package webhook

import (
	"code.justin.tv/common/golibs/statsd"
	"code.justin.tv/dta/skadi/pkg/config"
	"code.justin.tv/dta/skadi/pkg/info"
	"code.justin.tv/release/jenkins-api"
	"fmt"
	"github.com/google/go-github/github"
	"github.com/gorilla/mux"
	consulapi "github.com/hashicorp/consul/api"
	"github.com/nlopes/slack"
	"net/url"
	"time"
)

type WebhookConfig struct {
	ConsulPrefix  string
	SlackClient   *slack.Client
	JenkinsClient *jenkins.Client
	GithubClient  *github.Client
	ConsulClient  *consulapi.Client
	StatsdClient  statsd.Stats
	DqConfig      *DeployQueueConfig
	DfConfig      *DeployFactoryConfig
	deployQueue   DeployQueue
	deployFactory DeployFactory
}

var (
	BaseURL *url.URL
)

const (
	mailDefaultName    = "Deploy Tool"
	mailDefaultAddress = "devtools@justin.tv"
)

func (wc *WebhookConfig) Start() error {

	var err error
	if wc.deployQueue, err = NewDeployQueue(wc.DqConfig); err != nil {
		return fmt.Errorf("Could not create a new deploy queue. %v", err)
	}

	if wc.deployFactory, err = NewDeployFactory(wc.DfConfig, wc); err != nil {
		return fmt.Errorf("Could not create a new deploy factory. %v", err)
	}
	info.PublishRoot("deploystatus", info.Func(wc.deployFactory.Stats))

	go func() {
		// Give the listener a chance to start:
		time.Sleep(3 * time.Second)
		// Give pending jobs a priority.
		wc.restartPendingJobs()
		// Then take jobs from the queue.
		go wc.queueRunner()
	}()
	return nil
}

// Register relevant handlers
func (wc *WebhookConfig) RegisterHandlers(r *mux.Router) {
	config.CreateHandler(r, "/v1/webhook", wc.webhookHandler, nil)
}
