package webhook

import (
	"testing"
	"code.justin.tv/dta/skadi/pkg/deployment"
)

func TestDeployFactory_GetDeployer(t *testing.T) {
	const (
		targetId1 string = "dta/test/staging"
		targetId2 string = "dta/test/production"
	)

	wc := &WebhookConfig{}
	f := &DeployFactoryImpl{
		deployers: make(map[string]deployment.Deployer),
		max: 10,
		stallsec: 30,
		wc: wc,
	}
	wc.deployFactory = f

	// Check size
	if 0 != f.GetNumberOfActiveDeployers() {
		t.Error("Number of active deployers should be 0")
	}

	// Test serial deployment onto same target
	d1 := f.GetDeployer(targetId1)
	d2 := f.GetDeployer(targetId1)  // should fail
	d3 := f.GetDeployer(targetId2)
	f.ReturnDeployer(targetId1)
	d4 := f.GetDeployer(targetId1)
	if ! (d1 != nil && d2 == nil && d3 != nil && d4 != nil) {
		t.Error("Error on same target deploy serialization test")
	}

	// Check size again
	if 2 != f.GetNumberOfActiveDeployers() {
		t.Error("Number of active deployers should be 2")
	}
}
