package webhook

import (
	"code.justin.tv/dta/skadi/pkg/info"
	"fmt"
	log "github.com/Sirupsen/logrus"
	"net/http"
)

const (
	okJSON = `{"StatusCode":200,"StatusMessage":"Success"}`
)

var (
	whinfo = info.NewInfo("webhook")
)

func (wc *WebhookConfig) webhookHandler(w http.ResponseWriter, r *http.Request) {
	eventType := r.Header.Get("X-Github-Event")

	log.Printf("Received github webhook. Event: %q", eventType)
	whinfo.IncreaseCounter(eventType)
	var err error
	if eventType == "deployment" {
		err = wc.queueDeployment(r)
	} else if eventType == "deployment_status" {
		err = wc.handleDeploymentStatus(r)
	} else if eventType == "status" {
		err = wc.handleCommitStatus(r)
	} else if eventType == "push" {
		err = wc.handlePushStatus(r)
	} else {
		whinfo.IncreaseCounter("UnknownEvent")
		log.Printf("Unknown request: %#v", eventType)
	}

	if err != nil {
		log.Printf("webhook failed on %v - %v", eventType, err)
		whinfo.IncreaseCounter("Error")
		whinfo.SetProperty("LastError", err.Error())

		w.WriteHeader(http.StatusInternalServerError)
		fmt.Fprintln(w, err.Error())
		return
	}

	w.WriteHeader(http.StatusOK)
	fmt.Fprintln(w, okJSON)
}
