job {
  name 'dta-skadi'
  using 'TEMPLATE-autobuild'
  scm {
    git {
      remote {
        github 'dta/skadi', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
    }
  }
  triggers {
    scm('')
  }
  steps {
    shell 'rm -rf .manta/'
    shell 'manta -v'
    saveDeployArtifact 'dta/skadi', '.manta/'
    saveChasquiArtifact 'skadi', '.manta/', 'deployment-artifacts-twitch-core-services', '043714768218'
  }
}

job {
  name 'dta-skadi-deploy'
  using 'TEMPLATE-deploy-aws'
  steps {
    shell 'courier deploy --repo dta/skadi --dir /opt/twitch/skadi'
  }
}

job {
  name 'dta-skadi-deploy-chasqui'
  using 'TEMPLATE-deploy-aws'
  steps {
      deployChasquiArtifact 'skadi', '\$ENVIRONMENT', 'deployment-artifacts-twitch-core-services'
  }
}
