package appconfig

import (
	"runtime/debug"
	"testing"
)

func assert(t *testing.T, cond bool) {
	if !(cond) {
		debug.PrintStack()
		t.Fail()
	}
}

func TestBasic(t *testing.T) {
	c := Get()
	assert(t, c.Environment == "development")
}

var count int

func TestCallback(t *testing.T) {
	resetCallback()
	count = 0
	RegisterCallback(MyCallback1)
	RegisterCallback(MyCallback2)
	assert(t, count == 11)
}

func TestNotify(t *testing.T) {
	resetCallback()
	count = 0
	RegisterCallback(MyCallback1)
	RegisterCallback(MyCallback2)
	assert(t, count == 11)
	notifyCallbacks()
	assert(t, count == 22)
}

func TestToCamelCase(t *testing.T) {
	assert(t, "ConsulDatacenters" == toCamelCase("consul-datacenters"))
	assert(t, "ConsulMasterDatacenters" == toCamelCase("consul-master-datacenters"))
}

func MyCallback1(c *AppConfig) {
	count++
}

func MyCallback2(c *AppConfig) {
	count += 10
}
