package appconfig

type CallbackType func(*AppConfig)

type AppConfig struct {
	EnablePprof             bool   `forerunner:"enable-pprof" description:"Enable Pprof profiler"`
	SlackAPIToken           string `forerunner:"slack-api-token,secret" description:"API Token for talking to slack"`
	JenkinsHost             string `description:"Hostname for jenkins master"`
	JenkinsUser             string `description:"User for talking to jenkins api"`
	JenkinsAPIToken         string `forerunner:"jenkins-api-token,secret" description:"Token for talking to jenkins api"`
	GithubAPIToken          string `forerunner:"github-api-token,secret" description:"Token for talking to github api"`
	GithubHost              string `description:"Host for github api"`
	InsecureGithub          bool   `description:"Disable checking of a valid SSL cert for Github"`
	ConsulHost              string `description:"Hostname for consul's endpoint"`
	ConsulPrefix            string `description:"Prefix for consul data storage"`
	ConsulMasterDatacenters string `forerunner:"consul-master-datacenters" description:"Master datacenters for deployed-version update. Names to be comma separated"`
	ConsulDatacenters       string `forerunner:"consul-datacenters" description:"Default datacenters to search hosts. Names to be comma separated"`
	PgConnInfo              string `description:"Connection string for postgres"`
	Port                    int    `description:"Port to bind to for HTTP API"`
	StatsdHost              string `description:"Host to send statsd data to"`
	StatsdPort              int    `description:"Port to send statsd data to"`
	DeployStatsdPrefix      string `description:"Prefix for statsd deploy marks"`
	MetricStatsdPrefix      string `description:"Prefix for skadi metrics stats"`
	GithubClientID          string `forerunner:",secret" description:"Client ID for Github Application"`
	GithubClientSecret      string `forerunner:",secret" description:"Secret for Github Application"`
	GithubAuthURL           string `description:"Github URL to trigger oauth authentication"`
	GithubTokenURL          string `description:"Github URL to exchange access code for oauth token"`
	RollbarToken            string `forerunner:",secret" description:"Token for talking to rollbar"`
	Environment             string `description:"Environment skadi is running in"`
	APIBaseURL              string `forerunner:"api-base-url" description:"Base URL for API"`
	WebhookURL              string `forerunner:"webhook-url" description:"URL to register webhooks at"`
	LogLevel                string `forerunner:"loglevel" description:"The log level for logrus"`
	// DeployFactory related configurations
	MaxConcurrentDeployers int    `forerunner:"max-concurrent-deployers" description:"Maximum number of concurrent deploy jobs"`
	QueueURL               string `forerunner:"queue-url" description:"AWS SQS url of the deploy queue"`
	QueueRegion            string `forerunner:"queue-region" description:"AWS region code of the AWS SQS"`
	EnableQueueLog         bool   `forerunner:"enable-queue-log" description:"Enable queue activity log"`
	QueueLogPath           string `forerunner:"queue-log-path" description:"File path for queue activity log"`
	QueueRetryIntervalMin  int    `forerunner:"queue-retry-interval-min" description:"Minimum interval for queue retry in Millisecond"`
	QueueRetryIntervalMax  int    `forerunner:"queue-retry-interval-max" description:"Maximum interval for queue retry in Millisecond"`
	QueueRetryRuntime      int    `forerunner:"query-runtime" description:"Maximum retry runtime in Millisecond"`
	ConsiderStallSecs      int    `forerunner:"consider-stall-secs" description:"Consider as stalled if deploy runs longer than this seconds"`
	// RTEvent
	EnableRteventReceiver bool   `forerunner:"enable-rtevent-receiver" description:"Enable rtevent receiver"`
	RteventLogPath        string `forerunner:"rtevent-log-path" description:"File path for rtevent activity log"`
	// Behavior Control
	InstallGitWebhook          bool   `forerunner:"install-git-webhook" description:"Install callback webhook automatically on Git"`
	InstallGitWebhookSkipUsers string `forerunner:"install-git-webhook-skip-users" description:"Comma separated list of users that needs to skip hook check"`
	// Motd
	MotdRepo  string `forerunner:"motd-repo" description:"Name of GitHub repository where MOTD files are stored"`
	HttpsOnly bool   `forerunner:"https-only" description:"Redirect requests with plain http to secure https"`
	// Email
	SESRegion   string `forerunner:"ses-region" description:"AWS SES region code"`
	EmailSender string `forerunner:"email-sender" description:"Notification email sender address"`
}
