package build

import (
	"encoding/json"
	"net/http"

	"code.justin.tv/dta/skadi/pkg/config"
	"code.justin.tv/dta/skadi/pkg/repo"
	"github.com/gorilla/mux"
)

func RegisterHandlers(r *mux.Router) {
	config.CreateHandler(r, "/v1/build",
		getBuildHandler,
		&config.RouteOptions{AddCORS: true},
	).Methods("GET")
}

func getBuildHandler(w http.ResponseWriter, r *http.Request) {
	ctx := config.GetContext(w, r)
	repository := &repo.Repository{Owner: r.FormValue("owner"), Name: r.FormValue("name")}

	githubClient, err := config.GithubClient(ctx, false)
	if err != nil {
		config.JSONError(w, http.StatusInternalServerError, "issue fetching github client", err)
		return
	}

	jenkinsClient, err := config.JenkinsClient(ctx)
	if err != nil {
		config.JSONError(w, http.StatusInternalServerError, "issue fetching jenkins client", err)
		return
	}

	build, err := GetBuild(githubClient, jenkinsClient, repository, r.FormValue("sha"))
	if err != nil {
		config.JSONError(w, http.StatusInternalServerError, "error fetching build", err)
		return
	}
	json.NewEncoder(w).Encode(build)
}
