package build

import (
	"testing"

	"code.justin.tv/dta/skadi/internal/testhelper"
	"github.com/gorilla/mux"
)

// TestCORS ensures that the CORS handler works for various routes.
func TestCORS(t *testing.T) {
	router := mux.NewRouter()
	RegisterHandlers(router)
	testhelper.CORSTester(t, router, "/v1/build")
}

func TestParseTargetUrl(t *testing.T) {
	url := "http://jenkins-og.xarth.tv/job/release-skadi/88/"
	job, buildNum, err := ParseTargetUrl(url)
	if err != nil {
		t.Fatal(err)
	}
	if job != "release-skadi" || buildNum != 88 {
		t.Errorf("jenkins url not parsed correctly. job: %v id: %v", job, buildNum)
	}
}

func TestParseLongTargetUrl(t *testing.T) {
	url := "https://jenkins-og.xarth.tv/job/release-skadi-pipeline/job/master/99/"
	job, buildNum, err := ParseTargetUrl(url)
	if err != nil {
		t.Fatal(err)
	}
	if job != "release-skadi-pipeline/job/master" || buildNum != 99 {
		t.Errorf("jenkins url not parsed correctly. job: %v id: %v", job, buildNum)
	}
}
