package config

import (
	"fmt"
	"net/http"

	"code.justin.tv/common/chitin"
	"code.justin.tv/dta/skadi/pkg/helpers"
	"github.com/google/go-github/github"
	"golang.org/x/net/context"
)

var GithubDefaultToken string
var InsecureGithub bool
var GithubHost = "https://git.xarth.tv/api/v3/"

func GithubClient(ctx context.Context, allowDefault bool) (*github.Client, error) {
	token := (ctx.Value("GithubAccessToken")).(string)

	if !allowDefault && token == "" {
		return nil, fmt.Errorf("GithubAccessToken header was empty")
	}

	if token == "" {
		token = GithubDefaultToken
	}

	if token == "" {
		return nil, fmt.Errorf("no github token found!")
	}

	client, err := helpers.ConfigureGithubClient(GithubHost, token, ctx, InsecureGithub)
	if err != nil {
		return nil, err
	}

	return client, nil
}

// AuthenticateGithub is a helper function that checks if you are authenticated
// via github and returns a 403 if you aren't.
func AuthenticateGithub(f http.HandlerFunc) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		ctx := chitin.Context(w, r)

		client, err := GithubClient(ctx, false)
		if err != nil {
			JSONError(w, http.StatusForbidden, "unable to authenticate", err)
			return
		}

		_, _, err = client.Users.Get(context.TODO(), "")
		if err != nil {
			JSONError(w, http.StatusForbidden, "unable to authenticate", err)
			return
		}

		f(w, r)
	}
}
