package config

import (
	"code.justin.tv/common/chitin"
	"code.justin.tv/release/jenkins-api"
	"golang.org/x/net/context"
)

var JenkinsDefaultClient *jenkins.Client

func JenkinsClient(ctx context.Context) (*jenkins.Client, error) {
	client := jenkins.NewClient("", chitin.Client(ctx))
	client.BaseURL = JenkinsDefaultClient.BaseURL
	client.SetAuth(JenkinsDefaultClient.Auth.User, JenkinsDefaultClient.Auth.Password)
	return client, nil
}
