package deployment

import (
	"testing"

	"runtime/debug"

	"code.justin.tv/dta/skadi/internal/testhelper"
	"github.com/gorilla/mux"
)

func assert(t *testing.T, cond bool) {
	if !(cond) {
		debug.PrintStack()
		t.Fail()
	}
}

// TestCORS ensures that the CORS handler works for various routes.
func TestCORS(t *testing.T) {
	router := mux.NewRouter()
	RegisterHandlers(router, "0.0.0.0", nil, nil)
	testhelper.CORSTester(t, router, "/v1/deployments", "/v1/deployments/123/status")
}

func Test(t *testing.T) {
	SetRuntimeEnvironmentInfo("prod", true)
	assert(t, statsNamePrefix == StatsNamePrefix)
	SetRuntimeEnvironmentInfo("staging", false)
	assert(t, statsNamePrefix == StatsNamePrefix+"_staging")
}
