package deployment

import (
	"code.justin.tv/dta/skadi/pkg/repo"
	"fmt"
	log "github.com/Sirupsen/logrus"
	"github.com/google/go-github/github"
	consulapi "github.com/hashicorp/consul/api"
	"time"
)

const (
	DEFAULT_BRANCH                  = "master"
	AUTO_DEPLOY_FETCH_INTERVAL_SEC  = 60
)

var (
  consul *consulapi.Client
  ghe *github.Client
  repoStruct *repo.Repository

)
type AutoDeploy struct {
	ID          int        `json:"id" db:"id"`
	Owner       *string    `json:"owner" db:"owner"`
	Repo        *string    `json:"repo" db:"repository"`
	Environment *string    `json:"environment" db:"environment"`
	Reason      *string    `json:"reason" db:"reason"`
	AutoDeploy  bool       `json:"autodeploy"`
	EndDate     *string    `json:"enddate" db:"enddate"`
	Ref         *string
}

type dataBuffer struct {
	Owner         *string
	Repo          *string
	Ref           *string
	Branch        string
	Environment   *string
	Description   *string
	CodeReviewURL string
	Severity      string
	TriggerSmoca  string
	Hosts         string
	Link          *int64
}

func AutoDeployRunner(consulClient *consulapi.Client, githubClient *github.Client) {
	consul = consulClient
	ghe = githubClient
	AutoDeployRun()
}

func AutoDeployRun () {
	go func() {
		for {
			if err := processFreezeDeploy(); err != nil {
				log.Errorln("Unable to fetch freeze end times, db issue")
			}
			time.Sleep(AUTO_DEPLOY_FETCH_INTERVAL_SEC * time.Second)

		}
	}() }

func sendDeployment(id int, data dataBuffer) {
	gheDeployment, err := CreateGithubDeployment(ghe, repoStruct, data.Ref, data.Environment, data.Description, data.CodeReviewURL, data.Severity, data.TriggerSmoca, consul)
	if err != nil {
		log.Errorf("Error creating Github Deployment for Autodeploy: %v", err)
	} else {
		deployment, err := CreateDeployment(db, data.Branch, repoStruct, data.Owner, &data.Hosts, data.Link, gheDeployment)
		if err != nil {
			log.Errorf("Error creating deployment for Autodeploy: %v", err)
		}
		log.Infof("Autodeploy: %v", deployment)
		dberr := db.AutoDeploySent(id)
		if dberr != nil {
			log.Errorf("Database error writing to freezeschedules: %v", dberr)
		}
	}
}

func processFreezeDeploy() error {
	list, err := db.AutoDeployList()
	if err != nil {
		log.Errorf("Nothing to autodeploy: %v", err)
		return err
	}

	for _, v := range *list {
		data := dataBuffer{}
		description := fmt.Sprintf("[Autodeploy] %v", *v.Reason)
		repoStruct = &repo.Repository{Owner: *v.Owner, Name: *v.Repo}
		link := int64(0)

		data.Owner = v.Owner
		data.Repo = v.Repo
		data.Branch = DEFAULT_BRANCH
		data.Environment = v.Environment
		data.Description = &description
		data.CodeReviewURL = ""
		data.Severity = ""
		data.TriggerSmoca = "false"
		data.Hosts = ""
		data.Link = &link

		sha, err := db.GetLastMasterDeploySha(*v.Owner, *v.Repo, data.Branch)
		data.Ref = &sha
			if err != nil {
				log.Errorf("No sha from DB for %v can't deploy:, %v", *v.Repo, err)
			} else {
				sendDeployment(v.ID, data)
			}
		}
	return nil
}
