package deployment

import (
	"fmt"
)

func Example_joinAndSplitHosts() {
	fmt.Println(joinAndSplitHosts([]string{"1", "22", "333", "4444", "55555", "666666", "7777777"}, 1))
	fmt.Println(joinAndSplitHosts([]string{"1", "22", "333", "4444", "55555", "666666", "7777777"}, 4))
	fmt.Println(joinAndSplitHosts([]string{"1", "22", "333", "4444", "55555", "666666", "7777777"}, 8))
	fmt.Println(joinAndSplitHosts([]string{"1", "22", "333", "4444", "55555", "666666", "7777777"}, 14))
	fmt.Println(joinAndSplitHosts([]string{"1", "22", "333", "4444", "55555", "666666", "7777777"}, 26))
	fmt.Println(joinAndSplitHosts([]string{"1", "22", "333", "4444", "55555", "666666", "7777777"}, 34))
	fmt.Println(joinAndSplitHosts(nil, 10))
	fmt.Println(joinAndSplitHosts([]string{}, 10))
	fmt.Println(joinAndSplitHosts([]string{""}, 10))
	fmt.Println(joinAndSplitHosts([]string{"longword"}, 1))
	fmt.Println(joinAndSplitHosts([]string{"short1", "longword", "s2", "s3"}, 5))
	// Output:
	// 1,22,333,4444,55555,666666,7777777 [1 22 333 4444 55555 666666 7777777]
	// 1,22,333,4444,55555,666666,7777777 [1,22 333 4444 55555 666666 7777777]
	// 1,22,333,4444,55555,666666,7777777 [1,22,333 4444 55555 666666 7777777]
	// 1,22,333,4444,55555,666666,7777777 [1,22,333,4444 55555,666666 7777777]
	// 1,22,333,4444,55555,666666,7777777 [1,22,333,4444,55555,666666 7777777]
	// 1,22,333,4444,55555,666666,7777777 [1,22,333,4444,55555,666666,7777777]
	//  []
	//  []
	//  []
	// longword [longword]
	// short1,longword,s2,s3 [short1 longword s2,s3]
}
