package deploystatus

import (
	"code.justin.tv/dta/skadi/pkg/config"
	"github.com/gorilla/mux"
	consulapi "github.com/hashicorp/consul/api"
	"github.com/jmoiron/sqlx"
)

var (
	db *DB
)

func RegisterHandlers(r *mux.Router, dbInstance *sqlx.DB, cClient *consulapi.Client, consulDatacenters *string) {
	db = NewDB(dbInstance)
	launchConsulCacherThread(cClient, consulDatacenters)

	config.CreateHandler(r, "/v1/deployments/{deployid:[0-9]+}/deploystatus",
		DeployStatusPerDeployHandler,
		&config.RouteOptions{AddCORS: true},
	).Methods("GET")

	config.CreateHandler(r, "/v1/deploystatus/{owner:[A-Za-z0-9\\-_]+}/{repo:[A-Za-z0-9\\-_]+}/{env:[A-Za-z0-9\\-_]+}",
		DeployStatusPerServiceHandler,
		&config.RouteOptions{AddCORS: true},
	).Methods("GET")

	config.CreateHandler(r, "/v1/deploystatus/update/{status:[a-z]+}/{owner:[A-Za-z0-9\\-_]+}/{repo:[A-Za-z0-9\\-_]+}/{env:[A-Za-z0-9\\-_]+}/{ip:[0-9.]+}",
		UpdateHostVersionInfoHandler,
		&config.RouteOptions{AddCORS: true},
	).Methods("GET")

	config.CreateHandler(r, "/v1/deploystatus/host/{name:[A-Za-z0-9\\-_.]+}",
		DeployStatusPerHostHandler,
		&config.RouteOptions{AddCORS: true},
	).Methods("GET")
}
