package deploystatus

import (
	"encoding/json"
	"fmt"
	"net/http"

	"code.justin.tv/dta/skadi/pkg/config"
	"github.com/gorilla/mux"
	"net"
)

func DeployStatusPerHostHandler(w http.ResponseWriter, r *http.Request) {
	name := mux.Vars(r)["name"]

	// by the router config, it's guranteed that they have values but let just double check
	if name == "" {
		config.JSONError(w, http.StatusBadRequest, "", fmt.Errorf("Invalid arguments"))
		return
	}

	// Check if it's hostname or ip address
	var h *HostInfo
	if net.ParseIP(name) == nil {
		h = GetHostInfoByHostname(name)
	} else {
		h = GetHostInfoByIP(name)
	}
	if h == nil {
		config.JSONError(w, http.StatusNotFound, "", fmt.Errorf("No such host found: %s", name))
		return
	}

	services, err := db.GetHostServices(h.IPAddr)
	if err != nil {
		config.JSONError(w, http.StatusInternalServerError, "", fmt.Errorf("%v", err))
		return
	}

	s := &HostServiceStatus{
		IpAddr:     h.IPAddr,
		Hostname:   h.FQDN,
		Datacenter: h.Datacenter,
		Health:     statusStr(h.Alive),
		Services:   services,
	}

	json.NewEncoder(w).Encode(s)
}
