package deploystatus

import (
	"code.justin.tv/common/chitin"
	twapi "code.justin.tv/release/twitch-consul-api"
	"fmt"
	"golang.org/x/net/context"
)

//
// These are actually tests. Go matches the output of the logic with "Output:" sections comments.
// If output doesn't match, it'll report an error. It's just a lot easier doing these tests in this way.
//

const (
	consulEndpoint = "api.us-west-2.prod.consul.live-video.a2z.com"
)

func Example_launchConsulCacherThread() {
	cClient, _ := twapi.NewClient(consulEndpoint, chitin.Client(context.Background()))
	datacenters := "wanmaster"
	launchConsulCacherThread(cClient, &datacenters)
	for ip, data := range GetIpHostMap() {
		if ip == "" || data.Name == "" || data.FQDN == "" || data.IPAddr == "" || data.Datacenter != "wanmaster" {
			fmt.Println("fail")
		}
	}
	if len(GetIpHostMap()) > 0 {
		fmt.Println("pass")
	}

	// Output:
	// pass
}
