package deploystatus

import (
	"time"
)

const (
	HostStatusAlive = "alive"
	HostStatusDown  = "down"
	HostStatusGone  = "gone"
)

// Used by per-deployid API
type DeployStatus struct {
	Service     string               `json:"service"`
	Environment string               `json:"environment"`
	Deployed    *Artifact            `json:"deployed"`
	HostStat    *HostStat            `json:"host-stat"`
	Hosts       []*HostVersionStatus `json:"hosts"`
}

type HostStat struct {
	TotalHosts    int `json:"total-hosts"`
	HostsMatch    int `json:"hosts-match"`    // Number of hosts with matching version
	HostsMismatch int `json:"hosts-mismatch"` // Number of hosts in failure, progress or unknown state

	// Detail breakdown
	NumSuccess  int `json:"num-success"`
	NumFailure  int `json:"num-failure"`
	NumProgress int `json:"num-progress"`
	NumUnknown  int `json:"num-unknown"`
}

type HostServices struct {
	Service     string    `json:"service"`
	Environment string    `json:"environment"`
	Sha         string    `json:"sha"`
	Updated     time.Time `json:"updated"`
}

//
// Common
//
type Artifact struct {
	SHA    string `json:"sha"`
	Branch string `json:"branch"`
}

type HostVersionStatus struct {
	IpAddr     string `json:"ipaddr"`
	Hostname   string `json:"hostname"`
	Datacenter string `json:"datacenter,omitempty"`
	Health     string `json:"health,omitempty"`

	Sha     string    `json:"sha,omitempty"`
	Phase   string    `json:"phase,omitempty"`
	Status  string    `json:"status,omitempty"`
	Desc    string    `json:"desc,omitempty"`
	Updated time.Time `json:"updated,omitempty"`
}

type HostServiceStatus struct {
	IpAddr     string `json:"ipaddr"`
	Hostname   string `json:"hostname"`
	Datacenter string `json:"datacenter,omitempty"`
	Health     string `json:"health,omitempty"`

	Services []*HostServices `json:"services"`
}
