package email

import (
	"github.com/stretchr/testify/assert"
	"testing"
)

func TestFillDefaults(t *testing.T) {
	Init("us-west-2", "aaa@aaa.com", "UTF-8")

	e := &Email{}
	assert.Equal(t, "", e.Sender)
	e.fillDefaults() // should set with given default
	assert.Equal(t, "aaa@aaa.com", e.Sender)
	assert.Equal(t, "UTF-8", e.CharSet)

	e = &Email{
		Sender:  "bbb@bbb.com",
		CharSet: "ASCII",
	}
	e.fillDefaults() // shouldn't change the value
	assert.Equal(t, "bbb@bbb.com", e.Sender)
	assert.Equal(t, "ASCII", e.CharSet)
}
