package environment

type Environment struct {
	Name     string                     `json:"name" db:"environment"`
	Services map[string]ServiceArtifact `json:"services,omitempty"`
}

type Service struct {
	Environment    string
	Owner          string
	Repository     string
	DeployedSHA    *string
	DeployedBranch *string
	RollbackSHA    *string
	RollbackBranch *string
}
type ServiceArtifact struct {
	Deployed Artifact `json:"deployed"`
	Rollback Artifact `json:"rollback"`
}

type Artifact struct {
	SHA    string `json:"sha"`
	Branch string `json:"branch"`
}
