package freeze

import (
	"database/sql"

	log "github.com/Sirupsen/logrus"
	"github.com/jmoiron/sqlx"
)

type ScheduleDB struct {
	db *sqlx.DB
}

func notFoundError(err error) bool {
	return err == sql.ErrNoRows
}

func (db *ScheduleDB) InsertScheduleFreeze(f *Freeze) error {
	_, err := db.db.NamedExec(`INSERT INTO freezeschedules (owner, repository, creator, reason, environment, startdate, enddate, expression, expressiontype, autodeploy) 
	VALUES (:owner, :repository, :creator, :reason, :environment, :startdate, :enddate, :expression, :expressiontype, :autodeploy)`,
		f)
	if err != nil {
		log.Error("failed to insert freeze:", err)
	}
	f.Type = "schedule"
	f.Freeze()

	return err
}

func (db *ScheduleDB) GetScheduleFreeze(id int) (*Freeze, error) {
	var freeze Freeze

	if err := db.db.Get(&freeze, `SELECT id,owner,repository,creator,environment,reason,createdat,deleted,deletedby,deletedat,startdate,enddate,expression,expressiontype,'schedule' as type
		FROM freezeschedules
		WHERE id=$1`, id); err != nil {
		if !notFoundError(err) {
			log.Error("failed to get freeze:", err)
		}
		return nil, err
	}

	freeze.Localize()
	freeze.Freeze()

	return &freeze, nil
}

func (db *ScheduleDB) ListScheduleFreezesByOR(owner, repo string) (*[]Freeze, error) {
	var freezes []Freeze

	if err := db.db.Select(&freezes,
		`SELECT id,owner,repository,creator,environment,reason,createdat,startdate,enddate,expression,expressiontype,'schedule' as type
		FROM freezeschedules
		WHERE owner=$1 AND repository=$2 AND deleted=false`, owner, repo); err != nil {
		log.Error("failed to list freezes:", err)
		return nil, err
	}

	for i, freeze := range freezes {
		freeze.Localize()
		freeze.Freeze()
		freezes[i] = freeze
	}

	return &freezes, nil
}

func (db *ScheduleDB) ListFrozenScheduleFreezesByOR(owner, repo string) (*[]Freeze, error) {
	var freezes []Freeze

	if err := db.db.Select(&freezes,
		`SELECT id,owner,repository,creator,environment,reason,createdat,startdate,enddate,expression,expressiontype,'schedule' as type
		FROM freezeschedules
		WHERE owner=$1 AND repository=$2 AND deleted=false`, owner, repo); err != nil {
		log.Error("failed to list freezes:", err)
		return nil, err
	}

	var frozen []Freeze

	for _, freeze := range freezes {
		freeze.Localize()
		freeze.Freeze()
		if freeze.IsFrozen {
			frozen = append(frozen, freeze)
		}
	}

	return &frozen, nil
}

func (db *ScheduleDB) DeleteScheduleFreeze(id int, deletedBy string) error {
	_, err := db.db.Exec("UPDATE freezeschedules SET deleted=true, deletedby=$1, deletedat=CURRENT_TIMESTAMP WHERE id=$2", deletedBy, id)
	if err != nil {
		log.Error("failed to delete freezes:", err)
	}
	return err
}
