package freeze

import (
	"encoding/json"
	"time"
)

var (
	symbolsByWeekday = map[time.Weekday]string{
		time.Sunday:    "Su",
		time.Monday:    "M",
		time.Tuesday:   "Tu",
		time.Wednesday: "W",
		time.Thursday:  "Th",
		time.Friday:    "F",
		time.Saturday:  "Sa",
	}
)

// WeeklySchedule is an expression that contains days a schedule should be frozen.
type WeeklySchedule struct {
	Days map[string]bool `json:"days"`
}

func NewWeeklySchedule(b []byte) (*WeeklySchedule, error) {
	var weekly WeeklySchedule
	err := json.Unmarshal(b, &weekly)
	return &weekly, err
}

func (s WeeklySchedule) FrozenAt(now time.Time) (bool, error) {
	day := now.Weekday()
	symbol := symbolsByWeekday[day]

	return s.Days[symbol], nil
}
