package githubcache

import (
	"code.justin.tv/dta/skadi/pkg/helpers"
	"fmt"
	"golang.org/x/net/context"
)

//
// These are actually tests. Go matches the output of the logic with "Output:" sections comments.
// If output doesn't match, it'll report an error. It's just a lot easier doing these tests in this way.
//

const (
	GithubHost  = "http://git.dev-mcordell.dev.us-west2.justin.tv/api/v3/"
	GithubToken = "ed1bbdb5a88525939b022f9d994899276e8d1d58"
)

func Example_init() {
	githubClient, err := helpers.ConfigureGithubClient(GithubHost, GithubToken, context.Background(), true)
	if err != nil {
		fmt.Println(err)
		return
	}
	Init(githubClient)

	// Output:
}

func Example_getRepositoryInfo() {
	r := GetRepositoryInfo("dta", "skadi")
	if r != nil {
		fmt.Println(*r.Name)
	}

	r = GetRepositoryInfo("dta", "skadi_nonexist")
	if r != nil {
		fmt.Println(*r.Name)
	}

	// Output:
	// skadi
}

func Example_getDefaultBranch() {
	fmt.Println(GetDefaultBranch("dta", "skadi"))

	// Output:
	// master
}
