package helpers

import (
	"bytes"
	"fmt"
	"net"
	"regexp"
	"sort"
	"strings"
)

// Btoi will convert a bool to an int.
// true => 1
// false => 0
func Btoi(v bool) int {
	if v {
		return 1
	}

	return 0
}

func GetLocalIP() (string, error) {
	addrs, err := net.InterfaceAddrs()
	if err != nil {
		return "", err
	}
	for _, addr := range addrs {
		if ipnet, ok := addr.(*net.IPNet); ok && !ipnet.IP.IsLoopback() {
			if ipnet.IP.To4() != nil {
				return ipnet.IP.String(), nil
			}
		}
	}
	return "", fmt.Errorf("Failed to find local IP address.")
}

func UniqueStrings(list []string) []string {
	set := map[string]bool{}

	for _, item := range list {
		set[item] = true
	}

	res := []string{}
	for item, _ := range set {
		res = append(res, []string{item}...)
	}

	return res
}

func UniqueStringsSorted(list []string) []string {
	l := UniqueStrings(list)
	sort.Strings(l)
	return l
}

func ContainString(list []string, str string) bool {
	for _, s := range list {
		if s == str {
			return true
		}
	}
	return false
}

func SerializeStringChan(c *chan string) []string {
	serialized := []string{}
	for s := range *c {
		serialized = append(serialized, s)
	}
	return serialized
}

func SplitStringNoEmpty(str string, split string) []string {
	strs := []string{}
	for _, v := range strings.Split(str, split) {
		if v2 := strings.TrimSpace(v); v2 != "" {
			strs = append(strs, v2)
		}
	}
	return strs
}

func SplitStringTrimmed(str string, split string) []string {
	strs := []string{}
	for _, v := range strings.Split(str, split) {
		strs = append(strs, strings.TrimSpace(v))
	}
	return strs
}

func JoinStringsNoEmpty(str []string, split string) string {
	var buffer bytes.Buffer
	for _, s := range str {
		s2 := strings.TrimSpace(s)
		if len(s2) == 0 {
			continue
		}
		if buffer.Len() > 0 {
			buffer.WriteString(split)
		}
		buffer.WriteString(s2)
	}
	return buffer.String()
}

func IsAlphaNumericNonEmptyString(str string) bool {
	s := strings.TrimSpace(str)
	if s == "" {
		return false
	}
	var isAlphaNumeric = regexp.MustCompile(`^[A-Za-z0-9]+$`).MatchString
	return isAlphaNumeric(s)
}

func IsEmptyStringp(str *string) bool {
	if str == nil || *str == "" || strings.TrimSpace(*str) == "" {
		return true
	}
	return false
}

func SQLCompliantString(str string) string {
	str = strings.Replace(str, "%", "\\%", -1)
	str = strings.Replace(str, "_", "\\_", -1)
	str = strings.Replace(str, "*", "%", -1)
	return str
}
