package helpers

import (
	"fmt"
)

//
// These are actually tests. Go matches the output of the logic with "Output:" sections comments.
// If output doesn't match, it'll report an error. It's just a lot easier doing these tests in this way.
//

type BtoiTestCase struct {
	in  bool
	out int
}

func ExampleBtoi() {
	for _, c := range []BtoiTestCase{
		{true, 1},
		{false, 0},
	} {
		res := Btoi(c.in)

		if res != c.out {
			fmt.Printf("Btoi(%v) = %d; want %d", c.in, res, c.out)
		}
	}
	// Output:
}

func ExampleUniqueStrings() {
	fmt.Println(UniqueStrings([]string{}))
	fmt.Println(sortStrings(UniqueStrings([]string{"a", "b"})))
	fmt.Println(sortStrings(UniqueStrings([]string{"a", "b", "a"})))
	// Output:
	// []
	// [a b]
	// [a b]
}

func ExampleUniqueStringsSorted() {
	fmt.Println(UniqueStringsSorted([]string{}))
	fmt.Println(UniqueStringsSorted([]string{"a", "b"}))
	fmt.Println(UniqueStringsSorted([]string{"a", "b", "a"}))
	// Output:
	// []
	// [a b]
	// [a b]
}

func ExampleContainString() {
	fmt.Println(ContainString([]string{}, ""))
	fmt.Println(ContainString([]string{""}, ""))
	fmt.Println(ContainString([]string{"", "a", "b"}, "a"))
	fmt.Println(ContainString([]string{"", "a", "b"}, "c"))
	// Output:
	// false
	// true
	// true
	// false
}

func ExampleSerializeStringChan() {
	c := make(chan string, 10)
	close(c)
	fmt.Println(SerializeStringChan(&c))

	c = make(chan string, 10)
	c <- "a"
	c <- "b"
	c <- "c"
	close(c)
	fmt.Println(SerializeStringChan(&c))
	// Output:
	// []
	// [a b c]
}

func ExampleSplitStringNoEmpty() {
	fmt.Println(SplitStringNoEmpty("", ""))
	fmt.Println(SplitStringNoEmpty("a", ","))
	fmt.Println(SplitStringNoEmpty(",a", ","))
	fmt.Println(SplitStringNoEmpty("a,", ","))
	fmt.Println(SplitStringNoEmpty("a,b", ","))
	fmt.Println(SplitStringNoEmpty("a, b , c", ","))
	// Output:
	// []
	// [a]
	// [a]
	// [a]
	// [a b]
	// [a b c]
}

func ExampleSplitStringTrimmed() {
	fmt.Println(SplitStringTrimmed("", ""))
	fmt.Println(SplitStringTrimmed("a", ","))
	fmt.Println(SplitStringTrimmed(",a", ","))
	fmt.Println(SplitStringTrimmed("a,", ","))
	fmt.Println(SplitStringTrimmed("a,b", ","))
	fmt.Println(SplitStringTrimmed("a, b , c", ","))
	// Output:
	// []
	// [a]
	// [ a]
	// [a ]
	// [a b]
	// [a b c]
}

func ExampleJoinStringsNoEmpty() {
	fmt.Println(JoinStringsNoEmpty([]string{}, ""))
	fmt.Println(JoinStringsNoEmpty([]string{"     "}, ","))
	fmt.Println(JoinStringsNoEmpty([]string{"a"}, ","))
	fmt.Println(JoinStringsNoEmpty([]string{" a "}, ","))
	fmt.Println(JoinStringsNoEmpty([]string{"a", " b    "}, ","))
	fmt.Println(JoinStringsNoEmpty([]string{"a", " b", "c "}, ","))
	// Output:
	//
	//
	// a
	// a
	// a,b
	// a,b,c
}

func ExampleSplitStringNoEmpty_combo() {
	fmt.Println(JoinStringsNoEmpty(UniqueStringsSorted(SplitStringNoEmpty("", ",")), ","))
	fmt.Println(JoinStringsNoEmpty(UniqueStringsSorted(SplitStringNoEmpty("a", ",")), ","))
	fmt.Println(JoinStringsNoEmpty(UniqueStringsSorted(SplitStringNoEmpty("b,a", ",")), ","))
	fmt.Println(JoinStringsNoEmpty(UniqueStringsSorted(SplitStringNoEmpty(",b,  c,a, b,", ",")), ","))
	// Output:
	//
	// a
	// a,b
	// a,b,c
}

func ExampleIsAlphaNumericNonEmptyString() {
	fmt.Println(IsAlphaNumericNonEmptyString(""))
	fmt.Println(IsAlphaNumericNonEmptyString(" "))
	fmt.Println(IsAlphaNumericNonEmptyString("a"))
	fmt.Println(IsAlphaNumericNonEmptyString("A"))
	fmt.Println(IsAlphaNumericNonEmptyString("1"))
	fmt.Println(IsAlphaNumericNonEmptyString("'"))
	// Output:
	// false
	// false
	// true
	// true
	// true
	// false
}

func ExampleIsEmptyStringp() {
	s := []string{"", " ", "a"}
	fmt.Println(IsEmptyStringp(nil))
	fmt.Println(IsEmptyStringp(&s[0]))
	fmt.Println(IsEmptyStringp(&s[1]))
	fmt.Println(IsEmptyStringp(&s[2]))
	// Output:
	// true
	// true
	// true
	// false
}

func ExampleSQLCompliantString() {
	fmt.Println(SQLCompliantString(""))
	fmt.Println(SQLCompliantString("abc123"))
	fmt.Println(SQLCompliantString("abc_123%"))
	fmt.Println(SQLCompliantString("abc*123"))
	// Output:
	//
	// abc123
	// abc\_123\%
	// abc%123
}
