// infoapi package is separated from info package to prevent import cycle.
package infoapi

import (
	"code.justin.tv/dta/skadi/pkg/config"
	"code.justin.tv/dta/skadi/pkg/info"
	"github.com/gorilla/mux"
)

// Register relevant handlers
func RegisterHandlers(r *mux.Router) {
	config.CreateHandler(r, "/info", info.ListHandler, nil)
	config.CreateHandler(r, "/info/all", info.AllHandler, nil)
	config.CreateHandler(r, "/info/{root}", info.DetailHandler, nil)
	config.CreateHandler(r, "/debug/vars", info.DebugHandler, nil)
}
