package motd

import (
	"code.justin.tv/dta/skadi/pkg/config"
	"encoding/json"
	log "github.com/Sirupsen/logrus"
	"github.com/google/go-github/github"
	"github.com/gorilla/mux"
	"net/http"
	"strings"
)

var (
	motd Motd
)

func RegisterHandlers(r *mux.Router, githubClient *github.Client, motdRepo string) {
	if err := motd.Init(githubClient, motdRepo); err != nil {
		log.Errorf("Failed to initialize MOTD - %v", err)
		return
	}
	motd.Run()

	config.CreateHandler(r, "/v1/motd/{format:[a-z.]+}",
		MotdGetHandler,
		&config.RouteOptions{AddCORS: true},
	).Methods("GET")
}

func MotdGetHandler(w http.ResponseWriter, r *http.Request) {
	contentType := "text/plain"
	contents := "Invalid format parameter. Must be one of [text, text.json, html, html.json]"

	format := mux.Vars(r)["format"]
	if format == "" || format == "text" || format == "text.json" {
		contents = motd.motdText
	} else if format == "html" || format == "html.json" {
		contentType = "text/html"
		contents = motd.motdHtml
	}

	if strings.Contains(format, ".json") {
		json.NewEncoder(w).Encode(struct {
			Contents string
		}{
			contents,
		})
		return
	}

	w.Header().Add("Content-Type", contentType)
	w.Write([]byte(contents))
}
