package oauth

import (
	"code.justin.tv/dta/skadi/pkg/config"
	"github.com/gorilla/mux"
	"golang.org/x/oauth2"
)

var (
	oauthConfig    *oauth2.Config
	InsecureGithub = false
)

func RegisterHandlers(r *mux.Router, OauthConfig *oauth2.Config) {
	oauthConfig = OauthConfig
	config.CreateHandler(r, "/authorize", handleAuthorize, nil)
	config.CreateHandler(r, "/github_oauth_callback", handleGithubOauth, nil)
	config.CreateHandler(r, "/config", handleConfig, nil)
}
