package repo

import (
	"encoding/json"
	log "github.com/Sirupsen/logrus"
	"net/http"
	"strings"

	"code.justin.tv/dta/skadi/pkg/config"
	"github.com/gorilla/mux"
)

func CompareCommits(w http.ResponseWriter, r *http.Request) {
	ctx := config.GetContext(w, r)

	vars := mux.Vars(r)
	owner := vars["owner"]
	repo := vars["repo"]
	commits := strings.Split(vars["commits"], "...")

	client, err := config.GithubClient(ctx, false)
	if err != nil {
		config.JSONError(w, 500, "error creating github client", err)
		return
	}

	compare, _, err := client.Repositories.CompareCommits(ctx, owner, repo, commits[0], commits[1])
	if err != nil {
		log.Printf("error comparing commits: %v", err)
		config.JSONError(w, 500, "error comparing commits", err)
		return
	}

	json.NewEncoder(w).Encode(compare)
}
