package repo

import (
	"fmt"

	"code.justin.tv/dta/skadi/pkg/config"
	"github.com/gorilla/mux"
)

type Repository struct {
	Owner string `json:"owner,omitempty"`
	Name  string `json:"name,omitempty"`
}

func (r *Repository) FullName() string {
	return fmt.Sprintf("%v/%v", r.Owner, r.Name)
}

func RegisterOldHandlers(r *mux.Router) {
	config.CreateHandler(r, "/v1/repos/{owner}/{repo}/compare/{commits}",
		CompareCommits,
		&config.RouteOptions{AddCORS: true},
	).Methods("GET")
}
