package rtevent_receiver

import (
	"code.justin.tv/dta/rtevent"
	"github.com/jmoiron/sqlx"
)

type DB struct {
	*sqlx.DB
}

func NewDB(dbInstance *sqlx.DB) *DB {
	return &DB{
		dbInstance,
	}
}

func (db *DB) UpdateHostVersion(event *rtevent.DeployEvent) error {
	owner, repo, err := parseAppStr(event.App)
	if err != nil {
		return err
	}
	result, err := db.Exec("UPDATE host_version set sha=$1, deployedat=$2 where owner=$3 AND repository=$4 AND environment=$5 AND ipaddr=$6",
		event.Sha, event.CreatedAt, owner, repo, event.Environment, event.IPAddr)
	if err != nil {
		return err
	}
	num, err := result.RowsAffected()
	if num == 0 && err == nil {
		_, err = db.Exec("INSERT INTO host_version (owner, repository, environment, ipaddr, sha, deployedat) VALUES ($1, $2, $3, $4, $5, $6)",
			owner, repo, event.Environment, event.IPAddr, event.Sha, event.CreatedAt)
	}
	return err
}

func (db *DB) UpdateSkadiDeployStatus(event *rtevent.DeployEvent) error {
	status := STATUS_FAILURE
	if event.Success {
		status = STATUS_SUCCESS
	}

	_, err := db.Exec("INSERT INTO deployment_deploystatus (deployment_id, ipaddr, hostname, sha, phase, status, detail, changedat) VALUES ($1, $2, $3, $4, $5, $6, $7, $8)",
		event.DeployID, event.IPAddr, event.Hostname, event.Sha, event.Phase, status, event.Desc, event.CreatedAt)
	if err != nil {
		return err
	}

	if event.Phase == "" || event.Phase == COURIER_PHASE_INSTALL_REMOTE {
		err = db.UpdateHostVersion(event)

	}
	return err
}
