package user

import (
	"encoding/json"
	"net/http"

	"code.justin.tv/dta/skadi/pkg/config"
	"github.com/google/go-github/github"
	"github.com/gorilla/mux"
)

type User struct {
	Login     *string `json:"login"`
	AvatarURL *string `json:"avatar_url"`
	HTMLURL   *string `json:"html_url"`
}

func RegisterHandlers(r *mux.Router) {
	config.CreateHandler(r, "/v1/user/repos",
		ListReposForUser,
		&config.RouteOptions{AddCORS: true},
	).Methods("GET")
	config.CreateHandler(r, "/v1/user",
		CurrentUser,
		&config.RouteOptions{AddCORS: true},
	).Methods("GET")
}

func NewUser(u *github.User) *User {
	if u == nil {
		return nil
	}

	return &User{
		Login:     u.Login,
		AvatarURL: u.AvatarURL,
		HTMLURL:   u.HTMLURL,
	}
}

func CurrentUser(w http.ResponseWriter, r *http.Request) {
	ctx := config.GetContext(w, r)
	client, err := config.GithubClient(ctx, true)

	if err != nil {
		config.JSONError(w, 500, "error creating github client", err)
		return
	}

	user, _, err := client.Users.Get(ctx, "")
	if err != nil {
		config.JSONError(w, 500, "error getting user", err)
		return
	}

	json.NewEncoder(w).Encode(user)
}
