###############
# build tools #
###############

apt-get update
apt-get install -y manta forerunner

# ensure time doesn't drift
apt-get install -y ntp

# go
GOVERSION=1.6.1
GOSHASUM=6d894da8b4ad3f7f6c295db0d73ccc3646bce630e1c43e662a0120681d47e988
GO15VENDOREXPERIMENT=0
wget --no-verbose https://storage.googleapis.com/golang/go${GOVERSION}.linux-amd64.tar.gz
echo "${GOSHASUM}  go${GOVERSION}.linux-amd64.tar.gz" | sha256sum --check
tar -C /usr/local -xzf go${GOVERSION}.linux-amd64.tar.gz

echo '
export PATH="/usr/local/go/bin:/go/bin/:$PATH"
export GOPATH="/go"
export ENVIRONMENT=staging
export APP=skadi
export APPDIR=/go/src/code.justin.tv/dta/skadi
' >> /home/vagrant/.profile

source /home/vagrant/.profile

apt-get -y install git mercurial

# In vmware we can't use chown -R because
# /go/src/git.xarth.tv/<project_name> is already mounted from the
# host system.
chown vagrant:vagrant /go/ /go/src/ /go/src/code.justin.tv/ /go/src/code.justin.tv/dta
sudo -u vagrant -i go get github.com/golang/lint/golint
sudo -u vagrant -i go get code.google.com/p/go.tools/cmd/goimports
sudo -u vagrant -i go get github.com/tools/godep
sudo -u vagrant -i go get github.com/smartystreets/goconvey

##################
# Setup Database #
##################

apt-get install -y postgresql-9.1

# Goose is used for postgres
sudo -u vagrant -i go get bitbucket.org/liamstask/goose/cmd/goose
# Create user:
sudo -u postgres /usr/lib/postgresql/9.1/bin/createuser vagrant -s
# Create database:
sudo -u postgres /usr/lib/postgresql/9.1/bin/createdb vagrant -E utf8

# Fix permissions
sed -i 's!host\s\+all\s\+all\s\+127.0.0.1/32\s\+md5!host all all 127.0.0.1/32 trust!' /etc/postgresql/9.1/main/pg_hba.conf
/etc/init.d/postgresql reload

echo To setup databases run 'forerunner exec goose up'
