import pytest
import requests

test_owner = "dta"
test_repo = "skadi"
test_env = "clean-production"
test_sha = "d5f55e2e1996385fb8d0337fe3ceb2030567218a"
test_branch = "master"
test_deployment_id = 368
test_creator = "gkim"
test_state = ""
test_previous_sha = "752c34a5f83dd3e3489984ed8e0c0da2bf14b010"
test_ref = "master"
test_description = "test"
test_code_review_url = "http://localhost/"
test_severity = "test"

test_artifact_download_owner = "release"
test_artifact_download_repo = "manta"
test_artifact_download_sha = "f9638380748bdd638c31db6d320a2ddc9d72b426"

@pytest.fixture
def base_url(request):
    return request.config.option.base_url

@pytest.fixture
def ghe_token(request):
    return request.config.option.ghe_token

def test_list_repos(base_url, record_xml_property):
    r = requests.get("{0}/v1/repos".format(base_url))
    j = r.json()
    record_xml_property("response", r.text)
    with pytest.raises(requests.HTTPError) as http_err:
    	r.raise_for_status()
	j = r.json()
    assert j['VerboseError'] == "Not implemented yet."

def test_get_deployed_artifact(base_url, ghe_token, record_xml_property):
    r = requests.get("{0}/v1/artifact/deployed".format(base_url),
        params={"owner": test_owner, "name": test_repo, "env": test_env},
        headers={"GithubAccessToken": ghe_token},
        cookies={"GithubAccessToken": ghe_token, "GithubScope": "repo,admin:org_hook"})
    record_xml_property("response", r.text)

    r.raise_for_status()
    j = r.json()
    assert j['artifact'] is not None

def test_get_artifact_compare(base_url, ghe_token, record_xml_property):
    r = requests.get("{0}/v1/artifact/compare".format(base_url),
        params={"owner": test_owner, "name": test_repo, "env": test_env, "ref": test_ref},
        headers={"GithubAccessToken": ghe_token},
        cookies={"GithubAccessToken": ghe_token, "GithubScope": "repo,admin:org_hook"})
    record_xml_property("response", r.text)

    r.raise_for_status()
    j = r.json()
    assert j['github_compare'] is not None

def test_get_artifacts_download(base_url, ghe_token, record_xml_property):
    r = requests.get("{0}/v1/artifacts/download".format(base_url),
        params={"owner": test_artifact_download_owner, "name": test_artifact_download_repo, "environment": test_env, "sha": test_artifact_download_sha},
        headers={"GithubAccessToken": ghe_token},
        cookies={"GithubAccessToken": ghe_token, "GithubScope": "repo,admin:org_hook"})
    r.raise_for_status()
    assert r.headers['content-disposition'].find("attachment;") == 0

def test_get_build(base_url, ghe_token, record_xml_property):
    print "This test requires updating commit status in github"
    print "run: curl http://<github host>/api/v3/repos/dta/skadi/statuses/{0} -H \"Authorization: token {1}\" -H \"content-type: application/json\" -d \"{{\\\"state\\\": \\\"success\\\", \\\"target_url\\\": \\\"http://jenkins-master-0.prod.us-west2.justin.tv/job/dta-skadi/729/\\\", \\\"description\\\": \\\"test\\\"}}\"".format(test_sha, ghe_token)
    r = requests.get("{0}/v1/build".format(base_url),
        params={"owner": test_owner, "name": test_repo, "sha": test_sha},
        headers={"GithubAccessToken": ghe_token},
        cookies={"GithubAccessToken": ghe_token, "GithubScope": "repo,admin:org_hook"})
    record_xml_property("response", r.text)
    r.raise_for_status()
    j = r.json()
    assert j['duration'] is not None

def test_get_candidate_previous(base_url, ghe_token, record_xml_property):
    r = requests.get("{0}/v1/candidate/previous".format(base_url),
        params={"owner": test_owner, "name": test_repo},
        headers={"GithubAccessToken": ghe_token},
        cookies={"GithubAccessToken": ghe_token, "GithubScope": "repo,admin:org_hook"})
    record_xml_property("response", r.text)

    r.raise_for_status()
    j = r.json()
    assert type(j) == list

@pytest.mark.skipif(pytest.config.option.skip_create, reason="--skip-create enabled")
def test_post_deployments(base_url, ghe_token, record_xml_property):
    r = requests.post("{0}/v1/deployments".format(base_url),
        data={"branch": test_branch, "ref": test_ref, "environment": test_env, "owner": test_owner, "repo": test_repo, "description": test_description, "codereviewurl": test_code_review_url, "severity": test_severity},
        headers={"GithubAccessToken": ghe_token},
        cookies={"GithubAccessToken": ghe_token, "GithubScope": "repo,admin:org_hook"})
    record_xml_property("response", r.text)

    r.raise_for_status()
    j = r.json()
    assert j['id'] is not None

def test_get_deployments_status(base_url, ghe_token, record_xml_property):
    r = requests.get("{0}/v1/deployments/{1}/status".format(base_url, test_deployment_id),
        headers={"GithubAccessToken": ghe_token},
        cookies={"GithubAccessToken": ghe_token, "GithubScope": "repo,admin:org_hook"})
    record_xml_property("response", r.text)

    r.raise_for_status()
    j = r.json()
    assert j['id'] is not None

def test_get_deployments(base_url, ghe_token, record_xml_property):
    r = requests.get("{0}/v1/deployments".format(base_url),
        params={"owner": test_owner, "repo": test_repo, "environment": test_env, "count": 1},
        headers={"GithubAccessToken": ghe_token},
        cookies={"GithubAccessToken": ghe_token, "GithubScope": "repo,admin:org_hook"})
    record_xml_property("response", r.text)

    r.raise_for_status()
    j = r.json()
    assert type(j) == list

def test_get_deployments_log(base_url, ghe_token, record_xml_property):
    r = requests.get("{0}/v1/deployments/{1}/log".format(base_url, test_deployment_id),
        headers={"GithubAccessToken": ghe_token},
        cookies={"GithubAccessToken": ghe_token, "GithubScope": "repo,admin:org_hook"})
    record_xml_property("response", r.text)

    r.raise_for_status()
    j = r.json()
    assert j['output'] is not None

def test_get_deployment(base_url, ghe_token, record_xml_property):
    r = requests.get("{0}/v1/deployment/{1}".format(base_url, test_deployment_id),
        headers={"GithubAccessToken": ghe_token},
        cookies={"GithubAccessToken": ghe_token, "GithubScope": "repo,admin:org_hook"})
    record_xml_property("response", r.text)

    r.raise_for_status()
    j = r.json()
    assert j['id'] is not None

def test_get_deployments_history(base_url, ghe_token, record_xml_property):
    r = requests.get("{0}/v1/deployments/history".format(base_url),
        params={"owner": test_owner, "repo": test_repo, "environment": test_env, "count": 1},
        headers={"GithubAccessToken": ghe_token},
        cookies={"GithubAccessToken": ghe_token, "GithubScope": "repo,admin:org_hook"})
    record_xml_property("response", r.text)

    r.raise_for_status()
    j = r.json()
    assert type(j) == list
