// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package batch

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opCancelJob = "CancelJob"

// CancelJobRequest generates a "aws/request.Request" representing the
// client's request for the CancelJob operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelJob for more information on using the CancelJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelJobRequest method.
//    req, resp := client.CancelJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/CancelJob
func (c *Batch) CancelJobRequest(input *CancelJobInput) (req *request.Request, output *CancelJobOutput) {
	op := &request.Operation{
		Name:       opCancelJob,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/canceljob",
	}

	if input == nil {
		input = &CancelJobInput{}
	}

	output = &CancelJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelJob API operation for AWS Batch.
//
// Cancels jobs in an AWS Batch job queue. Jobs that are in the SUBMITTED, PENDING,
// or RUNNABLE state are cancelled. Jobs that have progressed to STARTING or
// RUNNING are not cancelled (but the API operation still succeeds, even if
// no jobs are cancelled); these jobs must be terminated with the TerminateJob
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Batch's
// API operation CancelJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClientException "ClientException"
//   These errors are usually caused by a client action, such as using an action
//   or resource on behalf of a user that doesn't have permission to use the action
//   or resource, or specifying an identifier that is not valid.
//
//   * ErrCodeServerException "ServerException"
//   These errors are usually caused by a server issue.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/CancelJob
func (c *Batch) CancelJob(input *CancelJobInput) (*CancelJobOutput, error) {
	req, out := c.CancelJobRequest(input)
	return out, req.Send()
}

// CancelJobWithContext is the same as CancelJob with the addition of
// the ability to pass a context and additional request options.
//
// See CancelJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) CancelJobWithContext(ctx aws.Context, input *CancelJobInput, opts ...request.Option) (*CancelJobOutput, error) {
	req, out := c.CancelJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateComputeEnvironment = "CreateComputeEnvironment"

// CreateComputeEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the CreateComputeEnvironment operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateComputeEnvironment for more information on using the CreateComputeEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateComputeEnvironmentRequest method.
//    req, resp := client.CreateComputeEnvironmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/CreateComputeEnvironment
func (c *Batch) CreateComputeEnvironmentRequest(input *CreateComputeEnvironmentInput) (req *request.Request, output *CreateComputeEnvironmentOutput) {
	op := &request.Operation{
		Name:       opCreateComputeEnvironment,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/createcomputeenvironment",
	}

	if input == nil {
		input = &CreateComputeEnvironmentInput{}
	}

	output = &CreateComputeEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateComputeEnvironment API operation for AWS Batch.
//
// Creates an AWS Batch compute environment. You can create MANAGED or UNMANAGED
// compute environments.
//
// In a managed compute environment, AWS Batch manages the compute resources
// within the environment, based on the compute resources that you specify.
// Instances launched into a managed compute environment use the latest Amazon
// ECS-optimized AMI. You can choose to use Amazon EC2 On-Demand instances in
// your managed compute environment, or you can use Amazon EC2 Spot instances
// that only launch when the Spot bid price is below a specified percentage
// of the On-Demand price.
//
// In an unmanaged compute environment, you can manage your own compute resources.
// This provides more compute resource configuration options, such as using
// a custom AMI, but you must ensure that your AMI meets the Amazon ECS container
// instance AMI specification. For more information, see Container Instance
// AMIs (http://docs.aws.amazon.com/AmazonECS/latest/developerguide/container_instance_AMIs.html)
// in the Amazon EC2 Container Service Developer Guide. After you have created
// your unmanaged compute environment, you can use the DescribeComputeEnvironments
// operation to find the Amazon ECS cluster that is associated with it and then
// manually launch your container instances into that Amazon ECS cluster. For
// more information, see Launching an Amazon ECS Container Instance (http://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_container_instance.html)
// in the Amazon EC2 Container Service Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Batch's
// API operation CreateComputeEnvironment for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClientException "ClientException"
//   These errors are usually caused by a client action, such as using an action
//   or resource on behalf of a user that doesn't have permission to use the action
//   or resource, or specifying an identifier that is not valid.
//
//   * ErrCodeServerException "ServerException"
//   These errors are usually caused by a server issue.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/CreateComputeEnvironment
func (c *Batch) CreateComputeEnvironment(input *CreateComputeEnvironmentInput) (*CreateComputeEnvironmentOutput, error) {
	req, out := c.CreateComputeEnvironmentRequest(input)
	return out, req.Send()
}

// CreateComputeEnvironmentWithContext is the same as CreateComputeEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateComputeEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) CreateComputeEnvironmentWithContext(ctx aws.Context, input *CreateComputeEnvironmentInput, opts ...request.Option) (*CreateComputeEnvironmentOutput, error) {
	req, out := c.CreateComputeEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateJobQueue = "CreateJobQueue"

// CreateJobQueueRequest generates a "aws/request.Request" representing the
// client's request for the CreateJobQueue operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateJobQueue for more information on using the CreateJobQueue
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateJobQueueRequest method.
//    req, resp := client.CreateJobQueueRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/CreateJobQueue
func (c *Batch) CreateJobQueueRequest(input *CreateJobQueueInput) (req *request.Request, output *CreateJobQueueOutput) {
	op := &request.Operation{
		Name:       opCreateJobQueue,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/createjobqueue",
	}

	if input == nil {
		input = &CreateJobQueueInput{}
	}

	output = &CreateJobQueueOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateJobQueue API operation for AWS Batch.
//
// Creates an AWS Batch job queue. When you create a job queue, you associate
// one or more compute environments to the queue and assign an order of preference
// for the compute environments.
//
// You also set a priority to the job queue that determines the order in which
// the AWS Batch scheduler places jobs onto its associated compute environments.
// For example, if a compute environment is associated with more than one job
// queue, the job queue with a higher priority is given preference for scheduling
// jobs to that compute environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Batch's
// API operation CreateJobQueue for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClientException "ClientException"
//   These errors are usually caused by a client action, such as using an action
//   or resource on behalf of a user that doesn't have permission to use the action
//   or resource, or specifying an identifier that is not valid.
//
//   * ErrCodeServerException "ServerException"
//   These errors are usually caused by a server issue.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/CreateJobQueue
func (c *Batch) CreateJobQueue(input *CreateJobQueueInput) (*CreateJobQueueOutput, error) {
	req, out := c.CreateJobQueueRequest(input)
	return out, req.Send()
}

// CreateJobQueueWithContext is the same as CreateJobQueue with the addition of
// the ability to pass a context and additional request options.
//
// See CreateJobQueue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) CreateJobQueueWithContext(ctx aws.Context, input *CreateJobQueueInput, opts ...request.Option) (*CreateJobQueueOutput, error) {
	req, out := c.CreateJobQueueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteComputeEnvironment = "DeleteComputeEnvironment"

// DeleteComputeEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteComputeEnvironment operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteComputeEnvironment for more information on using the DeleteComputeEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteComputeEnvironmentRequest method.
//    req, resp := client.DeleteComputeEnvironmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DeleteComputeEnvironment
func (c *Batch) DeleteComputeEnvironmentRequest(input *DeleteComputeEnvironmentInput) (req *request.Request, output *DeleteComputeEnvironmentOutput) {
	op := &request.Operation{
		Name:       opDeleteComputeEnvironment,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/deletecomputeenvironment",
	}

	if input == nil {
		input = &DeleteComputeEnvironmentInput{}
	}

	output = &DeleteComputeEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteComputeEnvironment API operation for AWS Batch.
//
// Deletes an AWS Batch compute environment.
//
// Before you can delete a compute environment, you must set its state to DISABLED
// with the UpdateComputeEnvironment API operation and disassociate it from
// any job queues with the UpdateJobQueue API operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Batch's
// API operation DeleteComputeEnvironment for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClientException "ClientException"
//   These errors are usually caused by a client action, such as using an action
//   or resource on behalf of a user that doesn't have permission to use the action
//   or resource, or specifying an identifier that is not valid.
//
//   * ErrCodeServerException "ServerException"
//   These errors are usually caused by a server issue.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DeleteComputeEnvironment
func (c *Batch) DeleteComputeEnvironment(input *DeleteComputeEnvironmentInput) (*DeleteComputeEnvironmentOutput, error) {
	req, out := c.DeleteComputeEnvironmentRequest(input)
	return out, req.Send()
}

// DeleteComputeEnvironmentWithContext is the same as DeleteComputeEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteComputeEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) DeleteComputeEnvironmentWithContext(ctx aws.Context, input *DeleteComputeEnvironmentInput, opts ...request.Option) (*DeleteComputeEnvironmentOutput, error) {
	req, out := c.DeleteComputeEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteJobQueue = "DeleteJobQueue"

// DeleteJobQueueRequest generates a "aws/request.Request" representing the
// client's request for the DeleteJobQueue operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteJobQueue for more information on using the DeleteJobQueue
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteJobQueueRequest method.
//    req, resp := client.DeleteJobQueueRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DeleteJobQueue
func (c *Batch) DeleteJobQueueRequest(input *DeleteJobQueueInput) (req *request.Request, output *DeleteJobQueueOutput) {
	op := &request.Operation{
		Name:       opDeleteJobQueue,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/deletejobqueue",
	}

	if input == nil {
		input = &DeleteJobQueueInput{}
	}

	output = &DeleteJobQueueOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteJobQueue API operation for AWS Batch.
//
// Deletes the specified job queue. You must first disable submissions for a
// queue with the UpdateJobQueue operation and terminate any jobs that have
// not completed with the TerminateJob.
//
// It is not necessary to disassociate compute environments from a queue before
// submitting a DeleteJobQueue request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Batch's
// API operation DeleteJobQueue for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClientException "ClientException"
//   These errors are usually caused by a client action, such as using an action
//   or resource on behalf of a user that doesn't have permission to use the action
//   or resource, or specifying an identifier that is not valid.
//
//   * ErrCodeServerException "ServerException"
//   These errors are usually caused by a server issue.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DeleteJobQueue
func (c *Batch) DeleteJobQueue(input *DeleteJobQueueInput) (*DeleteJobQueueOutput, error) {
	req, out := c.DeleteJobQueueRequest(input)
	return out, req.Send()
}

// DeleteJobQueueWithContext is the same as DeleteJobQueue with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteJobQueue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) DeleteJobQueueWithContext(ctx aws.Context, input *DeleteJobQueueInput, opts ...request.Option) (*DeleteJobQueueOutput, error) {
	req, out := c.DeleteJobQueueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterJobDefinition = "DeregisterJobDefinition"

// DeregisterJobDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterJobDefinition operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterJobDefinition for more information on using the DeregisterJobDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeregisterJobDefinitionRequest method.
//    req, resp := client.DeregisterJobDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DeregisterJobDefinition
func (c *Batch) DeregisterJobDefinitionRequest(input *DeregisterJobDefinitionInput) (req *request.Request, output *DeregisterJobDefinitionOutput) {
	op := &request.Operation{
		Name:       opDeregisterJobDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/deregisterjobdefinition",
	}

	if input == nil {
		input = &DeregisterJobDefinitionInput{}
	}

	output = &DeregisterJobDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeregisterJobDefinition API operation for AWS Batch.
//
// Deregisters an AWS Batch job definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Batch's
// API operation DeregisterJobDefinition for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClientException "ClientException"
//   These errors are usually caused by a client action, such as using an action
//   or resource on behalf of a user that doesn't have permission to use the action
//   or resource, or specifying an identifier that is not valid.
//
//   * ErrCodeServerException "ServerException"
//   These errors are usually caused by a server issue.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DeregisterJobDefinition
func (c *Batch) DeregisterJobDefinition(input *DeregisterJobDefinitionInput) (*DeregisterJobDefinitionOutput, error) {
	req, out := c.DeregisterJobDefinitionRequest(input)
	return out, req.Send()
}

// DeregisterJobDefinitionWithContext is the same as DeregisterJobDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterJobDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) DeregisterJobDefinitionWithContext(ctx aws.Context, input *DeregisterJobDefinitionInput, opts ...request.Option) (*DeregisterJobDefinitionOutput, error) {
	req, out := c.DeregisterJobDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeComputeEnvironments = "DescribeComputeEnvironments"

// DescribeComputeEnvironmentsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeComputeEnvironments operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeComputeEnvironments for more information on using the DescribeComputeEnvironments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeComputeEnvironmentsRequest method.
//    req, resp := client.DescribeComputeEnvironmentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DescribeComputeEnvironments
func (c *Batch) DescribeComputeEnvironmentsRequest(input *DescribeComputeEnvironmentsInput) (req *request.Request, output *DescribeComputeEnvironmentsOutput) {
	op := &request.Operation{
		Name:       opDescribeComputeEnvironments,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/describecomputeenvironments",
	}

	if input == nil {
		input = &DescribeComputeEnvironmentsInput{}
	}

	output = &DescribeComputeEnvironmentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeComputeEnvironments API operation for AWS Batch.
//
// Describes one or more of your compute environments.
//
// If you are using an unmanaged compute environment, you can use the DescribeComputeEnvironment
// operation to determine the ecsClusterArn that you should launch your Amazon
// ECS container instances into.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Batch's
// API operation DescribeComputeEnvironments for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClientException "ClientException"
//   These errors are usually caused by a client action, such as using an action
//   or resource on behalf of a user that doesn't have permission to use the action
//   or resource, or specifying an identifier that is not valid.
//
//   * ErrCodeServerException "ServerException"
//   These errors are usually caused by a server issue.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DescribeComputeEnvironments
func (c *Batch) DescribeComputeEnvironments(input *DescribeComputeEnvironmentsInput) (*DescribeComputeEnvironmentsOutput, error) {
	req, out := c.DescribeComputeEnvironmentsRequest(input)
	return out, req.Send()
}

// DescribeComputeEnvironmentsWithContext is the same as DescribeComputeEnvironments with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeComputeEnvironments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) DescribeComputeEnvironmentsWithContext(ctx aws.Context, input *DescribeComputeEnvironmentsInput, opts ...request.Option) (*DescribeComputeEnvironmentsOutput, error) {
	req, out := c.DescribeComputeEnvironmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeJobDefinitions = "DescribeJobDefinitions"

// DescribeJobDefinitionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeJobDefinitions operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeJobDefinitions for more information on using the DescribeJobDefinitions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeJobDefinitionsRequest method.
//    req, resp := client.DescribeJobDefinitionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DescribeJobDefinitions
func (c *Batch) DescribeJobDefinitionsRequest(input *DescribeJobDefinitionsInput) (req *request.Request, output *DescribeJobDefinitionsOutput) {
	op := &request.Operation{
		Name:       opDescribeJobDefinitions,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/describejobdefinitions",
	}

	if input == nil {
		input = &DescribeJobDefinitionsInput{}
	}

	output = &DescribeJobDefinitionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeJobDefinitions API operation for AWS Batch.
//
// Describes a list of job definitions. You can specify a status (such as ACTIVE)
// to only return job definitions that match that status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Batch's
// API operation DescribeJobDefinitions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClientException "ClientException"
//   These errors are usually caused by a client action, such as using an action
//   or resource on behalf of a user that doesn't have permission to use the action
//   or resource, or specifying an identifier that is not valid.
//
//   * ErrCodeServerException "ServerException"
//   These errors are usually caused by a server issue.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DescribeJobDefinitions
func (c *Batch) DescribeJobDefinitions(input *DescribeJobDefinitionsInput) (*DescribeJobDefinitionsOutput, error) {
	req, out := c.DescribeJobDefinitionsRequest(input)
	return out, req.Send()
}

// DescribeJobDefinitionsWithContext is the same as DescribeJobDefinitions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeJobDefinitions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) DescribeJobDefinitionsWithContext(ctx aws.Context, input *DescribeJobDefinitionsInput, opts ...request.Option) (*DescribeJobDefinitionsOutput, error) {
	req, out := c.DescribeJobDefinitionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeJobQueues = "DescribeJobQueues"

// DescribeJobQueuesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeJobQueues operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeJobQueues for more information on using the DescribeJobQueues
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeJobQueuesRequest method.
//    req, resp := client.DescribeJobQueuesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DescribeJobQueues
func (c *Batch) DescribeJobQueuesRequest(input *DescribeJobQueuesInput) (req *request.Request, output *DescribeJobQueuesOutput) {
	op := &request.Operation{
		Name:       opDescribeJobQueues,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/describejobqueues",
	}

	if input == nil {
		input = &DescribeJobQueuesInput{}
	}

	output = &DescribeJobQueuesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeJobQueues API operation for AWS Batch.
//
// Describes one or more of your job queues.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Batch's
// API operation DescribeJobQueues for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClientException "ClientException"
//   These errors are usually caused by a client action, such as using an action
//   or resource on behalf of a user that doesn't have permission to use the action
//   or resource, or specifying an identifier that is not valid.
//
//   * ErrCodeServerException "ServerException"
//   These errors are usually caused by a server issue.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DescribeJobQueues
func (c *Batch) DescribeJobQueues(input *DescribeJobQueuesInput) (*DescribeJobQueuesOutput, error) {
	req, out := c.DescribeJobQueuesRequest(input)
	return out, req.Send()
}

// DescribeJobQueuesWithContext is the same as DescribeJobQueues with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeJobQueues for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) DescribeJobQueuesWithContext(ctx aws.Context, input *DescribeJobQueuesInput, opts ...request.Option) (*DescribeJobQueuesOutput, error) {
	req, out := c.DescribeJobQueuesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeJobs = "DescribeJobs"

// DescribeJobsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeJobs operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeJobs for more information on using the DescribeJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeJobsRequest method.
//    req, resp := client.DescribeJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DescribeJobs
func (c *Batch) DescribeJobsRequest(input *DescribeJobsInput) (req *request.Request, output *DescribeJobsOutput) {
	op := &request.Operation{
		Name:       opDescribeJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/describejobs",
	}

	if input == nil {
		input = &DescribeJobsInput{}
	}

	output = &DescribeJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeJobs API operation for AWS Batch.
//
// Describes a list of AWS Batch jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Batch's
// API operation DescribeJobs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClientException "ClientException"
//   These errors are usually caused by a client action, such as using an action
//   or resource on behalf of a user that doesn't have permission to use the action
//   or resource, or specifying an identifier that is not valid.
//
//   * ErrCodeServerException "ServerException"
//   These errors are usually caused by a server issue.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DescribeJobs
func (c *Batch) DescribeJobs(input *DescribeJobsInput) (*DescribeJobsOutput, error) {
	req, out := c.DescribeJobsRequest(input)
	return out, req.Send()
}

// DescribeJobsWithContext is the same as DescribeJobs with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) DescribeJobsWithContext(ctx aws.Context, input *DescribeJobsInput, opts ...request.Option) (*DescribeJobsOutput, error) {
	req, out := c.DescribeJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListJobs = "ListJobs"

// ListJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListJobs operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListJobs for more information on using the ListJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListJobsRequest method.
//    req, resp := client.ListJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/ListJobs
func (c *Batch) ListJobsRequest(input *ListJobsInput) (req *request.Request, output *ListJobsOutput) {
	op := &request.Operation{
		Name:       opListJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/listjobs",
	}

	if input == nil {
		input = &ListJobsInput{}
	}

	output = &ListJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListJobs API operation for AWS Batch.
//
// Returns a list of task jobs for a specified job queue. You can filter the
// results by job status with the jobStatus parameter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Batch's
// API operation ListJobs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClientException "ClientException"
//   These errors are usually caused by a client action, such as using an action
//   or resource on behalf of a user that doesn't have permission to use the action
//   or resource, or specifying an identifier that is not valid.
//
//   * ErrCodeServerException "ServerException"
//   These errors are usually caused by a server issue.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/ListJobs
func (c *Batch) ListJobs(input *ListJobsInput) (*ListJobsOutput, error) {
	req, out := c.ListJobsRequest(input)
	return out, req.Send()
}

// ListJobsWithContext is the same as ListJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) ListJobsWithContext(ctx aws.Context, input *ListJobsInput, opts ...request.Option) (*ListJobsOutput, error) {
	req, out := c.ListJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterJobDefinition = "RegisterJobDefinition"

// RegisterJobDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the RegisterJobDefinition operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterJobDefinition for more information on using the RegisterJobDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterJobDefinitionRequest method.
//    req, resp := client.RegisterJobDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/RegisterJobDefinition
func (c *Batch) RegisterJobDefinitionRequest(input *RegisterJobDefinitionInput) (req *request.Request, output *RegisterJobDefinitionOutput) {
	op := &request.Operation{
		Name:       opRegisterJobDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/registerjobdefinition",
	}

	if input == nil {
		input = &RegisterJobDefinitionInput{}
	}

	output = &RegisterJobDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterJobDefinition API operation for AWS Batch.
//
// Registers an AWS Batch job definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Batch's
// API operation RegisterJobDefinition for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClientException "ClientException"
//   These errors are usually caused by a client action, such as using an action
//   or resource on behalf of a user that doesn't have permission to use the action
//   or resource, or specifying an identifier that is not valid.
//
//   * ErrCodeServerException "ServerException"
//   These errors are usually caused by a server issue.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/RegisterJobDefinition
func (c *Batch) RegisterJobDefinition(input *RegisterJobDefinitionInput) (*RegisterJobDefinitionOutput, error) {
	req, out := c.RegisterJobDefinitionRequest(input)
	return out, req.Send()
}

// RegisterJobDefinitionWithContext is the same as RegisterJobDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterJobDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) RegisterJobDefinitionWithContext(ctx aws.Context, input *RegisterJobDefinitionInput, opts ...request.Option) (*RegisterJobDefinitionOutput, error) {
	req, out := c.RegisterJobDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSubmitJob = "SubmitJob"

// SubmitJobRequest generates a "aws/request.Request" representing the
// client's request for the SubmitJob operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SubmitJob for more information on using the SubmitJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SubmitJobRequest method.
//    req, resp := client.SubmitJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/SubmitJob
func (c *Batch) SubmitJobRequest(input *SubmitJobInput) (req *request.Request, output *SubmitJobOutput) {
	op := &request.Operation{
		Name:       opSubmitJob,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/submitjob",
	}

	if input == nil {
		input = &SubmitJobInput{}
	}

	output = &SubmitJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SubmitJob API operation for AWS Batch.
//
// Submits an AWS Batch job from a job definition. Parameters specified during
// SubmitJob override parameters defined in the job definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Batch's
// API operation SubmitJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClientException "ClientException"
//   These errors are usually caused by a client action, such as using an action
//   or resource on behalf of a user that doesn't have permission to use the action
//   or resource, or specifying an identifier that is not valid.
//
//   * ErrCodeServerException "ServerException"
//   These errors are usually caused by a server issue.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/SubmitJob
func (c *Batch) SubmitJob(input *SubmitJobInput) (*SubmitJobOutput, error) {
	req, out := c.SubmitJobRequest(input)
	return out, req.Send()
}

// SubmitJobWithContext is the same as SubmitJob with the addition of
// the ability to pass a context and additional request options.
//
// See SubmitJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) SubmitJobWithContext(ctx aws.Context, input *SubmitJobInput, opts ...request.Option) (*SubmitJobOutput, error) {
	req, out := c.SubmitJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTerminateJob = "TerminateJob"

// TerminateJobRequest generates a "aws/request.Request" representing the
// client's request for the TerminateJob operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TerminateJob for more information on using the TerminateJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TerminateJobRequest method.
//    req, resp := client.TerminateJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/TerminateJob
func (c *Batch) TerminateJobRequest(input *TerminateJobInput) (req *request.Request, output *TerminateJobOutput) {
	op := &request.Operation{
		Name:       opTerminateJob,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/terminatejob",
	}

	if input == nil {
		input = &TerminateJobInput{}
	}

	output = &TerminateJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TerminateJob API operation for AWS Batch.
//
// Terminates jobs in a job queue. Jobs that are in the STARTING or RUNNING
// state are terminated, which causes them to transition to FAILED. Jobs that
// have not progressed to the STARTING state are cancelled.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Batch's
// API operation TerminateJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClientException "ClientException"
//   These errors are usually caused by a client action, such as using an action
//   or resource on behalf of a user that doesn't have permission to use the action
//   or resource, or specifying an identifier that is not valid.
//
//   * ErrCodeServerException "ServerException"
//   These errors are usually caused by a server issue.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/TerminateJob
func (c *Batch) TerminateJob(input *TerminateJobInput) (*TerminateJobOutput, error) {
	req, out := c.TerminateJobRequest(input)
	return out, req.Send()
}

// TerminateJobWithContext is the same as TerminateJob with the addition of
// the ability to pass a context and additional request options.
//
// See TerminateJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) TerminateJobWithContext(ctx aws.Context, input *TerminateJobInput, opts ...request.Option) (*TerminateJobOutput, error) {
	req, out := c.TerminateJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateComputeEnvironment = "UpdateComputeEnvironment"

// UpdateComputeEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateComputeEnvironment operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateComputeEnvironment for more information on using the UpdateComputeEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateComputeEnvironmentRequest method.
//    req, resp := client.UpdateComputeEnvironmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/UpdateComputeEnvironment
func (c *Batch) UpdateComputeEnvironmentRequest(input *UpdateComputeEnvironmentInput) (req *request.Request, output *UpdateComputeEnvironmentOutput) {
	op := &request.Operation{
		Name:       opUpdateComputeEnvironment,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/updatecomputeenvironment",
	}

	if input == nil {
		input = &UpdateComputeEnvironmentInput{}
	}

	output = &UpdateComputeEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateComputeEnvironment API operation for AWS Batch.
//
// Updates an AWS Batch compute environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Batch's
// API operation UpdateComputeEnvironment for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClientException "ClientException"
//   These errors are usually caused by a client action, such as using an action
//   or resource on behalf of a user that doesn't have permission to use the action
//   or resource, or specifying an identifier that is not valid.
//
//   * ErrCodeServerException "ServerException"
//   These errors are usually caused by a server issue.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/UpdateComputeEnvironment
func (c *Batch) UpdateComputeEnvironment(input *UpdateComputeEnvironmentInput) (*UpdateComputeEnvironmentOutput, error) {
	req, out := c.UpdateComputeEnvironmentRequest(input)
	return out, req.Send()
}

// UpdateComputeEnvironmentWithContext is the same as UpdateComputeEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateComputeEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) UpdateComputeEnvironmentWithContext(ctx aws.Context, input *UpdateComputeEnvironmentInput, opts ...request.Option) (*UpdateComputeEnvironmentOutput, error) {
	req, out := c.UpdateComputeEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateJobQueue = "UpdateJobQueue"

// UpdateJobQueueRequest generates a "aws/request.Request" representing the
// client's request for the UpdateJobQueue operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateJobQueue for more information on using the UpdateJobQueue
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateJobQueueRequest method.
//    req, resp := client.UpdateJobQueueRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/UpdateJobQueue
func (c *Batch) UpdateJobQueueRequest(input *UpdateJobQueueInput) (req *request.Request, output *UpdateJobQueueOutput) {
	op := &request.Operation{
		Name:       opUpdateJobQueue,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/updatejobqueue",
	}

	if input == nil {
		input = &UpdateJobQueueInput{}
	}

	output = &UpdateJobQueueOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateJobQueue API operation for AWS Batch.
//
// Updates a job queue.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Batch's
// API operation UpdateJobQueue for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClientException "ClientException"
//   These errors are usually caused by a client action, such as using an action
//   or resource on behalf of a user that doesn't have permission to use the action
//   or resource, or specifying an identifier that is not valid.
//
//   * ErrCodeServerException "ServerException"
//   These errors are usually caused by a server issue.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/UpdateJobQueue
func (c *Batch) UpdateJobQueue(input *UpdateJobQueueInput) (*UpdateJobQueueOutput, error) {
	req, out := c.UpdateJobQueueRequest(input)
	return out, req.Send()
}

// UpdateJobQueueWithContext is the same as UpdateJobQueue with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateJobQueue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Batch) UpdateJobQueueWithContext(ctx aws.Context, input *UpdateJobQueueInput, opts ...request.Option) (*UpdateJobQueueOutput, error) {
	req, out := c.UpdateJobQueueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// An object representing the details of a container that is part of a job attempt.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/AttemptContainerDetail
type AttemptContainerDetail struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon ECS container instance that
	// hosts the job attempt.
	ContainerInstanceArn *string `locationName:"containerInstanceArn" type:"string"`

	// The exit code for the job attempt. A non-zero exit code is considered a failure.
	ExitCode *int64 `locationName:"exitCode" type:"integer"`

	LogStreamName *string `locationName:"logStreamName" type:"string"`

	// A short (255 max characters) human-readable string to provide additional
	// details about a running or stopped container.
	Reason *string `locationName:"reason" type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon ECS task that is associated
	// with the job attempt.
	TaskArn *string `locationName:"taskArn" type:"string"`
}

// String returns the string representation
func (s AttemptContainerDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttemptContainerDetail) GoString() string {
	return s.String()
}

// SetContainerInstanceArn sets the ContainerInstanceArn field's value.
func (s *AttemptContainerDetail) SetContainerInstanceArn(v string) *AttemptContainerDetail {
	s.ContainerInstanceArn = &v
	return s
}

// SetExitCode sets the ExitCode field's value.
func (s *AttemptContainerDetail) SetExitCode(v int64) *AttemptContainerDetail {
	s.ExitCode = &v
	return s
}

// SetLogStreamName sets the LogStreamName field's value.
func (s *AttemptContainerDetail) SetLogStreamName(v string) *AttemptContainerDetail {
	s.LogStreamName = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *AttemptContainerDetail) SetReason(v string) *AttemptContainerDetail {
	s.Reason = &v
	return s
}

// SetTaskArn sets the TaskArn field's value.
func (s *AttemptContainerDetail) SetTaskArn(v string) *AttemptContainerDetail {
	s.TaskArn = &v
	return s
}

// An object representing a job attempt.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/AttemptDetail
type AttemptDetail struct {
	_ struct{} `type:"structure"`

	// Details about the container in this job attempt.
	Container *AttemptContainerDetail `locationName:"container" type:"structure"`

	// The Unix timestamp for when the attempt was started (when the task transitioned
	// from the PENDING state to the RUNNING state).
	StartedAt *int64 `locationName:"startedAt" type:"long"`

	// A short, human-readable string to provide additional details about the current
	// status of the job attempt.
	StatusReason *string `locationName:"statusReason" type:"string"`

	// The Unix timestamp for when the attempt was stopped (when the task transitioned
	// from the RUNNING state to the STOPPED state).
	StoppedAt *int64 `locationName:"stoppedAt" type:"long"`
}

// String returns the string representation
func (s AttemptDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttemptDetail) GoString() string {
	return s.String()
}

// SetContainer sets the Container field's value.
func (s *AttemptDetail) SetContainer(v *AttemptContainerDetail) *AttemptDetail {
	s.Container = v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *AttemptDetail) SetStartedAt(v int64) *AttemptDetail {
	s.StartedAt = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *AttemptDetail) SetStatusReason(v string) *AttemptDetail {
	s.StatusReason = &v
	return s
}

// SetStoppedAt sets the StoppedAt field's value.
func (s *AttemptDetail) SetStoppedAt(v int64) *AttemptDetail {
	s.StoppedAt = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/CancelJobRequest
type CancelJobInput struct {
	_ struct{} `type:"structure"`

	// A list of up to 100 job IDs to cancel.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`

	// A message to attach to the job that explains the reason for cancelling it.
	// This message is returned by future DescribeJobs operations on the job. This
	// message is also recorded in the AWS Batch activity logs.
	//
	// Reason is a required field
	Reason *string `locationName:"reason" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.Reason == nil {
		invalidParams.Add(request.NewErrParamRequired("Reason"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *CancelJobInput) SetJobId(v string) *CancelJobInput {
	s.JobId = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *CancelJobInput) SetReason(v string) *CancelJobInput {
	s.Reason = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/CancelJobResponse
type CancelJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CancelJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelJobOutput) GoString() string {
	return s.String()
}

// An object representing an AWS Batch compute environment.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/ComputeEnvironmentDetail
type ComputeEnvironmentDetail struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the compute environment.
	//
	// ComputeEnvironmentArn is a required field
	ComputeEnvironmentArn *string `locationName:"computeEnvironmentArn" type:"string" required:"true"`

	// The name of the compute environment.
	//
	// ComputeEnvironmentName is a required field
	ComputeEnvironmentName *string `locationName:"computeEnvironmentName" type:"string" required:"true"`

	// The compute resources defined for the compute environment.
	ComputeResources *ComputeResource `locationName:"computeResources" type:"structure"`

	// The Amazon Resource Name (ARN) of the underlying Amazon ECS cluster used
	// by the compute environment.
	//
	// EcsClusterArn is a required field
	EcsClusterArn *string `locationName:"ecsClusterArn" type:"string" required:"true"`

	// The service role associated with the compute environment that allows AWS
	// Batch to make calls to AWS API operations on your behalf.
	ServiceRole *string `locationName:"serviceRole" type:"string"`

	// The state of the compute environment. The valid values are ENABLED or DISABLED.
	// An ENABLED state indicates that you can register instances with the compute
	// environment and that the associated instances can accept jobs.
	State *string `locationName:"state" type:"string" enum:"CEState"`

	// The current status of the compute environment (for example, CREATING or VALID).
	Status *string `locationName:"status" type:"string" enum:"CEStatus"`

	// A short, human-readable string to provide additional details about the current
	// status of the compute environment.
	StatusReason *string `locationName:"statusReason" type:"string"`

	// The type of the compute environment.
	Type *string `locationName:"type" type:"string" enum:"CEType"`
}

// String returns the string representation
func (s ComputeEnvironmentDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ComputeEnvironmentDetail) GoString() string {
	return s.String()
}

// SetComputeEnvironmentArn sets the ComputeEnvironmentArn field's value.
func (s *ComputeEnvironmentDetail) SetComputeEnvironmentArn(v string) *ComputeEnvironmentDetail {
	s.ComputeEnvironmentArn = &v
	return s
}

// SetComputeEnvironmentName sets the ComputeEnvironmentName field's value.
func (s *ComputeEnvironmentDetail) SetComputeEnvironmentName(v string) *ComputeEnvironmentDetail {
	s.ComputeEnvironmentName = &v
	return s
}

// SetComputeResources sets the ComputeResources field's value.
func (s *ComputeEnvironmentDetail) SetComputeResources(v *ComputeResource) *ComputeEnvironmentDetail {
	s.ComputeResources = v
	return s
}

// SetEcsClusterArn sets the EcsClusterArn field's value.
func (s *ComputeEnvironmentDetail) SetEcsClusterArn(v string) *ComputeEnvironmentDetail {
	s.EcsClusterArn = &v
	return s
}

// SetServiceRole sets the ServiceRole field's value.
func (s *ComputeEnvironmentDetail) SetServiceRole(v string) *ComputeEnvironmentDetail {
	s.ServiceRole = &v
	return s
}

// SetState sets the State field's value.
func (s *ComputeEnvironmentDetail) SetState(v string) *ComputeEnvironmentDetail {
	s.State = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ComputeEnvironmentDetail) SetStatus(v string) *ComputeEnvironmentDetail {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *ComputeEnvironmentDetail) SetStatusReason(v string) *ComputeEnvironmentDetail {
	s.StatusReason = &v
	return s
}

// SetType sets the Type field's value.
func (s *ComputeEnvironmentDetail) SetType(v string) *ComputeEnvironmentDetail {
	s.Type = &v
	return s
}

// The order in which compute environments are tried for job placement within
// a queue. Compute environments are tried in ascending order. For example,
// if two compute environments are associated with a job queue, the compute
// environment with a lower order integer value is tried for job placement first.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/ComputeEnvironmentOrder
type ComputeEnvironmentOrder struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the compute environment.
	//
	// ComputeEnvironment is a required field
	ComputeEnvironment *string `locationName:"computeEnvironment" type:"string" required:"true"`

	// The order of the compute environment.
	//
	// Order is a required field
	Order *int64 `locationName:"order" type:"integer" required:"true"`
}

// String returns the string representation
func (s ComputeEnvironmentOrder) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ComputeEnvironmentOrder) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComputeEnvironmentOrder) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ComputeEnvironmentOrder"}
	if s.ComputeEnvironment == nil {
		invalidParams.Add(request.NewErrParamRequired("ComputeEnvironment"))
	}
	if s.Order == nil {
		invalidParams.Add(request.NewErrParamRequired("Order"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComputeEnvironment sets the ComputeEnvironment field's value.
func (s *ComputeEnvironmentOrder) SetComputeEnvironment(v string) *ComputeEnvironmentOrder {
	s.ComputeEnvironment = &v
	return s
}

// SetOrder sets the Order field's value.
func (s *ComputeEnvironmentOrder) SetOrder(v int64) *ComputeEnvironmentOrder {
	s.Order = &v
	return s
}

// An object representing an AWS Batch compute resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/ComputeResource
type ComputeResource struct {
	_ struct{} `type:"structure"`

	// The minimum percentage that a Spot Instance price must be when compared with
	// the On-Demand price for that instance type before instances are launched.
	// For example, if your bid percentage is 20%, then the Spot price must be below
	// 20% of the current On-Demand price for that EC2 instance.
	BidPercentage *int64 `locationName:"bidPercentage" type:"integer"`

	// The desired number of EC2 vCPUS in the compute environment.
	DesiredvCpus *int64 `locationName:"desiredvCpus" type:"integer"`

	// The EC2 key pair that is used for instances launched in the compute environment.
	Ec2KeyPair *string `locationName:"ec2KeyPair" type:"string"`

	// The Amazon Machine Image (AMI) ID used for instances launched in the compute
	// environment.
	ImageId *string `locationName:"imageId" type:"string"`

	// The Amazon ECS instance role applied to Amazon EC2 instances in a compute
	// environment.
	//
	// InstanceRole is a required field
	InstanceRole *string `locationName:"instanceRole" type:"string" required:"true"`

	// The instances types that may launched.
	//
	// InstanceTypes is a required field
	InstanceTypes []*string `locationName:"instanceTypes" type:"list" required:"true"`

	// The maximum number of EC2 vCPUs that an environment can reach.
	//
	// MaxvCpus is a required field
	MaxvCpus *int64 `locationName:"maxvCpus" type:"integer" required:"true"`

	// The minimum number of EC2 vCPUs that an environment should maintain.
	//
	// MinvCpus is a required field
	MinvCpus *int64 `locationName:"minvCpus" type:"integer" required:"true"`

	// The EC2 security group that is associated with instances launched in the
	// compute environment.
	//
	// SecurityGroupIds is a required field
	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the Amazon EC2 Spot Fleet IAM role applied
	// to a SPOT compute environment.
	SpotIamFleetRole *string `locationName:"spotIamFleetRole" type:"string"`

	// The VPC subnets into which the compute resources are launched.
	//
	// Subnets is a required field
	Subnets []*string `locationName:"subnets" type:"list" required:"true"`

	// Key-value pair tags to be applied to resources that are launched in the compute
	// environment.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The type of compute environment.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"CRType"`
}

// String returns the string representation
func (s ComputeResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ComputeResource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComputeResource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ComputeResource"}
	if s.InstanceRole == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceRole"))
	}
	if s.InstanceTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceTypes"))
	}
	if s.MaxvCpus == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxvCpus"))
	}
	if s.MinvCpus == nil {
		invalidParams.Add(request.NewErrParamRequired("MinvCpus"))
	}
	if s.SecurityGroupIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroupIds"))
	}
	if s.Subnets == nil {
		invalidParams.Add(request.NewErrParamRequired("Subnets"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBidPercentage sets the BidPercentage field's value.
func (s *ComputeResource) SetBidPercentage(v int64) *ComputeResource {
	s.BidPercentage = &v
	return s
}

// SetDesiredvCpus sets the DesiredvCpus field's value.
func (s *ComputeResource) SetDesiredvCpus(v int64) *ComputeResource {
	s.DesiredvCpus = &v
	return s
}

// SetEc2KeyPair sets the Ec2KeyPair field's value.
func (s *ComputeResource) SetEc2KeyPair(v string) *ComputeResource {
	s.Ec2KeyPair = &v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *ComputeResource) SetImageId(v string) *ComputeResource {
	s.ImageId = &v
	return s
}

// SetInstanceRole sets the InstanceRole field's value.
func (s *ComputeResource) SetInstanceRole(v string) *ComputeResource {
	s.InstanceRole = &v
	return s
}

// SetInstanceTypes sets the InstanceTypes field's value.
func (s *ComputeResource) SetInstanceTypes(v []*string) *ComputeResource {
	s.InstanceTypes = v
	return s
}

// SetMaxvCpus sets the MaxvCpus field's value.
func (s *ComputeResource) SetMaxvCpus(v int64) *ComputeResource {
	s.MaxvCpus = &v
	return s
}

// SetMinvCpus sets the MinvCpus field's value.
func (s *ComputeResource) SetMinvCpus(v int64) *ComputeResource {
	s.MinvCpus = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *ComputeResource) SetSecurityGroupIds(v []*string) *ComputeResource {
	s.SecurityGroupIds = v
	return s
}

// SetSpotIamFleetRole sets the SpotIamFleetRole field's value.
func (s *ComputeResource) SetSpotIamFleetRole(v string) *ComputeResource {
	s.SpotIamFleetRole = &v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *ComputeResource) SetSubnets(v []*string) *ComputeResource {
	s.Subnets = v
	return s
}

// SetTags sets the Tags field's value.
func (s *ComputeResource) SetTags(v map[string]*string) *ComputeResource {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *ComputeResource) SetType(v string) *ComputeResource {
	s.Type = &v
	return s
}

// An object representing the attributes of a compute environment that can be
// updated.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/ComputeResourceUpdate
type ComputeResourceUpdate struct {
	_ struct{} `type:"structure"`

	// The desired number of EC2 vCPUS in the compute environment.
	DesiredvCpus *int64 `locationName:"desiredvCpus" type:"integer"`

	// The maximum number of EC2 vCPUs that an environment can reach.
	MaxvCpus *int64 `locationName:"maxvCpus" type:"integer"`

	// The minimum number of EC2 vCPUs that an environment should maintain.
	MinvCpus *int64 `locationName:"minvCpus" type:"integer"`
}

// String returns the string representation
func (s ComputeResourceUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ComputeResourceUpdate) GoString() string {
	return s.String()
}

// SetDesiredvCpus sets the DesiredvCpus field's value.
func (s *ComputeResourceUpdate) SetDesiredvCpus(v int64) *ComputeResourceUpdate {
	s.DesiredvCpus = &v
	return s
}

// SetMaxvCpus sets the MaxvCpus field's value.
func (s *ComputeResourceUpdate) SetMaxvCpus(v int64) *ComputeResourceUpdate {
	s.MaxvCpus = &v
	return s
}

// SetMinvCpus sets the MinvCpus field's value.
func (s *ComputeResourceUpdate) SetMinvCpus(v int64) *ComputeResourceUpdate {
	s.MinvCpus = &v
	return s
}

// An object representing the details of a container that is part of a job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/ContainerDetail
type ContainerDetail struct {
	_ struct{} `type:"structure"`

	// The command that is passed to the container.
	Command []*string `locationName:"command" type:"list"`

	// The Amazon Resource Name (ARN) of the container instance on which the container
	// is running.
	ContainerInstanceArn *string `locationName:"containerInstanceArn" type:"string"`

	// The environment variables to pass to a container.
	Environment []*KeyValuePair `locationName:"environment" type:"list"`

	// The exit code to return upon completion.
	ExitCode *int64 `locationName:"exitCode" type:"integer"`

	// The image used to start the container.
	Image *string `locationName:"image" type:"string"`

	// The Amazon Resource Name (ARN) associated with the job upon execution.
	JobRoleArn *string `locationName:"jobRoleArn" type:"string"`

	LogStreamName *string `locationName:"logStreamName" type:"string"`

	// The number of MiB of memory reserved for the job.
	Memory *int64 `locationName:"memory" type:"integer"`

	// The mount points for data volumes in your container.
	MountPoints []*MountPoint `locationName:"mountPoints" type:"list"`

	// When this parameter is true, the container is given elevated privileges on
	// the host container instance (similar to the root user).
	Privileged *bool `locationName:"privileged" type:"boolean"`

	// When this parameter is true, the container is given read-only access to its
	// root file system.
	ReadonlyRootFilesystem *bool `locationName:"readonlyRootFilesystem" type:"boolean"`

	// A short (255 max characters) human-readable string to provide additional
	// details about a running or stopped container.
	Reason *string `locationName:"reason" type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon ECS task that is associated
	// with the container job.
	TaskArn *string `locationName:"taskArn" type:"string"`

	// A list of ulimit values to set in the container.
	Ulimits []*Ulimit `locationName:"ulimits" type:"list"`

	// The user name to use inside the container.
	User *string `locationName:"user" type:"string"`

	// The number of VCPUs allocated for the job.
	Vcpus *int64 `locationName:"vcpus" type:"integer"`

	// A list of volumes associated with the job.
	Volumes []*Volume `locationName:"volumes" type:"list"`
}

// String returns the string representation
func (s ContainerDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContainerDetail) GoString() string {
	return s.String()
}

// SetCommand sets the Command field's value.
func (s *ContainerDetail) SetCommand(v []*string) *ContainerDetail {
	s.Command = v
	return s
}

// SetContainerInstanceArn sets the ContainerInstanceArn field's value.
func (s *ContainerDetail) SetContainerInstanceArn(v string) *ContainerDetail {
	s.ContainerInstanceArn = &v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *ContainerDetail) SetEnvironment(v []*KeyValuePair) *ContainerDetail {
	s.Environment = v
	return s
}

// SetExitCode sets the ExitCode field's value.
func (s *ContainerDetail) SetExitCode(v int64) *ContainerDetail {
	s.ExitCode = &v
	return s
}

// SetImage sets the Image field's value.
func (s *ContainerDetail) SetImage(v string) *ContainerDetail {
	s.Image = &v
	return s
}

// SetJobRoleArn sets the JobRoleArn field's value.
func (s *ContainerDetail) SetJobRoleArn(v string) *ContainerDetail {
	s.JobRoleArn = &v
	return s
}

// SetLogStreamName sets the LogStreamName field's value.
func (s *ContainerDetail) SetLogStreamName(v string) *ContainerDetail {
	s.LogStreamName = &v
	return s
}

// SetMemory sets the Memory field's value.
func (s *ContainerDetail) SetMemory(v int64) *ContainerDetail {
	s.Memory = &v
	return s
}

// SetMountPoints sets the MountPoints field's value.
func (s *ContainerDetail) SetMountPoints(v []*MountPoint) *ContainerDetail {
	s.MountPoints = v
	return s
}

// SetPrivileged sets the Privileged field's value.
func (s *ContainerDetail) SetPrivileged(v bool) *ContainerDetail {
	s.Privileged = &v
	return s
}

// SetReadonlyRootFilesystem sets the ReadonlyRootFilesystem field's value.
func (s *ContainerDetail) SetReadonlyRootFilesystem(v bool) *ContainerDetail {
	s.ReadonlyRootFilesystem = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *ContainerDetail) SetReason(v string) *ContainerDetail {
	s.Reason = &v
	return s
}

// SetTaskArn sets the TaskArn field's value.
func (s *ContainerDetail) SetTaskArn(v string) *ContainerDetail {
	s.TaskArn = &v
	return s
}

// SetUlimits sets the Ulimits field's value.
func (s *ContainerDetail) SetUlimits(v []*Ulimit) *ContainerDetail {
	s.Ulimits = v
	return s
}

// SetUser sets the User field's value.
func (s *ContainerDetail) SetUser(v string) *ContainerDetail {
	s.User = &v
	return s
}

// SetVcpus sets the Vcpus field's value.
func (s *ContainerDetail) SetVcpus(v int64) *ContainerDetail {
	s.Vcpus = &v
	return s
}

// SetVolumes sets the Volumes field's value.
func (s *ContainerDetail) SetVolumes(v []*Volume) *ContainerDetail {
	s.Volumes = v
	return s
}

// The overrides that should be sent to a container.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/ContainerOverrides
type ContainerOverrides struct {
	_ struct{} `type:"structure"`

	// The command to send to the container that overrides the default command from
	// the Docker image or the job definition.
	Command []*string `locationName:"command" type:"list"`

	// The environment variables to send to the container. You can add new environment
	// variables, which are added to the container at launch, or you can override
	// the existing environment variables from the Docker image or the job definition.
	Environment []*KeyValuePair `locationName:"environment" type:"list"`

	// The number of MiB of memory reserved for the job. This value overrides the
	// value set in the job definition.
	Memory *int64 `locationName:"memory" type:"integer"`

	// The number of vCPUs to reserve for the container. This value overrides the
	// value set in the job definition.
	Vcpus *int64 `locationName:"vcpus" type:"integer"`
}

// String returns the string representation
func (s ContainerOverrides) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContainerOverrides) GoString() string {
	return s.String()
}

// SetCommand sets the Command field's value.
func (s *ContainerOverrides) SetCommand(v []*string) *ContainerOverrides {
	s.Command = v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *ContainerOverrides) SetEnvironment(v []*KeyValuePair) *ContainerOverrides {
	s.Environment = v
	return s
}

// SetMemory sets the Memory field's value.
func (s *ContainerOverrides) SetMemory(v int64) *ContainerOverrides {
	s.Memory = &v
	return s
}

// SetVcpus sets the Vcpus field's value.
func (s *ContainerOverrides) SetVcpus(v int64) *ContainerOverrides {
	s.Vcpus = &v
	return s
}

// Container properties are used in job definitions to describe the container
// that is launched as part of a job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/ContainerProperties
type ContainerProperties struct {
	_ struct{} `type:"structure"`

	// The command that is passed to the container. This parameter maps to Cmd in
	// the Create a container (https://docs.docker.com/engine/reference/api/docker_remote_api_v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/reference/api/docker_remote_api_v1.23/)
	// and the COMMAND parameter to docker run (https://docs.docker.com/engine/reference/run/).
	// For more information, see https://docs.docker.com/engine/reference/builder/#cmd
	// (https://docs.docker.com/engine/reference/builder/#cmd).
	Command []*string `locationName:"command" type:"list"`

	// The environment variables to pass to a container. This parameter maps to
	// Env in the Create a container (https://docs.docker.com/engine/reference/api/docker_remote_api_v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/reference/api/docker_remote_api_v1.23/)
	// and the --env option to docker run (https://docs.docker.com/engine/reference/run/).
	//
	// We do not recommend using plain text environment variables for sensitive
	// information, such as credential data.
	Environment []*KeyValuePair `locationName:"environment" type:"list"`

	// The image used to start a container. This string is passed directly to the
	// Docker daemon. Images in the Docker Hub registry are available by default.
	// Other repositories are specified with repository-url/image:tag. Up to 255
	// letters (uppercase and lowercase), numbers, hyphens, underscores, colons,
	// periods, forward slashes, and number signs are allowed. This parameter maps
	// to Image in the Create a container (https://docs.docker.com/engine/reference/api/docker_remote_api_v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/reference/api/docker_remote_api_v1.23/)
	// and the IMAGE parameter of docker run (https://docs.docker.com/engine/reference/run/).
	//
	//    * Images in Amazon ECR repositories use the full registry and repository
	//    URI (for example, 012345678910.dkr.ecr.<region-name>.amazonaws.com/<repository-name>).
	//
	//
	//    * Images in official repositories on Docker Hub use a single name (for
	//    example, ubuntu or mongo).
	//
	//    * Images in other repositories on Docker Hub are qualified with an organization
	//    name (for example, amazon/amazon-ecs-agent).
	//
	//    * Images in other online repositories are qualified further by a domain
	//    name (for example, quay.io/assemblyline/ubuntu).
	//
	// Image is a required field
	Image *string `locationName:"image" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role that the container can assume
	// for AWS permissions.
	JobRoleArn *string `locationName:"jobRoleArn" type:"string"`

	// The hard limit (in MiB) of memory to present to the container. If your container
	// attempts to exceed the memory specified here, the container is killed. This
	// parameter maps to Memory in the Create a container (https://docs.docker.com/engine/reference/api/docker_remote_api_v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/reference/api/docker_remote_api_v1.23/)
	// and the --memory option to docker run (https://docs.docker.com/engine/reference/run/).
	//
	// Memory is a required field
	Memory *int64 `locationName:"memory" type:"integer" required:"true"`

	// The mount points for data volumes in your container. This parameter maps
	// to Volumes in the Create a container (https://docs.docker.com/engine/reference/api/docker_remote_api_v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/reference/api/docker_remote_api_v1.23/)
	// and the --volume option to docker run (https://docs.docker.com/engine/reference/run/).
	MountPoints []*MountPoint `locationName:"mountPoints" type:"list"`

	// When this parameter is true, the container is given elevated privileges on
	// the host container instance (similar to the root user). This parameter maps
	// to Privileged in the Create a container (https://docs.docker.com/engine/reference/api/docker_remote_api_v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/reference/api/docker_remote_api_v1.23/)
	// and the --privileged option to docker run (https://docs.docker.com/engine/reference/run/).
	Privileged *bool `locationName:"privileged" type:"boolean"`

	// When this parameter is true, the container is given read-only access to its
	// root file system. This parameter maps to ReadonlyRootfs in the Create a container
	// (https://docs.docker.com/engine/reference/api/docker_remote_api_v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/reference/api/docker_remote_api_v1.23/)
	// and the --read-only option to docker run.
	ReadonlyRootFilesystem *bool `locationName:"readonlyRootFilesystem" type:"boolean"`

	// A list of ulimits to set in the container. This parameter maps to Ulimits
	// in the Create a container (https://docs.docker.com/engine/reference/api/docker_remote_api_v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/reference/api/docker_remote_api_v1.23/)
	// and the --ulimit option to docker run (https://docs.docker.com/engine/reference/run/).
	Ulimits []*Ulimit `locationName:"ulimits" type:"list"`

	// The user name to use inside the container. This parameter maps to User in
	// the Create a container (https://docs.docker.com/engine/reference/api/docker_remote_api_v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/reference/api/docker_remote_api_v1.23/)
	// and the --user option to docker run (https://docs.docker.com/engine/reference/run/).
	User *string `locationName:"user" type:"string"`

	// The number of vCPUs reserved for the container. This parameter maps to CpuShares
	// in the Create a container (https://docs.docker.com/engine/reference/api/docker_remote_api_v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/reference/api/docker_remote_api_v1.23/)
	// and the --cpu-shares option to docker run (https://docs.docker.com/engine/reference/run/).
	// Each vCPU is equivalent to 1,024 CPU shares.
	//
	// Vcpus is a required field
	Vcpus *int64 `locationName:"vcpus" type:"integer" required:"true"`

	// A list of data volumes used in a job.
	Volumes []*Volume `locationName:"volumes" type:"list"`
}

// String returns the string representation
func (s ContainerProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContainerProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContainerProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContainerProperties"}
	if s.Image == nil {
		invalidParams.Add(request.NewErrParamRequired("Image"))
	}
	if s.Memory == nil {
		invalidParams.Add(request.NewErrParamRequired("Memory"))
	}
	if s.Vcpus == nil {
		invalidParams.Add(request.NewErrParamRequired("Vcpus"))
	}
	if s.Ulimits != nil {
		for i, v := range s.Ulimits {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Ulimits", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCommand sets the Command field's value.
func (s *ContainerProperties) SetCommand(v []*string) *ContainerProperties {
	s.Command = v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *ContainerProperties) SetEnvironment(v []*KeyValuePair) *ContainerProperties {
	s.Environment = v
	return s
}

// SetImage sets the Image field's value.
func (s *ContainerProperties) SetImage(v string) *ContainerProperties {
	s.Image = &v
	return s
}

// SetJobRoleArn sets the JobRoleArn field's value.
func (s *ContainerProperties) SetJobRoleArn(v string) *ContainerProperties {
	s.JobRoleArn = &v
	return s
}

// SetMemory sets the Memory field's value.
func (s *ContainerProperties) SetMemory(v int64) *ContainerProperties {
	s.Memory = &v
	return s
}

// SetMountPoints sets the MountPoints field's value.
func (s *ContainerProperties) SetMountPoints(v []*MountPoint) *ContainerProperties {
	s.MountPoints = v
	return s
}

// SetPrivileged sets the Privileged field's value.
func (s *ContainerProperties) SetPrivileged(v bool) *ContainerProperties {
	s.Privileged = &v
	return s
}

// SetReadonlyRootFilesystem sets the ReadonlyRootFilesystem field's value.
func (s *ContainerProperties) SetReadonlyRootFilesystem(v bool) *ContainerProperties {
	s.ReadonlyRootFilesystem = &v
	return s
}

// SetUlimits sets the Ulimits field's value.
func (s *ContainerProperties) SetUlimits(v []*Ulimit) *ContainerProperties {
	s.Ulimits = v
	return s
}

// SetUser sets the User field's value.
func (s *ContainerProperties) SetUser(v string) *ContainerProperties {
	s.User = &v
	return s
}

// SetVcpus sets the Vcpus field's value.
func (s *ContainerProperties) SetVcpus(v int64) *ContainerProperties {
	s.Vcpus = &v
	return s
}

// SetVolumes sets the Volumes field's value.
func (s *ContainerProperties) SetVolumes(v []*Volume) *ContainerProperties {
	s.Volumes = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/CreateComputeEnvironmentRequest
type CreateComputeEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// The name for your compute environment. Up to 128 letters (uppercase and lowercase),
	// numbers, and underscores are allowed.
	//
	// ComputeEnvironmentName is a required field
	ComputeEnvironmentName *string `locationName:"computeEnvironmentName" type:"string" required:"true"`

	// Details of the compute resources managed by the compute environment. This
	// parameter is required for managed compute environments.
	ComputeResources *ComputeResource `locationName:"computeResources" type:"structure"`

	// The full Amazon Resource Name (ARN) of the IAM role that allows AWS Batch
	// to make calls to other AWS services on your behalf.
	//
	// ServiceRole is a required field
	ServiceRole *string `locationName:"serviceRole" type:"string" required:"true"`

	// The state of the compute environment. If the state is ENABLED, then the compute
	// environment accepts jobs from a queue and can scale out automatically based
	// on queues.
	State *string `locationName:"state" type:"string" enum:"CEState"`

	// The type of the compute environment.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"CEType"`
}

// String returns the string representation
func (s CreateComputeEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateComputeEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateComputeEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateComputeEnvironmentInput"}
	if s.ComputeEnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("ComputeEnvironmentName"))
	}
	if s.ServiceRole == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceRole"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.ComputeResources != nil {
		if err := s.ComputeResources.Validate(); err != nil {
			invalidParams.AddNested("ComputeResources", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComputeEnvironmentName sets the ComputeEnvironmentName field's value.
func (s *CreateComputeEnvironmentInput) SetComputeEnvironmentName(v string) *CreateComputeEnvironmentInput {
	s.ComputeEnvironmentName = &v
	return s
}

// SetComputeResources sets the ComputeResources field's value.
func (s *CreateComputeEnvironmentInput) SetComputeResources(v *ComputeResource) *CreateComputeEnvironmentInput {
	s.ComputeResources = v
	return s
}

// SetServiceRole sets the ServiceRole field's value.
func (s *CreateComputeEnvironmentInput) SetServiceRole(v string) *CreateComputeEnvironmentInput {
	s.ServiceRole = &v
	return s
}

// SetState sets the State field's value.
func (s *CreateComputeEnvironmentInput) SetState(v string) *CreateComputeEnvironmentInput {
	s.State = &v
	return s
}

// SetType sets the Type field's value.
func (s *CreateComputeEnvironmentInput) SetType(v string) *CreateComputeEnvironmentInput {
	s.Type = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/CreateComputeEnvironmentResponse
type CreateComputeEnvironmentOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the compute environment.
	ComputeEnvironmentArn *string `locationName:"computeEnvironmentArn" type:"string"`

	// The name of the compute environment.
	ComputeEnvironmentName *string `locationName:"computeEnvironmentName" type:"string"`
}

// String returns the string representation
func (s CreateComputeEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateComputeEnvironmentOutput) GoString() string {
	return s.String()
}

// SetComputeEnvironmentArn sets the ComputeEnvironmentArn field's value.
func (s *CreateComputeEnvironmentOutput) SetComputeEnvironmentArn(v string) *CreateComputeEnvironmentOutput {
	s.ComputeEnvironmentArn = &v
	return s
}

// SetComputeEnvironmentName sets the ComputeEnvironmentName field's value.
func (s *CreateComputeEnvironmentOutput) SetComputeEnvironmentName(v string) *CreateComputeEnvironmentOutput {
	s.ComputeEnvironmentName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/CreateJobQueueRequest
type CreateJobQueueInput struct {
	_ struct{} `type:"structure"`

	// The set of compute environments mapped to a job queue and their order relative
	// to each other. The job scheduler uses this parameter to determine which compute
	// environment should execute a given job. Compute environments must be in the
	// VALID state before you can associate them with a job queue. You can associate
	// up to 3 compute environments with a job queue.
	//
	// ComputeEnvironmentOrder is a required field
	ComputeEnvironmentOrder []*ComputeEnvironmentOrder `locationName:"computeEnvironmentOrder" type:"list" required:"true"`

	// The name of the job queue.
	//
	// JobQueueName is a required field
	JobQueueName *string `locationName:"jobQueueName" type:"string" required:"true"`

	// The priority of the job queue. Job queues with a higher priority (or a lower
	// integer value for the priority parameter) are evaluated first when associated
	// with same compute environment. Priority is determined in ascending order,
	// for example, a job queue with a priority value of 1 is given scheduling preference
	// over a job queue with a priority value of 10.
	//
	// Priority is a required field
	Priority *int64 `locationName:"priority" type:"integer" required:"true"`

	// The state of the job queue. If the job queue state is ENABLED, it is able
	// to accept jobs.
	State *string `locationName:"state" type:"string" enum:"JQState"`
}

// String returns the string representation
func (s CreateJobQueueInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateJobQueueInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateJobQueueInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateJobQueueInput"}
	if s.ComputeEnvironmentOrder == nil {
		invalidParams.Add(request.NewErrParamRequired("ComputeEnvironmentOrder"))
	}
	if s.JobQueueName == nil {
		invalidParams.Add(request.NewErrParamRequired("JobQueueName"))
	}
	if s.Priority == nil {
		invalidParams.Add(request.NewErrParamRequired("Priority"))
	}
	if s.ComputeEnvironmentOrder != nil {
		for i, v := range s.ComputeEnvironmentOrder {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ComputeEnvironmentOrder", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComputeEnvironmentOrder sets the ComputeEnvironmentOrder field's value.
func (s *CreateJobQueueInput) SetComputeEnvironmentOrder(v []*ComputeEnvironmentOrder) *CreateJobQueueInput {
	s.ComputeEnvironmentOrder = v
	return s
}

// SetJobQueueName sets the JobQueueName field's value.
func (s *CreateJobQueueInput) SetJobQueueName(v string) *CreateJobQueueInput {
	s.JobQueueName = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *CreateJobQueueInput) SetPriority(v int64) *CreateJobQueueInput {
	s.Priority = &v
	return s
}

// SetState sets the State field's value.
func (s *CreateJobQueueInput) SetState(v string) *CreateJobQueueInput {
	s.State = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/CreateJobQueueResponse
type CreateJobQueueOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the job queue.
	//
	// JobQueueArn is a required field
	JobQueueArn *string `locationName:"jobQueueArn" type:"string" required:"true"`

	// The name of the job queue.
	//
	// JobQueueName is a required field
	JobQueueName *string `locationName:"jobQueueName" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateJobQueueOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateJobQueueOutput) GoString() string {
	return s.String()
}

// SetJobQueueArn sets the JobQueueArn field's value.
func (s *CreateJobQueueOutput) SetJobQueueArn(v string) *CreateJobQueueOutput {
	s.JobQueueArn = &v
	return s
}

// SetJobQueueName sets the JobQueueName field's value.
func (s *CreateJobQueueOutput) SetJobQueueName(v string) *CreateJobQueueOutput {
	s.JobQueueName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DeleteComputeEnvironmentRequest
type DeleteComputeEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) of the compute environment to delete.
	//
	// ComputeEnvironment is a required field
	ComputeEnvironment *string `locationName:"computeEnvironment" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteComputeEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteComputeEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteComputeEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteComputeEnvironmentInput"}
	if s.ComputeEnvironment == nil {
		invalidParams.Add(request.NewErrParamRequired("ComputeEnvironment"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComputeEnvironment sets the ComputeEnvironment field's value.
func (s *DeleteComputeEnvironmentInput) SetComputeEnvironment(v string) *DeleteComputeEnvironmentInput {
	s.ComputeEnvironment = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DeleteComputeEnvironmentResponse
type DeleteComputeEnvironmentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteComputeEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteComputeEnvironmentOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DeleteJobQueueRequest
type DeleteJobQueueInput struct {
	_ struct{} `type:"structure"`

	// The short name or full Amazon Resource Name (ARN) of the queue to delete.
	//
	// JobQueue is a required field
	JobQueue *string `locationName:"jobQueue" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteJobQueueInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteJobQueueInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteJobQueueInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteJobQueueInput"}
	if s.JobQueue == nil {
		invalidParams.Add(request.NewErrParamRequired("JobQueue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobQueue sets the JobQueue field's value.
func (s *DeleteJobQueueInput) SetJobQueue(v string) *DeleteJobQueueInput {
	s.JobQueue = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DeleteJobQueueResponse
type DeleteJobQueueOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteJobQueueOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteJobQueueOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DeregisterJobDefinitionRequest
type DeregisterJobDefinitionInput struct {
	_ struct{} `type:"structure"`

	// The name and revision (name:revision) or full Amazon Resource Name (ARN)
	// of the job definition to deregister.
	//
	// JobDefinition is a required field
	JobDefinition *string `locationName:"jobDefinition" type:"string" required:"true"`
}

// String returns the string representation
func (s DeregisterJobDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterJobDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterJobDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterJobDefinitionInput"}
	if s.JobDefinition == nil {
		invalidParams.Add(request.NewErrParamRequired("JobDefinition"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobDefinition sets the JobDefinition field's value.
func (s *DeregisterJobDefinitionInput) SetJobDefinition(v string) *DeregisterJobDefinitionInput {
	s.JobDefinition = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DeregisterJobDefinitionResponse
type DeregisterJobDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeregisterJobDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterJobDefinitionOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DescribeComputeEnvironmentsRequest
type DescribeComputeEnvironmentsInput struct {
	_ struct{} `type:"structure"`

	// A list of up to 100 compute environment names or full Amazon Resource Name
	// (ARN) entries.
	ComputeEnvironments []*string `locationName:"computeEnvironments" type:"list"`

	// The maximum number of cluster results returned by DescribeComputeEnvironments
	// in paginated output. When this parameter is used, DescribeComputeEnvironments
	// only returns maxResults results in a single page along with a nextToken response
	// element. The remaining results of the initial request can be seen by sending
	// another DescribeComputeEnvironments request with the returned nextToken value.
	// This value can be between 1 and 100. If this parameter is not used, then
	// DescribeComputeEnvironments returns up to 100 results and a nextToken value
	// if applicable.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The nextToken value returned from a previous paginated DescribeComputeEnvironments
	// request where maxResults was used and the results exceeded the value of that
	// parameter. Pagination continues from the end of the previous results that
	// returned the nextToken value. This value is null when there are no more results
	// to return.
	//
	// This token should be treated as an opaque identifier that is only used to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeComputeEnvironmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeComputeEnvironmentsInput) GoString() string {
	return s.String()
}

// SetComputeEnvironments sets the ComputeEnvironments field's value.
func (s *DescribeComputeEnvironmentsInput) SetComputeEnvironments(v []*string) *DescribeComputeEnvironmentsInput {
	s.ComputeEnvironments = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeComputeEnvironmentsInput) SetMaxResults(v int64) *DescribeComputeEnvironmentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeComputeEnvironmentsInput) SetNextToken(v string) *DescribeComputeEnvironmentsInput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DescribeComputeEnvironmentsResponse
type DescribeComputeEnvironmentsOutput struct {
	_ struct{} `type:"structure"`

	// The list of compute environments.
	ComputeEnvironments []*ComputeEnvironmentDetail `locationName:"computeEnvironments" type:"list"`

	// The nextToken value to include in a future DescribeComputeEnvironments request.
	// When the results of a DescribeJobDefinitions request exceed maxResults, this
	// value can be used to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeComputeEnvironmentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeComputeEnvironmentsOutput) GoString() string {
	return s.String()
}

// SetComputeEnvironments sets the ComputeEnvironments field's value.
func (s *DescribeComputeEnvironmentsOutput) SetComputeEnvironments(v []*ComputeEnvironmentDetail) *DescribeComputeEnvironmentsOutput {
	s.ComputeEnvironments = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeComputeEnvironmentsOutput) SetNextToken(v string) *DescribeComputeEnvironmentsOutput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DescribeJobDefinitionsRequest
type DescribeJobDefinitionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the job definition to describe.
	JobDefinitionName *string `locationName:"jobDefinitionName" type:"string"`

	// A space-separated list of up to 100 job definition names or full Amazon Resource
	// Name (ARN) entries.
	JobDefinitions []*string `locationName:"jobDefinitions" type:"list"`

	// The maximum number of results returned by DescribeJobDefinitions in paginated
	// output. When this parameter is used, DescribeJobDefinitions only returns
	// maxResults results in a single page along with a nextToken response element.
	// The remaining results of the initial request can be seen by sending another
	// DescribeJobDefinitions request with the returned nextToken value. This value
	// can be between 1 and 100. If this parameter is not used, then DescribeJobDefinitions
	// returns up to 100 results and a nextToken value if applicable.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The nextToken value returned from a previous paginated DescribeJobDefinitions
	// request where maxResults was used and the results exceeded the value of that
	// parameter. Pagination continues from the end of the previous results that
	// returned the nextToken value. This value is null when there are no more results
	// to return.
	//
	// This token should be treated as an opaque identifier that is only used to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The status with which to filter job definitions.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s DescribeJobDefinitionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeJobDefinitionsInput) GoString() string {
	return s.String()
}

// SetJobDefinitionName sets the JobDefinitionName field's value.
func (s *DescribeJobDefinitionsInput) SetJobDefinitionName(v string) *DescribeJobDefinitionsInput {
	s.JobDefinitionName = &v
	return s
}

// SetJobDefinitions sets the JobDefinitions field's value.
func (s *DescribeJobDefinitionsInput) SetJobDefinitions(v []*string) *DescribeJobDefinitionsInput {
	s.JobDefinitions = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeJobDefinitionsInput) SetMaxResults(v int64) *DescribeJobDefinitionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeJobDefinitionsInput) SetNextToken(v string) *DescribeJobDefinitionsInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeJobDefinitionsInput) SetStatus(v string) *DescribeJobDefinitionsInput {
	s.Status = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DescribeJobDefinitionsResponse
type DescribeJobDefinitionsOutput struct {
	_ struct{} `type:"structure"`

	// The list of job definitions.
	JobDefinitions []*JobDefinition `locationName:"jobDefinitions" type:"list"`

	// The nextToken value to include in a future DescribeJobDefinitions request.
	// When the results of a DescribeJobDefinitions request exceed maxResults, this
	// value can be used to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeJobDefinitionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeJobDefinitionsOutput) GoString() string {
	return s.String()
}

// SetJobDefinitions sets the JobDefinitions field's value.
func (s *DescribeJobDefinitionsOutput) SetJobDefinitions(v []*JobDefinition) *DescribeJobDefinitionsOutput {
	s.JobDefinitions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeJobDefinitionsOutput) SetNextToken(v string) *DescribeJobDefinitionsOutput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DescribeJobQueuesRequest
type DescribeJobQueuesInput struct {
	_ struct{} `type:"structure"`

	// A list of up to 100 queue names or full queue Amazon Resource Name (ARN)
	// entries.
	JobQueues []*string `locationName:"jobQueues" type:"list"`

	// The maximum number of results returned by DescribeJobQueues in paginated
	// output. When this parameter is used, DescribeJobQueues only returns maxResults
	// results in a single page along with a nextToken response element. The remaining
	// results of the initial request can be seen by sending another DescribeJobQueues
	// request with the returned nextToken value. This value can be between 1 and
	// 100. If this parameter is not used, then DescribeJobQueues returns up to
	// 100 results and a nextToken value if applicable.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The nextToken value returned from a previous paginated DescribeJobQueues
	// request where maxResults was used and the results exceeded the value of that
	// parameter. Pagination continues from the end of the previous results that
	// returned the nextToken value. This value is null when there are no more results
	// to return.
	//
	// This token should be treated as an opaque identifier that is only used to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeJobQueuesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeJobQueuesInput) GoString() string {
	return s.String()
}

// SetJobQueues sets the JobQueues field's value.
func (s *DescribeJobQueuesInput) SetJobQueues(v []*string) *DescribeJobQueuesInput {
	s.JobQueues = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeJobQueuesInput) SetMaxResults(v int64) *DescribeJobQueuesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeJobQueuesInput) SetNextToken(v string) *DescribeJobQueuesInput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DescribeJobQueuesResponse
type DescribeJobQueuesOutput struct {
	_ struct{} `type:"structure"`

	// The list of job queues.
	JobQueues []*JobQueueDetail `locationName:"jobQueues" type:"list"`

	// The nextToken value to include in a future DescribeJobQueues request. When
	// the results of a DescribeJobQueues request exceed maxResults, this value
	// can be used to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeJobQueuesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeJobQueuesOutput) GoString() string {
	return s.String()
}

// SetJobQueues sets the JobQueues field's value.
func (s *DescribeJobQueuesOutput) SetJobQueues(v []*JobQueueDetail) *DescribeJobQueuesOutput {
	s.JobQueues = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeJobQueuesOutput) SetNextToken(v string) *DescribeJobQueuesOutput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DescribeJobsRequest
type DescribeJobsInput struct {
	_ struct{} `type:"structure"`

	// A space-separated list of up to 100 job IDs.
	//
	// Jobs is a required field
	Jobs []*string `locationName:"jobs" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeJobsInput"}
	if s.Jobs == nil {
		invalidParams.Add(request.NewErrParamRequired("Jobs"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobs sets the Jobs field's value.
func (s *DescribeJobsInput) SetJobs(v []*string) *DescribeJobsInput {
	s.Jobs = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DescribeJobsResponse
type DescribeJobsOutput struct {
	_ struct{} `type:"structure"`

	// The list of jobs.
	Jobs []*JobDetail `locationName:"jobs" type:"list"`
}

// String returns the string representation
func (s DescribeJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeJobsOutput) GoString() string {
	return s.String()
}

// SetJobs sets the Jobs field's value.
func (s *DescribeJobsOutput) SetJobs(v []*JobDetail) *DescribeJobsOutput {
	s.Jobs = v
	return s
}

// The contents of the host parameter determine whether your data volume persists
// on the host container instance and where it is stored. If the host parameter
// is empty, then the Docker daemon assigns a host path for your data volume,
// but the data is not guaranteed to persist after the containers associated
// with it stop running.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/Host
type Host struct {
	_ struct{} `type:"structure"`

	// The path on the host container instance that is presented to the container.
	// If this parameter is empty, then the Docker daemon has assigned a host path
	// for you. If the host parameter contains a sourcePath file location, then
	// the data volume persists at the specified location on the host container
	// instance until you delete it manually. If the sourcePath value does not exist
	// on the host container instance, the Docker daemon creates it. If the location
	// does exist, the contents of the source path folder are exported.
	SourcePath *string `locationName:"sourcePath" type:"string"`
}

// String returns the string representation
func (s Host) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Host) GoString() string {
	return s.String()
}

// SetSourcePath sets the SourcePath field's value.
func (s *Host) SetSourcePath(v string) *Host {
	s.SourcePath = &v
	return s
}

// An object representing an AWS Batch job definition.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/JobDefinition
type JobDefinition struct {
	_ struct{} `type:"structure"`

	// An object with various properties specific to container-based jobs.
	ContainerProperties *ContainerProperties `locationName:"containerProperties" type:"structure"`

	// The Amazon Resource Name (ARN) for the job definition.
	//
	// JobDefinitionArn is a required field
	JobDefinitionArn *string `locationName:"jobDefinitionArn" type:"string" required:"true"`

	// The name of the job definition.
	//
	// JobDefinitionName is a required field
	JobDefinitionName *string `locationName:"jobDefinitionName" type:"string" required:"true"`

	// Default parameters or parameter substitution placeholders that are set in
	// the job definition. Parameters are specified as a key-value pair mapping.
	// Parameters in a SubmitJob request override any corresponding parameter defaults
	// from the job definition.
	Parameters map[string]*string `locationName:"parameters" type:"map"`

	// The retry strategy to use for failed jobs that are submitted with this job
	// definition.
	RetryStrategy *RetryStrategy `locationName:"retryStrategy" type:"structure"`

	// The revision of the job definition.
	//
	// Revision is a required field
	Revision *int64 `locationName:"revision" type:"integer" required:"true"`

	// The status of the job definition.
	Status *string `locationName:"status" type:"string"`

	// The type of job definition.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true"`
}

// String returns the string representation
func (s JobDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobDefinition) GoString() string {
	return s.String()
}

// SetContainerProperties sets the ContainerProperties field's value.
func (s *JobDefinition) SetContainerProperties(v *ContainerProperties) *JobDefinition {
	s.ContainerProperties = v
	return s
}

// SetJobDefinitionArn sets the JobDefinitionArn field's value.
func (s *JobDefinition) SetJobDefinitionArn(v string) *JobDefinition {
	s.JobDefinitionArn = &v
	return s
}

// SetJobDefinitionName sets the JobDefinitionName field's value.
func (s *JobDefinition) SetJobDefinitionName(v string) *JobDefinition {
	s.JobDefinitionName = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *JobDefinition) SetParameters(v map[string]*string) *JobDefinition {
	s.Parameters = v
	return s
}

// SetRetryStrategy sets the RetryStrategy field's value.
func (s *JobDefinition) SetRetryStrategy(v *RetryStrategy) *JobDefinition {
	s.RetryStrategy = v
	return s
}

// SetRevision sets the Revision field's value.
func (s *JobDefinition) SetRevision(v int64) *JobDefinition {
	s.Revision = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *JobDefinition) SetStatus(v string) *JobDefinition {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *JobDefinition) SetType(v string) *JobDefinition {
	s.Type = &v
	return s
}

// An object representing an AWS Batch job dependency.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/JobDependency
type JobDependency struct {
	_ struct{} `type:"structure"`

	// The job ID of the AWS Batch job associated with this dependency.
	JobId *string `locationName:"jobId" type:"string"`
}

// String returns the string representation
func (s JobDependency) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobDependency) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *JobDependency) SetJobId(v string) *JobDependency {
	s.JobId = &v
	return s
}

// An object representing an AWS Batch job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/JobDetail
type JobDetail struct {
	_ struct{} `type:"structure"`

	// A list of job attempts associated with this job.
	Attempts []*AttemptDetail `locationName:"attempts" type:"list"`

	// An object representing the details of the container that is associated with
	// the job.
	Container *ContainerDetail `locationName:"container" type:"structure"`

	// The Unix timestamp for when the job was created (when the task entered the
	// PENDING state).
	CreatedAt *int64 `locationName:"createdAt" type:"long"`

	// A list of job names or IDs on which this job depends.
	DependsOn []*JobDependency `locationName:"dependsOn" type:"list"`

	// The job definition that is used by this job.
	//
	// JobDefinition is a required field
	JobDefinition *string `locationName:"jobDefinition" type:"string" required:"true"`

	// The ID for the job.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`

	// The name of the job.
	//
	// JobName is a required field
	JobName *string `locationName:"jobName" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the job queue with which the job is associated.
	//
	// JobQueue is a required field
	JobQueue *string `locationName:"jobQueue" type:"string" required:"true"`

	// Additional parameters passed to the job that replace parameter substitution
	// placeholders or override any corresponding parameter defaults from the job
	// definition.
	Parameters map[string]*string `locationName:"parameters" type:"map"`

	// The retry strategy to use for this job if an attempt fails.
	RetryStrategy *RetryStrategy `locationName:"retryStrategy" type:"structure"`

	// The Unix timestamp for when the job was started (when the task transitioned
	// from the PENDING state to the RUNNING state).
	//
	// StartedAt is a required field
	StartedAt *int64 `locationName:"startedAt" type:"long" required:"true"`

	// The current status for the job.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"JobStatus"`

	// A short, human-readable string to provide additional details about the current
	// status of the job.
	StatusReason *string `locationName:"statusReason" type:"string"`

	// The Unix timestamp for when the job was stopped (when the task transitioned
	// from the RUNNING state to the STOPPED state).
	StoppedAt *int64 `locationName:"stoppedAt" type:"long"`
}

// String returns the string representation
func (s JobDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobDetail) GoString() string {
	return s.String()
}

// SetAttempts sets the Attempts field's value.
func (s *JobDetail) SetAttempts(v []*AttemptDetail) *JobDetail {
	s.Attempts = v
	return s
}

// SetContainer sets the Container field's value.
func (s *JobDetail) SetContainer(v *ContainerDetail) *JobDetail {
	s.Container = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *JobDetail) SetCreatedAt(v int64) *JobDetail {
	s.CreatedAt = &v
	return s
}

// SetDependsOn sets the DependsOn field's value.
func (s *JobDetail) SetDependsOn(v []*JobDependency) *JobDetail {
	s.DependsOn = v
	return s
}

// SetJobDefinition sets the JobDefinition field's value.
func (s *JobDetail) SetJobDefinition(v string) *JobDetail {
	s.JobDefinition = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *JobDetail) SetJobId(v string) *JobDetail {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *JobDetail) SetJobName(v string) *JobDetail {
	s.JobName = &v
	return s
}

// SetJobQueue sets the JobQueue field's value.
func (s *JobDetail) SetJobQueue(v string) *JobDetail {
	s.JobQueue = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *JobDetail) SetParameters(v map[string]*string) *JobDetail {
	s.Parameters = v
	return s
}

// SetRetryStrategy sets the RetryStrategy field's value.
func (s *JobDetail) SetRetryStrategy(v *RetryStrategy) *JobDetail {
	s.RetryStrategy = v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *JobDetail) SetStartedAt(v int64) *JobDetail {
	s.StartedAt = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *JobDetail) SetStatus(v string) *JobDetail {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *JobDetail) SetStatusReason(v string) *JobDetail {
	s.StatusReason = &v
	return s
}

// SetStoppedAt sets the StoppedAt field's value.
func (s *JobDetail) SetStoppedAt(v int64) *JobDetail {
	s.StoppedAt = &v
	return s
}

// An object representing the details of an AWS Batch job queue.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/JobQueueDetail
type JobQueueDetail struct {
	_ struct{} `type:"structure"`

	// The compute environments that are attached to the job queue and the order
	// in which job placement is preferred. Compute environments are selected for
	// job placement in ascending order.
	//
	// ComputeEnvironmentOrder is a required field
	ComputeEnvironmentOrder []*ComputeEnvironmentOrder `locationName:"computeEnvironmentOrder" type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the job queue.
	//
	// JobQueueArn is a required field
	JobQueueArn *string `locationName:"jobQueueArn" type:"string" required:"true"`

	// The name of the job queue.
	//
	// JobQueueName is a required field
	JobQueueName *string `locationName:"jobQueueName" type:"string" required:"true"`

	// The priority of the job queue.
	//
	// Priority is a required field
	Priority *int64 `locationName:"priority" type:"integer" required:"true"`

	// Describes the ability of the queue to accept new jobs.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"JQState"`

	// The status of the job queue (for example, CREATING or VALID).
	Status *string `locationName:"status" type:"string" enum:"JQStatus"`

	// A short, human-readable string to provide additional details about the current
	// status of the job queue.
	StatusReason *string `locationName:"statusReason" type:"string"`
}

// String returns the string representation
func (s JobQueueDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobQueueDetail) GoString() string {
	return s.String()
}

// SetComputeEnvironmentOrder sets the ComputeEnvironmentOrder field's value.
func (s *JobQueueDetail) SetComputeEnvironmentOrder(v []*ComputeEnvironmentOrder) *JobQueueDetail {
	s.ComputeEnvironmentOrder = v
	return s
}

// SetJobQueueArn sets the JobQueueArn field's value.
func (s *JobQueueDetail) SetJobQueueArn(v string) *JobQueueDetail {
	s.JobQueueArn = &v
	return s
}

// SetJobQueueName sets the JobQueueName field's value.
func (s *JobQueueDetail) SetJobQueueName(v string) *JobQueueDetail {
	s.JobQueueName = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *JobQueueDetail) SetPriority(v int64) *JobQueueDetail {
	s.Priority = &v
	return s
}

// SetState sets the State field's value.
func (s *JobQueueDetail) SetState(v string) *JobQueueDetail {
	s.State = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *JobQueueDetail) SetStatus(v string) *JobQueueDetail {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *JobQueueDetail) SetStatusReason(v string) *JobQueueDetail {
	s.StatusReason = &v
	return s
}

// An object representing summary details of a job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/JobSummary
type JobSummary struct {
	_ struct{} `type:"structure"`

	// The ID of the job.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`

	// The name of the job.
	//
	// JobName is a required field
	JobName *string `locationName:"jobName" type:"string" required:"true"`
}

// String returns the string representation
func (s JobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobSummary) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *JobSummary) SetJobId(v string) *JobSummary {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *JobSummary) SetJobName(v string) *JobSummary {
	s.JobName = &v
	return s
}

// A key-value pair object.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/KeyValuePair
type KeyValuePair struct {
	_ struct{} `type:"structure"`

	// The name of the key value pair. For environment variables, this is the name
	// of the environment variable.
	Name *string `locationName:"name" type:"string"`

	// The value of the key value pair. For environment variables, this is the value
	// of the environment variable.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s KeyValuePair) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyValuePair) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *KeyValuePair) SetName(v string) *KeyValuePair {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *KeyValuePair) SetValue(v string) *KeyValuePair {
	s.Value = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/ListJobsRequest
type ListJobsInput struct {
	_ struct{} `type:"structure"`

	// The name or full Amazon Resource Name (ARN) of the job queue with which to
	// list jobs.
	//
	// JobQueue is a required field
	JobQueue *string `locationName:"jobQueue" type:"string" required:"true"`

	// The job status with which to filter jobs in the specified queue.
	JobStatus *string `locationName:"jobStatus" type:"string" enum:"JobStatus"`

	// The maximum number of results returned by ListJobs in paginated output. When
	// this parameter is used, ListJobs only returns maxResults results in a single
	// page along with a nextToken response element. The remaining results of the
	// initial request can be seen by sending another ListJobs request with the
	// returned nextToken value. This value can be between 1 and 100. If this parameter
	// is not used, then ListJobs returns up to 100 results and a nextToken value
	// if applicable.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The nextToken value returned from a previous paginated ListJobs request where
	// maxResults was used and the results exceeded the value of that parameter.
	// Pagination continues from the end of the previous results that returned the
	// nextToken value. This value is null when there are no more results to return.
	//
	// This token should be treated as an opaque identifier that is only used to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListJobsInput"}
	if s.JobQueue == nil {
		invalidParams.Add(request.NewErrParamRequired("JobQueue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobQueue sets the JobQueue field's value.
func (s *ListJobsInput) SetJobQueue(v string) *ListJobsInput {
	s.JobQueue = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *ListJobsInput) SetJobStatus(v string) *ListJobsInput {
	s.JobStatus = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListJobsInput) SetMaxResults(v int64) *ListJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJobsInput) SetNextToken(v string) *ListJobsInput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/ListJobsResponse
type ListJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list of job summaries that match the request.
	//
	// JobSummaryList is a required field
	JobSummaryList []*JobSummary `locationName:"jobSummaryList" type:"list" required:"true"`

	// The nextToken value to include in a future ListJobs request. When the results
	// of a ListJobs request exceed maxResults, this value can be used to retrieve
	// the next page of results. This value is null when there are no more results
	// to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListJobsOutput) GoString() string {
	return s.String()
}

// SetJobSummaryList sets the JobSummaryList field's value.
func (s *ListJobsOutput) SetJobSummaryList(v []*JobSummary) *ListJobsOutput {
	s.JobSummaryList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJobsOutput) SetNextToken(v string) *ListJobsOutput {
	s.NextToken = &v
	return s
}

// Details on a Docker volume mount point that is used in a job's container
// properties.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/MountPoint
type MountPoint struct {
	_ struct{} `type:"structure"`

	// The path on the container at which to mount the host volume.
	ContainerPath *string `locationName:"containerPath" type:"string"`

	// If this value is true, the container has read-only access to the volume;
	// otherwise, the container can write to the volume. The default value is false.
	ReadOnly *bool `locationName:"readOnly" type:"boolean"`

	// The name of the volume to mount.
	SourceVolume *string `locationName:"sourceVolume" type:"string"`
}

// String returns the string representation
func (s MountPoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MountPoint) GoString() string {
	return s.String()
}

// SetContainerPath sets the ContainerPath field's value.
func (s *MountPoint) SetContainerPath(v string) *MountPoint {
	s.ContainerPath = &v
	return s
}

// SetReadOnly sets the ReadOnly field's value.
func (s *MountPoint) SetReadOnly(v bool) *MountPoint {
	s.ReadOnly = &v
	return s
}

// SetSourceVolume sets the SourceVolume field's value.
func (s *MountPoint) SetSourceVolume(v string) *MountPoint {
	s.SourceVolume = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/RegisterJobDefinitionRequest
type RegisterJobDefinitionInput struct {
	_ struct{} `type:"structure"`

	// An object with various properties specific for container-based jobs. This
	// parameter is required if the type parameter is container.
	ContainerProperties *ContainerProperties `locationName:"containerProperties" type:"structure"`

	// The name of the job definition to register.
	//
	// JobDefinitionName is a required field
	JobDefinitionName *string `locationName:"jobDefinitionName" type:"string" required:"true"`

	// Default parameter substitution placeholders to set in the job definition.
	// Parameters are specified as a key-value pair mapping. Parameters in a SubmitJob
	// request override any corresponding parameter defaults from the job definition.
	Parameters map[string]*string `locationName:"parameters" type:"map"`

	// The retry strategy to use for failed jobs that are submitted with this job
	// definition. Any retry strategy that is specified during a SubmitJob operation
	// overrides the retry strategy defined here.
	RetryStrategy *RetryStrategy `locationName:"retryStrategy" type:"structure"`

	// The type of job definition.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"JobDefinitionType"`
}

// String returns the string representation
func (s RegisterJobDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterJobDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterJobDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterJobDefinitionInput"}
	if s.JobDefinitionName == nil {
		invalidParams.Add(request.NewErrParamRequired("JobDefinitionName"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.ContainerProperties != nil {
		if err := s.ContainerProperties.Validate(); err != nil {
			invalidParams.AddNested("ContainerProperties", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerProperties sets the ContainerProperties field's value.
func (s *RegisterJobDefinitionInput) SetContainerProperties(v *ContainerProperties) *RegisterJobDefinitionInput {
	s.ContainerProperties = v
	return s
}

// SetJobDefinitionName sets the JobDefinitionName field's value.
func (s *RegisterJobDefinitionInput) SetJobDefinitionName(v string) *RegisterJobDefinitionInput {
	s.JobDefinitionName = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *RegisterJobDefinitionInput) SetParameters(v map[string]*string) *RegisterJobDefinitionInput {
	s.Parameters = v
	return s
}

// SetRetryStrategy sets the RetryStrategy field's value.
func (s *RegisterJobDefinitionInput) SetRetryStrategy(v *RetryStrategy) *RegisterJobDefinitionInput {
	s.RetryStrategy = v
	return s
}

// SetType sets the Type field's value.
func (s *RegisterJobDefinitionInput) SetType(v string) *RegisterJobDefinitionInput {
	s.Type = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/RegisterJobDefinitionResponse
type RegisterJobDefinitionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the job definition.
	//
	// JobDefinitionArn is a required field
	JobDefinitionArn *string `locationName:"jobDefinitionArn" type:"string" required:"true"`

	// The name of the job definition.
	//
	// JobDefinitionName is a required field
	JobDefinitionName *string `locationName:"jobDefinitionName" type:"string" required:"true"`

	// The revision of the job definition.
	//
	// Revision is a required field
	Revision *int64 `locationName:"revision" type:"integer" required:"true"`
}

// String returns the string representation
func (s RegisterJobDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterJobDefinitionOutput) GoString() string {
	return s.String()
}

// SetJobDefinitionArn sets the JobDefinitionArn field's value.
func (s *RegisterJobDefinitionOutput) SetJobDefinitionArn(v string) *RegisterJobDefinitionOutput {
	s.JobDefinitionArn = &v
	return s
}

// SetJobDefinitionName sets the JobDefinitionName field's value.
func (s *RegisterJobDefinitionOutput) SetJobDefinitionName(v string) *RegisterJobDefinitionOutput {
	s.JobDefinitionName = &v
	return s
}

// SetRevision sets the Revision field's value.
func (s *RegisterJobDefinitionOutput) SetRevision(v int64) *RegisterJobDefinitionOutput {
	s.Revision = &v
	return s
}

// The retry strategy associated with a job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/RetryStrategy
type RetryStrategy struct {
	_ struct{} `type:"structure"`

	// The number of times to move a job to the RUNNABLE status. You may specify
	// between 1 and 10 attempts. If attempts is greater than one, the job is retried
	// if it fails until it has moved to RUNNABLE that many times.
	Attempts *int64 `locationName:"attempts" type:"integer"`
}

// String returns the string representation
func (s RetryStrategy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RetryStrategy) GoString() string {
	return s.String()
}

// SetAttempts sets the Attempts field's value.
func (s *RetryStrategy) SetAttempts(v int64) *RetryStrategy {
	s.Attempts = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/SubmitJobRequest
type SubmitJobInput struct {
	_ struct{} `type:"structure"`

	// A list of container overrides in JSON format that specify the name of a container
	// in the specified job definition and the overrides it should receive. You
	// can override the default command for a container (that is specified in the
	// job definition or the Docker image) with a command override. You can also
	// override existing environment variables (that are specified in the job definition
	// or Docker image) on a container or add new environment variables to it with
	// an environment override.
	ContainerOverrides *ContainerOverrides `locationName:"containerOverrides" type:"structure"`

	// A list of job IDs on which this job depends. A job can depend upon a maximum
	// of 100 jobs.
	DependsOn []*JobDependency `locationName:"dependsOn" type:"list"`

	// The job definition used by this job. This value can be either a name:revision
	// or the Amazon Resource Name (ARN) for the job definition.
	//
	// JobDefinition is a required field
	JobDefinition *string `locationName:"jobDefinition" type:"string" required:"true"`

	// The name of the job. A name must be 1 to 128 characters in length.
	//
	// Pattern: ^[a-zA-Z0-9_]+$
	//
	// JobName is a required field
	JobName *string `locationName:"jobName" type:"string" required:"true"`

	// The job queue into which the job will be submitted. You can specify either
	// the name or the Amazon Resource Name (ARN) of the queue.
	//
	// JobQueue is a required field
	JobQueue *string `locationName:"jobQueue" type:"string" required:"true"`

	// Additional parameters passed to the job that replace parameter substitution
	// placeholders that are set in the job definition. Parameters are specified
	// as a key and value pair mapping. Parameters in a SubmitJob request override
	// any corresponding parameter defaults from the job definition.
	Parameters map[string]*string `locationName:"parameters" type:"map"`

	// The retry strategy to use for failed jobs from this SubmitJob operation.
	// When a retry strategy is specified here, it overrides the retry strategy
	// defined in the job definition.
	RetryStrategy *RetryStrategy `locationName:"retryStrategy" type:"structure"`
}

// String returns the string representation
func (s SubmitJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SubmitJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SubmitJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SubmitJobInput"}
	if s.JobDefinition == nil {
		invalidParams.Add(request.NewErrParamRequired("JobDefinition"))
	}
	if s.JobName == nil {
		invalidParams.Add(request.NewErrParamRequired("JobName"))
	}
	if s.JobQueue == nil {
		invalidParams.Add(request.NewErrParamRequired("JobQueue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerOverrides sets the ContainerOverrides field's value.
func (s *SubmitJobInput) SetContainerOverrides(v *ContainerOverrides) *SubmitJobInput {
	s.ContainerOverrides = v
	return s
}

// SetDependsOn sets the DependsOn field's value.
func (s *SubmitJobInput) SetDependsOn(v []*JobDependency) *SubmitJobInput {
	s.DependsOn = v
	return s
}

// SetJobDefinition sets the JobDefinition field's value.
func (s *SubmitJobInput) SetJobDefinition(v string) *SubmitJobInput {
	s.JobDefinition = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *SubmitJobInput) SetJobName(v string) *SubmitJobInput {
	s.JobName = &v
	return s
}

// SetJobQueue sets the JobQueue field's value.
func (s *SubmitJobInput) SetJobQueue(v string) *SubmitJobInput {
	s.JobQueue = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *SubmitJobInput) SetParameters(v map[string]*string) *SubmitJobInput {
	s.Parameters = v
	return s
}

// SetRetryStrategy sets the RetryStrategy field's value.
func (s *SubmitJobInput) SetRetryStrategy(v *RetryStrategy) *SubmitJobInput {
	s.RetryStrategy = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/SubmitJobResponse
type SubmitJobOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the job.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`

	// The name of the job.
	//
	// JobName is a required field
	JobName *string `locationName:"jobName" type:"string" required:"true"`
}

// String returns the string representation
func (s SubmitJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SubmitJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *SubmitJobOutput) SetJobId(v string) *SubmitJobOutput {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *SubmitJobOutput) SetJobName(v string) *SubmitJobOutput {
	s.JobName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/TerminateJobRequest
type TerminateJobInput struct {
	_ struct{} `type:"structure"`

	// Job IDs to be terminated. Up to 100 jobs can be specified.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`

	// A message to attach to the job that explains the reason for cancelling it.
	// This message is returned by future DescribeJobs operations on the job. This
	// message is also recorded in the AWS Batch activity logs.
	//
	// Reason is a required field
	Reason *string `locationName:"reason" type:"string" required:"true"`
}

// String returns the string representation
func (s TerminateJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminateJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TerminateJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TerminateJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.Reason == nil {
		invalidParams.Add(request.NewErrParamRequired("Reason"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *TerminateJobInput) SetJobId(v string) *TerminateJobInput {
	s.JobId = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *TerminateJobInput) SetReason(v string) *TerminateJobInput {
	s.Reason = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/TerminateJobResponse
type TerminateJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TerminateJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminateJobOutput) GoString() string {
	return s.String()
}

// The ulimit settings to pass to the container.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/Ulimit
type Ulimit struct {
	_ struct{} `type:"structure"`

	// The hard limit for the ulimit type.
	//
	// HardLimit is a required field
	HardLimit *int64 `locationName:"hardLimit" type:"integer" required:"true"`

	// The type of the ulimit.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The soft limit for the ulimit type.
	//
	// SoftLimit is a required field
	SoftLimit *int64 `locationName:"softLimit" type:"integer" required:"true"`
}

// String returns the string representation
func (s Ulimit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Ulimit) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Ulimit) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Ulimit"}
	if s.HardLimit == nil {
		invalidParams.Add(request.NewErrParamRequired("HardLimit"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.SoftLimit == nil {
		invalidParams.Add(request.NewErrParamRequired("SoftLimit"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHardLimit sets the HardLimit field's value.
func (s *Ulimit) SetHardLimit(v int64) *Ulimit {
	s.HardLimit = &v
	return s
}

// SetName sets the Name field's value.
func (s *Ulimit) SetName(v string) *Ulimit {
	s.Name = &v
	return s
}

// SetSoftLimit sets the SoftLimit field's value.
func (s *Ulimit) SetSoftLimit(v int64) *Ulimit {
	s.SoftLimit = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/UpdateComputeEnvironmentRequest
type UpdateComputeEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// The name or full Amazon Resource Name (ARN) of the compute environment to
	// update.
	//
	// ComputeEnvironment is a required field
	ComputeEnvironment *string `locationName:"computeEnvironment" type:"string" required:"true"`

	// Details of the compute resources managed by the compute environment. Required
	// for a managed compute environment.
	ComputeResources *ComputeResourceUpdate `locationName:"computeResources" type:"structure"`

	// The name or full Amazon Resource Name (ARN) of the IAM role that allows AWS
	// Batch to make calls to ECS, Auto Scaling, and EC2 on your behalf.
	ServiceRole *string `locationName:"serviceRole" type:"string"`

	// The state of the compute environment. Compute environments in the ENABLED
	// state can accept jobs from a queue and scale in or out automatically based
	// on the workload demand of its associated queues.
	State *string `locationName:"state" type:"string" enum:"CEState"`
}

// String returns the string representation
func (s UpdateComputeEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateComputeEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateComputeEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateComputeEnvironmentInput"}
	if s.ComputeEnvironment == nil {
		invalidParams.Add(request.NewErrParamRequired("ComputeEnvironment"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComputeEnvironment sets the ComputeEnvironment field's value.
func (s *UpdateComputeEnvironmentInput) SetComputeEnvironment(v string) *UpdateComputeEnvironmentInput {
	s.ComputeEnvironment = &v
	return s
}

// SetComputeResources sets the ComputeResources field's value.
func (s *UpdateComputeEnvironmentInput) SetComputeResources(v *ComputeResourceUpdate) *UpdateComputeEnvironmentInput {
	s.ComputeResources = v
	return s
}

// SetServiceRole sets the ServiceRole field's value.
func (s *UpdateComputeEnvironmentInput) SetServiceRole(v string) *UpdateComputeEnvironmentInput {
	s.ServiceRole = &v
	return s
}

// SetState sets the State field's value.
func (s *UpdateComputeEnvironmentInput) SetState(v string) *UpdateComputeEnvironmentInput {
	s.State = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/UpdateComputeEnvironmentResponse
type UpdateComputeEnvironmentOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the compute environment.
	ComputeEnvironmentArn *string `locationName:"computeEnvironmentArn" type:"string"`

	// The name of compute environment.
	ComputeEnvironmentName *string `locationName:"computeEnvironmentName" type:"string"`
}

// String returns the string representation
func (s UpdateComputeEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateComputeEnvironmentOutput) GoString() string {
	return s.String()
}

// SetComputeEnvironmentArn sets the ComputeEnvironmentArn field's value.
func (s *UpdateComputeEnvironmentOutput) SetComputeEnvironmentArn(v string) *UpdateComputeEnvironmentOutput {
	s.ComputeEnvironmentArn = &v
	return s
}

// SetComputeEnvironmentName sets the ComputeEnvironmentName field's value.
func (s *UpdateComputeEnvironmentOutput) SetComputeEnvironmentName(v string) *UpdateComputeEnvironmentOutput {
	s.ComputeEnvironmentName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/UpdateJobQueueRequest
type UpdateJobQueueInput struct {
	_ struct{} `type:"structure"`

	// Details the set of compute environments mapped to a job queue and their order
	// relative to each other. This is one of the parameters used by the job scheduler
	// to determine which compute environment should execute a given job.
	ComputeEnvironmentOrder []*ComputeEnvironmentOrder `locationName:"computeEnvironmentOrder" type:"list"`

	// The name or the Amazon Resource Name (ARN) of the job queue.
	//
	// JobQueue is a required field
	JobQueue *string `locationName:"jobQueue" type:"string" required:"true"`

	// The priority of the job queue. Job queues with a higher priority (or a lower
	// integer value for the priority parameter) are evaluated first when associated
	// with same compute environment. Priority is determined in ascending order,
	// for example, a job queue with a priority value of 1 is given scheduling preference
	// over a job queue with a priority value of 10.
	Priority *int64 `locationName:"priority" type:"integer"`

	// Describes the queue's ability to accept new jobs.
	State *string `locationName:"state" type:"string" enum:"JQState"`
}

// String returns the string representation
func (s UpdateJobQueueInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateJobQueueInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateJobQueueInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateJobQueueInput"}
	if s.JobQueue == nil {
		invalidParams.Add(request.NewErrParamRequired("JobQueue"))
	}
	if s.ComputeEnvironmentOrder != nil {
		for i, v := range s.ComputeEnvironmentOrder {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ComputeEnvironmentOrder", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComputeEnvironmentOrder sets the ComputeEnvironmentOrder field's value.
func (s *UpdateJobQueueInput) SetComputeEnvironmentOrder(v []*ComputeEnvironmentOrder) *UpdateJobQueueInput {
	s.ComputeEnvironmentOrder = v
	return s
}

// SetJobQueue sets the JobQueue field's value.
func (s *UpdateJobQueueInput) SetJobQueue(v string) *UpdateJobQueueInput {
	s.JobQueue = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *UpdateJobQueueInput) SetPriority(v int64) *UpdateJobQueueInput {
	s.Priority = &v
	return s
}

// SetState sets the State field's value.
func (s *UpdateJobQueueInput) SetState(v string) *UpdateJobQueueInput {
	s.State = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/UpdateJobQueueResponse
type UpdateJobQueueOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the job queue.
	JobQueueArn *string `locationName:"jobQueueArn" type:"string"`

	// The name of the job queue.
	JobQueueName *string `locationName:"jobQueueName" type:"string"`
}

// String returns the string representation
func (s UpdateJobQueueOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateJobQueueOutput) GoString() string {
	return s.String()
}

// SetJobQueueArn sets the JobQueueArn field's value.
func (s *UpdateJobQueueOutput) SetJobQueueArn(v string) *UpdateJobQueueOutput {
	s.JobQueueArn = &v
	return s
}

// SetJobQueueName sets the JobQueueName field's value.
func (s *UpdateJobQueueOutput) SetJobQueueName(v string) *UpdateJobQueueOutput {
	s.JobQueueName = &v
	return s
}

// A data volume used in a job's container properties.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/Volume
type Volume struct {
	_ struct{} `type:"structure"`

	// The contents of the host parameter determine whether your data volume persists
	// on the host container instance and where it is stored. If the host parameter
	// is empty, then the Docker daemon assigns a host path for your data volume,
	// but the data is not guaranteed to persist after the containers associated
	// with it stop running.
	Host *Host `locationName:"host" type:"structure"`

	// The name of the volume. Up to 255 letters (uppercase and lowercase), numbers,
	// hyphens, and underscores are allowed. This name is referenced in the sourceVolume
	// parameter of container definition mountPoints.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s Volume) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Volume) GoString() string {
	return s.String()
}

// SetHost sets the Host field's value.
func (s *Volume) SetHost(v *Host) *Volume {
	s.Host = v
	return s
}

// SetName sets the Name field's value.
func (s *Volume) SetName(v string) *Volume {
	s.Name = &v
	return s
}

const (
	// CEStateEnabled is a CEState enum value
	CEStateEnabled = "ENABLED"

	// CEStateDisabled is a CEState enum value
	CEStateDisabled = "DISABLED"
)

const (
	// CEStatusCreating is a CEStatus enum value
	CEStatusCreating = "CREATING"

	// CEStatusUpdating is a CEStatus enum value
	CEStatusUpdating = "UPDATING"

	// CEStatusDeleting is a CEStatus enum value
	CEStatusDeleting = "DELETING"

	// CEStatusDeleted is a CEStatus enum value
	CEStatusDeleted = "DELETED"

	// CEStatusValid is a CEStatus enum value
	CEStatusValid = "VALID"

	// CEStatusInvalid is a CEStatus enum value
	CEStatusInvalid = "INVALID"
)

const (
	// CETypeManaged is a CEType enum value
	CETypeManaged = "MANAGED"

	// CETypeUnmanaged is a CEType enum value
	CETypeUnmanaged = "UNMANAGED"
)

const (
	// CRTypeEc2 is a CRType enum value
	CRTypeEc2 = "EC2"

	// CRTypeSpot is a CRType enum value
	CRTypeSpot = "SPOT"
)

const (
	// JQStateEnabled is a JQState enum value
	JQStateEnabled = "ENABLED"

	// JQStateDisabled is a JQState enum value
	JQStateDisabled = "DISABLED"
)

const (
	// JQStatusCreating is a JQStatus enum value
	JQStatusCreating = "CREATING"

	// JQStatusUpdating is a JQStatus enum value
	JQStatusUpdating = "UPDATING"

	// JQStatusDeleting is a JQStatus enum value
	JQStatusDeleting = "DELETING"

	// JQStatusDeleted is a JQStatus enum value
	JQStatusDeleted = "DELETED"

	// JQStatusValid is a JQStatus enum value
	JQStatusValid = "VALID"

	// JQStatusInvalid is a JQStatus enum value
	JQStatusInvalid = "INVALID"
)

const (
	// JobDefinitionTypeContainer is a JobDefinitionType enum value
	JobDefinitionTypeContainer = "container"
)

const (
	// JobStatusSubmitted is a JobStatus enum value
	JobStatusSubmitted = "SUBMITTED"

	// JobStatusPending is a JobStatus enum value
	JobStatusPending = "PENDING"

	// JobStatusRunnable is a JobStatus enum value
	JobStatusRunnable = "RUNNABLE"

	// JobStatusStarting is a JobStatus enum value
	JobStatusStarting = "STARTING"

	// JobStatusRunning is a JobStatus enum value
	JobStatusRunning = "RUNNING"

	// JobStatusSucceeded is a JobStatus enum value
	JobStatusSucceeded = "SUCCEEDED"

	// JobStatusFailed is a JobStatus enum value
	JobStatusFailed = "FAILED"
)
