// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rds

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/query"
)

const opAddRoleToDBCluster = "AddRoleToDBCluster"

// AddRoleToDBClusterRequest generates a "aws/request.Request" representing the
// client's request for the AddRoleToDBCluster operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddRoleToDBCluster for more information on using the AddRoleToDBCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddRoleToDBClusterRequest method.
//    req, resp := client.AddRoleToDBClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddRoleToDBCluster
func (c *RDS) AddRoleToDBClusterRequest(input *AddRoleToDBClusterInput) (req *request.Request, output *AddRoleToDBClusterOutput) {
	op := &request.Operation{
		Name:       opAddRoleToDBCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddRoleToDBClusterInput{}
	}

	output = &AddRoleToDBClusterOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddRoleToDBCluster API operation for Amazon Relational Database Service.
//
// Associates an Identity and Access Management (IAM) role from an Aurora DB
// cluster. For more information, see Authorizing Amazon Aurora to Access Other
// AWS Services On Your Behalf (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Aurora.Authorizing.AWSServices.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation AddRoleToDBCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier does not refer to an existing DB cluster.
//
//   * ErrCodeDBClusterRoleAlreadyExistsFault "DBClusterRoleAlreadyExists"
//   The specified IAM role Amazon Resource Name (ARN) is already associated with
//   the specified DB cluster.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The DB cluster is not in a valid state.
//
//   * ErrCodeDBClusterRoleQuotaExceededFault "DBClusterRoleQuotaExceeded"
//   You have exceeded the maximum number of IAM roles that can be associated
//   with the specified DB cluster.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddRoleToDBCluster
func (c *RDS) AddRoleToDBCluster(input *AddRoleToDBClusterInput) (*AddRoleToDBClusterOutput, error) {
	req, out := c.AddRoleToDBClusterRequest(input)
	return out, req.Send()
}

// AddRoleToDBClusterWithContext is the same as AddRoleToDBCluster with the addition of
// the ability to pass a context and additional request options.
//
// See AddRoleToDBCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) AddRoleToDBClusterWithContext(ctx aws.Context, input *AddRoleToDBClusterInput, opts ...request.Option) (*AddRoleToDBClusterOutput, error) {
	req, out := c.AddRoleToDBClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddSourceIdentifierToSubscription = "AddSourceIdentifierToSubscription"

// AddSourceIdentifierToSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the AddSourceIdentifierToSubscription operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddSourceIdentifierToSubscription for more information on using the AddSourceIdentifierToSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddSourceIdentifierToSubscriptionRequest method.
//    req, resp := client.AddSourceIdentifierToSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddSourceIdentifierToSubscription
func (c *RDS) AddSourceIdentifierToSubscriptionRequest(input *AddSourceIdentifierToSubscriptionInput) (req *request.Request, output *AddSourceIdentifierToSubscriptionOutput) {
	op := &request.Operation{
		Name:       opAddSourceIdentifierToSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddSourceIdentifierToSubscriptionInput{}
	}

	output = &AddSourceIdentifierToSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddSourceIdentifierToSubscription API operation for Amazon Relational Database Service.
//
// Adds a source identifier to an existing RDS event notification subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation AddSourceIdentifierToSubscription for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeSubscriptionNotFoundFault "SubscriptionNotFound"
//   The subscription name does not exist.
//
//   * ErrCodeSourceNotFoundFault "SourceNotFound"
//   The requested source could not be found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddSourceIdentifierToSubscription
func (c *RDS) AddSourceIdentifierToSubscription(input *AddSourceIdentifierToSubscriptionInput) (*AddSourceIdentifierToSubscriptionOutput, error) {
	req, out := c.AddSourceIdentifierToSubscriptionRequest(input)
	return out, req.Send()
}

// AddSourceIdentifierToSubscriptionWithContext is the same as AddSourceIdentifierToSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See AddSourceIdentifierToSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) AddSourceIdentifierToSubscriptionWithContext(ctx aws.Context, input *AddSourceIdentifierToSubscriptionInput, opts ...request.Option) (*AddSourceIdentifierToSubscriptionOutput, error) {
	req, out := c.AddSourceIdentifierToSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddTagsToResource = "AddTagsToResource"

// AddTagsToResourceRequest generates a "aws/request.Request" representing the
// client's request for the AddTagsToResource operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddTagsToResource for more information on using the AddTagsToResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddTagsToResourceRequest method.
//    req, resp := client.AddTagsToResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddTagsToResource
func (c *RDS) AddTagsToResourceRequest(input *AddTagsToResourceInput) (req *request.Request, output *AddTagsToResourceOutput) {
	op := &request.Operation{
		Name:       opAddTagsToResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsToResourceInput{}
	}

	output = &AddTagsToResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddTagsToResource API operation for Amazon Relational Database Service.
//
// Adds metadata tags to an Amazon RDS resource. These tags can also be used
// with cost allocation reporting to track cost associated with Amazon RDS resources,
// or used in a Condition statement in an IAM policy for Amazon RDS.
//
// For an overview on tagging Amazon RDS resources, see Tagging Amazon RDS Resources
// (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Tagging.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation AddTagsToResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier does not refer to an existing DB instance.
//
//   * ErrCodeDBSnapshotNotFoundFault "DBSnapshotNotFound"
//   DBSnapshotIdentifier does not refer to an existing DB snapshot.
//
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier does not refer to an existing DB cluster.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddTagsToResource
func (c *RDS) AddTagsToResource(input *AddTagsToResourceInput) (*AddTagsToResourceOutput, error) {
	req, out := c.AddTagsToResourceRequest(input)
	return out, req.Send()
}

// AddTagsToResourceWithContext is the same as AddTagsToResource with the addition of
// the ability to pass a context and additional request options.
//
// See AddTagsToResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) AddTagsToResourceWithContext(ctx aws.Context, input *AddTagsToResourceInput, opts ...request.Option) (*AddTagsToResourceOutput, error) {
	req, out := c.AddTagsToResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opApplyPendingMaintenanceAction = "ApplyPendingMaintenanceAction"

// ApplyPendingMaintenanceActionRequest generates a "aws/request.Request" representing the
// client's request for the ApplyPendingMaintenanceAction operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ApplyPendingMaintenanceAction for more information on using the ApplyPendingMaintenanceAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ApplyPendingMaintenanceActionRequest method.
//    req, resp := client.ApplyPendingMaintenanceActionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ApplyPendingMaintenanceAction
func (c *RDS) ApplyPendingMaintenanceActionRequest(input *ApplyPendingMaintenanceActionInput) (req *request.Request, output *ApplyPendingMaintenanceActionOutput) {
	op := &request.Operation{
		Name:       opApplyPendingMaintenanceAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ApplyPendingMaintenanceActionInput{}
	}

	output = &ApplyPendingMaintenanceActionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ApplyPendingMaintenanceAction API operation for Amazon Relational Database Service.
//
// Applies a pending maintenance action to a resource (for example, to a DB
// instance).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation ApplyPendingMaintenanceAction for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The specified resource ID was not found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ApplyPendingMaintenanceAction
func (c *RDS) ApplyPendingMaintenanceAction(input *ApplyPendingMaintenanceActionInput) (*ApplyPendingMaintenanceActionOutput, error) {
	req, out := c.ApplyPendingMaintenanceActionRequest(input)
	return out, req.Send()
}

// ApplyPendingMaintenanceActionWithContext is the same as ApplyPendingMaintenanceAction with the addition of
// the ability to pass a context and additional request options.
//
// See ApplyPendingMaintenanceAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) ApplyPendingMaintenanceActionWithContext(ctx aws.Context, input *ApplyPendingMaintenanceActionInput, opts ...request.Option) (*ApplyPendingMaintenanceActionOutput, error) {
	req, out := c.ApplyPendingMaintenanceActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAuthorizeDBSecurityGroupIngress = "AuthorizeDBSecurityGroupIngress"

// AuthorizeDBSecurityGroupIngressRequest generates a "aws/request.Request" representing the
// client's request for the AuthorizeDBSecurityGroupIngress operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AuthorizeDBSecurityGroupIngress for more information on using the AuthorizeDBSecurityGroupIngress
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AuthorizeDBSecurityGroupIngressRequest method.
//    req, resp := client.AuthorizeDBSecurityGroupIngressRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AuthorizeDBSecurityGroupIngress
func (c *RDS) AuthorizeDBSecurityGroupIngressRequest(input *AuthorizeDBSecurityGroupIngressInput) (req *request.Request, output *AuthorizeDBSecurityGroupIngressOutput) {
	op := &request.Operation{
		Name:       opAuthorizeDBSecurityGroupIngress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AuthorizeDBSecurityGroupIngressInput{}
	}

	output = &AuthorizeDBSecurityGroupIngressOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AuthorizeDBSecurityGroupIngress API operation for Amazon Relational Database Service.
//
// Enables ingress to a DBSecurityGroup using one of two forms of authorization.
// First, EC2 or VPC security groups can be added to the DBSecurityGroup if
// the application using the database is running on EC2 or VPC instances. Second,
// IP ranges are available if the application accessing your database is running
// on the Internet. Required parameters for this API are one of CIDR range,
// EC2SecurityGroupId for VPC, or (EC2SecurityGroupOwnerId and either EC2SecurityGroupName
// or EC2SecurityGroupId for non-VPC).
//
// You cannot authorize ingress from an EC2 security group in one AWS Region
// to an Amazon RDS DB instance in another. You cannot authorize ingress from
// a VPC security group in one VPC to an Amazon RDS DB instance in another.
//
// For an overview of CIDR ranges, go to the Wikipedia Tutorial (http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation AuthorizeDBSecurityGroupIngress for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBSecurityGroupNotFoundFault "DBSecurityGroupNotFound"
//   DBSecurityGroupName does not refer to an existing DB security group.
//
//   * ErrCodeInvalidDBSecurityGroupStateFault "InvalidDBSecurityGroupState"
//   The state of the DB security group does not allow deletion.
//
//   * ErrCodeAuthorizationAlreadyExistsFault "AuthorizationAlreadyExists"
//   The specified CIDRIP or EC2 security group is already authorized for the
//   specified DB security group.
//
//   * ErrCodeAuthorizationQuotaExceededFault "AuthorizationQuotaExceeded"
//   DB security group authorization quota has been reached.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AuthorizeDBSecurityGroupIngress
func (c *RDS) AuthorizeDBSecurityGroupIngress(input *AuthorizeDBSecurityGroupIngressInput) (*AuthorizeDBSecurityGroupIngressOutput, error) {
	req, out := c.AuthorizeDBSecurityGroupIngressRequest(input)
	return out, req.Send()
}

// AuthorizeDBSecurityGroupIngressWithContext is the same as AuthorizeDBSecurityGroupIngress with the addition of
// the ability to pass a context and additional request options.
//
// See AuthorizeDBSecurityGroupIngress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) AuthorizeDBSecurityGroupIngressWithContext(ctx aws.Context, input *AuthorizeDBSecurityGroupIngressInput, opts ...request.Option) (*AuthorizeDBSecurityGroupIngressOutput, error) {
	req, out := c.AuthorizeDBSecurityGroupIngressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCopyDBClusterParameterGroup = "CopyDBClusterParameterGroup"

// CopyDBClusterParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the CopyDBClusterParameterGroup operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CopyDBClusterParameterGroup for more information on using the CopyDBClusterParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CopyDBClusterParameterGroupRequest method.
//    req, resp := client.CopyDBClusterParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBClusterParameterGroup
func (c *RDS) CopyDBClusterParameterGroupRequest(input *CopyDBClusterParameterGroupInput) (req *request.Request, output *CopyDBClusterParameterGroupOutput) {
	op := &request.Operation{
		Name:       opCopyDBClusterParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopyDBClusterParameterGroupInput{}
	}

	output = &CopyDBClusterParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CopyDBClusterParameterGroup API operation for Amazon Relational Database Service.
//
// Copies the specified DB cluster parameter group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation CopyDBClusterParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName does not refer to an existing DB parameter group.
//
//   * ErrCodeDBParameterGroupQuotaExceededFault "DBParameterGroupQuotaExceeded"
//   Request would result in user exceeding the allowed number of DB parameter
//   groups.
//
//   * ErrCodeDBParameterGroupAlreadyExistsFault "DBParameterGroupAlreadyExists"
//   A DB parameter group with the same name exists.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBClusterParameterGroup
func (c *RDS) CopyDBClusterParameterGroup(input *CopyDBClusterParameterGroupInput) (*CopyDBClusterParameterGroupOutput, error) {
	req, out := c.CopyDBClusterParameterGroupRequest(input)
	return out, req.Send()
}

// CopyDBClusterParameterGroupWithContext is the same as CopyDBClusterParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CopyDBClusterParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) CopyDBClusterParameterGroupWithContext(ctx aws.Context, input *CopyDBClusterParameterGroupInput, opts ...request.Option) (*CopyDBClusterParameterGroupOutput, error) {
	req, out := c.CopyDBClusterParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCopyDBClusterSnapshot = "CopyDBClusterSnapshot"

// CopyDBClusterSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CopyDBClusterSnapshot operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CopyDBClusterSnapshot for more information on using the CopyDBClusterSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CopyDBClusterSnapshotRequest method.
//    req, resp := client.CopyDBClusterSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBClusterSnapshot
func (c *RDS) CopyDBClusterSnapshotRequest(input *CopyDBClusterSnapshotInput) (req *request.Request, output *CopyDBClusterSnapshotOutput) {
	op := &request.Operation{
		Name:       opCopyDBClusterSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopyDBClusterSnapshotInput{}
	}

	output = &CopyDBClusterSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CopyDBClusterSnapshot API operation for Amazon Relational Database Service.
//
// Copies a snapshot of a DB cluster.
//
// To copy a DB cluster snapshot from a shared manual DB cluster snapshot, SourceDBClusterSnapshotIdentifier
// must be the Amazon Resource Name (ARN) of the shared DB cluster snapshot.
//
// You can copy an encrypted DB cluster snapshot from another AWS Region. In
// that case, the AWS Region where you call the CopyDBClusterSnapshot action
// is the destination AWS Region for the encrypted DB cluster snapshot to be
// copied to. To copy an encrypted DB cluster snapshot from another AWS Region,
// you must provide the following values:
//
//    * KmsKeyId - The AWS Key Management System (KMS) key identifier for the
//    key to use to encrypt the copy of the DB cluster snapshot in the destination
//    AWS Region.
//
//    * PreSignedUrl - A URL that contains a Signature Version 4 signed request
//    for the CopyDBClusterSnapshot action to be called in the source AWS Region
//    where the DB cluster snapshot will be copied from. The pre-signed URL
//    must be a valid request for the CopyDBClusterSnapshot API action that
//    can be executed in the source AWS Region that contains the encrypted DB
//    cluster snapshot to be copied.
//
// The pre-signed URL request must contain the following parameter values:
//
// KmsKeyId - The KMS key identifier for the key to use to encrypt the copy
//    of the DB cluster snapshot in the destination AWS Region. This is the
//    same identifier for both the CopyDBClusterSnapshot action that is called
//    in the destination AWS Region, and the action contained in the pre-signed
//    URL.
//
// DestinationRegion - The name of the AWS Region that the DB cluster snapshot
//    will be created in.
//
// SourceDBClusterSnapshotIdentifier - The DB cluster snapshot identifier for
//    the encrypted DB cluster snapshot to be copied. This identifier must be
//    in the Amazon Resource Name (ARN) format for the source AWS Region. For
//    example, if you are copying an encrypted DB cluster snapshot from the
//    us-west-2 region, then your SourceDBClusterSnapshotIdentifier looks like
//    the following example: arn:aws:rds:us-west-2:123456789012:cluster-snapshot:aurora-cluster1-snapshot-20161115.
//
// To learn how to generate a Signature Version 4 signed request, see  Authenticating
//    Requests: Using Query Parameters (AWS Signature Version 4) (http://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html)
//    and  Signature Version 4 Signing Process (http://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
//
//    * TargetDBClusterSnapshotIdentifier - The identifier for the new copy
//    of the DB cluster snapshot in the destination AWS Region.
//
//    * SourceDBClusterSnapshotIdentifier - The DB cluster snapshot identifier
//    for the encrypted DB cluster snapshot to be copied. This identifier must
//    be in the ARN format for the source AWS Region and is the same value as
//    the SourceDBClusterSnapshotIdentifier in the pre-signed URL.
//
// To cancel the copy operation once it is in progress, delete the target DB
// cluster snapshot identified by TargetDBClusterSnapshotIdentifier while that
// DB cluster snapshot is in "copying" status.
//
// For more information on copying encrypted DB cluster snapshots from one AWS
// Region to another, see  Copying a DB Cluster Snapshot in the Same Account,
// Either in the Same Region or Across Regions (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopySnapshot.html#USER_CopyDBClusterSnapshot.CrossRegion)
// in the Amazon RDS User Guide.
//
// For more information on Amazon Aurora, see Aurora on Amazon RDS (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html)
// in the Amazon RDS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation CopyDBClusterSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterSnapshotAlreadyExistsFault "DBClusterSnapshotAlreadyExistsFault"
//   User already has a DB cluster snapshot with the given identifier.
//
//   * ErrCodeDBClusterSnapshotNotFoundFault "DBClusterSnapshotNotFoundFault"
//   DBClusterSnapshotIdentifier does not refer to an existing DB cluster snapshot.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The DB cluster is not in a valid state.
//
//   * ErrCodeInvalidDBClusterSnapshotStateFault "InvalidDBClusterSnapshotStateFault"
//   The supplied value is not a valid DB cluster snapshot state.
//
//   * ErrCodeSnapshotQuotaExceededFault "SnapshotQuotaExceeded"
//   Request would result in user exceeding the allowed number of DB snapshots.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   Error accessing KMS key.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBClusterSnapshot
func (c *RDS) CopyDBClusterSnapshot(input *CopyDBClusterSnapshotInput) (*CopyDBClusterSnapshotOutput, error) {
	req, out := c.CopyDBClusterSnapshotRequest(input)
	return out, req.Send()
}

// CopyDBClusterSnapshotWithContext is the same as CopyDBClusterSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CopyDBClusterSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) CopyDBClusterSnapshotWithContext(ctx aws.Context, input *CopyDBClusterSnapshotInput, opts ...request.Option) (*CopyDBClusterSnapshotOutput, error) {
	req, out := c.CopyDBClusterSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCopyDBParameterGroup = "CopyDBParameterGroup"

// CopyDBParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the CopyDBParameterGroup operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CopyDBParameterGroup for more information on using the CopyDBParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CopyDBParameterGroupRequest method.
//    req, resp := client.CopyDBParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBParameterGroup
func (c *RDS) CopyDBParameterGroupRequest(input *CopyDBParameterGroupInput) (req *request.Request, output *CopyDBParameterGroupOutput) {
	op := &request.Operation{
		Name:       opCopyDBParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopyDBParameterGroupInput{}
	}

	output = &CopyDBParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CopyDBParameterGroup API operation for Amazon Relational Database Service.
//
// Copies the specified DB parameter group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation CopyDBParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName does not refer to an existing DB parameter group.
//
//   * ErrCodeDBParameterGroupAlreadyExistsFault "DBParameterGroupAlreadyExists"
//   A DB parameter group with the same name exists.
//
//   * ErrCodeDBParameterGroupQuotaExceededFault "DBParameterGroupQuotaExceeded"
//   Request would result in user exceeding the allowed number of DB parameter
//   groups.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBParameterGroup
func (c *RDS) CopyDBParameterGroup(input *CopyDBParameterGroupInput) (*CopyDBParameterGroupOutput, error) {
	req, out := c.CopyDBParameterGroupRequest(input)
	return out, req.Send()
}

// CopyDBParameterGroupWithContext is the same as CopyDBParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CopyDBParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) CopyDBParameterGroupWithContext(ctx aws.Context, input *CopyDBParameterGroupInput, opts ...request.Option) (*CopyDBParameterGroupOutput, error) {
	req, out := c.CopyDBParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCopyDBSnapshot = "CopyDBSnapshot"

// CopyDBSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CopyDBSnapshot operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CopyDBSnapshot for more information on using the CopyDBSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CopyDBSnapshotRequest method.
//    req, resp := client.CopyDBSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBSnapshot
func (c *RDS) CopyDBSnapshotRequest(input *CopyDBSnapshotInput) (req *request.Request, output *CopyDBSnapshotOutput) {
	op := &request.Operation{
		Name:       opCopyDBSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopyDBSnapshotInput{}
	}

	output = &CopyDBSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CopyDBSnapshot API operation for Amazon Relational Database Service.
//
// Copies the specified DB snapshot. The source DB snapshot must be in the "available"
// state.
//
// You can copy a snapshot from one AWS Region to another. In that case, the
// AWS Region where you call the CopyDBSnapshot action is the destination AWS
// Region for the DB snapshot copy.
//
// You cannot copy an encrypted, shared DB snapshot from one AWS Region to another.
//
// For more information about copying snapshots, see Copying a DB Snapshot (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopyDBSnapshot.html)
// in the Amazon RDS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation CopyDBSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBSnapshotAlreadyExistsFault "DBSnapshotAlreadyExists"
//   DBSnapshotIdentifier is already used by an existing snapshot.
//
//   * ErrCodeDBSnapshotNotFoundFault "DBSnapshotNotFound"
//   DBSnapshotIdentifier does not refer to an existing DB snapshot.
//
//   * ErrCodeInvalidDBSnapshotStateFault "InvalidDBSnapshotState"
//   The state of the DB snapshot does not allow deletion.
//
//   * ErrCodeSnapshotQuotaExceededFault "SnapshotQuotaExceeded"
//   Request would result in user exceeding the allowed number of DB snapshots.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   Error accessing KMS key.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBSnapshot
func (c *RDS) CopyDBSnapshot(input *CopyDBSnapshotInput) (*CopyDBSnapshotOutput, error) {
	req, out := c.CopyDBSnapshotRequest(input)
	return out, req.Send()
}

// CopyDBSnapshotWithContext is the same as CopyDBSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CopyDBSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) CopyDBSnapshotWithContext(ctx aws.Context, input *CopyDBSnapshotInput, opts ...request.Option) (*CopyDBSnapshotOutput, error) {
	req, out := c.CopyDBSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCopyOptionGroup = "CopyOptionGroup"

// CopyOptionGroupRequest generates a "aws/request.Request" representing the
// client's request for the CopyOptionGroup operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CopyOptionGroup for more information on using the CopyOptionGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CopyOptionGroupRequest method.
//    req, resp := client.CopyOptionGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyOptionGroup
func (c *RDS) CopyOptionGroupRequest(input *CopyOptionGroupInput) (req *request.Request, output *CopyOptionGroupOutput) {
	op := &request.Operation{
		Name:       opCopyOptionGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopyOptionGroupInput{}
	}

	output = &CopyOptionGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CopyOptionGroup API operation for Amazon Relational Database Service.
//
// Copies the specified option group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation CopyOptionGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeOptionGroupAlreadyExistsFault "OptionGroupAlreadyExistsFault"
//   The option group you are trying to create already exists.
//
//   * ErrCodeOptionGroupNotFoundFault "OptionGroupNotFoundFault"
//   The specified option group could not be found.
//
//   * ErrCodeOptionGroupQuotaExceededFault "OptionGroupQuotaExceededFault"
//   The quota of 20 option groups was exceeded for this AWS account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyOptionGroup
func (c *RDS) CopyOptionGroup(input *CopyOptionGroupInput) (*CopyOptionGroupOutput, error) {
	req, out := c.CopyOptionGroupRequest(input)
	return out, req.Send()
}

// CopyOptionGroupWithContext is the same as CopyOptionGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CopyOptionGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) CopyOptionGroupWithContext(ctx aws.Context, input *CopyOptionGroupInput, opts ...request.Option) (*CopyOptionGroupOutput, error) {
	req, out := c.CopyOptionGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDBCluster = "CreateDBCluster"

// CreateDBClusterRequest generates a "aws/request.Request" representing the
// client's request for the CreateDBCluster operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDBCluster for more information on using the CreateDBCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDBClusterRequest method.
//    req, resp := client.CreateDBClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBCluster
func (c *RDS) CreateDBClusterRequest(input *CreateDBClusterInput) (req *request.Request, output *CreateDBClusterOutput) {
	op := &request.Operation{
		Name:       opCreateDBCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBClusterInput{}
	}

	output = &CreateDBClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDBCluster API operation for Amazon Relational Database Service.
//
// Creates a new Amazon Aurora DB cluster.
//
// You can use the ReplicationSourceIdentifier parameter to create the DB cluster
// as a Read Replica of another DB cluster or Amazon RDS MySQL DB instance.
// For cross-region replication where the DB cluster identified by ReplicationSourceIdentifier
// is encrypted, you must also specify the PreSignedUrl parameter.
//
// For more information on Amazon Aurora, see Aurora on Amazon RDS (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html)
// in the Amazon RDS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation CreateDBCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterAlreadyExistsFault "DBClusterAlreadyExistsFault"
//   User already has a DB cluster with the given identifier.
//
//   * ErrCodeInsufficientStorageClusterCapacityFault "InsufficientStorageClusterCapacity"
//   There is insufficient storage available for the current action. You may be
//   able to resolve this error by updating your subnet group to use different
//   Availability Zones that have more storage available.
//
//   * ErrCodeDBClusterQuotaExceededFault "DBClusterQuotaExceededFault"
//   User attempted to create a new DB cluster and the user has already reached
//   the maximum allowed DB cluster quota.
//
//   * ErrCodeStorageQuotaExceededFault "StorageQuotaExceeded"
//   Request would result in user exceeding the allowed amount of storage available
//   across all DB instances.
//
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName does not refer to an existing DB subnet group.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   DB subnet group does not cover all Availability Zones after it is created
//   because users' change.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The DB cluster is not in a valid state.
//
//   * ErrCodeInvalidDBSubnetGroupStateFault "InvalidDBSubnetGroupStateFault"
//   The DB subnet group cannot be deleted because it is in use.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is invalid, or multiple subnets were requested that
//   are not all in a common VPC.
//
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The specified DB instance is not in the available state.
//
//   * ErrCodeDBClusterParameterGroupNotFoundFault "DBClusterParameterGroupNotFound"
//   DBClusterParameterGroupName does not refer to an existing DB Cluster parameter
//   group.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   Error accessing KMS key.
//
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier does not refer to an existing DB cluster.
//
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier does not refer to an existing DB instance.
//
//   * ErrCodeDBSubnetGroupDoesNotCoverEnoughAZs "DBSubnetGroupDoesNotCoverEnoughAZs"
//   Subnets in the DB subnet group should cover at least two Availability Zones
//   unless there is only one Availability Zone.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBCluster
func (c *RDS) CreateDBCluster(input *CreateDBClusterInput) (*CreateDBClusterOutput, error) {
	req, out := c.CreateDBClusterRequest(input)
	return out, req.Send()
}

// CreateDBClusterWithContext is the same as CreateDBCluster with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDBCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) CreateDBClusterWithContext(ctx aws.Context, input *CreateDBClusterInput, opts ...request.Option) (*CreateDBClusterOutput, error) {
	req, out := c.CreateDBClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDBClusterParameterGroup = "CreateDBClusterParameterGroup"

// CreateDBClusterParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateDBClusterParameterGroup operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDBClusterParameterGroup for more information on using the CreateDBClusterParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDBClusterParameterGroupRequest method.
//    req, resp := client.CreateDBClusterParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBClusterParameterGroup
func (c *RDS) CreateDBClusterParameterGroupRequest(input *CreateDBClusterParameterGroupInput) (req *request.Request, output *CreateDBClusterParameterGroupOutput) {
	op := &request.Operation{
		Name:       opCreateDBClusterParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBClusterParameterGroupInput{}
	}

	output = &CreateDBClusterParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDBClusterParameterGroup API operation for Amazon Relational Database Service.
//
// Creates a new DB cluster parameter group.
//
// Parameters in a DB cluster parameter group apply to all of the instances
// in a DB cluster.
//
// A DB cluster parameter group is initially created with the default parameters
// for the database engine used by instances in the DB cluster. To provide custom
// values for any of the parameters, you must modify the group after creating
// it using ModifyDBClusterParameterGroup. Once you've created a DB cluster
// parameter group, you need to associate it with your DB cluster using ModifyDBCluster.
// When you associate a new DB cluster parameter group with a running DB cluster,
// you need to reboot the DB instances in the DB cluster without failover for
// the new DB cluster parameter group and associated settings to take effect.
//
// After you create a DB cluster parameter group, you should wait at least 5
// minutes before creating your first DB cluster that uses that DB cluster parameter
// group as the default parameter group. This allows Amazon RDS to fully complete
// the create action before the DB cluster parameter group is used as the default
// for a new DB cluster. This is especially important for parameters that are
// critical when creating the default database for a DB cluster, such as the
// character set for the default database defined by the character_set_database
// parameter. You can use the Parameter Groups option of the Amazon RDS console
// (https://console.aws.amazon.com/rds/) or the DescribeDBClusterParameters
// command to verify that your DB cluster parameter group has been created or
// modified.
//
// For more information on Amazon Aurora, see Aurora on Amazon RDS (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html)
// in the Amazon RDS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation CreateDBClusterParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBParameterGroupQuotaExceededFault "DBParameterGroupQuotaExceeded"
//   Request would result in user exceeding the allowed number of DB parameter
//   groups.
//
//   * ErrCodeDBParameterGroupAlreadyExistsFault "DBParameterGroupAlreadyExists"
//   A DB parameter group with the same name exists.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBClusterParameterGroup
func (c *RDS) CreateDBClusterParameterGroup(input *CreateDBClusterParameterGroupInput) (*CreateDBClusterParameterGroupOutput, error) {
	req, out := c.CreateDBClusterParameterGroupRequest(input)
	return out, req.Send()
}

// CreateDBClusterParameterGroupWithContext is the same as CreateDBClusterParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDBClusterParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) CreateDBClusterParameterGroupWithContext(ctx aws.Context, input *CreateDBClusterParameterGroupInput, opts ...request.Option) (*CreateDBClusterParameterGroupOutput, error) {
	req, out := c.CreateDBClusterParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDBClusterSnapshot = "CreateDBClusterSnapshot"

// CreateDBClusterSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CreateDBClusterSnapshot operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDBClusterSnapshot for more information on using the CreateDBClusterSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDBClusterSnapshotRequest method.
//    req, resp := client.CreateDBClusterSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBClusterSnapshot
func (c *RDS) CreateDBClusterSnapshotRequest(input *CreateDBClusterSnapshotInput) (req *request.Request, output *CreateDBClusterSnapshotOutput) {
	op := &request.Operation{
		Name:       opCreateDBClusterSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBClusterSnapshotInput{}
	}

	output = &CreateDBClusterSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDBClusterSnapshot API operation for Amazon Relational Database Service.
//
// Creates a snapshot of a DB cluster. For more information on Amazon Aurora,
// see Aurora on Amazon RDS (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html)
// in the Amazon RDS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation CreateDBClusterSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterSnapshotAlreadyExistsFault "DBClusterSnapshotAlreadyExistsFault"
//   User already has a DB cluster snapshot with the given identifier.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The DB cluster is not in a valid state.
//
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier does not refer to an existing DB cluster.
//
//   * ErrCodeSnapshotQuotaExceededFault "SnapshotQuotaExceeded"
//   Request would result in user exceeding the allowed number of DB snapshots.
//
//   * ErrCodeInvalidDBClusterSnapshotStateFault "InvalidDBClusterSnapshotStateFault"
//   The supplied value is not a valid DB cluster snapshot state.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBClusterSnapshot
func (c *RDS) CreateDBClusterSnapshot(input *CreateDBClusterSnapshotInput) (*CreateDBClusterSnapshotOutput, error) {
	req, out := c.CreateDBClusterSnapshotRequest(input)
	return out, req.Send()
}

// CreateDBClusterSnapshotWithContext is the same as CreateDBClusterSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDBClusterSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) CreateDBClusterSnapshotWithContext(ctx aws.Context, input *CreateDBClusterSnapshotInput, opts ...request.Option) (*CreateDBClusterSnapshotOutput, error) {
	req, out := c.CreateDBClusterSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDBInstance = "CreateDBInstance"

// CreateDBInstanceRequest generates a "aws/request.Request" representing the
// client's request for the CreateDBInstance operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDBInstance for more information on using the CreateDBInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDBInstanceRequest method.
//    req, resp := client.CreateDBInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBInstance
func (c *RDS) CreateDBInstanceRequest(input *CreateDBInstanceInput) (req *request.Request, output *CreateDBInstanceOutput) {
	op := &request.Operation{
		Name:       opCreateDBInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBInstanceInput{}
	}

	output = &CreateDBInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDBInstance API operation for Amazon Relational Database Service.
//
// Creates a new DB instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation CreateDBInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceAlreadyExistsFault "DBInstanceAlreadyExists"
//   User already has a DB instance with the given identifier.
//
//   * ErrCodeInsufficientDBInstanceCapacityFault "InsufficientDBInstanceCapacity"
//   Specified DB instance class is not available in the specified Availability
//   Zone.
//
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName does not refer to an existing DB parameter group.
//
//   * ErrCodeDBSecurityGroupNotFoundFault "DBSecurityGroupNotFound"
//   DBSecurityGroupName does not refer to an existing DB security group.
//
//   * ErrCodeInstanceQuotaExceededFault "InstanceQuotaExceeded"
//   Request would result in user exceeding the allowed number of DB instances.
//
//   * ErrCodeStorageQuotaExceededFault "StorageQuotaExceeded"
//   Request would result in user exceeding the allowed amount of storage available
//   across all DB instances.
//
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName does not refer to an existing DB subnet group.
//
//   * ErrCodeDBSubnetGroupDoesNotCoverEnoughAZs "DBSubnetGroupDoesNotCoverEnoughAZs"
//   Subnets in the DB subnet group should cover at least two Availability Zones
//   unless there is only one Availability Zone.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The DB cluster is not in a valid state.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is invalid, or multiple subnets were requested that
//   are not all in a common VPC.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   DB subnet group does not cover all Availability Zones after it is created
//   because users' change.
//
//   * ErrCodeProvisionedIopsNotAvailableInAZFault "ProvisionedIopsNotAvailableInAZFault"
//   Provisioned IOPS not available in the specified Availability Zone.
//
//   * ErrCodeOptionGroupNotFoundFault "OptionGroupNotFoundFault"
//   The specified option group could not be found.
//
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier does not refer to an existing DB cluster.
//
//   * ErrCodeStorageTypeNotSupportedFault "StorageTypeNotSupported"
//   StorageType specified cannot be associated with the DB Instance.
//
//   * ErrCodeAuthorizationNotFoundFault "AuthorizationNotFound"
//   Specified CIDRIP or EC2 security group is not authorized for the specified
//   DB security group.
//
//   RDS may not also be authorized via IAM to perform necessary actions on your
//   behalf.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   Error accessing KMS key.
//
//   * ErrCodeDomainNotFoundFault "DomainNotFoundFault"
//   Domain does not refer to an existing Active Directory Domain.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBInstance
func (c *RDS) CreateDBInstance(input *CreateDBInstanceInput) (*CreateDBInstanceOutput, error) {
	req, out := c.CreateDBInstanceRequest(input)
	return out, req.Send()
}

// CreateDBInstanceWithContext is the same as CreateDBInstance with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDBInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) CreateDBInstanceWithContext(ctx aws.Context, input *CreateDBInstanceInput, opts ...request.Option) (*CreateDBInstanceOutput, error) {
	req, out := c.CreateDBInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDBInstanceReadReplica = "CreateDBInstanceReadReplica"

// CreateDBInstanceReadReplicaRequest generates a "aws/request.Request" representing the
// client's request for the CreateDBInstanceReadReplica operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDBInstanceReadReplica for more information on using the CreateDBInstanceReadReplica
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDBInstanceReadReplicaRequest method.
//    req, resp := client.CreateDBInstanceReadReplicaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBInstanceReadReplica
func (c *RDS) CreateDBInstanceReadReplicaRequest(input *CreateDBInstanceReadReplicaInput) (req *request.Request, output *CreateDBInstanceReadReplicaOutput) {
	op := &request.Operation{
		Name:       opCreateDBInstanceReadReplica,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBInstanceReadReplicaInput{}
	}

	output = &CreateDBInstanceReadReplicaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDBInstanceReadReplica API operation for Amazon Relational Database Service.
//
// Creates a new DB instance that acts as a Read Replica for an existing source
// DB instance. You can create a Read Replica for a DB instance running MySQL,
// MariaDB, or PostgreSQL.
//
// Amazon Aurora does not support this action. You must call the CreateDBInstance
// action to create a DB instance for an Aurora DB cluster.
//
// All Read Replica DB instances are created as Single-AZ deployments with backups
// disabled. All other DB instance attributes (including DB security groups
// and DB parameter groups) are inherited from the source DB instance, except
// as specified below.
//
// The source DB instance must have backup retention enabled.
//
// For more information, see Working with PostgreSQL, MySQL, and MariaDB Read
// Replicas (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ReadRepl.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation CreateDBInstanceReadReplica for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceAlreadyExistsFault "DBInstanceAlreadyExists"
//   User already has a DB instance with the given identifier.
//
//   * ErrCodeInsufficientDBInstanceCapacityFault "InsufficientDBInstanceCapacity"
//   Specified DB instance class is not available in the specified Availability
//   Zone.
//
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName does not refer to an existing DB parameter group.
//
//   * ErrCodeDBSecurityGroupNotFoundFault "DBSecurityGroupNotFound"
//   DBSecurityGroupName does not refer to an existing DB security group.
//
//   * ErrCodeInstanceQuotaExceededFault "InstanceQuotaExceeded"
//   Request would result in user exceeding the allowed number of DB instances.
//
//   * ErrCodeStorageQuotaExceededFault "StorageQuotaExceeded"
//   Request would result in user exceeding the allowed amount of storage available
//   across all DB instances.
//
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier does not refer to an existing DB instance.
//
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The specified DB instance is not in the available state.
//
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName does not refer to an existing DB subnet group.
//
//   * ErrCodeDBSubnetGroupDoesNotCoverEnoughAZs "DBSubnetGroupDoesNotCoverEnoughAZs"
//   Subnets in the DB subnet group should cover at least two Availability Zones
//   unless there is only one Availability Zone.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is invalid, or multiple subnets were requested that
//   are not all in a common VPC.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   DB subnet group does not cover all Availability Zones after it is created
//   because users' change.
//
//   * ErrCodeProvisionedIopsNotAvailableInAZFault "ProvisionedIopsNotAvailableInAZFault"
//   Provisioned IOPS not available in the specified Availability Zone.
//
//   * ErrCodeOptionGroupNotFoundFault "OptionGroupNotFoundFault"
//   The specified option group could not be found.
//
//   * ErrCodeDBSubnetGroupNotAllowedFault "DBSubnetGroupNotAllowedFault"
//   Indicates that the DBSubnetGroup should not be specified while creating read
//   replicas that lie in the same region as the source instance.
//
//   * ErrCodeInvalidDBSubnetGroupFault "InvalidDBSubnetGroupFault"
//   Indicates the DBSubnetGroup does not belong to the same VPC as that of an
//   existing cross region read replica of the same source instance.
//
//   * ErrCodeStorageTypeNotSupportedFault "StorageTypeNotSupported"
//   StorageType specified cannot be associated with the DB Instance.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   Error accessing KMS key.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBInstanceReadReplica
func (c *RDS) CreateDBInstanceReadReplica(input *CreateDBInstanceReadReplicaInput) (*CreateDBInstanceReadReplicaOutput, error) {
	req, out := c.CreateDBInstanceReadReplicaRequest(input)
	return out, req.Send()
}

// CreateDBInstanceReadReplicaWithContext is the same as CreateDBInstanceReadReplica with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDBInstanceReadReplica for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) CreateDBInstanceReadReplicaWithContext(ctx aws.Context, input *CreateDBInstanceReadReplicaInput, opts ...request.Option) (*CreateDBInstanceReadReplicaOutput, error) {
	req, out := c.CreateDBInstanceReadReplicaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDBParameterGroup = "CreateDBParameterGroup"

// CreateDBParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateDBParameterGroup operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDBParameterGroup for more information on using the CreateDBParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDBParameterGroupRequest method.
//    req, resp := client.CreateDBParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBParameterGroup
func (c *RDS) CreateDBParameterGroupRequest(input *CreateDBParameterGroupInput) (req *request.Request, output *CreateDBParameterGroupOutput) {
	op := &request.Operation{
		Name:       opCreateDBParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBParameterGroupInput{}
	}

	output = &CreateDBParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDBParameterGroup API operation for Amazon Relational Database Service.
//
// Creates a new DB parameter group.
//
// A DB parameter group is initially created with the default parameters for
// the database engine used by the DB instance. To provide custom values for
// any of the parameters, you must modify the group after creating it using
// ModifyDBParameterGroup. Once you've created a DB parameter group, you need
// to associate it with your DB instance using ModifyDBInstance. When you associate
// a new DB parameter group with a running DB instance, you need to reboot the
// DB instance without failover for the new DB parameter group and associated
// settings to take effect.
//
// After you create a DB parameter group, you should wait at least 5 minutes
// before creating your first DB instance that uses that DB parameter group
// as the default parameter group. This allows Amazon RDS to fully complete
// the create action before the parameter group is used as the default for a
// new DB instance. This is especially important for parameters that are critical
// when creating the default database for a DB instance, such as the character
// set for the default database defined by the character_set_database parameter.
// You can use the Parameter Groups option of the Amazon RDS console (https://console.aws.amazon.com/rds/)
// or the DescribeDBParameters command to verify that your DB parameter group
// has been created or modified.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation CreateDBParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBParameterGroupQuotaExceededFault "DBParameterGroupQuotaExceeded"
//   Request would result in user exceeding the allowed number of DB parameter
//   groups.
//
//   * ErrCodeDBParameterGroupAlreadyExistsFault "DBParameterGroupAlreadyExists"
//   A DB parameter group with the same name exists.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBParameterGroup
func (c *RDS) CreateDBParameterGroup(input *CreateDBParameterGroupInput) (*CreateDBParameterGroupOutput, error) {
	req, out := c.CreateDBParameterGroupRequest(input)
	return out, req.Send()
}

// CreateDBParameterGroupWithContext is the same as CreateDBParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDBParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) CreateDBParameterGroupWithContext(ctx aws.Context, input *CreateDBParameterGroupInput, opts ...request.Option) (*CreateDBParameterGroupOutput, error) {
	req, out := c.CreateDBParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDBSecurityGroup = "CreateDBSecurityGroup"

// CreateDBSecurityGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateDBSecurityGroup operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDBSecurityGroup for more information on using the CreateDBSecurityGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDBSecurityGroupRequest method.
//    req, resp := client.CreateDBSecurityGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSecurityGroup
func (c *RDS) CreateDBSecurityGroupRequest(input *CreateDBSecurityGroupInput) (req *request.Request, output *CreateDBSecurityGroupOutput) {
	op := &request.Operation{
		Name:       opCreateDBSecurityGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBSecurityGroupInput{}
	}

	output = &CreateDBSecurityGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDBSecurityGroup API operation for Amazon Relational Database Service.
//
// Creates a new DB security group. DB security groups control access to a DB
// instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation CreateDBSecurityGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBSecurityGroupAlreadyExistsFault "DBSecurityGroupAlreadyExists"
//   A DB security group with the name specified in DBSecurityGroupName already
//   exists.
//
//   * ErrCodeDBSecurityGroupQuotaExceededFault "QuotaExceeded.DBSecurityGroup"
//   Request would result in user exceeding the allowed number of DB security
//   groups.
//
//   * ErrCodeDBSecurityGroupNotSupportedFault "DBSecurityGroupNotSupported"
//   A DB security group is not allowed for this action.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSecurityGroup
func (c *RDS) CreateDBSecurityGroup(input *CreateDBSecurityGroupInput) (*CreateDBSecurityGroupOutput, error) {
	req, out := c.CreateDBSecurityGroupRequest(input)
	return out, req.Send()
}

// CreateDBSecurityGroupWithContext is the same as CreateDBSecurityGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDBSecurityGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) CreateDBSecurityGroupWithContext(ctx aws.Context, input *CreateDBSecurityGroupInput, opts ...request.Option) (*CreateDBSecurityGroupOutput, error) {
	req, out := c.CreateDBSecurityGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDBSnapshot = "CreateDBSnapshot"

// CreateDBSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CreateDBSnapshot operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDBSnapshot for more information on using the CreateDBSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDBSnapshotRequest method.
//    req, resp := client.CreateDBSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSnapshot
func (c *RDS) CreateDBSnapshotRequest(input *CreateDBSnapshotInput) (req *request.Request, output *CreateDBSnapshotOutput) {
	op := &request.Operation{
		Name:       opCreateDBSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBSnapshotInput{}
	}

	output = &CreateDBSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDBSnapshot API operation for Amazon Relational Database Service.
//
// Creates a DBSnapshot. The source DBInstance must be in "available" state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation CreateDBSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBSnapshotAlreadyExistsFault "DBSnapshotAlreadyExists"
//   DBSnapshotIdentifier is already used by an existing snapshot.
//
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The specified DB instance is not in the available state.
//
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier does not refer to an existing DB instance.
//
//   * ErrCodeSnapshotQuotaExceededFault "SnapshotQuotaExceeded"
//   Request would result in user exceeding the allowed number of DB snapshots.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSnapshot
func (c *RDS) CreateDBSnapshot(input *CreateDBSnapshotInput) (*CreateDBSnapshotOutput, error) {
	req, out := c.CreateDBSnapshotRequest(input)
	return out, req.Send()
}

// CreateDBSnapshotWithContext is the same as CreateDBSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDBSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) CreateDBSnapshotWithContext(ctx aws.Context, input *CreateDBSnapshotInput, opts ...request.Option) (*CreateDBSnapshotOutput, error) {
	req, out := c.CreateDBSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDBSubnetGroup = "CreateDBSubnetGroup"

// CreateDBSubnetGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateDBSubnetGroup operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDBSubnetGroup for more information on using the CreateDBSubnetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDBSubnetGroupRequest method.
//    req, resp := client.CreateDBSubnetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSubnetGroup
func (c *RDS) CreateDBSubnetGroupRequest(input *CreateDBSubnetGroupInput) (req *request.Request, output *CreateDBSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opCreateDBSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBSubnetGroupInput{}
	}

	output = &CreateDBSubnetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDBSubnetGroup API operation for Amazon Relational Database Service.
//
// Creates a new DB subnet group. DB subnet groups must contain at least one
// subnet in at least two AZs in the AWS Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation CreateDBSubnetGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBSubnetGroupAlreadyExistsFault "DBSubnetGroupAlreadyExists"
//   DBSubnetGroupName is already used by an existing DB subnet group.
//
//   * ErrCodeDBSubnetGroupQuotaExceededFault "DBSubnetGroupQuotaExceeded"
//   Request would result in user exceeding the allowed number of DB subnet groups.
//
//   * ErrCodeDBSubnetQuotaExceededFault "DBSubnetQuotaExceededFault"
//   Request would result in user exceeding the allowed number of subnets in a
//   DB subnet groups.
//
//   * ErrCodeDBSubnetGroupDoesNotCoverEnoughAZs "DBSubnetGroupDoesNotCoverEnoughAZs"
//   Subnets in the DB subnet group should cover at least two Availability Zones
//   unless there is only one Availability Zone.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is invalid, or multiple subnets were requested that
//   are not all in a common VPC.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSubnetGroup
func (c *RDS) CreateDBSubnetGroup(input *CreateDBSubnetGroupInput) (*CreateDBSubnetGroupOutput, error) {
	req, out := c.CreateDBSubnetGroupRequest(input)
	return out, req.Send()
}

// CreateDBSubnetGroupWithContext is the same as CreateDBSubnetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDBSubnetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) CreateDBSubnetGroupWithContext(ctx aws.Context, input *CreateDBSubnetGroupInput, opts ...request.Option) (*CreateDBSubnetGroupOutput, error) {
	req, out := c.CreateDBSubnetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEventSubscription = "CreateEventSubscription"

// CreateEventSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the CreateEventSubscription operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEventSubscription for more information on using the CreateEventSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateEventSubscriptionRequest method.
//    req, resp := client.CreateEventSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateEventSubscription
func (c *RDS) CreateEventSubscriptionRequest(input *CreateEventSubscriptionInput) (req *request.Request, output *CreateEventSubscriptionOutput) {
	op := &request.Operation{
		Name:       opCreateEventSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEventSubscriptionInput{}
	}

	output = &CreateEventSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEventSubscription API operation for Amazon Relational Database Service.
//
// Creates an RDS event notification subscription. This action requires a topic
// ARN (Amazon Resource Name) created by either the RDS console, the SNS console,
// or the SNS API. To obtain an ARN with SNS, you must create a topic in Amazon
// SNS and subscribe to the topic. The ARN is displayed in the SNS console.
//
// You can specify the type of source (SourceType) you want to be notified of,
// provide a list of RDS sources (SourceIds) that triggers the events, and provide
// a list of event categories (EventCategories) for events you want to be notified
// of. For example, you can specify SourceType = db-instance, SourceIds = mydbinstance1,
// mydbinstance2 and EventCategories = Availability, Backup.
//
// If you specify both the SourceType and SourceIds, such as SourceType = db-instance
// and SourceIdentifier = myDBInstance1, you will be notified of all the db-instance
// events for the specified source. If you specify a SourceType but do not specify
// a SourceIdentifier, you will receive notice of the events for that source
// type for all your RDS sources. If you do not specify either the SourceType
// nor the SourceIdentifier, you will be notified of events generated from all
// RDS sources belonging to your customer account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation CreateEventSubscription for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEventSubscriptionQuotaExceededFault "EventSubscriptionQuotaExceeded"
//   You have reached the maximum number of event subscriptions.
//
//   * ErrCodeSubscriptionAlreadyExistFault "SubscriptionAlreadyExist"
//   The supplied subscription name already exists.
//
//   * ErrCodeSNSInvalidTopicFault "SNSInvalidTopic"
//   SNS has responded that there is a problem with the SND topic specified.
//
//   * ErrCodeSNSNoAuthorizationFault "SNSNoAuthorization"
//   You do not have permission to publish to the SNS topic ARN.
//
//   * ErrCodeSNSTopicArnNotFoundFault "SNSTopicArnNotFound"
//   The SNS topic ARN does not exist.
//
//   * ErrCodeSubscriptionCategoryNotFoundFault "SubscriptionCategoryNotFound"
//   The supplied category does not exist.
//
//   * ErrCodeSourceNotFoundFault "SourceNotFound"
//   The requested source could not be found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateEventSubscription
func (c *RDS) CreateEventSubscription(input *CreateEventSubscriptionInput) (*CreateEventSubscriptionOutput, error) {
	req, out := c.CreateEventSubscriptionRequest(input)
	return out, req.Send()
}

// CreateEventSubscriptionWithContext is the same as CreateEventSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEventSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) CreateEventSubscriptionWithContext(ctx aws.Context, input *CreateEventSubscriptionInput, opts ...request.Option) (*CreateEventSubscriptionOutput, error) {
	req, out := c.CreateEventSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateOptionGroup = "CreateOptionGroup"

// CreateOptionGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateOptionGroup operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateOptionGroup for more information on using the CreateOptionGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateOptionGroupRequest method.
//    req, resp := client.CreateOptionGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateOptionGroup
func (c *RDS) CreateOptionGroupRequest(input *CreateOptionGroupInput) (req *request.Request, output *CreateOptionGroupOutput) {
	op := &request.Operation{
		Name:       opCreateOptionGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateOptionGroupInput{}
	}

	output = &CreateOptionGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateOptionGroup API operation for Amazon Relational Database Service.
//
// Creates a new option group. You can create up to 20 option groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation CreateOptionGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeOptionGroupAlreadyExistsFault "OptionGroupAlreadyExistsFault"
//   The option group you are trying to create already exists.
//
//   * ErrCodeOptionGroupQuotaExceededFault "OptionGroupQuotaExceededFault"
//   The quota of 20 option groups was exceeded for this AWS account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateOptionGroup
func (c *RDS) CreateOptionGroup(input *CreateOptionGroupInput) (*CreateOptionGroupOutput, error) {
	req, out := c.CreateOptionGroupRequest(input)
	return out, req.Send()
}

// CreateOptionGroupWithContext is the same as CreateOptionGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateOptionGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) CreateOptionGroupWithContext(ctx aws.Context, input *CreateOptionGroupInput, opts ...request.Option) (*CreateOptionGroupOutput, error) {
	req, out := c.CreateOptionGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDBCluster = "DeleteDBCluster"

// DeleteDBClusterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDBCluster operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDBCluster for more information on using the DeleteDBCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDBClusterRequest method.
//    req, resp := client.DeleteDBClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBCluster
func (c *RDS) DeleteDBClusterRequest(input *DeleteDBClusterInput) (req *request.Request, output *DeleteDBClusterOutput) {
	op := &request.Operation{
		Name:       opDeleteDBCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBClusterInput{}
	}

	output = &DeleteDBClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDBCluster API operation for Amazon Relational Database Service.
//
// The DeleteDBCluster action deletes a previously provisioned DB cluster. When
// you delete a DB cluster, all automated backups for that DB cluster are deleted
// and cannot be recovered. Manual DB cluster snapshots of the specified DB
// cluster are not deleted.
//
// For more information on Amazon Aurora, see Aurora on Amazon RDS (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html)in the Amazon RDS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DeleteDBCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier does not refer to an existing DB cluster.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The DB cluster is not in a valid state.
//
//   * ErrCodeDBClusterSnapshotAlreadyExistsFault "DBClusterSnapshotAlreadyExistsFault"
//   User already has a DB cluster snapshot with the given identifier.
//
//   * ErrCodeSnapshotQuotaExceededFault "SnapshotQuotaExceeded"
//   Request would result in user exceeding the allowed number of DB snapshots.
//
//   * ErrCodeInvalidDBClusterSnapshotStateFault "InvalidDBClusterSnapshotStateFault"
//   The supplied value is not a valid DB cluster snapshot state.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBCluster
func (c *RDS) DeleteDBCluster(input *DeleteDBClusterInput) (*DeleteDBClusterOutput, error) {
	req, out := c.DeleteDBClusterRequest(input)
	return out, req.Send()
}

// DeleteDBClusterWithContext is the same as DeleteDBCluster with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDBCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DeleteDBClusterWithContext(ctx aws.Context, input *DeleteDBClusterInput, opts ...request.Option) (*DeleteDBClusterOutput, error) {
	req, out := c.DeleteDBClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDBClusterParameterGroup = "DeleteDBClusterParameterGroup"

// DeleteDBClusterParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDBClusterParameterGroup operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDBClusterParameterGroup for more information on using the DeleteDBClusterParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDBClusterParameterGroupRequest method.
//    req, resp := client.DeleteDBClusterParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterParameterGroup
func (c *RDS) DeleteDBClusterParameterGroupRequest(input *DeleteDBClusterParameterGroupInput) (req *request.Request, output *DeleteDBClusterParameterGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteDBClusterParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBClusterParameterGroupInput{}
	}

	output = &DeleteDBClusterParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDBClusterParameterGroup API operation for Amazon Relational Database Service.
//
// Deletes a specified DB cluster parameter group. The DB cluster parameter
// group to be deleted cannot be associated with any DB clusters.
//
// For more information on Amazon Aurora, see Aurora on Amazon RDS (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html)
// in the Amazon RDS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DeleteDBClusterParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBParameterGroupStateFault "InvalidDBParameterGroupState"
//   The DB parameter group is in use or is in an invalid state. If you are attempting
//   to delete the parameter group, you cannot delete it when the parameter group
//   is in this state.
//
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName does not refer to an existing DB parameter group.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterParameterGroup
func (c *RDS) DeleteDBClusterParameterGroup(input *DeleteDBClusterParameterGroupInput) (*DeleteDBClusterParameterGroupOutput, error) {
	req, out := c.DeleteDBClusterParameterGroupRequest(input)
	return out, req.Send()
}

// DeleteDBClusterParameterGroupWithContext is the same as DeleteDBClusterParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDBClusterParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DeleteDBClusterParameterGroupWithContext(ctx aws.Context, input *DeleteDBClusterParameterGroupInput, opts ...request.Option) (*DeleteDBClusterParameterGroupOutput, error) {
	req, out := c.DeleteDBClusterParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDBClusterSnapshot = "DeleteDBClusterSnapshot"

// DeleteDBClusterSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDBClusterSnapshot operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDBClusterSnapshot for more information on using the DeleteDBClusterSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDBClusterSnapshotRequest method.
//    req, resp := client.DeleteDBClusterSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterSnapshot
func (c *RDS) DeleteDBClusterSnapshotRequest(input *DeleteDBClusterSnapshotInput) (req *request.Request, output *DeleteDBClusterSnapshotOutput) {
	op := &request.Operation{
		Name:       opDeleteDBClusterSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBClusterSnapshotInput{}
	}

	output = &DeleteDBClusterSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDBClusterSnapshot API operation for Amazon Relational Database Service.
//
// Deletes a DB cluster snapshot. If the snapshot is being copied, the copy
// operation is terminated.
//
// The DB cluster snapshot must be in the available state to be deleted.
//
// For more information on Amazon Aurora, see Aurora on Amazon RDS (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html)
// in the Amazon RDS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DeleteDBClusterSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBClusterSnapshotStateFault "InvalidDBClusterSnapshotStateFault"
//   The supplied value is not a valid DB cluster snapshot state.
//
//   * ErrCodeDBClusterSnapshotNotFoundFault "DBClusterSnapshotNotFoundFault"
//   DBClusterSnapshotIdentifier does not refer to an existing DB cluster snapshot.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterSnapshot
func (c *RDS) DeleteDBClusterSnapshot(input *DeleteDBClusterSnapshotInput) (*DeleteDBClusterSnapshotOutput, error) {
	req, out := c.DeleteDBClusterSnapshotRequest(input)
	return out, req.Send()
}

// DeleteDBClusterSnapshotWithContext is the same as DeleteDBClusterSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDBClusterSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DeleteDBClusterSnapshotWithContext(ctx aws.Context, input *DeleteDBClusterSnapshotInput, opts ...request.Option) (*DeleteDBClusterSnapshotOutput, error) {
	req, out := c.DeleteDBClusterSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDBInstance = "DeleteDBInstance"

// DeleteDBInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDBInstance operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDBInstance for more information on using the DeleteDBInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDBInstanceRequest method.
//    req, resp := client.DeleteDBInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBInstance
func (c *RDS) DeleteDBInstanceRequest(input *DeleteDBInstanceInput) (req *request.Request, output *DeleteDBInstanceOutput) {
	op := &request.Operation{
		Name:       opDeleteDBInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBInstanceInput{}
	}

	output = &DeleteDBInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDBInstance API operation for Amazon Relational Database Service.
//
// The DeleteDBInstance action deletes a previously provisioned DB instance.
// When you delete a DB instance, all automated backups for that instance are
// deleted and cannot be recovered. Manual DB snapshots of the DB instance to
// be deleted by DeleteDBInstance are not deleted.
//
// If you request a final DB snapshot the status of the Amazon RDS DB instance
// is deleting until the DB snapshot is created. The API action DescribeDBInstance
// is used to monitor the status of this operation. The action cannot be canceled
// or reverted once submitted.
//
// Note that when a DB instance is in a failure state and has a status of failed,
// incompatible-restore, or incompatible-network, you can only delete it when
// the SkipFinalSnapshot parameter is set to true.
//
// If the specified DB instance is part of an Amazon Aurora DB cluster, you
// cannot delete the DB instance if the following are true:
//
//    * The DB cluster is a Read Replica of another Amazon Aurora DB cluster.
//
//    * The DB instance is the only instance in the DB cluster.
//
// To delete a DB instance in this case, first call the PromoteReadReplicaDBCluster
// API action to promote the DB cluster so it's no longer a Read Replica. After
// the promotion completes, then call the DeleteDBInstance API action to delete
// the final instance in the DB cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DeleteDBInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier does not refer to an existing DB instance.
//
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The specified DB instance is not in the available state.
//
//   * ErrCodeDBSnapshotAlreadyExistsFault "DBSnapshotAlreadyExists"
//   DBSnapshotIdentifier is already used by an existing snapshot.
//
//   * ErrCodeSnapshotQuotaExceededFault "SnapshotQuotaExceeded"
//   Request would result in user exceeding the allowed number of DB snapshots.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The DB cluster is not in a valid state.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBInstance
func (c *RDS) DeleteDBInstance(input *DeleteDBInstanceInput) (*DeleteDBInstanceOutput, error) {
	req, out := c.DeleteDBInstanceRequest(input)
	return out, req.Send()
}

// DeleteDBInstanceWithContext is the same as DeleteDBInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDBInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DeleteDBInstanceWithContext(ctx aws.Context, input *DeleteDBInstanceInput, opts ...request.Option) (*DeleteDBInstanceOutput, error) {
	req, out := c.DeleteDBInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDBParameterGroup = "DeleteDBParameterGroup"

// DeleteDBParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDBParameterGroup operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDBParameterGroup for more information on using the DeleteDBParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDBParameterGroupRequest method.
//    req, resp := client.DeleteDBParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBParameterGroup
func (c *RDS) DeleteDBParameterGroupRequest(input *DeleteDBParameterGroupInput) (req *request.Request, output *DeleteDBParameterGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteDBParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBParameterGroupInput{}
	}

	output = &DeleteDBParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDBParameterGroup API operation for Amazon Relational Database Service.
//
// Deletes a specified DBParameterGroup. The DBParameterGroup to be deleted
// cannot be associated with any DB instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DeleteDBParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBParameterGroupStateFault "InvalidDBParameterGroupState"
//   The DB parameter group is in use or is in an invalid state. If you are attempting
//   to delete the parameter group, you cannot delete it when the parameter group
//   is in this state.
//
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName does not refer to an existing DB parameter group.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBParameterGroup
func (c *RDS) DeleteDBParameterGroup(input *DeleteDBParameterGroupInput) (*DeleteDBParameterGroupOutput, error) {
	req, out := c.DeleteDBParameterGroupRequest(input)
	return out, req.Send()
}

// DeleteDBParameterGroupWithContext is the same as DeleteDBParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDBParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DeleteDBParameterGroupWithContext(ctx aws.Context, input *DeleteDBParameterGroupInput, opts ...request.Option) (*DeleteDBParameterGroupOutput, error) {
	req, out := c.DeleteDBParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDBSecurityGroup = "DeleteDBSecurityGroup"

// DeleteDBSecurityGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDBSecurityGroup operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDBSecurityGroup for more information on using the DeleteDBSecurityGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDBSecurityGroupRequest method.
//    req, resp := client.DeleteDBSecurityGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSecurityGroup
func (c *RDS) DeleteDBSecurityGroupRequest(input *DeleteDBSecurityGroupInput) (req *request.Request, output *DeleteDBSecurityGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteDBSecurityGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBSecurityGroupInput{}
	}

	output = &DeleteDBSecurityGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDBSecurityGroup API operation for Amazon Relational Database Service.
//
// Deletes a DB security group.
//
// The specified DB security group must not be associated with any DB instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DeleteDBSecurityGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBSecurityGroupStateFault "InvalidDBSecurityGroupState"
//   The state of the DB security group does not allow deletion.
//
//   * ErrCodeDBSecurityGroupNotFoundFault "DBSecurityGroupNotFound"
//   DBSecurityGroupName does not refer to an existing DB security group.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSecurityGroup
func (c *RDS) DeleteDBSecurityGroup(input *DeleteDBSecurityGroupInput) (*DeleteDBSecurityGroupOutput, error) {
	req, out := c.DeleteDBSecurityGroupRequest(input)
	return out, req.Send()
}

// DeleteDBSecurityGroupWithContext is the same as DeleteDBSecurityGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDBSecurityGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DeleteDBSecurityGroupWithContext(ctx aws.Context, input *DeleteDBSecurityGroupInput, opts ...request.Option) (*DeleteDBSecurityGroupOutput, error) {
	req, out := c.DeleteDBSecurityGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDBSnapshot = "DeleteDBSnapshot"

// DeleteDBSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDBSnapshot operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDBSnapshot for more information on using the DeleteDBSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDBSnapshotRequest method.
//    req, resp := client.DeleteDBSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSnapshot
func (c *RDS) DeleteDBSnapshotRequest(input *DeleteDBSnapshotInput) (req *request.Request, output *DeleteDBSnapshotOutput) {
	op := &request.Operation{
		Name:       opDeleteDBSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBSnapshotInput{}
	}

	output = &DeleteDBSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDBSnapshot API operation for Amazon Relational Database Service.
//
// Deletes a DBSnapshot. If the snapshot is being copied, the copy operation
// is terminated.
//
// The DBSnapshot must be in the available state to be deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DeleteDBSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBSnapshotStateFault "InvalidDBSnapshotState"
//   The state of the DB snapshot does not allow deletion.
//
//   * ErrCodeDBSnapshotNotFoundFault "DBSnapshotNotFound"
//   DBSnapshotIdentifier does not refer to an existing DB snapshot.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSnapshot
func (c *RDS) DeleteDBSnapshot(input *DeleteDBSnapshotInput) (*DeleteDBSnapshotOutput, error) {
	req, out := c.DeleteDBSnapshotRequest(input)
	return out, req.Send()
}

// DeleteDBSnapshotWithContext is the same as DeleteDBSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDBSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DeleteDBSnapshotWithContext(ctx aws.Context, input *DeleteDBSnapshotInput, opts ...request.Option) (*DeleteDBSnapshotOutput, error) {
	req, out := c.DeleteDBSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDBSubnetGroup = "DeleteDBSubnetGroup"

// DeleteDBSubnetGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDBSubnetGroup operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDBSubnetGroup for more information on using the DeleteDBSubnetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDBSubnetGroupRequest method.
//    req, resp := client.DeleteDBSubnetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSubnetGroup
func (c *RDS) DeleteDBSubnetGroupRequest(input *DeleteDBSubnetGroupInput) (req *request.Request, output *DeleteDBSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteDBSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDBSubnetGroupInput{}
	}

	output = &DeleteDBSubnetGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDBSubnetGroup API operation for Amazon Relational Database Service.
//
// Deletes a DB subnet group.
//
// The specified database subnet group must not be associated with any DB instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DeleteDBSubnetGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBSubnetGroupStateFault "InvalidDBSubnetGroupStateFault"
//   The DB subnet group cannot be deleted because it is in use.
//
//   * ErrCodeInvalidDBSubnetStateFault "InvalidDBSubnetStateFault"
//   The DB subnet is not in the available state.
//
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName does not refer to an existing DB subnet group.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSubnetGroup
func (c *RDS) DeleteDBSubnetGroup(input *DeleteDBSubnetGroupInput) (*DeleteDBSubnetGroupOutput, error) {
	req, out := c.DeleteDBSubnetGroupRequest(input)
	return out, req.Send()
}

// DeleteDBSubnetGroupWithContext is the same as DeleteDBSubnetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDBSubnetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DeleteDBSubnetGroupWithContext(ctx aws.Context, input *DeleteDBSubnetGroupInput, opts ...request.Option) (*DeleteDBSubnetGroupOutput, error) {
	req, out := c.DeleteDBSubnetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEventSubscription = "DeleteEventSubscription"

// DeleteEventSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEventSubscription operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEventSubscription for more information on using the DeleteEventSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEventSubscriptionRequest method.
//    req, resp := client.DeleteEventSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteEventSubscription
func (c *RDS) DeleteEventSubscriptionRequest(input *DeleteEventSubscriptionInput) (req *request.Request, output *DeleteEventSubscriptionOutput) {
	op := &request.Operation{
		Name:       opDeleteEventSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEventSubscriptionInput{}
	}

	output = &DeleteEventSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteEventSubscription API operation for Amazon Relational Database Service.
//
// Deletes an RDS event notification subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DeleteEventSubscription for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeSubscriptionNotFoundFault "SubscriptionNotFound"
//   The subscription name does not exist.
//
//   * ErrCodeInvalidEventSubscriptionStateFault "InvalidEventSubscriptionState"
//   This error can occur if someone else is modifying a subscription. You should
//   retry the action.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteEventSubscription
func (c *RDS) DeleteEventSubscription(input *DeleteEventSubscriptionInput) (*DeleteEventSubscriptionOutput, error) {
	req, out := c.DeleteEventSubscriptionRequest(input)
	return out, req.Send()
}

// DeleteEventSubscriptionWithContext is the same as DeleteEventSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEventSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DeleteEventSubscriptionWithContext(ctx aws.Context, input *DeleteEventSubscriptionInput, opts ...request.Option) (*DeleteEventSubscriptionOutput, error) {
	req, out := c.DeleteEventSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteOptionGroup = "DeleteOptionGroup"

// DeleteOptionGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteOptionGroup operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteOptionGroup for more information on using the DeleteOptionGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteOptionGroupRequest method.
//    req, resp := client.DeleteOptionGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteOptionGroup
func (c *RDS) DeleteOptionGroupRequest(input *DeleteOptionGroupInput) (req *request.Request, output *DeleteOptionGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteOptionGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteOptionGroupInput{}
	}

	output = &DeleteOptionGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteOptionGroup API operation for Amazon Relational Database Service.
//
// Deletes an existing option group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DeleteOptionGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeOptionGroupNotFoundFault "OptionGroupNotFoundFault"
//   The specified option group could not be found.
//
//   * ErrCodeInvalidOptionGroupStateFault "InvalidOptionGroupStateFault"
//   The option group is not in the available state.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteOptionGroup
func (c *RDS) DeleteOptionGroup(input *DeleteOptionGroupInput) (*DeleteOptionGroupOutput, error) {
	req, out := c.DeleteOptionGroupRequest(input)
	return out, req.Send()
}

// DeleteOptionGroupWithContext is the same as DeleteOptionGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteOptionGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DeleteOptionGroupWithContext(ctx aws.Context, input *DeleteOptionGroupInput, opts ...request.Option) (*DeleteOptionGroupOutput, error) {
	req, out := c.DeleteOptionGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccountAttributes = "DescribeAccountAttributes"

// DescribeAccountAttributesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountAttributes operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccountAttributes for more information on using the DescribeAccountAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAccountAttributesRequest method.
//    req, resp := client.DescribeAccountAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeAccountAttributes
func (c *RDS) DescribeAccountAttributesRequest(input *DescribeAccountAttributesInput) (req *request.Request, output *DescribeAccountAttributesOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAccountAttributesInput{}
	}

	output = &DescribeAccountAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountAttributes API operation for Amazon Relational Database Service.
//
// Lists all of the attributes for a customer account. The attributes include
// Amazon RDS quotas for the account, such as the number of DB instances allowed.
// The description for a quota includes the quota name, current usage toward
// that quota, and the quota's maximum value.
//
// This command does not take any parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeAccountAttributes for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeAccountAttributes
func (c *RDS) DescribeAccountAttributes(input *DescribeAccountAttributesInput) (*DescribeAccountAttributesOutput, error) {
	req, out := c.DescribeAccountAttributesRequest(input)
	return out, req.Send()
}

// DescribeAccountAttributesWithContext is the same as DescribeAccountAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccountAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeAccountAttributesWithContext(ctx aws.Context, input *DescribeAccountAttributesInput, opts ...request.Option) (*DescribeAccountAttributesOutput, error) {
	req, out := c.DescribeAccountAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCertificates = "DescribeCertificates"

// DescribeCertificatesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCertificates operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCertificates for more information on using the DescribeCertificates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCertificatesRequest method.
//    req, resp := client.DescribeCertificatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeCertificates
func (c *RDS) DescribeCertificatesRequest(input *DescribeCertificatesInput) (req *request.Request, output *DescribeCertificatesOutput) {
	op := &request.Operation{
		Name:       opDescribeCertificates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCertificatesInput{}
	}

	output = &DescribeCertificatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCertificates API operation for Amazon Relational Database Service.
//
// Lists the set of CA certificates provided by Amazon RDS for this AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeCertificates for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCertificateNotFoundFault "CertificateNotFound"
//   CertificateIdentifier does not refer to an existing certificate.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeCertificates
func (c *RDS) DescribeCertificates(input *DescribeCertificatesInput) (*DescribeCertificatesOutput, error) {
	req, out := c.DescribeCertificatesRequest(input)
	return out, req.Send()
}

// DescribeCertificatesWithContext is the same as DescribeCertificates with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCertificates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeCertificatesWithContext(ctx aws.Context, input *DescribeCertificatesInput, opts ...request.Option) (*DescribeCertificatesOutput, error) {
	req, out := c.DescribeCertificatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDBClusterParameterGroups = "DescribeDBClusterParameterGroups"

// DescribeDBClusterParameterGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBClusterParameterGroups operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBClusterParameterGroups for more information on using the DescribeDBClusterParameterGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBClusterParameterGroupsRequest method.
//    req, resp := client.DescribeDBClusterParameterGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterParameterGroups
func (c *RDS) DescribeDBClusterParameterGroupsRequest(input *DescribeDBClusterParameterGroupsInput) (req *request.Request, output *DescribeDBClusterParameterGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeDBClusterParameterGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDBClusterParameterGroupsInput{}
	}

	output = &DescribeDBClusterParameterGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBClusterParameterGroups API operation for Amazon Relational Database Service.
//
// Returns a list of DBClusterParameterGroup descriptions. If a DBClusterParameterGroupName
// parameter is specified, the list will contain only the description of the
// specified DB cluster parameter group.
//
// For more information on Amazon Aurora, see Aurora on Amazon RDS (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html)
// in the Amazon RDS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeDBClusterParameterGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName does not refer to an existing DB parameter group.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterParameterGroups
func (c *RDS) DescribeDBClusterParameterGroups(input *DescribeDBClusterParameterGroupsInput) (*DescribeDBClusterParameterGroupsOutput, error) {
	req, out := c.DescribeDBClusterParameterGroupsRequest(input)
	return out, req.Send()
}

// DescribeDBClusterParameterGroupsWithContext is the same as DescribeDBClusterParameterGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBClusterParameterGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBClusterParameterGroupsWithContext(ctx aws.Context, input *DescribeDBClusterParameterGroupsInput, opts ...request.Option) (*DescribeDBClusterParameterGroupsOutput, error) {
	req, out := c.DescribeDBClusterParameterGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDBClusterParameters = "DescribeDBClusterParameters"

// DescribeDBClusterParametersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBClusterParameters operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBClusterParameters for more information on using the DescribeDBClusterParameters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBClusterParametersRequest method.
//    req, resp := client.DescribeDBClusterParametersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterParameters
func (c *RDS) DescribeDBClusterParametersRequest(input *DescribeDBClusterParametersInput) (req *request.Request, output *DescribeDBClusterParametersOutput) {
	op := &request.Operation{
		Name:       opDescribeDBClusterParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDBClusterParametersInput{}
	}

	output = &DescribeDBClusterParametersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBClusterParameters API operation for Amazon Relational Database Service.
//
// Returns the detailed parameter list for a particular DB cluster parameter
// group.
//
// For more information on Amazon Aurora, see Aurora on Amazon RDS (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html)
// in the Amazon RDS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeDBClusterParameters for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName does not refer to an existing DB parameter group.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterParameters
func (c *RDS) DescribeDBClusterParameters(input *DescribeDBClusterParametersInput) (*DescribeDBClusterParametersOutput, error) {
	req, out := c.DescribeDBClusterParametersRequest(input)
	return out, req.Send()
}

// DescribeDBClusterParametersWithContext is the same as DescribeDBClusterParameters with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBClusterParameters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBClusterParametersWithContext(ctx aws.Context, input *DescribeDBClusterParametersInput, opts ...request.Option) (*DescribeDBClusterParametersOutput, error) {
	req, out := c.DescribeDBClusterParametersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDBClusterSnapshotAttributes = "DescribeDBClusterSnapshotAttributes"

// DescribeDBClusterSnapshotAttributesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBClusterSnapshotAttributes operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBClusterSnapshotAttributes for more information on using the DescribeDBClusterSnapshotAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBClusterSnapshotAttributesRequest method.
//    req, resp := client.DescribeDBClusterSnapshotAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterSnapshotAttributes
func (c *RDS) DescribeDBClusterSnapshotAttributesRequest(input *DescribeDBClusterSnapshotAttributesInput) (req *request.Request, output *DescribeDBClusterSnapshotAttributesOutput) {
	op := &request.Operation{
		Name:       opDescribeDBClusterSnapshotAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDBClusterSnapshotAttributesInput{}
	}

	output = &DescribeDBClusterSnapshotAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBClusterSnapshotAttributes API operation for Amazon Relational Database Service.
//
// Returns a list of DB cluster snapshot attribute names and values for a manual
// DB cluster snapshot.
//
// When sharing snapshots with other AWS accounts, DescribeDBClusterSnapshotAttributes
// returns the restore attribute and a list of IDs for the AWS accounts that
// are authorized to copy or restore the manual DB cluster snapshot. If all
// is included in the list of values for the restore attribute, then the manual
// DB cluster snapshot is public and can be copied or restored by all AWS accounts.
//
// To add or remove access for an AWS account to copy or restore a manual DB
// cluster snapshot, or to make the manual DB cluster snapshot public or private,
// use the ModifyDBClusterSnapshotAttribute API action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeDBClusterSnapshotAttributes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterSnapshotNotFoundFault "DBClusterSnapshotNotFoundFault"
//   DBClusterSnapshotIdentifier does not refer to an existing DB cluster snapshot.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterSnapshotAttributes
func (c *RDS) DescribeDBClusterSnapshotAttributes(input *DescribeDBClusterSnapshotAttributesInput) (*DescribeDBClusterSnapshotAttributesOutput, error) {
	req, out := c.DescribeDBClusterSnapshotAttributesRequest(input)
	return out, req.Send()
}

// DescribeDBClusterSnapshotAttributesWithContext is the same as DescribeDBClusterSnapshotAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBClusterSnapshotAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBClusterSnapshotAttributesWithContext(ctx aws.Context, input *DescribeDBClusterSnapshotAttributesInput, opts ...request.Option) (*DescribeDBClusterSnapshotAttributesOutput, error) {
	req, out := c.DescribeDBClusterSnapshotAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDBClusterSnapshots = "DescribeDBClusterSnapshots"

// DescribeDBClusterSnapshotsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBClusterSnapshots operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBClusterSnapshots for more information on using the DescribeDBClusterSnapshots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBClusterSnapshotsRequest method.
//    req, resp := client.DescribeDBClusterSnapshotsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterSnapshots
func (c *RDS) DescribeDBClusterSnapshotsRequest(input *DescribeDBClusterSnapshotsInput) (req *request.Request, output *DescribeDBClusterSnapshotsOutput) {
	op := &request.Operation{
		Name:       opDescribeDBClusterSnapshots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDBClusterSnapshotsInput{}
	}

	output = &DescribeDBClusterSnapshotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBClusterSnapshots API operation for Amazon Relational Database Service.
//
// Returns information about DB cluster snapshots. This API action supports
// pagination.
//
// For more information on Amazon Aurora, see Aurora on Amazon RDS (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html)
// in the Amazon RDS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeDBClusterSnapshots for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterSnapshotNotFoundFault "DBClusterSnapshotNotFoundFault"
//   DBClusterSnapshotIdentifier does not refer to an existing DB cluster snapshot.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterSnapshots
func (c *RDS) DescribeDBClusterSnapshots(input *DescribeDBClusterSnapshotsInput) (*DescribeDBClusterSnapshotsOutput, error) {
	req, out := c.DescribeDBClusterSnapshotsRequest(input)
	return out, req.Send()
}

// DescribeDBClusterSnapshotsWithContext is the same as DescribeDBClusterSnapshots with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBClusterSnapshots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBClusterSnapshotsWithContext(ctx aws.Context, input *DescribeDBClusterSnapshotsInput, opts ...request.Option) (*DescribeDBClusterSnapshotsOutput, error) {
	req, out := c.DescribeDBClusterSnapshotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDBClusters = "DescribeDBClusters"

// DescribeDBClustersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBClusters operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBClusters for more information on using the DescribeDBClusters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBClustersRequest method.
//    req, resp := client.DescribeDBClustersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusters
func (c *RDS) DescribeDBClustersRequest(input *DescribeDBClustersInput) (req *request.Request, output *DescribeDBClustersOutput) {
	op := &request.Operation{
		Name:       opDescribeDBClusters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDBClustersInput{}
	}

	output = &DescribeDBClustersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBClusters API operation for Amazon Relational Database Service.
//
// Returns information about provisioned Aurora DB clusters. This API supports
// pagination.
//
// For more information on Amazon Aurora, see Aurora on Amazon RDS (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html)
// in the Amazon RDS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeDBClusters for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier does not refer to an existing DB cluster.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusters
func (c *RDS) DescribeDBClusters(input *DescribeDBClustersInput) (*DescribeDBClustersOutput, error) {
	req, out := c.DescribeDBClustersRequest(input)
	return out, req.Send()
}

// DescribeDBClustersWithContext is the same as DescribeDBClusters with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBClusters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBClustersWithContext(ctx aws.Context, input *DescribeDBClustersInput, opts ...request.Option) (*DescribeDBClustersOutput, error) {
	req, out := c.DescribeDBClustersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDBEngineVersions = "DescribeDBEngineVersions"

// DescribeDBEngineVersionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBEngineVersions operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBEngineVersions for more information on using the DescribeDBEngineVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBEngineVersionsRequest method.
//    req, resp := client.DescribeDBEngineVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBEngineVersions
func (c *RDS) DescribeDBEngineVersionsRequest(input *DescribeDBEngineVersionsInput) (req *request.Request, output *DescribeDBEngineVersionsOutput) {
	op := &request.Operation{
		Name:       opDescribeDBEngineVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBEngineVersionsInput{}
	}

	output = &DescribeDBEngineVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBEngineVersions API operation for Amazon Relational Database Service.
//
// Returns a list of the available DB engines.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeDBEngineVersions for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBEngineVersions
func (c *RDS) DescribeDBEngineVersions(input *DescribeDBEngineVersionsInput) (*DescribeDBEngineVersionsOutput, error) {
	req, out := c.DescribeDBEngineVersionsRequest(input)
	return out, req.Send()
}

// DescribeDBEngineVersionsWithContext is the same as DescribeDBEngineVersions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBEngineVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBEngineVersionsWithContext(ctx aws.Context, input *DescribeDBEngineVersionsInput, opts ...request.Option) (*DescribeDBEngineVersionsOutput, error) {
	req, out := c.DescribeDBEngineVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDBEngineVersionsPages iterates over the pages of a DescribeDBEngineVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDBEngineVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDBEngineVersions operation.
//    pageNum := 0
//    err := client.DescribeDBEngineVersionsPages(params,
//        func(page *DescribeDBEngineVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeDBEngineVersionsPages(input *DescribeDBEngineVersionsInput, fn func(*DescribeDBEngineVersionsOutput, bool) bool) error {
	return c.DescribeDBEngineVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDBEngineVersionsPagesWithContext same as DescribeDBEngineVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBEngineVersionsPagesWithContext(ctx aws.Context, input *DescribeDBEngineVersionsInput, fn func(*DescribeDBEngineVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDBEngineVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDBEngineVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeDBEngineVersionsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeDBInstances = "DescribeDBInstances"

// DescribeDBInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBInstances operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBInstances for more information on using the DescribeDBInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBInstancesRequest method.
//    req, resp := client.DescribeDBInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBInstances
func (c *RDS) DescribeDBInstancesRequest(input *DescribeDBInstancesInput) (req *request.Request, output *DescribeDBInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeDBInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBInstancesInput{}
	}

	output = &DescribeDBInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBInstances API operation for Amazon Relational Database Service.
//
// Returns information about provisioned RDS instances. This API supports pagination.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeDBInstances for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier does not refer to an existing DB instance.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBInstances
func (c *RDS) DescribeDBInstances(input *DescribeDBInstancesInput) (*DescribeDBInstancesOutput, error) {
	req, out := c.DescribeDBInstancesRequest(input)
	return out, req.Send()
}

// DescribeDBInstancesWithContext is the same as DescribeDBInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBInstancesWithContext(ctx aws.Context, input *DescribeDBInstancesInput, opts ...request.Option) (*DescribeDBInstancesOutput, error) {
	req, out := c.DescribeDBInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDBInstancesPages iterates over the pages of a DescribeDBInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDBInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDBInstances operation.
//    pageNum := 0
//    err := client.DescribeDBInstancesPages(params,
//        func(page *DescribeDBInstancesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeDBInstancesPages(input *DescribeDBInstancesInput, fn func(*DescribeDBInstancesOutput, bool) bool) error {
	return c.DescribeDBInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDBInstancesPagesWithContext same as DescribeDBInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBInstancesPagesWithContext(ctx aws.Context, input *DescribeDBInstancesInput, fn func(*DescribeDBInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDBInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDBInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeDBInstancesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeDBLogFiles = "DescribeDBLogFiles"

// DescribeDBLogFilesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBLogFiles operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBLogFiles for more information on using the DescribeDBLogFiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBLogFilesRequest method.
//    req, resp := client.DescribeDBLogFilesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBLogFiles
func (c *RDS) DescribeDBLogFilesRequest(input *DescribeDBLogFilesInput) (req *request.Request, output *DescribeDBLogFilesOutput) {
	op := &request.Operation{
		Name:       opDescribeDBLogFiles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBLogFilesInput{}
	}

	output = &DescribeDBLogFilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBLogFiles API operation for Amazon Relational Database Service.
//
// Returns a list of DB log files for the DB instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeDBLogFiles for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier does not refer to an existing DB instance.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBLogFiles
func (c *RDS) DescribeDBLogFiles(input *DescribeDBLogFilesInput) (*DescribeDBLogFilesOutput, error) {
	req, out := c.DescribeDBLogFilesRequest(input)
	return out, req.Send()
}

// DescribeDBLogFilesWithContext is the same as DescribeDBLogFiles with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBLogFiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBLogFilesWithContext(ctx aws.Context, input *DescribeDBLogFilesInput, opts ...request.Option) (*DescribeDBLogFilesOutput, error) {
	req, out := c.DescribeDBLogFilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDBLogFilesPages iterates over the pages of a DescribeDBLogFiles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDBLogFiles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDBLogFiles operation.
//    pageNum := 0
//    err := client.DescribeDBLogFilesPages(params,
//        func(page *DescribeDBLogFilesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeDBLogFilesPages(input *DescribeDBLogFilesInput, fn func(*DescribeDBLogFilesOutput, bool) bool) error {
	return c.DescribeDBLogFilesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDBLogFilesPagesWithContext same as DescribeDBLogFilesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBLogFilesPagesWithContext(ctx aws.Context, input *DescribeDBLogFilesInput, fn func(*DescribeDBLogFilesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDBLogFilesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDBLogFilesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeDBLogFilesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeDBParameterGroups = "DescribeDBParameterGroups"

// DescribeDBParameterGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBParameterGroups operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBParameterGroups for more information on using the DescribeDBParameterGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBParameterGroupsRequest method.
//    req, resp := client.DescribeDBParameterGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBParameterGroups
func (c *RDS) DescribeDBParameterGroupsRequest(input *DescribeDBParameterGroupsInput) (req *request.Request, output *DescribeDBParameterGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeDBParameterGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBParameterGroupsInput{}
	}

	output = &DescribeDBParameterGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBParameterGroups API operation for Amazon Relational Database Service.
//
// Returns a list of DBParameterGroup descriptions. If a DBParameterGroupName
// is specified, the list will contain only the description of the specified
// DB parameter group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeDBParameterGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName does not refer to an existing DB parameter group.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBParameterGroups
func (c *RDS) DescribeDBParameterGroups(input *DescribeDBParameterGroupsInput) (*DescribeDBParameterGroupsOutput, error) {
	req, out := c.DescribeDBParameterGroupsRequest(input)
	return out, req.Send()
}

// DescribeDBParameterGroupsWithContext is the same as DescribeDBParameterGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBParameterGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBParameterGroupsWithContext(ctx aws.Context, input *DescribeDBParameterGroupsInput, opts ...request.Option) (*DescribeDBParameterGroupsOutput, error) {
	req, out := c.DescribeDBParameterGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDBParameterGroupsPages iterates over the pages of a DescribeDBParameterGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDBParameterGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDBParameterGroups operation.
//    pageNum := 0
//    err := client.DescribeDBParameterGroupsPages(params,
//        func(page *DescribeDBParameterGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeDBParameterGroupsPages(input *DescribeDBParameterGroupsInput, fn func(*DescribeDBParameterGroupsOutput, bool) bool) error {
	return c.DescribeDBParameterGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDBParameterGroupsPagesWithContext same as DescribeDBParameterGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBParameterGroupsPagesWithContext(ctx aws.Context, input *DescribeDBParameterGroupsInput, fn func(*DescribeDBParameterGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDBParameterGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDBParameterGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeDBParameterGroupsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeDBParameters = "DescribeDBParameters"

// DescribeDBParametersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBParameters operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBParameters for more information on using the DescribeDBParameters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBParametersRequest method.
//    req, resp := client.DescribeDBParametersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBParameters
func (c *RDS) DescribeDBParametersRequest(input *DescribeDBParametersInput) (req *request.Request, output *DescribeDBParametersOutput) {
	op := &request.Operation{
		Name:       opDescribeDBParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBParametersInput{}
	}

	output = &DescribeDBParametersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBParameters API operation for Amazon Relational Database Service.
//
// Returns the detailed parameter list for a particular DB parameter group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeDBParameters for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName does not refer to an existing DB parameter group.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBParameters
func (c *RDS) DescribeDBParameters(input *DescribeDBParametersInput) (*DescribeDBParametersOutput, error) {
	req, out := c.DescribeDBParametersRequest(input)
	return out, req.Send()
}

// DescribeDBParametersWithContext is the same as DescribeDBParameters with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBParameters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBParametersWithContext(ctx aws.Context, input *DescribeDBParametersInput, opts ...request.Option) (*DescribeDBParametersOutput, error) {
	req, out := c.DescribeDBParametersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDBParametersPages iterates over the pages of a DescribeDBParameters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDBParameters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDBParameters operation.
//    pageNum := 0
//    err := client.DescribeDBParametersPages(params,
//        func(page *DescribeDBParametersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeDBParametersPages(input *DescribeDBParametersInput, fn func(*DescribeDBParametersOutput, bool) bool) error {
	return c.DescribeDBParametersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDBParametersPagesWithContext same as DescribeDBParametersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBParametersPagesWithContext(ctx aws.Context, input *DescribeDBParametersInput, fn func(*DescribeDBParametersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDBParametersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDBParametersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeDBParametersOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeDBSecurityGroups = "DescribeDBSecurityGroups"

// DescribeDBSecurityGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBSecurityGroups operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBSecurityGroups for more information on using the DescribeDBSecurityGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBSecurityGroupsRequest method.
//    req, resp := client.DescribeDBSecurityGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSecurityGroups
func (c *RDS) DescribeDBSecurityGroupsRequest(input *DescribeDBSecurityGroupsInput) (req *request.Request, output *DescribeDBSecurityGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeDBSecurityGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBSecurityGroupsInput{}
	}

	output = &DescribeDBSecurityGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBSecurityGroups API operation for Amazon Relational Database Service.
//
// Returns a list of DBSecurityGroup descriptions. If a DBSecurityGroupName
// is specified, the list will contain only the descriptions of the specified
// DB security group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeDBSecurityGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBSecurityGroupNotFoundFault "DBSecurityGroupNotFound"
//   DBSecurityGroupName does not refer to an existing DB security group.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSecurityGroups
func (c *RDS) DescribeDBSecurityGroups(input *DescribeDBSecurityGroupsInput) (*DescribeDBSecurityGroupsOutput, error) {
	req, out := c.DescribeDBSecurityGroupsRequest(input)
	return out, req.Send()
}

// DescribeDBSecurityGroupsWithContext is the same as DescribeDBSecurityGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBSecurityGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBSecurityGroupsWithContext(ctx aws.Context, input *DescribeDBSecurityGroupsInput, opts ...request.Option) (*DescribeDBSecurityGroupsOutput, error) {
	req, out := c.DescribeDBSecurityGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDBSecurityGroupsPages iterates over the pages of a DescribeDBSecurityGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDBSecurityGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDBSecurityGroups operation.
//    pageNum := 0
//    err := client.DescribeDBSecurityGroupsPages(params,
//        func(page *DescribeDBSecurityGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeDBSecurityGroupsPages(input *DescribeDBSecurityGroupsInput, fn func(*DescribeDBSecurityGroupsOutput, bool) bool) error {
	return c.DescribeDBSecurityGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDBSecurityGroupsPagesWithContext same as DescribeDBSecurityGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBSecurityGroupsPagesWithContext(ctx aws.Context, input *DescribeDBSecurityGroupsInput, fn func(*DescribeDBSecurityGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDBSecurityGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDBSecurityGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeDBSecurityGroupsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeDBSnapshotAttributes = "DescribeDBSnapshotAttributes"

// DescribeDBSnapshotAttributesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBSnapshotAttributes operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBSnapshotAttributes for more information on using the DescribeDBSnapshotAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBSnapshotAttributesRequest method.
//    req, resp := client.DescribeDBSnapshotAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshotAttributes
func (c *RDS) DescribeDBSnapshotAttributesRequest(input *DescribeDBSnapshotAttributesInput) (req *request.Request, output *DescribeDBSnapshotAttributesOutput) {
	op := &request.Operation{
		Name:       opDescribeDBSnapshotAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDBSnapshotAttributesInput{}
	}

	output = &DescribeDBSnapshotAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBSnapshotAttributes API operation for Amazon Relational Database Service.
//
// Returns a list of DB snapshot attribute names and values for a manual DB
// snapshot.
//
// When sharing snapshots with other AWS accounts, DescribeDBSnapshotAttributes
// returns the restore attribute and a list of IDs for the AWS accounts that
// are authorized to copy or restore the manual DB snapshot. If all is included
// in the list of values for the restore attribute, then the manual DB snapshot
// is public and can be copied or restored by all AWS accounts.
//
// To add or remove access for an AWS account to copy or restore a manual DB
// snapshot, or to make the manual DB snapshot public or private, use the ModifyDBSnapshotAttribute
// API action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeDBSnapshotAttributes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBSnapshotNotFoundFault "DBSnapshotNotFound"
//   DBSnapshotIdentifier does not refer to an existing DB snapshot.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshotAttributes
func (c *RDS) DescribeDBSnapshotAttributes(input *DescribeDBSnapshotAttributesInput) (*DescribeDBSnapshotAttributesOutput, error) {
	req, out := c.DescribeDBSnapshotAttributesRequest(input)
	return out, req.Send()
}

// DescribeDBSnapshotAttributesWithContext is the same as DescribeDBSnapshotAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBSnapshotAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBSnapshotAttributesWithContext(ctx aws.Context, input *DescribeDBSnapshotAttributesInput, opts ...request.Option) (*DescribeDBSnapshotAttributesOutput, error) {
	req, out := c.DescribeDBSnapshotAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDBSnapshots = "DescribeDBSnapshots"

// DescribeDBSnapshotsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBSnapshots operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBSnapshots for more information on using the DescribeDBSnapshots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBSnapshotsRequest method.
//    req, resp := client.DescribeDBSnapshotsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshots
func (c *RDS) DescribeDBSnapshotsRequest(input *DescribeDBSnapshotsInput) (req *request.Request, output *DescribeDBSnapshotsOutput) {
	op := &request.Operation{
		Name:       opDescribeDBSnapshots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBSnapshotsInput{}
	}

	output = &DescribeDBSnapshotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBSnapshots API operation for Amazon Relational Database Service.
//
// Returns information about DB snapshots. This API action supports pagination.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeDBSnapshots for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBSnapshotNotFoundFault "DBSnapshotNotFound"
//   DBSnapshotIdentifier does not refer to an existing DB snapshot.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshots
func (c *RDS) DescribeDBSnapshots(input *DescribeDBSnapshotsInput) (*DescribeDBSnapshotsOutput, error) {
	req, out := c.DescribeDBSnapshotsRequest(input)
	return out, req.Send()
}

// DescribeDBSnapshotsWithContext is the same as DescribeDBSnapshots with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBSnapshots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBSnapshotsWithContext(ctx aws.Context, input *DescribeDBSnapshotsInput, opts ...request.Option) (*DescribeDBSnapshotsOutput, error) {
	req, out := c.DescribeDBSnapshotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDBSnapshotsPages iterates over the pages of a DescribeDBSnapshots operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDBSnapshots method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDBSnapshots operation.
//    pageNum := 0
//    err := client.DescribeDBSnapshotsPages(params,
//        func(page *DescribeDBSnapshotsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeDBSnapshotsPages(input *DescribeDBSnapshotsInput, fn func(*DescribeDBSnapshotsOutput, bool) bool) error {
	return c.DescribeDBSnapshotsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDBSnapshotsPagesWithContext same as DescribeDBSnapshotsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBSnapshotsPagesWithContext(ctx aws.Context, input *DescribeDBSnapshotsInput, fn func(*DescribeDBSnapshotsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDBSnapshotsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDBSnapshotsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeDBSnapshotsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeDBSubnetGroups = "DescribeDBSubnetGroups"

// DescribeDBSubnetGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDBSubnetGroups operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDBSubnetGroups for more information on using the DescribeDBSubnetGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDBSubnetGroupsRequest method.
//    req, resp := client.DescribeDBSubnetGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSubnetGroups
func (c *RDS) DescribeDBSubnetGroupsRequest(input *DescribeDBSubnetGroupsInput) (req *request.Request, output *DescribeDBSubnetGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeDBSubnetGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBSubnetGroupsInput{}
	}

	output = &DescribeDBSubnetGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDBSubnetGroups API operation for Amazon Relational Database Service.
//
// Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified,
// the list will contain only the descriptions of the specified DBSubnetGroup.
//
// For an overview of CIDR ranges, go to the Wikipedia Tutorial (http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeDBSubnetGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName does not refer to an existing DB subnet group.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSubnetGroups
func (c *RDS) DescribeDBSubnetGroups(input *DescribeDBSubnetGroupsInput) (*DescribeDBSubnetGroupsOutput, error) {
	req, out := c.DescribeDBSubnetGroupsRequest(input)
	return out, req.Send()
}

// DescribeDBSubnetGroupsWithContext is the same as DescribeDBSubnetGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDBSubnetGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBSubnetGroupsWithContext(ctx aws.Context, input *DescribeDBSubnetGroupsInput, opts ...request.Option) (*DescribeDBSubnetGroupsOutput, error) {
	req, out := c.DescribeDBSubnetGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDBSubnetGroupsPages iterates over the pages of a DescribeDBSubnetGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDBSubnetGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDBSubnetGroups operation.
//    pageNum := 0
//    err := client.DescribeDBSubnetGroupsPages(params,
//        func(page *DescribeDBSubnetGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeDBSubnetGroupsPages(input *DescribeDBSubnetGroupsInput, fn func(*DescribeDBSubnetGroupsOutput, bool) bool) error {
	return c.DescribeDBSubnetGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDBSubnetGroupsPagesWithContext same as DescribeDBSubnetGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeDBSubnetGroupsPagesWithContext(ctx aws.Context, input *DescribeDBSubnetGroupsInput, fn func(*DescribeDBSubnetGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDBSubnetGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDBSubnetGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeDBSubnetGroupsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeEngineDefaultClusterParameters = "DescribeEngineDefaultClusterParameters"

// DescribeEngineDefaultClusterParametersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEngineDefaultClusterParameters operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEngineDefaultClusterParameters for more information on using the DescribeEngineDefaultClusterParameters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEngineDefaultClusterParametersRequest method.
//    req, resp := client.DescribeEngineDefaultClusterParametersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEngineDefaultClusterParameters
func (c *RDS) DescribeEngineDefaultClusterParametersRequest(input *DescribeEngineDefaultClusterParametersInput) (req *request.Request, output *DescribeEngineDefaultClusterParametersOutput) {
	op := &request.Operation{
		Name:       opDescribeEngineDefaultClusterParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEngineDefaultClusterParametersInput{}
	}

	output = &DescribeEngineDefaultClusterParametersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEngineDefaultClusterParameters API operation for Amazon Relational Database Service.
//
// Returns the default engine and system parameter information for the cluster
// database engine.
//
// For more information on Amazon Aurora, see Aurora on Amazon RDS (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html)
// in the Amazon RDS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeEngineDefaultClusterParameters for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEngineDefaultClusterParameters
func (c *RDS) DescribeEngineDefaultClusterParameters(input *DescribeEngineDefaultClusterParametersInput) (*DescribeEngineDefaultClusterParametersOutput, error) {
	req, out := c.DescribeEngineDefaultClusterParametersRequest(input)
	return out, req.Send()
}

// DescribeEngineDefaultClusterParametersWithContext is the same as DescribeEngineDefaultClusterParameters with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEngineDefaultClusterParameters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeEngineDefaultClusterParametersWithContext(ctx aws.Context, input *DescribeEngineDefaultClusterParametersInput, opts ...request.Option) (*DescribeEngineDefaultClusterParametersOutput, error) {
	req, out := c.DescribeEngineDefaultClusterParametersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEngineDefaultParameters = "DescribeEngineDefaultParameters"

// DescribeEngineDefaultParametersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEngineDefaultParameters operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEngineDefaultParameters for more information on using the DescribeEngineDefaultParameters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEngineDefaultParametersRequest method.
//    req, resp := client.DescribeEngineDefaultParametersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEngineDefaultParameters
func (c *RDS) DescribeEngineDefaultParametersRequest(input *DescribeEngineDefaultParametersInput) (req *request.Request, output *DescribeEngineDefaultParametersOutput) {
	op := &request.Operation{
		Name:       opDescribeEngineDefaultParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"EngineDefaults.Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEngineDefaultParametersInput{}
	}

	output = &DescribeEngineDefaultParametersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEngineDefaultParameters API operation for Amazon Relational Database Service.
//
// Returns the default engine and system parameter information for the specified
// database engine.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeEngineDefaultParameters for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEngineDefaultParameters
func (c *RDS) DescribeEngineDefaultParameters(input *DescribeEngineDefaultParametersInput) (*DescribeEngineDefaultParametersOutput, error) {
	req, out := c.DescribeEngineDefaultParametersRequest(input)
	return out, req.Send()
}

// DescribeEngineDefaultParametersWithContext is the same as DescribeEngineDefaultParameters with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEngineDefaultParameters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeEngineDefaultParametersWithContext(ctx aws.Context, input *DescribeEngineDefaultParametersInput, opts ...request.Option) (*DescribeEngineDefaultParametersOutput, error) {
	req, out := c.DescribeEngineDefaultParametersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEngineDefaultParametersPages iterates over the pages of a DescribeEngineDefaultParameters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEngineDefaultParameters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeEngineDefaultParameters operation.
//    pageNum := 0
//    err := client.DescribeEngineDefaultParametersPages(params,
//        func(page *DescribeEngineDefaultParametersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeEngineDefaultParametersPages(input *DescribeEngineDefaultParametersInput, fn func(*DescribeEngineDefaultParametersOutput, bool) bool) error {
	return c.DescribeEngineDefaultParametersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEngineDefaultParametersPagesWithContext same as DescribeEngineDefaultParametersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeEngineDefaultParametersPagesWithContext(ctx aws.Context, input *DescribeEngineDefaultParametersInput, fn func(*DescribeEngineDefaultParametersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEngineDefaultParametersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEngineDefaultParametersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeEngineDefaultParametersOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeEventCategories = "DescribeEventCategories"

// DescribeEventCategoriesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEventCategories operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEventCategories for more information on using the DescribeEventCategories
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEventCategoriesRequest method.
//    req, resp := client.DescribeEventCategoriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEventCategories
func (c *RDS) DescribeEventCategoriesRequest(input *DescribeEventCategoriesInput) (req *request.Request, output *DescribeEventCategoriesOutput) {
	op := &request.Operation{
		Name:       opDescribeEventCategories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEventCategoriesInput{}
	}

	output = &DescribeEventCategoriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEventCategories API operation for Amazon Relational Database Service.
//
// Displays a list of categories for all event source types, or, if specified,
// for a specified source type. You can see a list of the event categories and
// source types in the  Events (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html)
// topic in the Amazon RDS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeEventCategories for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEventCategories
func (c *RDS) DescribeEventCategories(input *DescribeEventCategoriesInput) (*DescribeEventCategoriesOutput, error) {
	req, out := c.DescribeEventCategoriesRequest(input)
	return out, req.Send()
}

// DescribeEventCategoriesWithContext is the same as DescribeEventCategories with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEventCategories for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeEventCategoriesWithContext(ctx aws.Context, input *DescribeEventCategoriesInput, opts ...request.Option) (*DescribeEventCategoriesOutput, error) {
	req, out := c.DescribeEventCategoriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEventSubscriptions = "DescribeEventSubscriptions"

// DescribeEventSubscriptionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEventSubscriptions operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEventSubscriptions for more information on using the DescribeEventSubscriptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEventSubscriptionsRequest method.
//    req, resp := client.DescribeEventSubscriptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEventSubscriptions
func (c *RDS) DescribeEventSubscriptionsRequest(input *DescribeEventSubscriptionsInput) (req *request.Request, output *DescribeEventSubscriptionsOutput) {
	op := &request.Operation{
		Name:       opDescribeEventSubscriptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEventSubscriptionsInput{}
	}

	output = &DescribeEventSubscriptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEventSubscriptions API operation for Amazon Relational Database Service.
//
// Lists all the subscription descriptions for a customer account. The description
// for a subscription includes SubscriptionName, SNSTopicARN, CustomerID, SourceType,
// SourceID, CreationTime, and Status.
//
// If you specify a SubscriptionName, lists the description for that subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeEventSubscriptions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeSubscriptionNotFoundFault "SubscriptionNotFound"
//   The subscription name does not exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEventSubscriptions
func (c *RDS) DescribeEventSubscriptions(input *DescribeEventSubscriptionsInput) (*DescribeEventSubscriptionsOutput, error) {
	req, out := c.DescribeEventSubscriptionsRequest(input)
	return out, req.Send()
}

// DescribeEventSubscriptionsWithContext is the same as DescribeEventSubscriptions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEventSubscriptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeEventSubscriptionsWithContext(ctx aws.Context, input *DescribeEventSubscriptionsInput, opts ...request.Option) (*DescribeEventSubscriptionsOutput, error) {
	req, out := c.DescribeEventSubscriptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEventSubscriptionsPages iterates over the pages of a DescribeEventSubscriptions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEventSubscriptions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeEventSubscriptions operation.
//    pageNum := 0
//    err := client.DescribeEventSubscriptionsPages(params,
//        func(page *DescribeEventSubscriptionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeEventSubscriptionsPages(input *DescribeEventSubscriptionsInput, fn func(*DescribeEventSubscriptionsOutput, bool) bool) error {
	return c.DescribeEventSubscriptionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEventSubscriptionsPagesWithContext same as DescribeEventSubscriptionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeEventSubscriptionsPagesWithContext(ctx aws.Context, input *DescribeEventSubscriptionsInput, fn func(*DescribeEventSubscriptionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEventSubscriptionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEventSubscriptionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeEventSubscriptionsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeEvents = "DescribeEvents"

// DescribeEventsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEvents operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEvents for more information on using the DescribeEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEventsRequest method.
//    req, resp := client.DescribeEventsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEvents
func (c *RDS) DescribeEventsRequest(input *DescribeEventsInput) (req *request.Request, output *DescribeEventsOutput) {
	op := &request.Operation{
		Name:       opDescribeEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEventsInput{}
	}

	output = &DescribeEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEvents API operation for Amazon Relational Database Service.
//
// Returns events related to DB instances, DB security groups, DB snapshots,
// and DB parameter groups for the past 14 days. Events specific to a particular
// DB instance, DB security group, database snapshot, or DB parameter group
// can be obtained by providing the name as a parameter. By default, the past
// hour of events are returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeEvents for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEvents
func (c *RDS) DescribeEvents(input *DescribeEventsInput) (*DescribeEventsOutput, error) {
	req, out := c.DescribeEventsRequest(input)
	return out, req.Send()
}

// DescribeEventsWithContext is the same as DescribeEvents with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeEventsWithContext(ctx aws.Context, input *DescribeEventsInput, opts ...request.Option) (*DescribeEventsOutput, error) {
	req, out := c.DescribeEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEventsPages iterates over the pages of a DescribeEvents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEvents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeEvents operation.
//    pageNum := 0
//    err := client.DescribeEventsPages(params,
//        func(page *DescribeEventsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeEventsPages(input *DescribeEventsInput, fn func(*DescribeEventsOutput, bool) bool) error {
	return c.DescribeEventsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEventsPagesWithContext same as DescribeEventsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeEventsPagesWithContext(ctx aws.Context, input *DescribeEventsInput, fn func(*DescribeEventsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEventsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEventsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeEventsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeOptionGroupOptions = "DescribeOptionGroupOptions"

// DescribeOptionGroupOptionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOptionGroupOptions operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOptionGroupOptions for more information on using the DescribeOptionGroupOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeOptionGroupOptionsRequest method.
//    req, resp := client.DescribeOptionGroupOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOptionGroupOptions
func (c *RDS) DescribeOptionGroupOptionsRequest(input *DescribeOptionGroupOptionsInput) (req *request.Request, output *DescribeOptionGroupOptionsOutput) {
	op := &request.Operation{
		Name:       opDescribeOptionGroupOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeOptionGroupOptionsInput{}
	}

	output = &DescribeOptionGroupOptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOptionGroupOptions API operation for Amazon Relational Database Service.
//
// Describes all available options.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeOptionGroupOptions for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOptionGroupOptions
func (c *RDS) DescribeOptionGroupOptions(input *DescribeOptionGroupOptionsInput) (*DescribeOptionGroupOptionsOutput, error) {
	req, out := c.DescribeOptionGroupOptionsRequest(input)
	return out, req.Send()
}

// DescribeOptionGroupOptionsWithContext is the same as DescribeOptionGroupOptions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOptionGroupOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeOptionGroupOptionsWithContext(ctx aws.Context, input *DescribeOptionGroupOptionsInput, opts ...request.Option) (*DescribeOptionGroupOptionsOutput, error) {
	req, out := c.DescribeOptionGroupOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeOptionGroupOptionsPages iterates over the pages of a DescribeOptionGroupOptions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeOptionGroupOptions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeOptionGroupOptions operation.
//    pageNum := 0
//    err := client.DescribeOptionGroupOptionsPages(params,
//        func(page *DescribeOptionGroupOptionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeOptionGroupOptionsPages(input *DescribeOptionGroupOptionsInput, fn func(*DescribeOptionGroupOptionsOutput, bool) bool) error {
	return c.DescribeOptionGroupOptionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeOptionGroupOptionsPagesWithContext same as DescribeOptionGroupOptionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeOptionGroupOptionsPagesWithContext(ctx aws.Context, input *DescribeOptionGroupOptionsInput, fn func(*DescribeOptionGroupOptionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeOptionGroupOptionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeOptionGroupOptionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeOptionGroupOptionsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeOptionGroups = "DescribeOptionGroups"

// DescribeOptionGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOptionGroups operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOptionGroups for more information on using the DescribeOptionGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeOptionGroupsRequest method.
//    req, resp := client.DescribeOptionGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOptionGroups
func (c *RDS) DescribeOptionGroupsRequest(input *DescribeOptionGroupsInput) (req *request.Request, output *DescribeOptionGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeOptionGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeOptionGroupsInput{}
	}

	output = &DescribeOptionGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOptionGroups API operation for Amazon Relational Database Service.
//
// Describes the available option groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeOptionGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeOptionGroupNotFoundFault "OptionGroupNotFoundFault"
//   The specified option group could not be found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOptionGroups
func (c *RDS) DescribeOptionGroups(input *DescribeOptionGroupsInput) (*DescribeOptionGroupsOutput, error) {
	req, out := c.DescribeOptionGroupsRequest(input)
	return out, req.Send()
}

// DescribeOptionGroupsWithContext is the same as DescribeOptionGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOptionGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeOptionGroupsWithContext(ctx aws.Context, input *DescribeOptionGroupsInput, opts ...request.Option) (*DescribeOptionGroupsOutput, error) {
	req, out := c.DescribeOptionGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeOptionGroupsPages iterates over the pages of a DescribeOptionGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeOptionGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeOptionGroups operation.
//    pageNum := 0
//    err := client.DescribeOptionGroupsPages(params,
//        func(page *DescribeOptionGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeOptionGroupsPages(input *DescribeOptionGroupsInput, fn func(*DescribeOptionGroupsOutput, bool) bool) error {
	return c.DescribeOptionGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeOptionGroupsPagesWithContext same as DescribeOptionGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeOptionGroupsPagesWithContext(ctx aws.Context, input *DescribeOptionGroupsInput, fn func(*DescribeOptionGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeOptionGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeOptionGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeOptionGroupsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeOrderableDBInstanceOptions = "DescribeOrderableDBInstanceOptions"

// DescribeOrderableDBInstanceOptionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOrderableDBInstanceOptions operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOrderableDBInstanceOptions for more information on using the DescribeOrderableDBInstanceOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeOrderableDBInstanceOptionsRequest method.
//    req, resp := client.DescribeOrderableDBInstanceOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOrderableDBInstanceOptions
func (c *RDS) DescribeOrderableDBInstanceOptionsRequest(input *DescribeOrderableDBInstanceOptionsInput) (req *request.Request, output *DescribeOrderableDBInstanceOptionsOutput) {
	op := &request.Operation{
		Name:       opDescribeOrderableDBInstanceOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeOrderableDBInstanceOptionsInput{}
	}

	output = &DescribeOrderableDBInstanceOptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOrderableDBInstanceOptions API operation for Amazon Relational Database Service.
//
// Returns a list of orderable DB instance options for the specified engine.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeOrderableDBInstanceOptions for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOrderableDBInstanceOptions
func (c *RDS) DescribeOrderableDBInstanceOptions(input *DescribeOrderableDBInstanceOptionsInput) (*DescribeOrderableDBInstanceOptionsOutput, error) {
	req, out := c.DescribeOrderableDBInstanceOptionsRequest(input)
	return out, req.Send()
}

// DescribeOrderableDBInstanceOptionsWithContext is the same as DescribeOrderableDBInstanceOptions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOrderableDBInstanceOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeOrderableDBInstanceOptionsWithContext(ctx aws.Context, input *DescribeOrderableDBInstanceOptionsInput, opts ...request.Option) (*DescribeOrderableDBInstanceOptionsOutput, error) {
	req, out := c.DescribeOrderableDBInstanceOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeOrderableDBInstanceOptionsPages iterates over the pages of a DescribeOrderableDBInstanceOptions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeOrderableDBInstanceOptions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeOrderableDBInstanceOptions operation.
//    pageNum := 0
//    err := client.DescribeOrderableDBInstanceOptionsPages(params,
//        func(page *DescribeOrderableDBInstanceOptionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeOrderableDBInstanceOptionsPages(input *DescribeOrderableDBInstanceOptionsInput, fn func(*DescribeOrderableDBInstanceOptionsOutput, bool) bool) error {
	return c.DescribeOrderableDBInstanceOptionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeOrderableDBInstanceOptionsPagesWithContext same as DescribeOrderableDBInstanceOptionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeOrderableDBInstanceOptionsPagesWithContext(ctx aws.Context, input *DescribeOrderableDBInstanceOptionsInput, fn func(*DescribeOrderableDBInstanceOptionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeOrderableDBInstanceOptionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeOrderableDBInstanceOptionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeOrderableDBInstanceOptionsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribePendingMaintenanceActions = "DescribePendingMaintenanceActions"

// DescribePendingMaintenanceActionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribePendingMaintenanceActions operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePendingMaintenanceActions for more information on using the DescribePendingMaintenanceActions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePendingMaintenanceActionsRequest method.
//    req, resp := client.DescribePendingMaintenanceActionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribePendingMaintenanceActions
func (c *RDS) DescribePendingMaintenanceActionsRequest(input *DescribePendingMaintenanceActionsInput) (req *request.Request, output *DescribePendingMaintenanceActionsOutput) {
	op := &request.Operation{
		Name:       opDescribePendingMaintenanceActions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePendingMaintenanceActionsInput{}
	}

	output = &DescribePendingMaintenanceActionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePendingMaintenanceActions API operation for Amazon Relational Database Service.
//
// Returns a list of resources (for example, DB instances) that have at least
// one pending maintenance action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribePendingMaintenanceActions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundFault "ResourceNotFoundFault"
//   The specified resource ID was not found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribePendingMaintenanceActions
func (c *RDS) DescribePendingMaintenanceActions(input *DescribePendingMaintenanceActionsInput) (*DescribePendingMaintenanceActionsOutput, error) {
	req, out := c.DescribePendingMaintenanceActionsRequest(input)
	return out, req.Send()
}

// DescribePendingMaintenanceActionsWithContext is the same as DescribePendingMaintenanceActions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePendingMaintenanceActions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribePendingMaintenanceActionsWithContext(ctx aws.Context, input *DescribePendingMaintenanceActionsInput, opts ...request.Option) (*DescribePendingMaintenanceActionsOutput, error) {
	req, out := c.DescribePendingMaintenanceActionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeReservedDBInstances = "DescribeReservedDBInstances"

// DescribeReservedDBInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReservedDBInstances operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReservedDBInstances for more information on using the DescribeReservedDBInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeReservedDBInstancesRequest method.
//    req, resp := client.DescribeReservedDBInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstances
func (c *RDS) DescribeReservedDBInstancesRequest(input *DescribeReservedDBInstancesInput) (req *request.Request, output *DescribeReservedDBInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeReservedDBInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReservedDBInstancesInput{}
	}

	output = &DescribeReservedDBInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReservedDBInstances API operation for Amazon Relational Database Service.
//
// Returns information about reserved DB instances for this account, or about
// a specified reserved DB instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeReservedDBInstances for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeReservedDBInstanceNotFoundFault "ReservedDBInstanceNotFound"
//   The specified reserved DB Instance not found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstances
func (c *RDS) DescribeReservedDBInstances(input *DescribeReservedDBInstancesInput) (*DescribeReservedDBInstancesOutput, error) {
	req, out := c.DescribeReservedDBInstancesRequest(input)
	return out, req.Send()
}

// DescribeReservedDBInstancesWithContext is the same as DescribeReservedDBInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReservedDBInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeReservedDBInstancesWithContext(ctx aws.Context, input *DescribeReservedDBInstancesInput, opts ...request.Option) (*DescribeReservedDBInstancesOutput, error) {
	req, out := c.DescribeReservedDBInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReservedDBInstancesPages iterates over the pages of a DescribeReservedDBInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReservedDBInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeReservedDBInstances operation.
//    pageNum := 0
//    err := client.DescribeReservedDBInstancesPages(params,
//        func(page *DescribeReservedDBInstancesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeReservedDBInstancesPages(input *DescribeReservedDBInstancesInput, fn func(*DescribeReservedDBInstancesOutput, bool) bool) error {
	return c.DescribeReservedDBInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReservedDBInstancesPagesWithContext same as DescribeReservedDBInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeReservedDBInstancesPagesWithContext(ctx aws.Context, input *DescribeReservedDBInstancesInput, fn func(*DescribeReservedDBInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReservedDBInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReservedDBInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeReservedDBInstancesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeReservedDBInstancesOfferings = "DescribeReservedDBInstancesOfferings"

// DescribeReservedDBInstancesOfferingsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReservedDBInstancesOfferings operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReservedDBInstancesOfferings for more information on using the DescribeReservedDBInstancesOfferings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeReservedDBInstancesOfferingsRequest method.
//    req, resp := client.DescribeReservedDBInstancesOfferingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstancesOfferings
func (c *RDS) DescribeReservedDBInstancesOfferingsRequest(input *DescribeReservedDBInstancesOfferingsInput) (req *request.Request, output *DescribeReservedDBInstancesOfferingsOutput) {
	op := &request.Operation{
		Name:       opDescribeReservedDBInstancesOfferings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReservedDBInstancesOfferingsInput{}
	}

	output = &DescribeReservedDBInstancesOfferingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReservedDBInstancesOfferings API operation for Amazon Relational Database Service.
//
// Lists available reserved DB instance offerings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeReservedDBInstancesOfferings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeReservedDBInstancesOfferingNotFoundFault "ReservedDBInstancesOfferingNotFound"
//   Specified offering does not exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstancesOfferings
func (c *RDS) DescribeReservedDBInstancesOfferings(input *DescribeReservedDBInstancesOfferingsInput) (*DescribeReservedDBInstancesOfferingsOutput, error) {
	req, out := c.DescribeReservedDBInstancesOfferingsRequest(input)
	return out, req.Send()
}

// DescribeReservedDBInstancesOfferingsWithContext is the same as DescribeReservedDBInstancesOfferings with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReservedDBInstancesOfferings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeReservedDBInstancesOfferingsWithContext(ctx aws.Context, input *DescribeReservedDBInstancesOfferingsInput, opts ...request.Option) (*DescribeReservedDBInstancesOfferingsOutput, error) {
	req, out := c.DescribeReservedDBInstancesOfferingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReservedDBInstancesOfferingsPages iterates over the pages of a DescribeReservedDBInstancesOfferings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReservedDBInstancesOfferings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeReservedDBInstancesOfferings operation.
//    pageNum := 0
//    err := client.DescribeReservedDBInstancesOfferingsPages(params,
//        func(page *DescribeReservedDBInstancesOfferingsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DescribeReservedDBInstancesOfferingsPages(input *DescribeReservedDBInstancesOfferingsInput, fn func(*DescribeReservedDBInstancesOfferingsOutput, bool) bool) error {
	return c.DescribeReservedDBInstancesOfferingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReservedDBInstancesOfferingsPagesWithContext same as DescribeReservedDBInstancesOfferingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeReservedDBInstancesOfferingsPagesWithContext(ctx aws.Context, input *DescribeReservedDBInstancesOfferingsInput, fn func(*DescribeReservedDBInstancesOfferingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReservedDBInstancesOfferingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReservedDBInstancesOfferingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeReservedDBInstancesOfferingsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeSourceRegions = "DescribeSourceRegions"

// DescribeSourceRegionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSourceRegions operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSourceRegions for more information on using the DescribeSourceRegions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSourceRegionsRequest method.
//    req, resp := client.DescribeSourceRegionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeSourceRegions
func (c *RDS) DescribeSourceRegionsRequest(input *DescribeSourceRegionsInput) (req *request.Request, output *DescribeSourceRegionsOutput) {
	op := &request.Operation{
		Name:       opDescribeSourceRegions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSourceRegionsInput{}
	}

	output = &DescribeSourceRegionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSourceRegions API operation for Amazon Relational Database Service.
//
// Returns a list of the source AWS regions where the current AWS Region can
// create a Read Replica or copy a DB snapshot from. This API action supports
// pagination.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DescribeSourceRegions for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeSourceRegions
func (c *RDS) DescribeSourceRegions(input *DescribeSourceRegionsInput) (*DescribeSourceRegionsOutput, error) {
	req, out := c.DescribeSourceRegionsRequest(input)
	return out, req.Send()
}

// DescribeSourceRegionsWithContext is the same as DescribeSourceRegions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSourceRegions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DescribeSourceRegionsWithContext(ctx aws.Context, input *DescribeSourceRegionsInput, opts ...request.Option) (*DescribeSourceRegionsOutput, error) {
	req, out := c.DescribeSourceRegionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDownloadDBLogFilePortion = "DownloadDBLogFilePortion"

// DownloadDBLogFilePortionRequest generates a "aws/request.Request" representing the
// client's request for the DownloadDBLogFilePortion operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DownloadDBLogFilePortion for more information on using the DownloadDBLogFilePortion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DownloadDBLogFilePortionRequest method.
//    req, resp := client.DownloadDBLogFilePortionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DownloadDBLogFilePortion
func (c *RDS) DownloadDBLogFilePortionRequest(input *DownloadDBLogFilePortionInput) (req *request.Request, output *DownloadDBLogFilePortionOutput) {
	op := &request.Operation{
		Name:       opDownloadDBLogFilePortion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "NumberOfLines",
			TruncationToken: "AdditionalDataPending",
		},
	}

	if input == nil {
		input = &DownloadDBLogFilePortionInput{}
	}

	output = &DownloadDBLogFilePortionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DownloadDBLogFilePortion API operation for Amazon Relational Database Service.
//
// Downloads all or a portion of the specified log file, up to 1 MB in size.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation DownloadDBLogFilePortion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier does not refer to an existing DB instance.
//
//   * ErrCodeDBLogFileNotFoundFault "DBLogFileNotFoundFault"
//   LogFileName does not refer to an existing DB log file.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DownloadDBLogFilePortion
func (c *RDS) DownloadDBLogFilePortion(input *DownloadDBLogFilePortionInput) (*DownloadDBLogFilePortionOutput, error) {
	req, out := c.DownloadDBLogFilePortionRequest(input)
	return out, req.Send()
}

// DownloadDBLogFilePortionWithContext is the same as DownloadDBLogFilePortion with the addition of
// the ability to pass a context and additional request options.
//
// See DownloadDBLogFilePortion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DownloadDBLogFilePortionWithContext(ctx aws.Context, input *DownloadDBLogFilePortionInput, opts ...request.Option) (*DownloadDBLogFilePortionOutput, error) {
	req, out := c.DownloadDBLogFilePortionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DownloadDBLogFilePortionPages iterates over the pages of a DownloadDBLogFilePortion operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DownloadDBLogFilePortion method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DownloadDBLogFilePortion operation.
//    pageNum := 0
//    err := client.DownloadDBLogFilePortionPages(params,
//        func(page *DownloadDBLogFilePortionOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RDS) DownloadDBLogFilePortionPages(input *DownloadDBLogFilePortionInput, fn func(*DownloadDBLogFilePortionOutput, bool) bool) error {
	return c.DownloadDBLogFilePortionPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DownloadDBLogFilePortionPagesWithContext same as DownloadDBLogFilePortionPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) DownloadDBLogFilePortionPagesWithContext(ctx aws.Context, input *DownloadDBLogFilePortionInput, fn func(*DownloadDBLogFilePortionOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DownloadDBLogFilePortionInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DownloadDBLogFilePortionRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DownloadDBLogFilePortionOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opFailoverDBCluster = "FailoverDBCluster"

// FailoverDBClusterRequest generates a "aws/request.Request" representing the
// client's request for the FailoverDBCluster operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See FailoverDBCluster for more information on using the FailoverDBCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the FailoverDBClusterRequest method.
//    req, resp := client.FailoverDBClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/FailoverDBCluster
func (c *RDS) FailoverDBClusterRequest(input *FailoverDBClusterInput) (req *request.Request, output *FailoverDBClusterOutput) {
	op := &request.Operation{
		Name:       opFailoverDBCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &FailoverDBClusterInput{}
	}

	output = &FailoverDBClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// FailoverDBCluster API operation for Amazon Relational Database Service.
//
// Forces a failover for a DB cluster.
//
// A failover for a DB cluster promotes one of the Aurora Replicas (read-only
// instances) in the DB cluster to be the primary instance (the cluster writer).
//
// Amazon Aurora will automatically fail over to an Aurora Replica, if one exists,
// when the primary instance fails. You can force a failover when you want to
// simulate a failure of a primary instance for testing. Because each instance
// in a DB cluster has its own endpoint address, you will need to clean up and
// re-establish any existing connections that use those endpoint addresses when
// the failover is complete.
//
// For more information on Amazon Aurora, see Aurora on Amazon RDS (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html)
// in the Amazon RDS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation FailoverDBCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier does not refer to an existing DB cluster.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The DB cluster is not in a valid state.
//
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The specified DB instance is not in the available state.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/FailoverDBCluster
func (c *RDS) FailoverDBCluster(input *FailoverDBClusterInput) (*FailoverDBClusterOutput, error) {
	req, out := c.FailoverDBClusterRequest(input)
	return out, req.Send()
}

// FailoverDBClusterWithContext is the same as FailoverDBCluster with the addition of
// the ability to pass a context and additional request options.
//
// See FailoverDBCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) FailoverDBClusterWithContext(ctx aws.Context, input *FailoverDBClusterInput, opts ...request.Option) (*FailoverDBClusterOutput, error) {
	req, out := c.FailoverDBClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ListTagsForResource
func (c *RDS) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Relational Database Service.
//
// Lists all tags on an Amazon RDS resource.
//
// For an overview on tagging an Amazon RDS resource, see Tagging Amazon RDS
// Resources (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Tagging.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier does not refer to an existing DB instance.
//
//   * ErrCodeDBSnapshotNotFoundFault "DBSnapshotNotFound"
//   DBSnapshotIdentifier does not refer to an existing DB snapshot.
//
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier does not refer to an existing DB cluster.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ListTagsForResource
func (c *RDS) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyDBCluster = "ModifyDBCluster"

// ModifyDBClusterRequest generates a "aws/request.Request" representing the
// client's request for the ModifyDBCluster operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyDBCluster for more information on using the ModifyDBCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyDBClusterRequest method.
//    req, resp := client.ModifyDBClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBCluster
func (c *RDS) ModifyDBClusterRequest(input *ModifyDBClusterInput) (req *request.Request, output *ModifyDBClusterOutput) {
	op := &request.Operation{
		Name:       opModifyDBCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDBClusterInput{}
	}

	output = &ModifyDBClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyDBCluster API operation for Amazon Relational Database Service.
//
// Modify a setting for an Amazon Aurora DB cluster. You can change one or more
// database configuration parameters by specifying these parameters and the
// new values in the request. For more information on Amazon Aurora, see Aurora
// on Amazon RDS (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html)
// in the Amazon RDS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation ModifyDBCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier does not refer to an existing DB cluster.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The DB cluster is not in a valid state.
//
//   * ErrCodeStorageQuotaExceededFault "StorageQuotaExceeded"
//   Request would result in user exceeding the allowed amount of storage available
//   across all DB instances.
//
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName does not refer to an existing DB subnet group.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   DB subnet group does not cover all Availability Zones after it is created
//   because users' change.
//
//   * ErrCodeInvalidDBSubnetGroupStateFault "InvalidDBSubnetGroupStateFault"
//   The DB subnet group cannot be deleted because it is in use.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is invalid, or multiple subnets were requested that
//   are not all in a common VPC.
//
//   * ErrCodeDBClusterParameterGroupNotFoundFault "DBClusterParameterGroupNotFound"
//   DBClusterParameterGroupName does not refer to an existing DB Cluster parameter
//   group.
//
//   * ErrCodeInvalidDBSecurityGroupStateFault "InvalidDBSecurityGroupState"
//   The state of the DB security group does not allow deletion.
//
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The specified DB instance is not in the available state.
//
//   * ErrCodeDBClusterAlreadyExistsFault "DBClusterAlreadyExistsFault"
//   User already has a DB cluster with the given identifier.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBCluster
func (c *RDS) ModifyDBCluster(input *ModifyDBClusterInput) (*ModifyDBClusterOutput, error) {
	req, out := c.ModifyDBClusterRequest(input)
	return out, req.Send()
}

// ModifyDBClusterWithContext is the same as ModifyDBCluster with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyDBCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) ModifyDBClusterWithContext(ctx aws.Context, input *ModifyDBClusterInput, opts ...request.Option) (*ModifyDBClusterOutput, error) {
	req, out := c.ModifyDBClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyDBClusterParameterGroup = "ModifyDBClusterParameterGroup"

// ModifyDBClusterParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the ModifyDBClusterParameterGroup operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyDBClusterParameterGroup for more information on using the ModifyDBClusterParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyDBClusterParameterGroupRequest method.
//    req, resp := client.ModifyDBClusterParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBClusterParameterGroup
func (c *RDS) ModifyDBClusterParameterGroupRequest(input *ModifyDBClusterParameterGroupInput) (req *request.Request, output *DBClusterParameterGroupNameMessage) {
	op := &request.Operation{
		Name:       opModifyDBClusterParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDBClusterParameterGroupInput{}
	}

	output = &DBClusterParameterGroupNameMessage{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyDBClusterParameterGroup API operation for Amazon Relational Database Service.
//
// Modifies the parameters of a DB cluster parameter group. To modify more than
// one parameter, submit a list of the following: ParameterName, ParameterValue,
// and ApplyMethod. A maximum of 20 parameters can be modified in a single request.
//
// For more information on Amazon Aurora, see Aurora on Amazon RDS (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html)
// in the Amazon RDS User Guide.
//
// Changes to dynamic parameters are applied immediately. Changes to static
// parameters require a reboot without failover to the DB cluster associated
// with the parameter group before the change can take effect.
//
// After you create a DB cluster parameter group, you should wait at least 5
// minutes before creating your first DB cluster that uses that DB cluster parameter
// group as the default parameter group. This allows Amazon RDS to fully complete
// the create action before the parameter group is used as the default for a
// new DB cluster. This is especially important for parameters that are critical
// when creating the default database for a DB cluster, such as the character
// set for the default database defined by the character_set_database parameter.
// You can use the Parameter Groups option of the Amazon RDS console (https://console.aws.amazon.com/rds/)
// or the DescribeDBClusterParameters command to verify that your DB cluster
// parameter group has been created or modified.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation ModifyDBClusterParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName does not refer to an existing DB parameter group.
//
//   * ErrCodeInvalidDBParameterGroupStateFault "InvalidDBParameterGroupState"
//   The DB parameter group is in use or is in an invalid state. If you are attempting
//   to delete the parameter group, you cannot delete it when the parameter group
//   is in this state.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBClusterParameterGroup
func (c *RDS) ModifyDBClusterParameterGroup(input *ModifyDBClusterParameterGroupInput) (*DBClusterParameterGroupNameMessage, error) {
	req, out := c.ModifyDBClusterParameterGroupRequest(input)
	return out, req.Send()
}

// ModifyDBClusterParameterGroupWithContext is the same as ModifyDBClusterParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyDBClusterParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) ModifyDBClusterParameterGroupWithContext(ctx aws.Context, input *ModifyDBClusterParameterGroupInput, opts ...request.Option) (*DBClusterParameterGroupNameMessage, error) {
	req, out := c.ModifyDBClusterParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyDBClusterSnapshotAttribute = "ModifyDBClusterSnapshotAttribute"

// ModifyDBClusterSnapshotAttributeRequest generates a "aws/request.Request" representing the
// client's request for the ModifyDBClusterSnapshotAttribute operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyDBClusterSnapshotAttribute for more information on using the ModifyDBClusterSnapshotAttribute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyDBClusterSnapshotAttributeRequest method.
//    req, resp := client.ModifyDBClusterSnapshotAttributeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBClusterSnapshotAttribute
func (c *RDS) ModifyDBClusterSnapshotAttributeRequest(input *ModifyDBClusterSnapshotAttributeInput) (req *request.Request, output *ModifyDBClusterSnapshotAttributeOutput) {
	op := &request.Operation{
		Name:       opModifyDBClusterSnapshotAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDBClusterSnapshotAttributeInput{}
	}

	output = &ModifyDBClusterSnapshotAttributeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyDBClusterSnapshotAttribute API operation for Amazon Relational Database Service.
//
// Adds an attribute and values to, or removes an attribute and values from,
// a manual DB cluster snapshot.
//
// To share a manual DB cluster snapshot with other AWS accounts, specify restore
// as the AttributeName and use the ValuesToAdd parameter to add a list of IDs
// of the AWS accounts that are authorized to restore the manual DB cluster
// snapshot. Use the value all to make the manual DB cluster snapshot public,
// which means that it can be copied or restored by all AWS accounts. Do not
// add the all value for any manual DB cluster snapshots that contain private
// information that you don't want available to all AWS accounts. If a manual
// DB cluster snapshot is encrypted, it can be shared, but only by specifying
// a list of authorized AWS account IDs for the ValuesToAdd parameter. You can't
// use all as a value for that parameter in this case.
//
// To view which AWS accounts have access to copy or restore a manual DB cluster
// snapshot, or whether a manual DB cluster snapshot public or private, use
// the DescribeDBClusterSnapshotAttributes API action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation ModifyDBClusterSnapshotAttribute for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterSnapshotNotFoundFault "DBClusterSnapshotNotFoundFault"
//   DBClusterSnapshotIdentifier does not refer to an existing DB cluster snapshot.
//
//   * ErrCodeInvalidDBClusterSnapshotStateFault "InvalidDBClusterSnapshotStateFault"
//   The supplied value is not a valid DB cluster snapshot state.
//
//   * ErrCodeSharedSnapshotQuotaExceededFault "SharedSnapshotQuotaExceeded"
//   You have exceeded the maximum number of accounts that you can share a manual
//   DB snapshot with.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBClusterSnapshotAttribute
func (c *RDS) ModifyDBClusterSnapshotAttribute(input *ModifyDBClusterSnapshotAttributeInput) (*ModifyDBClusterSnapshotAttributeOutput, error) {
	req, out := c.ModifyDBClusterSnapshotAttributeRequest(input)
	return out, req.Send()
}

// ModifyDBClusterSnapshotAttributeWithContext is the same as ModifyDBClusterSnapshotAttribute with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyDBClusterSnapshotAttribute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) ModifyDBClusterSnapshotAttributeWithContext(ctx aws.Context, input *ModifyDBClusterSnapshotAttributeInput, opts ...request.Option) (*ModifyDBClusterSnapshotAttributeOutput, error) {
	req, out := c.ModifyDBClusterSnapshotAttributeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyDBInstance = "ModifyDBInstance"

// ModifyDBInstanceRequest generates a "aws/request.Request" representing the
// client's request for the ModifyDBInstance operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyDBInstance for more information on using the ModifyDBInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyDBInstanceRequest method.
//    req, resp := client.ModifyDBInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBInstance
func (c *RDS) ModifyDBInstanceRequest(input *ModifyDBInstanceInput) (req *request.Request, output *ModifyDBInstanceOutput) {
	op := &request.Operation{
		Name:       opModifyDBInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDBInstanceInput{}
	}

	output = &ModifyDBInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyDBInstance API operation for Amazon Relational Database Service.
//
// Modifies settings for a DB instance. You can change one or more database
// configuration parameters by specifying these parameters and the new values
// in the request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation ModifyDBInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The specified DB instance is not in the available state.
//
//   * ErrCodeInvalidDBSecurityGroupStateFault "InvalidDBSecurityGroupState"
//   The state of the DB security group does not allow deletion.
//
//   * ErrCodeDBInstanceAlreadyExistsFault "DBInstanceAlreadyExists"
//   User already has a DB instance with the given identifier.
//
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier does not refer to an existing DB instance.
//
//   * ErrCodeDBSecurityGroupNotFoundFault "DBSecurityGroupNotFound"
//   DBSecurityGroupName does not refer to an existing DB security group.
//
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName does not refer to an existing DB parameter group.
//
//   * ErrCodeInsufficientDBInstanceCapacityFault "InsufficientDBInstanceCapacity"
//   Specified DB instance class is not available in the specified Availability
//   Zone.
//
//   * ErrCodeStorageQuotaExceededFault "StorageQuotaExceeded"
//   Request would result in user exceeding the allowed amount of storage available
//   across all DB instances.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   DB subnet group does not cover all Availability Zones after it is created
//   because users' change.
//
//   * ErrCodeProvisionedIopsNotAvailableInAZFault "ProvisionedIopsNotAvailableInAZFault"
//   Provisioned IOPS not available in the specified Availability Zone.
//
//   * ErrCodeOptionGroupNotFoundFault "OptionGroupNotFoundFault"
//   The specified option group could not be found.
//
//   * ErrCodeDBUpgradeDependencyFailureFault "DBUpgradeDependencyFailure"
//   The DB upgrade failed because a resource the DB depends on could not be modified.
//
//   * ErrCodeStorageTypeNotSupportedFault "StorageTypeNotSupported"
//   StorageType specified cannot be associated with the DB Instance.
//
//   * ErrCodeAuthorizationNotFoundFault "AuthorizationNotFound"
//   Specified CIDRIP or EC2 security group is not authorized for the specified
//   DB security group.
//
//   RDS may not also be authorized via IAM to perform necessary actions on your
//   behalf.
//
//   * ErrCodeCertificateNotFoundFault "CertificateNotFound"
//   CertificateIdentifier does not refer to an existing certificate.
//
//   * ErrCodeDomainNotFoundFault "DomainNotFoundFault"
//   Domain does not refer to an existing Active Directory Domain.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBInstance
func (c *RDS) ModifyDBInstance(input *ModifyDBInstanceInput) (*ModifyDBInstanceOutput, error) {
	req, out := c.ModifyDBInstanceRequest(input)
	return out, req.Send()
}

// ModifyDBInstanceWithContext is the same as ModifyDBInstance with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyDBInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) ModifyDBInstanceWithContext(ctx aws.Context, input *ModifyDBInstanceInput, opts ...request.Option) (*ModifyDBInstanceOutput, error) {
	req, out := c.ModifyDBInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyDBParameterGroup = "ModifyDBParameterGroup"

// ModifyDBParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the ModifyDBParameterGroup operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyDBParameterGroup for more information on using the ModifyDBParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyDBParameterGroupRequest method.
//    req, resp := client.ModifyDBParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBParameterGroup
func (c *RDS) ModifyDBParameterGroupRequest(input *ModifyDBParameterGroupInput) (req *request.Request, output *DBParameterGroupNameMessage) {
	op := &request.Operation{
		Name:       opModifyDBParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDBParameterGroupInput{}
	}

	output = &DBParameterGroupNameMessage{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyDBParameterGroup API operation for Amazon Relational Database Service.
//
// Modifies the parameters of a DB parameter group. To modify more than one
// parameter, submit a list of the following: ParameterName, ParameterValue,
// and ApplyMethod. A maximum of 20 parameters can be modified in a single request.
//
// Changes to dynamic parameters are applied immediately. Changes to static
// parameters require a reboot without failover to the DB instance associated
// with the parameter group before the change can take effect.
//
// After you modify a DB parameter group, you should wait at least 5 minutes
// before creating your first DB instance that uses that DB parameter group
// as the default parameter group. This allows Amazon RDS to fully complete
// the modify action before the parameter group is used as the default for a
// new DB instance. This is especially important for parameters that are critical
// when creating the default database for a DB instance, such as the character
// set for the default database defined by the character_set_database parameter.
// You can use the Parameter Groups option of the Amazon RDS console (https://console.aws.amazon.com/rds/)
// or the DescribeDBParameters command to verify that your DB parameter group
// has been created or modified.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation ModifyDBParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName does not refer to an existing DB parameter group.
//
//   * ErrCodeInvalidDBParameterGroupStateFault "InvalidDBParameterGroupState"
//   The DB parameter group is in use or is in an invalid state. If you are attempting
//   to delete the parameter group, you cannot delete it when the parameter group
//   is in this state.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBParameterGroup
func (c *RDS) ModifyDBParameterGroup(input *ModifyDBParameterGroupInput) (*DBParameterGroupNameMessage, error) {
	req, out := c.ModifyDBParameterGroupRequest(input)
	return out, req.Send()
}

// ModifyDBParameterGroupWithContext is the same as ModifyDBParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyDBParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) ModifyDBParameterGroupWithContext(ctx aws.Context, input *ModifyDBParameterGroupInput, opts ...request.Option) (*DBParameterGroupNameMessage, error) {
	req, out := c.ModifyDBParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyDBSnapshot = "ModifyDBSnapshot"

// ModifyDBSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the ModifyDBSnapshot operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyDBSnapshot for more information on using the ModifyDBSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyDBSnapshotRequest method.
//    req, resp := client.ModifyDBSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBSnapshot
func (c *RDS) ModifyDBSnapshotRequest(input *ModifyDBSnapshotInput) (req *request.Request, output *ModifyDBSnapshotOutput) {
	op := &request.Operation{
		Name:       opModifyDBSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDBSnapshotInput{}
	}

	output = &ModifyDBSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyDBSnapshot API operation for Amazon Relational Database Service.
//
// Updates a manual DB snapshot, which can be encrypted or not encrypted, with
// a new engine version. You can update the engine version to either a new major
// or minor engine version.
//
// Amazon RDS supports upgrading a MySQL DB snapshot from MySQL 5.1 to MySQL
// 5.5.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation ModifyDBSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBSnapshotNotFoundFault "DBSnapshotNotFound"
//   DBSnapshotIdentifier does not refer to an existing DB snapshot.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBSnapshot
func (c *RDS) ModifyDBSnapshot(input *ModifyDBSnapshotInput) (*ModifyDBSnapshotOutput, error) {
	req, out := c.ModifyDBSnapshotRequest(input)
	return out, req.Send()
}

// ModifyDBSnapshotWithContext is the same as ModifyDBSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyDBSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) ModifyDBSnapshotWithContext(ctx aws.Context, input *ModifyDBSnapshotInput, opts ...request.Option) (*ModifyDBSnapshotOutput, error) {
	req, out := c.ModifyDBSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyDBSnapshotAttribute = "ModifyDBSnapshotAttribute"

// ModifyDBSnapshotAttributeRequest generates a "aws/request.Request" representing the
// client's request for the ModifyDBSnapshotAttribute operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyDBSnapshotAttribute for more information on using the ModifyDBSnapshotAttribute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyDBSnapshotAttributeRequest method.
//    req, resp := client.ModifyDBSnapshotAttributeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBSnapshotAttribute
func (c *RDS) ModifyDBSnapshotAttributeRequest(input *ModifyDBSnapshotAttributeInput) (req *request.Request, output *ModifyDBSnapshotAttributeOutput) {
	op := &request.Operation{
		Name:       opModifyDBSnapshotAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDBSnapshotAttributeInput{}
	}

	output = &ModifyDBSnapshotAttributeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyDBSnapshotAttribute API operation for Amazon Relational Database Service.
//
// Adds an attribute and values to, or removes an attribute and values from,
// a manual DB snapshot.
//
// To share a manual DB snapshot with other AWS accounts, specify restore as
// the AttributeName and use the ValuesToAdd parameter to add a list of IDs
// of the AWS accounts that are authorized to restore the manual DB snapshot.
// Uses the value all to make the manual DB snapshot public, which means it
// can be copied or restored by all AWS accounts. Do not add the all value for
// any manual DB snapshots that contain private information that you don't want
// available to all AWS accounts. If the manual DB snapshot is encrypted, it
// can be shared, but only by specifying a list of authorized AWS account IDs
// for the ValuesToAdd parameter. You can't use all as a value for that parameter
// in this case.
//
// To view which AWS accounts have access to copy or restore a manual DB snapshot,
// or whether a manual DB snapshot public or private, use the DescribeDBSnapshotAttributes
// API action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation ModifyDBSnapshotAttribute for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBSnapshotNotFoundFault "DBSnapshotNotFound"
//   DBSnapshotIdentifier does not refer to an existing DB snapshot.
//
//   * ErrCodeInvalidDBSnapshotStateFault "InvalidDBSnapshotState"
//   The state of the DB snapshot does not allow deletion.
//
//   * ErrCodeSharedSnapshotQuotaExceededFault "SharedSnapshotQuotaExceeded"
//   You have exceeded the maximum number of accounts that you can share a manual
//   DB snapshot with.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBSnapshotAttribute
func (c *RDS) ModifyDBSnapshotAttribute(input *ModifyDBSnapshotAttributeInput) (*ModifyDBSnapshotAttributeOutput, error) {
	req, out := c.ModifyDBSnapshotAttributeRequest(input)
	return out, req.Send()
}

// ModifyDBSnapshotAttributeWithContext is the same as ModifyDBSnapshotAttribute with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyDBSnapshotAttribute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) ModifyDBSnapshotAttributeWithContext(ctx aws.Context, input *ModifyDBSnapshotAttributeInput, opts ...request.Option) (*ModifyDBSnapshotAttributeOutput, error) {
	req, out := c.ModifyDBSnapshotAttributeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyDBSubnetGroup = "ModifyDBSubnetGroup"

// ModifyDBSubnetGroupRequest generates a "aws/request.Request" representing the
// client's request for the ModifyDBSubnetGroup operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyDBSubnetGroup for more information on using the ModifyDBSubnetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyDBSubnetGroupRequest method.
//    req, resp := client.ModifyDBSubnetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBSubnetGroup
func (c *RDS) ModifyDBSubnetGroupRequest(input *ModifyDBSubnetGroupInput) (req *request.Request, output *ModifyDBSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opModifyDBSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDBSubnetGroupInput{}
	}

	output = &ModifyDBSubnetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyDBSubnetGroup API operation for Amazon Relational Database Service.
//
// Modifies an existing DB subnet group. DB subnet groups must contain at least
// one subnet in at least two AZs in the AWS Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation ModifyDBSubnetGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName does not refer to an existing DB subnet group.
//
//   * ErrCodeDBSubnetQuotaExceededFault "DBSubnetQuotaExceededFault"
//   Request would result in user exceeding the allowed number of subnets in a
//   DB subnet groups.
//
//   * ErrCodeSubnetAlreadyInUse "SubnetAlreadyInUse"
//   The DB subnet is already in use in the Availability Zone.
//
//   * ErrCodeDBSubnetGroupDoesNotCoverEnoughAZs "DBSubnetGroupDoesNotCoverEnoughAZs"
//   Subnets in the DB subnet group should cover at least two Availability Zones
//   unless there is only one Availability Zone.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is invalid, or multiple subnets were requested that
//   are not all in a common VPC.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBSubnetGroup
func (c *RDS) ModifyDBSubnetGroup(input *ModifyDBSubnetGroupInput) (*ModifyDBSubnetGroupOutput, error) {
	req, out := c.ModifyDBSubnetGroupRequest(input)
	return out, req.Send()
}

// ModifyDBSubnetGroupWithContext is the same as ModifyDBSubnetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyDBSubnetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) ModifyDBSubnetGroupWithContext(ctx aws.Context, input *ModifyDBSubnetGroupInput, opts ...request.Option) (*ModifyDBSubnetGroupOutput, error) {
	req, out := c.ModifyDBSubnetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyEventSubscription = "ModifyEventSubscription"

// ModifyEventSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the ModifyEventSubscription operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyEventSubscription for more information on using the ModifyEventSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyEventSubscriptionRequest method.
//    req, resp := client.ModifyEventSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyEventSubscription
func (c *RDS) ModifyEventSubscriptionRequest(input *ModifyEventSubscriptionInput) (req *request.Request, output *ModifyEventSubscriptionOutput) {
	op := &request.Operation{
		Name:       opModifyEventSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyEventSubscriptionInput{}
	}

	output = &ModifyEventSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyEventSubscription API operation for Amazon Relational Database Service.
//
// Modifies an existing RDS event notification subscription. Note that you cannot
// modify the source identifiers using this call; to change source identifiers
// for a subscription, use the AddSourceIdentifierToSubscription and RemoveSourceIdentifierFromSubscription
// calls.
//
// You can see a list of the event categories for a given SourceType in the
// Events (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html)
// topic in the Amazon RDS User Guide or by using the DescribeEventCategories
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation ModifyEventSubscription for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEventSubscriptionQuotaExceededFault "EventSubscriptionQuotaExceeded"
//   You have reached the maximum number of event subscriptions.
//
//   * ErrCodeSubscriptionNotFoundFault "SubscriptionNotFound"
//   The subscription name does not exist.
//
//   * ErrCodeSNSInvalidTopicFault "SNSInvalidTopic"
//   SNS has responded that there is a problem with the SND topic specified.
//
//   * ErrCodeSNSNoAuthorizationFault "SNSNoAuthorization"
//   You do not have permission to publish to the SNS topic ARN.
//
//   * ErrCodeSNSTopicArnNotFoundFault "SNSTopicArnNotFound"
//   The SNS topic ARN does not exist.
//
//   * ErrCodeSubscriptionCategoryNotFoundFault "SubscriptionCategoryNotFound"
//   The supplied category does not exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyEventSubscription
func (c *RDS) ModifyEventSubscription(input *ModifyEventSubscriptionInput) (*ModifyEventSubscriptionOutput, error) {
	req, out := c.ModifyEventSubscriptionRequest(input)
	return out, req.Send()
}

// ModifyEventSubscriptionWithContext is the same as ModifyEventSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyEventSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) ModifyEventSubscriptionWithContext(ctx aws.Context, input *ModifyEventSubscriptionInput, opts ...request.Option) (*ModifyEventSubscriptionOutput, error) {
	req, out := c.ModifyEventSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyOptionGroup = "ModifyOptionGroup"

// ModifyOptionGroupRequest generates a "aws/request.Request" representing the
// client's request for the ModifyOptionGroup operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyOptionGroup for more information on using the ModifyOptionGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyOptionGroupRequest method.
//    req, resp := client.ModifyOptionGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyOptionGroup
func (c *RDS) ModifyOptionGroupRequest(input *ModifyOptionGroupInput) (req *request.Request, output *ModifyOptionGroupOutput) {
	op := &request.Operation{
		Name:       opModifyOptionGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyOptionGroupInput{}
	}

	output = &ModifyOptionGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyOptionGroup API operation for Amazon Relational Database Service.
//
// Modifies an existing option group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation ModifyOptionGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidOptionGroupStateFault "InvalidOptionGroupStateFault"
//   The option group is not in the available state.
//
//   * ErrCodeOptionGroupNotFoundFault "OptionGroupNotFoundFault"
//   The specified option group could not be found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyOptionGroup
func (c *RDS) ModifyOptionGroup(input *ModifyOptionGroupInput) (*ModifyOptionGroupOutput, error) {
	req, out := c.ModifyOptionGroupRequest(input)
	return out, req.Send()
}

// ModifyOptionGroupWithContext is the same as ModifyOptionGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyOptionGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) ModifyOptionGroupWithContext(ctx aws.Context, input *ModifyOptionGroupInput, opts ...request.Option) (*ModifyOptionGroupOutput, error) {
	req, out := c.ModifyOptionGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPromoteReadReplica = "PromoteReadReplica"

// PromoteReadReplicaRequest generates a "aws/request.Request" representing the
// client's request for the PromoteReadReplica operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PromoteReadReplica for more information on using the PromoteReadReplica
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PromoteReadReplicaRequest method.
//    req, resp := client.PromoteReadReplicaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/PromoteReadReplica
func (c *RDS) PromoteReadReplicaRequest(input *PromoteReadReplicaInput) (req *request.Request, output *PromoteReadReplicaOutput) {
	op := &request.Operation{
		Name:       opPromoteReadReplica,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PromoteReadReplicaInput{}
	}

	output = &PromoteReadReplicaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PromoteReadReplica API operation for Amazon Relational Database Service.
//
// Promotes a Read Replica DB instance to a standalone DB instance.
//
// We recommend that you enable automated backups on your Read Replica before
// promoting the Read Replica. This ensures that no backup is taken during the
// promotion process. Once the instance is promoted to a primary instance, backups
// are taken based on your backup settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation PromoteReadReplica for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The specified DB instance is not in the available state.
//
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier does not refer to an existing DB instance.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/PromoteReadReplica
func (c *RDS) PromoteReadReplica(input *PromoteReadReplicaInput) (*PromoteReadReplicaOutput, error) {
	req, out := c.PromoteReadReplicaRequest(input)
	return out, req.Send()
}

// PromoteReadReplicaWithContext is the same as PromoteReadReplica with the addition of
// the ability to pass a context and additional request options.
//
// See PromoteReadReplica for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) PromoteReadReplicaWithContext(ctx aws.Context, input *PromoteReadReplicaInput, opts ...request.Option) (*PromoteReadReplicaOutput, error) {
	req, out := c.PromoteReadReplicaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPromoteReadReplicaDBCluster = "PromoteReadReplicaDBCluster"

// PromoteReadReplicaDBClusterRequest generates a "aws/request.Request" representing the
// client's request for the PromoteReadReplicaDBCluster operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PromoteReadReplicaDBCluster for more information on using the PromoteReadReplicaDBCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PromoteReadReplicaDBClusterRequest method.
//    req, resp := client.PromoteReadReplicaDBClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/PromoteReadReplicaDBCluster
func (c *RDS) PromoteReadReplicaDBClusterRequest(input *PromoteReadReplicaDBClusterInput) (req *request.Request, output *PromoteReadReplicaDBClusterOutput) {
	op := &request.Operation{
		Name:       opPromoteReadReplicaDBCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PromoteReadReplicaDBClusterInput{}
	}

	output = &PromoteReadReplicaDBClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PromoteReadReplicaDBCluster API operation for Amazon Relational Database Service.
//
// Promotes a Read Replica DB cluster to a standalone DB cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation PromoteReadReplicaDBCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier does not refer to an existing DB cluster.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The DB cluster is not in a valid state.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/PromoteReadReplicaDBCluster
func (c *RDS) PromoteReadReplicaDBCluster(input *PromoteReadReplicaDBClusterInput) (*PromoteReadReplicaDBClusterOutput, error) {
	req, out := c.PromoteReadReplicaDBClusterRequest(input)
	return out, req.Send()
}

// PromoteReadReplicaDBClusterWithContext is the same as PromoteReadReplicaDBCluster with the addition of
// the ability to pass a context and additional request options.
//
// See PromoteReadReplicaDBCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) PromoteReadReplicaDBClusterWithContext(ctx aws.Context, input *PromoteReadReplicaDBClusterInput, opts ...request.Option) (*PromoteReadReplicaDBClusterOutput, error) {
	req, out := c.PromoteReadReplicaDBClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPurchaseReservedDBInstancesOffering = "PurchaseReservedDBInstancesOffering"

// PurchaseReservedDBInstancesOfferingRequest generates a "aws/request.Request" representing the
// client's request for the PurchaseReservedDBInstancesOffering operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PurchaseReservedDBInstancesOffering for more information on using the PurchaseReservedDBInstancesOffering
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PurchaseReservedDBInstancesOfferingRequest method.
//    req, resp := client.PurchaseReservedDBInstancesOfferingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/PurchaseReservedDBInstancesOffering
func (c *RDS) PurchaseReservedDBInstancesOfferingRequest(input *PurchaseReservedDBInstancesOfferingInput) (req *request.Request, output *PurchaseReservedDBInstancesOfferingOutput) {
	op := &request.Operation{
		Name:       opPurchaseReservedDBInstancesOffering,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PurchaseReservedDBInstancesOfferingInput{}
	}

	output = &PurchaseReservedDBInstancesOfferingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PurchaseReservedDBInstancesOffering API operation for Amazon Relational Database Service.
//
// Purchases a reserved DB instance offering.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation PurchaseReservedDBInstancesOffering for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeReservedDBInstancesOfferingNotFoundFault "ReservedDBInstancesOfferingNotFound"
//   Specified offering does not exist.
//
//   * ErrCodeReservedDBInstanceAlreadyExistsFault "ReservedDBInstanceAlreadyExists"
//   User already has a reservation with the given identifier.
//
//   * ErrCodeReservedDBInstanceQuotaExceededFault "ReservedDBInstanceQuotaExceeded"
//   Request would exceed the user's DB Instance quota.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/PurchaseReservedDBInstancesOffering
func (c *RDS) PurchaseReservedDBInstancesOffering(input *PurchaseReservedDBInstancesOfferingInput) (*PurchaseReservedDBInstancesOfferingOutput, error) {
	req, out := c.PurchaseReservedDBInstancesOfferingRequest(input)
	return out, req.Send()
}

// PurchaseReservedDBInstancesOfferingWithContext is the same as PurchaseReservedDBInstancesOffering with the addition of
// the ability to pass a context and additional request options.
//
// See PurchaseReservedDBInstancesOffering for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) PurchaseReservedDBInstancesOfferingWithContext(ctx aws.Context, input *PurchaseReservedDBInstancesOfferingInput, opts ...request.Option) (*PurchaseReservedDBInstancesOfferingOutput, error) {
	req, out := c.PurchaseReservedDBInstancesOfferingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRebootDBInstance = "RebootDBInstance"

// RebootDBInstanceRequest generates a "aws/request.Request" representing the
// client's request for the RebootDBInstance operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RebootDBInstance for more information on using the RebootDBInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RebootDBInstanceRequest method.
//    req, resp := client.RebootDBInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RebootDBInstance
func (c *RDS) RebootDBInstanceRequest(input *RebootDBInstanceInput) (req *request.Request, output *RebootDBInstanceOutput) {
	op := &request.Operation{
		Name:       opRebootDBInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebootDBInstanceInput{}
	}

	output = &RebootDBInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RebootDBInstance API operation for Amazon Relational Database Service.
//
// Rebooting a DB instance restarts the database engine service. A reboot also
// applies to the DB instance any modifications to the associated DB parameter
// group that were pending. Rebooting a DB instance results in a momentary outage
// of the instance, during which the DB instance status is set to rebooting.
// If the RDS instance is configured for MultiAZ, it is possible that the reboot
// will be conducted through a failover. An Amazon RDS event is created when
// the reboot is completed.
//
// If your DB instance is deployed in multiple Availability Zones, you can force
// a failover from one AZ to the other during the reboot. You might force a
// failover to test the availability of your DB instance deployment or to restore
// operations to the original AZ after a failover occurs.
//
// The time required to reboot is a function of the specific database engine's
// crash recovery process. To improve the reboot time, we recommend that you
// reduce database activities as much as possible during the reboot process
// to reduce rollback activity for in-transit transactions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation RebootDBInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The specified DB instance is not in the available state.
//
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier does not refer to an existing DB instance.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RebootDBInstance
func (c *RDS) RebootDBInstance(input *RebootDBInstanceInput) (*RebootDBInstanceOutput, error) {
	req, out := c.RebootDBInstanceRequest(input)
	return out, req.Send()
}

// RebootDBInstanceWithContext is the same as RebootDBInstance with the addition of
// the ability to pass a context and additional request options.
//
// See RebootDBInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) RebootDBInstanceWithContext(ctx aws.Context, input *RebootDBInstanceInput, opts ...request.Option) (*RebootDBInstanceOutput, error) {
	req, out := c.RebootDBInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveRoleFromDBCluster = "RemoveRoleFromDBCluster"

// RemoveRoleFromDBClusterRequest generates a "aws/request.Request" representing the
// client's request for the RemoveRoleFromDBCluster operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveRoleFromDBCluster for more information on using the RemoveRoleFromDBCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveRoleFromDBClusterRequest method.
//    req, resp := client.RemoveRoleFromDBClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RemoveRoleFromDBCluster
func (c *RDS) RemoveRoleFromDBClusterRequest(input *RemoveRoleFromDBClusterInput) (req *request.Request, output *RemoveRoleFromDBClusterOutput) {
	op := &request.Operation{
		Name:       opRemoveRoleFromDBCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveRoleFromDBClusterInput{}
	}

	output = &RemoveRoleFromDBClusterOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveRoleFromDBCluster API operation for Amazon Relational Database Service.
//
// Disassociates an Identity and Access Management (IAM) role from an Aurora
// DB cluster. For more information, see Authorizing Amazon Aurora to Access
// Other AWS Services On Your Behalf (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Aurora.Authorizing.AWSServices.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation RemoveRoleFromDBCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier does not refer to an existing DB cluster.
//
//   * ErrCodeDBClusterRoleNotFoundFault "DBClusterRoleNotFound"
//   The specified IAM role Amazon Resource Name (ARN) is not associated with
//   the specified DB cluster.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The DB cluster is not in a valid state.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RemoveRoleFromDBCluster
func (c *RDS) RemoveRoleFromDBCluster(input *RemoveRoleFromDBClusterInput) (*RemoveRoleFromDBClusterOutput, error) {
	req, out := c.RemoveRoleFromDBClusterRequest(input)
	return out, req.Send()
}

// RemoveRoleFromDBClusterWithContext is the same as RemoveRoleFromDBCluster with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveRoleFromDBCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) RemoveRoleFromDBClusterWithContext(ctx aws.Context, input *RemoveRoleFromDBClusterInput, opts ...request.Option) (*RemoveRoleFromDBClusterOutput, error) {
	req, out := c.RemoveRoleFromDBClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveSourceIdentifierFromSubscription = "RemoveSourceIdentifierFromSubscription"

// RemoveSourceIdentifierFromSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the RemoveSourceIdentifierFromSubscription operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveSourceIdentifierFromSubscription for more information on using the RemoveSourceIdentifierFromSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveSourceIdentifierFromSubscriptionRequest method.
//    req, resp := client.RemoveSourceIdentifierFromSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RemoveSourceIdentifierFromSubscription
func (c *RDS) RemoveSourceIdentifierFromSubscriptionRequest(input *RemoveSourceIdentifierFromSubscriptionInput) (req *request.Request, output *RemoveSourceIdentifierFromSubscriptionOutput) {
	op := &request.Operation{
		Name:       opRemoveSourceIdentifierFromSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveSourceIdentifierFromSubscriptionInput{}
	}

	output = &RemoveSourceIdentifierFromSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RemoveSourceIdentifierFromSubscription API operation for Amazon Relational Database Service.
//
// Removes a source identifier from an existing RDS event notification subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation RemoveSourceIdentifierFromSubscription for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeSubscriptionNotFoundFault "SubscriptionNotFound"
//   The subscription name does not exist.
//
//   * ErrCodeSourceNotFoundFault "SourceNotFound"
//   The requested source could not be found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RemoveSourceIdentifierFromSubscription
func (c *RDS) RemoveSourceIdentifierFromSubscription(input *RemoveSourceIdentifierFromSubscriptionInput) (*RemoveSourceIdentifierFromSubscriptionOutput, error) {
	req, out := c.RemoveSourceIdentifierFromSubscriptionRequest(input)
	return out, req.Send()
}

// RemoveSourceIdentifierFromSubscriptionWithContext is the same as RemoveSourceIdentifierFromSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveSourceIdentifierFromSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) RemoveSourceIdentifierFromSubscriptionWithContext(ctx aws.Context, input *RemoveSourceIdentifierFromSubscriptionInput, opts ...request.Option) (*RemoveSourceIdentifierFromSubscriptionOutput, error) {
	req, out := c.RemoveSourceIdentifierFromSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveTagsFromResource = "RemoveTagsFromResource"

// RemoveTagsFromResourceRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTagsFromResource operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveTagsFromResource for more information on using the RemoveTagsFromResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveTagsFromResourceRequest method.
//    req, resp := client.RemoveTagsFromResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RemoveTagsFromResource
func (c *RDS) RemoveTagsFromResourceRequest(input *RemoveTagsFromResourceInput) (req *request.Request, output *RemoveTagsFromResourceOutput) {
	op := &request.Operation{
		Name:       opRemoveTagsFromResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTagsFromResourceInput{}
	}

	output = &RemoveTagsFromResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveTagsFromResource API operation for Amazon Relational Database Service.
//
// Removes metadata tags from an Amazon RDS resource.
//
// For an overview on tagging an Amazon RDS resource, see Tagging Amazon RDS
// Resources (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Tagging.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation RemoveTagsFromResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier does not refer to an existing DB instance.
//
//   * ErrCodeDBSnapshotNotFoundFault "DBSnapshotNotFound"
//   DBSnapshotIdentifier does not refer to an existing DB snapshot.
//
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier does not refer to an existing DB cluster.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RemoveTagsFromResource
func (c *RDS) RemoveTagsFromResource(input *RemoveTagsFromResourceInput) (*RemoveTagsFromResourceOutput, error) {
	req, out := c.RemoveTagsFromResourceRequest(input)
	return out, req.Send()
}

// RemoveTagsFromResourceWithContext is the same as RemoveTagsFromResource with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveTagsFromResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) RemoveTagsFromResourceWithContext(ctx aws.Context, input *RemoveTagsFromResourceInput, opts ...request.Option) (*RemoveTagsFromResourceOutput, error) {
	req, out := c.RemoveTagsFromResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResetDBClusterParameterGroup = "ResetDBClusterParameterGroup"

// ResetDBClusterParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the ResetDBClusterParameterGroup operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResetDBClusterParameterGroup for more information on using the ResetDBClusterParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ResetDBClusterParameterGroupRequest method.
//    req, resp := client.ResetDBClusterParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ResetDBClusterParameterGroup
func (c *RDS) ResetDBClusterParameterGroupRequest(input *ResetDBClusterParameterGroupInput) (req *request.Request, output *DBClusterParameterGroupNameMessage) {
	op := &request.Operation{
		Name:       opResetDBClusterParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetDBClusterParameterGroupInput{}
	}

	output = &DBClusterParameterGroupNameMessage{}
	req = c.newRequest(op, input, output)
	return
}

// ResetDBClusterParameterGroup API operation for Amazon Relational Database Service.
//
// Modifies the parameters of a DB cluster parameter group to the default value.
// To reset specific parameters submit a list of the following: ParameterName
// and ApplyMethod. To reset the entire DB cluster parameter group, specify
// the DBClusterParameterGroupName and ResetAllParameters parameters.
//
// When resetting the entire group, dynamic parameters are updated immediately
// and static parameters are set to pending-reboot to take effect on the next
// DB instance restart or RebootDBInstance request. You must call RebootDBInstance
// for every DB instance in your DB cluster that you want the updated static
// parameter to apply to.
//
// For more information on Amazon Aurora, see Aurora on Amazon RDS (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html)
// in the Amazon RDS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation ResetDBClusterParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBParameterGroupStateFault "InvalidDBParameterGroupState"
//   The DB parameter group is in use or is in an invalid state. If you are attempting
//   to delete the parameter group, you cannot delete it when the parameter group
//   is in this state.
//
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName does not refer to an existing DB parameter group.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ResetDBClusterParameterGroup
func (c *RDS) ResetDBClusterParameterGroup(input *ResetDBClusterParameterGroupInput) (*DBClusterParameterGroupNameMessage, error) {
	req, out := c.ResetDBClusterParameterGroupRequest(input)
	return out, req.Send()
}

// ResetDBClusterParameterGroupWithContext is the same as ResetDBClusterParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ResetDBClusterParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) ResetDBClusterParameterGroupWithContext(ctx aws.Context, input *ResetDBClusterParameterGroupInput, opts ...request.Option) (*DBClusterParameterGroupNameMessage, error) {
	req, out := c.ResetDBClusterParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResetDBParameterGroup = "ResetDBParameterGroup"

// ResetDBParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the ResetDBParameterGroup operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResetDBParameterGroup for more information on using the ResetDBParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ResetDBParameterGroupRequest method.
//    req, resp := client.ResetDBParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ResetDBParameterGroup
func (c *RDS) ResetDBParameterGroupRequest(input *ResetDBParameterGroupInput) (req *request.Request, output *DBParameterGroupNameMessage) {
	op := &request.Operation{
		Name:       opResetDBParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetDBParameterGroupInput{}
	}

	output = &DBParameterGroupNameMessage{}
	req = c.newRequest(op, input, output)
	return
}

// ResetDBParameterGroup API operation for Amazon Relational Database Service.
//
// Modifies the parameters of a DB parameter group to the engine/system default
// value. To reset specific parameters, provide a list of the following: ParameterName
// and ApplyMethod. To reset the entire DB parameter group, specify the DBParameterGroup
// name and ResetAllParameters parameters. When resetting the entire group,
// dynamic parameters are updated immediately and static parameters are set
// to pending-reboot to take effect on the next DB instance restart or RebootDBInstance
// request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation ResetDBParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDBParameterGroupStateFault "InvalidDBParameterGroupState"
//   The DB parameter group is in use or is in an invalid state. If you are attempting
//   to delete the parameter group, you cannot delete it when the parameter group
//   is in this state.
//
//   * ErrCodeDBParameterGroupNotFoundFault "DBParameterGroupNotFound"
//   DBParameterGroupName does not refer to an existing DB parameter group.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ResetDBParameterGroup
func (c *RDS) ResetDBParameterGroup(input *ResetDBParameterGroupInput) (*DBParameterGroupNameMessage, error) {
	req, out := c.ResetDBParameterGroupRequest(input)
	return out, req.Send()
}

// ResetDBParameterGroupWithContext is the same as ResetDBParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ResetDBParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) ResetDBParameterGroupWithContext(ctx aws.Context, input *ResetDBParameterGroupInput, opts ...request.Option) (*DBParameterGroupNameMessage, error) {
	req, out := c.ResetDBParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestoreDBClusterFromS3 = "RestoreDBClusterFromS3"

// RestoreDBClusterFromS3Request generates a "aws/request.Request" representing the
// client's request for the RestoreDBClusterFromS3 operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreDBClusterFromS3 for more information on using the RestoreDBClusterFromS3
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RestoreDBClusterFromS3Request method.
//    req, resp := client.RestoreDBClusterFromS3Request(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBClusterFromS3
func (c *RDS) RestoreDBClusterFromS3Request(input *RestoreDBClusterFromS3Input) (req *request.Request, output *RestoreDBClusterFromS3Output) {
	op := &request.Operation{
		Name:       opRestoreDBClusterFromS3,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreDBClusterFromS3Input{}
	}

	output = &RestoreDBClusterFromS3Output{}
	req = c.newRequest(op, input, output)
	return
}

// RestoreDBClusterFromS3 API operation for Amazon Relational Database Service.
//
// Creates an Amazon Aurora DB cluster from data stored in an Amazon S3 bucket.
// Amazon RDS must be authorized to access the Amazon S3 bucket and the data
// must be created using the Percona XtraBackup utility as described in Migrating
// Data from MySQL by Using an Amazon S3 Bucket (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Aurora.Migrate.MySQL.html#Aurora.Migrate.MySQL.S3).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation RestoreDBClusterFromS3 for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterAlreadyExistsFault "DBClusterAlreadyExistsFault"
//   User already has a DB cluster with the given identifier.
//
//   * ErrCodeDBClusterQuotaExceededFault "DBClusterQuotaExceededFault"
//   User attempted to create a new DB cluster and the user has already reached
//   the maximum allowed DB cluster quota.
//
//   * ErrCodeStorageQuotaExceededFault "StorageQuotaExceeded"
//   Request would result in user exceeding the allowed amount of storage available
//   across all DB instances.
//
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName does not refer to an existing DB subnet group.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   DB subnet group does not cover all Availability Zones after it is created
//   because users' change.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The DB cluster is not in a valid state.
//
//   * ErrCodeInvalidDBSubnetGroupStateFault "InvalidDBSubnetGroupStateFault"
//   The DB subnet group cannot be deleted because it is in use.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is invalid, or multiple subnets were requested that
//   are not all in a common VPC.
//
//   * ErrCodeInvalidS3BucketFault "InvalidS3BucketFault"
//   The specified Amazon S3 bucket name could not be found or Amazon RDS is not
//   authorized to access the specified Amazon S3 bucket. Verify the SourceS3BucketName
//   and S3IngestionRoleArn values and try again.
//
//   * ErrCodeDBClusterParameterGroupNotFoundFault "DBClusterParameterGroupNotFound"
//   DBClusterParameterGroupName does not refer to an existing DB Cluster parameter
//   group.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   Error accessing KMS key.
//
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier does not refer to an existing DB cluster.
//
//   * ErrCodeInsufficientStorageClusterCapacityFault "InsufficientStorageClusterCapacity"
//   There is insufficient storage available for the current action. You may be
//   able to resolve this error by updating your subnet group to use different
//   Availability Zones that have more storage available.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBClusterFromS3
func (c *RDS) RestoreDBClusterFromS3(input *RestoreDBClusterFromS3Input) (*RestoreDBClusterFromS3Output, error) {
	req, out := c.RestoreDBClusterFromS3Request(input)
	return out, req.Send()
}

// RestoreDBClusterFromS3WithContext is the same as RestoreDBClusterFromS3 with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreDBClusterFromS3 for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) RestoreDBClusterFromS3WithContext(ctx aws.Context, input *RestoreDBClusterFromS3Input, opts ...request.Option) (*RestoreDBClusterFromS3Output, error) {
	req, out := c.RestoreDBClusterFromS3Request(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestoreDBClusterFromSnapshot = "RestoreDBClusterFromSnapshot"

// RestoreDBClusterFromSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the RestoreDBClusterFromSnapshot operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreDBClusterFromSnapshot for more information on using the RestoreDBClusterFromSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RestoreDBClusterFromSnapshotRequest method.
//    req, resp := client.RestoreDBClusterFromSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBClusterFromSnapshot
func (c *RDS) RestoreDBClusterFromSnapshotRequest(input *RestoreDBClusterFromSnapshotInput) (req *request.Request, output *RestoreDBClusterFromSnapshotOutput) {
	op := &request.Operation{
		Name:       opRestoreDBClusterFromSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreDBClusterFromSnapshotInput{}
	}

	output = &RestoreDBClusterFromSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RestoreDBClusterFromSnapshot API operation for Amazon Relational Database Service.
//
// Creates a new DB cluster from a DB cluster snapshot. The target DB cluster
// is created from the source DB cluster restore point with the same configuration
// as the original source DB cluster, except that the new DB cluster is created
// with the default security group.
//
// For more information on Amazon Aurora, see Aurora on Amazon RDS (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html)
// in the Amazon RDS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation RestoreDBClusterFromSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterAlreadyExistsFault "DBClusterAlreadyExistsFault"
//   User already has a DB cluster with the given identifier.
//
//   * ErrCodeDBClusterQuotaExceededFault "DBClusterQuotaExceededFault"
//   User attempted to create a new DB cluster and the user has already reached
//   the maximum allowed DB cluster quota.
//
//   * ErrCodeStorageQuotaExceededFault "StorageQuotaExceeded"
//   Request would result in user exceeding the allowed amount of storage available
//   across all DB instances.
//
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName does not refer to an existing DB subnet group.
//
//   * ErrCodeDBSnapshotNotFoundFault "DBSnapshotNotFound"
//   DBSnapshotIdentifier does not refer to an existing DB snapshot.
//
//   * ErrCodeDBClusterSnapshotNotFoundFault "DBClusterSnapshotNotFoundFault"
//   DBClusterSnapshotIdentifier does not refer to an existing DB cluster snapshot.
//
//   * ErrCodeInsufficientDBClusterCapacityFault "InsufficientDBClusterCapacityFault"
//   The DB cluster does not have enough capacity for the current operation.
//
//   * ErrCodeInsufficientStorageClusterCapacityFault "InsufficientStorageClusterCapacity"
//   There is insufficient storage available for the current action. You may be
//   able to resolve this error by updating your subnet group to use different
//   Availability Zones that have more storage available.
//
//   * ErrCodeInvalidDBSnapshotStateFault "InvalidDBSnapshotState"
//   The state of the DB snapshot does not allow deletion.
//
//   * ErrCodeInvalidDBClusterSnapshotStateFault "InvalidDBClusterSnapshotStateFault"
//   The supplied value is not a valid DB cluster snapshot state.
//
//   * ErrCodeStorageQuotaExceededFault "StorageQuotaExceeded"
//   Request would result in user exceeding the allowed amount of storage available
//   across all DB instances.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   DB subnet group does not cover all Availability Zones after it is created
//   because users' change.
//
//   * ErrCodeInvalidRestoreFault "InvalidRestoreFault"
//   Cannot restore from vpc backup to non-vpc DB instance.
//
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName does not refer to an existing DB subnet group.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is invalid, or multiple subnets were requested that
//   are not all in a common VPC.
//
//   * ErrCodeOptionGroupNotFoundFault "OptionGroupNotFoundFault"
//   The specified option group could not be found.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   Error accessing KMS key.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBClusterFromSnapshot
func (c *RDS) RestoreDBClusterFromSnapshot(input *RestoreDBClusterFromSnapshotInput) (*RestoreDBClusterFromSnapshotOutput, error) {
	req, out := c.RestoreDBClusterFromSnapshotRequest(input)
	return out, req.Send()
}

// RestoreDBClusterFromSnapshotWithContext is the same as RestoreDBClusterFromSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreDBClusterFromSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) RestoreDBClusterFromSnapshotWithContext(ctx aws.Context, input *RestoreDBClusterFromSnapshotInput, opts ...request.Option) (*RestoreDBClusterFromSnapshotOutput, error) {
	req, out := c.RestoreDBClusterFromSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestoreDBClusterToPointInTime = "RestoreDBClusterToPointInTime"

// RestoreDBClusterToPointInTimeRequest generates a "aws/request.Request" representing the
// client's request for the RestoreDBClusterToPointInTime operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreDBClusterToPointInTime for more information on using the RestoreDBClusterToPointInTime
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RestoreDBClusterToPointInTimeRequest method.
//    req, resp := client.RestoreDBClusterToPointInTimeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBClusterToPointInTime
func (c *RDS) RestoreDBClusterToPointInTimeRequest(input *RestoreDBClusterToPointInTimeInput) (req *request.Request, output *RestoreDBClusterToPointInTimeOutput) {
	op := &request.Operation{
		Name:       opRestoreDBClusterToPointInTime,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreDBClusterToPointInTimeInput{}
	}

	output = &RestoreDBClusterToPointInTimeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RestoreDBClusterToPointInTime API operation for Amazon Relational Database Service.
//
// Restores a DB cluster to an arbitrary point in time. Users can restore to
// any point in time before LatestRestorableTime for up to BackupRetentionPeriod
// days. The target DB cluster is created from the source DB cluster with the
// same configuration as the original DB cluster, except that the new DB cluster
// is created with the default DB security group.
//
// This action only restores the DB cluster, not the DB instances for that DB
// cluster. You must invoke the CreateDBInstance action to create DB instances
// for the restored DB cluster, specifying the identifier of the restored DB
// cluster in DBClusterIdentifier. You can create DB instances only after the
// RestoreDBClusterToPointInTime action has completed and the DB cluster is
// available.
//
// For more information on Amazon Aurora, see Aurora on Amazon RDS (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Aurora.html)
// in the Amazon RDS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation RestoreDBClusterToPointInTime for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBClusterAlreadyExistsFault "DBClusterAlreadyExistsFault"
//   User already has a DB cluster with the given identifier.
//
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier does not refer to an existing DB cluster.
//
//   * ErrCodeDBClusterQuotaExceededFault "DBClusterQuotaExceededFault"
//   User attempted to create a new DB cluster and the user has already reached
//   the maximum allowed DB cluster quota.
//
//   * ErrCodeDBClusterSnapshotNotFoundFault "DBClusterSnapshotNotFoundFault"
//   DBClusterSnapshotIdentifier does not refer to an existing DB cluster snapshot.
//
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName does not refer to an existing DB subnet group.
//
//   * ErrCodeInsufficientDBClusterCapacityFault "InsufficientDBClusterCapacityFault"
//   The DB cluster does not have enough capacity for the current operation.
//
//   * ErrCodeInsufficientStorageClusterCapacityFault "InsufficientStorageClusterCapacity"
//   There is insufficient storage available for the current action. You may be
//   able to resolve this error by updating your subnet group to use different
//   Availability Zones that have more storage available.
//
//   * ErrCodeInvalidDBClusterSnapshotStateFault "InvalidDBClusterSnapshotStateFault"
//   The supplied value is not a valid DB cluster snapshot state.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The DB cluster is not in a valid state.
//
//   * ErrCodeInvalidDBSnapshotStateFault "InvalidDBSnapshotState"
//   The state of the DB snapshot does not allow deletion.
//
//   * ErrCodeInvalidRestoreFault "InvalidRestoreFault"
//   Cannot restore from vpc backup to non-vpc DB instance.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is invalid, or multiple subnets were requested that
//   are not all in a common VPC.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   DB subnet group does not cover all Availability Zones after it is created
//   because users' change.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   Error accessing KMS key.
//
//   * ErrCodeOptionGroupNotFoundFault "OptionGroupNotFoundFault"
//   The specified option group could not be found.
//
//   * ErrCodeStorageQuotaExceededFault "StorageQuotaExceeded"
//   Request would result in user exceeding the allowed amount of storage available
//   across all DB instances.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBClusterToPointInTime
func (c *RDS) RestoreDBClusterToPointInTime(input *RestoreDBClusterToPointInTimeInput) (*RestoreDBClusterToPointInTimeOutput, error) {
	req, out := c.RestoreDBClusterToPointInTimeRequest(input)
	return out, req.Send()
}

// RestoreDBClusterToPointInTimeWithContext is the same as RestoreDBClusterToPointInTime with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreDBClusterToPointInTime for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) RestoreDBClusterToPointInTimeWithContext(ctx aws.Context, input *RestoreDBClusterToPointInTimeInput, opts ...request.Option) (*RestoreDBClusterToPointInTimeOutput, error) {
	req, out := c.RestoreDBClusterToPointInTimeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestoreDBInstanceFromDBSnapshot = "RestoreDBInstanceFromDBSnapshot"

// RestoreDBInstanceFromDBSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the RestoreDBInstanceFromDBSnapshot operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreDBInstanceFromDBSnapshot for more information on using the RestoreDBInstanceFromDBSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RestoreDBInstanceFromDBSnapshotRequest method.
//    req, resp := client.RestoreDBInstanceFromDBSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBInstanceFromDBSnapshot
func (c *RDS) RestoreDBInstanceFromDBSnapshotRequest(input *RestoreDBInstanceFromDBSnapshotInput) (req *request.Request, output *RestoreDBInstanceFromDBSnapshotOutput) {
	op := &request.Operation{
		Name:       opRestoreDBInstanceFromDBSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreDBInstanceFromDBSnapshotInput{}
	}

	output = &RestoreDBInstanceFromDBSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RestoreDBInstanceFromDBSnapshot API operation for Amazon Relational Database Service.
//
// Creates a new DB instance from a DB snapshot. The target database is created
// from the source database restore point with the most of original configuration
// with the default security group and the default DB parameter group. By default,
// the new DB instance is created as a single-AZ deployment except when the
// instance is a SQL Server instance that has an option group that is associated
// with mirroring; in this case, the instance becomes a mirrored AZ deployment
// and not a single-AZ deployment.
//
// If your intent is to replace your original DB instance with the new, restored
// DB instance, then rename your original DB instance before you call the RestoreDBInstanceFromDBSnapshot
// action. RDS does not allow two DB instances with the same name. Once you
// have renamed your original DB instance with a different identifier, then
// you can pass the original name of the DB instance as the DBInstanceIdentifier
// in the call to the RestoreDBInstanceFromDBSnapshot action. The result is
// that you will replace the original DB instance with the DB instance created
// from the snapshot.
//
// If you are restoring from a shared manual DB snapshot, the DBSnapshotIdentifier
// must be the ARN of the shared DB snapshot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation RestoreDBInstanceFromDBSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceAlreadyExistsFault "DBInstanceAlreadyExists"
//   User already has a DB instance with the given identifier.
//
//   * ErrCodeDBSnapshotNotFoundFault "DBSnapshotNotFound"
//   DBSnapshotIdentifier does not refer to an existing DB snapshot.
//
//   * ErrCodeInstanceQuotaExceededFault "InstanceQuotaExceeded"
//   Request would result in user exceeding the allowed number of DB instances.
//
//   * ErrCodeInsufficientDBInstanceCapacityFault "InsufficientDBInstanceCapacity"
//   Specified DB instance class is not available in the specified Availability
//   Zone.
//
//   * ErrCodeInvalidDBSnapshotStateFault "InvalidDBSnapshotState"
//   The state of the DB snapshot does not allow deletion.
//
//   * ErrCodeStorageQuotaExceededFault "StorageQuotaExceeded"
//   Request would result in user exceeding the allowed amount of storage available
//   across all DB instances.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   DB subnet group does not cover all Availability Zones after it is created
//   because users' change.
//
//   * ErrCodeInvalidRestoreFault "InvalidRestoreFault"
//   Cannot restore from vpc backup to non-vpc DB instance.
//
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName does not refer to an existing DB subnet group.
//
//   * ErrCodeDBSubnetGroupDoesNotCoverEnoughAZs "DBSubnetGroupDoesNotCoverEnoughAZs"
//   Subnets in the DB subnet group should cover at least two Availability Zones
//   unless there is only one Availability Zone.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is invalid, or multiple subnets were requested that
//   are not all in a common VPC.
//
//   * ErrCodeProvisionedIopsNotAvailableInAZFault "ProvisionedIopsNotAvailableInAZFault"
//   Provisioned IOPS not available in the specified Availability Zone.
//
//   * ErrCodeOptionGroupNotFoundFault "OptionGroupNotFoundFault"
//   The specified option group could not be found.
//
//   * ErrCodeStorageTypeNotSupportedFault "StorageTypeNotSupported"
//   StorageType specified cannot be associated with the DB Instance.
//
//   * ErrCodeAuthorizationNotFoundFault "AuthorizationNotFound"
//   Specified CIDRIP or EC2 security group is not authorized for the specified
//   DB security group.
//
//   RDS may not also be authorized via IAM to perform necessary actions on your
//   behalf.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   Error accessing KMS key.
//
//   * ErrCodeDBSecurityGroupNotFoundFault "DBSecurityGroupNotFound"
//   DBSecurityGroupName does not refer to an existing DB security group.
//
//   * ErrCodeDomainNotFoundFault "DomainNotFoundFault"
//   Domain does not refer to an existing Active Directory Domain.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBInstanceFromDBSnapshot
func (c *RDS) RestoreDBInstanceFromDBSnapshot(input *RestoreDBInstanceFromDBSnapshotInput) (*RestoreDBInstanceFromDBSnapshotOutput, error) {
	req, out := c.RestoreDBInstanceFromDBSnapshotRequest(input)
	return out, req.Send()
}

// RestoreDBInstanceFromDBSnapshotWithContext is the same as RestoreDBInstanceFromDBSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreDBInstanceFromDBSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) RestoreDBInstanceFromDBSnapshotWithContext(ctx aws.Context, input *RestoreDBInstanceFromDBSnapshotInput, opts ...request.Option) (*RestoreDBInstanceFromDBSnapshotOutput, error) {
	req, out := c.RestoreDBInstanceFromDBSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestoreDBInstanceToPointInTime = "RestoreDBInstanceToPointInTime"

// RestoreDBInstanceToPointInTimeRequest generates a "aws/request.Request" representing the
// client's request for the RestoreDBInstanceToPointInTime operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreDBInstanceToPointInTime for more information on using the RestoreDBInstanceToPointInTime
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RestoreDBInstanceToPointInTimeRequest method.
//    req, resp := client.RestoreDBInstanceToPointInTimeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBInstanceToPointInTime
func (c *RDS) RestoreDBInstanceToPointInTimeRequest(input *RestoreDBInstanceToPointInTimeInput) (req *request.Request, output *RestoreDBInstanceToPointInTimeOutput) {
	op := &request.Operation{
		Name:       opRestoreDBInstanceToPointInTime,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreDBInstanceToPointInTimeInput{}
	}

	output = &RestoreDBInstanceToPointInTimeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RestoreDBInstanceToPointInTime API operation for Amazon Relational Database Service.
//
// Restores a DB instance to an arbitrary point in time. You can restore to
// any point in time before the time identified by the LatestRestorableTime
// property. You can restore to a point up to the number of days specified by
// the BackupRetentionPeriod property.
//
// The target database is created with most of the original configuration, but
// in a system-selected availability zone, with the default security group,
// the default subnet group, and the default DB parameter group. By default,
// the new DB instance is created as a single-AZ deployment except when the
// instance is a SQL Server instance that has an option group that is associated
// with mirroring; in this case, the instance becomes a mirrored deployment
// and not a single-AZ deployment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation RestoreDBInstanceToPointInTime for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceAlreadyExistsFault "DBInstanceAlreadyExists"
//   User already has a DB instance with the given identifier.
//
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier does not refer to an existing DB instance.
//
//   * ErrCodeInstanceQuotaExceededFault "InstanceQuotaExceeded"
//   Request would result in user exceeding the allowed number of DB instances.
//
//   * ErrCodeInsufficientDBInstanceCapacityFault "InsufficientDBInstanceCapacity"
//   Specified DB instance class is not available in the specified Availability
//   Zone.
//
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The specified DB instance is not in the available state.
//
//   * ErrCodePointInTimeRestoreNotEnabledFault "PointInTimeRestoreNotEnabled"
//   SourceDBInstanceIdentifier refers to a DB instance with BackupRetentionPeriod
//   equal to 0.
//
//   * ErrCodeStorageQuotaExceededFault "StorageQuotaExceeded"
//   Request would result in user exceeding the allowed amount of storage available
//   across all DB instances.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   DB subnet group does not cover all Availability Zones after it is created
//   because users' change.
//
//   * ErrCodeInvalidRestoreFault "InvalidRestoreFault"
//   Cannot restore from vpc backup to non-vpc DB instance.
//
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName does not refer to an existing DB subnet group.
//
//   * ErrCodeDBSubnetGroupDoesNotCoverEnoughAZs "DBSubnetGroupDoesNotCoverEnoughAZs"
//   Subnets in the DB subnet group should cover at least two Availability Zones
//   unless there is only one Availability Zone.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is invalid, or multiple subnets were requested that
//   are not all in a common VPC.
//
//   * ErrCodeProvisionedIopsNotAvailableInAZFault "ProvisionedIopsNotAvailableInAZFault"
//   Provisioned IOPS not available in the specified Availability Zone.
//
//   * ErrCodeOptionGroupNotFoundFault "OptionGroupNotFoundFault"
//   The specified option group could not be found.
//
//   * ErrCodeStorageTypeNotSupportedFault "StorageTypeNotSupported"
//   StorageType specified cannot be associated with the DB Instance.
//
//   * ErrCodeAuthorizationNotFoundFault "AuthorizationNotFound"
//   Specified CIDRIP or EC2 security group is not authorized for the specified
//   DB security group.
//
//   RDS may not also be authorized via IAM to perform necessary actions on your
//   behalf.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   Error accessing KMS key.
//
//   * ErrCodeDBSecurityGroupNotFoundFault "DBSecurityGroupNotFound"
//   DBSecurityGroupName does not refer to an existing DB security group.
//
//   * ErrCodeDomainNotFoundFault "DomainNotFoundFault"
//   Domain does not refer to an existing Active Directory Domain.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBInstanceToPointInTime
func (c *RDS) RestoreDBInstanceToPointInTime(input *RestoreDBInstanceToPointInTimeInput) (*RestoreDBInstanceToPointInTimeOutput, error) {
	req, out := c.RestoreDBInstanceToPointInTimeRequest(input)
	return out, req.Send()
}

// RestoreDBInstanceToPointInTimeWithContext is the same as RestoreDBInstanceToPointInTime with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreDBInstanceToPointInTime for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) RestoreDBInstanceToPointInTimeWithContext(ctx aws.Context, input *RestoreDBInstanceToPointInTimeInput, opts ...request.Option) (*RestoreDBInstanceToPointInTimeOutput, error) {
	req, out := c.RestoreDBInstanceToPointInTimeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRevokeDBSecurityGroupIngress = "RevokeDBSecurityGroupIngress"

// RevokeDBSecurityGroupIngressRequest generates a "aws/request.Request" representing the
// client's request for the RevokeDBSecurityGroupIngress operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RevokeDBSecurityGroupIngress for more information on using the RevokeDBSecurityGroupIngress
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RevokeDBSecurityGroupIngressRequest method.
//    req, resp := client.RevokeDBSecurityGroupIngressRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RevokeDBSecurityGroupIngress
func (c *RDS) RevokeDBSecurityGroupIngressRequest(input *RevokeDBSecurityGroupIngressInput) (req *request.Request, output *RevokeDBSecurityGroupIngressOutput) {
	op := &request.Operation{
		Name:       opRevokeDBSecurityGroupIngress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RevokeDBSecurityGroupIngressInput{}
	}

	output = &RevokeDBSecurityGroupIngressOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RevokeDBSecurityGroupIngress API operation for Amazon Relational Database Service.
//
// Revokes ingress from a DBSecurityGroup for previously authorized IP ranges
// or EC2 or VPC Security Groups. Required parameters for this API are one of
// CIDRIP, EC2SecurityGroupId for VPC, or (EC2SecurityGroupOwnerId and either
// EC2SecurityGroupName or EC2SecurityGroupId).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation RevokeDBSecurityGroupIngress for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBSecurityGroupNotFoundFault "DBSecurityGroupNotFound"
//   DBSecurityGroupName does not refer to an existing DB security group.
//
//   * ErrCodeAuthorizationNotFoundFault "AuthorizationNotFound"
//   Specified CIDRIP or EC2 security group is not authorized for the specified
//   DB security group.
//
//   RDS may not also be authorized via IAM to perform necessary actions on your
//   behalf.
//
//   * ErrCodeInvalidDBSecurityGroupStateFault "InvalidDBSecurityGroupState"
//   The state of the DB security group does not allow deletion.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RevokeDBSecurityGroupIngress
func (c *RDS) RevokeDBSecurityGroupIngress(input *RevokeDBSecurityGroupIngressInput) (*RevokeDBSecurityGroupIngressOutput, error) {
	req, out := c.RevokeDBSecurityGroupIngressRequest(input)
	return out, req.Send()
}

// RevokeDBSecurityGroupIngressWithContext is the same as RevokeDBSecurityGroupIngress with the addition of
// the ability to pass a context and additional request options.
//
// See RevokeDBSecurityGroupIngress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) RevokeDBSecurityGroupIngressWithContext(ctx aws.Context, input *RevokeDBSecurityGroupIngressInput, opts ...request.Option) (*RevokeDBSecurityGroupIngressOutput, error) {
	req, out := c.RevokeDBSecurityGroupIngressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartDBInstance = "StartDBInstance"

// StartDBInstanceRequest generates a "aws/request.Request" representing the
// client's request for the StartDBInstance operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartDBInstance for more information on using the StartDBInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartDBInstanceRequest method.
//    req, resp := client.StartDBInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/StartDBInstance
func (c *RDS) StartDBInstanceRequest(input *StartDBInstanceInput) (req *request.Request, output *StartDBInstanceOutput) {
	op := &request.Operation{
		Name:       opStartDBInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartDBInstanceInput{}
	}

	output = &StartDBInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartDBInstance API operation for Amazon Relational Database Service.
//
// Starts a DB instance that was stopped using the AWS console, the stop-db-instance
// AWS CLI command, or the StopDBInstance action. For more information, see
// Stopping and Starting a DB instance in the AWS RDS user guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation StartDBInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier does not refer to an existing DB instance.
//
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The specified DB instance is not in the available state.
//
//   * ErrCodeInsufficientDBInstanceCapacityFault "InsufficientDBInstanceCapacity"
//   Specified DB instance class is not available in the specified Availability
//   Zone.
//
//   * ErrCodeDBSubnetGroupNotFoundFault "DBSubnetGroupNotFoundFault"
//   DBSubnetGroupName does not refer to an existing DB subnet group.
//
//   * ErrCodeDBSubnetGroupDoesNotCoverEnoughAZs "DBSubnetGroupDoesNotCoverEnoughAZs"
//   Subnets in the DB subnet group should cover at least two Availability Zones
//   unless there is only one Availability Zone.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The DB cluster is not in a valid state.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   The requested subnet is invalid, or multiple subnets were requested that
//   are not all in a common VPC.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   DB subnet group does not cover all Availability Zones after it is created
//   because users' change.
//
//   * ErrCodeDBClusterNotFoundFault "DBClusterNotFoundFault"
//   DBClusterIdentifier does not refer to an existing DB cluster.
//
//   * ErrCodeAuthorizationNotFoundFault "AuthorizationNotFound"
//   Specified CIDRIP or EC2 security group is not authorized for the specified
//   DB security group.
//
//   RDS may not also be authorized via IAM to perform necessary actions on your
//   behalf.
//
//   * ErrCodeKMSKeyNotAccessibleFault "KMSKeyNotAccessibleFault"
//   Error accessing KMS key.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/StartDBInstance
func (c *RDS) StartDBInstance(input *StartDBInstanceInput) (*StartDBInstanceOutput, error) {
	req, out := c.StartDBInstanceRequest(input)
	return out, req.Send()
}

// StartDBInstanceWithContext is the same as StartDBInstance with the addition of
// the ability to pass a context and additional request options.
//
// See StartDBInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) StartDBInstanceWithContext(ctx aws.Context, input *StartDBInstanceInput, opts ...request.Option) (*StartDBInstanceOutput, error) {
	req, out := c.StartDBInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopDBInstance = "StopDBInstance"

// StopDBInstanceRequest generates a "aws/request.Request" representing the
// client's request for the StopDBInstance operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopDBInstance for more information on using the StopDBInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopDBInstanceRequest method.
//    req, resp := client.StopDBInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/StopDBInstance
func (c *RDS) StopDBInstanceRequest(input *StopDBInstanceInput) (req *request.Request, output *StopDBInstanceOutput) {
	op := &request.Operation{
		Name:       opStopDBInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopDBInstanceInput{}
	}

	output = &StopDBInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopDBInstance API operation for Amazon Relational Database Service.
//
// Stops a DB instance. When you stop a DB instance, Amazon RDS retains the
// DB instance's metadata, including its endpoint, DB parameter group, and option
// group membership. Amazon RDS also retains the transaction logs so you can
// do a point-in-time restore if necessary. For more information, see Stopping
// and Starting a DB instance in the AWS RDS user guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Relational Database Service's
// API operation StopDBInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDBInstanceNotFoundFault "DBInstanceNotFound"
//   DBInstanceIdentifier does not refer to an existing DB instance.
//
//   * ErrCodeInvalidDBInstanceStateFault "InvalidDBInstanceState"
//   The specified DB instance is not in the available state.
//
//   * ErrCodeDBSnapshotAlreadyExistsFault "DBSnapshotAlreadyExists"
//   DBSnapshotIdentifier is already used by an existing snapshot.
//
//   * ErrCodeSnapshotQuotaExceededFault "SnapshotQuotaExceeded"
//   Request would result in user exceeding the allowed number of DB snapshots.
//
//   * ErrCodeInvalidDBClusterStateFault "InvalidDBClusterStateFault"
//   The DB cluster is not in a valid state.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/StopDBInstance
func (c *RDS) StopDBInstance(input *StopDBInstanceInput) (*StopDBInstanceOutput, error) {
	req, out := c.StopDBInstanceRequest(input)
	return out, req.Send()
}

// StopDBInstanceWithContext is the same as StopDBInstance with the addition of
// the ability to pass a context and additional request options.
//
// See StopDBInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RDS) StopDBInstanceWithContext(ctx aws.Context, input *StopDBInstanceInput, opts ...request.Option) (*StopDBInstanceOutput, error) {
	req, out := c.StopDBInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Describes a quota for an AWS account, for example, the number of DB instances
// allowed.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AccountQuota
type AccountQuota struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon RDS quota for this AWS account.
	AccountQuotaName *string `type:"string"`

	// The maximum allowed value for the quota.
	Max *int64 `type:"long"`

	// The amount currently used toward the quota maximum.
	Used *int64 `type:"long"`
}

// String returns the string representation
func (s AccountQuota) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountQuota) GoString() string {
	return s.String()
}

// SetAccountQuotaName sets the AccountQuotaName field's value.
func (s *AccountQuota) SetAccountQuotaName(v string) *AccountQuota {
	s.AccountQuotaName = &v
	return s
}

// SetMax sets the Max field's value.
func (s *AccountQuota) SetMax(v int64) *AccountQuota {
	s.Max = &v
	return s
}

// SetUsed sets the Used field's value.
func (s *AccountQuota) SetUsed(v int64) *AccountQuota {
	s.Used = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddRoleToDBClusterMessage
type AddRoleToDBClusterInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB cluster to associate the IAM role with.
	//
	// DBClusterIdentifier is a required field
	DBClusterIdentifier *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role to associate with the Aurora
	// DB cluster, for example arn:aws:iam::123456789012:role/AuroraAccessRole.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AddRoleToDBClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddRoleToDBClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddRoleToDBClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddRoleToDBClusterInput"}
	if s.DBClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterIdentifier"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *AddRoleToDBClusterInput) SetDBClusterIdentifier(v string) *AddRoleToDBClusterInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *AddRoleToDBClusterInput) SetRoleArn(v string) *AddRoleToDBClusterInput {
	s.RoleArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddRoleToDBClusterOutput
type AddRoleToDBClusterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddRoleToDBClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddRoleToDBClusterOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddSourceIdentifierToSubscriptionMessage
type AddSourceIdentifierToSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the event source to be added. An identifier must begin
	// with a letter and must contain only ASCII letters, digits, and hyphens; it
	// cannot end with a hyphen or contain two consecutive hyphens.
	//
	// Constraints:
	//
	//    * If the source type is a DB instance, then a DBInstanceIdentifier must
	//    be supplied.
	//
	//    * If the source type is a DB security group, a DBSecurityGroupName must
	//    be supplied.
	//
	//    * If the source type is a DB parameter group, a DBParameterGroupName must
	//    be supplied.
	//
	//    * If the source type is a DB snapshot, a DBSnapshotIdentifier must be
	//    supplied.
	//
	// SourceIdentifier is a required field
	SourceIdentifier *string `type:"string" required:"true"`

	// The name of the RDS event notification subscription you want to add a source
	// identifier to.
	//
	// SubscriptionName is a required field
	SubscriptionName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AddSourceIdentifierToSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddSourceIdentifierToSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddSourceIdentifierToSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddSourceIdentifierToSubscriptionInput"}
	if s.SourceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceIdentifier"))
	}
	if s.SubscriptionName == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceIdentifier sets the SourceIdentifier field's value.
func (s *AddSourceIdentifierToSubscriptionInput) SetSourceIdentifier(v string) *AddSourceIdentifierToSubscriptionInput {
	s.SourceIdentifier = &v
	return s
}

// SetSubscriptionName sets the SubscriptionName field's value.
func (s *AddSourceIdentifierToSubscriptionInput) SetSubscriptionName(v string) *AddSourceIdentifierToSubscriptionInput {
	s.SubscriptionName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddSourceIdentifierToSubscriptionResult
type AddSourceIdentifierToSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// Contains the results of a successful invocation of the DescribeEventSubscriptions
	// action.
	EventSubscription *EventSubscription `type:"structure"`
}

// String returns the string representation
func (s AddSourceIdentifierToSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddSourceIdentifierToSubscriptionOutput) GoString() string {
	return s.String()
}

// SetEventSubscription sets the EventSubscription field's value.
func (s *AddSourceIdentifierToSubscriptionOutput) SetEventSubscription(v *EventSubscription) *AddSourceIdentifierToSubscriptionOutput {
	s.EventSubscription = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddTagsToResourceMessage
type AddTagsToResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon RDS resource the tags will be added to. This value is an Amazon
	// Resource Name (ARN). For information about creating an ARN, see  Constructing
	// an RDS Amazon Resource Name (ARN) (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing).
	//
	// ResourceName is a required field
	ResourceName *string `type:"string" required:"true"`

	// The tags to be assigned to the Amazon RDS resource.
	//
	// Tags is a required field
	Tags []*Tag `locationNameList:"Tag" type:"list" required:"true"`
}

// String returns the string representation
func (s AddTagsToResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsToResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsToResourceInput"}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceName sets the ResourceName field's value.
func (s *AddTagsToResourceInput) SetResourceName(v string) *AddTagsToResourceInput {
	s.ResourceName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AddTagsToResourceInput) SetTags(v []*Tag) *AddTagsToResourceInput {
	s.Tags = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddTagsToResourceOutput
type AddTagsToResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddTagsToResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToResourceOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ApplyPendingMaintenanceActionMessage
type ApplyPendingMaintenanceActionInput struct {
	_ struct{} `type:"structure"`

	// The pending maintenance action to apply to this resource.
	//
	// Valid values: system-update, db-upgrade
	//
	// ApplyAction is a required field
	ApplyAction *string `type:"string" required:"true"`

	// A value that specifies the type of opt-in request, or undoes an opt-in request.
	// An opt-in request of type immediate cannot be undone.
	//
	// Valid values:
	//
	//    * immediate - Apply the maintenance action immediately.
	//
	//    * next-maintenance - Apply the maintenance action during the next maintenance
	//    window for the resource.
	//
	//    * undo-opt-in - Cancel any existing next-maintenance opt-in requests.
	//
	// OptInType is a required field
	OptInType *string `type:"string" required:"true"`

	// The RDS Amazon Resource Name (ARN) of the resource that the pending maintenance
	// action applies to. For information about creating an ARN, see  Constructing
	// an RDS Amazon Resource Name (ARN) (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing).
	//
	// ResourceIdentifier is a required field
	ResourceIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ApplyPendingMaintenanceActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplyPendingMaintenanceActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplyPendingMaintenanceActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApplyPendingMaintenanceActionInput"}
	if s.ApplyAction == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplyAction"))
	}
	if s.OptInType == nil {
		invalidParams.Add(request.NewErrParamRequired("OptInType"))
	}
	if s.ResourceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplyAction sets the ApplyAction field's value.
func (s *ApplyPendingMaintenanceActionInput) SetApplyAction(v string) *ApplyPendingMaintenanceActionInput {
	s.ApplyAction = &v
	return s
}

// SetOptInType sets the OptInType field's value.
func (s *ApplyPendingMaintenanceActionInput) SetOptInType(v string) *ApplyPendingMaintenanceActionInput {
	s.OptInType = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *ApplyPendingMaintenanceActionInput) SetResourceIdentifier(v string) *ApplyPendingMaintenanceActionInput {
	s.ResourceIdentifier = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ApplyPendingMaintenanceActionResult
type ApplyPendingMaintenanceActionOutput struct {
	_ struct{} `type:"structure"`

	// Describes the pending maintenance actions for a resource.
	ResourcePendingMaintenanceActions *ResourcePendingMaintenanceActions `type:"structure"`
}

// String returns the string representation
func (s ApplyPendingMaintenanceActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplyPendingMaintenanceActionOutput) GoString() string {
	return s.String()
}

// SetResourcePendingMaintenanceActions sets the ResourcePendingMaintenanceActions field's value.
func (s *ApplyPendingMaintenanceActionOutput) SetResourcePendingMaintenanceActions(v *ResourcePendingMaintenanceActions) *ApplyPendingMaintenanceActionOutput {
	s.ResourcePendingMaintenanceActions = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AuthorizeDBSecurityGroupIngressMessage
type AuthorizeDBSecurityGroupIngressInput struct {
	_ struct{} `type:"structure"`

	// The IP range to authorize.
	CIDRIP *string `type:"string"`

	// The name of the DB security group to add authorization to.
	//
	// DBSecurityGroupName is a required field
	DBSecurityGroupName *string `type:"string" required:"true"`

	// Id of the EC2 security group to authorize. For VPC DB security groups, EC2SecurityGroupId
	// must be provided. Otherwise, EC2SecurityGroupOwnerId and either EC2SecurityGroupName
	// or EC2SecurityGroupId must be provided.
	EC2SecurityGroupId *string `type:"string"`

	// Name of the EC2 security group to authorize. For VPC DB security groups,
	// EC2SecurityGroupId must be provided. Otherwise, EC2SecurityGroupOwnerId and
	// either EC2SecurityGroupName or EC2SecurityGroupId must be provided.
	EC2SecurityGroupName *string `type:"string"`

	// AWS account number of the owner of the EC2 security group specified in the
	// EC2SecurityGroupName parameter. The AWS Access Key ID is not an acceptable
	// value. For VPC DB security groups, EC2SecurityGroupId must be provided. Otherwise,
	// EC2SecurityGroupOwnerId and either EC2SecurityGroupName or EC2SecurityGroupId
	// must be provided.
	EC2SecurityGroupOwnerId *string `type:"string"`
}

// String returns the string representation
func (s AuthorizeDBSecurityGroupIngressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizeDBSecurityGroupIngressInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuthorizeDBSecurityGroupIngressInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AuthorizeDBSecurityGroupIngressInput"}
	if s.DBSecurityGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBSecurityGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCIDRIP sets the CIDRIP field's value.
func (s *AuthorizeDBSecurityGroupIngressInput) SetCIDRIP(v string) *AuthorizeDBSecurityGroupIngressInput {
	s.CIDRIP = &v
	return s
}

// SetDBSecurityGroupName sets the DBSecurityGroupName field's value.
func (s *AuthorizeDBSecurityGroupIngressInput) SetDBSecurityGroupName(v string) *AuthorizeDBSecurityGroupIngressInput {
	s.DBSecurityGroupName = &v
	return s
}

// SetEC2SecurityGroupId sets the EC2SecurityGroupId field's value.
func (s *AuthorizeDBSecurityGroupIngressInput) SetEC2SecurityGroupId(v string) *AuthorizeDBSecurityGroupIngressInput {
	s.EC2SecurityGroupId = &v
	return s
}

// SetEC2SecurityGroupName sets the EC2SecurityGroupName field's value.
func (s *AuthorizeDBSecurityGroupIngressInput) SetEC2SecurityGroupName(v string) *AuthorizeDBSecurityGroupIngressInput {
	s.EC2SecurityGroupName = &v
	return s
}

// SetEC2SecurityGroupOwnerId sets the EC2SecurityGroupOwnerId field's value.
func (s *AuthorizeDBSecurityGroupIngressInput) SetEC2SecurityGroupOwnerId(v string) *AuthorizeDBSecurityGroupIngressInput {
	s.EC2SecurityGroupOwnerId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AuthorizeDBSecurityGroupIngressResult
type AuthorizeDBSecurityGroupIngressOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//    * DescribeDBSecurityGroups
	//
	//    * AuthorizeDBSecurityGroupIngress
	//
	//    * CreateDBSecurityGroup
	//
	//    * RevokeDBSecurityGroupIngress
	//
	// This data type is used as a response element in the DescribeDBSecurityGroups
	// action.
	DBSecurityGroup *DBSecurityGroup `type:"structure"`
}

// String returns the string representation
func (s AuthorizeDBSecurityGroupIngressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizeDBSecurityGroupIngressOutput) GoString() string {
	return s.String()
}

// SetDBSecurityGroup sets the DBSecurityGroup field's value.
func (s *AuthorizeDBSecurityGroupIngressOutput) SetDBSecurityGroup(v *DBSecurityGroup) *AuthorizeDBSecurityGroupIngressOutput {
	s.DBSecurityGroup = v
	return s
}

// Contains Availability Zone information.
//
// This data type is used as an element in the following data type:
//
//    * OrderableDBInstanceOption
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AvailabilityZone
type AvailabilityZone struct {
	_ struct{} `type:"structure"`

	// The name of the availability zone.
	Name *string `type:"string"`
}

// String returns the string representation
func (s AvailabilityZone) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AvailabilityZone) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AvailabilityZone) SetName(v string) *AvailabilityZone {
	s.Name = &v
	return s
}

// A CA certificate for an AWS account.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/Certificate
type Certificate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the certificate.
	CertificateArn *string `type:"string"`

	// The unique key that identifies a certificate.
	CertificateIdentifier *string `type:"string"`

	// The type of the certificate.
	CertificateType *string `type:"string"`

	// The thumbprint of the certificate.
	Thumbprint *string `type:"string"`

	// The starting date from which the certificate is valid.
	ValidFrom *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The final date that the certificate continues to be valid.
	ValidTill *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s Certificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Certificate) GoString() string {
	return s.String()
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *Certificate) SetCertificateArn(v string) *Certificate {
	s.CertificateArn = &v
	return s
}

// SetCertificateIdentifier sets the CertificateIdentifier field's value.
func (s *Certificate) SetCertificateIdentifier(v string) *Certificate {
	s.CertificateIdentifier = &v
	return s
}

// SetCertificateType sets the CertificateType field's value.
func (s *Certificate) SetCertificateType(v string) *Certificate {
	s.CertificateType = &v
	return s
}

// SetThumbprint sets the Thumbprint field's value.
func (s *Certificate) SetThumbprint(v string) *Certificate {
	s.Thumbprint = &v
	return s
}

// SetValidFrom sets the ValidFrom field's value.
func (s *Certificate) SetValidFrom(v time.Time) *Certificate {
	s.ValidFrom = &v
	return s
}

// SetValidTill sets the ValidTill field's value.
func (s *Certificate) SetValidTill(v time.Time) *Certificate {
	s.ValidTill = &v
	return s
}

// This data type is used as a response element in the action DescribeDBEngineVersions.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CharacterSet
type CharacterSet struct {
	_ struct{} `type:"structure"`

	// The description of the character set.
	CharacterSetDescription *string `type:"string"`

	// The name of the character set.
	CharacterSetName *string `type:"string"`
}

// String returns the string representation
func (s CharacterSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CharacterSet) GoString() string {
	return s.String()
}

// SetCharacterSetDescription sets the CharacterSetDescription field's value.
func (s *CharacterSet) SetCharacterSetDescription(v string) *CharacterSet {
	s.CharacterSetDescription = &v
	return s
}

// SetCharacterSetName sets the CharacterSetName field's value.
func (s *CharacterSet) SetCharacterSetName(v string) *CharacterSet {
	s.CharacterSetName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBClusterParameterGroupMessage
type CopyDBClusterParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The identifier or Amazon Resource Name (ARN) for the source DB cluster parameter
	// group. For information about creating an ARN, see  Constructing an RDS Amazon
	// Resource Name (ARN) (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing).
	//
	// Constraints:
	//
	//    * Must specify a valid DB cluster parameter group.
	//
	//    * If the source DB cluster parameter group is in the same AWS Region as
	//    the copy, specify a valid DB parameter group identifier, for example my-db-cluster-param-group,
	//    or a valid ARN.
	//
	//    * If the source DB parameter group is in a different AWS Region than the
	//    copy, specify a valid DB cluster parameter group ARN, for example arn:aws:rds:us-east-1:123456789012:cluster-pg:custom-cluster-group1.
	//
	// SourceDBClusterParameterGroupIdentifier is a required field
	SourceDBClusterParameterGroupIdentifier *string `type:"string" required:"true"`

	// A list of tags.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// A description for the copied DB cluster parameter group.
	//
	// TargetDBClusterParameterGroupDescription is a required field
	TargetDBClusterParameterGroupDescription *string `type:"string" required:"true"`

	// The identifier for the copied DB cluster parameter group.
	//
	// Constraints:
	//
	//    * Cannot be null, empty, or blank
	//
	//    * Must contain from 1 to 255 alphanumeric characters or hyphens
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	// Example: my-cluster-param-group1
	//
	// TargetDBClusterParameterGroupIdentifier is a required field
	TargetDBClusterParameterGroupIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CopyDBClusterParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyDBClusterParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyDBClusterParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopyDBClusterParameterGroupInput"}
	if s.SourceDBClusterParameterGroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceDBClusterParameterGroupIdentifier"))
	}
	if s.TargetDBClusterParameterGroupDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetDBClusterParameterGroupDescription"))
	}
	if s.TargetDBClusterParameterGroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetDBClusterParameterGroupIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceDBClusterParameterGroupIdentifier sets the SourceDBClusterParameterGroupIdentifier field's value.
func (s *CopyDBClusterParameterGroupInput) SetSourceDBClusterParameterGroupIdentifier(v string) *CopyDBClusterParameterGroupInput {
	s.SourceDBClusterParameterGroupIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CopyDBClusterParameterGroupInput) SetTags(v []*Tag) *CopyDBClusterParameterGroupInput {
	s.Tags = v
	return s
}

// SetTargetDBClusterParameterGroupDescription sets the TargetDBClusterParameterGroupDescription field's value.
func (s *CopyDBClusterParameterGroupInput) SetTargetDBClusterParameterGroupDescription(v string) *CopyDBClusterParameterGroupInput {
	s.TargetDBClusterParameterGroupDescription = &v
	return s
}

// SetTargetDBClusterParameterGroupIdentifier sets the TargetDBClusterParameterGroupIdentifier field's value.
func (s *CopyDBClusterParameterGroupInput) SetTargetDBClusterParameterGroupIdentifier(v string) *CopyDBClusterParameterGroupInput {
	s.TargetDBClusterParameterGroupIdentifier = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBClusterParameterGroupResult
type CopyDBClusterParameterGroupOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the CreateDBClusterParameterGroup
	// or CopyDBClusterParameterGroup action.
	//
	// This data type is used as a request parameter in the DeleteDBClusterParameterGroup
	// action, and as a response element in the DescribeDBClusterParameterGroups
	// action.
	DBClusterParameterGroup *DBClusterParameterGroup `type:"structure"`
}

// String returns the string representation
func (s CopyDBClusterParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyDBClusterParameterGroupOutput) GoString() string {
	return s.String()
}

// SetDBClusterParameterGroup sets the DBClusterParameterGroup field's value.
func (s *CopyDBClusterParameterGroupOutput) SetDBClusterParameterGroup(v *DBClusterParameterGroup) *CopyDBClusterParameterGroupOutput {
	s.DBClusterParameterGroup = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBClusterSnapshotMessage
type CopyDBClusterSnapshotInput struct {
	_ struct{} `type:"structure"`

	// True to copy all tags from the source DB cluster snapshot to the target DB
	// cluster snapshot; otherwise false. The default is false.
	CopyTags *bool `type:"boolean"`

	// DestinationRegion is used for presigning the request to a given region.
	DestinationRegion *string `type:"string"`

	// The AWS KMS key ID for an encrypted DB cluster snapshot. The KMS key ID is
	// the Amazon Resource Name (ARN), KMS key identifier, or the KMS key alias
	// for the KMS encryption key.
	//
	// If you copy an unencrypted DB cluster snapshot and specify a value for the
	// KmsKeyId parameter, Amazon RDS encrypts the target DB cluster snapshot using
	// the specified KMS encryption key.
	//
	// If you copy an encrypted DB cluster snapshot from your AWS account, you can
	// specify a value for KmsKeyId to encrypt the copy with a new KMS encryption
	// key. If you don't specify a value for KmsKeyId, then the copy of the DB cluster
	// snapshot is encrypted with the same KMS key as the source DB cluster snapshot.
	//
	// If you copy an encrypted DB cluster snapshot that is shared from another
	// AWS account, then you must specify a value for KmsKeyId.
	//
	// To copy an encrypted DB cluster snapshot to another AWS Region, you must
	// set KmsKeyId to the KMS key ID you want to use to encrypt the copy of the
	// DB cluster snapshot in the destination AWS Region. KMS encryption keys are
	// specific to the AWS Region that they are created in, and you cannot use encryption
	// keys from one AWS Region in another AWS Region.
	KmsKeyId *string `type:"string"`

	// The URL that contains a Signature Version 4 signed request for the CopyDBClusterSnapshot
	// API action in the AWS Region that contains the source DB cluster snapshot
	// to copy. The PreSignedUrl parameter must be used when copying an encrypted
	// DB cluster snapshot from another AWS Region.
	//
	// The pre-signed URL must be a valid request for the CopyDBSClusterSnapshot
	// API action that can be executed in the source AWS Region that contains the
	// encrypted DB cluster snapshot to be copied. The pre-signed URL request must
	// contain the following parameter values:
	//
	//    * KmsKeyId - The KMS key identifier for the key to use to encrypt the
	//    copy of the DB cluster snapshot in the destination AWS Region. This is
	//    the same identifier for both the CopyDBClusterSnapshot action that is
	//    called in the destination AWS Region, and the action contained in the
	//    pre-signed URL.
	//
	//    * DestinationRegion - The name of the AWS Region that the DB cluster snapshot
	//    will be created in.
	//
	//    * SourceDBClusterSnapshotIdentifier - The DB cluster snapshot identifier
	//    for the encrypted DB cluster snapshot to be copied. This identifier must
	//    be in the Amazon Resource Name (ARN) format for the source AWS Region.
	//    For example, if you are copying an encrypted DB cluster snapshot from
	//    the us-west-2 region, then your SourceDBClusterSnapshotIdentifier looks
	//    like the following example: arn:aws:rds:us-west-2:123456789012:cluster-snapshot:aurora-cluster1-snapshot-20161115.
	//
	// To learn how to generate a Signature Version 4 signed request, see  Authenticating
	// Requests: Using Query Parameters (AWS Signature Version 4) (http://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html)
	// and  Signature Version 4 Signing Process (http://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
	PreSignedUrl *string `type:"string"`

	// The identifier of the DB cluster snapshot to copy. This parameter is not
	// case-sensitive.
	//
	// You cannot copy an encrypted, shared DB cluster snapshot from one AWS Region
	// to another.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	//    * Must specify a valid system snapshot in the "available" state.
	//
	//    * If the source snapshot is in the same AWS Region as the copy, specify
	//    a valid DB snapshot identifier.
	//
	//    * If the source snapshot is in a different AWS Region than the copy, specify
	//    a valid DB cluster snapshot ARN. For more information, go to  Copying
	//    a DB Snapshot or DB Cluster Snapshot (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopySnapshot.html).
	//
	// Example: my-cluster-snapshot1
	//
	// SourceDBClusterSnapshotIdentifier is a required field
	SourceDBClusterSnapshotIdentifier *string `type:"string" required:"true"`

	// SourceRegion is the source region where the resource exists. This is not
	// sent over the wire and is only used for presigning. This value should always
	// have the same region as the source ARN.
	SourceRegion *string `type:"string" ignore:"true"`

	// A list of tags.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// The identifier of the new DB cluster snapshot to create from the source DB
	// cluster snapshot. This parameter is not case-sensitive.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// Example: my-cluster-snapshot2
	//
	// TargetDBClusterSnapshotIdentifier is a required field
	TargetDBClusterSnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CopyDBClusterSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyDBClusterSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyDBClusterSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopyDBClusterSnapshotInput"}
	if s.SourceDBClusterSnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceDBClusterSnapshotIdentifier"))
	}
	if s.TargetDBClusterSnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetDBClusterSnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCopyTags sets the CopyTags field's value.
func (s *CopyDBClusterSnapshotInput) SetCopyTags(v bool) *CopyDBClusterSnapshotInput {
	s.CopyTags = &v
	return s
}

// SetDestinationRegion sets the DestinationRegion field's value.
func (s *CopyDBClusterSnapshotInput) SetDestinationRegion(v string) *CopyDBClusterSnapshotInput {
	s.DestinationRegion = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CopyDBClusterSnapshotInput) SetKmsKeyId(v string) *CopyDBClusterSnapshotInput {
	s.KmsKeyId = &v
	return s
}

// SetPreSignedUrl sets the PreSignedUrl field's value.
func (s *CopyDBClusterSnapshotInput) SetPreSignedUrl(v string) *CopyDBClusterSnapshotInput {
	s.PreSignedUrl = &v
	return s
}

// SetSourceDBClusterSnapshotIdentifier sets the SourceDBClusterSnapshotIdentifier field's value.
func (s *CopyDBClusterSnapshotInput) SetSourceDBClusterSnapshotIdentifier(v string) *CopyDBClusterSnapshotInput {
	s.SourceDBClusterSnapshotIdentifier = &v
	return s
}

// SetSourceRegion sets the SourceRegion field's value.
func (s *CopyDBClusterSnapshotInput) SetSourceRegion(v string) *CopyDBClusterSnapshotInput {
	s.SourceRegion = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CopyDBClusterSnapshotInput) SetTags(v []*Tag) *CopyDBClusterSnapshotInput {
	s.Tags = v
	return s
}

// SetTargetDBClusterSnapshotIdentifier sets the TargetDBClusterSnapshotIdentifier field's value.
func (s *CopyDBClusterSnapshotInput) SetTargetDBClusterSnapshotIdentifier(v string) *CopyDBClusterSnapshotInput {
	s.TargetDBClusterSnapshotIdentifier = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBClusterSnapshotResult
type CopyDBClusterSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//    * CreateDBClusterSnapshot
	//
	//    * DeleteDBClusterSnapshot
	//
	// This data type is used as a response element in the DescribeDBClusterSnapshots
	// action.
	DBClusterSnapshot *DBClusterSnapshot `type:"structure"`
}

// String returns the string representation
func (s CopyDBClusterSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyDBClusterSnapshotOutput) GoString() string {
	return s.String()
}

// SetDBClusterSnapshot sets the DBClusterSnapshot field's value.
func (s *CopyDBClusterSnapshotOutput) SetDBClusterSnapshot(v *DBClusterSnapshot) *CopyDBClusterSnapshotOutput {
	s.DBClusterSnapshot = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBParameterGroupMessage
type CopyDBParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The identifier or ARN for the source DB parameter group. For information
	// about creating an ARN, see  Constructing an RDS Amazon Resource Name (ARN)
	// (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing).
	//
	// Constraints:
	//
	//    * Must specify a valid DB parameter group.
	//
	//    *  Must specify a valid DB parameter group identifier, for example my-db-param-group,
	//    or a valid ARN.
	//
	// SourceDBParameterGroupIdentifier is a required field
	SourceDBParameterGroupIdentifier *string `type:"string" required:"true"`

	// A list of tags.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// A description for the copied DB parameter group.
	//
	// TargetDBParameterGroupDescription is a required field
	TargetDBParameterGroupDescription *string `type:"string" required:"true"`

	// The identifier for the copied DB parameter group.
	//
	// Constraints:
	//
	//    * Cannot be null, empty, or blank
	//
	//    * Must contain from 1 to 255 alphanumeric characters or hyphens
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	// Example: my-db-parameter-group
	//
	// TargetDBParameterGroupIdentifier is a required field
	TargetDBParameterGroupIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CopyDBParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyDBParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyDBParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopyDBParameterGroupInput"}
	if s.SourceDBParameterGroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceDBParameterGroupIdentifier"))
	}
	if s.TargetDBParameterGroupDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetDBParameterGroupDescription"))
	}
	if s.TargetDBParameterGroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetDBParameterGroupIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceDBParameterGroupIdentifier sets the SourceDBParameterGroupIdentifier field's value.
func (s *CopyDBParameterGroupInput) SetSourceDBParameterGroupIdentifier(v string) *CopyDBParameterGroupInput {
	s.SourceDBParameterGroupIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CopyDBParameterGroupInput) SetTags(v []*Tag) *CopyDBParameterGroupInput {
	s.Tags = v
	return s
}

// SetTargetDBParameterGroupDescription sets the TargetDBParameterGroupDescription field's value.
func (s *CopyDBParameterGroupInput) SetTargetDBParameterGroupDescription(v string) *CopyDBParameterGroupInput {
	s.TargetDBParameterGroupDescription = &v
	return s
}

// SetTargetDBParameterGroupIdentifier sets the TargetDBParameterGroupIdentifier field's value.
func (s *CopyDBParameterGroupInput) SetTargetDBParameterGroupIdentifier(v string) *CopyDBParameterGroupInput {
	s.TargetDBParameterGroupIdentifier = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBParameterGroupResult
type CopyDBParameterGroupOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the CreateDBParameterGroup
	// action.
	//
	// This data type is used as a request parameter in the DeleteDBParameterGroup
	// action, and as a response element in the DescribeDBParameterGroups action.
	DBParameterGroup *DBParameterGroup `type:"structure"`
}

// String returns the string representation
func (s CopyDBParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyDBParameterGroupOutput) GoString() string {
	return s.String()
}

// SetDBParameterGroup sets the DBParameterGroup field's value.
func (s *CopyDBParameterGroupOutput) SetDBParameterGroup(v *DBParameterGroup) *CopyDBParameterGroupOutput {
	s.DBParameterGroup = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBSnapshotMessage
type CopyDBSnapshotInput struct {
	_ struct{} `type:"structure"`

	// True to copy all tags from the source DB snapshot to the target DB snapshot;
	// otherwise false. The default is false.
	CopyTags *bool `type:"boolean"`

	// DestinationRegion is used for presigning the request to a given region.
	DestinationRegion *string `type:"string"`

	// The AWS KMS key ID for an encrypted DB snapshot. The KMS key ID is the Amazon
	// Resource Name (ARN), KMS key identifier, or the KMS key alias for the KMS
	// encryption key.
	//
	// If you copy an encrypted DB snapshot from your AWS account, you can specify
	// a value for this parameter to encrypt the copy with a new KMS encryption
	// key. If you don't specify a value for this parameter, then the copy of the
	// DB snapshot is encrypted with the same KMS key as the source DB snapshot.
	//
	// If you copy an encrypted DB snapshot that is shared from another AWS account,
	// then you must specify a value for this parameter.
	//
	// If you specify this parameter when you copy an unencrypted snapshot, the
	// copy is encrypted.
	//
	// If you copy an encrypted snapshot to a different AWS Region, then you must
	// specify a KMS key for the destination AWS Region. KMS encryption keys are
	// specific to the AWS Region that they are created in, and you cannot use encryption
	// keys from one AWS Region in another AWS Region.
	KmsKeyId *string `type:"string"`

	// The name of an option group to associate with the copy of the snapshot.
	//
	// Specify this option if you are copying a snapshot from one AWS Region to
	// another, and your DB instance uses a nondefault option group. If your source
	// DB instance uses Transparent Data Encryption for Oracle or Microsoft SQL
	// Server, you must specify this option when copying across regions. For more
	// information, see Option Group Considerations (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopySnapshot.html#USER_CopySnapshot.Options).
	OptionGroupName *string `type:"string"`

	// The URL that contains a Signature Version 4 signed request for the CopyDBSnapshot
	// API action in the source AWS Region that contains the source DB snapshot
	// to copy.
	//
	// You must specify this parameter when you copy an encrypted DB snapshot from
	// another AWS Region by using the Amazon RDS API. You can specify the source
	// region option instead of this parameter when you copy an encrypted DB snapshot
	// from another AWS Region by using the AWS CLI.
	//
	// The presigned URL must be a valid request for the CopyDBSnapshot API action
	// that can be executed in the source AWS Region that contains the encrypted
	// DB snapshot to be copied. The presigned URL request must contain the following
	// parameter values:
	//
	//    * DestinationRegion - The AWS Region that the encrypted DB snapshot will
	//    be copied to. This AWS Region is the same one where the CopyDBSnapshot
	//    action is called that contains this presigned URL.
	//
	// For example, if you copy an encrypted DB snapshot from the us-west-2 region
	//    to the us-east-1 region, then you call the CopyDBSnapshot action in the
	//    us-east-1 region and provide a presigned URL that contains a call to the
	//    CopyDBSnapshot action in the us-west-2 region. For this example, the DestinationRegion
	//    in the presigned URL must be set to the us-east-1 region.
	//
	//    * KmsKeyId - The KMS key identifier for the key to use to encrypt the
	//    copy of the DB snapshot in the destination AWS Region. This is the same
	//    identifier for both the CopyDBSnapshot action that is called in the destination
	//    AWS Region, and the action contained in the presigned URL.
	//
	//    * SourceDBSnapshotIdentifier - The DB snapshot identifier for the encrypted
	//    snapshot to be copied. This identifier must be in the Amazon Resource
	//    Name (ARN) format for the source AWS Region. For example, if you are copying
	//    an encrypted DB snapshot from the us-west-2 region, then your SourceDBSnapshotIdentifier
	//    looks like the following example: arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20161115.
	//
	//
	// To learn how to generate a Signature Version 4 signed request, see Authenticating
	// Requests: Using Query Parameters (AWS Signature Version 4) (http://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html)
	// and Signature Version 4 Signing Process (http://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
	PreSignedUrl *string `type:"string"`

	// The identifier for the source DB snapshot.
	//
	// If the source snapshot is in the same AWS Region as the copy, specify a valid
	// DB snapshot identifier. For example, you might specify rds:mysql-instance1-snapshot-20130805.
	//
	// If the source snapshot is in a different AWS Region than the copy, specify
	// a valid DB snapshot ARN. For example, you might specify arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805.
	//
	// If you are copying from a shared manual DB snapshot, this parameter must
	// be the Amazon Resource Name (ARN) of the shared DB snapshot.
	//
	// If you are copying an encrypted snapshot this parameter must be in the ARN
	// format for the source AWS Region, and must match the SourceDBSnapshotIdentifier
	// in the PreSignedUrl parameter.
	//
	// Constraints:
	//
	//    * Must specify a valid system snapshot in the "available" state.
	//
	// Example: rds:mydb-2012-04-02-00-01
	//
	// Example: arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805
	//
	// SourceDBSnapshotIdentifier is a required field
	SourceDBSnapshotIdentifier *string `type:"string" required:"true"`

	// SourceRegion is the source region where the resource exists. This is not
	// sent over the wire and is only used for presigning. This value should always
	// have the same region as the source ARN.
	SourceRegion *string `type:"string" ignore:"true"`

	// A list of tags.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// The identifier for the copy of the snapshot.
	//
	// Constraints:
	//
	//    * Cannot be null, empty, or blank
	//
	//    * Must contain from 1 to 255 alphanumeric characters or hyphens
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	// Example: my-db-snapshot
	//
	// TargetDBSnapshotIdentifier is a required field
	TargetDBSnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CopyDBSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyDBSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyDBSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopyDBSnapshotInput"}
	if s.SourceDBSnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceDBSnapshotIdentifier"))
	}
	if s.TargetDBSnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetDBSnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCopyTags sets the CopyTags field's value.
func (s *CopyDBSnapshotInput) SetCopyTags(v bool) *CopyDBSnapshotInput {
	s.CopyTags = &v
	return s
}

// SetDestinationRegion sets the DestinationRegion field's value.
func (s *CopyDBSnapshotInput) SetDestinationRegion(v string) *CopyDBSnapshotInput {
	s.DestinationRegion = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CopyDBSnapshotInput) SetKmsKeyId(v string) *CopyDBSnapshotInput {
	s.KmsKeyId = &v
	return s
}

// SetOptionGroupName sets the OptionGroupName field's value.
func (s *CopyDBSnapshotInput) SetOptionGroupName(v string) *CopyDBSnapshotInput {
	s.OptionGroupName = &v
	return s
}

// SetPreSignedUrl sets the PreSignedUrl field's value.
func (s *CopyDBSnapshotInput) SetPreSignedUrl(v string) *CopyDBSnapshotInput {
	s.PreSignedUrl = &v
	return s
}

// SetSourceDBSnapshotIdentifier sets the SourceDBSnapshotIdentifier field's value.
func (s *CopyDBSnapshotInput) SetSourceDBSnapshotIdentifier(v string) *CopyDBSnapshotInput {
	s.SourceDBSnapshotIdentifier = &v
	return s
}

// SetSourceRegion sets the SourceRegion field's value.
func (s *CopyDBSnapshotInput) SetSourceRegion(v string) *CopyDBSnapshotInput {
	s.SourceRegion = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CopyDBSnapshotInput) SetTags(v []*Tag) *CopyDBSnapshotInput {
	s.Tags = v
	return s
}

// SetTargetDBSnapshotIdentifier sets the TargetDBSnapshotIdentifier field's value.
func (s *CopyDBSnapshotInput) SetTargetDBSnapshotIdentifier(v string) *CopyDBSnapshotInput {
	s.TargetDBSnapshotIdentifier = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBSnapshotResult
type CopyDBSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//    * CreateDBSnapshot
	//
	//    * DeleteDBSnapshot
	//
	// This data type is used as a response element in the DescribeDBSnapshots action.
	DBSnapshot *DBSnapshot `type:"structure"`
}

// String returns the string representation
func (s CopyDBSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyDBSnapshotOutput) GoString() string {
	return s.String()
}

// SetDBSnapshot sets the DBSnapshot field's value.
func (s *CopyDBSnapshotOutput) SetDBSnapshot(v *DBSnapshot) *CopyDBSnapshotOutput {
	s.DBSnapshot = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyOptionGroupMessage
type CopyOptionGroupInput struct {
	_ struct{} `type:"structure"`

	// The identifier or ARN for the source option group. For information about
	// creating an ARN, see  Constructing an RDS Amazon Resource Name (ARN) (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing).
	//
	// Constraints:
	//
	//    * Must specify a valid option group.
	//
	//    * If the source option group is in the same AWS Region as the copy, specify
	//    a valid option group identifier, for example my-option-group, or a valid
	//    ARN.
	//
	//    * If the source option group is in a different AWS Region than the copy,
	//    specify a valid option group ARN, for example arn:aws:rds:us-west-2:123456789012:og:special-options.
	//
	// SourceOptionGroupIdentifier is a required field
	SourceOptionGroupIdentifier *string `type:"string" required:"true"`

	// A list of tags.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// The description for the copied option group.
	//
	// TargetOptionGroupDescription is a required field
	TargetOptionGroupDescription *string `type:"string" required:"true"`

	// The identifier for the copied option group.
	//
	// Constraints:
	//
	//    * Cannot be null, empty, or blank
	//
	//    * Must contain from 1 to 255 alphanumeric characters or hyphens
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	// Example: my-option-group
	//
	// TargetOptionGroupIdentifier is a required field
	TargetOptionGroupIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CopyOptionGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyOptionGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyOptionGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopyOptionGroupInput"}
	if s.SourceOptionGroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceOptionGroupIdentifier"))
	}
	if s.TargetOptionGroupDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetOptionGroupDescription"))
	}
	if s.TargetOptionGroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetOptionGroupIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceOptionGroupIdentifier sets the SourceOptionGroupIdentifier field's value.
func (s *CopyOptionGroupInput) SetSourceOptionGroupIdentifier(v string) *CopyOptionGroupInput {
	s.SourceOptionGroupIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CopyOptionGroupInput) SetTags(v []*Tag) *CopyOptionGroupInput {
	s.Tags = v
	return s
}

// SetTargetOptionGroupDescription sets the TargetOptionGroupDescription field's value.
func (s *CopyOptionGroupInput) SetTargetOptionGroupDescription(v string) *CopyOptionGroupInput {
	s.TargetOptionGroupDescription = &v
	return s
}

// SetTargetOptionGroupIdentifier sets the TargetOptionGroupIdentifier field's value.
func (s *CopyOptionGroupInput) SetTargetOptionGroupIdentifier(v string) *CopyOptionGroupInput {
	s.TargetOptionGroupIdentifier = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyOptionGroupResult
type CopyOptionGroupOutput struct {
	_ struct{} `type:"structure"`

	OptionGroup *OptionGroup `type:"structure"`
}

// String returns the string representation
func (s CopyOptionGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyOptionGroupOutput) GoString() string {
	return s.String()
}

// SetOptionGroup sets the OptionGroup field's value.
func (s *CopyOptionGroupOutput) SetOptionGroup(v *OptionGroup) *CopyOptionGroupOutput {
	s.OptionGroup = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBClusterMessage
type CreateDBClusterInput struct {
	_ struct{} `type:"structure"`

	// A list of EC2 Availability Zones that instances in the DB cluster can be
	// created in. For information on regions and Availability Zones, see Regions
	// and Availability Zones (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html).
	AvailabilityZones []*string `locationNameList:"AvailabilityZone" type:"list"`

	// The number of days for which automated backups are retained. You must specify
	// a minimum value of 1.
	//
	// Default: 1
	//
	// Constraints:
	//
	//    * Must be a value from 1 to 35
	BackupRetentionPeriod *int64 `type:"integer"`

	// A value that indicates that the DB cluster should be associated with the
	// specified CharacterSet.
	CharacterSetName *string `type:"string"`

	// The DB cluster identifier. This parameter is stored as a lowercase string.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// Example: my-cluster1
	//
	// DBClusterIdentifier is a required field
	DBClusterIdentifier *string `type:"string" required:"true"`

	// The name of the DB cluster parameter group to associate with this DB cluster.
	// If this argument is omitted, default.aurora5.6 will be used.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 alphanumeric characters
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	DBClusterParameterGroupName *string `type:"string"`

	// A DB subnet group to associate with this DB cluster.
	//
	// Constraints: Must contain no more than 255 alphanumeric characters, periods,
	// underscores, spaces, or hyphens. Must not be default.
	//
	// Example: mySubnetgroup
	DBSubnetGroupName *string `type:"string"`

	// The name for your database of up to 64 alpha-numeric characters. If you do
	// not provide a name, Amazon RDS will not create a database in the DB cluster
	// you are creating.
	DatabaseName *string `type:"string"`

	// DestinationRegion is used for presigning the request to a given region.
	DestinationRegion *string `type:"string"`

	// A Boolean value that is true to enable mapping of AWS Identity and Access
	// Management (IAM) accounts to database accounts, and otherwise false.
	//
	// Default: false
	EnableIAMDatabaseAuthentication *bool `type:"boolean"`

	// The name of the database engine to be used for this DB cluster.
	//
	// Valid Values: aurora
	//
	// Engine is a required field
	Engine *string `type:"string" required:"true"`

	// The version number of the database engine to use.
	//
	// Aurora
	//
	// Example: 5.6.10a
	EngineVersion *string `type:"string"`

	// The KMS key identifier for an encrypted DB cluster.
	//
	// The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption
	// key. If you are creating a DB cluster with the same AWS account that owns
	// the KMS encryption key used to encrypt the new DB cluster, then you can use
	// the KMS key alias instead of the ARN for the KMS encryption key.
	//
	// If the StorageEncrypted parameter is true, and you do not specify a value
	// for the KmsKeyId parameter, then Amazon RDS will use your default encryption
	// key. AWS KMS creates the default encryption key for your AWS account. Your
	// AWS account has a different default encryption key for each AWS Region.
	//
	// If you create a Read Replica of an encrypted DB cluster in another AWS Region,
	// you must set KmsKeyId to a KMS key ID that is valid in the destination AWS
	// Region. This key is used to encrypt the Read Replica in that AWS Region.
	KmsKeyId *string `type:"string"`

	// The password for the master database user. This password can contain any
	// printable ASCII character except "/", """, or "@".
	//
	// Constraints: Must contain from 8 to 41 characters.
	MasterUserPassword *string `type:"string"`

	// The name of the master user for the DB cluster.
	//
	// Constraints:
	//
	//    * Must be 1 to 16 alphanumeric characters.
	//
	//    * First character must be a letter.
	//
	//    * Cannot be a reserved word for the chosen database engine.
	MasterUsername *string `type:"string"`

	// A value that indicates that the DB cluster should be associated with the
	// specified option group.
	//
	// Permanent options cannot be removed from an option group. The option group
	// cannot be removed from a DB cluster once it is associated with a DB cluster.
	OptionGroupName *string `type:"string"`

	// The port number on which the instances in the DB cluster accept connections.
	//
	// Default: 3306
	Port *int64 `type:"integer"`

	// A URL that contains a Signature Version 4 signed request for the CreateDBCluster
	// action to be called in the source AWS Region where the DB cluster will be
	// replicated from. You only need to specify PreSignedUrl when you are performing
	// cross-region replication from an encrypted DB cluster.
	//
	// The pre-signed URL must be a valid request for the CreateDBCluster API action
	// that can be executed in the source AWS Region that contains the encrypted
	// DB cluster to be copied.
	//
	// The pre-signed URL request must contain the following parameter values:
	//
	//    * KmsKeyId - The KMS key identifier for the key to use to encrypt the
	//    copy of the DB cluster in the destination AWS Region. This should refer
	//    to the same KMS key for both the CreateDBCluster action that is called
	//    in the destination AWS Region, and the action contained in the pre-signed
	//    URL.
	//
	//    * DestinationRegion - The name of the AWS Region that Aurora Read Replica
	//    will be created in.
	//
	//    * ReplicationSourceIdentifier - The DB cluster identifier for the encrypted
	//    DB cluster to be copied. This identifier must be in the Amazon Resource
	//    Name (ARN) format for the source AWS Region. For example, if you are copying
	//    an encrypted DB cluster from the us-west-2 region, then your ReplicationSourceIdentifier
	//    would look like Example: arn:aws:rds:us-west-2:123456789012:cluster:aurora-cluster1.
	//
	// To learn how to generate a Signature Version 4 signed request, see  Authenticating
	// Requests: Using Query Parameters (AWS Signature Version 4) (http://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html)
	// and  Signature Version 4 Signing Process (http://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
	PreSignedUrl *string `type:"string"`

	// The daily time range during which automated backups are created if automated
	// backups are enabled using the BackupRetentionPeriod parameter.
	//
	// Default: A 30-minute window selected at random from an 8-hour block of time
	// per AWS Region. To see the time blocks available, see  Adjusting the Preferred
	// Maintenance Window (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html)
	// in the Amazon RDS User Guide.
	//
	// Constraints:
	//
	//    * Must be in the format hh24:mi-hh24:mi.
	//
	//    * Times should be in Universal Coordinated Time (UTC).
	//
	//    * Must not conflict with the preferred maintenance window.
	//
	//    * Must be at least 30 minutes.
	PreferredBackupWindow *string `type:"string"`

	// The weekly time range during which system maintenance can occur, in Universal
	// Coordinated Time (UTC).
	//
	// Format: ddd:hh24:mi-ddd:hh24:mi
	//
	// Default: A 30-minute window selected at random from an 8-hour block of time
	// per AWS Region, occurring on a random day of the week. To see the time blocks
	// available, see  Adjusting the Preferred Maintenance Window (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html)
	// in the Amazon RDS User Guide.
	//
	// Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
	//
	// Constraints: Minimum 30-minute window.
	PreferredMaintenanceWindow *string `type:"string"`

	// The Amazon Resource Name (ARN) of the source DB instance or DB cluster if
	// this DB cluster is created as a Read Replica.
	ReplicationSourceIdentifier *string `type:"string"`

	// SourceRegion is the source region where the resource exists. This is not
	// sent over the wire and is only used for presigning. This value should always
	// have the same region as the source ARN.
	SourceRegion *string `type:"string" ignore:"true"`

	// Specifies whether the DB cluster is encrypted.
	StorageEncrypted *bool `type:"boolean"`

	// A list of tags.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// A list of EC2 VPC security groups to associate with this DB cluster.
	VpcSecurityGroupIds []*string `locationNameList:"VpcSecurityGroupId" type:"list"`
}

// String returns the string representation
func (s CreateDBClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDBClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDBClusterInput"}
	if s.DBClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterIdentifier"))
	}
	if s.Engine == nil {
		invalidParams.Add(request.NewErrParamRequired("Engine"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *CreateDBClusterInput) SetAvailabilityZones(v []*string) *CreateDBClusterInput {
	s.AvailabilityZones = v
	return s
}

// SetBackupRetentionPeriod sets the BackupRetentionPeriod field's value.
func (s *CreateDBClusterInput) SetBackupRetentionPeriod(v int64) *CreateDBClusterInput {
	s.BackupRetentionPeriod = &v
	return s
}

// SetCharacterSetName sets the CharacterSetName field's value.
func (s *CreateDBClusterInput) SetCharacterSetName(v string) *CreateDBClusterInput {
	s.CharacterSetName = &v
	return s
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *CreateDBClusterInput) SetDBClusterIdentifier(v string) *CreateDBClusterInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *CreateDBClusterInput) SetDBClusterParameterGroupName(v string) *CreateDBClusterInput {
	s.DBClusterParameterGroupName = &v
	return s
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *CreateDBClusterInput) SetDBSubnetGroupName(v string) *CreateDBClusterInput {
	s.DBSubnetGroupName = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *CreateDBClusterInput) SetDatabaseName(v string) *CreateDBClusterInput {
	s.DatabaseName = &v
	return s
}

// SetDestinationRegion sets the DestinationRegion field's value.
func (s *CreateDBClusterInput) SetDestinationRegion(v string) *CreateDBClusterInput {
	s.DestinationRegion = &v
	return s
}

// SetEnableIAMDatabaseAuthentication sets the EnableIAMDatabaseAuthentication field's value.
func (s *CreateDBClusterInput) SetEnableIAMDatabaseAuthentication(v bool) *CreateDBClusterInput {
	s.EnableIAMDatabaseAuthentication = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *CreateDBClusterInput) SetEngine(v string) *CreateDBClusterInput {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *CreateDBClusterInput) SetEngineVersion(v string) *CreateDBClusterInput {
	s.EngineVersion = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateDBClusterInput) SetKmsKeyId(v string) *CreateDBClusterInput {
	s.KmsKeyId = &v
	return s
}

// SetMasterUserPassword sets the MasterUserPassword field's value.
func (s *CreateDBClusterInput) SetMasterUserPassword(v string) *CreateDBClusterInput {
	s.MasterUserPassword = &v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *CreateDBClusterInput) SetMasterUsername(v string) *CreateDBClusterInput {
	s.MasterUsername = &v
	return s
}

// SetOptionGroupName sets the OptionGroupName field's value.
func (s *CreateDBClusterInput) SetOptionGroupName(v string) *CreateDBClusterInput {
	s.OptionGroupName = &v
	return s
}

// SetPort sets the Port field's value.
func (s *CreateDBClusterInput) SetPort(v int64) *CreateDBClusterInput {
	s.Port = &v
	return s
}

// SetPreSignedUrl sets the PreSignedUrl field's value.
func (s *CreateDBClusterInput) SetPreSignedUrl(v string) *CreateDBClusterInput {
	s.PreSignedUrl = &v
	return s
}

// SetPreferredBackupWindow sets the PreferredBackupWindow field's value.
func (s *CreateDBClusterInput) SetPreferredBackupWindow(v string) *CreateDBClusterInput {
	s.PreferredBackupWindow = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *CreateDBClusterInput) SetPreferredMaintenanceWindow(v string) *CreateDBClusterInput {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetReplicationSourceIdentifier sets the ReplicationSourceIdentifier field's value.
func (s *CreateDBClusterInput) SetReplicationSourceIdentifier(v string) *CreateDBClusterInput {
	s.ReplicationSourceIdentifier = &v
	return s
}

// SetSourceRegion sets the SourceRegion field's value.
func (s *CreateDBClusterInput) SetSourceRegion(v string) *CreateDBClusterInput {
	s.SourceRegion = &v
	return s
}

// SetStorageEncrypted sets the StorageEncrypted field's value.
func (s *CreateDBClusterInput) SetStorageEncrypted(v bool) *CreateDBClusterInput {
	s.StorageEncrypted = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDBClusterInput) SetTags(v []*Tag) *CreateDBClusterInput {
	s.Tags = v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *CreateDBClusterInput) SetVpcSecurityGroupIds(v []*string) *CreateDBClusterInput {
	s.VpcSecurityGroupIds = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBClusterResult
type CreateDBClusterOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//    * CreateDBCluster
	//
	//    * DeleteDBCluster
	//
	//    * FailoverDBCluster
	//
	//    * ModifyDBCluster
	//
	//    * RestoreDBClusterFromSnapshot
	//
	//    * RestoreDBClusterToPointInTime
	//
	// This data type is used as a response element in the DescribeDBClusters action.
	DBCluster *DBCluster `type:"structure"`
}

// String returns the string representation
func (s CreateDBClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBClusterOutput) GoString() string {
	return s.String()
}

// SetDBCluster sets the DBCluster field's value.
func (s *CreateDBClusterOutput) SetDBCluster(v *DBCluster) *CreateDBClusterOutput {
	s.DBCluster = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBClusterParameterGroupMessage
type CreateDBClusterParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB cluster parameter group.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 alphanumeric characters
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	// This value is stored as a lowercase string.
	//
	// DBClusterParameterGroupName is a required field
	DBClusterParameterGroupName *string `type:"string" required:"true"`

	// The DB cluster parameter group family name. A DB cluster parameter group
	// can be associated with one and only one DB cluster parameter group family,
	// and can be applied only to a DB cluster running a database engine and engine
	// version compatible with that DB cluster parameter group family.
	//
	// DBParameterGroupFamily is a required field
	DBParameterGroupFamily *string `type:"string" required:"true"`

	// The description for the DB cluster parameter group.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// A list of tags.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateDBClusterParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBClusterParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDBClusterParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDBClusterParameterGroupInput"}
	if s.DBClusterParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterParameterGroupName"))
	}
	if s.DBParameterGroupFamily == nil {
		invalidParams.Add(request.NewErrParamRequired("DBParameterGroupFamily"))
	}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *CreateDBClusterParameterGroupInput) SetDBClusterParameterGroupName(v string) *CreateDBClusterParameterGroupInput {
	s.DBClusterParameterGroupName = &v
	return s
}

// SetDBParameterGroupFamily sets the DBParameterGroupFamily field's value.
func (s *CreateDBClusterParameterGroupInput) SetDBParameterGroupFamily(v string) *CreateDBClusterParameterGroupInput {
	s.DBParameterGroupFamily = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateDBClusterParameterGroupInput) SetDescription(v string) *CreateDBClusterParameterGroupInput {
	s.Description = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDBClusterParameterGroupInput) SetTags(v []*Tag) *CreateDBClusterParameterGroupInput {
	s.Tags = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBClusterParameterGroupResult
type CreateDBClusterParameterGroupOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the CreateDBClusterParameterGroup
	// or CopyDBClusterParameterGroup action.
	//
	// This data type is used as a request parameter in the DeleteDBClusterParameterGroup
	// action, and as a response element in the DescribeDBClusterParameterGroups
	// action.
	DBClusterParameterGroup *DBClusterParameterGroup `type:"structure"`
}

// String returns the string representation
func (s CreateDBClusterParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBClusterParameterGroupOutput) GoString() string {
	return s.String()
}

// SetDBClusterParameterGroup sets the DBClusterParameterGroup field's value.
func (s *CreateDBClusterParameterGroupOutput) SetDBClusterParameterGroup(v *DBClusterParameterGroup) *CreateDBClusterParameterGroupOutput {
	s.DBClusterParameterGroup = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBClusterSnapshotMessage
type CreateDBClusterSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the DB cluster to create a snapshot for. This parameter
	// is not case-sensitive.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// Example: my-cluster1
	//
	// DBClusterIdentifier is a required field
	DBClusterIdentifier *string `type:"string" required:"true"`

	// The identifier of the DB cluster snapshot. This parameter is stored as a
	// lowercase string.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// Example: my-cluster1-snapshot1
	//
	// DBClusterSnapshotIdentifier is a required field
	DBClusterSnapshotIdentifier *string `type:"string" required:"true"`

	// The tags to be assigned to the DB cluster snapshot.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateDBClusterSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBClusterSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDBClusterSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDBClusterSnapshotInput"}
	if s.DBClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterIdentifier"))
	}
	if s.DBClusterSnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterSnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *CreateDBClusterSnapshotInput) SetDBClusterIdentifier(v string) *CreateDBClusterSnapshotInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBClusterSnapshotIdentifier sets the DBClusterSnapshotIdentifier field's value.
func (s *CreateDBClusterSnapshotInput) SetDBClusterSnapshotIdentifier(v string) *CreateDBClusterSnapshotInput {
	s.DBClusterSnapshotIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDBClusterSnapshotInput) SetTags(v []*Tag) *CreateDBClusterSnapshotInput {
	s.Tags = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBClusterSnapshotResult
type CreateDBClusterSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//    * CreateDBClusterSnapshot
	//
	//    * DeleteDBClusterSnapshot
	//
	// This data type is used as a response element in the DescribeDBClusterSnapshots
	// action.
	DBClusterSnapshot *DBClusterSnapshot `type:"structure"`
}

// String returns the string representation
func (s CreateDBClusterSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBClusterSnapshotOutput) GoString() string {
	return s.String()
}

// SetDBClusterSnapshot sets the DBClusterSnapshot field's value.
func (s *CreateDBClusterSnapshotOutput) SetDBClusterSnapshot(v *DBClusterSnapshot) *CreateDBClusterSnapshotOutput {
	s.DBClusterSnapshot = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBInstanceMessage
type CreateDBInstanceInput struct {
	_ struct{} `type:"structure"`

	// The amount of storage (in gigabytes) to be initially allocated for the database
	// instance.
	//
	// Type: Integer
	//
	// Amazon Aurora
	//
	// Not applicable. Aurora cluster volumes automatically grow as the amount of
	// data in your database increases, though you are only charged for the space
	// that you use in an Aurora cluster volume.
	//
	// MySQL
	//
	// Constraints to the amount of storage for each storage type are the following:
	//
	//    * General Purpose (SSD) storage (gp2): Must be an integer from 5 to 6144.
	//
	//    * Provisioned IOPS storage (io1): Must be an integer from 100 to 6144.
	//
	//    * Magnetic storage (standard): Must be an integer from 5 to 3072.
	//
	// MariaDB
	//
	// Constraints to the amount of storage for each storage type are the following:
	//
	//    * General Purpose (SSD) storage (gp2): Must be an integer from 5 to 6144.
	//
	//    * Provisioned IOPS storage (io1): Must be an integer from 100 to 6144.
	//
	//    * Magnetic storage (standard): Must be an integer from 5 to 3072.
	//
	// PostgreSQL
	//
	// Constraints to the amount of storage for each storage type are the following:
	//
	//    * General Purpose (SSD) storage (gp2): Must be an integer from 5 to 6144.
	//
	//    * Provisioned IOPS storage (io1): Must be an integer from 100 to 6144.
	//
	//    * Magnetic storage (standard): Must be an integer from 5 to 3072.
	//
	// Oracle
	//
	// Constraints to the amount of storage for each storage type are the following:
	//
	//    * General Purpose (SSD) storage (gp2): Must be an integer from 10 to 6144.
	//
	//    * Provisioned IOPS storage (io1): Must be an integer from 100 to 6144.
	//
	//    * Magnetic storage (standard): Must be an integer from 10 to 3072.
	//
	// SQL Server
	//
	// Constraints to the amount of storage for each storage type are the following:
	//
	//    * General Purpose (SSD) storage (gp2):
	//
	// Enterprise and Standard editions: Must be an integer from 200 to 16384.
	//
	// Web and Express editions: Must be an integer from 20 to 16384.
	//
	//    * Provisioned IOPS storage (io1):
	//
	// Enterprise and Standard editions: Must be an integer from 200 to 16384.
	//
	// Web and Express editions: Must be an integer from 100 to 16384.
	//
	//    * Magnetic storage (standard):
	//
	// Enterprise and Standard editions: Must be an integer from 200 to 1024.
	//
	// Web and Express editions: Must be an integer from 20 to 1024.
	AllocatedStorage *int64 `type:"integer"`

	// Indicates that minor engine upgrades will be applied automatically to the
	// DB instance during the maintenance window.
	//
	// Default: true
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// The EC2 Availability Zone that the database instance will be created in.
	// For information on regions and Availability Zones, see Regions and Availability
	// Zones (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html).
	//
	// Default: A random, system-chosen Availability Zone in the endpoint's AWS
	// Region.
	//
	// Example: us-east-1d
	//
	// Constraint: The AvailabilityZone parameter cannot be specified if the MultiAZ
	// parameter is set to true. The specified Availability Zone must be in the
	// same AWS Region as the current endpoint.
	AvailabilityZone *string `type:"string"`

	// The number of days for which automated backups are retained. Setting this
	// parameter to a positive number enables backups. Setting this parameter to
	// 0 disables automated backups.
	//
	// Amazon Aurora
	//
	// Not applicable. The retention period for automated backups is managed by
	// the DB cluster. For more information, see CreateDBCluster.
	//
	// Default: 1
	//
	// Constraints:
	//
	//    * Must be a value from 0 to 35
	//
	//    * Cannot be set to 0 if the DB instance is a source to Read Replicas
	BackupRetentionPeriod *int64 `type:"integer"`

	// For supported engines, indicates that the DB instance should be associated
	// with the specified CharacterSet.
	//
	// Amazon Aurora
	//
	// Not applicable. The character set is managed by the DB cluster. For more
	// information, see CreateDBCluster.
	CharacterSetName *string `type:"string"`

	// True to copy all tags from the DB instance to snapshots of the DB instance;
	// otherwise false. The default is false.
	CopyTagsToSnapshot *bool `type:"boolean"`

	// The identifier of the DB cluster that the instance will belong to.
	//
	// For information on creating a DB cluster, see CreateDBCluster.
	//
	// Type: String
	DBClusterIdentifier *string `type:"string"`

	// The compute and memory capacity of the DB instance. Note that not all instance
	// classes are available in all regions for all DB engines.
	//
	// Valid Values: db.t1.micro | db.m1.small | db.m1.medium | db.m1.large | db.m1.xlarge
	// | db.m2.xlarge |db.m2.2xlarge | db.m2.4xlarge | db.m3.medium | db.m3.large
	// | db.m3.xlarge | db.m3.2xlarge | db.m4.large | db.m4.xlarge | db.m4.2xlarge
	// | db.m4.4xlarge | db.m4.10xlarge | db.r3.large | db.r3.xlarge | db.r3.2xlarge
	// | db.r3.4xlarge | db.r3.8xlarge | db.t2.micro | db.t2.small | db.t2.medium
	// | db.t2.large
	//
	// DBInstanceClass is a required field
	DBInstanceClass *string `type:"string" required:"true"`

	// The DB instance identifier. This parameter is stored as a lowercase string.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// Example: mydbinstance
	//
	// DBInstanceIdentifier is a required field
	DBInstanceIdentifier *string `type:"string" required:"true"`

	// The meaning of this parameter differs according to the database engine you
	// use.
	//
	// Type: String
	//
	// MySQL
	//
	// The name of the database to create when the DB instance is created. If this
	// parameter is not specified, no database is created in the DB instance.
	//
	// Constraints:
	//
	//    * Must contain 1 to 64 alphanumeric characters
	//
	//    * Cannot be a word reserved by the specified database engine
	//
	// MariaDB
	//
	// The name of the database to create when the DB instance is created. If this
	// parameter is not specified, no database is created in the DB instance.
	//
	// Constraints:
	//
	//    * Must contain 1 to 64 alphanumeric characters
	//
	//    * Cannot be a word reserved by the specified database engine
	//
	// PostgreSQL
	//
	// The name of the database to create when the DB instance is created. If this
	// parameter is not specified, the default "postgres" database is created in
	// the DB instance.
	//
	// Constraints:
	//
	//    * Must contain 1 to 63 alphanumeric characters
	//
	//    * Must begin with a letter or an underscore. Subsequent characters can
	//    be letters, underscores, or digits (0-9).
	//
	//    * Cannot be a word reserved by the specified database engine
	//
	// Oracle
	//
	// The Oracle System ID (SID) of the created DB instance. If you specify null,
	// the default value ORCL is used. You can't specify the string NULL, or any
	// other reserved word, for DBName.
	//
	// Default: ORCL
	//
	// Constraints:
	//
	//    * Cannot be longer than 8 characters
	//
	// SQL Server
	//
	// Not applicable. Must be null.
	//
	// Amazon Aurora
	//
	// The name of the database to create when the primary instance of the DB cluster
	// is created. If this parameter is not specified, no database is created in
	// the DB instance.
	//
	// Constraints:
	//
	//    * Must contain 1 to 64 alphanumeric characters
	//
	//    * Cannot be a word reserved by the specified database engine
	DBName *string `type:"string"`

	// The name of the DB parameter group to associate with this DB instance. If
	// this argument is omitted, the default DBParameterGroup for the specified
	// engine will be used.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 alphanumeric characters
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	DBParameterGroupName *string `type:"string"`

	// A list of DB security groups to associate with this DB instance.
	//
	// Default: The default DB security group for the database engine.
	DBSecurityGroups []*string `locationNameList:"DBSecurityGroupName" type:"list"`

	// A DB subnet group to associate with this DB instance.
	//
	// If there is no DB subnet group, then it is a non-VPC DB instance.
	DBSubnetGroupName *string `type:"string"`

	// Specify the Active Directory Domain to create the instance in.
	Domain *string `type:"string"`

	// Specify the name of the IAM role to be used when making API calls to the
	// Directory Service.
	DomainIAMRoleName *string `type:"string"`

	// True to enable mapping of AWS Identity and Access Management (IAM) accounts
	// to database accounts; otherwise false.
	//
	// You can enable IAM database authentication for the following database engines:
	//
	// Amazon Aurora
	//
	// Not applicable. Mapping AWS IAM accounts to database accounts is managed
	// by the DB cluster. For more information, see CreateDBCluster.
	//
	// MySQL
	//
	//    * For MySQL 5.6, minor version 5.6.34 or higher
	//
	//    * For MySQL 5.7, minor version 5.7.16 or higher
	//
	// Default: false
	EnableIAMDatabaseAuthentication *bool `type:"boolean"`

	// The name of the database engine to be used for this instance.
	//
	// Not every database engine is available for every AWS Region.
	//
	// Valid Values:
	//
	//    * aurora
	//
	//    * mariadb
	//
	//    * mysql
	//
	//    * oracle-ee
	//
	//    * oracle-se2
	//
	//    * oracle-se1
	//
	//    * oracle-se
	//
	//    * postgres
	//
	//    * sqlserver-ee
	//
	//    * sqlserver-se
	//
	//    * sqlserver-ex
	//
	//    * sqlserver-web
	//
	// Engine is a required field
	Engine *string `type:"string" required:"true"`

	// The version number of the database engine to use.
	//
	// The following are the database engines and major and minor versions that
	// are available with Amazon RDS. Not every database engine is available for
	// every AWS Region.
	//
	// Amazon Aurora
	//
	// Not applicable. The version number of the database engine to be used by the
	// DB instance is managed by the DB cluster. For more information, see CreateDBCluster.
	//
	// MariaDB
	//
	//    * 10.1.23 (supported in all AWS regions)
	//
	//    * 10.1.19 (supported in all AWS regions)
	//
	//    * 10.1.14 (supported in all regions except us-east-2)
	//
	// 10.0.31 (supported in all AWS regions)
	//
	//    * 10.0.28 (supported in all AWS regions)
	//
	//    * 10.0.24 (supported in all AWS regions)
	//
	//    * 10.0.17 (supported in all regions except us-east-2, ca-central-1, eu-west-2)
	//
	// Microsoft SQL Server 2016
	//
	// 13.00.4422.0.v1 (supported for all editions, and all AWS regions)
	//
	//    * 13.00.2164.0.v1 (supported for all editions, and all AWS regions)
	//
	// Microsoft SQL Server 2014
	//
	// 12.00.5546.0.v1 (supported for all editions, and all AWS regions)
	//
	//    * 12.00.5000.0.v1 (supported for all editions, and all AWS regions)
	//
	//    * 12.00.4422.0.v1 (supported for all editions except Enterprise Edition,
	//    and all AWS regions except ca-central-1 and eu-west-2)
	//
	// Microsoft SQL Server 2012
	//
	// 11.00.6594.0.v1 (supported for all editions, and all AWS regions)
	//
	//    * 11.00.6020.0.v1 (supported for all editions, and all AWS regions)
	//
	//    * 11.00.5058.0.v1 (supported for all editions, and all AWS regions except
	//    us-east-2, ca-central-1, and eu-west-2)
	//
	//    * 11.00.2100.60.v1 (supported for all editions, and all AWS regions except
	//    us-east-2, ca-central-1, and eu-west-2)
	//
	// Microsoft SQL Server 2008 R2
	//
	// 10.50.6529.0.v1 (supported for all editions, and all AWS regions except us-east-2,
	// ca-central-1, and eu-west-2)
	//
	//    * 10.50.6000.34.v1 (supported for all editions, and all AWS regions except
	//    us-east-2, ca-central-1, and eu-west-2)
	//
	//    * 10.50.2789.0.v1 (supported for all editions, and all AWS regions except
	//    us-east-2, ca-central-1, and eu-west-2)
	//
	// MySQL
	//
	// 5.7.17 (supported in all AWS regions)
	//
	//    * 5.7.16 (supported in all AWS regions)
	//
	//    * 5.7.11 (supported in all AWS regions)
	//
	//    * 5.6.35 (supported in all AWS regions)
	//
	//    * 5.6.34 (supported in all AWS regions)
	//
	//    * 5.6.29 (supported in all AWS regions)
	//
	//    * 5.6.27 (supported in all regions except us-east-2, ca-central-1, eu-west-2)
	//
	// 5.5.54(supported in all AWS regions)
	//
	// 5.5.53(supported in all AWS regions)
	//
	// 5.5.46(supported in all AWS regions)
	//
	// Oracle 12c
	//
	// 12.1.0.2.v8(supported for EE in all AWS regions, and SE2 in all AWS regions except us-gov-west-1)
	//
	// 12.1.0.2.v7(supported for EE in all AWS regions, and SE2 in all AWS regions except us-gov-west-1)
	//
	// 12.1.0.2.v6(supported for EE in all AWS regions, and SE2 in all AWS regions except us-gov-west-1)
	//
	// 12.1.0.2.v5(supported for EE in all AWS regions, and SE2 in all AWS regions except us-gov-west-1)
	//
	// 12.1.0.2.v4(supported for EE in all AWS regions, and SE2 in all AWS regions except us-gov-west-1)
	//
	// 12.1.0.2.v3(supported for EE in all AWS regions, and SE2 in all AWS regions except us-gov-west-1)
	//
	// 12.1.0.2.v2(supported for EE in all AWS regions, and SE2 in all AWS regions except us-gov-west-1)
	//
	// 12.1.0.2.v1(supported for EE in all AWS regions, and SE2 in all AWS regions except us-gov-west-1)
	//
	// Oracle 11g
	//
	// 11.2.0.4.v12(supported for EE, SE1, and SE, in all AWS regions)
	//
	// 11.2.0.4.v11(supported for EE, SE1, and SE, in all AWS regions)
	//
	// 11.2.0.4.v10(supported for EE, SE1, and SE, in all AWS regions)
	//
	// 11.2.0.4.v9(supported for EE, SE1, and SE, in all AWS regions)
	//
	// 11.2.0.4.v8(supported for EE, SE1, and SE, in all AWS regions)
	//
	// 11.2.0.4.v7(supported for EE, SE1, and SE, in all AWS regions)
	//
	// 11.2.0.4.v6(supported for EE, SE1, and SE, in all AWS regions)
	//
	// 11.2.0.4.v5(supported for EE, SE1, and SE, in all AWS regions)
	//
	// 11.2.0.4.v4(supported for EE, SE1, and SE, in all AWS regions)
	//
	// 11.2.0.4.v3(supported for EE, SE1, and SE, in all AWS regions)
	//
	// 11.2.0.4.v1(supported for EE, SE1, and SE, in all AWS regions)
	//
	// PostgreSQL
	//
	// Version 9.6.x: 9.6.1 | 9.6.2
	//
	// Version 9.5.x:9.5.6 | 9.5.4 | 9.5.2
	//
	// Version 9.4.x:9.4.11 | 9.4.9 | 9.4.7
	//
	// Version 9.3.x:9.3.16 | 9.3.14 | 9.3.12
	EngineVersion *string `type:"string"`

	// The amount of Provisioned IOPS (input/output operations per second) to be
	// initially allocated for the DB instance.
	//
	// Constraints: Must be a multiple between 3 and 10 of the storage amount for
	// the DB instance. Must also be an integer multiple of 1000. For example, if
	// the size of your DB instance is 500 GB, then your Iops value can be 2000,
	// 3000, 4000, or 5000.
	Iops *int64 `type:"integer"`

	// The KMS key identifier for an encrypted DB instance.
	//
	// The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption
	// key. If you are creating a DB instance with the same AWS account that owns
	// the KMS encryption key used to encrypt the new DB instance, then you can
	// use the KMS key alias instead of the ARN for the KM encryption key.
	//
	// Amazon Aurora
	//
	// Not applicable. The KMS key identifier is managed by the DB cluster. For
	// more information, see CreateDBCluster.
	//
	// If the StorageEncrypted parameter is true, and you do not specify a value
	// for the KmsKeyId parameter, then Amazon RDS will use your default encryption
	// key. AWS KMS creates the default encryption key for your AWS account. Your
	// AWS account has a different default encryption key for each AWS Region.
	KmsKeyId *string `type:"string"`

	// License model information for this DB instance.
	//
	// Valid values: license-included | bring-your-own-license | general-public-license
	LicenseModel *string `type:"string"`

	// The password for the master user. Can be any printable ASCII character except
	// "/", """, or "@".
	//
	// Amazon Aurora
	//
	// Not applicable. The password for the master user is managed by the DB cluster.
	// For more information, see CreateDBCluster.
	//
	// MariaDB
	//
	// Constraints: Must contain from 8 to 41 characters.
	//
	// Microsoft SQL Server
	//
	// Constraints: Must contain from 8 to 128 characters.
	//
	// MySQL
	//
	// Constraints: Must contain from 8 to 41 characters.
	//
	// Oracle
	//
	// Constraints: Must contain from 8 to 30 characters.
	//
	// PostgreSQL
	//
	// Constraints: Must contain from 8 to 128 characters.
	MasterUserPassword *string `type:"string"`

	// The name for the master user.
	//
	// Amazon Aurora
	//
	// Not applicable. The name for the master user is managed by the DB cluster.
	// For more information, see CreateDBCluster.
	//
	// MariaDB
	//
	// Constraints:
	//
	//    * Must be 1 to 16 alphanumeric characters.
	//
	//    * Cannot be a reserved word for the chosen database engine.
	//
	// Microsoft SQL Server
	//
	// Constraints:
	//
	//    * Must be 1 to 128 alphanumeric characters.
	//
	//    * First character must be a letter.
	//
	//    * Cannot be a reserved word for the chosen database engine.
	//
	// MySQL
	//
	// Constraints:
	//
	//    * Must be 1 to 16 alphanumeric characters.
	//
	//    * First character must be a letter.
	//
	//    * Cannot be a reserved word for the chosen database engine.
	//
	// Oracle
	//
	// Constraints:
	//
	//    * Must be 1 to 30 alphanumeric characters.
	//
	//    * First character must be a letter.
	//
	//    * Cannot be a reserved word for the chosen database engine.
	//
	// PostgreSQL
	//
	// Constraints:
	//
	//    * Must be 1 to 63 alphanumeric characters.
	//
	//    * First character must be a letter.
	//
	//    * Cannot be a reserved word for the chosen database engine.
	MasterUsername *string `type:"string"`

	// The interval, in seconds, between points when Enhanced Monitoring metrics
	// are collected for the DB instance. To disable collecting Enhanced Monitoring
	// metrics, specify 0. The default is 0.
	//
	// If MonitoringRoleArn is specified, then you must also set MonitoringInterval
	// to a value other than 0.
	//
	// Valid Values: 0, 1, 5, 10, 15, 30, 60
	MonitoringInterval *int64 `type:"integer"`

	// The ARN for the IAM role that permits RDS to send enhanced monitoring metrics
	// to CloudWatch Logs. For example, arn:aws:iam:123456789012:role/emaccess.
	// For information on creating a monitoring role, go to Setting Up and Enabling
	// Enhanced Monitoring (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling).
	//
	// If MonitoringInterval is set to a value other than 0, then you must supply
	// a MonitoringRoleArn value.
	MonitoringRoleArn *string `type:"string"`

	// Specifies if the DB instance is a Multi-AZ deployment. You cannot set the
	// AvailabilityZone parameter if the MultiAZ parameter is set to true.
	MultiAZ *bool `type:"boolean"`

	// Indicates that the DB instance should be associated with the specified option
	// group.
	//
	// Permanent options, such as the TDE option for Oracle Advanced Security TDE,
	// cannot be removed from an option group, and that option group cannot be removed
	// from a DB instance once it is associated with a DB instance
	OptionGroupName *string `type:"string"`

	// The port number on which the database accepts connections.
	//
	// MySQL
	//
	// Default: 3306
	//
	// Valid Values: 1150-65535
	//
	// Type: Integer
	//
	// MariaDB
	//
	// Default: 3306
	//
	// Valid Values: 1150-65535
	//
	// Type: Integer
	//
	// PostgreSQL
	//
	// Default: 5432
	//
	// Valid Values: 1150-65535
	//
	// Type: Integer
	//
	// Oracle
	//
	// Default: 1521
	//
	// Valid Values: 1150-65535
	//
	// SQL Server
	//
	// Default: 1433
	//
	// Valid Values: 1150-65535 except for 1434, 3389, 47001, 49152, and 49152 through
	// 49156.
	//
	// Amazon Aurora
	//
	// Default: 3306
	//
	// Valid Values: 1150-65535
	//
	// Type: Integer
	Port *int64 `type:"integer"`

	// The daily time range during which automated backups are created if automated
	// backups are enabled, using the BackupRetentionPeriod parameter. For more
	// information, see DB Instance Backups (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.BackingUpAndRestoringAmazonRDSInstances.html).
	//
	// Amazon Aurora
	//
	// Not applicable. The daily time range for creating automated backups is managed
	// by the DB cluster. For more information, see CreateDBCluster.
	//
	// Default: A 30-minute window selected at random from an 8-hour block of time
	// per AWS Region. To see the time blocks available, see  Adjusting the Preferred
	// DB Instance Maintenance Window (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow).
	//
	// Constraints:
	//
	//    * Must be in the format hh24:mi-hh24:mi.
	//
	//    * Times should be in Universal Coordinated Time (UTC).
	//
	//    * Must not conflict with the preferred maintenance window.
	//
	//    * Must be at least 30 minutes.
	PreferredBackupWindow *string `type:"string"`

	// The weekly time range during which system maintenance can occur, in Universal
	// Coordinated Time (UTC). For more information, see DB Instance Maintenance
	// (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBMaintenance.html).
	//
	// Format: ddd:hh24:mi-ddd:hh24:mi
	//
	// Default: A 30-minute window selected at random from an 8-hour block of time
	// per AWS Region, occurring on a random day of the week. To see the time blocks
	// available, see  Adjusting the Preferred Maintenance Window (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html)
	// in the Amazon RDS User Guide.
	//
	// Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
	//
	// Constraints: Minimum 30-minute window.
	PreferredMaintenanceWindow *string `type:"string"`

	// A value that specifies the order in which an Aurora Replica is promoted to
	// the primary instance after a failure of the existing primary instance. For
	// more information, see  Fault Tolerance for an Aurora DB Cluster (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Aurora.Managing.html#Aurora.Managing.FaultTolerance).
	//
	// Default: 1
	//
	// Valid Values: 0 - 15
	PromotionTier *int64 `type:"integer"`

	// Specifies the accessibility options for the DB instance. A value of true
	// specifies an Internet-facing instance with a publicly resolvable DNS name,
	// which resolves to a public IP address. A value of false specifies an internal
	// instance with a DNS name that resolves to a private IP address.
	//
	// Default: The default behavior varies depending on whether a VPC has been
	// requested or not. The following list shows the default behavior in each case.
	//
	//    * Default VPC: true
	//
	//    * VPC: false
	//
	// If no DB subnet group has been specified as part of the request and the PubliclyAccessible
	// value has not been set, the DB instance will be publicly accessible. If a
	// specific DB subnet group has been specified as part of the request and the
	// PubliclyAccessible value has not been set, the DB instance will be private.
	PubliclyAccessible *bool `type:"boolean"`

	// Specifies whether the DB instance is encrypted.
	//
	// Amazon Aurora
	//
	// Not applicable. The encryption for DB instances is managed by the DB cluster.
	// For more information, see CreateDBCluster.
	//
	// Default: false
	StorageEncrypted *bool `type:"boolean"`

	// Specifies the storage type to be associated with the DB instance.
	//
	// Valid values: standard | gp2 | io1
	//
	// If you specify io1, you must also include a value for the Iops parameter.
	//
	// Default: io1 if the Iops parameter is specified; otherwise standard
	StorageType *string `type:"string"`

	// A list of tags.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// The ARN from the Key Store with which to associate the instance for TDE encryption.
	TdeCredentialArn *string `type:"string"`

	// The password for the given ARN from the Key Store in order to access the
	// device.
	TdeCredentialPassword *string `type:"string"`

	// The time zone of the DB instance. The time zone parameter is currently supported
	// only by Microsoft SQL Server (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.TimeZone).
	Timezone *string `type:"string"`

	// A list of EC2 VPC security groups to associate with this DB instance.
	//
	// Amazon Aurora
	//
	// Not applicable. The associated list of EC2 VPC security groups is managed
	// by the DB cluster. For more information, see CreateDBCluster.
	//
	// Default: The default EC2 VPC security group for the DB subnet group's VPC.
	VpcSecurityGroupIds []*string `locationNameList:"VpcSecurityGroupId" type:"list"`
}

// String returns the string representation
func (s CreateDBInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDBInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDBInstanceInput"}
	if s.DBInstanceClass == nil {
		invalidParams.Add(request.NewErrParamRequired("DBInstanceClass"))
	}
	if s.DBInstanceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBInstanceIdentifier"))
	}
	if s.Engine == nil {
		invalidParams.Add(request.NewErrParamRequired("Engine"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *CreateDBInstanceInput) SetAllocatedStorage(v int64) *CreateDBInstanceInput {
	s.AllocatedStorage = &v
	return s
}

// SetAutoMinorVersionUpgrade sets the AutoMinorVersionUpgrade field's value.
func (s *CreateDBInstanceInput) SetAutoMinorVersionUpgrade(v bool) *CreateDBInstanceInput {
	s.AutoMinorVersionUpgrade = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *CreateDBInstanceInput) SetAvailabilityZone(v string) *CreateDBInstanceInput {
	s.AvailabilityZone = &v
	return s
}

// SetBackupRetentionPeriod sets the BackupRetentionPeriod field's value.
func (s *CreateDBInstanceInput) SetBackupRetentionPeriod(v int64) *CreateDBInstanceInput {
	s.BackupRetentionPeriod = &v
	return s
}

// SetCharacterSetName sets the CharacterSetName field's value.
func (s *CreateDBInstanceInput) SetCharacterSetName(v string) *CreateDBInstanceInput {
	s.CharacterSetName = &v
	return s
}

// SetCopyTagsToSnapshot sets the CopyTagsToSnapshot field's value.
func (s *CreateDBInstanceInput) SetCopyTagsToSnapshot(v bool) *CreateDBInstanceInput {
	s.CopyTagsToSnapshot = &v
	return s
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *CreateDBInstanceInput) SetDBClusterIdentifier(v string) *CreateDBInstanceInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBInstanceClass sets the DBInstanceClass field's value.
func (s *CreateDBInstanceInput) SetDBInstanceClass(v string) *CreateDBInstanceInput {
	s.DBInstanceClass = &v
	return s
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *CreateDBInstanceInput) SetDBInstanceIdentifier(v string) *CreateDBInstanceInput {
	s.DBInstanceIdentifier = &v
	return s
}

// SetDBName sets the DBName field's value.
func (s *CreateDBInstanceInput) SetDBName(v string) *CreateDBInstanceInput {
	s.DBName = &v
	return s
}

// SetDBParameterGroupName sets the DBParameterGroupName field's value.
func (s *CreateDBInstanceInput) SetDBParameterGroupName(v string) *CreateDBInstanceInput {
	s.DBParameterGroupName = &v
	return s
}

// SetDBSecurityGroups sets the DBSecurityGroups field's value.
func (s *CreateDBInstanceInput) SetDBSecurityGroups(v []*string) *CreateDBInstanceInput {
	s.DBSecurityGroups = v
	return s
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *CreateDBInstanceInput) SetDBSubnetGroupName(v string) *CreateDBInstanceInput {
	s.DBSubnetGroupName = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *CreateDBInstanceInput) SetDomain(v string) *CreateDBInstanceInput {
	s.Domain = &v
	return s
}

// SetDomainIAMRoleName sets the DomainIAMRoleName field's value.
func (s *CreateDBInstanceInput) SetDomainIAMRoleName(v string) *CreateDBInstanceInput {
	s.DomainIAMRoleName = &v
	return s
}

// SetEnableIAMDatabaseAuthentication sets the EnableIAMDatabaseAuthentication field's value.
func (s *CreateDBInstanceInput) SetEnableIAMDatabaseAuthentication(v bool) *CreateDBInstanceInput {
	s.EnableIAMDatabaseAuthentication = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *CreateDBInstanceInput) SetEngine(v string) *CreateDBInstanceInput {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *CreateDBInstanceInput) SetEngineVersion(v string) *CreateDBInstanceInput {
	s.EngineVersion = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *CreateDBInstanceInput) SetIops(v int64) *CreateDBInstanceInput {
	s.Iops = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateDBInstanceInput) SetKmsKeyId(v string) *CreateDBInstanceInput {
	s.KmsKeyId = &v
	return s
}

// SetLicenseModel sets the LicenseModel field's value.
func (s *CreateDBInstanceInput) SetLicenseModel(v string) *CreateDBInstanceInput {
	s.LicenseModel = &v
	return s
}

// SetMasterUserPassword sets the MasterUserPassword field's value.
func (s *CreateDBInstanceInput) SetMasterUserPassword(v string) *CreateDBInstanceInput {
	s.MasterUserPassword = &v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *CreateDBInstanceInput) SetMasterUsername(v string) *CreateDBInstanceInput {
	s.MasterUsername = &v
	return s
}

// SetMonitoringInterval sets the MonitoringInterval field's value.
func (s *CreateDBInstanceInput) SetMonitoringInterval(v int64) *CreateDBInstanceInput {
	s.MonitoringInterval = &v
	return s
}

// SetMonitoringRoleArn sets the MonitoringRoleArn field's value.
func (s *CreateDBInstanceInput) SetMonitoringRoleArn(v string) *CreateDBInstanceInput {
	s.MonitoringRoleArn = &v
	return s
}

// SetMultiAZ sets the MultiAZ field's value.
func (s *CreateDBInstanceInput) SetMultiAZ(v bool) *CreateDBInstanceInput {
	s.MultiAZ = &v
	return s
}

// SetOptionGroupName sets the OptionGroupName field's value.
func (s *CreateDBInstanceInput) SetOptionGroupName(v string) *CreateDBInstanceInput {
	s.OptionGroupName = &v
	return s
}

// SetPort sets the Port field's value.
func (s *CreateDBInstanceInput) SetPort(v int64) *CreateDBInstanceInput {
	s.Port = &v
	return s
}

// SetPreferredBackupWindow sets the PreferredBackupWindow field's value.
func (s *CreateDBInstanceInput) SetPreferredBackupWindow(v string) *CreateDBInstanceInput {
	s.PreferredBackupWindow = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *CreateDBInstanceInput) SetPreferredMaintenanceWindow(v string) *CreateDBInstanceInput {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetPromotionTier sets the PromotionTier field's value.
func (s *CreateDBInstanceInput) SetPromotionTier(v int64) *CreateDBInstanceInput {
	s.PromotionTier = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *CreateDBInstanceInput) SetPubliclyAccessible(v bool) *CreateDBInstanceInput {
	s.PubliclyAccessible = &v
	return s
}

// SetStorageEncrypted sets the StorageEncrypted field's value.
func (s *CreateDBInstanceInput) SetStorageEncrypted(v bool) *CreateDBInstanceInput {
	s.StorageEncrypted = &v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *CreateDBInstanceInput) SetStorageType(v string) *CreateDBInstanceInput {
	s.StorageType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDBInstanceInput) SetTags(v []*Tag) *CreateDBInstanceInput {
	s.Tags = v
	return s
}

// SetTdeCredentialArn sets the TdeCredentialArn field's value.
func (s *CreateDBInstanceInput) SetTdeCredentialArn(v string) *CreateDBInstanceInput {
	s.TdeCredentialArn = &v
	return s
}

// SetTdeCredentialPassword sets the TdeCredentialPassword field's value.
func (s *CreateDBInstanceInput) SetTdeCredentialPassword(v string) *CreateDBInstanceInput {
	s.TdeCredentialPassword = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *CreateDBInstanceInput) SetTimezone(v string) *CreateDBInstanceInput {
	s.Timezone = &v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *CreateDBInstanceInput) SetVpcSecurityGroupIds(v []*string) *CreateDBInstanceInput {
	s.VpcSecurityGroupIds = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBInstanceResult
type CreateDBInstanceOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//    * CreateDBInstance
	//
	//    * DeleteDBInstance
	//
	//    * ModifyDBInstance
	//
	//    * StopDBInstance
	//
	//    * StartDBInstance
	//
	// This data type is used as a response element in the DescribeDBInstances action.
	DBInstance *DBInstance `type:"structure"`
}

// String returns the string representation
func (s CreateDBInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBInstanceOutput) GoString() string {
	return s.String()
}

// SetDBInstance sets the DBInstance field's value.
func (s *CreateDBInstanceOutput) SetDBInstance(v *DBInstance) *CreateDBInstanceOutput {
	s.DBInstance = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBInstanceReadReplicaMessage
type CreateDBInstanceReadReplicaInput struct {
	_ struct{} `type:"structure"`

	// Indicates that minor engine upgrades will be applied automatically to the
	// Read Replica during the maintenance window.
	//
	// Default: Inherits from the source DB instance
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// The Amazon EC2 Availability Zone that the Read Replica will be created in.
	//
	// Default: A random, system-chosen Availability Zone in the endpoint's AWS
	// Region.
	//
	// Example: us-east-1d
	AvailabilityZone *string `type:"string"`

	// True to copy all tags from the Read Replica to snapshots of the Read Replica;
	// otherwise false. The default is false.
	CopyTagsToSnapshot *bool `type:"boolean"`

	// The compute and memory capacity of the Read Replica. Note that not all instance
	// classes are available in all regions for all DB engines.
	//
	// Valid Values: db.m1.small | db.m1.medium | db.m1.large | db.m1.xlarge | db.m2.xlarge
	// |db.m2.2xlarge | db.m2.4xlarge | db.m3.medium | db.m3.large | db.m3.xlarge
	// | db.m3.2xlarge | db.m4.large | db.m4.xlarge | db.m4.2xlarge | db.m4.4xlarge
	// | db.m4.10xlarge | db.r3.large | db.r3.xlarge | db.r3.2xlarge | db.r3.4xlarge
	// | db.r3.8xlarge | db.t2.micro | db.t2.small | db.t2.medium | db.t2.large
	//
	// Default: Inherits from the source DB instance.
	DBInstanceClass *string `type:"string"`

	// The DB instance identifier of the Read Replica. This identifier is the unique
	// key that identifies a DB instance. This parameter is stored as a lowercase
	// string.
	//
	// DBInstanceIdentifier is a required field
	DBInstanceIdentifier *string `type:"string" required:"true"`

	// Specifies a DB subnet group for the DB instance. The new DB instance will
	// be created in the VPC associated with the DB subnet group. If no DB subnet
	// group is specified, then the new DB instance is not created in a VPC.
	//
	// Constraints:
	//
	//    * Can only be specified if the source DB instance identifier specifies
	//    a DB instance in another AWS Region.
	//
	//    * The specified DB subnet group must be in the same AWS Region in which
	//    the operation is running.
	//
	//    * All Read Replicas in one AWS Region that are created from the same source
	//    DB instance must either:>
	//
	// Specify DB subnet groups from the same VPC. All these Read Replicas will
	//    be created in the same VPC.
	//
	// Not specify a DB subnet group. All these Read Replicas will be created outside
	//    of any VPC.
	//
	// Constraints: Must contain no more than 255 alphanumeric characters, periods,
	// underscores, spaces, or hyphens. Must not be default.
	//
	// Example: mySubnetgroup
	DBSubnetGroupName *string `type:"string"`

	// DestinationRegion is used for presigning the request to a given region.
	DestinationRegion *string `type:"string"`

	// True to enable mapping of AWS Identity and Access Management (IAM) accounts
	// to database accounts; otherwise false.
	//
	// You can enable IAM database authentication for the following database engines
	//
	//    * For MySQL 5.6, minor version 5.6.34 or higher
	//
	//    * For MySQL 5.7, minor version 5.7.16 or higher
	//
	//    * Aurora 5.6 or higher.
	//
	// Default: false
	EnableIAMDatabaseAuthentication *bool `type:"boolean"`

	// The amount of Provisioned IOPS (input/output operations per second) to be
	// initially allocated for the DB instance.
	Iops *int64 `type:"integer"`

	// The AWS KMS key ID for an encrypted Read Replica. The KMS key ID is the Amazon
	// Resource Name (ARN), KMS key identifier, or the KMS key alias for the KMS
	// encryption key.
	//
	// If you specify this parameter when you create a Read Replica from an unencrypted
	// DB instance, the Read Replica is encrypted.
	//
	// If you create an encrypted Read Replica in the same AWS Region as the source
	// DB instance, then you do not have to specify a value for this parameter.
	// The Read Replica is encrypted with the same KMS key as the source DB instance.
	//
	// If you create an encrypted Read Replica in a different AWS Region, then you
	// must specify a KMS key for the destination AWS Region. KMS encryption keys
	// are specific to the AWS Region that they are created in, and you cannot use
	// encryption keys from one AWS Region in another AWS Region.
	KmsKeyId *string `type:"string"`

	// The interval, in seconds, between points when Enhanced Monitoring metrics
	// are collected for the Read Replica. To disable collecting Enhanced Monitoring
	// metrics, specify 0. The default is 0.
	//
	// If MonitoringRoleArn is specified, then you must also set MonitoringInterval
	// to a value other than 0.
	//
	// Valid Values: 0, 1, 5, 10, 15, 30, 60
	MonitoringInterval *int64 `type:"integer"`

	// The ARN for the IAM role that permits RDS to send enhanced monitoring metrics
	// to CloudWatch Logs. For example, arn:aws:iam:123456789012:role/emaccess.
	// For information on creating a monitoring role, go to To create an IAM role
	// for Amazon RDS Enhanced Monitoring (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole).
	//
	// If MonitoringInterval is set to a value other than 0, then you must supply
	// a MonitoringRoleArn value.
	MonitoringRoleArn *string `type:"string"`

	// The option group the DB instance will be associated with. If omitted, the
	// default option group for the engine specified will be used.
	OptionGroupName *string `type:"string"`

	// The port number that the DB instance uses for connections.
	//
	// Default: Inherits from the source DB instance
	//
	// Valid Values: 1150-65535
	Port *int64 `type:"integer"`

	// The URL that contains a Signature Version 4 signed request for the CreateDBInstanceReadReplica
	// API action in the source AWS Region that contains the source DB instance.
	//
	// You must specify this parameter when you create an encrypted Read Replica
	// from another AWS Region by using the Amazon RDS API. You can specify the
	// source region option instead of this parameter when you create an encrypted
	// Read Replica from another AWS Region by using the AWS CLI.
	//
	// The presigned URL must be a valid request for the CreateDBInstanceReadReplica
	// API action that can be executed in the source AWS Region that contains the
	// encrypted source DB instance. The presigned URL request must contain the
	// following parameter values:
	//
	//    * DestinationRegion - The AWS Region that the encrypted Read Replica will
	//    be created in. This AWS Region is the same one where the CreateDBInstanceReadReplica
	//    action is called that contains this presigned URL.
	//
	// For example, if you create an encrypted DB instance in the us-west-1 region,
	//    from a source DB instance in the us-east-2 region, then you call the CreateDBInstanceReadReplica
	//    action in the us-east-1 region and provide a presigned URL that contains
	//    a call to the CreateDBInstanceReadReplica action in the us-west-2 region.
	//    For this example, the DestinationRegion in the presigned URL must be set
	//    to the us-east-1 region.
	//
	//    * KmsKeyId - The KMS key identifier for the key to use to encrypt the
	//    Read Replica in the destination AWS Region. This is the same identifier
	//    for both the CreateDBInstanceReadReplica action that is called in the
	//    destination AWS Region, and the action contained in the presigned URL.
	//
	//
	//    * SourceDBInstanceIdentifier - The DB instance identifier for the encrypted
	//    DB instance to be replicated. This identifier must be in the Amazon Resource
	//    Name (ARN) format for the source AWS Region. For example, if you are creating
	//    an encrypted Read Replica from a DB instance in the us-west-2 region,
	//    then your SourceDBInstanceIdentifier looks like the following example:
	//    arn:aws:rds:us-west-2:123456789012:instance:mysql-instance1-20161115.
	//
	//
	// To learn how to generate a Signature Version 4 signed request, see Authenticating
	// Requests: Using Query Parameters (AWS Signature Version 4) (http://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html)
	// and Signature Version 4 Signing Process (http://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
	PreSignedUrl *string `type:"string"`

	// Specifies the accessibility options for the DB instance. A value of true
	// specifies an Internet-facing instance with a publicly resolvable DNS name,
	// which resolves to a public IP address. A value of false specifies an internal
	// instance with a DNS name that resolves to a private IP address.
	//
	// Default: The default behavior varies depending on whether a VPC has been
	// requested or not. The following list shows the default behavior in each case.
	//
	//    * Default VPC:true
	//
	//    * VPC:false
	//
	// If no DB subnet group has been specified as part of the request and the PubliclyAccessible
	// value has not been set, the DB instance will be publicly accessible. If a
	// specific DB subnet group has been specified as part of the request and the
	// PubliclyAccessible value has not been set, the DB instance will be private.
	PubliclyAccessible *bool `type:"boolean"`

	// The identifier of the DB instance that will act as the source for the Read
	// Replica. Each DB instance can have up to five Read Replicas.
	//
	// Constraints:
	//
	//    * Must be the identifier of an existing MySQL, MariaDB, or PostgreSQL
	//    DB instance.
	//
	//    * Can specify a DB instance that is a MySQL Read Replica only if the source
	//    is running MySQL 5.6.
	//
	//    * Can specify a DB instance that is a PostgreSQL DB instance only if the
	//    source is running PostgreSQL 9.3.5 or later (9.4.7 and higher for cross
	//    region replication).
	//
	//    * The specified DB instance must have automatic backups enabled, its backup
	//    retention period must be greater than 0.
	//
	//    * If the source DB instance is in the same AWS Region as the Read Replica,
	//    specify a valid DB instance identifier.
	//
	//    * If the source DB instance is in a different AWS Region than the Read
	//    Replica, specify a valid DB instance ARN. For more information, go to
	//     Constructing a Amazon RDS Amazon Resource Name (ARN) (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing).
	//
	// SourceDBInstanceIdentifier is a required field
	SourceDBInstanceIdentifier *string `type:"string" required:"true"`

	// SourceRegion is the source region where the resource exists. This is not
	// sent over the wire and is only used for presigning. This value should always
	// have the same region as the source ARN.
	SourceRegion *string `type:"string" ignore:"true"`

	// Specifies the storage type to be associated with the Read Replica.
	//
	// Valid values: standard | gp2 | io1
	//
	// If you specify io1, you must also include a value for the Iops parameter.
	//
	// Default: io1 if the Iops parameter is specified; otherwise standard
	StorageType *string `type:"string"`

	// A list of tags.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateDBInstanceReadReplicaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBInstanceReadReplicaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDBInstanceReadReplicaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDBInstanceReadReplicaInput"}
	if s.DBInstanceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBInstanceIdentifier"))
	}
	if s.SourceDBInstanceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceDBInstanceIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoMinorVersionUpgrade sets the AutoMinorVersionUpgrade field's value.
func (s *CreateDBInstanceReadReplicaInput) SetAutoMinorVersionUpgrade(v bool) *CreateDBInstanceReadReplicaInput {
	s.AutoMinorVersionUpgrade = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *CreateDBInstanceReadReplicaInput) SetAvailabilityZone(v string) *CreateDBInstanceReadReplicaInput {
	s.AvailabilityZone = &v
	return s
}

// SetCopyTagsToSnapshot sets the CopyTagsToSnapshot field's value.
func (s *CreateDBInstanceReadReplicaInput) SetCopyTagsToSnapshot(v bool) *CreateDBInstanceReadReplicaInput {
	s.CopyTagsToSnapshot = &v
	return s
}

// SetDBInstanceClass sets the DBInstanceClass field's value.
func (s *CreateDBInstanceReadReplicaInput) SetDBInstanceClass(v string) *CreateDBInstanceReadReplicaInput {
	s.DBInstanceClass = &v
	return s
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *CreateDBInstanceReadReplicaInput) SetDBInstanceIdentifier(v string) *CreateDBInstanceReadReplicaInput {
	s.DBInstanceIdentifier = &v
	return s
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *CreateDBInstanceReadReplicaInput) SetDBSubnetGroupName(v string) *CreateDBInstanceReadReplicaInput {
	s.DBSubnetGroupName = &v
	return s
}

// SetDestinationRegion sets the DestinationRegion field's value.
func (s *CreateDBInstanceReadReplicaInput) SetDestinationRegion(v string) *CreateDBInstanceReadReplicaInput {
	s.DestinationRegion = &v
	return s
}

// SetEnableIAMDatabaseAuthentication sets the EnableIAMDatabaseAuthentication field's value.
func (s *CreateDBInstanceReadReplicaInput) SetEnableIAMDatabaseAuthentication(v bool) *CreateDBInstanceReadReplicaInput {
	s.EnableIAMDatabaseAuthentication = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *CreateDBInstanceReadReplicaInput) SetIops(v int64) *CreateDBInstanceReadReplicaInput {
	s.Iops = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateDBInstanceReadReplicaInput) SetKmsKeyId(v string) *CreateDBInstanceReadReplicaInput {
	s.KmsKeyId = &v
	return s
}

// SetMonitoringInterval sets the MonitoringInterval field's value.
func (s *CreateDBInstanceReadReplicaInput) SetMonitoringInterval(v int64) *CreateDBInstanceReadReplicaInput {
	s.MonitoringInterval = &v
	return s
}

// SetMonitoringRoleArn sets the MonitoringRoleArn field's value.
func (s *CreateDBInstanceReadReplicaInput) SetMonitoringRoleArn(v string) *CreateDBInstanceReadReplicaInput {
	s.MonitoringRoleArn = &v
	return s
}

// SetOptionGroupName sets the OptionGroupName field's value.
func (s *CreateDBInstanceReadReplicaInput) SetOptionGroupName(v string) *CreateDBInstanceReadReplicaInput {
	s.OptionGroupName = &v
	return s
}

// SetPort sets the Port field's value.
func (s *CreateDBInstanceReadReplicaInput) SetPort(v int64) *CreateDBInstanceReadReplicaInput {
	s.Port = &v
	return s
}

// SetPreSignedUrl sets the PreSignedUrl field's value.
func (s *CreateDBInstanceReadReplicaInput) SetPreSignedUrl(v string) *CreateDBInstanceReadReplicaInput {
	s.PreSignedUrl = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *CreateDBInstanceReadReplicaInput) SetPubliclyAccessible(v bool) *CreateDBInstanceReadReplicaInput {
	s.PubliclyAccessible = &v
	return s
}

// SetSourceDBInstanceIdentifier sets the SourceDBInstanceIdentifier field's value.
func (s *CreateDBInstanceReadReplicaInput) SetSourceDBInstanceIdentifier(v string) *CreateDBInstanceReadReplicaInput {
	s.SourceDBInstanceIdentifier = &v
	return s
}

// SetSourceRegion sets the SourceRegion field's value.
func (s *CreateDBInstanceReadReplicaInput) SetSourceRegion(v string) *CreateDBInstanceReadReplicaInput {
	s.SourceRegion = &v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *CreateDBInstanceReadReplicaInput) SetStorageType(v string) *CreateDBInstanceReadReplicaInput {
	s.StorageType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDBInstanceReadReplicaInput) SetTags(v []*Tag) *CreateDBInstanceReadReplicaInput {
	s.Tags = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBInstanceReadReplicaResult
type CreateDBInstanceReadReplicaOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//    * CreateDBInstance
	//
	//    * DeleteDBInstance
	//
	//    * ModifyDBInstance
	//
	//    * StopDBInstance
	//
	//    * StartDBInstance
	//
	// This data type is used as a response element in the DescribeDBInstances action.
	DBInstance *DBInstance `type:"structure"`
}

// String returns the string representation
func (s CreateDBInstanceReadReplicaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBInstanceReadReplicaOutput) GoString() string {
	return s.String()
}

// SetDBInstance sets the DBInstance field's value.
func (s *CreateDBInstanceReadReplicaOutput) SetDBInstance(v *DBInstance) *CreateDBInstanceReadReplicaOutput {
	s.DBInstance = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBParameterGroupMessage
type CreateDBParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The DB parameter group family name. A DB parameter group can be associated
	// with one and only one DB parameter group family, and can be applied only
	// to a DB instance running a database engine and engine version compatible
	// with that DB parameter group family.
	//
	// DBParameterGroupFamily is a required field
	DBParameterGroupFamily *string `type:"string" required:"true"`

	// The name of the DB parameter group.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 alphanumeric characters
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	// This value is stored as a lowercase string.
	//
	// DBParameterGroupName is a required field
	DBParameterGroupName *string `type:"string" required:"true"`

	// The description for the DB parameter group.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// A list of tags.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateDBParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDBParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDBParameterGroupInput"}
	if s.DBParameterGroupFamily == nil {
		invalidParams.Add(request.NewErrParamRequired("DBParameterGroupFamily"))
	}
	if s.DBParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBParameterGroupName"))
	}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBParameterGroupFamily sets the DBParameterGroupFamily field's value.
func (s *CreateDBParameterGroupInput) SetDBParameterGroupFamily(v string) *CreateDBParameterGroupInput {
	s.DBParameterGroupFamily = &v
	return s
}

// SetDBParameterGroupName sets the DBParameterGroupName field's value.
func (s *CreateDBParameterGroupInput) SetDBParameterGroupName(v string) *CreateDBParameterGroupInput {
	s.DBParameterGroupName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateDBParameterGroupInput) SetDescription(v string) *CreateDBParameterGroupInput {
	s.Description = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDBParameterGroupInput) SetTags(v []*Tag) *CreateDBParameterGroupInput {
	s.Tags = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBParameterGroupResult
type CreateDBParameterGroupOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the CreateDBParameterGroup
	// action.
	//
	// This data type is used as a request parameter in the DeleteDBParameterGroup
	// action, and as a response element in the DescribeDBParameterGroups action.
	DBParameterGroup *DBParameterGroup `type:"structure"`
}

// String returns the string representation
func (s CreateDBParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBParameterGroupOutput) GoString() string {
	return s.String()
}

// SetDBParameterGroup sets the DBParameterGroup field's value.
func (s *CreateDBParameterGroupOutput) SetDBParameterGroup(v *DBParameterGroup) *CreateDBParameterGroupOutput {
	s.DBParameterGroup = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSecurityGroupMessage
type CreateDBSecurityGroupInput struct {
	_ struct{} `type:"structure"`

	// The description for the DB security group.
	//
	// DBSecurityGroupDescription is a required field
	DBSecurityGroupDescription *string `type:"string" required:"true"`

	// The name for the DB security group. This value is stored as a lowercase string.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 alphanumeric characters
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	//    * Must not be "Default"
	//
	// Example: mysecuritygroup
	//
	// DBSecurityGroupName is a required field
	DBSecurityGroupName *string `type:"string" required:"true"`

	// A list of tags.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateDBSecurityGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBSecurityGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDBSecurityGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDBSecurityGroupInput"}
	if s.DBSecurityGroupDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("DBSecurityGroupDescription"))
	}
	if s.DBSecurityGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBSecurityGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBSecurityGroupDescription sets the DBSecurityGroupDescription field's value.
func (s *CreateDBSecurityGroupInput) SetDBSecurityGroupDescription(v string) *CreateDBSecurityGroupInput {
	s.DBSecurityGroupDescription = &v
	return s
}

// SetDBSecurityGroupName sets the DBSecurityGroupName field's value.
func (s *CreateDBSecurityGroupInput) SetDBSecurityGroupName(v string) *CreateDBSecurityGroupInput {
	s.DBSecurityGroupName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDBSecurityGroupInput) SetTags(v []*Tag) *CreateDBSecurityGroupInput {
	s.Tags = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSecurityGroupResult
type CreateDBSecurityGroupOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//    * DescribeDBSecurityGroups
	//
	//    * AuthorizeDBSecurityGroupIngress
	//
	//    * CreateDBSecurityGroup
	//
	//    * RevokeDBSecurityGroupIngress
	//
	// This data type is used as a response element in the DescribeDBSecurityGroups
	// action.
	DBSecurityGroup *DBSecurityGroup `type:"structure"`
}

// String returns the string representation
func (s CreateDBSecurityGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBSecurityGroupOutput) GoString() string {
	return s.String()
}

// SetDBSecurityGroup sets the DBSecurityGroup field's value.
func (s *CreateDBSecurityGroupOutput) SetDBSecurityGroup(v *DBSecurityGroup) *CreateDBSecurityGroupOutput {
	s.DBSecurityGroup = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSnapshotMessage
type CreateDBSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The DB instance identifier. This is the unique key that identifies a DB instance.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	// DBInstanceIdentifier is a required field
	DBInstanceIdentifier *string `type:"string" required:"true"`

	// The identifier for the DB snapshot.
	//
	// Constraints:
	//
	//    * Cannot be null, empty, or blank
	//
	//    * Must contain from 1 to 255 alphanumeric characters or hyphens
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	// Example: my-snapshot-id
	//
	// DBSnapshotIdentifier is a required field
	DBSnapshotIdentifier *string `type:"string" required:"true"`

	// A list of tags.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateDBSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDBSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDBSnapshotInput"}
	if s.DBInstanceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBInstanceIdentifier"))
	}
	if s.DBSnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBSnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *CreateDBSnapshotInput) SetDBInstanceIdentifier(v string) *CreateDBSnapshotInput {
	s.DBInstanceIdentifier = &v
	return s
}

// SetDBSnapshotIdentifier sets the DBSnapshotIdentifier field's value.
func (s *CreateDBSnapshotInput) SetDBSnapshotIdentifier(v string) *CreateDBSnapshotInput {
	s.DBSnapshotIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDBSnapshotInput) SetTags(v []*Tag) *CreateDBSnapshotInput {
	s.Tags = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSnapshotResult
type CreateDBSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//    * CreateDBSnapshot
	//
	//    * DeleteDBSnapshot
	//
	// This data type is used as a response element in the DescribeDBSnapshots action.
	DBSnapshot *DBSnapshot `type:"structure"`
}

// String returns the string representation
func (s CreateDBSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBSnapshotOutput) GoString() string {
	return s.String()
}

// SetDBSnapshot sets the DBSnapshot field's value.
func (s *CreateDBSnapshotOutput) SetDBSnapshot(v *DBSnapshot) *CreateDBSnapshotOutput {
	s.DBSnapshot = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSubnetGroupMessage
type CreateDBSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The description for the DB subnet group.
	//
	// DBSubnetGroupDescription is a required field
	DBSubnetGroupDescription *string `type:"string" required:"true"`

	// The name for the DB subnet group. This value is stored as a lowercase string.
	//
	// Constraints: Must contain no more than 255 alphanumeric characters, periods,
	// underscores, spaces, or hyphens. Must not be default.
	//
	// Example: mySubnetgroup
	//
	// DBSubnetGroupName is a required field
	DBSubnetGroupName *string `type:"string" required:"true"`

	// The EC2 Subnet IDs for the DB subnet group.
	//
	// SubnetIds is a required field
	SubnetIds []*string `locationNameList:"SubnetIdentifier" type:"list" required:"true"`

	// A list of tags.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateDBSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBSubnetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDBSubnetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDBSubnetGroupInput"}
	if s.DBSubnetGroupDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("DBSubnetGroupDescription"))
	}
	if s.DBSubnetGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBSubnetGroupName"))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBSubnetGroupDescription sets the DBSubnetGroupDescription field's value.
func (s *CreateDBSubnetGroupInput) SetDBSubnetGroupDescription(v string) *CreateDBSubnetGroupInput {
	s.DBSubnetGroupDescription = &v
	return s
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *CreateDBSubnetGroupInput) SetDBSubnetGroupName(v string) *CreateDBSubnetGroupInput {
	s.DBSubnetGroupName = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *CreateDBSubnetGroupInput) SetSubnetIds(v []*string) *CreateDBSubnetGroupInput {
	s.SubnetIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDBSubnetGroupInput) SetTags(v []*Tag) *CreateDBSubnetGroupInput {
	s.Tags = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSubnetGroupResult
type CreateDBSubnetGroupOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//    * CreateDBSubnetGroup
	//
	//    * ModifyDBSubnetGroup
	//
	//    * DescribeDBSubnetGroups
	//
	//    * DeleteDBSubnetGroup
	//
	// This data type is used as a response element in the DescribeDBSubnetGroups
	// action.
	DBSubnetGroup *DBSubnetGroup `type:"structure"`
}

// String returns the string representation
func (s CreateDBSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBSubnetGroupOutput) GoString() string {
	return s.String()
}

// SetDBSubnetGroup sets the DBSubnetGroup field's value.
func (s *CreateDBSubnetGroupOutput) SetDBSubnetGroup(v *DBSubnetGroup) *CreateDBSubnetGroupOutput {
	s.DBSubnetGroup = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateEventSubscriptionMessage
type CreateEventSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// A Boolean value; set to true to activate the subscription, set to false to
	// create the subscription but not active it.
	Enabled *bool `type:"boolean"`

	// A list of event categories for a SourceType that you want to subscribe to.
	// You can see a list of the categories for a given SourceType in the Events
	// (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html)
	// topic in the Amazon RDS User Guide or by using the DescribeEventCategories
	// action.
	EventCategories []*string `locationNameList:"EventCategory" type:"list"`

	// The Amazon Resource Name (ARN) of the SNS topic created for event notification.
	// The ARN is created by Amazon SNS when you create a topic and subscribe to
	// it.
	//
	// SnsTopicArn is a required field
	SnsTopicArn *string `type:"string" required:"true"`

	// The list of identifiers of the event sources for which events will be returned.
	// If not specified, then all sources are included in the response. An identifier
	// must begin with a letter and must contain only ASCII letters, digits, and
	// hyphens; it cannot end with a hyphen or contain two consecutive hyphens.
	//
	// Constraints:
	//
	//    * If SourceIds are supplied, SourceType must also be provided.
	//
	//    * If the source type is a DB instance, then a DBInstanceIdentifier must
	//    be supplied.
	//
	//    * If the source type is a DB security group, a DBSecurityGroupName must
	//    be supplied.
	//
	//    * If the source type is a DB parameter group, a DBParameterGroupName must
	//    be supplied.
	//
	//    * If the source type is a DB snapshot, a DBSnapshotIdentifier must be
	//    supplied.
	SourceIds []*string `locationNameList:"SourceId" type:"list"`

	// The type of source that will be generating the events. For example, if you
	// want to be notified of events generated by a DB instance, you would set this
	// parameter to db-instance. if this value is not specified, all events are
	// returned.
	//
	// Valid values: db-instance | db-cluster | db-parameter-group | db-security-group
	// | db-snapshot | db-cluster-snapshot
	SourceType *string `type:"string"`

	// The name of the subscription.
	//
	// Constraints: The name must be less than 255 characters.
	//
	// SubscriptionName is a required field
	SubscriptionName *string `type:"string" required:"true"`

	// A list of tags.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateEventSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEventSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEventSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEventSubscriptionInput"}
	if s.SnsTopicArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SnsTopicArn"))
	}
	if s.SubscriptionName == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *CreateEventSubscriptionInput) SetEnabled(v bool) *CreateEventSubscriptionInput {
	s.Enabled = &v
	return s
}

// SetEventCategories sets the EventCategories field's value.
func (s *CreateEventSubscriptionInput) SetEventCategories(v []*string) *CreateEventSubscriptionInput {
	s.EventCategories = v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *CreateEventSubscriptionInput) SetSnsTopicArn(v string) *CreateEventSubscriptionInput {
	s.SnsTopicArn = &v
	return s
}

// SetSourceIds sets the SourceIds field's value.
func (s *CreateEventSubscriptionInput) SetSourceIds(v []*string) *CreateEventSubscriptionInput {
	s.SourceIds = v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *CreateEventSubscriptionInput) SetSourceType(v string) *CreateEventSubscriptionInput {
	s.SourceType = &v
	return s
}

// SetSubscriptionName sets the SubscriptionName field's value.
func (s *CreateEventSubscriptionInput) SetSubscriptionName(v string) *CreateEventSubscriptionInput {
	s.SubscriptionName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEventSubscriptionInput) SetTags(v []*Tag) *CreateEventSubscriptionInput {
	s.Tags = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateEventSubscriptionResult
type CreateEventSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// Contains the results of a successful invocation of the DescribeEventSubscriptions
	// action.
	EventSubscription *EventSubscription `type:"structure"`
}

// String returns the string representation
func (s CreateEventSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEventSubscriptionOutput) GoString() string {
	return s.String()
}

// SetEventSubscription sets the EventSubscription field's value.
func (s *CreateEventSubscriptionOutput) SetEventSubscription(v *EventSubscription) *CreateEventSubscriptionOutput {
	s.EventSubscription = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateOptionGroupMessage
type CreateOptionGroupInput struct {
	_ struct{} `type:"structure"`

	// Specifies the name of the engine that this option group should be associated
	// with.
	//
	// EngineName is a required field
	EngineName *string `type:"string" required:"true"`

	// Specifies the major version of the engine that this option group should be
	// associated with.
	//
	// MajorEngineVersion is a required field
	MajorEngineVersion *string `type:"string" required:"true"`

	// The description of the option group.
	//
	// OptionGroupDescription is a required field
	OptionGroupDescription *string `type:"string" required:"true"`

	// Specifies the name of the option group to be created.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 alphanumeric characters or hyphens
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	// Example: myoptiongroup
	//
	// OptionGroupName is a required field
	OptionGroupName *string `type:"string" required:"true"`

	// A list of tags.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateOptionGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateOptionGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateOptionGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateOptionGroupInput"}
	if s.EngineName == nil {
		invalidParams.Add(request.NewErrParamRequired("EngineName"))
	}
	if s.MajorEngineVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("MajorEngineVersion"))
	}
	if s.OptionGroupDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("OptionGroupDescription"))
	}
	if s.OptionGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("OptionGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEngineName sets the EngineName field's value.
func (s *CreateOptionGroupInput) SetEngineName(v string) *CreateOptionGroupInput {
	s.EngineName = &v
	return s
}

// SetMajorEngineVersion sets the MajorEngineVersion field's value.
func (s *CreateOptionGroupInput) SetMajorEngineVersion(v string) *CreateOptionGroupInput {
	s.MajorEngineVersion = &v
	return s
}

// SetOptionGroupDescription sets the OptionGroupDescription field's value.
func (s *CreateOptionGroupInput) SetOptionGroupDescription(v string) *CreateOptionGroupInput {
	s.OptionGroupDescription = &v
	return s
}

// SetOptionGroupName sets the OptionGroupName field's value.
func (s *CreateOptionGroupInput) SetOptionGroupName(v string) *CreateOptionGroupInput {
	s.OptionGroupName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateOptionGroupInput) SetTags(v []*Tag) *CreateOptionGroupInput {
	s.Tags = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateOptionGroupResult
type CreateOptionGroupOutput struct {
	_ struct{} `type:"structure"`

	OptionGroup *OptionGroup `type:"structure"`
}

// String returns the string representation
func (s CreateOptionGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateOptionGroupOutput) GoString() string {
	return s.String()
}

// SetOptionGroup sets the OptionGroup field's value.
func (s *CreateOptionGroupOutput) SetOptionGroup(v *OptionGroup) *CreateOptionGroupOutput {
	s.OptionGroup = v
	return s
}

// Contains the result of a successful invocation of the following actions:
//
//    * CreateDBCluster
//
//    * DeleteDBCluster
//
//    * FailoverDBCluster
//
//    * ModifyDBCluster
//
//    * RestoreDBClusterFromSnapshot
//
//    * RestoreDBClusterToPointInTime
//
// This data type is used as a response element in the DescribeDBClusters action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DBCluster
type DBCluster struct {
	_ struct{} `type:"structure"`

	// For all database engines except Amazon Aurora, AllocatedStorage specifies
	// the allocated storage size in gigabytes (GB). For Aurora, AllocatedStorage
	// always returns 1, because Aurora DB cluster storage size is not fixed, but
	// instead automatically adjusts as needed.
	AllocatedStorage *int64 `type:"integer"`

	// Provides a list of the AWS Identity and Access Management (IAM) roles that
	// are associated with the DB cluster. IAM roles that are associated with a
	// DB cluster grant permission for the DB cluster to access other AWS services
	// on your behalf.
	AssociatedRoles []*DBClusterRole `locationNameList:"DBClusterRole" type:"list"`

	// Provides the list of EC2 Availability Zones that instances in the DB cluster
	// can be created in.
	AvailabilityZones []*string `locationNameList:"AvailabilityZone" type:"list"`

	// Specifies the number of days for which automatic DB snapshots are retained.
	BackupRetentionPeriod *int64 `type:"integer"`

	// If present, specifies the name of the character set that this cluster is
	// associated with.
	CharacterSetName *string `type:"string"`

	// Identifies the clone group to which the DB cluster is associated.
	CloneGroupId *string `type:"string"`

	// Specifies the time when the DB cluster was created, in Universal Coordinated
	// Time (UTC).
	ClusterCreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The Amazon Resource Name (ARN) for the DB cluster.
	DBClusterArn *string `type:"string"`

	// Contains a user-supplied DB cluster identifier. This identifier is the unique
	// key that identifies a DB cluster.
	DBClusterIdentifier *string `type:"string"`

	// Provides the list of instances that make up the DB cluster.
	DBClusterMembers []*DBClusterMember `locationNameList:"DBClusterMember" type:"list"`

	// Provides the list of option group memberships for this DB cluster.
	DBClusterOptionGroupMemberships []*DBClusterOptionGroupStatus `locationNameList:"DBClusterOptionGroup" type:"list"`

	// Specifies the name of the DB cluster parameter group for the DB cluster.
	DBClusterParameterGroup *string `type:"string"`

	// Specifies information on the subnet group associated with the DB cluster,
	// including the name, description, and subnets in the subnet group.
	DBSubnetGroup *string `type:"string"`

	// Contains the name of the initial database of this DB cluster that was provided
	// at create time, if one was specified when the DB cluster was created. This
	// same name is returned for the life of the DB cluster.
	DatabaseName *string `type:"string"`

	// The region-unique, immutable identifier for the DB cluster. This identifier
	// is found in AWS CloudTrail log entries whenever the KMS key for the DB cluster
	// is accessed.
	DbClusterResourceId *string `type:"string"`

	// Specifies the earliest time to which a database can be restored with point-in-time
	// restore.
	EarliestRestorableTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Specifies the connection endpoint for the primary instance of the DB cluster.
	Endpoint *string `type:"string"`

	// Provides the name of the database engine to be used for this DB cluster.
	Engine *string `type:"string"`

	// Indicates the database engine version.
	EngineVersion *string `type:"string"`

	// Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
	HostedZoneId *string `type:"string"`

	// True if mapping of AWS Identity and Access Management (IAM) accounts to database
	// accounts is enabled; otherwise false.
	IAMDatabaseAuthenticationEnabled *bool `type:"boolean"`

	// If StorageEncrypted is true, the KMS key identifier for the encrypted DB
	// cluster.
	KmsKeyId *string `type:"string"`

	// Specifies the latest time to which a database can be restored with point-in-time
	// restore.
	LatestRestorableTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Contains the master username for the DB cluster.
	MasterUsername *string `type:"string"`

	// Specifies whether the DB cluster has instances in multiple Availability Zones.
	MultiAZ *bool `type:"boolean"`

	// Specifies the progress of the operation as a percentage.
	PercentProgress *string `type:"string"`

	// Specifies the port that the database engine is listening on.
	Port *int64 `type:"integer"`

	// Specifies the daily time range during which automated backups are created
	// if automated backups are enabled, as determined by the BackupRetentionPeriod.
	PreferredBackupWindow *string `type:"string"`

	// Specifies the weekly time range during which system maintenance can occur,
	// in Universal Coordinated Time (UTC).
	PreferredMaintenanceWindow *string `type:"string"`

	// Contains one or more identifiers of the Read Replicas associated with this
	// DB cluster.
	ReadReplicaIdentifiers []*string `locationNameList:"ReadReplicaIdentifier" type:"list"`

	// The reader endpoint for the DB cluster. The reader endpoint for a DB cluster
	// load-balances connections across the Aurora Replicas that are available in
	// a DB cluster. As clients request new connections to the reader endpoint,
	// Aurora distributes the connection requests among the Aurora Replicas in the
	// DB cluster. This functionality can help balance your read workload across
	// multiple Aurora Replicas in your DB cluster.
	//
	// If a failover occurs, and the Aurora Replica that you are connected to is
	// promoted to be the primary instance, your connection will be dropped. To
	// continue sending your read workload to other Aurora Replicas in the cluster,
	// you can then reconnect to the reader endpoint.
	ReaderEndpoint *string `type:"string"`

	// Contains the identifier of the source DB cluster if this DB cluster is a
	// Read Replica.
	ReplicationSourceIdentifier *string `type:"string"`

	// Specifies the current state of this DB cluster.
	Status *string `type:"string"`

	// Specifies whether the DB cluster is encrypted.
	StorageEncrypted *bool `type:"boolean"`

	// Provides a list of VPC security groups that the DB cluster belongs to.
	VpcSecurityGroups []*VpcSecurityGroupMembership `locationNameList:"VpcSecurityGroupMembership" type:"list"`
}

// String returns the string representation
func (s DBCluster) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBCluster) GoString() string {
	return s.String()
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *DBCluster) SetAllocatedStorage(v int64) *DBCluster {
	s.AllocatedStorage = &v
	return s
}

// SetAssociatedRoles sets the AssociatedRoles field's value.
func (s *DBCluster) SetAssociatedRoles(v []*DBClusterRole) *DBCluster {
	s.AssociatedRoles = v
	return s
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *DBCluster) SetAvailabilityZones(v []*string) *DBCluster {
	s.AvailabilityZones = v
	return s
}

// SetBackupRetentionPeriod sets the BackupRetentionPeriod field's value.
func (s *DBCluster) SetBackupRetentionPeriod(v int64) *DBCluster {
	s.BackupRetentionPeriod = &v
	return s
}

// SetCharacterSetName sets the CharacterSetName field's value.
func (s *DBCluster) SetCharacterSetName(v string) *DBCluster {
	s.CharacterSetName = &v
	return s
}

// SetCloneGroupId sets the CloneGroupId field's value.
func (s *DBCluster) SetCloneGroupId(v string) *DBCluster {
	s.CloneGroupId = &v
	return s
}

// SetClusterCreateTime sets the ClusterCreateTime field's value.
func (s *DBCluster) SetClusterCreateTime(v time.Time) *DBCluster {
	s.ClusterCreateTime = &v
	return s
}

// SetDBClusterArn sets the DBClusterArn field's value.
func (s *DBCluster) SetDBClusterArn(v string) *DBCluster {
	s.DBClusterArn = &v
	return s
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *DBCluster) SetDBClusterIdentifier(v string) *DBCluster {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBClusterMembers sets the DBClusterMembers field's value.
func (s *DBCluster) SetDBClusterMembers(v []*DBClusterMember) *DBCluster {
	s.DBClusterMembers = v
	return s
}

// SetDBClusterOptionGroupMemberships sets the DBClusterOptionGroupMemberships field's value.
func (s *DBCluster) SetDBClusterOptionGroupMemberships(v []*DBClusterOptionGroupStatus) *DBCluster {
	s.DBClusterOptionGroupMemberships = v
	return s
}

// SetDBClusterParameterGroup sets the DBClusterParameterGroup field's value.
func (s *DBCluster) SetDBClusterParameterGroup(v string) *DBCluster {
	s.DBClusterParameterGroup = &v
	return s
}

// SetDBSubnetGroup sets the DBSubnetGroup field's value.
func (s *DBCluster) SetDBSubnetGroup(v string) *DBCluster {
	s.DBSubnetGroup = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *DBCluster) SetDatabaseName(v string) *DBCluster {
	s.DatabaseName = &v
	return s
}

// SetDbClusterResourceId sets the DbClusterResourceId field's value.
func (s *DBCluster) SetDbClusterResourceId(v string) *DBCluster {
	s.DbClusterResourceId = &v
	return s
}

// SetEarliestRestorableTime sets the EarliestRestorableTime field's value.
func (s *DBCluster) SetEarliestRestorableTime(v time.Time) *DBCluster {
	s.EarliestRestorableTime = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *DBCluster) SetEndpoint(v string) *DBCluster {
	s.Endpoint = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *DBCluster) SetEngine(v string) *DBCluster {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *DBCluster) SetEngineVersion(v string) *DBCluster {
	s.EngineVersion = &v
	return s
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *DBCluster) SetHostedZoneId(v string) *DBCluster {
	s.HostedZoneId = &v
	return s
}

// SetIAMDatabaseAuthenticationEnabled sets the IAMDatabaseAuthenticationEnabled field's value.
func (s *DBCluster) SetIAMDatabaseAuthenticationEnabled(v bool) *DBCluster {
	s.IAMDatabaseAuthenticationEnabled = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *DBCluster) SetKmsKeyId(v string) *DBCluster {
	s.KmsKeyId = &v
	return s
}

// SetLatestRestorableTime sets the LatestRestorableTime field's value.
func (s *DBCluster) SetLatestRestorableTime(v time.Time) *DBCluster {
	s.LatestRestorableTime = &v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *DBCluster) SetMasterUsername(v string) *DBCluster {
	s.MasterUsername = &v
	return s
}

// SetMultiAZ sets the MultiAZ field's value.
func (s *DBCluster) SetMultiAZ(v bool) *DBCluster {
	s.MultiAZ = &v
	return s
}

// SetPercentProgress sets the PercentProgress field's value.
func (s *DBCluster) SetPercentProgress(v string) *DBCluster {
	s.PercentProgress = &v
	return s
}

// SetPort sets the Port field's value.
func (s *DBCluster) SetPort(v int64) *DBCluster {
	s.Port = &v
	return s
}

// SetPreferredBackupWindow sets the PreferredBackupWindow field's value.
func (s *DBCluster) SetPreferredBackupWindow(v string) *DBCluster {
	s.PreferredBackupWindow = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *DBCluster) SetPreferredMaintenanceWindow(v string) *DBCluster {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetReadReplicaIdentifiers sets the ReadReplicaIdentifiers field's value.
func (s *DBCluster) SetReadReplicaIdentifiers(v []*string) *DBCluster {
	s.ReadReplicaIdentifiers = v
	return s
}

// SetReaderEndpoint sets the ReaderEndpoint field's value.
func (s *DBCluster) SetReaderEndpoint(v string) *DBCluster {
	s.ReaderEndpoint = &v
	return s
}

// SetReplicationSourceIdentifier sets the ReplicationSourceIdentifier field's value.
func (s *DBCluster) SetReplicationSourceIdentifier(v string) *DBCluster {
	s.ReplicationSourceIdentifier = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DBCluster) SetStatus(v string) *DBCluster {
	s.Status = &v
	return s
}

// SetStorageEncrypted sets the StorageEncrypted field's value.
func (s *DBCluster) SetStorageEncrypted(v bool) *DBCluster {
	s.StorageEncrypted = &v
	return s
}

// SetVpcSecurityGroups sets the VpcSecurityGroups field's value.
func (s *DBCluster) SetVpcSecurityGroups(v []*VpcSecurityGroupMembership) *DBCluster {
	s.VpcSecurityGroups = v
	return s
}

// Contains information about an instance that is part of a DB cluster.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DBClusterMember
type DBClusterMember struct {
	_ struct{} `type:"structure"`

	// Specifies the status of the DB cluster parameter group for this member of
	// the DB cluster.
	DBClusterParameterGroupStatus *string `type:"string"`

	// Specifies the instance identifier for this member of the DB cluster.
	DBInstanceIdentifier *string `type:"string"`

	// Value that is true if the cluster member is the primary instance for the
	// DB cluster and false otherwise.
	IsClusterWriter *bool `type:"boolean"`

	// A value that specifies the order in which an Aurora Replica is promoted to
	// the primary instance after a failure of the existing primary instance. For
	// more information, see  Fault Tolerance for an Aurora DB Cluster (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Aurora.Managing.html#Aurora.Managing.FaultTolerance).
	PromotionTier *int64 `type:"integer"`
}

// String returns the string representation
func (s DBClusterMember) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBClusterMember) GoString() string {
	return s.String()
}

// SetDBClusterParameterGroupStatus sets the DBClusterParameterGroupStatus field's value.
func (s *DBClusterMember) SetDBClusterParameterGroupStatus(v string) *DBClusterMember {
	s.DBClusterParameterGroupStatus = &v
	return s
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *DBClusterMember) SetDBInstanceIdentifier(v string) *DBClusterMember {
	s.DBInstanceIdentifier = &v
	return s
}

// SetIsClusterWriter sets the IsClusterWriter field's value.
func (s *DBClusterMember) SetIsClusterWriter(v bool) *DBClusterMember {
	s.IsClusterWriter = &v
	return s
}

// SetPromotionTier sets the PromotionTier field's value.
func (s *DBClusterMember) SetPromotionTier(v int64) *DBClusterMember {
	s.PromotionTier = &v
	return s
}

// Contains status information for a DB cluster option group.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DBClusterOptionGroupStatus
type DBClusterOptionGroupStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the name of the DB cluster option group.
	DBClusterOptionGroupName *string `type:"string"`

	// Specifies the status of the DB cluster option group.
	Status *string `type:"string"`
}

// String returns the string representation
func (s DBClusterOptionGroupStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBClusterOptionGroupStatus) GoString() string {
	return s.String()
}

// SetDBClusterOptionGroupName sets the DBClusterOptionGroupName field's value.
func (s *DBClusterOptionGroupStatus) SetDBClusterOptionGroupName(v string) *DBClusterOptionGroupStatus {
	s.DBClusterOptionGroupName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DBClusterOptionGroupStatus) SetStatus(v string) *DBClusterOptionGroupStatus {
	s.Status = &v
	return s
}

// Contains the result of a successful invocation of the CreateDBClusterParameterGroup
// or CopyDBClusterParameterGroup action.
//
// This data type is used as a request parameter in the DeleteDBClusterParameterGroup
// action, and as a response element in the DescribeDBClusterParameterGroups
// action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DBClusterParameterGroup
type DBClusterParameterGroup struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the DB cluster parameter group.
	DBClusterParameterGroupArn *string `type:"string"`

	// Provides the name of the DB cluster parameter group.
	DBClusterParameterGroupName *string `type:"string"`

	// Provides the name of the DB parameter group family that this DB cluster parameter
	// group is compatible with.
	DBParameterGroupFamily *string `type:"string"`

	// Provides the customer-specified description for this DB cluster parameter
	// group.
	Description *string `type:"string"`
}

// String returns the string representation
func (s DBClusterParameterGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBClusterParameterGroup) GoString() string {
	return s.String()
}

// SetDBClusterParameterGroupArn sets the DBClusterParameterGroupArn field's value.
func (s *DBClusterParameterGroup) SetDBClusterParameterGroupArn(v string) *DBClusterParameterGroup {
	s.DBClusterParameterGroupArn = &v
	return s
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *DBClusterParameterGroup) SetDBClusterParameterGroupName(v string) *DBClusterParameterGroup {
	s.DBClusterParameterGroupName = &v
	return s
}

// SetDBParameterGroupFamily sets the DBParameterGroupFamily field's value.
func (s *DBClusterParameterGroup) SetDBParameterGroupFamily(v string) *DBClusterParameterGroup {
	s.DBParameterGroupFamily = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DBClusterParameterGroup) SetDescription(v string) *DBClusterParameterGroup {
	s.Description = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DBClusterParameterGroupNameMessage
type DBClusterParameterGroupNameMessage struct {
	_ struct{} `type:"structure"`

	// The name of the DB cluster parameter group.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 alphanumeric characters
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	// This value is stored as a lowercase string.
	DBClusterParameterGroupName *string `type:"string"`
}

// String returns the string representation
func (s DBClusterParameterGroupNameMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBClusterParameterGroupNameMessage) GoString() string {
	return s.String()
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *DBClusterParameterGroupNameMessage) SetDBClusterParameterGroupName(v string) *DBClusterParameterGroupNameMessage {
	s.DBClusterParameterGroupName = &v
	return s
}

// Describes an AWS Identity and Access Management (IAM) role that is associated
// with a DB cluster.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DBClusterRole
type DBClusterRole struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role that is associated with the
	// DB cluster.
	RoleArn *string `type:"string"`

	// Describes the state of association between the IAM role and the DB cluster.
	// The Status property returns one of the following values:
	//
	//    * ACTIVE - the IAM role ARN is associated with the DB cluster and can
	//    be used to access other AWS services on your behalf.
	//
	//    * PENDING - the IAM role ARN is being associated with the DB cluster.
	//
	//    * INVALID - the IAM role ARN is associated with the DB cluster, but the
	//    DB cluster is unable to assume the IAM role in order to access other AWS
	//    services on your behalf.
	Status *string `type:"string"`
}

// String returns the string representation
func (s DBClusterRole) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBClusterRole) GoString() string {
	return s.String()
}

// SetRoleArn sets the RoleArn field's value.
func (s *DBClusterRole) SetRoleArn(v string) *DBClusterRole {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DBClusterRole) SetStatus(v string) *DBClusterRole {
	s.Status = &v
	return s
}

// Contains the result of a successful invocation of the following actions:
//
//    * CreateDBClusterSnapshot
//
//    * DeleteDBClusterSnapshot
//
// This data type is used as a response element in the DescribeDBClusterSnapshots
// action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DBClusterSnapshot
type DBClusterSnapshot struct {
	_ struct{} `type:"structure"`

	// Specifies the allocated storage size in gigabytes (GB).
	AllocatedStorage *int64 `type:"integer"`

	// Provides the list of EC2 Availability Zones that instances in the DB cluster
	// snapshot can be restored in.
	AvailabilityZones []*string `locationNameList:"AvailabilityZone" type:"list"`

	// Specifies the time when the DB cluster was created, in Universal Coordinated
	// Time (UTC).
	ClusterCreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Specifies the DB cluster identifier of the DB cluster that this DB cluster
	// snapshot was created from.
	DBClusterIdentifier *string `type:"string"`

	// The Amazon Resource Name (ARN) for the DB cluster snapshot.
	DBClusterSnapshotArn *string `type:"string"`

	// Specifies the identifier for the DB cluster snapshot.
	DBClusterSnapshotIdentifier *string `type:"string"`

	// Specifies the name of the database engine.
	Engine *string `type:"string"`

	// Provides the version of the database engine for this DB cluster snapshot.
	EngineVersion *string `type:"string"`

	// True if mapping of AWS Identity and Access Management (IAM) accounts to database
	// accounts is enabled; otherwise false.
	IAMDatabaseAuthenticationEnabled *bool `type:"boolean"`

	// If StorageEncrypted is true, the KMS key identifier for the encrypted DB
	// cluster snapshot.
	KmsKeyId *string `type:"string"`

	// Provides the license model information for this DB cluster snapshot.
	LicenseModel *string `type:"string"`

	// Provides the master username for the DB cluster snapshot.
	MasterUsername *string `type:"string"`

	// Specifies the percentage of the estimated data that has been transferred.
	PercentProgress *int64 `type:"integer"`

	// Specifies the port that the DB cluster was listening on at the time of the
	// snapshot.
	Port *int64 `type:"integer"`

	// Provides the time when the snapshot was taken, in Universal Coordinated Time
	// (UTC).
	SnapshotCreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Provides the type of the DB cluster snapshot.
	SnapshotType *string `type:"string"`

	// If the DB cluster snapshot was copied from a source DB cluster snapshot,
	// the Amazon Resource Name (ARN) for the source DB cluster snapshot; otherwise,
	// a null value.
	SourceDBClusterSnapshotArn *string `type:"string"`

	// Specifies the status of this DB cluster snapshot.
	Status *string `type:"string"`

	// Specifies whether the DB cluster snapshot is encrypted.
	StorageEncrypted *bool `type:"boolean"`

	// Provides the VPC ID associated with the DB cluster snapshot.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DBClusterSnapshot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBClusterSnapshot) GoString() string {
	return s.String()
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *DBClusterSnapshot) SetAllocatedStorage(v int64) *DBClusterSnapshot {
	s.AllocatedStorage = &v
	return s
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *DBClusterSnapshot) SetAvailabilityZones(v []*string) *DBClusterSnapshot {
	s.AvailabilityZones = v
	return s
}

// SetClusterCreateTime sets the ClusterCreateTime field's value.
func (s *DBClusterSnapshot) SetClusterCreateTime(v time.Time) *DBClusterSnapshot {
	s.ClusterCreateTime = &v
	return s
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *DBClusterSnapshot) SetDBClusterIdentifier(v string) *DBClusterSnapshot {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBClusterSnapshotArn sets the DBClusterSnapshotArn field's value.
func (s *DBClusterSnapshot) SetDBClusterSnapshotArn(v string) *DBClusterSnapshot {
	s.DBClusterSnapshotArn = &v
	return s
}

// SetDBClusterSnapshotIdentifier sets the DBClusterSnapshotIdentifier field's value.
func (s *DBClusterSnapshot) SetDBClusterSnapshotIdentifier(v string) *DBClusterSnapshot {
	s.DBClusterSnapshotIdentifier = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *DBClusterSnapshot) SetEngine(v string) *DBClusterSnapshot {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *DBClusterSnapshot) SetEngineVersion(v string) *DBClusterSnapshot {
	s.EngineVersion = &v
	return s
}

// SetIAMDatabaseAuthenticationEnabled sets the IAMDatabaseAuthenticationEnabled field's value.
func (s *DBClusterSnapshot) SetIAMDatabaseAuthenticationEnabled(v bool) *DBClusterSnapshot {
	s.IAMDatabaseAuthenticationEnabled = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *DBClusterSnapshot) SetKmsKeyId(v string) *DBClusterSnapshot {
	s.KmsKeyId = &v
	return s
}

// SetLicenseModel sets the LicenseModel field's value.
func (s *DBClusterSnapshot) SetLicenseModel(v string) *DBClusterSnapshot {
	s.LicenseModel = &v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *DBClusterSnapshot) SetMasterUsername(v string) *DBClusterSnapshot {
	s.MasterUsername = &v
	return s
}

// SetPercentProgress sets the PercentProgress field's value.
func (s *DBClusterSnapshot) SetPercentProgress(v int64) *DBClusterSnapshot {
	s.PercentProgress = &v
	return s
}

// SetPort sets the Port field's value.
func (s *DBClusterSnapshot) SetPort(v int64) *DBClusterSnapshot {
	s.Port = &v
	return s
}

// SetSnapshotCreateTime sets the SnapshotCreateTime field's value.
func (s *DBClusterSnapshot) SetSnapshotCreateTime(v time.Time) *DBClusterSnapshot {
	s.SnapshotCreateTime = &v
	return s
}

// SetSnapshotType sets the SnapshotType field's value.
func (s *DBClusterSnapshot) SetSnapshotType(v string) *DBClusterSnapshot {
	s.SnapshotType = &v
	return s
}

// SetSourceDBClusterSnapshotArn sets the SourceDBClusterSnapshotArn field's value.
func (s *DBClusterSnapshot) SetSourceDBClusterSnapshotArn(v string) *DBClusterSnapshot {
	s.SourceDBClusterSnapshotArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DBClusterSnapshot) SetStatus(v string) *DBClusterSnapshot {
	s.Status = &v
	return s
}

// SetStorageEncrypted sets the StorageEncrypted field's value.
func (s *DBClusterSnapshot) SetStorageEncrypted(v bool) *DBClusterSnapshot {
	s.StorageEncrypted = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *DBClusterSnapshot) SetVpcId(v string) *DBClusterSnapshot {
	s.VpcId = &v
	return s
}

// Contains the name and values of a manual DB cluster snapshot attribute.
//
// Manual DB cluster snapshot attributes are used to authorize other AWS accounts
// to restore a manual DB cluster snapshot. For more information, see the ModifyDBClusterSnapshotAttribute
// API action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DBClusterSnapshotAttribute
type DBClusterSnapshotAttribute struct {
	_ struct{} `type:"structure"`

	// The name of the manual DB cluster snapshot attribute.
	//
	// The attribute named restore refers to the list of AWS accounts that have
	// permission to copy or restore the manual DB cluster snapshot. For more information,
	// see the ModifyDBClusterSnapshotAttribute API action.
	AttributeName *string `type:"string"`

	// The value(s) for the manual DB cluster snapshot attribute.
	//
	// If the AttributeName field is set to restore, then this element returns a
	// list of IDs of the AWS accounts that are authorized to copy or restore the
	// manual DB cluster snapshot. If a value of all is in the list, then the manual
	// DB cluster snapshot is public and available for any AWS account to copy or
	// restore.
	AttributeValues []*string `locationNameList:"AttributeValue" type:"list"`
}

// String returns the string representation
func (s DBClusterSnapshotAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBClusterSnapshotAttribute) GoString() string {
	return s.String()
}

// SetAttributeName sets the AttributeName field's value.
func (s *DBClusterSnapshotAttribute) SetAttributeName(v string) *DBClusterSnapshotAttribute {
	s.AttributeName = &v
	return s
}

// SetAttributeValues sets the AttributeValues field's value.
func (s *DBClusterSnapshotAttribute) SetAttributeValues(v []*string) *DBClusterSnapshotAttribute {
	s.AttributeValues = v
	return s
}

// Contains the results of a successful call to the DescribeDBClusterSnapshotAttributes
// API action.
//
// Manual DB cluster snapshot attributes are used to authorize other AWS accounts
// to copy or restore a manual DB cluster snapshot. For more information, see
// the ModifyDBClusterSnapshotAttribute API action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DBClusterSnapshotAttributesResult
type DBClusterSnapshotAttributesResult struct {
	_ struct{} `type:"structure"`

	// The list of attributes and values for the manual DB cluster snapshot.
	DBClusterSnapshotAttributes []*DBClusterSnapshotAttribute `locationNameList:"DBClusterSnapshotAttribute" type:"list"`

	// The identifier of the manual DB cluster snapshot that the attributes apply
	// to.
	DBClusterSnapshotIdentifier *string `type:"string"`
}

// String returns the string representation
func (s DBClusterSnapshotAttributesResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBClusterSnapshotAttributesResult) GoString() string {
	return s.String()
}

// SetDBClusterSnapshotAttributes sets the DBClusterSnapshotAttributes field's value.
func (s *DBClusterSnapshotAttributesResult) SetDBClusterSnapshotAttributes(v []*DBClusterSnapshotAttribute) *DBClusterSnapshotAttributesResult {
	s.DBClusterSnapshotAttributes = v
	return s
}

// SetDBClusterSnapshotIdentifier sets the DBClusterSnapshotIdentifier field's value.
func (s *DBClusterSnapshotAttributesResult) SetDBClusterSnapshotIdentifier(v string) *DBClusterSnapshotAttributesResult {
	s.DBClusterSnapshotIdentifier = &v
	return s
}

// This data type is used as a response element in the action DescribeDBEngineVersions.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DBEngineVersion
type DBEngineVersion struct {
	_ struct{} `type:"structure"`

	// The description of the database engine.
	DBEngineDescription *string `type:"string"`

	// The description of the database engine version.
	DBEngineVersionDescription *string `type:"string"`

	// The name of the DB parameter group family for the database engine.
	DBParameterGroupFamily *string `type:"string"`

	// The default character set for new instances of this engine version, if the
	// CharacterSetName parameter of the CreateDBInstance API is not specified.
	DefaultCharacterSet *CharacterSet `type:"structure"`

	// The name of the database engine.
	Engine *string `type:"string"`

	// The version number of the database engine.
	EngineVersion *string `type:"string"`

	// A list of the character sets supported by this engine for the CharacterSetName
	// parameter of the CreateDBInstance action.
	SupportedCharacterSets []*CharacterSet `locationNameList:"CharacterSet" type:"list"`

	// A list of the time zones supported by this engine for the Timezone parameter
	// of the CreateDBInstance action.
	SupportedTimezones []*Timezone `locationNameList:"Timezone" type:"list"`

	// A list of engine versions that this database engine version can be upgraded
	// to.
	ValidUpgradeTarget []*UpgradeTarget `locationNameList:"UpgradeTarget" type:"list"`
}

// String returns the string representation
func (s DBEngineVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBEngineVersion) GoString() string {
	return s.String()
}

// SetDBEngineDescription sets the DBEngineDescription field's value.
func (s *DBEngineVersion) SetDBEngineDescription(v string) *DBEngineVersion {
	s.DBEngineDescription = &v
	return s
}

// SetDBEngineVersionDescription sets the DBEngineVersionDescription field's value.
func (s *DBEngineVersion) SetDBEngineVersionDescription(v string) *DBEngineVersion {
	s.DBEngineVersionDescription = &v
	return s
}

// SetDBParameterGroupFamily sets the DBParameterGroupFamily field's value.
func (s *DBEngineVersion) SetDBParameterGroupFamily(v string) *DBEngineVersion {
	s.DBParameterGroupFamily = &v
	return s
}

// SetDefaultCharacterSet sets the DefaultCharacterSet field's value.
func (s *DBEngineVersion) SetDefaultCharacterSet(v *CharacterSet) *DBEngineVersion {
	s.DefaultCharacterSet = v
	return s
}

// SetEngine sets the Engine field's value.
func (s *DBEngineVersion) SetEngine(v string) *DBEngineVersion {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *DBEngineVersion) SetEngineVersion(v string) *DBEngineVersion {
	s.EngineVersion = &v
	return s
}

// SetSupportedCharacterSets sets the SupportedCharacterSets field's value.
func (s *DBEngineVersion) SetSupportedCharacterSets(v []*CharacterSet) *DBEngineVersion {
	s.SupportedCharacterSets = v
	return s
}

// SetSupportedTimezones sets the SupportedTimezones field's value.
func (s *DBEngineVersion) SetSupportedTimezones(v []*Timezone) *DBEngineVersion {
	s.SupportedTimezones = v
	return s
}

// SetValidUpgradeTarget sets the ValidUpgradeTarget field's value.
func (s *DBEngineVersion) SetValidUpgradeTarget(v []*UpgradeTarget) *DBEngineVersion {
	s.ValidUpgradeTarget = v
	return s
}

// Contains the result of a successful invocation of the following actions:
//
//    * CreateDBInstance
//
//    * DeleteDBInstance
//
//    * ModifyDBInstance
//
//    * StopDBInstance
//
//    * StartDBInstance
//
// This data type is used as a response element in the DescribeDBInstances action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DBInstance
type DBInstance struct {
	_ struct{} `type:"structure"`

	// Specifies the allocated storage size specified in gigabytes.
	AllocatedStorage *int64 `type:"integer"`

	// Indicates that minor version patches are applied automatically.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// Specifies the name of the Availability Zone the DB instance is located in.
	AvailabilityZone *string `type:"string"`

	// Specifies the number of days for which automatic DB snapshots are retained.
	BackupRetentionPeriod *int64 `type:"integer"`

	// The identifier of the CA certificate for this DB instance.
	CACertificateIdentifier *string `type:"string"`

	// If present, specifies the name of the character set that this instance is
	// associated with.
	CharacterSetName *string `type:"string"`

	// Specifies whether tags are copied from the DB instance to snapshots of the
	// DB instance.
	CopyTagsToSnapshot *bool `type:"boolean"`

	// If the DB instance is a member of a DB cluster, contains the name of the
	// DB cluster that the DB instance is a member of.
	DBClusterIdentifier *string `type:"string"`

	// The Amazon Resource Name (ARN) for the DB instance.
	DBInstanceArn *string `type:"string"`

	// Contains the name of the compute and memory capacity class of the DB instance.
	DBInstanceClass *string `type:"string"`

	// Contains a user-supplied database identifier. This identifier is the unique
	// key that identifies a DB instance.
	DBInstanceIdentifier *string `type:"string"`

	// Specifies the current state of this database.
	DBInstanceStatus *string `type:"string"`

	// The meaning of this parameter differs according to the database engine you
	// use. For example, this value returns MySQL, MariaDB, or PostgreSQL information
	// when returning values from CreateDBInstanceReadReplica since Read Replicas
	// are only supported for these engines.
	//
	// MySQL, MariaDB, SQL Server, PostgreSQL
	//
	// Contains the name of the initial database of this instance that was provided
	// at create time, if one was specified when the DB instance was created. This
	// same name is returned for the life of the DB instance.
	//
	// Type: String
	//
	// Oracle
	//
	// Contains the Oracle System ID (SID) of the created DB instance. Not shown
	// when the returned parameters do not apply to an Oracle DB instance.
	DBName *string `type:"string"`

	// Provides the list of DB parameter groups applied to this DB instance.
	DBParameterGroups []*DBParameterGroupStatus `locationNameList:"DBParameterGroup" type:"list"`

	// Provides List of DB security group elements containing only DBSecurityGroup.Name
	// and DBSecurityGroup.Status subelements.
	DBSecurityGroups []*DBSecurityGroupMembership `locationNameList:"DBSecurityGroup" type:"list"`

	// Specifies information on the subnet group associated with the DB instance,
	// including the name, description, and subnets in the subnet group.
	DBSubnetGroup *DBSubnetGroup `type:"structure"`

	// Specifies the port that the DB instance listens on. If the DB instance is
	// part of a DB cluster, this can be a different port than the DB cluster port.
	DbInstancePort *int64 `type:"integer"`

	// The region-unique, immutable identifier for the DB instance. This identifier
	// is found in AWS CloudTrail log entries whenever the KMS key for the DB instance
	// is accessed.
	DbiResourceId *string `type:"string"`

	// The Active Directory Domain membership records associated with the DB instance.
	DomainMemberships []*DomainMembership `locationNameList:"DomainMembership" type:"list"`

	// Specifies the connection endpoint.
	Endpoint *Endpoint `type:"structure"`

	// Provides the name of the database engine to be used for this DB instance.
	Engine *string `type:"string"`

	// Indicates the database engine version.
	EngineVersion *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon CloudWatch Logs log stream that
	// receives the Enhanced Monitoring metrics data for the DB instance.
	EnhancedMonitoringResourceArn *string `type:"string"`

	// True if mapping of AWS Identity and Access Management (IAM) accounts to database
	// accounts is enabled; otherwise false.
	//
	// IAM database authentication can be enabled for the following database engines
	//
	//    * For MySQL 5.6, minor version 5.6.34 or higher
	//
	//    * For MySQL 5.7, minor version 5.7.16 or higher
	//
	//    * Aurora 5.6 or higher. To enable IAM database authentication for Aurora,
	//    see DBCluster Type.
	IAMDatabaseAuthenticationEnabled *bool `type:"boolean"`

	// Provides the date and time the DB instance was created.
	InstanceCreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Specifies the Provisioned IOPS (I/O operations per second) value.
	Iops *int64 `type:"integer"`

	// If StorageEncrypted is true, the KMS key identifier for the encrypted DB
	// instance.
	KmsKeyId *string `type:"string"`

	// Specifies the latest time to which a database can be restored with point-in-time
	// restore.
	LatestRestorableTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// License model information for this DB instance.
	LicenseModel *string `type:"string"`

	// Contains the master username for the DB instance.
	MasterUsername *string `type:"string"`

	// The interval, in seconds, between points when Enhanced Monitoring metrics
	// are collected for the DB instance.
	MonitoringInterval *int64 `type:"integer"`

	// The ARN for the IAM role that permits RDS to send Enhanced Monitoring metrics
	// to CloudWatch Logs.
	MonitoringRoleArn *string `type:"string"`

	// Specifies if the DB instance is a Multi-AZ deployment.
	MultiAZ *bool `type:"boolean"`

	// Provides the list of option group memberships for this DB instance.
	OptionGroupMemberships []*OptionGroupMembership `locationNameList:"OptionGroupMembership" type:"list"`

	// Specifies that changes to the DB instance are pending. This element is only
	// included when changes are pending. Specific changes are identified by subelements.
	PendingModifiedValues *PendingModifiedValues `type:"structure"`

	// Specifies the daily time range during which automated backups are created
	// if automated backups are enabled, as determined by the BackupRetentionPeriod.
	PreferredBackupWindow *string `type:"string"`

	// Specifies the weekly time range during which system maintenance can occur,
	// in Universal Coordinated Time (UTC).
	PreferredMaintenanceWindow *string `type:"string"`

	// A value that specifies the order in which an Aurora Replica is promoted to
	// the primary instance after a failure of the existing primary instance. For
	// more information, see  Fault Tolerance for an Aurora DB Cluster (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Aurora.Managing.html#Aurora.Managing.FaultTolerance).
	PromotionTier *int64 `type:"integer"`

	// Specifies the accessibility options for the DB instance. A value of true
	// specifies an Internet-facing instance with a publicly resolvable DNS name,
	// which resolves to a public IP address. A value of false specifies an internal
	// instance with a DNS name that resolves to a private IP address.
	//
	// Default: The default behavior varies depending on whether a VPC has been
	// requested or not. The following list shows the default behavior in each case.
	//
	//    * Default VPC:true
	//
	//    * VPC:false
	//
	// If no DB subnet group has been specified as part of the request and the PubliclyAccessible
	// value has not been set, the DB instance will be publicly accessible. If a
	// specific DB subnet group has been specified as part of the request and the
	// PubliclyAccessible value has not been set, the DB instance will be private.
	PubliclyAccessible *bool `type:"boolean"`

	// Contains one or more identifiers of Aurora DB clusters that are Read Replicas
	// of this DB instance.
	ReadReplicaDBClusterIdentifiers []*string `locationNameList:"ReadReplicaDBClusterIdentifier" type:"list"`

	// Contains one or more identifiers of the Read Replicas associated with this
	// DB instance.
	ReadReplicaDBInstanceIdentifiers []*string `locationNameList:"ReadReplicaDBInstanceIdentifier" type:"list"`

	// Contains the identifier of the source DB instance if this DB instance is
	// a Read Replica.
	ReadReplicaSourceDBInstanceIdentifier *string `type:"string"`

	// If present, specifies the name of the secondary Availability Zone for a DB
	// instance with multi-AZ support.
	SecondaryAvailabilityZone *string `type:"string"`

	// The status of a Read Replica. If the instance is not a Read Replica, this
	// will be blank.
	StatusInfos []*DBInstanceStatusInfo `locationNameList:"DBInstanceStatusInfo" type:"list"`

	// Specifies whether the DB instance is encrypted.
	StorageEncrypted *bool `type:"boolean"`

	// Specifies the storage type associated with DB instance.
	StorageType *string `type:"string"`

	// The ARN from the key store with which the instance is associated for TDE
	// encryption.
	TdeCredentialArn *string `type:"string"`

	// The time zone of the DB instance. In most cases, the Timezone element is
	// empty. Timezone content appears only for Microsoft SQL Server DB instances
	// that were created with a time zone specified.
	Timezone *string `type:"string"`

	// Provides a list of VPC security group elements that the DB instance belongs
	// to.
	VpcSecurityGroups []*VpcSecurityGroupMembership `locationNameList:"VpcSecurityGroupMembership" type:"list"`
}

// String returns the string representation
func (s DBInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBInstance) GoString() string {
	return s.String()
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *DBInstance) SetAllocatedStorage(v int64) *DBInstance {
	s.AllocatedStorage = &v
	return s
}

// SetAutoMinorVersionUpgrade sets the AutoMinorVersionUpgrade field's value.
func (s *DBInstance) SetAutoMinorVersionUpgrade(v bool) *DBInstance {
	s.AutoMinorVersionUpgrade = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *DBInstance) SetAvailabilityZone(v string) *DBInstance {
	s.AvailabilityZone = &v
	return s
}

// SetBackupRetentionPeriod sets the BackupRetentionPeriod field's value.
func (s *DBInstance) SetBackupRetentionPeriod(v int64) *DBInstance {
	s.BackupRetentionPeriod = &v
	return s
}

// SetCACertificateIdentifier sets the CACertificateIdentifier field's value.
func (s *DBInstance) SetCACertificateIdentifier(v string) *DBInstance {
	s.CACertificateIdentifier = &v
	return s
}

// SetCharacterSetName sets the CharacterSetName field's value.
func (s *DBInstance) SetCharacterSetName(v string) *DBInstance {
	s.CharacterSetName = &v
	return s
}

// SetCopyTagsToSnapshot sets the CopyTagsToSnapshot field's value.
func (s *DBInstance) SetCopyTagsToSnapshot(v bool) *DBInstance {
	s.CopyTagsToSnapshot = &v
	return s
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *DBInstance) SetDBClusterIdentifier(v string) *DBInstance {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBInstanceArn sets the DBInstanceArn field's value.
func (s *DBInstance) SetDBInstanceArn(v string) *DBInstance {
	s.DBInstanceArn = &v
	return s
}

// SetDBInstanceClass sets the DBInstanceClass field's value.
func (s *DBInstance) SetDBInstanceClass(v string) *DBInstance {
	s.DBInstanceClass = &v
	return s
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *DBInstance) SetDBInstanceIdentifier(v string) *DBInstance {
	s.DBInstanceIdentifier = &v
	return s
}

// SetDBInstanceStatus sets the DBInstanceStatus field's value.
func (s *DBInstance) SetDBInstanceStatus(v string) *DBInstance {
	s.DBInstanceStatus = &v
	return s
}

// SetDBName sets the DBName field's value.
func (s *DBInstance) SetDBName(v string) *DBInstance {
	s.DBName = &v
	return s
}

// SetDBParameterGroups sets the DBParameterGroups field's value.
func (s *DBInstance) SetDBParameterGroups(v []*DBParameterGroupStatus) *DBInstance {
	s.DBParameterGroups = v
	return s
}

// SetDBSecurityGroups sets the DBSecurityGroups field's value.
func (s *DBInstance) SetDBSecurityGroups(v []*DBSecurityGroupMembership) *DBInstance {
	s.DBSecurityGroups = v
	return s
}

// SetDBSubnetGroup sets the DBSubnetGroup field's value.
func (s *DBInstance) SetDBSubnetGroup(v *DBSubnetGroup) *DBInstance {
	s.DBSubnetGroup = v
	return s
}

// SetDbInstancePort sets the DbInstancePort field's value.
func (s *DBInstance) SetDbInstancePort(v int64) *DBInstance {
	s.DbInstancePort = &v
	return s
}

// SetDbiResourceId sets the DbiResourceId field's value.
func (s *DBInstance) SetDbiResourceId(v string) *DBInstance {
	s.DbiResourceId = &v
	return s
}

// SetDomainMemberships sets the DomainMemberships field's value.
func (s *DBInstance) SetDomainMemberships(v []*DomainMembership) *DBInstance {
	s.DomainMemberships = v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *DBInstance) SetEndpoint(v *Endpoint) *DBInstance {
	s.Endpoint = v
	return s
}

// SetEngine sets the Engine field's value.
func (s *DBInstance) SetEngine(v string) *DBInstance {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *DBInstance) SetEngineVersion(v string) *DBInstance {
	s.EngineVersion = &v
	return s
}

// SetEnhancedMonitoringResourceArn sets the EnhancedMonitoringResourceArn field's value.
func (s *DBInstance) SetEnhancedMonitoringResourceArn(v string) *DBInstance {
	s.EnhancedMonitoringResourceArn = &v
	return s
}

// SetIAMDatabaseAuthenticationEnabled sets the IAMDatabaseAuthenticationEnabled field's value.
func (s *DBInstance) SetIAMDatabaseAuthenticationEnabled(v bool) *DBInstance {
	s.IAMDatabaseAuthenticationEnabled = &v
	return s
}

// SetInstanceCreateTime sets the InstanceCreateTime field's value.
func (s *DBInstance) SetInstanceCreateTime(v time.Time) *DBInstance {
	s.InstanceCreateTime = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *DBInstance) SetIops(v int64) *DBInstance {
	s.Iops = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *DBInstance) SetKmsKeyId(v string) *DBInstance {
	s.KmsKeyId = &v
	return s
}

// SetLatestRestorableTime sets the LatestRestorableTime field's value.
func (s *DBInstance) SetLatestRestorableTime(v time.Time) *DBInstance {
	s.LatestRestorableTime = &v
	return s
}

// SetLicenseModel sets the LicenseModel field's value.
func (s *DBInstance) SetLicenseModel(v string) *DBInstance {
	s.LicenseModel = &v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *DBInstance) SetMasterUsername(v string) *DBInstance {
	s.MasterUsername = &v
	return s
}

// SetMonitoringInterval sets the MonitoringInterval field's value.
func (s *DBInstance) SetMonitoringInterval(v int64) *DBInstance {
	s.MonitoringInterval = &v
	return s
}

// SetMonitoringRoleArn sets the MonitoringRoleArn field's value.
func (s *DBInstance) SetMonitoringRoleArn(v string) *DBInstance {
	s.MonitoringRoleArn = &v
	return s
}

// SetMultiAZ sets the MultiAZ field's value.
func (s *DBInstance) SetMultiAZ(v bool) *DBInstance {
	s.MultiAZ = &v
	return s
}

// SetOptionGroupMemberships sets the OptionGroupMemberships field's value.
func (s *DBInstance) SetOptionGroupMemberships(v []*OptionGroupMembership) *DBInstance {
	s.OptionGroupMemberships = v
	return s
}

// SetPendingModifiedValues sets the PendingModifiedValues field's value.
func (s *DBInstance) SetPendingModifiedValues(v *PendingModifiedValues) *DBInstance {
	s.PendingModifiedValues = v
	return s
}

// SetPreferredBackupWindow sets the PreferredBackupWindow field's value.
func (s *DBInstance) SetPreferredBackupWindow(v string) *DBInstance {
	s.PreferredBackupWindow = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *DBInstance) SetPreferredMaintenanceWindow(v string) *DBInstance {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetPromotionTier sets the PromotionTier field's value.
func (s *DBInstance) SetPromotionTier(v int64) *DBInstance {
	s.PromotionTier = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *DBInstance) SetPubliclyAccessible(v bool) *DBInstance {
	s.PubliclyAccessible = &v
	return s
}

// SetReadReplicaDBClusterIdentifiers sets the ReadReplicaDBClusterIdentifiers field's value.
func (s *DBInstance) SetReadReplicaDBClusterIdentifiers(v []*string) *DBInstance {
	s.ReadReplicaDBClusterIdentifiers = v
	return s
}

// SetReadReplicaDBInstanceIdentifiers sets the ReadReplicaDBInstanceIdentifiers field's value.
func (s *DBInstance) SetReadReplicaDBInstanceIdentifiers(v []*string) *DBInstance {
	s.ReadReplicaDBInstanceIdentifiers = v
	return s
}

// SetReadReplicaSourceDBInstanceIdentifier sets the ReadReplicaSourceDBInstanceIdentifier field's value.
func (s *DBInstance) SetReadReplicaSourceDBInstanceIdentifier(v string) *DBInstance {
	s.ReadReplicaSourceDBInstanceIdentifier = &v
	return s
}

// SetSecondaryAvailabilityZone sets the SecondaryAvailabilityZone field's value.
func (s *DBInstance) SetSecondaryAvailabilityZone(v string) *DBInstance {
	s.SecondaryAvailabilityZone = &v
	return s
}

// SetStatusInfos sets the StatusInfos field's value.
func (s *DBInstance) SetStatusInfos(v []*DBInstanceStatusInfo) *DBInstance {
	s.StatusInfos = v
	return s
}

// SetStorageEncrypted sets the StorageEncrypted field's value.
func (s *DBInstance) SetStorageEncrypted(v bool) *DBInstance {
	s.StorageEncrypted = &v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *DBInstance) SetStorageType(v string) *DBInstance {
	s.StorageType = &v
	return s
}

// SetTdeCredentialArn sets the TdeCredentialArn field's value.
func (s *DBInstance) SetTdeCredentialArn(v string) *DBInstance {
	s.TdeCredentialArn = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *DBInstance) SetTimezone(v string) *DBInstance {
	s.Timezone = &v
	return s
}

// SetVpcSecurityGroups sets the VpcSecurityGroups field's value.
func (s *DBInstance) SetVpcSecurityGroups(v []*VpcSecurityGroupMembership) *DBInstance {
	s.VpcSecurityGroups = v
	return s
}

// Provides a list of status information for a DB instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DBInstanceStatusInfo
type DBInstanceStatusInfo struct {
	_ struct{} `type:"structure"`

	// Details of the error if there is an error for the instance. If the instance
	// is not in an error state, this value is blank.
	Message *string `type:"string"`

	// Boolean value that is true if the instance is operating normally, or false
	// if the instance is in an error state.
	Normal *bool `type:"boolean"`

	// Status of the DB instance. For a StatusType of read replica, the values can
	// be replicating, error, stopped, or terminated.
	Status *string `type:"string"`

	// This value is currently "read replication."
	StatusType *string `type:"string"`
}

// String returns the string representation
func (s DBInstanceStatusInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBInstanceStatusInfo) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *DBInstanceStatusInfo) SetMessage(v string) *DBInstanceStatusInfo {
	s.Message = &v
	return s
}

// SetNormal sets the Normal field's value.
func (s *DBInstanceStatusInfo) SetNormal(v bool) *DBInstanceStatusInfo {
	s.Normal = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DBInstanceStatusInfo) SetStatus(v string) *DBInstanceStatusInfo {
	s.Status = &v
	return s
}

// SetStatusType sets the StatusType field's value.
func (s *DBInstanceStatusInfo) SetStatusType(v string) *DBInstanceStatusInfo {
	s.StatusType = &v
	return s
}

// Contains the result of a successful invocation of the CreateDBParameterGroup
// action.
//
// This data type is used as a request parameter in the DeleteDBParameterGroup
// action, and as a response element in the DescribeDBParameterGroups action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DBParameterGroup
type DBParameterGroup struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the DB parameter group.
	DBParameterGroupArn *string `type:"string"`

	// Provides the name of the DB parameter group family that this DB parameter
	// group is compatible with.
	DBParameterGroupFamily *string `type:"string"`

	// Provides the name of the DB parameter group.
	DBParameterGroupName *string `type:"string"`

	// Provides the customer-specified description for this DB parameter group.
	Description *string `type:"string"`
}

// String returns the string representation
func (s DBParameterGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBParameterGroup) GoString() string {
	return s.String()
}

// SetDBParameterGroupArn sets the DBParameterGroupArn field's value.
func (s *DBParameterGroup) SetDBParameterGroupArn(v string) *DBParameterGroup {
	s.DBParameterGroupArn = &v
	return s
}

// SetDBParameterGroupFamily sets the DBParameterGroupFamily field's value.
func (s *DBParameterGroup) SetDBParameterGroupFamily(v string) *DBParameterGroup {
	s.DBParameterGroupFamily = &v
	return s
}

// SetDBParameterGroupName sets the DBParameterGroupName field's value.
func (s *DBParameterGroup) SetDBParameterGroupName(v string) *DBParameterGroup {
	s.DBParameterGroupName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DBParameterGroup) SetDescription(v string) *DBParameterGroup {
	s.Description = &v
	return s
}

// Contains the result of a successful invocation of the ModifyDBParameterGroup
// or ResetDBParameterGroup action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DBParameterGroupNameMessage
type DBParameterGroupNameMessage struct {
	_ struct{} `type:"structure"`

	// Provides the name of the DB parameter group.
	DBParameterGroupName *string `type:"string"`
}

// String returns the string representation
func (s DBParameterGroupNameMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBParameterGroupNameMessage) GoString() string {
	return s.String()
}

// SetDBParameterGroupName sets the DBParameterGroupName field's value.
func (s *DBParameterGroupNameMessage) SetDBParameterGroupName(v string) *DBParameterGroupNameMessage {
	s.DBParameterGroupName = &v
	return s
}

// The status of the DB parameter group.
//
// This data type is used as a response element in the following actions:
//
//    * CreateDBInstance
//
//    * CreateDBInstanceReadReplica
//
//    * DeleteDBInstance
//
//    * ModifyDBInstance
//
//    * RebootDBInstance
//
//    * RestoreDBInstanceFromDBSnapshot
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DBParameterGroupStatus
type DBParameterGroupStatus struct {
	_ struct{} `type:"structure"`

	// The name of the DP parameter group.
	DBParameterGroupName *string `type:"string"`

	// The status of parameter updates.
	ParameterApplyStatus *string `type:"string"`
}

// String returns the string representation
func (s DBParameterGroupStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBParameterGroupStatus) GoString() string {
	return s.String()
}

// SetDBParameterGroupName sets the DBParameterGroupName field's value.
func (s *DBParameterGroupStatus) SetDBParameterGroupName(v string) *DBParameterGroupStatus {
	s.DBParameterGroupName = &v
	return s
}

// SetParameterApplyStatus sets the ParameterApplyStatus field's value.
func (s *DBParameterGroupStatus) SetParameterApplyStatus(v string) *DBParameterGroupStatus {
	s.ParameterApplyStatus = &v
	return s
}

// Contains the result of a successful invocation of the following actions:
//
//    * DescribeDBSecurityGroups
//
//    * AuthorizeDBSecurityGroupIngress
//
//    * CreateDBSecurityGroup
//
//    * RevokeDBSecurityGroupIngress
//
// This data type is used as a response element in the DescribeDBSecurityGroups
// action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DBSecurityGroup
type DBSecurityGroup struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the DB security group.
	DBSecurityGroupArn *string `type:"string"`

	// Provides the description of the DB security group.
	DBSecurityGroupDescription *string `type:"string"`

	// Specifies the name of the DB security group.
	DBSecurityGroupName *string `type:"string"`

	// Contains a list of EC2SecurityGroup elements.
	EC2SecurityGroups []*EC2SecurityGroup `locationNameList:"EC2SecurityGroup" type:"list"`

	// Contains a list of IPRange elements.
	IPRanges []*IPRange `locationNameList:"IPRange" type:"list"`

	// Provides the AWS ID of the owner of a specific DB security group.
	OwnerId *string `type:"string"`

	// Provides the VpcId of the DB security group.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DBSecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBSecurityGroup) GoString() string {
	return s.String()
}

// SetDBSecurityGroupArn sets the DBSecurityGroupArn field's value.
func (s *DBSecurityGroup) SetDBSecurityGroupArn(v string) *DBSecurityGroup {
	s.DBSecurityGroupArn = &v
	return s
}

// SetDBSecurityGroupDescription sets the DBSecurityGroupDescription field's value.
func (s *DBSecurityGroup) SetDBSecurityGroupDescription(v string) *DBSecurityGroup {
	s.DBSecurityGroupDescription = &v
	return s
}

// SetDBSecurityGroupName sets the DBSecurityGroupName field's value.
func (s *DBSecurityGroup) SetDBSecurityGroupName(v string) *DBSecurityGroup {
	s.DBSecurityGroupName = &v
	return s
}

// SetEC2SecurityGroups sets the EC2SecurityGroups field's value.
func (s *DBSecurityGroup) SetEC2SecurityGroups(v []*EC2SecurityGroup) *DBSecurityGroup {
	s.EC2SecurityGroups = v
	return s
}

// SetIPRanges sets the IPRanges field's value.
func (s *DBSecurityGroup) SetIPRanges(v []*IPRange) *DBSecurityGroup {
	s.IPRanges = v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *DBSecurityGroup) SetOwnerId(v string) *DBSecurityGroup {
	s.OwnerId = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *DBSecurityGroup) SetVpcId(v string) *DBSecurityGroup {
	s.VpcId = &v
	return s
}

// This data type is used as a response element in the following actions:
//
//    * ModifyDBInstance
//
//    * RebootDBInstance
//
//    * RestoreDBInstanceFromDBSnapshot
//
//    * RestoreDBInstanceToPointInTime
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DBSecurityGroupMembership
type DBSecurityGroupMembership struct {
	_ struct{} `type:"structure"`

	// The name of the DB security group.
	DBSecurityGroupName *string `type:"string"`

	// The status of the DB security group.
	Status *string `type:"string"`
}

// String returns the string representation
func (s DBSecurityGroupMembership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBSecurityGroupMembership) GoString() string {
	return s.String()
}

// SetDBSecurityGroupName sets the DBSecurityGroupName field's value.
func (s *DBSecurityGroupMembership) SetDBSecurityGroupName(v string) *DBSecurityGroupMembership {
	s.DBSecurityGroupName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DBSecurityGroupMembership) SetStatus(v string) *DBSecurityGroupMembership {
	s.Status = &v
	return s
}

// Contains the result of a successful invocation of the following actions:
//
//    * CreateDBSnapshot
//
//    * DeleteDBSnapshot
//
// This data type is used as a response element in the DescribeDBSnapshots action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DBSnapshot
type DBSnapshot struct {
	_ struct{} `type:"structure"`

	// Specifies the allocated storage size in gigabytes (GB).
	AllocatedStorage *int64 `type:"integer"`

	// Specifies the name of the Availability Zone the DB instance was located in
	// at the time of the DB snapshot.
	AvailabilityZone *string `type:"string"`

	// Specifies the DB instance identifier of the DB instance this DB snapshot
	// was created from.
	DBInstanceIdentifier *string `type:"string"`

	// The Amazon Resource Name (ARN) for the DB snapshot.
	DBSnapshotArn *string `type:"string"`

	// Specifies the identifier for the DB snapshot.
	DBSnapshotIdentifier *string `type:"string"`

	// Specifies whether the DB snapshot is encrypted.
	Encrypted *bool `type:"boolean"`

	// Specifies the name of the database engine.
	Engine *string `type:"string"`

	// Specifies the version of the database engine.
	EngineVersion *string `type:"string"`

	// True if mapping of AWS Identity and Access Management (IAM) accounts to database
	// accounts is enabled; otherwise false.
	IAMDatabaseAuthenticationEnabled *bool `type:"boolean"`

	// Specifies the time when the snapshot was taken, in Universal Coordinated
	// Time (UTC).
	InstanceCreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Specifies the Provisioned IOPS (I/O operations per second) value of the DB
	// instance at the time of the snapshot.
	Iops *int64 `type:"integer"`

	// If Encrypted is true, the KMS key identifier for the encrypted DB snapshot.
	KmsKeyId *string `type:"string"`

	// License model information for the restored DB instance.
	LicenseModel *string `type:"string"`

	// Provides the master username for the DB snapshot.
	MasterUsername *string `type:"string"`

	// Provides the option group name for the DB snapshot.
	OptionGroupName *string `type:"string"`

	// The percentage of the estimated data that has been transferred.
	PercentProgress *int64 `type:"integer"`

	// Specifies the port that the database engine was listening on at the time
	// of the snapshot.
	Port *int64 `type:"integer"`

	// Provides the time when the snapshot was taken, in Universal Coordinated Time
	// (UTC).
	SnapshotCreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Provides the type of the DB snapshot.
	SnapshotType *string `type:"string"`

	// The DB snapshot Amazon Resource Name (ARN) that the DB snapshot was copied
	// from. It only has value in case of cross-customer or cross-region copy.
	SourceDBSnapshotIdentifier *string `type:"string"`

	// The AWS Region that the DB snapshot was created in or copied from.
	SourceRegion *string `type:"string"`

	// Specifies the status of this DB snapshot.
	Status *string `type:"string"`

	// Specifies the storage type associated with DB snapshot.
	StorageType *string `type:"string"`

	// The ARN from the key store with which to associate the instance for TDE encryption.
	TdeCredentialArn *string `type:"string"`

	// The time zone of the DB snapshot. In most cases, the Timezone element is
	// empty. Timezone content appears only for snapshots taken from Microsoft SQL
	// Server DB instances that were created with a time zone specified.
	Timezone *string `type:"string"`

	// Provides the VPC ID associated with the DB snapshot.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DBSnapshot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBSnapshot) GoString() string {
	return s.String()
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *DBSnapshot) SetAllocatedStorage(v int64) *DBSnapshot {
	s.AllocatedStorage = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *DBSnapshot) SetAvailabilityZone(v string) *DBSnapshot {
	s.AvailabilityZone = &v
	return s
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *DBSnapshot) SetDBInstanceIdentifier(v string) *DBSnapshot {
	s.DBInstanceIdentifier = &v
	return s
}

// SetDBSnapshotArn sets the DBSnapshotArn field's value.
func (s *DBSnapshot) SetDBSnapshotArn(v string) *DBSnapshot {
	s.DBSnapshotArn = &v
	return s
}

// SetDBSnapshotIdentifier sets the DBSnapshotIdentifier field's value.
func (s *DBSnapshot) SetDBSnapshotIdentifier(v string) *DBSnapshot {
	s.DBSnapshotIdentifier = &v
	return s
}

// SetEncrypted sets the Encrypted field's value.
func (s *DBSnapshot) SetEncrypted(v bool) *DBSnapshot {
	s.Encrypted = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *DBSnapshot) SetEngine(v string) *DBSnapshot {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *DBSnapshot) SetEngineVersion(v string) *DBSnapshot {
	s.EngineVersion = &v
	return s
}

// SetIAMDatabaseAuthenticationEnabled sets the IAMDatabaseAuthenticationEnabled field's value.
func (s *DBSnapshot) SetIAMDatabaseAuthenticationEnabled(v bool) *DBSnapshot {
	s.IAMDatabaseAuthenticationEnabled = &v
	return s
}

// SetInstanceCreateTime sets the InstanceCreateTime field's value.
func (s *DBSnapshot) SetInstanceCreateTime(v time.Time) *DBSnapshot {
	s.InstanceCreateTime = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *DBSnapshot) SetIops(v int64) *DBSnapshot {
	s.Iops = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *DBSnapshot) SetKmsKeyId(v string) *DBSnapshot {
	s.KmsKeyId = &v
	return s
}

// SetLicenseModel sets the LicenseModel field's value.
func (s *DBSnapshot) SetLicenseModel(v string) *DBSnapshot {
	s.LicenseModel = &v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *DBSnapshot) SetMasterUsername(v string) *DBSnapshot {
	s.MasterUsername = &v
	return s
}

// SetOptionGroupName sets the OptionGroupName field's value.
func (s *DBSnapshot) SetOptionGroupName(v string) *DBSnapshot {
	s.OptionGroupName = &v
	return s
}

// SetPercentProgress sets the PercentProgress field's value.
func (s *DBSnapshot) SetPercentProgress(v int64) *DBSnapshot {
	s.PercentProgress = &v
	return s
}

// SetPort sets the Port field's value.
func (s *DBSnapshot) SetPort(v int64) *DBSnapshot {
	s.Port = &v
	return s
}

// SetSnapshotCreateTime sets the SnapshotCreateTime field's value.
func (s *DBSnapshot) SetSnapshotCreateTime(v time.Time) *DBSnapshot {
	s.SnapshotCreateTime = &v
	return s
}

// SetSnapshotType sets the SnapshotType field's value.
func (s *DBSnapshot) SetSnapshotType(v string) *DBSnapshot {
	s.SnapshotType = &v
	return s
}

// SetSourceDBSnapshotIdentifier sets the SourceDBSnapshotIdentifier field's value.
func (s *DBSnapshot) SetSourceDBSnapshotIdentifier(v string) *DBSnapshot {
	s.SourceDBSnapshotIdentifier = &v
	return s
}

// SetSourceRegion sets the SourceRegion field's value.
func (s *DBSnapshot) SetSourceRegion(v string) *DBSnapshot {
	s.SourceRegion = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DBSnapshot) SetStatus(v string) *DBSnapshot {
	s.Status = &v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *DBSnapshot) SetStorageType(v string) *DBSnapshot {
	s.StorageType = &v
	return s
}

// SetTdeCredentialArn sets the TdeCredentialArn field's value.
func (s *DBSnapshot) SetTdeCredentialArn(v string) *DBSnapshot {
	s.TdeCredentialArn = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *DBSnapshot) SetTimezone(v string) *DBSnapshot {
	s.Timezone = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *DBSnapshot) SetVpcId(v string) *DBSnapshot {
	s.VpcId = &v
	return s
}

// Contains the name and values of a manual DB snapshot attribute
//
// Manual DB snapshot attributes are used to authorize other AWS accounts to
// restore a manual DB snapshot. For more information, see the ModifyDBSnapshotAttribute
// API.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DBSnapshotAttribute
type DBSnapshotAttribute struct {
	_ struct{} `type:"structure"`

	// The name of the manual DB snapshot attribute.
	//
	// The attribute named restore refers to the list of AWS accounts that have
	// permission to copy or restore the manual DB cluster snapshot. For more information,
	// see the ModifyDBSnapshotAttribute API action.
	AttributeName *string `type:"string"`

	// The value or values for the manual DB snapshot attribute.
	//
	// If the AttributeName field is set to restore, then this element returns a
	// list of IDs of the AWS accounts that are authorized to copy or restore the
	// manual DB snapshot. If a value of all is in the list, then the manual DB
	// snapshot is public and available for any AWS account to copy or restore.
	AttributeValues []*string `locationNameList:"AttributeValue" type:"list"`
}

// String returns the string representation
func (s DBSnapshotAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBSnapshotAttribute) GoString() string {
	return s.String()
}

// SetAttributeName sets the AttributeName field's value.
func (s *DBSnapshotAttribute) SetAttributeName(v string) *DBSnapshotAttribute {
	s.AttributeName = &v
	return s
}

// SetAttributeValues sets the AttributeValues field's value.
func (s *DBSnapshotAttribute) SetAttributeValues(v []*string) *DBSnapshotAttribute {
	s.AttributeValues = v
	return s
}

// Contains the results of a successful call to the DescribeDBSnapshotAttributes
// API action.
//
// Manual DB snapshot attributes are used to authorize other AWS accounts to
// copy or restore a manual DB snapshot. For more information, see the ModifyDBSnapshotAttribute
// API action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DBSnapshotAttributesResult
type DBSnapshotAttributesResult struct {
	_ struct{} `type:"structure"`

	// The list of attributes and values for the manual DB snapshot.
	DBSnapshotAttributes []*DBSnapshotAttribute `locationNameList:"DBSnapshotAttribute" type:"list"`

	// The identifier of the manual DB snapshot that the attributes apply to.
	DBSnapshotIdentifier *string `type:"string"`
}

// String returns the string representation
func (s DBSnapshotAttributesResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBSnapshotAttributesResult) GoString() string {
	return s.String()
}

// SetDBSnapshotAttributes sets the DBSnapshotAttributes field's value.
func (s *DBSnapshotAttributesResult) SetDBSnapshotAttributes(v []*DBSnapshotAttribute) *DBSnapshotAttributesResult {
	s.DBSnapshotAttributes = v
	return s
}

// SetDBSnapshotIdentifier sets the DBSnapshotIdentifier field's value.
func (s *DBSnapshotAttributesResult) SetDBSnapshotIdentifier(v string) *DBSnapshotAttributesResult {
	s.DBSnapshotIdentifier = &v
	return s
}

// Contains the result of a successful invocation of the following actions:
//
//    * CreateDBSubnetGroup
//
//    * ModifyDBSubnetGroup
//
//    * DescribeDBSubnetGroups
//
//    * DeleteDBSubnetGroup
//
// This data type is used as a response element in the DescribeDBSubnetGroups
// action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DBSubnetGroup
type DBSubnetGroup struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the DB subnet group.
	DBSubnetGroupArn *string `type:"string"`

	// Provides the description of the DB subnet group.
	DBSubnetGroupDescription *string `type:"string"`

	// The name of the DB subnet group.
	DBSubnetGroupName *string `type:"string"`

	// Provides the status of the DB subnet group.
	SubnetGroupStatus *string `type:"string"`

	// Contains a list of Subnet elements.
	Subnets []*Subnet `locationNameList:"Subnet" type:"list"`

	// Provides the VpcId of the DB subnet group.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DBSubnetGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DBSubnetGroup) GoString() string {
	return s.String()
}

// SetDBSubnetGroupArn sets the DBSubnetGroupArn field's value.
func (s *DBSubnetGroup) SetDBSubnetGroupArn(v string) *DBSubnetGroup {
	s.DBSubnetGroupArn = &v
	return s
}

// SetDBSubnetGroupDescription sets the DBSubnetGroupDescription field's value.
func (s *DBSubnetGroup) SetDBSubnetGroupDescription(v string) *DBSubnetGroup {
	s.DBSubnetGroupDescription = &v
	return s
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *DBSubnetGroup) SetDBSubnetGroupName(v string) *DBSubnetGroup {
	s.DBSubnetGroupName = &v
	return s
}

// SetSubnetGroupStatus sets the SubnetGroupStatus field's value.
func (s *DBSubnetGroup) SetSubnetGroupStatus(v string) *DBSubnetGroup {
	s.SubnetGroupStatus = &v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *DBSubnetGroup) SetSubnets(v []*Subnet) *DBSubnetGroup {
	s.Subnets = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *DBSubnetGroup) SetVpcId(v string) *DBSubnetGroup {
	s.VpcId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterMessage
type DeleteDBClusterInput struct {
	_ struct{} `type:"structure"`

	// The DB cluster identifier for the DB cluster to be deleted. This parameter
	// isn't case-sensitive.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	// DBClusterIdentifier is a required field
	DBClusterIdentifier *string `type:"string" required:"true"`

	// The DB cluster snapshot identifier of the new DB cluster snapshot created
	// when SkipFinalSnapshot is set to false.
	//
	// Specifying this parameter and also setting the SkipFinalShapshot parameter
	// to true results in an error.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 alphanumeric characters
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	FinalDBSnapshotIdentifier *string `type:"string"`

	// Determines whether a final DB cluster snapshot is created before the DB cluster
	// is deleted. If true is specified, no DB cluster snapshot is created. If false
	// is specified, a DB cluster snapshot is created before the DB cluster is deleted.
	//
	// You must specify a FinalDBSnapshotIdentifier parameter if SkipFinalSnapshot
	// is false.
	//
	// Default: false
	SkipFinalSnapshot *bool `type:"boolean"`
}

// String returns the string representation
func (s DeleteDBClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDBClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDBClusterInput"}
	if s.DBClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *DeleteDBClusterInput) SetDBClusterIdentifier(v string) *DeleteDBClusterInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetFinalDBSnapshotIdentifier sets the FinalDBSnapshotIdentifier field's value.
func (s *DeleteDBClusterInput) SetFinalDBSnapshotIdentifier(v string) *DeleteDBClusterInput {
	s.FinalDBSnapshotIdentifier = &v
	return s
}

// SetSkipFinalSnapshot sets the SkipFinalSnapshot field's value.
func (s *DeleteDBClusterInput) SetSkipFinalSnapshot(v bool) *DeleteDBClusterInput {
	s.SkipFinalSnapshot = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterResult
type DeleteDBClusterOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//    * CreateDBCluster
	//
	//    * DeleteDBCluster
	//
	//    * FailoverDBCluster
	//
	//    * ModifyDBCluster
	//
	//    * RestoreDBClusterFromSnapshot
	//
	//    * RestoreDBClusterToPointInTime
	//
	// This data type is used as a response element in the DescribeDBClusters action.
	DBCluster *DBCluster `type:"structure"`
}

// String returns the string representation
func (s DeleteDBClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBClusterOutput) GoString() string {
	return s.String()
}

// SetDBCluster sets the DBCluster field's value.
func (s *DeleteDBClusterOutput) SetDBCluster(v *DBCluster) *DeleteDBClusterOutput {
	s.DBCluster = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterParameterGroupMessage
type DeleteDBClusterParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB cluster parameter group.
	//
	// Constraints:
	//
	//    * Must be the name of an existing DB cluster parameter group.
	//
	//    * You cannot delete a default DB cluster parameter group.
	//
	//    * Cannot be associated with any DB clusters.
	//
	// DBClusterParameterGroupName is a required field
	DBClusterParameterGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDBClusterParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBClusterParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDBClusterParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDBClusterParameterGroupInput"}
	if s.DBClusterParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterParameterGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *DeleteDBClusterParameterGroupInput) SetDBClusterParameterGroupName(v string) *DeleteDBClusterParameterGroupInput {
	s.DBClusterParameterGroupName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterParameterGroupOutput
type DeleteDBClusterParameterGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDBClusterParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBClusterParameterGroupOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterSnapshotMessage
type DeleteDBClusterSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the DB cluster snapshot to delete.
	//
	// Constraints: Must be the name of an existing DB cluster snapshot in the available
	// state.
	//
	// DBClusterSnapshotIdentifier is a required field
	DBClusterSnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDBClusterSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBClusterSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDBClusterSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDBClusterSnapshotInput"}
	if s.DBClusterSnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterSnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterSnapshotIdentifier sets the DBClusterSnapshotIdentifier field's value.
func (s *DeleteDBClusterSnapshotInput) SetDBClusterSnapshotIdentifier(v string) *DeleteDBClusterSnapshotInput {
	s.DBClusterSnapshotIdentifier = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterSnapshotResult
type DeleteDBClusterSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//    * CreateDBClusterSnapshot
	//
	//    * DeleteDBClusterSnapshot
	//
	// This data type is used as a response element in the DescribeDBClusterSnapshots
	// action.
	DBClusterSnapshot *DBClusterSnapshot `type:"structure"`
}

// String returns the string representation
func (s DeleteDBClusterSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBClusterSnapshotOutput) GoString() string {
	return s.String()
}

// SetDBClusterSnapshot sets the DBClusterSnapshot field's value.
func (s *DeleteDBClusterSnapshotOutput) SetDBClusterSnapshot(v *DBClusterSnapshot) *DeleteDBClusterSnapshotOutput {
	s.DBClusterSnapshot = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBInstanceMessage
type DeleteDBInstanceInput struct {
	_ struct{} `type:"structure"`

	// The DB instance identifier for the DB instance to be deleted. This parameter
	// isn't case-sensitive.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	// DBInstanceIdentifier is a required field
	DBInstanceIdentifier *string `type:"string" required:"true"`

	// The DBSnapshotIdentifier of the new DBSnapshot created when SkipFinalSnapshot
	// is set to false.
	//
	// Specifying this parameter and also setting the SkipFinalShapshot parameter
	// to true results in an error.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 alphanumeric characters
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	//    * Cannot be specified when deleting a Read Replica.
	FinalDBSnapshotIdentifier *string `type:"string"`

	// Determines whether a final DB snapshot is created before the DB instance
	// is deleted. If true is specified, no DBSnapshot is created. If false is specified,
	// a DB snapshot is created before the DB instance is deleted.
	//
	// Note that when a DB instance is in a failure state and has a status of 'failed',
	// 'incompatible-restore', or 'incompatible-network', it can only be deleted
	// when the SkipFinalSnapshot parameter is set to "true".
	//
	// Specify true when deleting a Read Replica.
	//
	// The FinalDBSnapshotIdentifier parameter must be specified if SkipFinalSnapshot
	// is false.
	//
	// Default: false
	SkipFinalSnapshot *bool `type:"boolean"`
}

// String returns the string representation
func (s DeleteDBInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDBInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDBInstanceInput"}
	if s.DBInstanceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBInstanceIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *DeleteDBInstanceInput) SetDBInstanceIdentifier(v string) *DeleteDBInstanceInput {
	s.DBInstanceIdentifier = &v
	return s
}

// SetFinalDBSnapshotIdentifier sets the FinalDBSnapshotIdentifier field's value.
func (s *DeleteDBInstanceInput) SetFinalDBSnapshotIdentifier(v string) *DeleteDBInstanceInput {
	s.FinalDBSnapshotIdentifier = &v
	return s
}

// SetSkipFinalSnapshot sets the SkipFinalSnapshot field's value.
func (s *DeleteDBInstanceInput) SetSkipFinalSnapshot(v bool) *DeleteDBInstanceInput {
	s.SkipFinalSnapshot = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBInstanceResult
type DeleteDBInstanceOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//    * CreateDBInstance
	//
	//    * DeleteDBInstance
	//
	//    * ModifyDBInstance
	//
	//    * StopDBInstance
	//
	//    * StartDBInstance
	//
	// This data type is used as a response element in the DescribeDBInstances action.
	DBInstance *DBInstance `type:"structure"`
}

// String returns the string representation
func (s DeleteDBInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBInstanceOutput) GoString() string {
	return s.String()
}

// SetDBInstance sets the DBInstance field's value.
func (s *DeleteDBInstanceOutput) SetDBInstance(v *DBInstance) *DeleteDBInstanceOutput {
	s.DBInstance = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBParameterGroupMessage
type DeleteDBParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB parameter group.
	//
	// Constraints:
	//
	//    * Must be the name of an existing DB parameter group
	//
	//    * You cannot delete a default DB parameter group
	//
	//    * Cannot be associated with any DB instances
	//
	// DBParameterGroupName is a required field
	DBParameterGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDBParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDBParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDBParameterGroupInput"}
	if s.DBParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBParameterGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBParameterGroupName sets the DBParameterGroupName field's value.
func (s *DeleteDBParameterGroupInput) SetDBParameterGroupName(v string) *DeleteDBParameterGroupInput {
	s.DBParameterGroupName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBParameterGroupOutput
type DeleteDBParameterGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDBParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBParameterGroupOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSecurityGroupMessage
type DeleteDBSecurityGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB security group to delete.
	//
	// You cannot delete the default DB security group.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 alphanumeric characters
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	//    * Must not be "Default"
	//
	// DBSecurityGroupName is a required field
	DBSecurityGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDBSecurityGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBSecurityGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDBSecurityGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDBSecurityGroupInput"}
	if s.DBSecurityGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBSecurityGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBSecurityGroupName sets the DBSecurityGroupName field's value.
func (s *DeleteDBSecurityGroupInput) SetDBSecurityGroupName(v string) *DeleteDBSecurityGroupInput {
	s.DBSecurityGroupName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSecurityGroupOutput
type DeleteDBSecurityGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDBSecurityGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBSecurityGroupOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSnapshotMessage
type DeleteDBSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The DBSnapshot identifier.
	//
	// Constraints: Must be the name of an existing DB snapshot in the available
	// state.
	//
	// DBSnapshotIdentifier is a required field
	DBSnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDBSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDBSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDBSnapshotInput"}
	if s.DBSnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBSnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBSnapshotIdentifier sets the DBSnapshotIdentifier field's value.
func (s *DeleteDBSnapshotInput) SetDBSnapshotIdentifier(v string) *DeleteDBSnapshotInput {
	s.DBSnapshotIdentifier = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSnapshotResult
type DeleteDBSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//    * CreateDBSnapshot
	//
	//    * DeleteDBSnapshot
	//
	// This data type is used as a response element in the DescribeDBSnapshots action.
	DBSnapshot *DBSnapshot `type:"structure"`
}

// String returns the string representation
func (s DeleteDBSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBSnapshotOutput) GoString() string {
	return s.String()
}

// SetDBSnapshot sets the DBSnapshot field's value.
func (s *DeleteDBSnapshotOutput) SetDBSnapshot(v *DBSnapshot) *DeleteDBSnapshotOutput {
	s.DBSnapshot = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSubnetGroupMessage
type DeleteDBSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the database subnet group to delete.
	//
	// You cannot delete the default subnet group.
	//
	// Constraints:
	//
	// Constraints: Must contain no more than 255 alphanumeric characters, periods,
	// underscores, spaces, or hyphens. Must not be default.
	//
	// Example: mySubnetgroup
	//
	// DBSubnetGroupName is a required field
	DBSubnetGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDBSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBSubnetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDBSubnetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDBSubnetGroupInput"}
	if s.DBSubnetGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBSubnetGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *DeleteDBSubnetGroupInput) SetDBSubnetGroupName(v string) *DeleteDBSubnetGroupInput {
	s.DBSubnetGroupName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSubnetGroupOutput
type DeleteDBSubnetGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDBSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDBSubnetGroupOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteEventSubscriptionMessage
type DeleteEventSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// The name of the RDS event notification subscription you want to delete.
	//
	// SubscriptionName is a required field
	SubscriptionName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEventSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEventSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEventSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEventSubscriptionInput"}
	if s.SubscriptionName == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSubscriptionName sets the SubscriptionName field's value.
func (s *DeleteEventSubscriptionInput) SetSubscriptionName(v string) *DeleteEventSubscriptionInput {
	s.SubscriptionName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteEventSubscriptionResult
type DeleteEventSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// Contains the results of a successful invocation of the DescribeEventSubscriptions
	// action.
	EventSubscription *EventSubscription `type:"structure"`
}

// String returns the string representation
func (s DeleteEventSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEventSubscriptionOutput) GoString() string {
	return s.String()
}

// SetEventSubscription sets the EventSubscription field's value.
func (s *DeleteEventSubscriptionOutput) SetEventSubscription(v *EventSubscription) *DeleteEventSubscriptionOutput {
	s.EventSubscription = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteOptionGroupMessage
type DeleteOptionGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the option group to be deleted.
	//
	// You cannot delete default option groups.
	//
	// OptionGroupName is a required field
	OptionGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteOptionGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteOptionGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteOptionGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteOptionGroupInput"}
	if s.OptionGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("OptionGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOptionGroupName sets the OptionGroupName field's value.
func (s *DeleteOptionGroupInput) SetOptionGroupName(v string) *DeleteOptionGroupInput {
	s.OptionGroupName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteOptionGroupOutput
type DeleteOptionGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteOptionGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteOptionGroupOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeAccountAttributesMessage
type DescribeAccountAttributesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeAccountAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountAttributesInput) GoString() string {
	return s.String()
}

// Data returned by the DescribeAccountAttributes action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AccountAttributesMessage
type DescribeAccountAttributesOutput struct {
	_ struct{} `type:"structure"`

	// A list of AccountQuota objects. Within this list, each quota has a name,
	// a count of usage toward the quota maximum, and a maximum value for the quota.
	AccountQuotas []*AccountQuota `locationNameList:"AccountQuota" type:"list"`
}

// String returns the string representation
func (s DescribeAccountAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountAttributesOutput) GoString() string {
	return s.String()
}

// SetAccountQuotas sets the AccountQuotas field's value.
func (s *DescribeAccountAttributesOutput) SetAccountQuotas(v []*AccountQuota) *DescribeAccountAttributesOutput {
	s.AccountQuotas = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeCertificatesMessage
type DescribeCertificatesInput struct {
	_ struct{} `type:"structure"`

	// The user-supplied certificate identifier. If this parameter is specified,
	// information for only the identified certificate is returned. This parameter
	// isn't case-sensitive.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	CertificateIdentifier *string `type:"string"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeCertificates
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeCertificatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCertificatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCertificatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCertificatesInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateIdentifier sets the CertificateIdentifier field's value.
func (s *DescribeCertificatesInput) SetCertificateIdentifier(v string) *DescribeCertificatesInput {
	s.CertificateIdentifier = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeCertificatesInput) SetFilters(v []*Filter) *DescribeCertificatesInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeCertificatesInput) SetMarker(v string) *DescribeCertificatesInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeCertificatesInput) SetMaxRecords(v int64) *DescribeCertificatesInput {
	s.MaxRecords = &v
	return s
}

// Data returned by the DescribeCertificates action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CertificateMessage
type DescribeCertificatesOutput struct {
	_ struct{} `type:"structure"`

	// The list of Certificate objects for the AWS account.
	Certificates []*Certificate `locationNameList:"Certificate" type:"list"`

	// An optional pagination token provided by a previous DescribeCertificates
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords .
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeCertificatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCertificatesOutput) GoString() string {
	return s.String()
}

// SetCertificates sets the Certificates field's value.
func (s *DescribeCertificatesOutput) SetCertificates(v []*Certificate) *DescribeCertificatesOutput {
	s.Certificates = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeCertificatesOutput) SetMarker(v string) *DescribeCertificatesOutput {
	s.Marker = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterParameterGroupsMessage
type DescribeDBClusterParameterGroupsInput struct {
	_ struct{} `type:"structure"`

	// The name of a specific DB cluster parameter group to return details for.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 alphanumeric characters
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	DBClusterParameterGroupName *string `type:"string"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeDBClusterParameterGroups
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeDBClusterParameterGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterParameterGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBClusterParameterGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBClusterParameterGroupsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *DescribeDBClusterParameterGroupsInput) SetDBClusterParameterGroupName(v string) *DescribeDBClusterParameterGroupsInput {
	s.DBClusterParameterGroupName = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeDBClusterParameterGroupsInput) SetFilters(v []*Filter) *DescribeDBClusterParameterGroupsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBClusterParameterGroupsInput) SetMarker(v string) *DescribeDBClusterParameterGroupsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeDBClusterParameterGroupsInput) SetMaxRecords(v int64) *DescribeDBClusterParameterGroupsInput {
	s.MaxRecords = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DBClusterParameterGroupsMessage
type DescribeDBClusterParameterGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A list of DB cluster parameter groups.
	DBClusterParameterGroups []*DBClusterParameterGroup `locationNameList:"DBClusterParameterGroup" type:"list"`

	// An optional pagination token provided by a previous DescribeDBClusterParameterGroups
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBClusterParameterGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterParameterGroupsOutput) GoString() string {
	return s.String()
}

// SetDBClusterParameterGroups sets the DBClusterParameterGroups field's value.
func (s *DescribeDBClusterParameterGroupsOutput) SetDBClusterParameterGroups(v []*DBClusterParameterGroup) *DescribeDBClusterParameterGroupsOutput {
	s.DBClusterParameterGroups = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBClusterParameterGroupsOutput) SetMarker(v string) *DescribeDBClusterParameterGroupsOutput {
	s.Marker = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterParametersMessage
type DescribeDBClusterParametersInput struct {
	_ struct{} `type:"structure"`

	// The name of a specific DB cluster parameter group to return parameter details
	// for.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 alphanumeric characters
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	// DBClusterParameterGroupName is a required field
	DBClusterParameterGroupName *string `type:"string" required:"true"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeDBClusterParameters
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// A value that indicates to return only parameters for a specific source. Parameter
	// sources can be engine, service, or customer.
	Source *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBClusterParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterParametersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBClusterParametersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBClusterParametersInput"}
	if s.DBClusterParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterParameterGroupName"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *DescribeDBClusterParametersInput) SetDBClusterParameterGroupName(v string) *DescribeDBClusterParametersInput {
	s.DBClusterParameterGroupName = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeDBClusterParametersInput) SetFilters(v []*Filter) *DescribeDBClusterParametersInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBClusterParametersInput) SetMarker(v string) *DescribeDBClusterParametersInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeDBClusterParametersInput) SetMaxRecords(v int64) *DescribeDBClusterParametersInput {
	s.MaxRecords = &v
	return s
}

// SetSource sets the Source field's value.
func (s *DescribeDBClusterParametersInput) SetSource(v string) *DescribeDBClusterParametersInput {
	s.Source = &v
	return s
}

// Provides details about a DB cluster parameter group including the parameters
// in the DB cluster parameter group.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DBClusterParameterGroupDetails
type DescribeDBClusterParametersOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous DescribeDBClusterParameters
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords .
	Marker *string `type:"string"`

	// Provides a list of parameters for the DB cluster parameter group.
	Parameters []*Parameter `locationNameList:"Parameter" type:"list"`
}

// String returns the string representation
func (s DescribeDBClusterParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterParametersOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBClusterParametersOutput) SetMarker(v string) *DescribeDBClusterParametersOutput {
	s.Marker = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *DescribeDBClusterParametersOutput) SetParameters(v []*Parameter) *DescribeDBClusterParametersOutput {
	s.Parameters = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterSnapshotAttributesMessage
type DescribeDBClusterSnapshotAttributesInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the DB cluster snapshot to describe the attributes for.
	//
	// DBClusterSnapshotIdentifier is a required field
	DBClusterSnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDBClusterSnapshotAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterSnapshotAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBClusterSnapshotAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBClusterSnapshotAttributesInput"}
	if s.DBClusterSnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterSnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterSnapshotIdentifier sets the DBClusterSnapshotIdentifier field's value.
func (s *DescribeDBClusterSnapshotAttributesInput) SetDBClusterSnapshotIdentifier(v string) *DescribeDBClusterSnapshotAttributesInput {
	s.DBClusterSnapshotIdentifier = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterSnapshotAttributesResult
type DescribeDBClusterSnapshotAttributesOutput struct {
	_ struct{} `type:"structure"`

	// Contains the results of a successful call to the DescribeDBClusterSnapshotAttributes
	// API action.
	//
	// Manual DB cluster snapshot attributes are used to authorize other AWS accounts
	// to copy or restore a manual DB cluster snapshot. For more information, see
	// the ModifyDBClusterSnapshotAttribute API action.
	DBClusterSnapshotAttributesResult *DBClusterSnapshotAttributesResult `type:"structure"`
}

// String returns the string representation
func (s DescribeDBClusterSnapshotAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterSnapshotAttributesOutput) GoString() string {
	return s.String()
}

// SetDBClusterSnapshotAttributesResult sets the DBClusterSnapshotAttributesResult field's value.
func (s *DescribeDBClusterSnapshotAttributesOutput) SetDBClusterSnapshotAttributesResult(v *DBClusterSnapshotAttributesResult) *DescribeDBClusterSnapshotAttributesOutput {
	s.DBClusterSnapshotAttributesResult = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterSnapshotsMessage
type DescribeDBClusterSnapshotsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the DB cluster to retrieve the list of DB cluster snapshots for.
	// This parameter cannot be used in conjunction with the DBClusterSnapshotIdentifier
	// parameter. This parameter is not case-sensitive.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	DBClusterIdentifier *string `type:"string"`

	// A specific DB cluster snapshot identifier to describe. This parameter cannot
	// be used in conjunction with the DBClusterIdentifier parameter. This value
	// is stored as a lowercase string.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 alphanumeric characters
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	//    * If this identifier is for an automated snapshot, the SnapshotType parameter
	//    must also be specified.
	DBClusterSnapshotIdentifier *string `type:"string"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// Set this value to true to include manual DB cluster snapshots that are public
	// and can be copied or restored by any AWS account, otherwise set this value
	// to false. The default is false. The default is false.
	//
	// You can share a manual DB cluster snapshot as public by using the ModifyDBClusterSnapshotAttribute
	// API action.
	IncludePublic *bool `type:"boolean"`

	// Set this value to true to include shared manual DB cluster snapshots from
	// other AWS accounts that this AWS account has been given permission to copy
	// or restore, otherwise set this value to false. The default is false.
	//
	// You can give an AWS account permission to restore a manual DB cluster snapshot
	// from another AWS account by the ModifyDBClusterSnapshotAttribute API action.
	IncludeShared *bool `type:"boolean"`

	// An optional pagination token provided by a previous DescribeDBClusterSnapshots
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The type of DB cluster snapshots to be returned. You can specify one of the
	// following values:
	//
	//    * automated - Return all DB cluster snapshots that have been automatically
	//    taken by Amazon RDS for my AWS account.
	//
	//    * manual - Return all DB cluster snapshots that have been taken by my
	//    AWS account.
	//
	//    * shared - Return all manual DB cluster snapshots that have been shared
	//    to my AWS account.
	//
	//    * public - Return all DB cluster snapshots that have been marked as public.
	//
	// If you don't specify a SnapshotType value, then both automated and manual
	// DB cluster snapshots are returned. You can include shared DB cluster snapshots
	// with these results by setting the IncludeShared parameter to true. You can
	// include public DB cluster snapshots with these results by setting the IncludePublic
	// parameter to true.
	//
	// The IncludeShared and IncludePublic parameters don't apply for SnapshotType
	// values of manual or automated. The IncludePublic parameter doesn't apply
	// when SnapshotType is set to shared. The IncludeShared parameter doesn't apply
	// when SnapshotType is set to public.
	SnapshotType *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBClusterSnapshotsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterSnapshotsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBClusterSnapshotsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBClusterSnapshotsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *DescribeDBClusterSnapshotsInput) SetDBClusterIdentifier(v string) *DescribeDBClusterSnapshotsInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBClusterSnapshotIdentifier sets the DBClusterSnapshotIdentifier field's value.
func (s *DescribeDBClusterSnapshotsInput) SetDBClusterSnapshotIdentifier(v string) *DescribeDBClusterSnapshotsInput {
	s.DBClusterSnapshotIdentifier = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeDBClusterSnapshotsInput) SetFilters(v []*Filter) *DescribeDBClusterSnapshotsInput {
	s.Filters = v
	return s
}

// SetIncludePublic sets the IncludePublic field's value.
func (s *DescribeDBClusterSnapshotsInput) SetIncludePublic(v bool) *DescribeDBClusterSnapshotsInput {
	s.IncludePublic = &v
	return s
}

// SetIncludeShared sets the IncludeShared field's value.
func (s *DescribeDBClusterSnapshotsInput) SetIncludeShared(v bool) *DescribeDBClusterSnapshotsInput {
	s.IncludeShared = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBClusterSnapshotsInput) SetMarker(v string) *DescribeDBClusterSnapshotsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeDBClusterSnapshotsInput) SetMaxRecords(v int64) *DescribeDBClusterSnapshotsInput {
	s.MaxRecords = &v
	return s
}

// SetSnapshotType sets the SnapshotType field's value.
func (s *DescribeDBClusterSnapshotsInput) SetSnapshotType(v string) *DescribeDBClusterSnapshotsInput {
	s.SnapshotType = &v
	return s
}

// Provides a list of DB cluster snapshots for the user as the result of a call
// to the DescribeDBClusterSnapshots action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DBClusterSnapshotMessage
type DescribeDBClusterSnapshotsOutput struct {
	_ struct{} `type:"structure"`

	// Provides a list of DB cluster snapshots for the user.
	DBClusterSnapshots []*DBClusterSnapshot `locationNameList:"DBClusterSnapshot" type:"list"`

	// An optional pagination token provided by a previous DescribeDBClusterSnapshots
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBClusterSnapshotsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClusterSnapshotsOutput) GoString() string {
	return s.String()
}

// SetDBClusterSnapshots sets the DBClusterSnapshots field's value.
func (s *DescribeDBClusterSnapshotsOutput) SetDBClusterSnapshots(v []*DBClusterSnapshot) *DescribeDBClusterSnapshotsOutput {
	s.DBClusterSnapshots = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBClusterSnapshotsOutput) SetMarker(v string) *DescribeDBClusterSnapshotsOutput {
	s.Marker = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClustersMessage
type DescribeDBClustersInput struct {
	_ struct{} `type:"structure"`

	// The user-supplied DB cluster identifier. If this parameter is specified,
	// information from only the specific DB cluster is returned. This parameter
	// isn't case-sensitive.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	DBClusterIdentifier *string `type:"string"`

	// A filter that specifies one or more DB clusters to describe.
	//
	// Supported filters:
	//
	//    * db-cluster-id - Accepts DB cluster identifiers and DB cluster Amazon
	//    Resource Names (ARNs). The results list will only include information
	//    about the DB clusters identified by these ARNs.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeDBClusters request.
	// If this parameter is specified, the response includes only records beyond
	// the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeDBClustersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClustersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBClustersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBClustersInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *DescribeDBClustersInput) SetDBClusterIdentifier(v string) *DescribeDBClustersInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeDBClustersInput) SetFilters(v []*Filter) *DescribeDBClustersInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBClustersInput) SetMarker(v string) *DescribeDBClustersInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeDBClustersInput) SetMaxRecords(v int64) *DescribeDBClustersInput {
	s.MaxRecords = &v
	return s
}

// Contains the result of a successful invocation of the DescribeDBClusters
// action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DBClusterMessage
type DescribeDBClustersOutput struct {
	_ struct{} `type:"structure"`

	// Contains a list of DB clusters for the user.
	DBClusters []*DBCluster `locationNameList:"DBCluster" type:"list"`

	// A pagination token that can be used in a subsequent DescribeDBClusters request.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBClustersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBClustersOutput) GoString() string {
	return s.String()
}

// SetDBClusters sets the DBClusters field's value.
func (s *DescribeDBClustersOutput) SetDBClusters(v []*DBCluster) *DescribeDBClustersOutput {
	s.DBClusters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBClustersOutput) SetMarker(v string) *DescribeDBClustersOutput {
	s.Marker = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBEngineVersionsMessage
type DescribeDBEngineVersionsInput struct {
	_ struct{} `type:"structure"`

	// The name of a specific DB parameter group family to return details for.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 alphanumeric characters
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	DBParameterGroupFamily *string `type:"string"`

	// Indicates that only the default version of the specified engine or engine
	// and major version combination is returned.
	DefaultOnly *bool `type:"boolean"`

	// The database engine to return.
	Engine *string `type:"string"`

	// The database engine version to return.
	//
	// Example: 5.1.49
	EngineVersion *string `type:"string"`

	// Not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// If this parameter is specified and the requested engine supports the CharacterSetName
	// parameter for CreateDBInstance, the response includes a list of supported
	// character sets for each engine version.
	ListSupportedCharacterSets *bool `type:"boolean"`

	// If this parameter is specified and the requested engine supports the TimeZone
	// parameter for CreateDBInstance, the response includes a list of supported
	// time zones for each engine version.
	ListSupportedTimezones *bool `type:"boolean"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more than the
	// MaxRecords value is available, a pagination token called a marker is included
	// in the response so that the following results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeDBEngineVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBEngineVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBEngineVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBEngineVersionsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBParameterGroupFamily sets the DBParameterGroupFamily field's value.
func (s *DescribeDBEngineVersionsInput) SetDBParameterGroupFamily(v string) *DescribeDBEngineVersionsInput {
	s.DBParameterGroupFamily = &v
	return s
}

// SetDefaultOnly sets the DefaultOnly field's value.
func (s *DescribeDBEngineVersionsInput) SetDefaultOnly(v bool) *DescribeDBEngineVersionsInput {
	s.DefaultOnly = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *DescribeDBEngineVersionsInput) SetEngine(v string) *DescribeDBEngineVersionsInput {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *DescribeDBEngineVersionsInput) SetEngineVersion(v string) *DescribeDBEngineVersionsInput {
	s.EngineVersion = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeDBEngineVersionsInput) SetFilters(v []*Filter) *DescribeDBEngineVersionsInput {
	s.Filters = v
	return s
}

// SetListSupportedCharacterSets sets the ListSupportedCharacterSets field's value.
func (s *DescribeDBEngineVersionsInput) SetListSupportedCharacterSets(v bool) *DescribeDBEngineVersionsInput {
	s.ListSupportedCharacterSets = &v
	return s
}

// SetListSupportedTimezones sets the ListSupportedTimezones field's value.
func (s *DescribeDBEngineVersionsInput) SetListSupportedTimezones(v bool) *DescribeDBEngineVersionsInput {
	s.ListSupportedTimezones = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBEngineVersionsInput) SetMarker(v string) *DescribeDBEngineVersionsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeDBEngineVersionsInput) SetMaxRecords(v int64) *DescribeDBEngineVersionsInput {
	s.MaxRecords = &v
	return s
}

// Contains the result of a successful invocation of the DescribeDBEngineVersions
// action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DBEngineVersionMessage
type DescribeDBEngineVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of DBEngineVersion elements.
	DBEngineVersions []*DBEngineVersion `locationNameList:"DBEngineVersion" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBEngineVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBEngineVersionsOutput) GoString() string {
	return s.String()
}

// SetDBEngineVersions sets the DBEngineVersions field's value.
func (s *DescribeDBEngineVersionsOutput) SetDBEngineVersions(v []*DBEngineVersion) *DescribeDBEngineVersionsOutput {
	s.DBEngineVersions = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBEngineVersionsOutput) SetMarker(v string) *DescribeDBEngineVersionsOutput {
	s.Marker = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBInstancesMessage
type DescribeDBInstancesInput struct {
	_ struct{} `type:"structure"`

	// The user-supplied instance identifier. If this parameter is specified, information
	// from only the specific DB instance is returned. This parameter isn't case-sensitive.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	DBInstanceIdentifier *string `type:"string"`

	// A filter that specifies one or more DB instances to describe.
	//
	// Supported filters:
	//
	//    * db-cluster-id - Accepts DB cluster identifiers and DB cluster Amazon
	//    Resource Names (ARNs). The results list will only include information
	//    about the DB instances associated with the DB Clusters identified by these
	//    ARNs.
	//
	//    * db-instance-id - Accepts DB instance identifiers and DB instance Amazon
	//    Resource Names (ARNs). The results list will only include information
	//    about the DB instances identified by these ARNs.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeDBInstances request.
	// If this parameter is specified, the response includes only records beyond
	// the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeDBInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBInstancesInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *DescribeDBInstancesInput) SetDBInstanceIdentifier(v string) *DescribeDBInstancesInput {
	s.DBInstanceIdentifier = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeDBInstancesInput) SetFilters(v []*Filter) *DescribeDBInstancesInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBInstancesInput) SetMarker(v string) *DescribeDBInstancesInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeDBInstancesInput) SetMaxRecords(v int64) *DescribeDBInstancesInput {
	s.MaxRecords = &v
	return s
}

// Contains the result of a successful invocation of the DescribeDBInstances
// action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DBInstanceMessage
type DescribeDBInstancesOutput struct {
	_ struct{} `type:"structure"`

	// A list of DBInstance instances.
	DBInstances []*DBInstance `locationNameList:"DBInstance" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords .
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBInstancesOutput) GoString() string {
	return s.String()
}

// SetDBInstances sets the DBInstances field's value.
func (s *DescribeDBInstancesOutput) SetDBInstances(v []*DBInstance) *DescribeDBInstancesOutput {
	s.DBInstances = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBInstancesOutput) SetMarker(v string) *DescribeDBInstancesOutput {
	s.Marker = &v
	return s
}

// This data type is used as a response element to DescribeDBLogFiles.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBLogFilesDetails
type DescribeDBLogFilesDetails struct {
	_ struct{} `type:"structure"`

	// A POSIX timestamp when the last log entry was written.
	LastWritten *int64 `type:"long"`

	// The name of the log file for the specified DB instance.
	LogFileName *string `type:"string"`

	// The size, in bytes, of the log file for the specified DB instance.
	Size *int64 `type:"long"`
}

// String returns the string representation
func (s DescribeDBLogFilesDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBLogFilesDetails) GoString() string {
	return s.String()
}

// SetLastWritten sets the LastWritten field's value.
func (s *DescribeDBLogFilesDetails) SetLastWritten(v int64) *DescribeDBLogFilesDetails {
	s.LastWritten = &v
	return s
}

// SetLogFileName sets the LogFileName field's value.
func (s *DescribeDBLogFilesDetails) SetLogFileName(v string) *DescribeDBLogFilesDetails {
	s.LogFileName = &v
	return s
}

// SetSize sets the Size field's value.
func (s *DescribeDBLogFilesDetails) SetSize(v int64) *DescribeDBLogFilesDetails {
	s.Size = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBLogFilesMessage
type DescribeDBLogFilesInput struct {
	_ struct{} `type:"structure"`

	// The customer-assigned name of the DB instance that contains the log files
	// you want to list.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	// DBInstanceIdentifier is a required field
	DBInstanceIdentifier *string `type:"string" required:"true"`

	// Filters the available log files for files written since the specified date,
	// in POSIX timestamp format with milliseconds.
	FileLastWritten *int64 `type:"long"`

	// Filters the available log files for files larger than the specified size.
	FileSize *int64 `type:"long"`

	// Filters the available log files for log file names that contain the specified
	// string.
	FilenameContains *string `type:"string"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// The pagination token provided in the previous request. If this parameter
	// is specified the response includes only records beyond the marker, up to
	// MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeDBLogFilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBLogFilesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBLogFilesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBLogFilesInput"}
	if s.DBInstanceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBInstanceIdentifier"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *DescribeDBLogFilesInput) SetDBInstanceIdentifier(v string) *DescribeDBLogFilesInput {
	s.DBInstanceIdentifier = &v
	return s
}

// SetFileLastWritten sets the FileLastWritten field's value.
func (s *DescribeDBLogFilesInput) SetFileLastWritten(v int64) *DescribeDBLogFilesInput {
	s.FileLastWritten = &v
	return s
}

// SetFileSize sets the FileSize field's value.
func (s *DescribeDBLogFilesInput) SetFileSize(v int64) *DescribeDBLogFilesInput {
	s.FileSize = &v
	return s
}

// SetFilenameContains sets the FilenameContains field's value.
func (s *DescribeDBLogFilesInput) SetFilenameContains(v string) *DescribeDBLogFilesInput {
	s.FilenameContains = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeDBLogFilesInput) SetFilters(v []*Filter) *DescribeDBLogFilesInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBLogFilesInput) SetMarker(v string) *DescribeDBLogFilesInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeDBLogFilesInput) SetMaxRecords(v int64) *DescribeDBLogFilesInput {
	s.MaxRecords = &v
	return s
}

// The response from a call to DescribeDBLogFiles.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBLogFilesResponse
type DescribeDBLogFilesOutput struct {
	_ struct{} `type:"structure"`

	// The DB log files returned.
	DescribeDBLogFiles []*DescribeDBLogFilesDetails `locationNameList:"DescribeDBLogFilesDetails" type:"list"`

	// A pagination token that can be used in a subsequent DescribeDBLogFiles request.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBLogFilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBLogFilesOutput) GoString() string {
	return s.String()
}

// SetDescribeDBLogFiles sets the DescribeDBLogFiles field's value.
func (s *DescribeDBLogFilesOutput) SetDescribeDBLogFiles(v []*DescribeDBLogFilesDetails) *DescribeDBLogFilesOutput {
	s.DescribeDBLogFiles = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBLogFilesOutput) SetMarker(v string) *DescribeDBLogFilesOutput {
	s.Marker = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBParameterGroupsMessage
type DescribeDBParameterGroupsInput struct {
	_ struct{} `type:"structure"`

	// The name of a specific DB parameter group to return details for.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 alphanumeric characters
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	DBParameterGroupName *string `type:"string"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeDBParameterGroups
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeDBParameterGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBParameterGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBParameterGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBParameterGroupsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBParameterGroupName sets the DBParameterGroupName field's value.
func (s *DescribeDBParameterGroupsInput) SetDBParameterGroupName(v string) *DescribeDBParameterGroupsInput {
	s.DBParameterGroupName = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeDBParameterGroupsInput) SetFilters(v []*Filter) *DescribeDBParameterGroupsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBParameterGroupsInput) SetMarker(v string) *DescribeDBParameterGroupsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeDBParameterGroupsInput) SetMaxRecords(v int64) *DescribeDBParameterGroupsInput {
	s.MaxRecords = &v
	return s
}

// Contains the result of a successful invocation of the DescribeDBParameterGroups
// action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DBParameterGroupsMessage
type DescribeDBParameterGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A list of DBParameterGroup instances.
	DBParameterGroups []*DBParameterGroup `locationNameList:"DBParameterGroup" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBParameterGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBParameterGroupsOutput) GoString() string {
	return s.String()
}

// SetDBParameterGroups sets the DBParameterGroups field's value.
func (s *DescribeDBParameterGroupsOutput) SetDBParameterGroups(v []*DBParameterGroup) *DescribeDBParameterGroupsOutput {
	s.DBParameterGroups = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBParameterGroupsOutput) SetMarker(v string) *DescribeDBParameterGroupsOutput {
	s.Marker = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBParametersMessage
type DescribeDBParametersInput struct {
	_ struct{} `type:"structure"`

	// The name of a specific DB parameter group to return details for.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 alphanumeric characters
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	// DBParameterGroupName is a required field
	DBParameterGroupName *string `type:"string" required:"true"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeDBParameters
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The parameter types to return.
	//
	// Default: All parameter types returned
	//
	// Valid Values: user | system | engine-default
	Source *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBParametersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBParametersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBParametersInput"}
	if s.DBParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBParameterGroupName"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBParameterGroupName sets the DBParameterGroupName field's value.
func (s *DescribeDBParametersInput) SetDBParameterGroupName(v string) *DescribeDBParametersInput {
	s.DBParameterGroupName = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeDBParametersInput) SetFilters(v []*Filter) *DescribeDBParametersInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBParametersInput) SetMarker(v string) *DescribeDBParametersInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeDBParametersInput) SetMaxRecords(v int64) *DescribeDBParametersInput {
	s.MaxRecords = &v
	return s
}

// SetSource sets the Source field's value.
func (s *DescribeDBParametersInput) SetSource(v string) *DescribeDBParametersInput {
	s.Source = &v
	return s
}

// Contains the result of a successful invocation of the DescribeDBParameters
// action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DBParameterGroupDetails
type DescribeDBParametersOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// A list of Parameter values.
	Parameters []*Parameter `locationNameList:"Parameter" type:"list"`
}

// String returns the string representation
func (s DescribeDBParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBParametersOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBParametersOutput) SetMarker(v string) *DescribeDBParametersOutput {
	s.Marker = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *DescribeDBParametersOutput) SetParameters(v []*Parameter) *DescribeDBParametersOutput {
	s.Parameters = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSecurityGroupsMessage
type DescribeDBSecurityGroupsInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB security group to return details for.
	DBSecurityGroupName *string `type:"string"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeDBSecurityGroups
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeDBSecurityGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBSecurityGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBSecurityGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBSecurityGroupsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBSecurityGroupName sets the DBSecurityGroupName field's value.
func (s *DescribeDBSecurityGroupsInput) SetDBSecurityGroupName(v string) *DescribeDBSecurityGroupsInput {
	s.DBSecurityGroupName = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeDBSecurityGroupsInput) SetFilters(v []*Filter) *DescribeDBSecurityGroupsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBSecurityGroupsInput) SetMarker(v string) *DescribeDBSecurityGroupsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeDBSecurityGroupsInput) SetMaxRecords(v int64) *DescribeDBSecurityGroupsInput {
	s.MaxRecords = &v
	return s
}

// Contains the result of a successful invocation of the DescribeDBSecurityGroups
// action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DBSecurityGroupMessage
type DescribeDBSecurityGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A list of DBSecurityGroup instances.
	DBSecurityGroups []*DBSecurityGroup `locationNameList:"DBSecurityGroup" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBSecurityGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBSecurityGroupsOutput) GoString() string {
	return s.String()
}

// SetDBSecurityGroups sets the DBSecurityGroups field's value.
func (s *DescribeDBSecurityGroupsOutput) SetDBSecurityGroups(v []*DBSecurityGroup) *DescribeDBSecurityGroupsOutput {
	s.DBSecurityGroups = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBSecurityGroupsOutput) SetMarker(v string) *DescribeDBSecurityGroupsOutput {
	s.Marker = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshotAttributesMessage
type DescribeDBSnapshotAttributesInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the DB snapshot to describe the attributes for.
	//
	// DBSnapshotIdentifier is a required field
	DBSnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDBSnapshotAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBSnapshotAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBSnapshotAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBSnapshotAttributesInput"}
	if s.DBSnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBSnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBSnapshotIdentifier sets the DBSnapshotIdentifier field's value.
func (s *DescribeDBSnapshotAttributesInput) SetDBSnapshotIdentifier(v string) *DescribeDBSnapshotAttributesInput {
	s.DBSnapshotIdentifier = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshotAttributesResult
type DescribeDBSnapshotAttributesOutput struct {
	_ struct{} `type:"structure"`

	// Contains the results of a successful call to the DescribeDBSnapshotAttributes
	// API action.
	//
	// Manual DB snapshot attributes are used to authorize other AWS accounts to
	// copy or restore a manual DB snapshot. For more information, see the ModifyDBSnapshotAttribute
	// API action.
	DBSnapshotAttributesResult *DBSnapshotAttributesResult `type:"structure"`
}

// String returns the string representation
func (s DescribeDBSnapshotAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBSnapshotAttributesOutput) GoString() string {
	return s.String()
}

// SetDBSnapshotAttributesResult sets the DBSnapshotAttributesResult field's value.
func (s *DescribeDBSnapshotAttributesOutput) SetDBSnapshotAttributesResult(v *DBSnapshotAttributesResult) *DescribeDBSnapshotAttributesOutput {
	s.DBSnapshotAttributesResult = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshotsMessage
type DescribeDBSnapshotsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the DB instance to retrieve the list of DB snapshots for. This
	// parameter cannot be used in conjunction with DBSnapshotIdentifier. This parameter
	// is not case-sensitive.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	DBInstanceIdentifier *string `type:"string"`

	// A specific DB snapshot identifier to describe. This parameter cannot be used
	// in conjunction with DBInstanceIdentifier. This value is stored as a lowercase
	// string.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 alphanumeric characters.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	//    * If this identifier is for an automated snapshot, the SnapshotType parameter
	//    must also be specified.
	DBSnapshotIdentifier *string `type:"string"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// Set this value to true to include manual DB snapshots that are public and
	// can be copied or restored by any AWS account, otherwise set this value to
	// false. The default is false.
	//
	// You can share a manual DB snapshot as public by using the ModifyDBSnapshotAttribute
	// API.
	IncludePublic *bool `type:"boolean"`

	// Set this value to true to include shared manual DB snapshots from other AWS
	// accounts that this AWS account has been given permission to copy or restore,
	// otherwise set this value to false. The default is false.
	//
	// You can give an AWS account permission to restore a manual DB snapshot from
	// another AWS account by using the ModifyDBSnapshotAttribute API action.
	IncludeShared *bool `type:"boolean"`

	// An optional pagination token provided by a previous DescribeDBSnapshots request.
	// If this parameter is specified, the response includes only records beyond
	// the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The type of snapshots to be returned. You can specify one of the following
	// values:
	//
	//    * automated - Return all DB snapshots that have been automatically taken
	//    by Amazon RDS for my AWS account.
	//
	//    * manual - Return all DB snapshots that have been taken by my AWS account.
	//
	//    * shared - Return all manual DB snapshots that have been shared to my
	//    AWS account.
	//
	//    * public - Return all DB snapshots that have been marked as public.
	//
	// If you don't specify a SnapshotType value, then both automated and manual
	// snapshots are returned. Shared and public DB snapshots are not included in
	// the returned results by default. You can include shared snapshots with these
	// results by setting the IncludeShared parameter to true. You can include public
	// snapshots with these results by setting the IncludePublic parameter to true.
	//
	// The IncludeShared and IncludePublic parameters don't apply for SnapshotType
	// values of manual or automated. The IncludePublic parameter doesn't apply
	// when SnapshotType is set to shared. The IncludeShared parameter doesn't apply
	// when SnapshotType is set to public.
	SnapshotType *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBSnapshotsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBSnapshotsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBSnapshotsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBSnapshotsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *DescribeDBSnapshotsInput) SetDBInstanceIdentifier(v string) *DescribeDBSnapshotsInput {
	s.DBInstanceIdentifier = &v
	return s
}

// SetDBSnapshotIdentifier sets the DBSnapshotIdentifier field's value.
func (s *DescribeDBSnapshotsInput) SetDBSnapshotIdentifier(v string) *DescribeDBSnapshotsInput {
	s.DBSnapshotIdentifier = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeDBSnapshotsInput) SetFilters(v []*Filter) *DescribeDBSnapshotsInput {
	s.Filters = v
	return s
}

// SetIncludePublic sets the IncludePublic field's value.
func (s *DescribeDBSnapshotsInput) SetIncludePublic(v bool) *DescribeDBSnapshotsInput {
	s.IncludePublic = &v
	return s
}

// SetIncludeShared sets the IncludeShared field's value.
func (s *DescribeDBSnapshotsInput) SetIncludeShared(v bool) *DescribeDBSnapshotsInput {
	s.IncludeShared = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBSnapshotsInput) SetMarker(v string) *DescribeDBSnapshotsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeDBSnapshotsInput) SetMaxRecords(v int64) *DescribeDBSnapshotsInput {
	s.MaxRecords = &v
	return s
}

// SetSnapshotType sets the SnapshotType field's value.
func (s *DescribeDBSnapshotsInput) SetSnapshotType(v string) *DescribeDBSnapshotsInput {
	s.SnapshotType = &v
	return s
}

// Contains the result of a successful invocation of the DescribeDBSnapshots
// action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DBSnapshotMessage
type DescribeDBSnapshotsOutput struct {
	_ struct{} `type:"structure"`

	// A list of DBSnapshot instances.
	DBSnapshots []*DBSnapshot `locationNameList:"DBSnapshot" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBSnapshotsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBSnapshotsOutput) GoString() string {
	return s.String()
}

// SetDBSnapshots sets the DBSnapshots field's value.
func (s *DescribeDBSnapshotsOutput) SetDBSnapshots(v []*DBSnapshot) *DescribeDBSnapshotsOutput {
	s.DBSnapshots = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBSnapshotsOutput) SetMarker(v string) *DescribeDBSnapshotsOutput {
	s.Marker = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSubnetGroupsMessage
type DescribeDBSubnetGroupsInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB subnet group to return details for.
	DBSubnetGroupName *string `type:"string"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeDBSubnetGroups
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeDBSubnetGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBSubnetGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBSubnetGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDBSubnetGroupsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *DescribeDBSubnetGroupsInput) SetDBSubnetGroupName(v string) *DescribeDBSubnetGroupsInput {
	s.DBSubnetGroupName = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeDBSubnetGroupsInput) SetFilters(v []*Filter) *DescribeDBSubnetGroupsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBSubnetGroupsInput) SetMarker(v string) *DescribeDBSubnetGroupsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeDBSubnetGroupsInput) SetMaxRecords(v int64) *DescribeDBSubnetGroupsInput {
	s.MaxRecords = &v
	return s
}

// Contains the result of a successful invocation of the DescribeDBSubnetGroups
// action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DBSubnetGroupMessage
type DescribeDBSubnetGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A list of DBSubnetGroup instances.
	DBSubnetGroups []*DBSubnetGroup `locationNameList:"DBSubnetGroup" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBSubnetGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDBSubnetGroupsOutput) GoString() string {
	return s.String()
}

// SetDBSubnetGroups sets the DBSubnetGroups field's value.
func (s *DescribeDBSubnetGroupsOutput) SetDBSubnetGroups(v []*DBSubnetGroup) *DescribeDBSubnetGroupsOutput {
	s.DBSubnetGroups = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeDBSubnetGroupsOutput) SetMarker(v string) *DescribeDBSubnetGroupsOutput {
	s.Marker = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEngineDefaultClusterParametersMessage
type DescribeEngineDefaultClusterParametersInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB cluster parameter group family to return engine parameter
	// information for.
	//
	// DBParameterGroupFamily is a required field
	DBParameterGroupFamily *string `type:"string" required:"true"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeEngineDefaultClusterParameters
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeEngineDefaultClusterParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEngineDefaultClusterParametersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEngineDefaultClusterParametersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEngineDefaultClusterParametersInput"}
	if s.DBParameterGroupFamily == nil {
		invalidParams.Add(request.NewErrParamRequired("DBParameterGroupFamily"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBParameterGroupFamily sets the DBParameterGroupFamily field's value.
func (s *DescribeEngineDefaultClusterParametersInput) SetDBParameterGroupFamily(v string) *DescribeEngineDefaultClusterParametersInput {
	s.DBParameterGroupFamily = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeEngineDefaultClusterParametersInput) SetFilters(v []*Filter) *DescribeEngineDefaultClusterParametersInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEngineDefaultClusterParametersInput) SetMarker(v string) *DescribeEngineDefaultClusterParametersInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeEngineDefaultClusterParametersInput) SetMaxRecords(v int64) *DescribeEngineDefaultClusterParametersInput {
	s.MaxRecords = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEngineDefaultClusterParametersResult
type DescribeEngineDefaultClusterParametersOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the DescribeEngineDefaultParameters
	// action.
	EngineDefaults *EngineDefaults `type:"structure"`
}

// String returns the string representation
func (s DescribeEngineDefaultClusterParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEngineDefaultClusterParametersOutput) GoString() string {
	return s.String()
}

// SetEngineDefaults sets the EngineDefaults field's value.
func (s *DescribeEngineDefaultClusterParametersOutput) SetEngineDefaults(v *EngineDefaults) *DescribeEngineDefaultClusterParametersOutput {
	s.EngineDefaults = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEngineDefaultParametersMessage
type DescribeEngineDefaultParametersInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB parameter group family.
	//
	// DBParameterGroupFamily is a required field
	DBParameterGroupFamily *string `type:"string" required:"true"`

	// Not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeEngineDefaultParameters
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeEngineDefaultParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEngineDefaultParametersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEngineDefaultParametersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEngineDefaultParametersInput"}
	if s.DBParameterGroupFamily == nil {
		invalidParams.Add(request.NewErrParamRequired("DBParameterGroupFamily"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBParameterGroupFamily sets the DBParameterGroupFamily field's value.
func (s *DescribeEngineDefaultParametersInput) SetDBParameterGroupFamily(v string) *DescribeEngineDefaultParametersInput {
	s.DBParameterGroupFamily = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeEngineDefaultParametersInput) SetFilters(v []*Filter) *DescribeEngineDefaultParametersInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEngineDefaultParametersInput) SetMarker(v string) *DescribeEngineDefaultParametersInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeEngineDefaultParametersInput) SetMaxRecords(v int64) *DescribeEngineDefaultParametersInput {
	s.MaxRecords = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEngineDefaultParametersResult
type DescribeEngineDefaultParametersOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the DescribeEngineDefaultParameters
	// action.
	EngineDefaults *EngineDefaults `type:"structure"`
}

// String returns the string representation
func (s DescribeEngineDefaultParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEngineDefaultParametersOutput) GoString() string {
	return s.String()
}

// SetEngineDefaults sets the EngineDefaults field's value.
func (s *DescribeEngineDefaultParametersOutput) SetEngineDefaults(v *EngineDefaults) *DescribeEngineDefaultParametersOutput {
	s.EngineDefaults = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEventCategoriesMessage
type DescribeEventCategoriesInput struct {
	_ struct{} `type:"structure"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// The type of source that will be generating the events.
	//
	// Valid values: db-instance | db-parameter-group | db-security-group | db-snapshot
	SourceType *string `type:"string"`
}

// String returns the string representation
func (s DescribeEventCategoriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventCategoriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEventCategoriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEventCategoriesInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeEventCategoriesInput) SetFilters(v []*Filter) *DescribeEventCategoriesInput {
	s.Filters = v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *DescribeEventCategoriesInput) SetSourceType(v string) *DescribeEventCategoriesInput {
	s.SourceType = &v
	return s
}

// Data returned from the DescribeEventCategories action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/EventCategoriesMessage
type DescribeEventCategoriesOutput struct {
	_ struct{} `type:"structure"`

	// A list of EventCategoriesMap data types.
	EventCategoriesMapList []*EventCategoriesMap `locationNameList:"EventCategoriesMap" type:"list"`
}

// String returns the string representation
func (s DescribeEventCategoriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventCategoriesOutput) GoString() string {
	return s.String()
}

// SetEventCategoriesMapList sets the EventCategoriesMapList field's value.
func (s *DescribeEventCategoriesOutput) SetEventCategoriesMapList(v []*EventCategoriesMap) *DescribeEventCategoriesOutput {
	s.EventCategoriesMapList = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEventSubscriptionsMessage
type DescribeEventSubscriptionsInput struct {
	_ struct{} `type:"structure"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords .
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The name of the RDS event notification subscription you want to describe.
	SubscriptionName *string `type:"string"`
}

// String returns the string representation
func (s DescribeEventSubscriptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventSubscriptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEventSubscriptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEventSubscriptionsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeEventSubscriptionsInput) SetFilters(v []*Filter) *DescribeEventSubscriptionsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEventSubscriptionsInput) SetMarker(v string) *DescribeEventSubscriptionsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeEventSubscriptionsInput) SetMaxRecords(v int64) *DescribeEventSubscriptionsInput {
	s.MaxRecords = &v
	return s
}

// SetSubscriptionName sets the SubscriptionName field's value.
func (s *DescribeEventSubscriptionsInput) SetSubscriptionName(v string) *DescribeEventSubscriptionsInput {
	s.SubscriptionName = &v
	return s
}

// Data returned by the DescribeEventSubscriptions action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/EventSubscriptionsMessage
type DescribeEventSubscriptionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of EventSubscriptions data types.
	EventSubscriptionsList []*EventSubscription `locationNameList:"EventSubscription" type:"list"`

	// An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeEventSubscriptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventSubscriptionsOutput) GoString() string {
	return s.String()
}

// SetEventSubscriptionsList sets the EventSubscriptionsList field's value.
func (s *DescribeEventSubscriptionsOutput) SetEventSubscriptionsList(v []*EventSubscription) *DescribeEventSubscriptionsOutput {
	s.EventSubscriptionsList = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEventSubscriptionsOutput) SetMarker(v string) *DescribeEventSubscriptionsOutput {
	s.Marker = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEventsMessage
type DescribeEventsInput struct {
	_ struct{} `type:"structure"`

	// The number of minutes to retrieve events for.
	//
	// Default: 60
	Duration *int64 `type:"integer"`

	// The end of the time interval for which to retrieve events, specified in ISO
	// 8601 format. For more information about ISO 8601, go to the ISO8601 Wikipedia
	// page. (http://en.wikipedia.org/wiki/ISO_8601)
	//
	// Example: 2009-07-08T18:00Z
	EndTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A list of event categories that trigger notifications for a event notification
	// subscription.
	EventCategories []*string `locationNameList:"EventCategory" type:"list"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeEvents request.
	// If this parameter is specified, the response includes only records beyond
	// the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The identifier of the event source for which events will be returned. If
	// not specified, then all sources are included in the response.
	//
	// Constraints:
	//
	//    * If SourceIdentifier is supplied, SourceType must also be provided.
	//
	//    * If the source type is DBInstance, then a DBInstanceIdentifier must be
	//    supplied.
	//
	//    * If the source type is DBSecurityGroup, a DBSecurityGroupName must be
	//    supplied.
	//
	//    * If the source type is DBParameterGroup, a DBParameterGroupName must
	//    be supplied.
	//
	//    * If the source type is DBSnapshot, a DBSnapshotIdentifier must be supplied.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	SourceIdentifier *string `type:"string"`

	// The event source to retrieve events for. If no value is specified, all events
	// are returned.
	SourceType *string `type:"string" enum:"SourceType"`

	// The beginning of the time interval to retrieve events for, specified in ISO
	// 8601 format. For more information about ISO 8601, go to the ISO8601 Wikipedia
	// page. (http://en.wikipedia.org/wiki/ISO_8601)
	//
	// Example: 2009-07-08T18:00Z
	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s DescribeEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEventsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDuration sets the Duration field's value.
func (s *DescribeEventsInput) SetDuration(v int64) *DescribeEventsInput {
	s.Duration = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeEventsInput) SetEndTime(v time.Time) *DescribeEventsInput {
	s.EndTime = &v
	return s
}

// SetEventCategories sets the EventCategories field's value.
func (s *DescribeEventsInput) SetEventCategories(v []*string) *DescribeEventsInput {
	s.EventCategories = v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeEventsInput) SetFilters(v []*Filter) *DescribeEventsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEventsInput) SetMarker(v string) *DescribeEventsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeEventsInput) SetMaxRecords(v int64) *DescribeEventsInput {
	s.MaxRecords = &v
	return s
}

// SetSourceIdentifier sets the SourceIdentifier field's value.
func (s *DescribeEventsInput) SetSourceIdentifier(v string) *DescribeEventsInput {
	s.SourceIdentifier = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *DescribeEventsInput) SetSourceType(v string) *DescribeEventsInput {
	s.SourceType = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeEventsInput) SetStartTime(v time.Time) *DescribeEventsInput {
	s.StartTime = &v
	return s
}

// Contains the result of a successful invocation of the DescribeEvents action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/EventsMessage
type DescribeEventsOutput struct {
	_ struct{} `type:"structure"`

	// A list of Event instances.
	Events []*Event `locationNameList:"Event" type:"list"`

	// An optional pagination token provided by a previous Events request. If this
	// parameter is specified, the response includes only records beyond the marker,
	// up to the value specified by MaxRecords .
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventsOutput) GoString() string {
	return s.String()
}

// SetEvents sets the Events field's value.
func (s *DescribeEventsOutput) SetEvents(v []*Event) *DescribeEventsOutput {
	s.Events = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEventsOutput) SetMarker(v string) *DescribeEventsOutput {
	s.Marker = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOptionGroupOptionsMessage
type DescribeOptionGroupOptionsInput struct {
	_ struct{} `type:"structure"`

	// A required parameter. Options available for the given engine name will be
	// described.
	//
	// EngineName is a required field
	EngineName *string `type:"string" required:"true"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// If specified, filters the results to include only options for the specified
	// major engine version.
	MajorEngineVersion *string `type:"string"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeOptionGroupOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOptionGroupOptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeOptionGroupOptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeOptionGroupOptionsInput"}
	if s.EngineName == nil {
		invalidParams.Add(request.NewErrParamRequired("EngineName"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEngineName sets the EngineName field's value.
func (s *DescribeOptionGroupOptionsInput) SetEngineName(v string) *DescribeOptionGroupOptionsInput {
	s.EngineName = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeOptionGroupOptionsInput) SetFilters(v []*Filter) *DescribeOptionGroupOptionsInput {
	s.Filters = v
	return s
}

// SetMajorEngineVersion sets the MajorEngineVersion field's value.
func (s *DescribeOptionGroupOptionsInput) SetMajorEngineVersion(v string) *DescribeOptionGroupOptionsInput {
	s.MajorEngineVersion = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeOptionGroupOptionsInput) SetMarker(v string) *DescribeOptionGroupOptionsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeOptionGroupOptionsInput) SetMaxRecords(v int64) *DescribeOptionGroupOptionsInput {
	s.MaxRecords = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/OptionGroupOptionsMessage
type DescribeOptionGroupOptionsOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// List of available option group options.
	OptionGroupOptions []*OptionGroupOption `locationNameList:"OptionGroupOption" type:"list"`
}

// String returns the string representation
func (s DescribeOptionGroupOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOptionGroupOptionsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeOptionGroupOptionsOutput) SetMarker(v string) *DescribeOptionGroupOptionsOutput {
	s.Marker = &v
	return s
}

// SetOptionGroupOptions sets the OptionGroupOptions field's value.
func (s *DescribeOptionGroupOptionsOutput) SetOptionGroupOptions(v []*OptionGroupOption) *DescribeOptionGroupOptionsOutput {
	s.OptionGroupOptions = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOptionGroupsMessage
type DescribeOptionGroupsInput struct {
	_ struct{} `type:"structure"`

	// Filters the list of option groups to only include groups associated with
	// a specific database engine.
	EngineName *string `type:"string"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// Filters the list of option groups to only include groups associated with
	// a specific database engine version. If specified, then EngineName must also
	// be specified.
	MajorEngineVersion *string `type:"string"`

	// An optional pagination token provided by a previous DescribeOptionGroups
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The name of the option group to describe. Cannot be supplied together with
	// EngineName or MajorEngineVersion.
	OptionGroupName *string `type:"string"`
}

// String returns the string representation
func (s DescribeOptionGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOptionGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeOptionGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeOptionGroupsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEngineName sets the EngineName field's value.
func (s *DescribeOptionGroupsInput) SetEngineName(v string) *DescribeOptionGroupsInput {
	s.EngineName = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeOptionGroupsInput) SetFilters(v []*Filter) *DescribeOptionGroupsInput {
	s.Filters = v
	return s
}

// SetMajorEngineVersion sets the MajorEngineVersion field's value.
func (s *DescribeOptionGroupsInput) SetMajorEngineVersion(v string) *DescribeOptionGroupsInput {
	s.MajorEngineVersion = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeOptionGroupsInput) SetMarker(v string) *DescribeOptionGroupsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeOptionGroupsInput) SetMaxRecords(v int64) *DescribeOptionGroupsInput {
	s.MaxRecords = &v
	return s
}

// SetOptionGroupName sets the OptionGroupName field's value.
func (s *DescribeOptionGroupsInput) SetOptionGroupName(v string) *DescribeOptionGroupsInput {
	s.OptionGroupName = &v
	return s
}

// List of option groups.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/OptionGroups
type DescribeOptionGroupsOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// List of option groups.
	OptionGroupsList []*OptionGroup `locationNameList:"OptionGroup" type:"list"`
}

// String returns the string representation
func (s DescribeOptionGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOptionGroupsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeOptionGroupsOutput) SetMarker(v string) *DescribeOptionGroupsOutput {
	s.Marker = &v
	return s
}

// SetOptionGroupsList sets the OptionGroupsList field's value.
func (s *DescribeOptionGroupsOutput) SetOptionGroupsList(v []*OptionGroup) *DescribeOptionGroupsOutput {
	s.OptionGroupsList = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOrderableDBInstanceOptionsMessage
type DescribeOrderableDBInstanceOptionsInput struct {
	_ struct{} `type:"structure"`

	// The DB instance class filter value. Specify this parameter to show only the
	// available offerings matching the specified DB instance class.
	DBInstanceClass *string `type:"string"`

	// The name of the engine to retrieve DB instance options for.
	//
	// Engine is a required field
	Engine *string `type:"string" required:"true"`

	// The engine version filter value. Specify this parameter to show only the
	// available offerings matching the specified engine version.
	EngineVersion *string `type:"string"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// The license model filter value. Specify this parameter to show only the available
	// offerings matching the specified license model.
	LicenseModel *string `type:"string"`

	// An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords .
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The VPC filter value. Specify this parameter to show only the available VPC
	// or non-VPC offerings.
	Vpc *bool `type:"boolean"`
}

// String returns the string representation
func (s DescribeOrderableDBInstanceOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrderableDBInstanceOptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeOrderableDBInstanceOptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeOrderableDBInstanceOptionsInput"}
	if s.Engine == nil {
		invalidParams.Add(request.NewErrParamRequired("Engine"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBInstanceClass sets the DBInstanceClass field's value.
func (s *DescribeOrderableDBInstanceOptionsInput) SetDBInstanceClass(v string) *DescribeOrderableDBInstanceOptionsInput {
	s.DBInstanceClass = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *DescribeOrderableDBInstanceOptionsInput) SetEngine(v string) *DescribeOrderableDBInstanceOptionsInput {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *DescribeOrderableDBInstanceOptionsInput) SetEngineVersion(v string) *DescribeOrderableDBInstanceOptionsInput {
	s.EngineVersion = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeOrderableDBInstanceOptionsInput) SetFilters(v []*Filter) *DescribeOrderableDBInstanceOptionsInput {
	s.Filters = v
	return s
}

// SetLicenseModel sets the LicenseModel field's value.
func (s *DescribeOrderableDBInstanceOptionsInput) SetLicenseModel(v string) *DescribeOrderableDBInstanceOptionsInput {
	s.LicenseModel = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeOrderableDBInstanceOptionsInput) SetMarker(v string) *DescribeOrderableDBInstanceOptionsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeOrderableDBInstanceOptionsInput) SetMaxRecords(v int64) *DescribeOrderableDBInstanceOptionsInput {
	s.MaxRecords = &v
	return s
}

// SetVpc sets the Vpc field's value.
func (s *DescribeOrderableDBInstanceOptionsInput) SetVpc(v bool) *DescribeOrderableDBInstanceOptionsInput {
	s.Vpc = &v
	return s
}

// Contains the result of a successful invocation of the DescribeOrderableDBInstanceOptions
// action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/OrderableDBInstanceOptionsMessage
type DescribeOrderableDBInstanceOptionsOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous OrderableDBInstanceOptions
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords .
	Marker *string `type:"string"`

	// An OrderableDBInstanceOption structure containing information about orderable
	// options for the DB instance.
	OrderableDBInstanceOptions []*OrderableDBInstanceOption `locationNameList:"OrderableDBInstanceOption" type:"list"`
}

// String returns the string representation
func (s DescribeOrderableDBInstanceOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrderableDBInstanceOptionsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeOrderableDBInstanceOptionsOutput) SetMarker(v string) *DescribeOrderableDBInstanceOptionsOutput {
	s.Marker = &v
	return s
}

// SetOrderableDBInstanceOptions sets the OrderableDBInstanceOptions field's value.
func (s *DescribeOrderableDBInstanceOptionsOutput) SetOrderableDBInstanceOptions(v []*OrderableDBInstanceOption) *DescribeOrderableDBInstanceOptionsOutput {
	s.OrderableDBInstanceOptions = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribePendingMaintenanceActionsMessage
type DescribePendingMaintenanceActionsInput struct {
	_ struct{} `type:"structure"`

	// A filter that specifies one or more resources to return pending maintenance
	// actions for.
	//
	// Supported filters:
	//
	//    * db-cluster-id - Accepts DB cluster identifiers and DB cluster Amazon
	//    Resource Names (ARNs). The results list will only include pending maintenance
	//    actions for the DB clusters identified by these ARNs.
	//
	//    * db-instance-id - Accepts DB instance identifiers and DB instance ARNs.
	//    The results list will only include pending maintenance actions for the
	//    DB instances identified by these ARNs.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribePendingMaintenanceActions
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to a number of records specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The ARN of a resource to return pending maintenance actions for.
	ResourceIdentifier *string `type:"string"`
}

// String returns the string representation
func (s DescribePendingMaintenanceActionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePendingMaintenanceActionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePendingMaintenanceActionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePendingMaintenanceActionsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribePendingMaintenanceActionsInput) SetFilters(v []*Filter) *DescribePendingMaintenanceActionsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribePendingMaintenanceActionsInput) SetMarker(v string) *DescribePendingMaintenanceActionsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribePendingMaintenanceActionsInput) SetMaxRecords(v int64) *DescribePendingMaintenanceActionsInput {
	s.MaxRecords = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *DescribePendingMaintenanceActionsInput) SetResourceIdentifier(v string) *DescribePendingMaintenanceActionsInput {
	s.ResourceIdentifier = &v
	return s
}

// Data returned from the DescribePendingMaintenanceActions action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/PendingMaintenanceActionsMessage
type DescribePendingMaintenanceActionsOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous DescribePendingMaintenanceActions
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to a number of records specified by MaxRecords.
	Marker *string `type:"string"`

	// A list of the pending maintenance actions for the resource.
	PendingMaintenanceActions []*ResourcePendingMaintenanceActions `locationNameList:"ResourcePendingMaintenanceActions" type:"list"`
}

// String returns the string representation
func (s DescribePendingMaintenanceActionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePendingMaintenanceActionsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribePendingMaintenanceActionsOutput) SetMarker(v string) *DescribePendingMaintenanceActionsOutput {
	s.Marker = &v
	return s
}

// SetPendingMaintenanceActions sets the PendingMaintenanceActions field's value.
func (s *DescribePendingMaintenanceActionsOutput) SetPendingMaintenanceActions(v []*ResourcePendingMaintenanceActions) *DescribePendingMaintenanceActionsOutput {
	s.PendingMaintenanceActions = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstancesMessage
type DescribeReservedDBInstancesInput struct {
	_ struct{} `type:"structure"`

	// The DB instance class filter value. Specify this parameter to show only those
	// reservations matching the specified DB instances class.
	DBInstanceClass *string `type:"string"`

	// The duration filter value, specified in years or seconds. Specify this parameter
	// to show only reservations for this duration.
	//
	// Valid Values: 1 | 3 | 31536000 | 94608000
	Duration *string `type:"string"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more than the
	// MaxRecords value is available, a pagination token called a marker is included
	// in the response so that the following results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The Multi-AZ filter value. Specify this parameter to show only those reservations
	// matching the specified Multi-AZ parameter.
	MultiAZ *bool `type:"boolean"`

	// The offering type filter value. Specify this parameter to show only the available
	// offerings matching the specified offering type.
	//
	// Valid Values: "Partial Upfront" | "All Upfront" | "No Upfront"
	OfferingType *string `type:"string"`

	// The product description filter value. Specify this parameter to show only
	// those reservations matching the specified product description.
	ProductDescription *string `type:"string"`

	// The reserved DB instance identifier filter value. Specify this parameter
	// to show only the reservation that matches the specified reservation ID.
	ReservedDBInstanceId *string `type:"string"`

	// The offering identifier filter value. Specify this parameter to show only
	// purchased reservations matching the specified offering identifier.
	ReservedDBInstancesOfferingId *string `type:"string"`
}

// String returns the string representation
func (s DescribeReservedDBInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservedDBInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReservedDBInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReservedDBInstancesInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBInstanceClass sets the DBInstanceClass field's value.
func (s *DescribeReservedDBInstancesInput) SetDBInstanceClass(v string) *DescribeReservedDBInstancesInput {
	s.DBInstanceClass = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *DescribeReservedDBInstancesInput) SetDuration(v string) *DescribeReservedDBInstancesInput {
	s.Duration = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeReservedDBInstancesInput) SetFilters(v []*Filter) *DescribeReservedDBInstancesInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeReservedDBInstancesInput) SetMarker(v string) *DescribeReservedDBInstancesInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeReservedDBInstancesInput) SetMaxRecords(v int64) *DescribeReservedDBInstancesInput {
	s.MaxRecords = &v
	return s
}

// SetMultiAZ sets the MultiAZ field's value.
func (s *DescribeReservedDBInstancesInput) SetMultiAZ(v bool) *DescribeReservedDBInstancesInput {
	s.MultiAZ = &v
	return s
}

// SetOfferingType sets the OfferingType field's value.
func (s *DescribeReservedDBInstancesInput) SetOfferingType(v string) *DescribeReservedDBInstancesInput {
	s.OfferingType = &v
	return s
}

// SetProductDescription sets the ProductDescription field's value.
func (s *DescribeReservedDBInstancesInput) SetProductDescription(v string) *DescribeReservedDBInstancesInput {
	s.ProductDescription = &v
	return s
}

// SetReservedDBInstanceId sets the ReservedDBInstanceId field's value.
func (s *DescribeReservedDBInstancesInput) SetReservedDBInstanceId(v string) *DescribeReservedDBInstancesInput {
	s.ReservedDBInstanceId = &v
	return s
}

// SetReservedDBInstancesOfferingId sets the ReservedDBInstancesOfferingId field's value.
func (s *DescribeReservedDBInstancesInput) SetReservedDBInstancesOfferingId(v string) *DescribeReservedDBInstancesInput {
	s.ReservedDBInstancesOfferingId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstancesOfferingsMessage
type DescribeReservedDBInstancesOfferingsInput struct {
	_ struct{} `type:"structure"`

	// The DB instance class filter value. Specify this parameter to show only the
	// available offerings matching the specified DB instance class.
	DBInstanceClass *string `type:"string"`

	// Duration filter value, specified in years or seconds. Specify this parameter
	// to show only reservations for this duration.
	//
	// Valid Values: 1 | 3 | 31536000 | 94608000
	Duration *string `type:"string"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more than the
	// MaxRecords value is available, a pagination token called a marker is included
	// in the response so that the following results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The Multi-AZ filter value. Specify this parameter to show only the available
	// offerings matching the specified Multi-AZ parameter.
	MultiAZ *bool `type:"boolean"`

	// The offering type filter value. Specify this parameter to show only the available
	// offerings matching the specified offering type.
	//
	// Valid Values: "Partial Upfront" | "All Upfront" | "No Upfront"
	OfferingType *string `type:"string"`

	// Product description filter value. Specify this parameter to show only the
	// available offerings matching the specified product description.
	ProductDescription *string `type:"string"`

	// The offering identifier filter value. Specify this parameter to show only
	// the available offering that matches the specified reservation identifier.
	//
	// Example: 438012d3-4052-4cc7-b2e3-8d3372e0e706
	ReservedDBInstancesOfferingId *string `type:"string"`
}

// String returns the string representation
func (s DescribeReservedDBInstancesOfferingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservedDBInstancesOfferingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReservedDBInstancesOfferingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReservedDBInstancesOfferingsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBInstanceClass sets the DBInstanceClass field's value.
func (s *DescribeReservedDBInstancesOfferingsInput) SetDBInstanceClass(v string) *DescribeReservedDBInstancesOfferingsInput {
	s.DBInstanceClass = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *DescribeReservedDBInstancesOfferingsInput) SetDuration(v string) *DescribeReservedDBInstancesOfferingsInput {
	s.Duration = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeReservedDBInstancesOfferingsInput) SetFilters(v []*Filter) *DescribeReservedDBInstancesOfferingsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeReservedDBInstancesOfferingsInput) SetMarker(v string) *DescribeReservedDBInstancesOfferingsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeReservedDBInstancesOfferingsInput) SetMaxRecords(v int64) *DescribeReservedDBInstancesOfferingsInput {
	s.MaxRecords = &v
	return s
}

// SetMultiAZ sets the MultiAZ field's value.
func (s *DescribeReservedDBInstancesOfferingsInput) SetMultiAZ(v bool) *DescribeReservedDBInstancesOfferingsInput {
	s.MultiAZ = &v
	return s
}

// SetOfferingType sets the OfferingType field's value.
func (s *DescribeReservedDBInstancesOfferingsInput) SetOfferingType(v string) *DescribeReservedDBInstancesOfferingsInput {
	s.OfferingType = &v
	return s
}

// SetProductDescription sets the ProductDescription field's value.
func (s *DescribeReservedDBInstancesOfferingsInput) SetProductDescription(v string) *DescribeReservedDBInstancesOfferingsInput {
	s.ProductDescription = &v
	return s
}

// SetReservedDBInstancesOfferingId sets the ReservedDBInstancesOfferingId field's value.
func (s *DescribeReservedDBInstancesOfferingsInput) SetReservedDBInstancesOfferingId(v string) *DescribeReservedDBInstancesOfferingsInput {
	s.ReservedDBInstancesOfferingId = &v
	return s
}

// Contains the result of a successful invocation of the DescribeReservedDBInstancesOfferings
// action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ReservedDBInstancesOfferingMessage
type DescribeReservedDBInstancesOfferingsOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// A list of reserved DB instance offerings.
	ReservedDBInstancesOfferings []*ReservedDBInstancesOffering `locationNameList:"ReservedDBInstancesOffering" type:"list"`
}

// String returns the string representation
func (s DescribeReservedDBInstancesOfferingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservedDBInstancesOfferingsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeReservedDBInstancesOfferingsOutput) SetMarker(v string) *DescribeReservedDBInstancesOfferingsOutput {
	s.Marker = &v
	return s
}

// SetReservedDBInstancesOfferings sets the ReservedDBInstancesOfferings field's value.
func (s *DescribeReservedDBInstancesOfferingsOutput) SetReservedDBInstancesOfferings(v []*ReservedDBInstancesOffering) *DescribeReservedDBInstancesOfferingsOutput {
	s.ReservedDBInstancesOfferings = v
	return s
}

// Contains the result of a successful invocation of the DescribeReservedDBInstances
// action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ReservedDBInstanceMessage
type DescribeReservedDBInstancesOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// A list of reserved DB instances.
	ReservedDBInstances []*ReservedDBInstance `locationNameList:"ReservedDBInstance" type:"list"`
}

// String returns the string representation
func (s DescribeReservedDBInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservedDBInstancesOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeReservedDBInstancesOutput) SetMarker(v string) *DescribeReservedDBInstancesOutput {
	s.Marker = &v
	return s
}

// SetReservedDBInstances sets the ReservedDBInstances field's value.
func (s *DescribeReservedDBInstancesOutput) SetReservedDBInstances(v []*ReservedDBInstance) *DescribeReservedDBInstancesOutput {
	s.ReservedDBInstances = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeSourceRegionsMessage
type DescribeSourceRegionsInput struct {
	_ struct{} `type:"structure"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeSourceRegions
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The source AWS Region name. For example, us-east-1.
	//
	// Constraints:
	//
	//    * Must specify a valid AWS Region name.
	RegionName *string `type:"string"`
}

// String returns the string representation
func (s DescribeSourceRegionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSourceRegionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSourceRegionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSourceRegionsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeSourceRegionsInput) SetFilters(v []*Filter) *DescribeSourceRegionsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeSourceRegionsInput) SetMarker(v string) *DescribeSourceRegionsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeSourceRegionsInput) SetMaxRecords(v int64) *DescribeSourceRegionsInput {
	s.MaxRecords = &v
	return s
}

// SetRegionName sets the RegionName field's value.
func (s *DescribeSourceRegionsInput) SetRegionName(v string) *DescribeSourceRegionsInput {
	s.RegionName = &v
	return s
}

// Contains the result of a successful invocation of the DescribeSourceRegions
// action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/SourceRegionMessage
type DescribeSourceRegionsOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// A list of SourceRegion instances that contains each source AWS Region that
	// the current AWS Region can get a Read Replica or a DB snapshot from.
	SourceRegions []*SourceRegion `locationNameList:"SourceRegion" type:"list"`
}

// String returns the string representation
func (s DescribeSourceRegionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSourceRegionsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeSourceRegionsOutput) SetMarker(v string) *DescribeSourceRegionsOutput {
	s.Marker = &v
	return s
}

// SetSourceRegions sets the SourceRegions field's value.
func (s *DescribeSourceRegionsOutput) SetSourceRegions(v []*SourceRegion) *DescribeSourceRegionsOutput {
	s.SourceRegions = v
	return s
}

// An Active Directory Domain membership record associated with the DB instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DomainMembership
type DomainMembership struct {
	_ struct{} `type:"structure"`

	// The identifier of the Active Directory Domain.
	Domain *string `type:"string"`

	// The fully qualified domain name of the Active Directory Domain.
	FQDN *string `type:"string"`

	// The name of the IAM role to be used when making API calls to the Directory
	// Service.
	IAMRoleName *string `type:"string"`

	// The status of the DB instance's Active Directory Domain membership, such
	// as joined, pending-join, failed etc).
	Status *string `type:"string"`
}

// String returns the string representation
func (s DomainMembership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainMembership) GoString() string {
	return s.String()
}

// SetDomain sets the Domain field's value.
func (s *DomainMembership) SetDomain(v string) *DomainMembership {
	s.Domain = &v
	return s
}

// SetFQDN sets the FQDN field's value.
func (s *DomainMembership) SetFQDN(v string) *DomainMembership {
	s.FQDN = &v
	return s
}

// SetIAMRoleName sets the IAMRoleName field's value.
func (s *DomainMembership) SetIAMRoleName(v string) *DomainMembership {
	s.IAMRoleName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DomainMembership) SetStatus(v string) *DomainMembership {
	s.Status = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DownloadDBLogFilePortionMessage
type DownloadDBLogFilePortionInput struct {
	_ struct{} `type:"structure"`

	// The customer-assigned name of the DB instance that contains the log files
	// you want to list.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	// DBInstanceIdentifier is a required field
	DBInstanceIdentifier *string `type:"string" required:"true"`

	// The name of the log file to be downloaded.
	//
	// LogFileName is a required field
	LogFileName *string `type:"string" required:"true"`

	// The pagination token provided in the previous request or "0". If the Marker
	// parameter is specified the response includes only records beyond the marker
	// until the end of the file or up to NumberOfLines.
	Marker *string `type:"string"`

	// The number of lines to download. If the number of lines specified results
	// in a file over 1 MB in size, the file will be truncated at 1 MB in size.
	//
	// If the NumberOfLines parameter is specified, then the block of lines returned
	// can be from the beginning or the end of the log file, depending on the value
	// of the Marker parameter.
	//
	//    * If neither Marker or NumberOfLines are specified, the entire log file
	//    is returned up to a maximum of 10000 lines, starting with the most recent
	//    log entries first.
	//
	//    * If NumberOfLines is specified and Marker is not specified, then the
	//    most recent lines from the end of the log file are returned.
	//
	//    * If Marker is specified as "0", then the specified number of lines from
	//    the beginning of the log file are returned.
	//
	//    * You can download the log file in blocks of lines by specifying the size
	//    of the block using the NumberOfLines parameter, and by specifying a value
	//    of "0" for the Marker parameter in your first request. Include the Marker
	//    value returned in the response as the Marker value for the next request,
	//    continuing until the AdditionalDataPending response element returns false.
	NumberOfLines *int64 `type:"integer"`
}

// String returns the string representation
func (s DownloadDBLogFilePortionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DownloadDBLogFilePortionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DownloadDBLogFilePortionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DownloadDBLogFilePortionInput"}
	if s.DBInstanceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBInstanceIdentifier"))
	}
	if s.LogFileName == nil {
		invalidParams.Add(request.NewErrParamRequired("LogFileName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *DownloadDBLogFilePortionInput) SetDBInstanceIdentifier(v string) *DownloadDBLogFilePortionInput {
	s.DBInstanceIdentifier = &v
	return s
}

// SetLogFileName sets the LogFileName field's value.
func (s *DownloadDBLogFilePortionInput) SetLogFileName(v string) *DownloadDBLogFilePortionInput {
	s.LogFileName = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DownloadDBLogFilePortionInput) SetMarker(v string) *DownloadDBLogFilePortionInput {
	s.Marker = &v
	return s
}

// SetNumberOfLines sets the NumberOfLines field's value.
func (s *DownloadDBLogFilePortionInput) SetNumberOfLines(v int64) *DownloadDBLogFilePortionInput {
	s.NumberOfLines = &v
	return s
}

// This data type is used as a response element to DownloadDBLogFilePortion.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DownloadDBLogFilePortionDetails
type DownloadDBLogFilePortionOutput struct {
	_ struct{} `type:"structure"`

	// Boolean value that if true, indicates there is more data to be downloaded.
	AdditionalDataPending *bool `type:"boolean"`

	// Entries from the specified log file.
	LogFileData *string `type:"string"`

	// A pagination token that can be used in a subsequent DownloadDBLogFilePortion
	// request.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DownloadDBLogFilePortionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DownloadDBLogFilePortionOutput) GoString() string {
	return s.String()
}

// SetAdditionalDataPending sets the AdditionalDataPending field's value.
func (s *DownloadDBLogFilePortionOutput) SetAdditionalDataPending(v bool) *DownloadDBLogFilePortionOutput {
	s.AdditionalDataPending = &v
	return s
}

// SetLogFileData sets the LogFileData field's value.
func (s *DownloadDBLogFilePortionOutput) SetLogFileData(v string) *DownloadDBLogFilePortionOutput {
	s.LogFileData = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DownloadDBLogFilePortionOutput) SetMarker(v string) *DownloadDBLogFilePortionOutput {
	s.Marker = &v
	return s
}

// This data type is used as a response element in the following actions:
//
//    * AuthorizeDBSecurityGroupIngress
//
//    * DescribeDBSecurityGroups
//
//    * RevokeDBSecurityGroupIngress
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/EC2SecurityGroup
type EC2SecurityGroup struct {
	_ struct{} `type:"structure"`

	// Specifies the id of the EC2 security group.
	EC2SecurityGroupId *string `type:"string"`

	// Specifies the name of the EC2 security group.
	EC2SecurityGroupName *string `type:"string"`

	// Specifies the AWS ID of the owner of the EC2 security group specified in
	// the EC2SecurityGroupName field.
	EC2SecurityGroupOwnerId *string `type:"string"`

	// Provides the status of the EC2 security group. Status can be "authorizing",
	// "authorized", "revoking", and "revoked".
	Status *string `type:"string"`
}

// String returns the string representation
func (s EC2SecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EC2SecurityGroup) GoString() string {
	return s.String()
}

// SetEC2SecurityGroupId sets the EC2SecurityGroupId field's value.
func (s *EC2SecurityGroup) SetEC2SecurityGroupId(v string) *EC2SecurityGroup {
	s.EC2SecurityGroupId = &v
	return s
}

// SetEC2SecurityGroupName sets the EC2SecurityGroupName field's value.
func (s *EC2SecurityGroup) SetEC2SecurityGroupName(v string) *EC2SecurityGroup {
	s.EC2SecurityGroupName = &v
	return s
}

// SetEC2SecurityGroupOwnerId sets the EC2SecurityGroupOwnerId field's value.
func (s *EC2SecurityGroup) SetEC2SecurityGroupOwnerId(v string) *EC2SecurityGroup {
	s.EC2SecurityGroupOwnerId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *EC2SecurityGroup) SetStatus(v string) *EC2SecurityGroup {
	s.Status = &v
	return s
}

// This data type is used as a response element in the following actions:
//
//    * CreateDBInstance
//
//    * DescribeDBInstances
//
//    * DeleteDBInstance
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/Endpoint
type Endpoint struct {
	_ struct{} `type:"structure"`

	// Specifies the DNS address of the DB instance.
	Address *string `type:"string"`

	// Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
	HostedZoneId *string `type:"string"`

	// Specifies the port that the database engine is listening on.
	Port *int64 `type:"integer"`
}

// String returns the string representation
func (s Endpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Endpoint) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *Endpoint) SetAddress(v string) *Endpoint {
	s.Address = &v
	return s
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *Endpoint) SetHostedZoneId(v string) *Endpoint {
	s.HostedZoneId = &v
	return s
}

// SetPort sets the Port field's value.
func (s *Endpoint) SetPort(v int64) *Endpoint {
	s.Port = &v
	return s
}

// Contains the result of a successful invocation of the DescribeEngineDefaultParameters
// action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/EngineDefaults
type EngineDefaults struct {
	_ struct{} `type:"structure"`

	// Specifies the name of the DB parameter group family that the engine default
	// parameters apply to.
	DBParameterGroupFamily *string `type:"string"`

	// An optional pagination token provided by a previous EngineDefaults request.
	// If this parameter is specified, the response includes only records beyond
	// the marker, up to the value specified by MaxRecords .
	Marker *string `type:"string"`

	// Contains a list of engine default parameters.
	Parameters []*Parameter `locationNameList:"Parameter" type:"list"`
}

// String returns the string representation
func (s EngineDefaults) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EngineDefaults) GoString() string {
	return s.String()
}

// SetDBParameterGroupFamily sets the DBParameterGroupFamily field's value.
func (s *EngineDefaults) SetDBParameterGroupFamily(v string) *EngineDefaults {
	s.DBParameterGroupFamily = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *EngineDefaults) SetMarker(v string) *EngineDefaults {
	s.Marker = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *EngineDefaults) SetParameters(v []*Parameter) *EngineDefaults {
	s.Parameters = v
	return s
}

// This data type is used as a response element in the DescribeEvents action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/Event
type Event struct {
	_ struct{} `type:"structure"`

	// Specifies the date and time of the event.
	Date *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Specifies the category for the event.
	EventCategories []*string `locationNameList:"EventCategory" type:"list"`

	// Provides the text of this event.
	Message *string `type:"string"`

	// The Amazon Resource Name (ARN) for the event.
	SourceArn *string `type:"string"`

	// Provides the identifier for the source of the event.
	SourceIdentifier *string `type:"string"`

	// Specifies the source type for this event.
	SourceType *string `type:"string" enum:"SourceType"`
}

// String returns the string representation
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Event) GoString() string {
	return s.String()
}

// SetDate sets the Date field's value.
func (s *Event) SetDate(v time.Time) *Event {
	s.Date = &v
	return s
}

// SetEventCategories sets the EventCategories field's value.
func (s *Event) SetEventCategories(v []*string) *Event {
	s.EventCategories = v
	return s
}

// SetMessage sets the Message field's value.
func (s *Event) SetMessage(v string) *Event {
	s.Message = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *Event) SetSourceArn(v string) *Event {
	s.SourceArn = &v
	return s
}

// SetSourceIdentifier sets the SourceIdentifier field's value.
func (s *Event) SetSourceIdentifier(v string) *Event {
	s.SourceIdentifier = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *Event) SetSourceType(v string) *Event {
	s.SourceType = &v
	return s
}

// Contains the results of a successful invocation of the DescribeEventCategories
// action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/EventCategoriesMap
type EventCategoriesMap struct {
	_ struct{} `type:"structure"`

	// The event categories for the specified source type
	EventCategories []*string `locationNameList:"EventCategory" type:"list"`

	// The source type that the returned categories belong to
	SourceType *string `type:"string"`
}

// String returns the string representation
func (s EventCategoriesMap) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventCategoriesMap) GoString() string {
	return s.String()
}

// SetEventCategories sets the EventCategories field's value.
func (s *EventCategoriesMap) SetEventCategories(v []*string) *EventCategoriesMap {
	s.EventCategories = v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *EventCategoriesMap) SetSourceType(v string) *EventCategoriesMap {
	s.SourceType = &v
	return s
}

// Contains the results of a successful invocation of the DescribeEventSubscriptions
// action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/EventSubscription
type EventSubscription struct {
	_ struct{} `type:"structure"`

	// The RDS event notification subscription Id.
	CustSubscriptionId *string `type:"string"`

	// The AWS customer account associated with the RDS event notification subscription.
	CustomerAwsId *string `type:"string"`

	// A Boolean value indicating if the subscription is enabled. True indicates
	// the subscription is enabled.
	Enabled *bool `type:"boolean"`

	// A list of event categories for the RDS event notification subscription.
	EventCategoriesList []*string `locationNameList:"EventCategory" type:"list"`

	// The Amazon Resource Name (ARN) for the event subscription.
	EventSubscriptionArn *string `type:"string"`

	// The topic ARN of the RDS event notification subscription.
	SnsTopicArn *string `type:"string"`

	// A list of source IDs for the RDS event notification subscription.
	SourceIdsList []*string `locationNameList:"SourceId" type:"list"`

	// The source type for the RDS event notification subscription.
	SourceType *string `type:"string"`

	// The status of the RDS event notification subscription.
	//
	// Constraints:
	//
	// Can be one of the following: creating | modifying | deleting | active | no-permission
	// | topic-not-exist
	//
	// The status "no-permission" indicates that RDS no longer has permission to
	// post to the SNS topic. The status "topic-not-exist" indicates that the topic
	// was deleted after the subscription was created.
	Status *string `type:"string"`

	// The time the RDS event notification subscription was created.
	SubscriptionCreationTime *string `type:"string"`
}

// String returns the string representation
func (s EventSubscription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventSubscription) GoString() string {
	return s.String()
}

// SetCustSubscriptionId sets the CustSubscriptionId field's value.
func (s *EventSubscription) SetCustSubscriptionId(v string) *EventSubscription {
	s.CustSubscriptionId = &v
	return s
}

// SetCustomerAwsId sets the CustomerAwsId field's value.
func (s *EventSubscription) SetCustomerAwsId(v string) *EventSubscription {
	s.CustomerAwsId = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *EventSubscription) SetEnabled(v bool) *EventSubscription {
	s.Enabled = &v
	return s
}

// SetEventCategoriesList sets the EventCategoriesList field's value.
func (s *EventSubscription) SetEventCategoriesList(v []*string) *EventSubscription {
	s.EventCategoriesList = v
	return s
}

// SetEventSubscriptionArn sets the EventSubscriptionArn field's value.
func (s *EventSubscription) SetEventSubscriptionArn(v string) *EventSubscription {
	s.EventSubscriptionArn = &v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *EventSubscription) SetSnsTopicArn(v string) *EventSubscription {
	s.SnsTopicArn = &v
	return s
}

// SetSourceIdsList sets the SourceIdsList field's value.
func (s *EventSubscription) SetSourceIdsList(v []*string) *EventSubscription {
	s.SourceIdsList = v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *EventSubscription) SetSourceType(v string) *EventSubscription {
	s.SourceType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *EventSubscription) SetStatus(v string) *EventSubscription {
	s.Status = &v
	return s
}

// SetSubscriptionCreationTime sets the SubscriptionCreationTime field's value.
func (s *EventSubscription) SetSubscriptionCreationTime(v string) *EventSubscription {
	s.SubscriptionCreationTime = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/FailoverDBClusterMessage
type FailoverDBClusterInput struct {
	_ struct{} `type:"structure"`

	// A DB cluster identifier to force a failover for. This parameter is not case-sensitive.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	DBClusterIdentifier *string `type:"string"`

	// The name of the instance to promote to the primary instance.
	//
	// You must specify the instance identifier for an Aurora Replica in the DB
	// cluster. For example, mydbcluster-replica1.
	TargetDBInstanceIdentifier *string `type:"string"`
}

// String returns the string representation
func (s FailoverDBClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailoverDBClusterInput) GoString() string {
	return s.String()
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *FailoverDBClusterInput) SetDBClusterIdentifier(v string) *FailoverDBClusterInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetTargetDBInstanceIdentifier sets the TargetDBInstanceIdentifier field's value.
func (s *FailoverDBClusterInput) SetTargetDBInstanceIdentifier(v string) *FailoverDBClusterInput {
	s.TargetDBInstanceIdentifier = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/FailoverDBClusterResult
type FailoverDBClusterOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//    * CreateDBCluster
	//
	//    * DeleteDBCluster
	//
	//    * FailoverDBCluster
	//
	//    * ModifyDBCluster
	//
	//    * RestoreDBClusterFromSnapshot
	//
	//    * RestoreDBClusterToPointInTime
	//
	// This data type is used as a response element in the DescribeDBClusters action.
	DBCluster *DBCluster `type:"structure"`
}

// String returns the string representation
func (s FailoverDBClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailoverDBClusterOutput) GoString() string {
	return s.String()
}

// SetDBCluster sets the DBCluster field's value.
func (s *FailoverDBClusterOutput) SetDBCluster(v *DBCluster) *FailoverDBClusterOutput {
	s.DBCluster = v
	return s
}

// This type is not currently supported.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/Filter
type Filter struct {
	_ struct{} `type:"structure"`

	// This parameter is not currently supported.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// This parameter is not currently supported.
	//
	// Values is a required field
	Values []*string `locationNameList:"Value" type:"list" required:"true"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Filter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Filter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *Filter) SetName(v string) *Filter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *Filter) SetValues(v []*string) *Filter {
	s.Values = v
	return s
}

// This data type is used as a response element in the DescribeDBSecurityGroups
// action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/IPRange
type IPRange struct {
	_ struct{} `type:"structure"`

	// Specifies the IP range.
	CIDRIP *string `type:"string"`

	// Specifies the status of the IP range. Status can be "authorizing", "authorized",
	// "revoking", and "revoked".
	Status *string `type:"string"`
}

// String returns the string representation
func (s IPRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IPRange) GoString() string {
	return s.String()
}

// SetCIDRIP sets the CIDRIP field's value.
func (s *IPRange) SetCIDRIP(v string) *IPRange {
	s.CIDRIP = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *IPRange) SetStatus(v string) *IPRange {
	s.Status = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ListTagsForResourceMessage
type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// This parameter is not currently supported.
	Filters []*Filter `locationNameList:"Filter" type:"list"`

	// The Amazon RDS resource with tags to be listed. This value is an Amazon Resource
	// Name (ARN). For information about creating an ARN, see  Constructing an RDS
	// Amazon Resource Name (ARN) (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing).
	//
	// ResourceName is a required field
	ResourceName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListTagsForResourceInput) SetFilters(v []*Filter) *ListTagsForResourceInput {
	s.Filters = v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *ListTagsForResourceInput) SetResourceName(v string) *ListTagsForResourceInput {
	s.ResourceName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/TagListMessage
type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// List of tags returned by the ListTagsForResource operation.
	TagList []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTagList sets the TagList field's value.
func (s *ListTagsForResourceOutput) SetTagList(v []*Tag) *ListTagsForResourceOutput {
	s.TagList = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBClusterMessage
type ModifyDBClusterInput struct {
	_ struct{} `type:"structure"`

	// A value that specifies whether the modifications in this request and any
	// pending modifications are asynchronously applied as soon as possible, regardless
	// of the PreferredMaintenanceWindow setting for the DB cluster. If this parameter
	// is set to false, changes to the DB cluster are applied during the next maintenance
	// window.
	//
	// The ApplyImmediately parameter only affects the NewDBClusterIdentifier and
	// MasterUserPassword values. If you set the ApplyImmediately parameter value
	// to false, then changes to the NewDBClusterIdentifier and MasterUserPassword
	// values are applied during the next maintenance window. All other changes
	// are applied immediately, regardless of the value of the ApplyImmediately
	// parameter.
	//
	// Default: false
	ApplyImmediately *bool `type:"boolean"`

	// The number of days for which automated backups are retained. You must specify
	// a minimum value of 1.
	//
	// Default: 1
	//
	// Constraints:
	//
	//    * Must be a value from 1 to 35
	BackupRetentionPeriod *int64 `type:"integer"`

	// The DB cluster identifier for the cluster being modified. This parameter
	// is not case-sensitive.
	//
	// Constraints:
	//
	//    * Must be the identifier for an existing DB cluster.
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// DBClusterIdentifier is a required field
	DBClusterIdentifier *string `type:"string" required:"true"`

	// The name of the DB cluster parameter group to use for the DB cluster.
	DBClusterParameterGroupName *string `type:"string"`

	// A Boolean value that is true to enable mapping of AWS Identity and Access
	// Management (IAM) accounts to database accounts, and otherwise false.
	//
	// Default: false
	EnableIAMDatabaseAuthentication *bool `type:"boolean"`

	// The new password for the master database user. This password can contain
	// any printable ASCII character except "/", """, or "@".
	//
	// Constraints: Must contain from 8 to 41 characters.
	MasterUserPassword *string `type:"string"`

	// The new DB cluster identifier for the DB cluster when renaming a DB cluster.
	// This value is stored as a lowercase string.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	// Example: my-cluster2
	NewDBClusterIdentifier *string `type:"string"`

	// A value that indicates that the DB cluster should be associated with the
	// specified option group. Changing this parameter does not result in an outage
	// except in the following case, and the change is applied during the next maintenance
	// window unless the ApplyImmediately parameter is set to true for this request.
	// If the parameter change results in an option group that enables OEM, this
	// change can cause a brief (sub-second) period during which new connections
	// are rejected but existing connections are not interrupted.
	//
	// Permanent options cannot be removed from an option group. The option group
	// cannot be removed from a DB cluster once it is associated with a DB cluster.
	OptionGroupName *string `type:"string"`

	// The port number on which the DB cluster accepts connections.
	//
	// Constraints: Value must be 1150-65535
	//
	// Default: The same port as the original DB cluster.
	Port *int64 `type:"integer"`

	// The daily time range during which automated backups are created if automated
	// backups are enabled, using the BackupRetentionPeriod parameter.
	//
	// Default: A 30-minute window selected at random from an 8-hour block of time
	// per AWS Region. To see the time blocks available, see  Adjusting the Preferred
	// Maintenance Window (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html)
	// in the Amazon RDS User Guide.
	//
	// Constraints:
	//
	//    * Must be in the format hh24:mi-hh24:mi.
	//
	//    * Times should be in Universal Coordinated Time (UTC).
	//
	//    * Must not conflict with the preferred maintenance window.
	//
	//    * Must be at least 30 minutes.
	PreferredBackupWindow *string `type:"string"`

	// The weekly time range during which system maintenance can occur, in Universal
	// Coordinated Time (UTC).
	//
	// Format: ddd:hh24:mi-ddd:hh24:mi
	//
	// Default: A 30-minute window selected at random from an 8-hour block of time
	// per AWS Region, occurring on a random day of the week. To see the time blocks
	// available, see  Adjusting the Preferred Maintenance Window (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html)
	// in the Amazon RDS User Guide.
	//
	// Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
	//
	// Constraints: Minimum 30-minute window.
	PreferredMaintenanceWindow *string `type:"string"`

	// A list of VPC security groups that the DB cluster will belong to.
	VpcSecurityGroupIds []*string `locationNameList:"VpcSecurityGroupId" type:"list"`
}

// String returns the string representation
func (s ModifyDBClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyDBClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyDBClusterInput"}
	if s.DBClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplyImmediately sets the ApplyImmediately field's value.
func (s *ModifyDBClusterInput) SetApplyImmediately(v bool) *ModifyDBClusterInput {
	s.ApplyImmediately = &v
	return s
}

// SetBackupRetentionPeriod sets the BackupRetentionPeriod field's value.
func (s *ModifyDBClusterInput) SetBackupRetentionPeriod(v int64) *ModifyDBClusterInput {
	s.BackupRetentionPeriod = &v
	return s
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *ModifyDBClusterInput) SetDBClusterIdentifier(v string) *ModifyDBClusterInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *ModifyDBClusterInput) SetDBClusterParameterGroupName(v string) *ModifyDBClusterInput {
	s.DBClusterParameterGroupName = &v
	return s
}

// SetEnableIAMDatabaseAuthentication sets the EnableIAMDatabaseAuthentication field's value.
func (s *ModifyDBClusterInput) SetEnableIAMDatabaseAuthentication(v bool) *ModifyDBClusterInput {
	s.EnableIAMDatabaseAuthentication = &v
	return s
}

// SetMasterUserPassword sets the MasterUserPassword field's value.
func (s *ModifyDBClusterInput) SetMasterUserPassword(v string) *ModifyDBClusterInput {
	s.MasterUserPassword = &v
	return s
}

// SetNewDBClusterIdentifier sets the NewDBClusterIdentifier field's value.
func (s *ModifyDBClusterInput) SetNewDBClusterIdentifier(v string) *ModifyDBClusterInput {
	s.NewDBClusterIdentifier = &v
	return s
}

// SetOptionGroupName sets the OptionGroupName field's value.
func (s *ModifyDBClusterInput) SetOptionGroupName(v string) *ModifyDBClusterInput {
	s.OptionGroupName = &v
	return s
}

// SetPort sets the Port field's value.
func (s *ModifyDBClusterInput) SetPort(v int64) *ModifyDBClusterInput {
	s.Port = &v
	return s
}

// SetPreferredBackupWindow sets the PreferredBackupWindow field's value.
func (s *ModifyDBClusterInput) SetPreferredBackupWindow(v string) *ModifyDBClusterInput {
	s.PreferredBackupWindow = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *ModifyDBClusterInput) SetPreferredMaintenanceWindow(v string) *ModifyDBClusterInput {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *ModifyDBClusterInput) SetVpcSecurityGroupIds(v []*string) *ModifyDBClusterInput {
	s.VpcSecurityGroupIds = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBClusterResult
type ModifyDBClusterOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//    * CreateDBCluster
	//
	//    * DeleteDBCluster
	//
	//    * FailoverDBCluster
	//
	//    * ModifyDBCluster
	//
	//    * RestoreDBClusterFromSnapshot
	//
	//    * RestoreDBClusterToPointInTime
	//
	// This data type is used as a response element in the DescribeDBClusters action.
	DBCluster *DBCluster `type:"structure"`
}

// String returns the string representation
func (s ModifyDBClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBClusterOutput) GoString() string {
	return s.String()
}

// SetDBCluster sets the DBCluster field's value.
func (s *ModifyDBClusterOutput) SetDBCluster(v *DBCluster) *ModifyDBClusterOutput {
	s.DBCluster = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBClusterParameterGroupMessage
type ModifyDBClusterParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB cluster parameter group to modify.
	//
	// DBClusterParameterGroupName is a required field
	DBClusterParameterGroupName *string `type:"string" required:"true"`

	// A list of parameters in the DB cluster parameter group to modify.
	//
	// Parameters is a required field
	Parameters []*Parameter `locationNameList:"Parameter" type:"list" required:"true"`
}

// String returns the string representation
func (s ModifyDBClusterParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBClusterParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyDBClusterParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyDBClusterParameterGroupInput"}
	if s.DBClusterParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterParameterGroupName"))
	}
	if s.Parameters == nil {
		invalidParams.Add(request.NewErrParamRequired("Parameters"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *ModifyDBClusterParameterGroupInput) SetDBClusterParameterGroupName(v string) *ModifyDBClusterParameterGroupInput {
	s.DBClusterParameterGroupName = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *ModifyDBClusterParameterGroupInput) SetParameters(v []*Parameter) *ModifyDBClusterParameterGroupInput {
	s.Parameters = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBClusterSnapshotAttributeMessage
type ModifyDBClusterSnapshotAttributeInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB cluster snapshot attribute to modify.
	//
	// To manage authorization for other AWS accounts to copy or restore a manual
	// DB cluster snapshot, set this value to restore.
	//
	// AttributeName is a required field
	AttributeName *string `type:"string" required:"true"`

	// The identifier for the DB cluster snapshot to modify the attributes for.
	//
	// DBClusterSnapshotIdentifier is a required field
	DBClusterSnapshotIdentifier *string `type:"string" required:"true"`

	// A list of DB cluster snapshot attributes to add to the attribute specified
	// by AttributeName.
	//
	// To authorize other AWS accounts to copy or restore a manual DB cluster snapshot,
	// set this list to include one or more AWS account IDs, or all to make the
	// manual DB cluster snapshot restorable by any AWS account. Do not add the
	// all value for any manual DB cluster snapshots that contain private information
	// that you don't want available to all AWS accounts.
	ValuesToAdd []*string `locationNameList:"AttributeValue" type:"list"`

	// A list of DB cluster snapshot attributes to remove from the attribute specified
	// by AttributeName.
	//
	// To remove authorization for other AWS accounts to copy or restore a manual
	// DB cluster snapshot, set this list to include one or more AWS account identifiers,
	// or all to remove authorization for any AWS account to copy or restore the
	// DB cluster snapshot. If you specify all, an AWS account whose account ID
	// is explicitly added to the restore attribute can still copy or restore a
	// manual DB cluster snapshot.
	ValuesToRemove []*string `locationNameList:"AttributeValue" type:"list"`
}

// String returns the string representation
func (s ModifyDBClusterSnapshotAttributeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBClusterSnapshotAttributeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyDBClusterSnapshotAttributeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyDBClusterSnapshotAttributeInput"}
	if s.AttributeName == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeName"))
	}
	if s.DBClusterSnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterSnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeName sets the AttributeName field's value.
func (s *ModifyDBClusterSnapshotAttributeInput) SetAttributeName(v string) *ModifyDBClusterSnapshotAttributeInput {
	s.AttributeName = &v
	return s
}

// SetDBClusterSnapshotIdentifier sets the DBClusterSnapshotIdentifier field's value.
func (s *ModifyDBClusterSnapshotAttributeInput) SetDBClusterSnapshotIdentifier(v string) *ModifyDBClusterSnapshotAttributeInput {
	s.DBClusterSnapshotIdentifier = &v
	return s
}

// SetValuesToAdd sets the ValuesToAdd field's value.
func (s *ModifyDBClusterSnapshotAttributeInput) SetValuesToAdd(v []*string) *ModifyDBClusterSnapshotAttributeInput {
	s.ValuesToAdd = v
	return s
}

// SetValuesToRemove sets the ValuesToRemove field's value.
func (s *ModifyDBClusterSnapshotAttributeInput) SetValuesToRemove(v []*string) *ModifyDBClusterSnapshotAttributeInput {
	s.ValuesToRemove = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBClusterSnapshotAttributeResult
type ModifyDBClusterSnapshotAttributeOutput struct {
	_ struct{} `type:"structure"`

	// Contains the results of a successful call to the DescribeDBClusterSnapshotAttributes
	// API action.
	//
	// Manual DB cluster snapshot attributes are used to authorize other AWS accounts
	// to copy or restore a manual DB cluster snapshot. For more information, see
	// the ModifyDBClusterSnapshotAttribute API action.
	DBClusterSnapshotAttributesResult *DBClusterSnapshotAttributesResult `type:"structure"`
}

// String returns the string representation
func (s ModifyDBClusterSnapshotAttributeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBClusterSnapshotAttributeOutput) GoString() string {
	return s.String()
}

// SetDBClusterSnapshotAttributesResult sets the DBClusterSnapshotAttributesResult field's value.
func (s *ModifyDBClusterSnapshotAttributeOutput) SetDBClusterSnapshotAttributesResult(v *DBClusterSnapshotAttributesResult) *ModifyDBClusterSnapshotAttributeOutput {
	s.DBClusterSnapshotAttributesResult = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBInstanceMessage
type ModifyDBInstanceInput struct {
	_ struct{} `type:"structure"`

	// The new storage capacity of the RDS instance. Changing this setting does
	// not result in an outage and the change is applied during the next maintenance
	// window unless ApplyImmediately is set to true for this request.
	//
	// MySQL
	//
	// Default: Uses existing setting
	//
	// Valid Values: 5-6144
	//
	// Constraints: Value supplied must be at least 10% greater than the current
	// value. Values that are not at least 10% greater than the existing value are
	// rounded up so that they are 10% greater than the current value.
	//
	// Type: Integer
	//
	// MariaDB
	//
	// Default: Uses existing setting
	//
	// Valid Values: 5-6144
	//
	// Constraints: Value supplied must be at least 10% greater than the current
	// value. Values that are not at least 10% greater than the existing value are
	// rounded up so that they are 10% greater than the current value.
	//
	// Type: Integer
	//
	// PostgreSQL
	//
	// Default: Uses existing setting
	//
	// Valid Values: 5-6144
	//
	// Constraints: Value supplied must be at least 10% greater than the current
	// value. Values that are not at least 10% greater than the existing value are
	// rounded up so that they are 10% greater than the current value.
	//
	// Type: Integer
	//
	// Oracle
	//
	// Default: Uses existing setting
	//
	// Valid Values: 10-6144
	//
	// Constraints: Value supplied must be at least 10% greater than the current
	// value. Values that are not at least 10% greater than the existing value are
	// rounded up so that they are 10% greater than the current value.
	//
	// SQL Server
	//
	// Cannot be modified.
	//
	// If you choose to migrate your DB instance from using standard storage to
	// using Provisioned IOPS, or from using Provisioned IOPS to using standard
	// storage, the process can take time. The duration of the migration depends
	// on several factors such as database load, storage size, storage type (standard
	// or Provisioned IOPS), amount of IOPS provisioned (if any), and the number
	// of prior scale storage operations. Typical migration times are under 24 hours,
	// but the process can take up to several days in some cases. During the migration,
	// the DB instance will be available for use, but might experience performance
	// degradation. While the migration takes place, nightly backups for the instance
	// will be suspended. No other Amazon RDS operations can take place for the
	// instance, including modifying the instance, rebooting the instance, deleting
	// the instance, creating a Read Replica for the instance, and creating a DB
	// snapshot of the instance.
	AllocatedStorage *int64 `type:"integer"`

	// Indicates that major version upgrades are allowed. Changing this parameter
	// does not result in an outage and the change is asynchronously applied as
	// soon as possible.
	//
	// Constraints: This parameter must be set to true when specifying a value for
	// the EngineVersion parameter that is a different major version than the DB
	// instance's current version.
	AllowMajorVersionUpgrade *bool `type:"boolean"`

	// Specifies whether the modifications in this request and any pending modifications
	// are asynchronously applied as soon as possible, regardless of the PreferredMaintenanceWindow
	// setting for the DB instance.
	//
	// If this parameter is set to false, changes to the DB instance are applied
	// during the next maintenance window. Some parameter changes can cause an outage
	// and will be applied on the next call to RebootDBInstance, or the next failure
	// reboot. Review the table of parameters in Modifying a DB Instance and Using
	// the Apply Immediately Parameter (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html)
	// to see the impact that setting ApplyImmediately to true or false has for
	// each modified parameter and to determine when the changes will be applied.
	//
	// Default: false
	ApplyImmediately *bool `type:"boolean"`

	// Indicates that minor version upgrades will be applied automatically to the
	// DB instance during the maintenance window. Changing this parameter does not
	// result in an outage except in the following case and the change is asynchronously
	// applied as soon as possible. An outage will result if this parameter is set
	// to true during the maintenance window, and a newer minor version is available,
	// and RDS has enabled auto patching for that engine version.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// The number of days to retain automated backups. Setting this parameter to
	// a positive number enables backups. Setting this parameter to 0 disables automated
	// backups.
	//
	// Changing this parameter can result in an outage if you change from 0 to a
	// non-zero value or from a non-zero value to 0. These changes are applied during
	// the next maintenance window unless the ApplyImmediately parameter is set
	// to true for this request. If you change the parameter from one non-zero value
	// to another non-zero value, the change is asynchronously applied as soon as
	// possible.
	//
	// Amazon Aurora
	//
	// Not applicable. The retention period for automated backups is managed by
	// the DB cluster. For more information, see ModifyDBCluster.
	//
	// Default: Uses existing setting
	//
	// Constraints:
	//
	//    * Must be a value from 0 to 35
	//
	//    * Can be specified for a MySQL Read Replica only if the source is running
	//    MySQL 5.6
	//
	//    * Can be specified for a PostgreSQL Read Replica only if the source is
	//    running PostgreSQL 9.3.5
	//
	//    * Cannot be set to 0 if the DB instance is a source to Read Replicas
	BackupRetentionPeriod *int64 `type:"integer"`

	// Indicates the certificate that needs to be associated with the instance.
	CACertificateIdentifier *string `type:"string"`

	// True to copy all tags from the DB instance to snapshots of the DB instance;
	// otherwise false. The default is false.
	CopyTagsToSnapshot *bool `type:"boolean"`

	// The new compute and memory capacity of the DB instance. To determine the
	// instance classes that are available for a particular DB engine, use the DescribeOrderableDBInstanceOptions
	// action. Note that not all instance classes are available in all regions for
	// all DB engines.
	//
	// Passing a value for this setting causes an outage during the change and is
	// applied during the next maintenance window, unless ApplyImmediately is specified
	// as true for this request.
	//
	// Default: Uses existing setting
	//
	// Valid Values: db.t1.micro | db.m1.small | db.m1.medium | db.m1.large | db.m1.xlarge
	// | db.m2.xlarge | db.m2.2xlarge | db.m2.4xlarge | db.m3.medium | db.m3.large
	// | db.m3.xlarge | db.m3.2xlarge | db.m4.large | db.m4.xlarge | db.m4.2xlarge
	// | db.m4.4xlarge | db.m4.10xlarge | db.r3.large | db.r3.xlarge | db.r3.2xlarge
	// | db.r3.4xlarge | db.r3.8xlarge | db.t2.micro | db.t2.small | db.t2.medium
	// | db.t2.large
	DBInstanceClass *string `type:"string"`

	// The DB instance identifier. This value is stored as a lowercase string.
	//
	// Constraints:
	//
	//    * Must be the identifier for an existing DB instance
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	// DBInstanceIdentifier is a required field
	DBInstanceIdentifier *string `type:"string" required:"true"`

	// The name of the DB parameter group to apply to the DB instance. Changing
	// this setting does not result in an outage. The parameter group name itself
	// is changed immediately, but the actual parameter changes are not applied
	// until you reboot the instance without failover. The db instance will NOT
	// be rebooted automatically and the parameter changes will NOT be applied during
	// the next maintenance window.
	//
	// Default: Uses existing setting
	//
	// Constraints: The DB parameter group must be in the same DB parameter group
	// family as this DB instance.
	DBParameterGroupName *string `type:"string"`

	// The port number on which the database accepts connections.
	//
	// The value of the DBPortNumber parameter must not match any of the port values
	// specified for options in the option group for the DB instance.
	//
	// Your database will restart when you change the DBPortNumber value regardless
	// of the value of the ApplyImmediately parameter.
	//
	// MySQL
	//
	// Default: 3306
	//
	// Valid Values: 1150-65535
	//
	// MariaDB
	//
	// Default: 3306
	//
	// Valid Values: 1150-65535
	//
	// PostgreSQL
	//
	// Default: 5432
	//
	// Valid Values: 1150-65535
	//
	// Type: Integer
	//
	// Oracle
	//
	// Default: 1521
	//
	// Valid Values: 1150-65535
	//
	// SQL Server
	//
	// Default: 1433
	//
	// Valid Values: 1150-65535 except for 1434, 3389, 47001, 49152, and 49152 through
	// 49156.
	//
	// Amazon Aurora
	//
	// Default: 3306
	//
	// Valid Values: 1150-65535
	DBPortNumber *int64 `type:"integer"`

	// A list of DB security groups to authorize on this DB instance. Changing this
	// setting does not result in an outage and the change is asynchronously applied
	// as soon as possible.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 alphanumeric characters
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	DBSecurityGroups []*string `locationNameList:"DBSecurityGroupName" type:"list"`

	// The new DB subnet group for the DB instance. You can use this parameter to
	// move your DB instance to a different VPC. If your DB instance is not in a
	// VPC, you can also use this parameter to move your DB instance into a VPC.
	// For more information, see Updating the VPC for a DB Instance (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html#USER_VPC.Non-VPC2VPC).
	//
	// Changing the subnet group causes an outage during the change. The change
	// is applied during the next maintenance window, unless you specify true for
	// the ApplyImmediately parameter.
	//
	// Constraints: Must contain no more than 255 alphanumeric characters, periods,
	// underscores, spaces, or hyphens.
	//
	// Example: mySubnetGroup
	DBSubnetGroupName *string `type:"string"`

	// The Active Directory Domain to move the instance to. Specify none to remove
	// the instance from its current domain. The domain must be created prior to
	// this operation. Currently only a Microsoft SQL Server instance can be created
	// in a Active Directory Domain.
	Domain *string `type:"string"`

	// The name of the IAM role to use when making API calls to the Directory Service.
	DomainIAMRoleName *string `type:"string"`

	// True to enable mapping of AWS Identity and Access Management (IAM) accounts
	// to database accounts; otherwise false.
	//
	// You can enable IAM database authentication for the following database engines
	//
	// Amazon Aurora
	//
	// Not applicable. Mapping AWS IAM accounts to database accounts is managed
	// by the DB cluster. For more information, see ModifyDBCluster.
	//
	// MySQL
	//
	//    * For MySQL 5.6, minor version 5.6.34 or higher
	//
	//    * For MySQL 5.7, minor version 5.7.16 or higher
	//
	// Default: false
	EnableIAMDatabaseAuthentication *bool `type:"boolean"`

	// The version number of the database engine to upgrade to. Changing this parameter
	// results in an outage and the change is applied during the next maintenance
	// window unless the ApplyImmediately parameter is set to true for this request.
	//
	// For major version upgrades, if a nondefault DB parameter group is currently
	// in use, a new DB parameter group in the DB parameter group family for the
	// new engine version must be specified. The new DB parameter group can be the
	// default for that DB parameter group family.
	//
	// For a list of valid engine versions, see CreateDBInstance.
	EngineVersion *string `type:"string"`

	// The new Provisioned IOPS (I/O operations per second) value for the RDS instance.
	// Changing this setting does not result in an outage and the change is applied
	// during the next maintenance window unless the ApplyImmediately parameter
	// is set to true for this request.
	//
	// Default: Uses existing setting
	//
	// Constraints: Value supplied must be at least 10% greater than the current
	// value. Values that are not at least 10% greater than the existing value are
	// rounded up so that they are 10% greater than the current value. If you are
	// migrating from Provisioned IOPS to standard storage, set this value to 0.
	// The DB instance will require a reboot for the change in storage type to take
	// effect.
	//
	// SQL Server
	//
	// Setting the IOPS value for the SQL Server database engine is not supported.
	//
	// Type: Integer
	//
	// If you choose to migrate your DB instance from using standard storage to
	// using Provisioned IOPS, or from using Provisioned IOPS to using standard
	// storage, the process can take time. The duration of the migration depends
	// on several factors such as database load, storage size, storage type (standard
	// or Provisioned IOPS), amount of IOPS provisioned (if any), and the number
	// of prior scale storage operations. Typical migration times are under 24 hours,
	// but the process can take up to several days in some cases. During the migration,
	// the DB instance will be available for use, but might experience performance
	// degradation. While the migration takes place, nightly backups for the instance
	// will be suspended. No other Amazon RDS operations can take place for the
	// instance, including modifying the instance, rebooting the instance, deleting
	// the instance, creating a Read Replica for the instance, and creating a DB
	// snapshot of the instance.
	Iops *int64 `type:"integer"`

	// The license model for the DB instance.
	//
	// Valid values: license-included | bring-your-own-license | general-public-license
	LicenseModel *string `type:"string"`

	// The new password for the master user. Can be any printable ASCII character
	// except "/", """, or "@".
	//
	// Changing this parameter does not result in an outage and the change is asynchronously
	// applied as soon as possible. Between the time of the request and the completion
	// of the request, the MasterUserPassword element exists in the PendingModifiedValues
	// element of the operation response.
	//
	// Amazon Aurora
	//
	// Not applicable. The password for the master user is managed by the DB cluster.
	// For more information, see ModifyDBCluster.
	//
	// Default: Uses existing setting
	//
	// Constraints: Must be 8 to 41 alphanumeric characters (MySQL, MariaDB, and
	// Amazon Aurora), 8 to 30 alphanumeric characters (Oracle), or 8 to 128 alphanumeric
	// characters (SQL Server).
	//
	// Amazon RDS API actions never return the password, so this action provides
	// a way to regain access to a primary instance user if the password is lost.
	// This includes restoring privileges that might have been accidentally revoked.
	MasterUserPassword *string `type:"string"`

	// The interval, in seconds, between points when Enhanced Monitoring metrics
	// are collected for the DB instance. To disable collecting Enhanced Monitoring
	// metrics, specify 0. The default is 0.
	//
	// If MonitoringRoleArn is specified, then you must also set MonitoringInterval
	// to a value other than 0.
	//
	// Valid Values: 0, 1, 5, 10, 15, 30, 60
	MonitoringInterval *int64 `type:"integer"`

	// The ARN for the IAM role that permits RDS to send enhanced monitoring metrics
	// to CloudWatch Logs. For example, arn:aws:iam:123456789012:role/emaccess.
	// For information on creating a monitoring role, go to To create an IAM role
	// for Amazon RDS Enhanced Monitoring (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole).
	//
	// If MonitoringInterval is set to a value other than 0, then you must supply
	// a MonitoringRoleArn value.
	MonitoringRoleArn *string `type:"string"`

	// Specifies if the DB instance is a Multi-AZ deployment. Changing this parameter
	// does not result in an outage and the change is applied during the next maintenance
	// window unless the ApplyImmediately parameter is set to true for this request.
	//
	// Constraints: Cannot be specified if the DB instance is a Read Replica.
	MultiAZ *bool `type:"boolean"`

	// The new DB instance identifier for the DB instance when renaming a DB instance.
	// When you change the DB instance identifier, an instance reboot will occur
	// immediately if you set Apply Immediately to true, or will occur during the
	// next maintenance window if Apply Immediately to false. This value is stored
	// as a lowercase string.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	NewDBInstanceIdentifier *string `type:"string"`

	// Indicates that the DB instance should be associated with the specified option
	// group. Changing this parameter does not result in an outage except in the
	// following case and the change is applied during the next maintenance window
	// unless the ApplyImmediately parameter is set to true for this request. If
	// the parameter change results in an option group that enables OEM, this change
	// can cause a brief (sub-second) period during which new connections are rejected
	// but existing connections are not interrupted.
	//
	// Permanent options, such as the TDE option for Oracle Advanced Security TDE,
	// cannot be removed from an option group, and that option group cannot be removed
	// from a DB instance once it is associated with a DB instance
	OptionGroupName *string `type:"string"`

	// The daily time range during which automated backups are created if automated
	// backups are enabled, as determined by the BackupRetentionPeriod parameter.
	// Changing this parameter does not result in an outage and the change is asynchronously
	// applied as soon as possible.
	//
	// Amazon Aurora
	//
	// Not applicable. The daily time range for creating automated backups is managed
	// by the DB cluster. For more information, see ModifyDBCluster.
	//
	// Constraints:
	//
	//    * Must be in the format hh24:mi-hh24:mi
	//
	//    * Times should be in Universal Time Coordinated (UTC)
	//
	//    * Must not conflict with the preferred maintenance window
	//
	//    * Must be at least 30 minutes
	PreferredBackupWindow *string `type:"string"`

	// The weekly time range (in UTC) during which system maintenance can occur,
	// which might result in an outage. Changing this parameter does not result
	// in an outage, except in the following situation, and the change is asynchronously
	// applied as soon as possible. If there are pending actions that cause a reboot,
	// and the maintenance window is changed to include the current time, then changing
	// this parameter will cause a reboot of the DB instance. If moving this window
	// to the current time, there must be at least 30 minutes between the current
	// time and end of the window to ensure pending changes are applied.
	//
	// Default: Uses existing setting
	//
	// Format: ddd:hh24:mi-ddd:hh24:mi
	//
	// Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
	//
	// Constraints: Must be at least 30 minutes
	PreferredMaintenanceWindow *string `type:"string"`

	// A value that specifies the order in which an Aurora Replica is promoted to
	// the primary instance after a failure of the existing primary instance. For
	// more information, see  Fault Tolerance for an Aurora DB Cluster (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Aurora.Managing.html#Aurora.Managing.FaultTolerance).
	//
	// Default: 1
	//
	// Valid Values: 0 - 15
	PromotionTier *int64 `type:"integer"`

	// Boolean value that indicates if the DB instance has a publicly resolvable
	// DNS name. Set to True to make the DB instance Internet-facing with a publicly
	// resolvable DNS name, which resolves to a public IP address. Set to False
	// to make the DB instance internal with a DNS name that resolves to a private
	// IP address.
	//
	// PubliclyAccessible only applies to DB instances in a VPC. The DB instance
	// must be part of a public subnet and PubliclyAccessible must be true in order
	// for it to be publicly accessible.
	//
	// Changes to the PubliclyAccessible parameter are applied immediately regardless
	// of the value of the ApplyImmediately parameter.
	//
	// Default: false
	PubliclyAccessible *bool `type:"boolean"`

	// Specifies the storage type to be associated with the DB instance.
	//
	// Valid values: standard | gp2 | io1
	//
	// If you specify io1, you must also include a value for the Iops parameter.
	//
	// Default: io1 if the Iops parameter is specified; otherwise standard
	StorageType *string `type:"string"`

	// The ARN from the Key Store with which to associate the instance for TDE encryption.
	TdeCredentialArn *string `type:"string"`

	// The password for the given ARN from the Key Store in order to access the
	// device.
	TdeCredentialPassword *string `type:"string"`

	// A list of EC2 VPC security groups to authorize on this DB instance. This
	// change is asynchronously applied as soon as possible.
	//
	// Amazon Aurora
	//
	// Not applicable. The associated list of EC2 VPC security groups is managed
	// by the DB cluster. For more information, see ModifyDBCluster.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 alphanumeric characters
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	VpcSecurityGroupIds []*string `locationNameList:"VpcSecurityGroupId" type:"list"`
}

// String returns the string representation
func (s ModifyDBInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyDBInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyDBInstanceInput"}
	if s.DBInstanceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBInstanceIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *ModifyDBInstanceInput) SetAllocatedStorage(v int64) *ModifyDBInstanceInput {
	s.AllocatedStorage = &v
	return s
}

// SetAllowMajorVersionUpgrade sets the AllowMajorVersionUpgrade field's value.
func (s *ModifyDBInstanceInput) SetAllowMajorVersionUpgrade(v bool) *ModifyDBInstanceInput {
	s.AllowMajorVersionUpgrade = &v
	return s
}

// SetApplyImmediately sets the ApplyImmediately field's value.
func (s *ModifyDBInstanceInput) SetApplyImmediately(v bool) *ModifyDBInstanceInput {
	s.ApplyImmediately = &v
	return s
}

// SetAutoMinorVersionUpgrade sets the AutoMinorVersionUpgrade field's value.
func (s *ModifyDBInstanceInput) SetAutoMinorVersionUpgrade(v bool) *ModifyDBInstanceInput {
	s.AutoMinorVersionUpgrade = &v
	return s
}

// SetBackupRetentionPeriod sets the BackupRetentionPeriod field's value.
func (s *ModifyDBInstanceInput) SetBackupRetentionPeriod(v int64) *ModifyDBInstanceInput {
	s.BackupRetentionPeriod = &v
	return s
}

// SetCACertificateIdentifier sets the CACertificateIdentifier field's value.
func (s *ModifyDBInstanceInput) SetCACertificateIdentifier(v string) *ModifyDBInstanceInput {
	s.CACertificateIdentifier = &v
	return s
}

// SetCopyTagsToSnapshot sets the CopyTagsToSnapshot field's value.
func (s *ModifyDBInstanceInput) SetCopyTagsToSnapshot(v bool) *ModifyDBInstanceInput {
	s.CopyTagsToSnapshot = &v
	return s
}

// SetDBInstanceClass sets the DBInstanceClass field's value.
func (s *ModifyDBInstanceInput) SetDBInstanceClass(v string) *ModifyDBInstanceInput {
	s.DBInstanceClass = &v
	return s
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *ModifyDBInstanceInput) SetDBInstanceIdentifier(v string) *ModifyDBInstanceInput {
	s.DBInstanceIdentifier = &v
	return s
}

// SetDBParameterGroupName sets the DBParameterGroupName field's value.
func (s *ModifyDBInstanceInput) SetDBParameterGroupName(v string) *ModifyDBInstanceInput {
	s.DBParameterGroupName = &v
	return s
}

// SetDBPortNumber sets the DBPortNumber field's value.
func (s *ModifyDBInstanceInput) SetDBPortNumber(v int64) *ModifyDBInstanceInput {
	s.DBPortNumber = &v
	return s
}

// SetDBSecurityGroups sets the DBSecurityGroups field's value.
func (s *ModifyDBInstanceInput) SetDBSecurityGroups(v []*string) *ModifyDBInstanceInput {
	s.DBSecurityGroups = v
	return s
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *ModifyDBInstanceInput) SetDBSubnetGroupName(v string) *ModifyDBInstanceInput {
	s.DBSubnetGroupName = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *ModifyDBInstanceInput) SetDomain(v string) *ModifyDBInstanceInput {
	s.Domain = &v
	return s
}

// SetDomainIAMRoleName sets the DomainIAMRoleName field's value.
func (s *ModifyDBInstanceInput) SetDomainIAMRoleName(v string) *ModifyDBInstanceInput {
	s.DomainIAMRoleName = &v
	return s
}

// SetEnableIAMDatabaseAuthentication sets the EnableIAMDatabaseAuthentication field's value.
func (s *ModifyDBInstanceInput) SetEnableIAMDatabaseAuthentication(v bool) *ModifyDBInstanceInput {
	s.EnableIAMDatabaseAuthentication = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *ModifyDBInstanceInput) SetEngineVersion(v string) *ModifyDBInstanceInput {
	s.EngineVersion = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *ModifyDBInstanceInput) SetIops(v int64) *ModifyDBInstanceInput {
	s.Iops = &v
	return s
}

// SetLicenseModel sets the LicenseModel field's value.
func (s *ModifyDBInstanceInput) SetLicenseModel(v string) *ModifyDBInstanceInput {
	s.LicenseModel = &v
	return s
}

// SetMasterUserPassword sets the MasterUserPassword field's value.
func (s *ModifyDBInstanceInput) SetMasterUserPassword(v string) *ModifyDBInstanceInput {
	s.MasterUserPassword = &v
	return s
}

// SetMonitoringInterval sets the MonitoringInterval field's value.
func (s *ModifyDBInstanceInput) SetMonitoringInterval(v int64) *ModifyDBInstanceInput {
	s.MonitoringInterval = &v
	return s
}

// SetMonitoringRoleArn sets the MonitoringRoleArn field's value.
func (s *ModifyDBInstanceInput) SetMonitoringRoleArn(v string) *ModifyDBInstanceInput {
	s.MonitoringRoleArn = &v
	return s
}

// SetMultiAZ sets the MultiAZ field's value.
func (s *ModifyDBInstanceInput) SetMultiAZ(v bool) *ModifyDBInstanceInput {
	s.MultiAZ = &v
	return s
}

// SetNewDBInstanceIdentifier sets the NewDBInstanceIdentifier field's value.
func (s *ModifyDBInstanceInput) SetNewDBInstanceIdentifier(v string) *ModifyDBInstanceInput {
	s.NewDBInstanceIdentifier = &v
	return s
}

// SetOptionGroupName sets the OptionGroupName field's value.
func (s *ModifyDBInstanceInput) SetOptionGroupName(v string) *ModifyDBInstanceInput {
	s.OptionGroupName = &v
	return s
}

// SetPreferredBackupWindow sets the PreferredBackupWindow field's value.
func (s *ModifyDBInstanceInput) SetPreferredBackupWindow(v string) *ModifyDBInstanceInput {
	s.PreferredBackupWindow = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *ModifyDBInstanceInput) SetPreferredMaintenanceWindow(v string) *ModifyDBInstanceInput {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetPromotionTier sets the PromotionTier field's value.
func (s *ModifyDBInstanceInput) SetPromotionTier(v int64) *ModifyDBInstanceInput {
	s.PromotionTier = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *ModifyDBInstanceInput) SetPubliclyAccessible(v bool) *ModifyDBInstanceInput {
	s.PubliclyAccessible = &v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *ModifyDBInstanceInput) SetStorageType(v string) *ModifyDBInstanceInput {
	s.StorageType = &v
	return s
}

// SetTdeCredentialArn sets the TdeCredentialArn field's value.
func (s *ModifyDBInstanceInput) SetTdeCredentialArn(v string) *ModifyDBInstanceInput {
	s.TdeCredentialArn = &v
	return s
}

// SetTdeCredentialPassword sets the TdeCredentialPassword field's value.
func (s *ModifyDBInstanceInput) SetTdeCredentialPassword(v string) *ModifyDBInstanceInput {
	s.TdeCredentialPassword = &v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *ModifyDBInstanceInput) SetVpcSecurityGroupIds(v []*string) *ModifyDBInstanceInput {
	s.VpcSecurityGroupIds = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBInstanceResult
type ModifyDBInstanceOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//    * CreateDBInstance
	//
	//    * DeleteDBInstance
	//
	//    * ModifyDBInstance
	//
	//    * StopDBInstance
	//
	//    * StartDBInstance
	//
	// This data type is used as a response element in the DescribeDBInstances action.
	DBInstance *DBInstance `type:"structure"`
}

// String returns the string representation
func (s ModifyDBInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBInstanceOutput) GoString() string {
	return s.String()
}

// SetDBInstance sets the DBInstance field's value.
func (s *ModifyDBInstanceOutput) SetDBInstance(v *DBInstance) *ModifyDBInstanceOutput {
	s.DBInstance = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBParameterGroupMessage
type ModifyDBParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB parameter group.
	//
	// Constraints:
	//
	//    * Must be the name of an existing DB parameter group
	//
	//    * Must be 1 to 255 alphanumeric characters
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	// DBParameterGroupName is a required field
	DBParameterGroupName *string `type:"string" required:"true"`

	// An array of parameter names, values, and the apply method for the parameter
	// update. At least one parameter name, value, and apply method must be supplied;
	// subsequent arguments are optional. A maximum of 20 parameters can be modified
	// in a single request.
	//
	// Valid Values (for the application method): immediate | pending-reboot
	//
	// You can use the immediate value with dynamic parameters only. You can use
	// the pending-reboot value for both dynamic and static parameters, and changes
	// are applied when you reboot the DB instance without failover.
	//
	// Parameters is a required field
	Parameters []*Parameter `locationNameList:"Parameter" type:"list" required:"true"`
}

// String returns the string representation
func (s ModifyDBParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyDBParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyDBParameterGroupInput"}
	if s.DBParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBParameterGroupName"))
	}
	if s.Parameters == nil {
		invalidParams.Add(request.NewErrParamRequired("Parameters"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBParameterGroupName sets the DBParameterGroupName field's value.
func (s *ModifyDBParameterGroupInput) SetDBParameterGroupName(v string) *ModifyDBParameterGroupInput {
	s.DBParameterGroupName = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *ModifyDBParameterGroupInput) SetParameters(v []*Parameter) *ModifyDBParameterGroupInput {
	s.Parameters = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBSnapshotAttributeMessage
type ModifyDBSnapshotAttributeInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB snapshot attribute to modify.
	//
	// To manage authorization for other AWS accounts to copy or restore a manual
	// DB snapshot, set this value to restore.
	//
	// AttributeName is a required field
	AttributeName *string `type:"string" required:"true"`

	// The identifier for the DB snapshot to modify the attributes for.
	//
	// DBSnapshotIdentifier is a required field
	DBSnapshotIdentifier *string `type:"string" required:"true"`

	// A list of DB snapshot attributes to add to the attribute specified by AttributeName.
	//
	// To authorize other AWS accounts to copy or restore a manual snapshot, set
	// this list to include one or more AWS account IDs, or all to make the manual
	// DB snapshot restorable by any AWS account. Do not add the all value for any
	// manual DB snapshots that contain private information that you don't want
	// available to all AWS accounts.
	ValuesToAdd []*string `locationNameList:"AttributeValue" type:"list"`

	// A list of DB snapshot attributes to remove from the attribute specified by
	// AttributeName.
	//
	// To remove authorization for other AWS accounts to copy or restore a manual
	// snapshot, set this list to include one or more AWS account identifiers, or
	// all to remove authorization for any AWS account to copy or restore the DB
	// snapshot. If you specify all, an AWS account whose account ID is explicitly
	// added to the restore attribute can still copy or restore the manual DB snapshot.
	ValuesToRemove []*string `locationNameList:"AttributeValue" type:"list"`
}

// String returns the string representation
func (s ModifyDBSnapshotAttributeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBSnapshotAttributeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyDBSnapshotAttributeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyDBSnapshotAttributeInput"}
	if s.AttributeName == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeName"))
	}
	if s.DBSnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBSnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeName sets the AttributeName field's value.
func (s *ModifyDBSnapshotAttributeInput) SetAttributeName(v string) *ModifyDBSnapshotAttributeInput {
	s.AttributeName = &v
	return s
}

// SetDBSnapshotIdentifier sets the DBSnapshotIdentifier field's value.
func (s *ModifyDBSnapshotAttributeInput) SetDBSnapshotIdentifier(v string) *ModifyDBSnapshotAttributeInput {
	s.DBSnapshotIdentifier = &v
	return s
}

// SetValuesToAdd sets the ValuesToAdd field's value.
func (s *ModifyDBSnapshotAttributeInput) SetValuesToAdd(v []*string) *ModifyDBSnapshotAttributeInput {
	s.ValuesToAdd = v
	return s
}

// SetValuesToRemove sets the ValuesToRemove field's value.
func (s *ModifyDBSnapshotAttributeInput) SetValuesToRemove(v []*string) *ModifyDBSnapshotAttributeInput {
	s.ValuesToRemove = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBSnapshotAttributeResult
type ModifyDBSnapshotAttributeOutput struct {
	_ struct{} `type:"structure"`

	// Contains the results of a successful call to the DescribeDBSnapshotAttributes
	// API action.
	//
	// Manual DB snapshot attributes are used to authorize other AWS accounts to
	// copy or restore a manual DB snapshot. For more information, see the ModifyDBSnapshotAttribute
	// API action.
	DBSnapshotAttributesResult *DBSnapshotAttributesResult `type:"structure"`
}

// String returns the string representation
func (s ModifyDBSnapshotAttributeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBSnapshotAttributeOutput) GoString() string {
	return s.String()
}

// SetDBSnapshotAttributesResult sets the DBSnapshotAttributesResult field's value.
func (s *ModifyDBSnapshotAttributeOutput) SetDBSnapshotAttributesResult(v *DBSnapshotAttributesResult) *ModifyDBSnapshotAttributeOutput {
	s.DBSnapshotAttributesResult = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBSnapshotMessage
type ModifyDBSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the DB snapshot to modify.
	//
	// DBSnapshotIdentifier is a required field
	DBSnapshotIdentifier *string `type:"string" required:"true"`

	// The engine version to update the DB snapshot to.
	EngineVersion *string `type:"string"`
}

// String returns the string representation
func (s ModifyDBSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyDBSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyDBSnapshotInput"}
	if s.DBSnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBSnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBSnapshotIdentifier sets the DBSnapshotIdentifier field's value.
func (s *ModifyDBSnapshotInput) SetDBSnapshotIdentifier(v string) *ModifyDBSnapshotInput {
	s.DBSnapshotIdentifier = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *ModifyDBSnapshotInput) SetEngineVersion(v string) *ModifyDBSnapshotInput {
	s.EngineVersion = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBSnapshotResult
type ModifyDBSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//    * CreateDBSnapshot
	//
	//    * DeleteDBSnapshot
	//
	// This data type is used as a response element in the DescribeDBSnapshots action.
	DBSnapshot *DBSnapshot `type:"structure"`
}

// String returns the string representation
func (s ModifyDBSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBSnapshotOutput) GoString() string {
	return s.String()
}

// SetDBSnapshot sets the DBSnapshot field's value.
func (s *ModifyDBSnapshotOutput) SetDBSnapshot(v *DBSnapshot) *ModifyDBSnapshotOutput {
	s.DBSnapshot = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBSubnetGroupMessage
type ModifyDBSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The description for the DB subnet group.
	DBSubnetGroupDescription *string `type:"string"`

	// The name for the DB subnet group. This value is stored as a lowercase string.
	//
	// Constraints: Must contain no more than 255 alphanumeric characters, periods,
	// underscores, spaces, or hyphens. Must not be default.
	//
	// Example: mySubnetgroup
	//
	// DBSubnetGroupName is a required field
	DBSubnetGroupName *string `type:"string" required:"true"`

	// The EC2 subnet IDs for the DB subnet group.
	//
	// SubnetIds is a required field
	SubnetIds []*string `locationNameList:"SubnetIdentifier" type:"list" required:"true"`
}

// String returns the string representation
func (s ModifyDBSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBSubnetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyDBSubnetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyDBSubnetGroupInput"}
	if s.DBSubnetGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBSubnetGroupName"))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBSubnetGroupDescription sets the DBSubnetGroupDescription field's value.
func (s *ModifyDBSubnetGroupInput) SetDBSubnetGroupDescription(v string) *ModifyDBSubnetGroupInput {
	s.DBSubnetGroupDescription = &v
	return s
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *ModifyDBSubnetGroupInput) SetDBSubnetGroupName(v string) *ModifyDBSubnetGroupInput {
	s.DBSubnetGroupName = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *ModifyDBSubnetGroupInput) SetSubnetIds(v []*string) *ModifyDBSubnetGroupInput {
	s.SubnetIds = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBSubnetGroupResult
type ModifyDBSubnetGroupOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//    * CreateDBSubnetGroup
	//
	//    * ModifyDBSubnetGroup
	//
	//    * DescribeDBSubnetGroups
	//
	//    * DeleteDBSubnetGroup
	//
	// This data type is used as a response element in the DescribeDBSubnetGroups
	// action.
	DBSubnetGroup *DBSubnetGroup `type:"structure"`
}

// String returns the string representation
func (s ModifyDBSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDBSubnetGroupOutput) GoString() string {
	return s.String()
}

// SetDBSubnetGroup sets the DBSubnetGroup field's value.
func (s *ModifyDBSubnetGroupOutput) SetDBSubnetGroup(v *DBSubnetGroup) *ModifyDBSubnetGroupOutput {
	s.DBSubnetGroup = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyEventSubscriptionMessage
type ModifyEventSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// A Boolean value; set to true to activate the subscription.
	Enabled *bool `type:"boolean"`

	// A list of event categories for a SourceType that you want to subscribe to.
	// You can see a list of the categories for a given SourceType in the Events
	// (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html)
	// topic in the Amazon RDS User Guide or by using the DescribeEventCategories
	// action.
	EventCategories []*string `locationNameList:"EventCategory" type:"list"`

	// The Amazon Resource Name (ARN) of the SNS topic created for event notification.
	// The ARN is created by Amazon SNS when you create a topic and subscribe to
	// it.
	SnsTopicArn *string `type:"string"`

	// The type of source that will be generating the events. For example, if you
	// want to be notified of events generated by a DB instance, you would set this
	// parameter to db-instance. if this value is not specified, all events are
	// returned.
	//
	// Valid values: db-instance | db-parameter-group | db-security-group | db-snapshot
	SourceType *string `type:"string"`

	// The name of the RDS event notification subscription.
	//
	// SubscriptionName is a required field
	SubscriptionName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModifyEventSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyEventSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyEventSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyEventSubscriptionInput"}
	if s.SubscriptionName == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *ModifyEventSubscriptionInput) SetEnabled(v bool) *ModifyEventSubscriptionInput {
	s.Enabled = &v
	return s
}

// SetEventCategories sets the EventCategories field's value.
func (s *ModifyEventSubscriptionInput) SetEventCategories(v []*string) *ModifyEventSubscriptionInput {
	s.EventCategories = v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *ModifyEventSubscriptionInput) SetSnsTopicArn(v string) *ModifyEventSubscriptionInput {
	s.SnsTopicArn = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *ModifyEventSubscriptionInput) SetSourceType(v string) *ModifyEventSubscriptionInput {
	s.SourceType = &v
	return s
}

// SetSubscriptionName sets the SubscriptionName field's value.
func (s *ModifyEventSubscriptionInput) SetSubscriptionName(v string) *ModifyEventSubscriptionInput {
	s.SubscriptionName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyEventSubscriptionResult
type ModifyEventSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// Contains the results of a successful invocation of the DescribeEventSubscriptions
	// action.
	EventSubscription *EventSubscription `type:"structure"`
}

// String returns the string representation
func (s ModifyEventSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyEventSubscriptionOutput) GoString() string {
	return s.String()
}

// SetEventSubscription sets the EventSubscription field's value.
func (s *ModifyEventSubscriptionOutput) SetEventSubscription(v *EventSubscription) *ModifyEventSubscriptionOutput {
	s.EventSubscription = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyOptionGroupMessage
type ModifyOptionGroupInput struct {
	_ struct{} `type:"structure"`

	// Indicates whether the changes should be applied immediately, or during the
	// next maintenance window for each instance associated with the option group.
	ApplyImmediately *bool `type:"boolean"`

	// The name of the option group to be modified.
	//
	// Permanent options, such as the TDE option for Oracle Advanced Security TDE,
	// cannot be removed from an option group, and that option group cannot be removed
	// from a DB instance once it is associated with a DB instance
	//
	// OptionGroupName is a required field
	OptionGroupName *string `type:"string" required:"true"`

	// Options in this list are added to the option group or, if already present,
	// the specified configuration is used to update the existing configuration.
	OptionsToInclude []*OptionConfiguration `locationNameList:"OptionConfiguration" type:"list"`

	// Options in this list are removed from the option group.
	OptionsToRemove []*string `type:"list"`
}

// String returns the string representation
func (s ModifyOptionGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyOptionGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyOptionGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyOptionGroupInput"}
	if s.OptionGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("OptionGroupName"))
	}
	if s.OptionsToInclude != nil {
		for i, v := range s.OptionsToInclude {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OptionsToInclude", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplyImmediately sets the ApplyImmediately field's value.
func (s *ModifyOptionGroupInput) SetApplyImmediately(v bool) *ModifyOptionGroupInput {
	s.ApplyImmediately = &v
	return s
}

// SetOptionGroupName sets the OptionGroupName field's value.
func (s *ModifyOptionGroupInput) SetOptionGroupName(v string) *ModifyOptionGroupInput {
	s.OptionGroupName = &v
	return s
}

// SetOptionsToInclude sets the OptionsToInclude field's value.
func (s *ModifyOptionGroupInput) SetOptionsToInclude(v []*OptionConfiguration) *ModifyOptionGroupInput {
	s.OptionsToInclude = v
	return s
}

// SetOptionsToRemove sets the OptionsToRemove field's value.
func (s *ModifyOptionGroupInput) SetOptionsToRemove(v []*string) *ModifyOptionGroupInput {
	s.OptionsToRemove = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyOptionGroupResult
type ModifyOptionGroupOutput struct {
	_ struct{} `type:"structure"`

	OptionGroup *OptionGroup `type:"structure"`
}

// String returns the string representation
func (s ModifyOptionGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyOptionGroupOutput) GoString() string {
	return s.String()
}

// SetOptionGroup sets the OptionGroup field's value.
func (s *ModifyOptionGroupOutput) SetOptionGroup(v *OptionGroup) *ModifyOptionGroupOutput {
	s.OptionGroup = v
	return s
}

// Option details.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/Option
type Option struct {
	_ struct{} `type:"structure"`

	// If the option requires access to a port, then this DB security group allows
	// access to the port.
	DBSecurityGroupMemberships []*DBSecurityGroupMembership `locationNameList:"DBSecurityGroup" type:"list"`

	// The description of the option.
	OptionDescription *string `type:"string"`

	// The name of the option.
	OptionName *string `type:"string"`

	// The option settings for this option.
	OptionSettings []*OptionSetting `locationNameList:"OptionSetting" type:"list"`

	// The version of the option.
	OptionVersion *string `type:"string"`

	// Indicate if this option is permanent.
	Permanent *bool `type:"boolean"`

	// Indicate if this option is persistent.
	Persistent *bool `type:"boolean"`

	// If required, the port configured for this option to use.
	Port *int64 `type:"integer"`

	// If the option requires access to a port, then this VPC security group allows
	// access to the port.
	VpcSecurityGroupMemberships []*VpcSecurityGroupMembership `locationNameList:"VpcSecurityGroupMembership" type:"list"`
}

// String returns the string representation
func (s Option) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Option) GoString() string {
	return s.String()
}

// SetDBSecurityGroupMemberships sets the DBSecurityGroupMemberships field's value.
func (s *Option) SetDBSecurityGroupMemberships(v []*DBSecurityGroupMembership) *Option {
	s.DBSecurityGroupMemberships = v
	return s
}

// SetOptionDescription sets the OptionDescription field's value.
func (s *Option) SetOptionDescription(v string) *Option {
	s.OptionDescription = &v
	return s
}

// SetOptionName sets the OptionName field's value.
func (s *Option) SetOptionName(v string) *Option {
	s.OptionName = &v
	return s
}

// SetOptionSettings sets the OptionSettings field's value.
func (s *Option) SetOptionSettings(v []*OptionSetting) *Option {
	s.OptionSettings = v
	return s
}

// SetOptionVersion sets the OptionVersion field's value.
func (s *Option) SetOptionVersion(v string) *Option {
	s.OptionVersion = &v
	return s
}

// SetPermanent sets the Permanent field's value.
func (s *Option) SetPermanent(v bool) *Option {
	s.Permanent = &v
	return s
}

// SetPersistent sets the Persistent field's value.
func (s *Option) SetPersistent(v bool) *Option {
	s.Persistent = &v
	return s
}

// SetPort sets the Port field's value.
func (s *Option) SetPort(v int64) *Option {
	s.Port = &v
	return s
}

// SetVpcSecurityGroupMemberships sets the VpcSecurityGroupMemberships field's value.
func (s *Option) SetVpcSecurityGroupMemberships(v []*VpcSecurityGroupMembership) *Option {
	s.VpcSecurityGroupMemberships = v
	return s
}

// A list of all available options
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/OptionConfiguration
type OptionConfiguration struct {
	_ struct{} `type:"structure"`

	// A list of DBSecurityGroupMemebrship name strings used for this option.
	DBSecurityGroupMemberships []*string `locationNameList:"DBSecurityGroupName" type:"list"`

	// The configuration of options to include in a group.
	//
	// OptionName is a required field
	OptionName *string `type:"string" required:"true"`

	// The option settings to include in an option group.
	OptionSettings []*OptionSetting `locationNameList:"OptionSetting" type:"list"`

	// The version for the option.
	OptionVersion *string `type:"string"`

	// The optional port for the option.
	Port *int64 `type:"integer"`

	// A list of VpcSecurityGroupMemebrship name strings used for this option.
	VpcSecurityGroupMemberships []*string `locationNameList:"VpcSecurityGroupId" type:"list"`
}

// String returns the string representation
func (s OptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OptionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OptionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OptionConfiguration"}
	if s.OptionName == nil {
		invalidParams.Add(request.NewErrParamRequired("OptionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBSecurityGroupMemberships sets the DBSecurityGroupMemberships field's value.
func (s *OptionConfiguration) SetDBSecurityGroupMemberships(v []*string) *OptionConfiguration {
	s.DBSecurityGroupMemberships = v
	return s
}

// SetOptionName sets the OptionName field's value.
func (s *OptionConfiguration) SetOptionName(v string) *OptionConfiguration {
	s.OptionName = &v
	return s
}

// SetOptionSettings sets the OptionSettings field's value.
func (s *OptionConfiguration) SetOptionSettings(v []*OptionSetting) *OptionConfiguration {
	s.OptionSettings = v
	return s
}

// SetOptionVersion sets the OptionVersion field's value.
func (s *OptionConfiguration) SetOptionVersion(v string) *OptionConfiguration {
	s.OptionVersion = &v
	return s
}

// SetPort sets the Port field's value.
func (s *OptionConfiguration) SetPort(v int64) *OptionConfiguration {
	s.Port = &v
	return s
}

// SetVpcSecurityGroupMemberships sets the VpcSecurityGroupMemberships field's value.
func (s *OptionConfiguration) SetVpcSecurityGroupMemberships(v []*string) *OptionConfiguration {
	s.VpcSecurityGroupMemberships = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/OptionGroup
type OptionGroup struct {
	_ struct{} `type:"structure"`

	// Indicates whether this option group can be applied to both VPC and non-VPC
	// instances. The value true indicates the option group can be applied to both
	// VPC and non-VPC instances.
	AllowsVpcAndNonVpcInstanceMemberships *bool `type:"boolean"`

	// Indicates the name of the engine that this option group can be applied to.
	EngineName *string `type:"string"`

	// Indicates the major engine version associated with this option group.
	MajorEngineVersion *string `type:"string"`

	// The Amazon Resource Name (ARN) for the option group.
	OptionGroupArn *string `type:"string"`

	// Provides a description of the option group.
	OptionGroupDescription *string `type:"string"`

	// Specifies the name of the option group.
	OptionGroupName *string `type:"string"`

	// Indicates what options are available in the option group.
	Options []*Option `locationNameList:"Option" type:"list"`

	// If AllowsVpcAndNonVpcInstanceMemberships is false, this field is blank. If
	// AllowsVpcAndNonVpcInstanceMemberships is true and this field is blank, then
	// this option group can be applied to both VPC and non-VPC instances. If this
	// field contains a value, then this option group can only be applied to instances
	// that are in the VPC indicated by this field.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s OptionGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OptionGroup) GoString() string {
	return s.String()
}

// SetAllowsVpcAndNonVpcInstanceMemberships sets the AllowsVpcAndNonVpcInstanceMemberships field's value.
func (s *OptionGroup) SetAllowsVpcAndNonVpcInstanceMemberships(v bool) *OptionGroup {
	s.AllowsVpcAndNonVpcInstanceMemberships = &v
	return s
}

// SetEngineName sets the EngineName field's value.
func (s *OptionGroup) SetEngineName(v string) *OptionGroup {
	s.EngineName = &v
	return s
}

// SetMajorEngineVersion sets the MajorEngineVersion field's value.
func (s *OptionGroup) SetMajorEngineVersion(v string) *OptionGroup {
	s.MajorEngineVersion = &v
	return s
}

// SetOptionGroupArn sets the OptionGroupArn field's value.
func (s *OptionGroup) SetOptionGroupArn(v string) *OptionGroup {
	s.OptionGroupArn = &v
	return s
}

// SetOptionGroupDescription sets the OptionGroupDescription field's value.
func (s *OptionGroup) SetOptionGroupDescription(v string) *OptionGroup {
	s.OptionGroupDescription = &v
	return s
}

// SetOptionGroupName sets the OptionGroupName field's value.
func (s *OptionGroup) SetOptionGroupName(v string) *OptionGroup {
	s.OptionGroupName = &v
	return s
}

// SetOptions sets the Options field's value.
func (s *OptionGroup) SetOptions(v []*Option) *OptionGroup {
	s.Options = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *OptionGroup) SetVpcId(v string) *OptionGroup {
	s.VpcId = &v
	return s
}

// Provides information on the option groups the DB instance is a member of.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/OptionGroupMembership
type OptionGroupMembership struct {
	_ struct{} `type:"structure"`

	// The name of the option group that the instance belongs to.
	OptionGroupName *string `type:"string"`

	// The status of the DB instance's option group membership. Valid values are:
	// in-sync, pending-apply, pending-removal, pending-maintenance-apply, pending-maintenance-removal,
	// applying, removing, and failed.
	Status *string `type:"string"`
}

// String returns the string representation
func (s OptionGroupMembership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OptionGroupMembership) GoString() string {
	return s.String()
}

// SetOptionGroupName sets the OptionGroupName field's value.
func (s *OptionGroupMembership) SetOptionGroupName(v string) *OptionGroupMembership {
	s.OptionGroupName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *OptionGroupMembership) SetStatus(v string) *OptionGroupMembership {
	s.Status = &v
	return s
}

// Available option.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/OptionGroupOption
type OptionGroupOption struct {
	_ struct{} `type:"structure"`

	// If the option requires a port, specifies the default port for the option.
	DefaultPort *int64 `type:"integer"`

	// The description of the option.
	Description *string `type:"string"`

	// The name of the engine that this option can be applied to.
	EngineName *string `type:"string"`

	// Indicates the major engine version that the option is available for.
	MajorEngineVersion *string `type:"string"`

	// The minimum required engine version for the option to be applied.
	MinimumRequiredMinorEngineVersion *string `type:"string"`

	// The name of the option.
	Name *string `type:"string"`

	// The option settings that are available (and the default value) for each option
	// in an option group.
	OptionGroupOptionSettings []*OptionGroupOptionSetting `locationNameList:"OptionGroupOptionSetting" type:"list"`

	// The versions that are available for the option.
	OptionGroupOptionVersions []*OptionVersion `locationNameList:"OptionVersion" type:"list"`

	// The options that conflict with this option.
	OptionsConflictsWith []*string `locationNameList:"OptionConflictName" type:"list"`

	// The options that are prerequisites for this option.
	OptionsDependedOn []*string `locationNameList:"OptionName" type:"list"`

	// Permanent options can never be removed from an option group. An option group
	// containing a permanent option can't be removed from a DB instance.
	Permanent *bool `type:"boolean"`

	// Persistent options can't be removed from an option group while DB instances
	// are associated with the option group. If you disassociate all DB instances
	// from the option group, your can remove the persistent option from the option
	// group.
	Persistent *bool `type:"boolean"`

	// Specifies whether the option requires a port.
	PortRequired *bool `type:"boolean"`

	// If true, you must enable the Auto Minor Version Upgrade setting for your
	// DB instance before you can use this option. You can enable Auto Minor Version
	// Upgrade when you first create your DB instance, or by modifying your DB instance
	// later.
	RequiresAutoMinorEngineVersionUpgrade *bool `type:"boolean"`

	// If true, you can change the option to an earlier version of the option. This
	// only applies to options that have different versions available.
	SupportsOptionVersionDowngrade *bool `type:"boolean"`

	// If true, you can only use this option with a DB instance that is in a VPC.
	VpcOnly *bool `type:"boolean"`
}

// String returns the string representation
func (s OptionGroupOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OptionGroupOption) GoString() string {
	return s.String()
}

// SetDefaultPort sets the DefaultPort field's value.
func (s *OptionGroupOption) SetDefaultPort(v int64) *OptionGroupOption {
	s.DefaultPort = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *OptionGroupOption) SetDescription(v string) *OptionGroupOption {
	s.Description = &v
	return s
}

// SetEngineName sets the EngineName field's value.
func (s *OptionGroupOption) SetEngineName(v string) *OptionGroupOption {
	s.EngineName = &v
	return s
}

// SetMajorEngineVersion sets the MajorEngineVersion field's value.
func (s *OptionGroupOption) SetMajorEngineVersion(v string) *OptionGroupOption {
	s.MajorEngineVersion = &v
	return s
}

// SetMinimumRequiredMinorEngineVersion sets the MinimumRequiredMinorEngineVersion field's value.
func (s *OptionGroupOption) SetMinimumRequiredMinorEngineVersion(v string) *OptionGroupOption {
	s.MinimumRequiredMinorEngineVersion = &v
	return s
}

// SetName sets the Name field's value.
func (s *OptionGroupOption) SetName(v string) *OptionGroupOption {
	s.Name = &v
	return s
}

// SetOptionGroupOptionSettings sets the OptionGroupOptionSettings field's value.
func (s *OptionGroupOption) SetOptionGroupOptionSettings(v []*OptionGroupOptionSetting) *OptionGroupOption {
	s.OptionGroupOptionSettings = v
	return s
}

// SetOptionGroupOptionVersions sets the OptionGroupOptionVersions field's value.
func (s *OptionGroupOption) SetOptionGroupOptionVersions(v []*OptionVersion) *OptionGroupOption {
	s.OptionGroupOptionVersions = v
	return s
}

// SetOptionsConflictsWith sets the OptionsConflictsWith field's value.
func (s *OptionGroupOption) SetOptionsConflictsWith(v []*string) *OptionGroupOption {
	s.OptionsConflictsWith = v
	return s
}

// SetOptionsDependedOn sets the OptionsDependedOn field's value.
func (s *OptionGroupOption) SetOptionsDependedOn(v []*string) *OptionGroupOption {
	s.OptionsDependedOn = v
	return s
}

// SetPermanent sets the Permanent field's value.
func (s *OptionGroupOption) SetPermanent(v bool) *OptionGroupOption {
	s.Permanent = &v
	return s
}

// SetPersistent sets the Persistent field's value.
func (s *OptionGroupOption) SetPersistent(v bool) *OptionGroupOption {
	s.Persistent = &v
	return s
}

// SetPortRequired sets the PortRequired field's value.
func (s *OptionGroupOption) SetPortRequired(v bool) *OptionGroupOption {
	s.PortRequired = &v
	return s
}

// SetRequiresAutoMinorEngineVersionUpgrade sets the RequiresAutoMinorEngineVersionUpgrade field's value.
func (s *OptionGroupOption) SetRequiresAutoMinorEngineVersionUpgrade(v bool) *OptionGroupOption {
	s.RequiresAutoMinorEngineVersionUpgrade = &v
	return s
}

// SetSupportsOptionVersionDowngrade sets the SupportsOptionVersionDowngrade field's value.
func (s *OptionGroupOption) SetSupportsOptionVersionDowngrade(v bool) *OptionGroupOption {
	s.SupportsOptionVersionDowngrade = &v
	return s
}

// SetVpcOnly sets the VpcOnly field's value.
func (s *OptionGroupOption) SetVpcOnly(v bool) *OptionGroupOption {
	s.VpcOnly = &v
	return s
}

// Option group option settings are used to display settings available for each
// option with their default values and other information. These values are
// used with the DescribeOptionGroupOptions action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/OptionGroupOptionSetting
type OptionGroupOptionSetting struct {
	_ struct{} `type:"structure"`

	// Indicates the acceptable values for the option group option.
	AllowedValues *string `type:"string"`

	// The DB engine specific parameter type for the option group option.
	ApplyType *string `type:"string"`

	// The default value for the option group option.
	DefaultValue *string `type:"string"`

	// Boolean value where true indicates that this option group option can be changed
	// from the default value.
	IsModifiable *bool `type:"boolean"`

	// The description of the option group option.
	SettingDescription *string `type:"string"`

	// The name of the option group option.
	SettingName *string `type:"string"`
}

// String returns the string representation
func (s OptionGroupOptionSetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OptionGroupOptionSetting) GoString() string {
	return s.String()
}

// SetAllowedValues sets the AllowedValues field's value.
func (s *OptionGroupOptionSetting) SetAllowedValues(v string) *OptionGroupOptionSetting {
	s.AllowedValues = &v
	return s
}

// SetApplyType sets the ApplyType field's value.
func (s *OptionGroupOptionSetting) SetApplyType(v string) *OptionGroupOptionSetting {
	s.ApplyType = &v
	return s
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *OptionGroupOptionSetting) SetDefaultValue(v string) *OptionGroupOptionSetting {
	s.DefaultValue = &v
	return s
}

// SetIsModifiable sets the IsModifiable field's value.
func (s *OptionGroupOptionSetting) SetIsModifiable(v bool) *OptionGroupOptionSetting {
	s.IsModifiable = &v
	return s
}

// SetSettingDescription sets the SettingDescription field's value.
func (s *OptionGroupOptionSetting) SetSettingDescription(v string) *OptionGroupOptionSetting {
	s.SettingDescription = &v
	return s
}

// SetSettingName sets the SettingName field's value.
func (s *OptionGroupOptionSetting) SetSettingName(v string) *OptionGroupOptionSetting {
	s.SettingName = &v
	return s
}

// Option settings are the actual settings being applied or configured for that
// option. It is used when you modify an option group or describe option groups.
// For example, the NATIVE_NETWORK_ENCRYPTION option has a setting called SQLNET.ENCRYPTION_SERVER
// that can have several different values.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/OptionSetting
type OptionSetting struct {
	_ struct{} `type:"structure"`

	// The allowed values of the option setting.
	AllowedValues *string `type:"string"`

	// The DB engine specific parameter type.
	ApplyType *string `type:"string"`

	// The data type of the option setting.
	DataType *string `type:"string"`

	// The default value of the option setting.
	DefaultValue *string `type:"string"`

	// The description of the option setting.
	Description *string `type:"string"`

	// Indicates if the option setting is part of a collection.
	IsCollection *bool `type:"boolean"`

	// A Boolean value that, when true, indicates the option setting can be modified
	// from the default.
	IsModifiable *bool `type:"boolean"`

	// The name of the option that has settings that you can set.
	Name *string `type:"string"`

	// The current value of the option setting.
	Value *string `type:"string"`
}

// String returns the string representation
func (s OptionSetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OptionSetting) GoString() string {
	return s.String()
}

// SetAllowedValues sets the AllowedValues field's value.
func (s *OptionSetting) SetAllowedValues(v string) *OptionSetting {
	s.AllowedValues = &v
	return s
}

// SetApplyType sets the ApplyType field's value.
func (s *OptionSetting) SetApplyType(v string) *OptionSetting {
	s.ApplyType = &v
	return s
}

// SetDataType sets the DataType field's value.
func (s *OptionSetting) SetDataType(v string) *OptionSetting {
	s.DataType = &v
	return s
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *OptionSetting) SetDefaultValue(v string) *OptionSetting {
	s.DefaultValue = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *OptionSetting) SetDescription(v string) *OptionSetting {
	s.Description = &v
	return s
}

// SetIsCollection sets the IsCollection field's value.
func (s *OptionSetting) SetIsCollection(v bool) *OptionSetting {
	s.IsCollection = &v
	return s
}

// SetIsModifiable sets the IsModifiable field's value.
func (s *OptionSetting) SetIsModifiable(v bool) *OptionSetting {
	s.IsModifiable = &v
	return s
}

// SetName sets the Name field's value.
func (s *OptionSetting) SetName(v string) *OptionSetting {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *OptionSetting) SetValue(v string) *OptionSetting {
	s.Value = &v
	return s
}

// The version for an option. Option group option versions are returned by the
// DescribeOptionGroupOptions action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/OptionVersion
type OptionVersion struct {
	_ struct{} `type:"structure"`

	// True if the version is the default version of the option; otherwise, false.
	IsDefault *bool `type:"boolean"`

	// The version of the option.
	Version *string `type:"string"`
}

// String returns the string representation
func (s OptionVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OptionVersion) GoString() string {
	return s.String()
}

// SetIsDefault sets the IsDefault field's value.
func (s *OptionVersion) SetIsDefault(v bool) *OptionVersion {
	s.IsDefault = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *OptionVersion) SetVersion(v string) *OptionVersion {
	s.Version = &v
	return s
}

// Contains a list of available options for a DB instance
//
// This data type is used as a response element in the DescribeOrderableDBInstanceOptions
// action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/OrderableDBInstanceOption
type OrderableDBInstanceOption struct {
	_ struct{} `type:"structure"`

	// A list of Availability Zones for the orderable DB instance.
	AvailabilityZones []*AvailabilityZone `locationNameList:"AvailabilityZone" type:"list"`

	// The DB instance class for the orderable DB instance.
	DBInstanceClass *string `type:"string"`

	// The engine type of the orderable DB instance.
	Engine *string `type:"string"`

	// The engine version of the orderable DB instance.
	EngineVersion *string `type:"string"`

	// The license model for the orderable DB instance.
	LicenseModel *string `type:"string"`

	// Indicates whether this orderable DB instance is multi-AZ capable.
	MultiAZCapable *bool `type:"boolean"`

	// Indicates whether this orderable DB instance can have a Read Replica.
	ReadReplicaCapable *bool `type:"boolean"`

	// Indicates the storage type for this orderable DB instance.
	StorageType *string `type:"string"`

	// Indicates whether the DB instance supports enhanced monitoring at intervals
	// from 1 to 60 seconds.
	SupportsEnhancedMonitoring *bool `type:"boolean"`

	// Indicates whether this orderable DB instance supports IAM database authentication.
	SupportsIAMDatabaseAuthentication *bool `type:"boolean"`

	// Indicates whether this orderable DB instance supports provisioned IOPS.
	SupportsIops *bool `type:"boolean"`

	// Indicates whether this orderable DB instance supports encrypted storage.
	SupportsStorageEncryption *bool `type:"boolean"`

	// Indicates whether this is a VPC orderable DB instance.
	Vpc *bool `type:"boolean"`
}

// String returns the string representation
func (s OrderableDBInstanceOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrderableDBInstanceOption) GoString() string {
	return s.String()
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *OrderableDBInstanceOption) SetAvailabilityZones(v []*AvailabilityZone) *OrderableDBInstanceOption {
	s.AvailabilityZones = v
	return s
}

// SetDBInstanceClass sets the DBInstanceClass field's value.
func (s *OrderableDBInstanceOption) SetDBInstanceClass(v string) *OrderableDBInstanceOption {
	s.DBInstanceClass = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *OrderableDBInstanceOption) SetEngine(v string) *OrderableDBInstanceOption {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *OrderableDBInstanceOption) SetEngineVersion(v string) *OrderableDBInstanceOption {
	s.EngineVersion = &v
	return s
}

// SetLicenseModel sets the LicenseModel field's value.
func (s *OrderableDBInstanceOption) SetLicenseModel(v string) *OrderableDBInstanceOption {
	s.LicenseModel = &v
	return s
}

// SetMultiAZCapable sets the MultiAZCapable field's value.
func (s *OrderableDBInstanceOption) SetMultiAZCapable(v bool) *OrderableDBInstanceOption {
	s.MultiAZCapable = &v
	return s
}

// SetReadReplicaCapable sets the ReadReplicaCapable field's value.
func (s *OrderableDBInstanceOption) SetReadReplicaCapable(v bool) *OrderableDBInstanceOption {
	s.ReadReplicaCapable = &v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *OrderableDBInstanceOption) SetStorageType(v string) *OrderableDBInstanceOption {
	s.StorageType = &v
	return s
}

// SetSupportsEnhancedMonitoring sets the SupportsEnhancedMonitoring field's value.
func (s *OrderableDBInstanceOption) SetSupportsEnhancedMonitoring(v bool) *OrderableDBInstanceOption {
	s.SupportsEnhancedMonitoring = &v
	return s
}

// SetSupportsIAMDatabaseAuthentication sets the SupportsIAMDatabaseAuthentication field's value.
func (s *OrderableDBInstanceOption) SetSupportsIAMDatabaseAuthentication(v bool) *OrderableDBInstanceOption {
	s.SupportsIAMDatabaseAuthentication = &v
	return s
}

// SetSupportsIops sets the SupportsIops field's value.
func (s *OrderableDBInstanceOption) SetSupportsIops(v bool) *OrderableDBInstanceOption {
	s.SupportsIops = &v
	return s
}

// SetSupportsStorageEncryption sets the SupportsStorageEncryption field's value.
func (s *OrderableDBInstanceOption) SetSupportsStorageEncryption(v bool) *OrderableDBInstanceOption {
	s.SupportsStorageEncryption = &v
	return s
}

// SetVpc sets the Vpc field's value.
func (s *OrderableDBInstanceOption) SetVpc(v bool) *OrderableDBInstanceOption {
	s.Vpc = &v
	return s
}

// This data type is used as a request parameter in the ModifyDBParameterGroup
// and ResetDBParameterGroup actions.
//
// This data type is used as a response element in the DescribeEngineDefaultParameters
// and DescribeDBParameters actions.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/Parameter
type Parameter struct {
	_ struct{} `type:"structure"`

	// Specifies the valid range of values for the parameter.
	AllowedValues *string `type:"string"`

	// Indicates when to apply parameter updates.
	ApplyMethod *string `type:"string" enum:"ApplyMethod"`

	// Specifies the engine specific parameters type.
	ApplyType *string `type:"string"`

	// Specifies the valid data type for the parameter.
	DataType *string `type:"string"`

	// Provides a description of the parameter.
	Description *string `type:"string"`

	// Indicates whether (true) or not (false) the parameter can be modified. Some
	// parameters have security or operational implications that prevent them from
	// being changed.
	IsModifiable *bool `type:"boolean"`

	// The earliest engine version to which the parameter can apply.
	MinimumEngineVersion *string `type:"string"`

	// Specifies the name of the parameter.
	ParameterName *string `type:"string"`

	// Specifies the value of the parameter.
	ParameterValue *string `type:"string"`

	// Indicates the source of the parameter value.
	Source *string `type:"string"`
}

// String returns the string representation
func (s Parameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Parameter) GoString() string {
	return s.String()
}

// SetAllowedValues sets the AllowedValues field's value.
func (s *Parameter) SetAllowedValues(v string) *Parameter {
	s.AllowedValues = &v
	return s
}

// SetApplyMethod sets the ApplyMethod field's value.
func (s *Parameter) SetApplyMethod(v string) *Parameter {
	s.ApplyMethod = &v
	return s
}

// SetApplyType sets the ApplyType field's value.
func (s *Parameter) SetApplyType(v string) *Parameter {
	s.ApplyType = &v
	return s
}

// SetDataType sets the DataType field's value.
func (s *Parameter) SetDataType(v string) *Parameter {
	s.DataType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Parameter) SetDescription(v string) *Parameter {
	s.Description = &v
	return s
}

// SetIsModifiable sets the IsModifiable field's value.
func (s *Parameter) SetIsModifiable(v bool) *Parameter {
	s.IsModifiable = &v
	return s
}

// SetMinimumEngineVersion sets the MinimumEngineVersion field's value.
func (s *Parameter) SetMinimumEngineVersion(v string) *Parameter {
	s.MinimumEngineVersion = &v
	return s
}

// SetParameterName sets the ParameterName field's value.
func (s *Parameter) SetParameterName(v string) *Parameter {
	s.ParameterName = &v
	return s
}

// SetParameterValue sets the ParameterValue field's value.
func (s *Parameter) SetParameterValue(v string) *Parameter {
	s.ParameterValue = &v
	return s
}

// SetSource sets the Source field's value.
func (s *Parameter) SetSource(v string) *Parameter {
	s.Source = &v
	return s
}

// Provides information about a pending maintenance action for a resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/PendingMaintenanceAction
type PendingMaintenanceAction struct {
	_ struct{} `type:"structure"`

	// The type of pending maintenance action that is available for the resource.
	Action *string `type:"string"`

	// The date of the maintenance window when the action will be applied. The maintenance
	// action will be applied to the resource during its first maintenance window
	// after this date. If this date is specified, any next-maintenance opt-in requests
	// are ignored.
	AutoAppliedAfterDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The effective date when the pending maintenance action will be applied to
	// the resource. This date takes into account opt-in requests received from
	// the ApplyPendingMaintenanceAction API, the AutoAppliedAfterDate, and the
	// ForcedApplyDate. This value is blank if an opt-in request has not been received
	// and nothing has been specified as AutoAppliedAfterDate or ForcedApplyDate.
	CurrentApplyDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A description providing more detail about the maintenance action.
	Description *string `type:"string"`

	// The date when the maintenance action will be automatically applied. The maintenance
	// action will be applied to the resource on this date regardless of the maintenance
	// window for the resource. If this date is specified, any immediate opt-in
	// requests are ignored.
	ForcedApplyDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Indicates the type of opt-in request that has been received for the resource.
	OptInStatus *string `type:"string"`
}

// String returns the string representation
func (s PendingMaintenanceAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PendingMaintenanceAction) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *PendingMaintenanceAction) SetAction(v string) *PendingMaintenanceAction {
	s.Action = &v
	return s
}

// SetAutoAppliedAfterDate sets the AutoAppliedAfterDate field's value.
func (s *PendingMaintenanceAction) SetAutoAppliedAfterDate(v time.Time) *PendingMaintenanceAction {
	s.AutoAppliedAfterDate = &v
	return s
}

// SetCurrentApplyDate sets the CurrentApplyDate field's value.
func (s *PendingMaintenanceAction) SetCurrentApplyDate(v time.Time) *PendingMaintenanceAction {
	s.CurrentApplyDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PendingMaintenanceAction) SetDescription(v string) *PendingMaintenanceAction {
	s.Description = &v
	return s
}

// SetForcedApplyDate sets the ForcedApplyDate field's value.
func (s *PendingMaintenanceAction) SetForcedApplyDate(v time.Time) *PendingMaintenanceAction {
	s.ForcedApplyDate = &v
	return s
}

// SetOptInStatus sets the OptInStatus field's value.
func (s *PendingMaintenanceAction) SetOptInStatus(v string) *PendingMaintenanceAction {
	s.OptInStatus = &v
	return s
}

// This data type is used as a response element in the ModifyDBInstance action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/PendingModifiedValues
type PendingModifiedValues struct {
	_ struct{} `type:"structure"`

	// Contains the new AllocatedStorage size for the DB instance that will be applied
	// or is in progress.
	AllocatedStorage *int64 `type:"integer"`

	// Specifies the pending number of days for which automated backups are retained.
	BackupRetentionPeriod *int64 `type:"integer"`

	// Specifies the identifier of the CA certificate for the DB instance.
	CACertificateIdentifier *string `type:"string"`

	// Contains the new DBInstanceClass for the DB instance that will be applied
	// or is in progress.
	DBInstanceClass *string `type:"string"`

	// Contains the new DBInstanceIdentifier for the DB instance that will be applied
	// or is in progress.
	DBInstanceIdentifier *string `type:"string"`

	// The new DB subnet group for the DB instance.
	DBSubnetGroupName *string `type:"string"`

	// Indicates the database engine version.
	EngineVersion *string `type:"string"`

	// Specifies the new Provisioned IOPS value for the DB instance that will be
	// applied or is being applied.
	Iops *int64 `type:"integer"`

	// The license model for the DB instance.
	//
	// Valid values: license-included | bring-your-own-license | general-public-license
	LicenseModel *string `type:"string"`

	// Contains the pending or in-progress change of the master credentials for
	// the DB instance.
	MasterUserPassword *string `type:"string"`

	// Indicates that the Single-AZ DB instance is to change to a Multi-AZ deployment.
	MultiAZ *bool `type:"boolean"`

	// Specifies the pending port for the DB instance.
	Port *int64 `type:"integer"`

	// Specifies the storage type to be associated with the DB instance.
	StorageType *string `type:"string"`
}

// String returns the string representation
func (s PendingModifiedValues) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PendingModifiedValues) GoString() string {
	return s.String()
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *PendingModifiedValues) SetAllocatedStorage(v int64) *PendingModifiedValues {
	s.AllocatedStorage = &v
	return s
}

// SetBackupRetentionPeriod sets the BackupRetentionPeriod field's value.
func (s *PendingModifiedValues) SetBackupRetentionPeriod(v int64) *PendingModifiedValues {
	s.BackupRetentionPeriod = &v
	return s
}

// SetCACertificateIdentifier sets the CACertificateIdentifier field's value.
func (s *PendingModifiedValues) SetCACertificateIdentifier(v string) *PendingModifiedValues {
	s.CACertificateIdentifier = &v
	return s
}

// SetDBInstanceClass sets the DBInstanceClass field's value.
func (s *PendingModifiedValues) SetDBInstanceClass(v string) *PendingModifiedValues {
	s.DBInstanceClass = &v
	return s
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *PendingModifiedValues) SetDBInstanceIdentifier(v string) *PendingModifiedValues {
	s.DBInstanceIdentifier = &v
	return s
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *PendingModifiedValues) SetDBSubnetGroupName(v string) *PendingModifiedValues {
	s.DBSubnetGroupName = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *PendingModifiedValues) SetEngineVersion(v string) *PendingModifiedValues {
	s.EngineVersion = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *PendingModifiedValues) SetIops(v int64) *PendingModifiedValues {
	s.Iops = &v
	return s
}

// SetLicenseModel sets the LicenseModel field's value.
func (s *PendingModifiedValues) SetLicenseModel(v string) *PendingModifiedValues {
	s.LicenseModel = &v
	return s
}

// SetMasterUserPassword sets the MasterUserPassword field's value.
func (s *PendingModifiedValues) SetMasterUserPassword(v string) *PendingModifiedValues {
	s.MasterUserPassword = &v
	return s
}

// SetMultiAZ sets the MultiAZ field's value.
func (s *PendingModifiedValues) SetMultiAZ(v bool) *PendingModifiedValues {
	s.MultiAZ = &v
	return s
}

// SetPort sets the Port field's value.
func (s *PendingModifiedValues) SetPort(v int64) *PendingModifiedValues {
	s.Port = &v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *PendingModifiedValues) SetStorageType(v string) *PendingModifiedValues {
	s.StorageType = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/PromoteReadReplicaDBClusterMessage
type PromoteReadReplicaDBClusterInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the DB cluster Read Replica to promote. This parameter
	// is not case-sensitive.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// Example: my-cluster-replica1
	//
	// DBClusterIdentifier is a required field
	DBClusterIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PromoteReadReplicaDBClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PromoteReadReplicaDBClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PromoteReadReplicaDBClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PromoteReadReplicaDBClusterInput"}
	if s.DBClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *PromoteReadReplicaDBClusterInput) SetDBClusterIdentifier(v string) *PromoteReadReplicaDBClusterInput {
	s.DBClusterIdentifier = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/PromoteReadReplicaDBClusterResult
type PromoteReadReplicaDBClusterOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//    * CreateDBCluster
	//
	//    * DeleteDBCluster
	//
	//    * FailoverDBCluster
	//
	//    * ModifyDBCluster
	//
	//    * RestoreDBClusterFromSnapshot
	//
	//    * RestoreDBClusterToPointInTime
	//
	// This data type is used as a response element in the DescribeDBClusters action.
	DBCluster *DBCluster `type:"structure"`
}

// String returns the string representation
func (s PromoteReadReplicaDBClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PromoteReadReplicaDBClusterOutput) GoString() string {
	return s.String()
}

// SetDBCluster sets the DBCluster field's value.
func (s *PromoteReadReplicaDBClusterOutput) SetDBCluster(v *DBCluster) *PromoteReadReplicaDBClusterOutput {
	s.DBCluster = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/PromoteReadReplicaMessage
type PromoteReadReplicaInput struct {
	_ struct{} `type:"structure"`

	// The number of days to retain automated backups. Setting this parameter to
	// a positive number enables backups. Setting this parameter to 0 disables automated
	// backups.
	//
	// Default: 1
	//
	// Constraints:
	//
	//    * Must be a value from 0 to 8
	BackupRetentionPeriod *int64 `type:"integer"`

	// The DB instance identifier. This value is stored as a lowercase string.
	//
	// Constraints:
	//
	//    * Must be the identifier for an existing Read Replica DB instance
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	// Example: mydbinstance
	//
	// DBInstanceIdentifier is a required field
	DBInstanceIdentifier *string `type:"string" required:"true"`

	// The daily time range during which automated backups are created if automated
	// backups are enabled, using the BackupRetentionPeriod parameter.
	//
	// Default: A 30-minute window selected at random from an 8-hour block of time
	// per AWS Region. To see the time blocks available, see  Adjusting the Preferred
	// Maintenance Window (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html)
	// in the Amazon RDS User Guide.
	//
	// Constraints:
	//
	//    * Must be in the format hh24:mi-hh24:mi.
	//
	//    * Times should be in Universal Coordinated Time (UTC).
	//
	//    * Must not conflict with the preferred maintenance window.
	//
	//    * Must be at least 30 minutes.
	PreferredBackupWindow *string `type:"string"`
}

// String returns the string representation
func (s PromoteReadReplicaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PromoteReadReplicaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PromoteReadReplicaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PromoteReadReplicaInput"}
	if s.DBInstanceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBInstanceIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupRetentionPeriod sets the BackupRetentionPeriod field's value.
func (s *PromoteReadReplicaInput) SetBackupRetentionPeriod(v int64) *PromoteReadReplicaInput {
	s.BackupRetentionPeriod = &v
	return s
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *PromoteReadReplicaInput) SetDBInstanceIdentifier(v string) *PromoteReadReplicaInput {
	s.DBInstanceIdentifier = &v
	return s
}

// SetPreferredBackupWindow sets the PreferredBackupWindow field's value.
func (s *PromoteReadReplicaInput) SetPreferredBackupWindow(v string) *PromoteReadReplicaInput {
	s.PreferredBackupWindow = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/PromoteReadReplicaResult
type PromoteReadReplicaOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//    * CreateDBInstance
	//
	//    * DeleteDBInstance
	//
	//    * ModifyDBInstance
	//
	//    * StopDBInstance
	//
	//    * StartDBInstance
	//
	// This data type is used as a response element in the DescribeDBInstances action.
	DBInstance *DBInstance `type:"structure"`
}

// String returns the string representation
func (s PromoteReadReplicaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PromoteReadReplicaOutput) GoString() string {
	return s.String()
}

// SetDBInstance sets the DBInstance field's value.
func (s *PromoteReadReplicaOutput) SetDBInstance(v *DBInstance) *PromoteReadReplicaOutput {
	s.DBInstance = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/PurchaseReservedDBInstancesOfferingMessage
type PurchaseReservedDBInstancesOfferingInput struct {
	_ struct{} `type:"structure"`

	// The number of instances to reserve.
	//
	// Default: 1
	DBInstanceCount *int64 `type:"integer"`

	// Customer-specified identifier to track this reservation.
	//
	// Example: myreservationID
	ReservedDBInstanceId *string `type:"string"`

	// The ID of the Reserved DB instance offering to purchase.
	//
	// Example: 438012d3-4052-4cc7-b2e3-8d3372e0e706
	//
	// ReservedDBInstancesOfferingId is a required field
	ReservedDBInstancesOfferingId *string `type:"string" required:"true"`

	// A list of tags.
	Tags []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s PurchaseReservedDBInstancesOfferingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PurchaseReservedDBInstancesOfferingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PurchaseReservedDBInstancesOfferingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PurchaseReservedDBInstancesOfferingInput"}
	if s.ReservedDBInstancesOfferingId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReservedDBInstancesOfferingId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBInstanceCount sets the DBInstanceCount field's value.
func (s *PurchaseReservedDBInstancesOfferingInput) SetDBInstanceCount(v int64) *PurchaseReservedDBInstancesOfferingInput {
	s.DBInstanceCount = &v
	return s
}

// SetReservedDBInstanceId sets the ReservedDBInstanceId field's value.
func (s *PurchaseReservedDBInstancesOfferingInput) SetReservedDBInstanceId(v string) *PurchaseReservedDBInstancesOfferingInput {
	s.ReservedDBInstanceId = &v
	return s
}

// SetReservedDBInstancesOfferingId sets the ReservedDBInstancesOfferingId field's value.
func (s *PurchaseReservedDBInstancesOfferingInput) SetReservedDBInstancesOfferingId(v string) *PurchaseReservedDBInstancesOfferingInput {
	s.ReservedDBInstancesOfferingId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PurchaseReservedDBInstancesOfferingInput) SetTags(v []*Tag) *PurchaseReservedDBInstancesOfferingInput {
	s.Tags = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/PurchaseReservedDBInstancesOfferingResult
type PurchaseReservedDBInstancesOfferingOutput struct {
	_ struct{} `type:"structure"`

	// This data type is used as a response element in the DescribeReservedDBInstances
	// and PurchaseReservedDBInstancesOffering actions.
	ReservedDBInstance *ReservedDBInstance `type:"structure"`
}

// String returns the string representation
func (s PurchaseReservedDBInstancesOfferingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PurchaseReservedDBInstancesOfferingOutput) GoString() string {
	return s.String()
}

// SetReservedDBInstance sets the ReservedDBInstance field's value.
func (s *PurchaseReservedDBInstancesOfferingOutput) SetReservedDBInstance(v *ReservedDBInstance) *PurchaseReservedDBInstancesOfferingOutput {
	s.ReservedDBInstance = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RebootDBInstanceMessage
type RebootDBInstanceInput struct {
	_ struct{} `type:"structure"`

	// The DB instance identifier. This parameter is stored as a lowercase string.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	// DBInstanceIdentifier is a required field
	DBInstanceIdentifier *string `type:"string" required:"true"`

	// When true, the reboot will be conducted through a MultiAZ failover.
	//
	// Constraint: You cannot specify true if the instance is not configured for
	// MultiAZ.
	ForceFailover *bool `type:"boolean"`
}

// String returns the string representation
func (s RebootDBInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootDBInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebootDBInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RebootDBInstanceInput"}
	if s.DBInstanceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBInstanceIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *RebootDBInstanceInput) SetDBInstanceIdentifier(v string) *RebootDBInstanceInput {
	s.DBInstanceIdentifier = &v
	return s
}

// SetForceFailover sets the ForceFailover field's value.
func (s *RebootDBInstanceInput) SetForceFailover(v bool) *RebootDBInstanceInput {
	s.ForceFailover = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RebootDBInstanceResult
type RebootDBInstanceOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//    * CreateDBInstance
	//
	//    * DeleteDBInstance
	//
	//    * ModifyDBInstance
	//
	//    * StopDBInstance
	//
	//    * StartDBInstance
	//
	// This data type is used as a response element in the DescribeDBInstances action.
	DBInstance *DBInstance `type:"structure"`
}

// String returns the string representation
func (s RebootDBInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootDBInstanceOutput) GoString() string {
	return s.String()
}

// SetDBInstance sets the DBInstance field's value.
func (s *RebootDBInstanceOutput) SetDBInstance(v *DBInstance) *RebootDBInstanceOutput {
	s.DBInstance = v
	return s
}

// This data type is used as a response element in the DescribeReservedDBInstances
// and DescribeReservedDBInstancesOfferings actions.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RecurringCharge
type RecurringCharge struct {
	_ struct{} `type:"structure"`

	// The amount of the recurring charge.
	RecurringChargeAmount *float64 `type:"double"`

	// The frequency of the recurring charge.
	RecurringChargeFrequency *string `type:"string"`
}

// String returns the string representation
func (s RecurringCharge) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecurringCharge) GoString() string {
	return s.String()
}

// SetRecurringChargeAmount sets the RecurringChargeAmount field's value.
func (s *RecurringCharge) SetRecurringChargeAmount(v float64) *RecurringCharge {
	s.RecurringChargeAmount = &v
	return s
}

// SetRecurringChargeFrequency sets the RecurringChargeFrequency field's value.
func (s *RecurringCharge) SetRecurringChargeFrequency(v string) *RecurringCharge {
	s.RecurringChargeFrequency = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RemoveRoleFromDBClusterMessage
type RemoveRoleFromDBClusterInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB cluster to disassociate the IAM role from.
	//
	// DBClusterIdentifier is a required field
	DBClusterIdentifier *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role to disassociate from the Aurora
	// DB cluster, for example arn:aws:iam::123456789012:role/AuroraAccessRole.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveRoleFromDBClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveRoleFromDBClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveRoleFromDBClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveRoleFromDBClusterInput"}
	if s.DBClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterIdentifier"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *RemoveRoleFromDBClusterInput) SetDBClusterIdentifier(v string) *RemoveRoleFromDBClusterInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *RemoveRoleFromDBClusterInput) SetRoleArn(v string) *RemoveRoleFromDBClusterInput {
	s.RoleArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RemoveRoleFromDBClusterOutput
type RemoveRoleFromDBClusterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveRoleFromDBClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveRoleFromDBClusterOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RemoveSourceIdentifierFromSubscriptionMessage
type RemoveSourceIdentifierFromSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// The source identifier to be removed from the subscription, such as the DB
	// instance identifier for a DB instance or the name of a security group.
	//
	// SourceIdentifier is a required field
	SourceIdentifier *string `type:"string" required:"true"`

	// The name of the RDS event notification subscription you want to remove a
	// source identifier from.
	//
	// SubscriptionName is a required field
	SubscriptionName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveSourceIdentifierFromSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveSourceIdentifierFromSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveSourceIdentifierFromSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveSourceIdentifierFromSubscriptionInput"}
	if s.SourceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceIdentifier"))
	}
	if s.SubscriptionName == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceIdentifier sets the SourceIdentifier field's value.
func (s *RemoveSourceIdentifierFromSubscriptionInput) SetSourceIdentifier(v string) *RemoveSourceIdentifierFromSubscriptionInput {
	s.SourceIdentifier = &v
	return s
}

// SetSubscriptionName sets the SubscriptionName field's value.
func (s *RemoveSourceIdentifierFromSubscriptionInput) SetSubscriptionName(v string) *RemoveSourceIdentifierFromSubscriptionInput {
	s.SubscriptionName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RemoveSourceIdentifierFromSubscriptionResult
type RemoveSourceIdentifierFromSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// Contains the results of a successful invocation of the DescribeEventSubscriptions
	// action.
	EventSubscription *EventSubscription `type:"structure"`
}

// String returns the string representation
func (s RemoveSourceIdentifierFromSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveSourceIdentifierFromSubscriptionOutput) GoString() string {
	return s.String()
}

// SetEventSubscription sets the EventSubscription field's value.
func (s *RemoveSourceIdentifierFromSubscriptionOutput) SetEventSubscription(v *EventSubscription) *RemoveSourceIdentifierFromSubscriptionOutput {
	s.EventSubscription = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RemoveTagsFromResourceMessage
type RemoveTagsFromResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon RDS resource the tags will be removed from. This value is an Amazon
	// Resource Name (ARN). For information about creating an ARN, see  Constructing
	// an RDS Amazon Resource Name (ARN) (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing).
	//
	// ResourceName is a required field
	ResourceName *string `type:"string" required:"true"`

	// The tag key (name) of the tag to be removed.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s RemoveTagsFromResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTagsFromResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveTagsFromResourceInput"}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceName sets the ResourceName field's value.
func (s *RemoveTagsFromResourceInput) SetResourceName(v string) *RemoveTagsFromResourceInput {
	s.ResourceName = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *RemoveTagsFromResourceInput) SetTagKeys(v []*string) *RemoveTagsFromResourceInput {
	s.TagKeys = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RemoveTagsFromResourceOutput
type RemoveTagsFromResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveTagsFromResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromResourceOutput) GoString() string {
	return s.String()
}

// This data type is used as a response element in the DescribeReservedDBInstances
// and PurchaseReservedDBInstancesOffering actions.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ReservedDBInstance
type ReservedDBInstance struct {
	_ struct{} `type:"structure"`

	// The currency code for the reserved DB instance.
	CurrencyCode *string `type:"string"`

	// The DB instance class for the reserved DB instance.
	DBInstanceClass *string `type:"string"`

	// The number of reserved DB instances.
	DBInstanceCount *int64 `type:"integer"`

	// The duration of the reservation in seconds.
	Duration *int64 `type:"integer"`

	// The fixed price charged for this reserved DB instance.
	FixedPrice *float64 `type:"double"`

	// Indicates if the reservation applies to Multi-AZ deployments.
	MultiAZ *bool `type:"boolean"`

	// The offering type of this reserved DB instance.
	OfferingType *string `type:"string"`

	// The description of the reserved DB instance.
	ProductDescription *string `type:"string"`

	// The recurring price charged to run this reserved DB instance.
	RecurringCharges []*RecurringCharge `locationNameList:"RecurringCharge" type:"list"`

	// The Amazon Resource Name (ARN) for the reserved DB instance.
	ReservedDBInstanceArn *string `type:"string"`

	// The unique identifier for the reservation.
	ReservedDBInstanceId *string `type:"string"`

	// The offering identifier.
	ReservedDBInstancesOfferingId *string `type:"string"`

	// The time the reservation started.
	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The state of the reserved DB instance.
	State *string `type:"string"`

	// The hourly price charged for this reserved DB instance.
	UsagePrice *float64 `type:"double"`
}

// String returns the string representation
func (s ReservedDBInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservedDBInstance) GoString() string {
	return s.String()
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *ReservedDBInstance) SetCurrencyCode(v string) *ReservedDBInstance {
	s.CurrencyCode = &v
	return s
}

// SetDBInstanceClass sets the DBInstanceClass field's value.
func (s *ReservedDBInstance) SetDBInstanceClass(v string) *ReservedDBInstance {
	s.DBInstanceClass = &v
	return s
}

// SetDBInstanceCount sets the DBInstanceCount field's value.
func (s *ReservedDBInstance) SetDBInstanceCount(v int64) *ReservedDBInstance {
	s.DBInstanceCount = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *ReservedDBInstance) SetDuration(v int64) *ReservedDBInstance {
	s.Duration = &v
	return s
}

// SetFixedPrice sets the FixedPrice field's value.
func (s *ReservedDBInstance) SetFixedPrice(v float64) *ReservedDBInstance {
	s.FixedPrice = &v
	return s
}

// SetMultiAZ sets the MultiAZ field's value.
func (s *ReservedDBInstance) SetMultiAZ(v bool) *ReservedDBInstance {
	s.MultiAZ = &v
	return s
}

// SetOfferingType sets the OfferingType field's value.
func (s *ReservedDBInstance) SetOfferingType(v string) *ReservedDBInstance {
	s.OfferingType = &v
	return s
}

// SetProductDescription sets the ProductDescription field's value.
func (s *ReservedDBInstance) SetProductDescription(v string) *ReservedDBInstance {
	s.ProductDescription = &v
	return s
}

// SetRecurringCharges sets the RecurringCharges field's value.
func (s *ReservedDBInstance) SetRecurringCharges(v []*RecurringCharge) *ReservedDBInstance {
	s.RecurringCharges = v
	return s
}

// SetReservedDBInstanceArn sets the ReservedDBInstanceArn field's value.
func (s *ReservedDBInstance) SetReservedDBInstanceArn(v string) *ReservedDBInstance {
	s.ReservedDBInstanceArn = &v
	return s
}

// SetReservedDBInstanceId sets the ReservedDBInstanceId field's value.
func (s *ReservedDBInstance) SetReservedDBInstanceId(v string) *ReservedDBInstance {
	s.ReservedDBInstanceId = &v
	return s
}

// SetReservedDBInstancesOfferingId sets the ReservedDBInstancesOfferingId field's value.
func (s *ReservedDBInstance) SetReservedDBInstancesOfferingId(v string) *ReservedDBInstance {
	s.ReservedDBInstancesOfferingId = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ReservedDBInstance) SetStartTime(v time.Time) *ReservedDBInstance {
	s.StartTime = &v
	return s
}

// SetState sets the State field's value.
func (s *ReservedDBInstance) SetState(v string) *ReservedDBInstance {
	s.State = &v
	return s
}

// SetUsagePrice sets the UsagePrice field's value.
func (s *ReservedDBInstance) SetUsagePrice(v float64) *ReservedDBInstance {
	s.UsagePrice = &v
	return s
}

// This data type is used as a response element in the DescribeReservedDBInstancesOfferings
// action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ReservedDBInstancesOffering
type ReservedDBInstancesOffering struct {
	_ struct{} `type:"structure"`

	// The currency code for the reserved DB instance offering.
	CurrencyCode *string `type:"string"`

	// The DB instance class for the reserved DB instance.
	DBInstanceClass *string `type:"string"`

	// The duration of the offering in seconds.
	Duration *int64 `type:"integer"`

	// The fixed price charged for this offering.
	FixedPrice *float64 `type:"double"`

	// Indicates if the offering applies to Multi-AZ deployments.
	MultiAZ *bool `type:"boolean"`

	// The offering type.
	OfferingType *string `type:"string"`

	// The database engine used by the offering.
	ProductDescription *string `type:"string"`

	// The recurring price charged to run this reserved DB instance.
	RecurringCharges []*RecurringCharge `locationNameList:"RecurringCharge" type:"list"`

	// The offering identifier.
	ReservedDBInstancesOfferingId *string `type:"string"`

	// The hourly price charged for this offering.
	UsagePrice *float64 `type:"double"`
}

// String returns the string representation
func (s ReservedDBInstancesOffering) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservedDBInstancesOffering) GoString() string {
	return s.String()
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *ReservedDBInstancesOffering) SetCurrencyCode(v string) *ReservedDBInstancesOffering {
	s.CurrencyCode = &v
	return s
}

// SetDBInstanceClass sets the DBInstanceClass field's value.
func (s *ReservedDBInstancesOffering) SetDBInstanceClass(v string) *ReservedDBInstancesOffering {
	s.DBInstanceClass = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *ReservedDBInstancesOffering) SetDuration(v int64) *ReservedDBInstancesOffering {
	s.Duration = &v
	return s
}

// SetFixedPrice sets the FixedPrice field's value.
func (s *ReservedDBInstancesOffering) SetFixedPrice(v float64) *ReservedDBInstancesOffering {
	s.FixedPrice = &v
	return s
}

// SetMultiAZ sets the MultiAZ field's value.
func (s *ReservedDBInstancesOffering) SetMultiAZ(v bool) *ReservedDBInstancesOffering {
	s.MultiAZ = &v
	return s
}

// SetOfferingType sets the OfferingType field's value.
func (s *ReservedDBInstancesOffering) SetOfferingType(v string) *ReservedDBInstancesOffering {
	s.OfferingType = &v
	return s
}

// SetProductDescription sets the ProductDescription field's value.
func (s *ReservedDBInstancesOffering) SetProductDescription(v string) *ReservedDBInstancesOffering {
	s.ProductDescription = &v
	return s
}

// SetRecurringCharges sets the RecurringCharges field's value.
func (s *ReservedDBInstancesOffering) SetRecurringCharges(v []*RecurringCharge) *ReservedDBInstancesOffering {
	s.RecurringCharges = v
	return s
}

// SetReservedDBInstancesOfferingId sets the ReservedDBInstancesOfferingId field's value.
func (s *ReservedDBInstancesOffering) SetReservedDBInstancesOfferingId(v string) *ReservedDBInstancesOffering {
	s.ReservedDBInstancesOfferingId = &v
	return s
}

// SetUsagePrice sets the UsagePrice field's value.
func (s *ReservedDBInstancesOffering) SetUsagePrice(v float64) *ReservedDBInstancesOffering {
	s.UsagePrice = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ResetDBClusterParameterGroupMessage
type ResetDBClusterParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB cluster parameter group to reset.
	//
	// DBClusterParameterGroupName is a required field
	DBClusterParameterGroupName *string `type:"string" required:"true"`

	// A list of parameter names in the DB cluster parameter group to reset to the
	// default values. You cannot use this parameter if the ResetAllParameters parameter
	// is set to true.
	Parameters []*Parameter `locationNameList:"Parameter" type:"list"`

	// A value that is set to true to reset all parameters in the DB cluster parameter
	// group to their default values, and false otherwise. You cannot use this parameter
	// if there is a list of parameter names specified for the Parameters parameter.
	ResetAllParameters *bool `type:"boolean"`
}

// String returns the string representation
func (s ResetDBClusterParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetDBClusterParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResetDBClusterParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResetDBClusterParameterGroupInput"}
	if s.DBClusterParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterParameterGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *ResetDBClusterParameterGroupInput) SetDBClusterParameterGroupName(v string) *ResetDBClusterParameterGroupInput {
	s.DBClusterParameterGroupName = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *ResetDBClusterParameterGroupInput) SetParameters(v []*Parameter) *ResetDBClusterParameterGroupInput {
	s.Parameters = v
	return s
}

// SetResetAllParameters sets the ResetAllParameters field's value.
func (s *ResetDBClusterParameterGroupInput) SetResetAllParameters(v bool) *ResetDBClusterParameterGroupInput {
	s.ResetAllParameters = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ResetDBParameterGroupMessage
type ResetDBParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB parameter group.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 alphanumeric characters
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	// DBParameterGroupName is a required field
	DBParameterGroupName *string `type:"string" required:"true"`

	// To reset the entire DB parameter group, specify the DBParameterGroup name
	// and ResetAllParameters parameters. To reset specific parameters, provide
	// a list of the following: ParameterName and ApplyMethod. A maximum of 20 parameters
	// can be modified in a single request.
	//
	// MySQL
	//
	// Valid Values (for Apply method): immediate | pending-reboot
	//
	// You can use the immediate value with dynamic parameters only. You can use
	// the pending-reboot value for both dynamic and static parameters, and changes
	// are applied when DB instance reboots.
	//
	// MariaDB
	//
	// Valid Values (for Apply method): immediate | pending-reboot
	//
	// You can use the immediate value with dynamic parameters only. You can use
	// the pending-reboot value for both dynamic and static parameters, and changes
	// are applied when DB instance reboots.
	//
	// Oracle
	//
	// Valid Values (for Apply method): pending-reboot
	Parameters []*Parameter `locationNameList:"Parameter" type:"list"`

	// Specifies whether (true) or not (false) to reset all parameters in the DB
	// parameter group to default values.
	//
	// Default: true
	ResetAllParameters *bool `type:"boolean"`
}

// String returns the string representation
func (s ResetDBParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetDBParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResetDBParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResetDBParameterGroupInput"}
	if s.DBParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DBParameterGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBParameterGroupName sets the DBParameterGroupName field's value.
func (s *ResetDBParameterGroupInput) SetDBParameterGroupName(v string) *ResetDBParameterGroupInput {
	s.DBParameterGroupName = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *ResetDBParameterGroupInput) SetParameters(v []*Parameter) *ResetDBParameterGroupInput {
	s.Parameters = v
	return s
}

// SetResetAllParameters sets the ResetAllParameters field's value.
func (s *ResetDBParameterGroupInput) SetResetAllParameters(v bool) *ResetDBParameterGroupInput {
	s.ResetAllParameters = &v
	return s
}

// Describes the pending maintenance actions for a resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ResourcePendingMaintenanceActions
type ResourcePendingMaintenanceActions struct {
	_ struct{} `type:"structure"`

	// A list that provides details about the pending maintenance actions for the
	// resource.
	PendingMaintenanceActionDetails []*PendingMaintenanceAction `locationNameList:"PendingMaintenanceAction" type:"list"`

	// The ARN of the resource that has pending maintenance actions.
	ResourceIdentifier *string `type:"string"`
}

// String returns the string representation
func (s ResourcePendingMaintenanceActions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourcePendingMaintenanceActions) GoString() string {
	return s.String()
}

// SetPendingMaintenanceActionDetails sets the PendingMaintenanceActionDetails field's value.
func (s *ResourcePendingMaintenanceActions) SetPendingMaintenanceActionDetails(v []*PendingMaintenanceAction) *ResourcePendingMaintenanceActions {
	s.PendingMaintenanceActionDetails = v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *ResourcePendingMaintenanceActions) SetResourceIdentifier(v string) *ResourcePendingMaintenanceActions {
	s.ResourceIdentifier = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBClusterFromS3Message
type RestoreDBClusterFromS3Input struct {
	_ struct{} `type:"structure"`

	// A list of EC2 Availability Zones that instances in the restored DB cluster
	// can be created in.
	AvailabilityZones []*string `locationNameList:"AvailabilityZone" type:"list"`

	// The number of days for which automated backups of the restored DB cluster
	// are retained. You must specify a minimum value of 1.
	//
	// Default: 1
	//
	// Constraints:
	//
	//    * Must be a value from 1 to 35
	BackupRetentionPeriod *int64 `type:"integer"`

	// A value that indicates that the restored DB cluster should be associated
	// with the specified CharacterSet.
	CharacterSetName *string `type:"string"`

	// The name of the DB cluster to create from the source data in the S3 bucket.
	// This parameter is isn't case-sensitive.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// Example: my-cluster1
	//
	// DBClusterIdentifier is a required field
	DBClusterIdentifier *string `type:"string" required:"true"`

	// The name of the DB cluster parameter group to associate with the restored
	// DB cluster. If this argument is omitted, default.aurora5.6 will be used.
	//
	// Constraints:
	//
	//    * Must be 1 to 255 alphanumeric characters
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	DBClusterParameterGroupName *string `type:"string"`

	// A DB subnet group to associate with the restored DB cluster.
	//
	// Constraints: Must contain no more than 255 alphanumeric characters, periods,
	// underscores, spaces, or hyphens. Must not be default.
	//
	// Example: mySubnetgroup
	DBSubnetGroupName *string `type:"string"`

	// The database name for the restored DB cluster.
	DatabaseName *string `type:"string"`

	// A Boolean value that is true to enable mapping of AWS Identity and Access
	// Management (IAM) accounts to database accounts, and otherwise false.
	//
	// Default: false
	EnableIAMDatabaseAuthentication *bool `type:"boolean"`

	// The name of the database engine to be used for the restored DB cluster.
	//
	// Valid Values: aurora
	//
	// Engine is a required field
	Engine *string `type:"string" required:"true"`

	// The version number of the database engine to use.
	//
	// Aurora
	//
	// Example: 5.6.10a
	EngineVersion *string `type:"string"`

	// The KMS key identifier for an encrypted DB cluster.
	//
	// The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption
	// key. If you are creating a DB cluster with the same AWS account that owns
	// the KMS encryption key used to encrypt the new DB cluster, then you can use
	// the KMS key alias instead of the ARN for the KM encryption key.
	//
	// If the StorageEncrypted parameter is true, and you do not specify a value
	// for the KmsKeyId parameter, then Amazon RDS will use your default encryption
	// key. AWS KMS creates the default encryption key for your AWS account. Your
	// AWS account has a different default encryption key for each AWS Region.
	KmsKeyId *string `type:"string"`

	// The password for the master database user. This password can contain any
	// printable ASCII character except "/", """, or "@".
	//
	// Constraints: Must contain from 8 to 41 characters.
	//
	// MasterUserPassword is a required field
	MasterUserPassword *string `type:"string" required:"true"`

	// The name of the master user for the restored DB cluster.
	//
	// Constraints:
	//
	//    * Must be 1 to 16 alphanumeric characters.
	//
	//    * First character must be a letter.
	//
	//    * Cannot be a reserved word for the chosen database engine.
	//
	// MasterUsername is a required field
	MasterUsername *string `type:"string" required:"true"`

	// A value that indicates that the restored DB cluster should be associated
	// with the specified option group.
	//
	// Permanent options cannot be removed from an option group. An option group
	// cannot be removed from a DB cluster once it is associated with a DB cluster.
	OptionGroupName *string `type:"string"`

	// The port number on which the instances in the restored DB cluster accept
	// connections.
	//
	// Default: 3306
	Port *int64 `type:"integer"`

	// The daily time range during which automated backups are created if automated
	// backups are enabled using the BackupRetentionPeriod parameter.
	//
	// Default: A 30-minute window selected at random from an 8-hour block of time
	// per AWS Region. To see the time blocks available, see  Adjusting the Preferred
	// Maintenance Window (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html)
	// in the Amazon RDS User Guide.
	//
	// Constraints:
	//
	//    * Must be in the format hh24:mi-hh24:mi.
	//
	//    * Times should be in Universal Coordinated Time (UTC).
	//
	//    * Must not conflict with the preferred maintenance window.
	//
	//    * Must be at least 30 minutes.
	PreferredBackupWindow *string `type:"string"`

	// The weekly time range during which system maintenance can occur, in Universal
	// Coordinated Time (UTC).
	//
	// Format: ddd:hh24:mi-ddd:hh24:mi
	//
	// Default: A 30-minute window selected at random from an 8-hour block of time
	// per AWS Region, occurring on a random day of the week. To see the time blocks
	// available, see  Adjusting the Preferred Maintenance Window (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html)
	// in the Amazon RDS User Guide.
	//
	// Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
	//
	// Constraints: Minimum 30-minute window.
	PreferredMaintenanceWindow *string `type:"string"`

	// The name of the Amazon S3 bucket that contains the data used to create the
	// Amazon Aurora DB cluster.
	//
	// S3BucketName is a required field
	S3BucketName *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that authorizes Amazon RDS to access the Amazon S3 bucket on your
	// behalf.
	//
	// S3IngestionRoleArn is a required field
	S3IngestionRoleArn *string `type:"string" required:"true"`

	// The prefix for all of the file names that contain the data used to create
	// the Amazon Aurora DB cluster. If you do not specify a SourceS3Prefix value,
	// then the Amazon Aurora DB cluster is created by using all of the files in
	// the Amazon S3 bucket.
	S3Prefix *string `type:"string"`

	// The identifier for the database engine that was backed up to create the files
	// stored in the Amazon S3 bucket.
	//
	// Valid values: mysql
	//
	// SourceEngine is a required field
	SourceEngine *string `type:"string" required:"true"`

	// The version of the database that the backup files were created from.
	//
	// MySQL version 5.5 and 5.6 are supported.
	//
	// Example: 5.6.22
	//
	// SourceEngineVersion is a required field
	SourceEngineVersion *string `type:"string" required:"true"`

	// Specifies whether the restored DB cluster is encrypted.
	StorageEncrypted *bool `type:"boolean"`

	// A list of tags.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// A list of EC2 VPC security groups to associate with the restored DB cluster.
	VpcSecurityGroupIds []*string `locationNameList:"VpcSecurityGroupId" type:"list"`
}

// String returns the string representation
func (s RestoreDBClusterFromS3Input) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreDBClusterFromS3Input) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreDBClusterFromS3Input) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreDBClusterFromS3Input"}
	if s.DBClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterIdentifier"))
	}
	if s.Engine == nil {
		invalidParams.Add(request.NewErrParamRequired("Engine"))
	}
	if s.MasterUserPassword == nil {
		invalidParams.Add(request.NewErrParamRequired("MasterUserPassword"))
	}
	if s.MasterUsername == nil {
		invalidParams.Add(request.NewErrParamRequired("MasterUsername"))
	}
	if s.S3BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("S3BucketName"))
	}
	if s.S3IngestionRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("S3IngestionRoleArn"))
	}
	if s.SourceEngine == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceEngine"))
	}
	if s.SourceEngineVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceEngineVersion"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *RestoreDBClusterFromS3Input) SetAvailabilityZones(v []*string) *RestoreDBClusterFromS3Input {
	s.AvailabilityZones = v
	return s
}

// SetBackupRetentionPeriod sets the BackupRetentionPeriod field's value.
func (s *RestoreDBClusterFromS3Input) SetBackupRetentionPeriod(v int64) *RestoreDBClusterFromS3Input {
	s.BackupRetentionPeriod = &v
	return s
}

// SetCharacterSetName sets the CharacterSetName field's value.
func (s *RestoreDBClusterFromS3Input) SetCharacterSetName(v string) *RestoreDBClusterFromS3Input {
	s.CharacterSetName = &v
	return s
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *RestoreDBClusterFromS3Input) SetDBClusterIdentifier(v string) *RestoreDBClusterFromS3Input {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBClusterParameterGroupName sets the DBClusterParameterGroupName field's value.
func (s *RestoreDBClusterFromS3Input) SetDBClusterParameterGroupName(v string) *RestoreDBClusterFromS3Input {
	s.DBClusterParameterGroupName = &v
	return s
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *RestoreDBClusterFromS3Input) SetDBSubnetGroupName(v string) *RestoreDBClusterFromS3Input {
	s.DBSubnetGroupName = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *RestoreDBClusterFromS3Input) SetDatabaseName(v string) *RestoreDBClusterFromS3Input {
	s.DatabaseName = &v
	return s
}

// SetEnableIAMDatabaseAuthentication sets the EnableIAMDatabaseAuthentication field's value.
func (s *RestoreDBClusterFromS3Input) SetEnableIAMDatabaseAuthentication(v bool) *RestoreDBClusterFromS3Input {
	s.EnableIAMDatabaseAuthentication = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *RestoreDBClusterFromS3Input) SetEngine(v string) *RestoreDBClusterFromS3Input {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *RestoreDBClusterFromS3Input) SetEngineVersion(v string) *RestoreDBClusterFromS3Input {
	s.EngineVersion = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *RestoreDBClusterFromS3Input) SetKmsKeyId(v string) *RestoreDBClusterFromS3Input {
	s.KmsKeyId = &v
	return s
}

// SetMasterUserPassword sets the MasterUserPassword field's value.
func (s *RestoreDBClusterFromS3Input) SetMasterUserPassword(v string) *RestoreDBClusterFromS3Input {
	s.MasterUserPassword = &v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *RestoreDBClusterFromS3Input) SetMasterUsername(v string) *RestoreDBClusterFromS3Input {
	s.MasterUsername = &v
	return s
}

// SetOptionGroupName sets the OptionGroupName field's value.
func (s *RestoreDBClusterFromS3Input) SetOptionGroupName(v string) *RestoreDBClusterFromS3Input {
	s.OptionGroupName = &v
	return s
}

// SetPort sets the Port field's value.
func (s *RestoreDBClusterFromS3Input) SetPort(v int64) *RestoreDBClusterFromS3Input {
	s.Port = &v
	return s
}

// SetPreferredBackupWindow sets the PreferredBackupWindow field's value.
func (s *RestoreDBClusterFromS3Input) SetPreferredBackupWindow(v string) *RestoreDBClusterFromS3Input {
	s.PreferredBackupWindow = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *RestoreDBClusterFromS3Input) SetPreferredMaintenanceWindow(v string) *RestoreDBClusterFromS3Input {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *RestoreDBClusterFromS3Input) SetS3BucketName(v string) *RestoreDBClusterFromS3Input {
	s.S3BucketName = &v
	return s
}

// SetS3IngestionRoleArn sets the S3IngestionRoleArn field's value.
func (s *RestoreDBClusterFromS3Input) SetS3IngestionRoleArn(v string) *RestoreDBClusterFromS3Input {
	s.S3IngestionRoleArn = &v
	return s
}

// SetS3Prefix sets the S3Prefix field's value.
func (s *RestoreDBClusterFromS3Input) SetS3Prefix(v string) *RestoreDBClusterFromS3Input {
	s.S3Prefix = &v
	return s
}

// SetSourceEngine sets the SourceEngine field's value.
func (s *RestoreDBClusterFromS3Input) SetSourceEngine(v string) *RestoreDBClusterFromS3Input {
	s.SourceEngine = &v
	return s
}

// SetSourceEngineVersion sets the SourceEngineVersion field's value.
func (s *RestoreDBClusterFromS3Input) SetSourceEngineVersion(v string) *RestoreDBClusterFromS3Input {
	s.SourceEngineVersion = &v
	return s
}

// SetStorageEncrypted sets the StorageEncrypted field's value.
func (s *RestoreDBClusterFromS3Input) SetStorageEncrypted(v bool) *RestoreDBClusterFromS3Input {
	s.StorageEncrypted = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *RestoreDBClusterFromS3Input) SetTags(v []*Tag) *RestoreDBClusterFromS3Input {
	s.Tags = v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *RestoreDBClusterFromS3Input) SetVpcSecurityGroupIds(v []*string) *RestoreDBClusterFromS3Input {
	s.VpcSecurityGroupIds = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBClusterFromS3Result
type RestoreDBClusterFromS3Output struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//    * CreateDBCluster
	//
	//    * DeleteDBCluster
	//
	//    * FailoverDBCluster
	//
	//    * ModifyDBCluster
	//
	//    * RestoreDBClusterFromSnapshot
	//
	//    * RestoreDBClusterToPointInTime
	//
	// This data type is used as a response element in the DescribeDBClusters action.
	DBCluster *DBCluster `type:"structure"`
}

// String returns the string representation
func (s RestoreDBClusterFromS3Output) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreDBClusterFromS3Output) GoString() string {
	return s.String()
}

// SetDBCluster sets the DBCluster field's value.
func (s *RestoreDBClusterFromS3Output) SetDBCluster(v *DBCluster) *RestoreDBClusterFromS3Output {
	s.DBCluster = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBClusterFromSnapshotMessage
type RestoreDBClusterFromSnapshotInput struct {
	_ struct{} `type:"structure"`

	// Provides the list of EC2 Availability Zones that instances in the restored
	// DB cluster can be created in.
	AvailabilityZones []*string `locationNameList:"AvailabilityZone" type:"list"`

	// The name of the DB cluster to create from the DB cluster snapshot. This parameter
	// isn't case-sensitive.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 255 alphanumeric characters or hyphens
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	// Example: my-snapshot-id
	//
	// DBClusterIdentifier is a required field
	DBClusterIdentifier *string `type:"string" required:"true"`

	// The name of the DB subnet group to use for the new DB cluster.
	//
	// Constraints: Must contain no more than 255 alphanumeric characters, periods,
	// underscores, spaces, or hyphens. Must not be default.
	//
	// Example: mySubnetgroup
	DBSubnetGroupName *string `type:"string"`

	// The database name for the restored DB cluster.
	DatabaseName *string `type:"string"`

	// A Boolean value that is true to enable mapping of AWS Identity and Access
	// Management (IAM) accounts to database accounts, and otherwise false.
	//
	// Default: false
	EnableIAMDatabaseAuthentication *bool `type:"boolean"`

	// The database engine to use for the new DB cluster.
	//
	// Default: The same as source
	//
	// Constraint: Must be compatible with the engine of the source
	//
	// Engine is a required field
	Engine *string `type:"string" required:"true"`

	// The version of the database engine to use for the new DB cluster.
	EngineVersion *string `type:"string"`

	// The KMS key identifier to use when restoring an encrypted DB cluster from
	// a DB cluster snapshot.
	//
	// The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption
	// key. If you are restoring a DB cluster with the same AWS account that owns
	// the KMS encryption key used to encrypt the new DB cluster, then you can use
	// the KMS key alias instead of the ARN for the KMS encryption key.
	//
	// If you do not specify a value for the KmsKeyId parameter, then the following
	// will occur:
	//
	//    * If the DB cluster snapshot is encrypted, then the restored DB cluster
	//    is encrypted using the KMS key that was used to encrypt the DB cluster
	//    snapshot.
	//
	//    * If the DB cluster snapshot is not encrypted, then the restored DB cluster
	//    is encrypted using the specified encryption key.
	KmsKeyId *string `type:"string"`

	// The name of the option group to use for the restored DB cluster.
	OptionGroupName *string `type:"string"`

	// The port number on which the new DB cluster accepts connections.
	//
	// Constraints: Value must be 1150-65535
	//
	// Default: The same port as the original DB cluster.
	Port *int64 `type:"integer"`

	// The identifier for the DB cluster snapshot to restore from.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	// SnapshotIdentifier is a required field
	SnapshotIdentifier *string `type:"string" required:"true"`

	// The tags to be assigned to the restored DB cluster.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// A list of VPC security groups that the new DB cluster will belong to.
	VpcSecurityGroupIds []*string `locationNameList:"VpcSecurityGroupId" type:"list"`
}

// String returns the string representation
func (s RestoreDBClusterFromSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreDBClusterFromSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreDBClusterFromSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreDBClusterFromSnapshotInput"}
	if s.DBClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterIdentifier"))
	}
	if s.Engine == nil {
		invalidParams.Add(request.NewErrParamRequired("Engine"))
	}
	if s.SnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *RestoreDBClusterFromSnapshotInput) SetAvailabilityZones(v []*string) *RestoreDBClusterFromSnapshotInput {
	s.AvailabilityZones = v
	return s
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *RestoreDBClusterFromSnapshotInput) SetDBClusterIdentifier(v string) *RestoreDBClusterFromSnapshotInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *RestoreDBClusterFromSnapshotInput) SetDBSubnetGroupName(v string) *RestoreDBClusterFromSnapshotInput {
	s.DBSubnetGroupName = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *RestoreDBClusterFromSnapshotInput) SetDatabaseName(v string) *RestoreDBClusterFromSnapshotInput {
	s.DatabaseName = &v
	return s
}

// SetEnableIAMDatabaseAuthentication sets the EnableIAMDatabaseAuthentication field's value.
func (s *RestoreDBClusterFromSnapshotInput) SetEnableIAMDatabaseAuthentication(v bool) *RestoreDBClusterFromSnapshotInput {
	s.EnableIAMDatabaseAuthentication = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *RestoreDBClusterFromSnapshotInput) SetEngine(v string) *RestoreDBClusterFromSnapshotInput {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *RestoreDBClusterFromSnapshotInput) SetEngineVersion(v string) *RestoreDBClusterFromSnapshotInput {
	s.EngineVersion = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *RestoreDBClusterFromSnapshotInput) SetKmsKeyId(v string) *RestoreDBClusterFromSnapshotInput {
	s.KmsKeyId = &v
	return s
}

// SetOptionGroupName sets the OptionGroupName field's value.
func (s *RestoreDBClusterFromSnapshotInput) SetOptionGroupName(v string) *RestoreDBClusterFromSnapshotInput {
	s.OptionGroupName = &v
	return s
}

// SetPort sets the Port field's value.
func (s *RestoreDBClusterFromSnapshotInput) SetPort(v int64) *RestoreDBClusterFromSnapshotInput {
	s.Port = &v
	return s
}

// SetSnapshotIdentifier sets the SnapshotIdentifier field's value.
func (s *RestoreDBClusterFromSnapshotInput) SetSnapshotIdentifier(v string) *RestoreDBClusterFromSnapshotInput {
	s.SnapshotIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *RestoreDBClusterFromSnapshotInput) SetTags(v []*Tag) *RestoreDBClusterFromSnapshotInput {
	s.Tags = v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *RestoreDBClusterFromSnapshotInput) SetVpcSecurityGroupIds(v []*string) *RestoreDBClusterFromSnapshotInput {
	s.VpcSecurityGroupIds = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBClusterFromSnapshotResult
type RestoreDBClusterFromSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//    * CreateDBCluster
	//
	//    * DeleteDBCluster
	//
	//    * FailoverDBCluster
	//
	//    * ModifyDBCluster
	//
	//    * RestoreDBClusterFromSnapshot
	//
	//    * RestoreDBClusterToPointInTime
	//
	// This data type is used as a response element in the DescribeDBClusters action.
	DBCluster *DBCluster `type:"structure"`
}

// String returns the string representation
func (s RestoreDBClusterFromSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreDBClusterFromSnapshotOutput) GoString() string {
	return s.String()
}

// SetDBCluster sets the DBCluster field's value.
func (s *RestoreDBClusterFromSnapshotOutput) SetDBCluster(v *DBCluster) *RestoreDBClusterFromSnapshotOutput {
	s.DBCluster = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBClusterToPointInTimeMessage
type RestoreDBClusterToPointInTimeInput struct {
	_ struct{} `type:"structure"`

	// The name of the new DB cluster to be created.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	// DBClusterIdentifier is a required field
	DBClusterIdentifier *string `type:"string" required:"true"`

	// The DB subnet group name to use for the new DB cluster.
	//
	// Constraints: Must contain no more than 255 alphanumeric characters, periods,
	// underscores, spaces, or hyphens. Must not be default.
	//
	// Example: mySubnetgroup
	DBSubnetGroupName *string `type:"string"`

	// A Boolean value that is true to enable mapping of AWS Identity and Access
	// Management (IAM) accounts to database accounts, and otherwise false.
	//
	// Default: false
	EnableIAMDatabaseAuthentication *bool `type:"boolean"`

	// The KMS key identifier to use when restoring an encrypted DB cluster from
	// an encrypted DB cluster.
	//
	// The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption
	// key. If you are restoring a DB cluster with the same AWS account that owns
	// the KMS encryption key used to encrypt the new DB cluster, then you can use
	// the KMS key alias instead of the ARN for the KMS encryption key.
	//
	// You can restore to a new DB cluster and encrypt the new DB cluster with a
	// KMS key that is different than the KMS key used to encrypt the source DB
	// cluster. The new DB cluster will be encrypted with the KMS key identified
	// by the KmsKeyId parameter.
	//
	// If you do not specify a value for the KmsKeyId parameter, then the following
	// will occur:
	//
	//    * If the DB cluster is encrypted, then the restored DB cluster is encrypted
	//    using the KMS key that was used to encrypt the source DB cluster.
	//
	//    * If the DB cluster is not encrypted, then the restored DB cluster is
	//    not encrypted.
	//
	// If DBClusterIdentifier refers to a DB cluster that is not encrypted, then
	// the restore request is rejected.
	KmsKeyId *string `type:"string"`

	// The name of the option group for the new DB cluster.
	OptionGroupName *string `type:"string"`

	// The port number on which the new DB cluster accepts connections.
	//
	// Constraints: Value must be 1150-65535
	//
	// Default: The same port as the original DB cluster.
	Port *int64 `type:"integer"`

	// The date and time to restore the DB cluster to.
	//
	// Valid Values: Value must be a time in Universal Coordinated Time (UTC) format
	//
	// Constraints:
	//
	//    * Must be before the latest restorable time for the DB instance
	//
	//    * Must be specified if UseLatestRestorableTime parameter is not provided
	//
	//    * Cannot be specified if UseLatestRestorableTime parameter is true
	//
	//    * Cannot be specified if RestoreType parameter is copy-on-write
	//
	// Example: 2015-03-07T23:45:00Z
	RestoreToTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The type of restore to be performed. You can specify one of the following
	// values:
	//
	//    * full-copy - The new DB cluster is restored as a full copy of the source
	//    DB cluster.
	//
	//    * copy-on-write - The new DB cluster is restored as a clone of the source
	//    DB cluster.
	//
	// Constraints: You cannot specify copy-on-write if the engine version of the
	// source DB cluster is earlier than 1.11.
	//
	// If you don't specify a RestoreType value, then the new DB cluster is restored
	// as a full copy of the source DB cluster.
	RestoreType *string `type:"string"`

	// The identifier of the source DB cluster from which to restore.
	//
	// Constraints:
	//
	//    * Must be the identifier of an existing database instance
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	// SourceDBClusterIdentifier is a required field
	SourceDBClusterIdentifier *string `type:"string" required:"true"`

	// A list of tags.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// A value that is set to true to restore the DB cluster to the latest restorable
	// backup time, and false otherwise.
	//
	// Default: false
	//
	// Constraints: Cannot be specified if RestoreToTime parameter is provided.
	UseLatestRestorableTime *bool `type:"boolean"`

	// A list of VPC security groups that the new DB cluster belongs to.
	VpcSecurityGroupIds []*string `locationNameList:"VpcSecurityGroupId" type:"list"`
}

// String returns the string representation
func (s RestoreDBClusterToPointInTimeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreDBClusterToPointInTimeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreDBClusterToPointInTimeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreDBClusterToPointInTimeInput"}
	if s.DBClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBClusterIdentifier"))
	}
	if s.SourceDBClusterIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceDBClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDBClusterIdentifier sets the DBClusterIdentifier field's value.
func (s *RestoreDBClusterToPointInTimeInput) SetDBClusterIdentifier(v string) *RestoreDBClusterToPointInTimeInput {
	s.DBClusterIdentifier = &v
	return s
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *RestoreDBClusterToPointInTimeInput) SetDBSubnetGroupName(v string) *RestoreDBClusterToPointInTimeInput {
	s.DBSubnetGroupName = &v
	return s
}

// SetEnableIAMDatabaseAuthentication sets the EnableIAMDatabaseAuthentication field's value.
func (s *RestoreDBClusterToPointInTimeInput) SetEnableIAMDatabaseAuthentication(v bool) *RestoreDBClusterToPointInTimeInput {
	s.EnableIAMDatabaseAuthentication = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *RestoreDBClusterToPointInTimeInput) SetKmsKeyId(v string) *RestoreDBClusterToPointInTimeInput {
	s.KmsKeyId = &v
	return s
}

// SetOptionGroupName sets the OptionGroupName field's value.
func (s *RestoreDBClusterToPointInTimeInput) SetOptionGroupName(v string) *RestoreDBClusterToPointInTimeInput {
	s.OptionGroupName = &v
	return s
}

// SetPort sets the Port field's value.
func (s *RestoreDBClusterToPointInTimeInput) SetPort(v int64) *RestoreDBClusterToPointInTimeInput {
	s.Port = &v
	return s
}

// SetRestoreToTime sets the RestoreToTime field's value.
func (s *RestoreDBClusterToPointInTimeInput) SetRestoreToTime(v time.Time) *RestoreDBClusterToPointInTimeInput {
	s.RestoreToTime = &v
	return s
}

// SetRestoreType sets the RestoreType field's value.
func (s *RestoreDBClusterToPointInTimeInput) SetRestoreType(v string) *RestoreDBClusterToPointInTimeInput {
	s.RestoreType = &v
	return s
}

// SetSourceDBClusterIdentifier sets the SourceDBClusterIdentifier field's value.
func (s *RestoreDBClusterToPointInTimeInput) SetSourceDBClusterIdentifier(v string) *RestoreDBClusterToPointInTimeInput {
	s.SourceDBClusterIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *RestoreDBClusterToPointInTimeInput) SetTags(v []*Tag) *RestoreDBClusterToPointInTimeInput {
	s.Tags = v
	return s
}

// SetUseLatestRestorableTime sets the UseLatestRestorableTime field's value.
func (s *RestoreDBClusterToPointInTimeInput) SetUseLatestRestorableTime(v bool) *RestoreDBClusterToPointInTimeInput {
	s.UseLatestRestorableTime = &v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *RestoreDBClusterToPointInTimeInput) SetVpcSecurityGroupIds(v []*string) *RestoreDBClusterToPointInTimeInput {
	s.VpcSecurityGroupIds = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBClusterToPointInTimeResult
type RestoreDBClusterToPointInTimeOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//    * CreateDBCluster
	//
	//    * DeleteDBCluster
	//
	//    * FailoverDBCluster
	//
	//    * ModifyDBCluster
	//
	//    * RestoreDBClusterFromSnapshot
	//
	//    * RestoreDBClusterToPointInTime
	//
	// This data type is used as a response element in the DescribeDBClusters action.
	DBCluster *DBCluster `type:"structure"`
}

// String returns the string representation
func (s RestoreDBClusterToPointInTimeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreDBClusterToPointInTimeOutput) GoString() string {
	return s.String()
}

// SetDBCluster sets the DBCluster field's value.
func (s *RestoreDBClusterToPointInTimeOutput) SetDBCluster(v *DBCluster) *RestoreDBClusterToPointInTimeOutput {
	s.DBCluster = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBInstanceFromDBSnapshotMessage
type RestoreDBInstanceFromDBSnapshotInput struct {
	_ struct{} `type:"structure"`

	// Indicates that minor version upgrades will be applied automatically to the
	// DB instance during the maintenance window.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// The EC2 Availability Zone that the database instance will be created in.
	//
	// Default: A random, system-chosen Availability Zone.
	//
	// Constraint: You cannot specify the AvailabilityZone parameter if the MultiAZ
	// parameter is set to true.
	//
	// Example: us-east-1a
	AvailabilityZone *string `type:"string"`

	// True to copy all tags from the restored DB instance to snapshots of the DB
	// instance; otherwise false. The default is false.
	CopyTagsToSnapshot *bool `type:"boolean"`

	// The compute and memory capacity of the Amazon RDS DB instance.
	//
	// Valid Values: db.t1.micro | db.m1.small | db.m1.medium | db.m1.large | db.m1.xlarge
	// | db.m2.2xlarge | db.m2.4xlarge | db.m3.medium | db.m3.large | db.m3.xlarge
	// | db.m3.2xlarge | db.m4.large | db.m4.xlarge | db.m4.2xlarge | db.m4.4xlarge
	// | db.m4.10xlarge | db.r3.large | db.r3.xlarge | db.r3.2xlarge | db.r3.4xlarge
	// | db.r3.8xlarge | db.t2.micro | db.t2.small | db.t2.medium | db.t2.large
	DBInstanceClass *string `type:"string"`

	// Name of the DB instance to create from the DB snapshot. This parameter isn't
	// case-sensitive.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	// Example: my-snapshot-id
	//
	// DBInstanceIdentifier is a required field
	DBInstanceIdentifier *string `type:"string" required:"true"`

	// The database name for the restored DB instance.
	//
	// This parameter doesn't apply to the MySQL, PostgreSQL, or MariaDB engines.
	DBName *string `type:"string"`

	// The identifier for the DB snapshot to restore from.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 255 alphanumeric characters or hyphens
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	// If you are restoring from a shared manual DB snapshot, the DBSnapshotIdentifier
	// must be the ARN of the shared DB snapshot.
	//
	// DBSnapshotIdentifier is a required field
	DBSnapshotIdentifier *string `type:"string" required:"true"`

	// The DB subnet group name to use for the new instance.
	//
	// Constraints: Must contain no more than 255 alphanumeric characters, periods,
	// underscores, spaces, or hyphens. Must not be default.
	//
	// Example: mySubnetgroup
	DBSubnetGroupName *string `type:"string"`

	// Specify the Active Directory Domain to restore the instance in.
	Domain *string `type:"string"`

	// Specify the name of the IAM role to be used when making API calls to the
	// Directory Service.
	DomainIAMRoleName *string `type:"string"`

	// True to enable mapping of AWS Identity and Access Management (IAM) accounts
	// to database accounts; otherwise false.
	//
	// You can enable IAM database authentication for the following database engines
	//
	//    * For MySQL 5.6, minor version 5.6.34 or higher
	//
	//    * For MySQL 5.7, minor version 5.7.16 or higher
	//
	//    * Aurora 5.6 or higher.
	//
	// Default: false
	EnableIAMDatabaseAuthentication *bool `type:"boolean"`

	// The database engine to use for the new instance.
	//
	// Default: The same as source
	//
	// Constraint: Must be compatible with the engine of the source. You can restore
	// a MariaDB 10.1 DB instance from a MySQL 5.6 snapshot.
	//
	// Valid Values: MySQL | mariadb | oracle-se1 | oracle-se | oracle-ee | sqlserver-ee
	// | sqlserver-se | sqlserver-ex | sqlserver-web | postgres | aurora
	Engine *string `type:"string"`

	// Specifies the amount of provisioned IOPS for the DB instance, expressed in
	// I/O operations per second. If this parameter is not specified, the IOPS value
	// will be taken from the backup. If this parameter is set to 0, the new instance
	// will be converted to a non-PIOPS instance, which will take additional time,
	// though your DB instance will be available for connections before the conversion
	// starts.
	//
	// Constraints: Must be an integer greater than 1000.
	//
	// SQL Server
	//
	// Setting the IOPS value for the SQL Server database engine is not supported.
	Iops *int64 `type:"integer"`

	// License model information for the restored DB instance.
	//
	// Default: Same as source.
	//
	// Valid values: license-included | bring-your-own-license | general-public-license
	LicenseModel *string `type:"string"`

	// Specifies if the DB instance is a Multi-AZ deployment.
	//
	// Constraint: You cannot specify the AvailabilityZone parameter if the MultiAZ
	// parameter is set to true.
	MultiAZ *bool `type:"boolean"`

	// The name of the option group to be used for the restored DB instance.
	//
	// Permanent options, such as the TDE option for Oracle Advanced Security TDE,
	// cannot be removed from an option group, and that option group cannot be removed
	// from a DB instance once it is associated with a DB instance
	OptionGroupName *string `type:"string"`

	// The port number on which the database accepts connections.
	//
	// Default: The same port as the original DB instance
	//
	// Constraints: Value must be 1150-65535
	Port *int64 `type:"integer"`

	// Specifies the accessibility options for the DB instance. A value of true
	// specifies an Internet-facing instance with a publicly resolvable DNS name,
	// which resolves to a public IP address. A value of false specifies an internal
	// instance with a DNS name that resolves to a private IP address.
	//
	// Default: The default behavior varies depending on whether a VPC has been
	// requested or not. The following list shows the default behavior in each case.
	//
	//    * Default VPC: true
	//
	//    * VPC: false
	//
	// If no DB subnet group has been specified as part of the request and the PubliclyAccessible
	// value has not been set, the DB instance will be publicly accessible. If a
	// specific DB subnet group has been specified as part of the request and the
	// PubliclyAccessible value has not been set, the DB instance will be private.
	PubliclyAccessible *bool `type:"boolean"`

	// Specifies the storage type to be associated with the DB instance.
	//
	// Valid values: standard | gp2 | io1
	//
	// If you specify io1, you must also include a value for the Iops parameter.
	//
	// Default: io1 if the Iops parameter is specified; otherwise standard
	StorageType *string `type:"string"`

	// A list of tags.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// The ARN from the Key Store with which to associate the instance for TDE encryption.
	TdeCredentialArn *string `type:"string"`

	// The password for the given ARN from the Key Store in order to access the
	// device.
	TdeCredentialPassword *string `type:"string"`
}

// String returns the string representation
func (s RestoreDBInstanceFromDBSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreDBInstanceFromDBSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreDBInstanceFromDBSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreDBInstanceFromDBSnapshotInput"}
	if s.DBInstanceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBInstanceIdentifier"))
	}
	if s.DBSnapshotIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DBSnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoMinorVersionUpgrade sets the AutoMinorVersionUpgrade field's value.
func (s *RestoreDBInstanceFromDBSnapshotInput) SetAutoMinorVersionUpgrade(v bool) *RestoreDBInstanceFromDBSnapshotInput {
	s.AutoMinorVersionUpgrade = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *RestoreDBInstanceFromDBSnapshotInput) SetAvailabilityZone(v string) *RestoreDBInstanceFromDBSnapshotInput {
	s.AvailabilityZone = &v
	return s
}

// SetCopyTagsToSnapshot sets the CopyTagsToSnapshot field's value.
func (s *RestoreDBInstanceFromDBSnapshotInput) SetCopyTagsToSnapshot(v bool) *RestoreDBInstanceFromDBSnapshotInput {
	s.CopyTagsToSnapshot = &v
	return s
}

// SetDBInstanceClass sets the DBInstanceClass field's value.
func (s *RestoreDBInstanceFromDBSnapshotInput) SetDBInstanceClass(v string) *RestoreDBInstanceFromDBSnapshotInput {
	s.DBInstanceClass = &v
	return s
}

// SetDBInstanceIdentifier sets the DBInstanceIdentifier field's value.
func (s *RestoreDBInstanceFromDBSnapshotInput) SetDBInstanceIdentifier(v string) *RestoreDBInstanceFromDBSnapshotInput {
	s.DBInstanceIdentifier = &v
	return s
}

// SetDBName sets the DBName field's value.
func (s *RestoreDBInstanceFromDBSnapshotInput) SetDBName(v string) *RestoreDBInstanceFromDBSnapshotInput {
	s.DBName = &v
	return s
}

// SetDBSnapshotIdentifier sets the DBSnapshotIdentifier field's value.
func (s *RestoreDBInstanceFromDBSnapshotInput) SetDBSnapshotIdentifier(v string) *RestoreDBInstanceFromDBSnapshotInput {
	s.DBSnapshotIdentifier = &v
	return s
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *RestoreDBInstanceFromDBSnapshotInput) SetDBSubnetGroupName(v string) *RestoreDBInstanceFromDBSnapshotInput {
	s.DBSubnetGroupName = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *RestoreDBInstanceFromDBSnapshotInput) SetDomain(v string) *RestoreDBInstanceFromDBSnapshotInput {
	s.Domain = &v
	return s
}

// SetDomainIAMRoleName sets the DomainIAMRoleName field's value.
func (s *RestoreDBInstanceFromDBSnapshotInput) SetDomainIAMRoleName(v string) *RestoreDBInstanceFromDBSnapshotInput {
	s.DomainIAMRoleName = &v
	return s
}

// SetEnableIAMDatabaseAuthentication sets the EnableIAMDatabaseAuthentication field's value.
func (s *RestoreDBInstanceFromDBSnapshotInput) SetEnableIAMDatabaseAuthentication(v bool) *RestoreDBInstanceFromDBSnapshotInput {
	s.EnableIAMDatabaseAuthentication = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *RestoreDBInstanceFromDBSnapshotInput) SetEngine(v string) *RestoreDBInstanceFromDBSnapshotInput {
	s.Engine = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *RestoreDBInstanceFromDBSnapshotInput) SetIops(v int64) *RestoreDBInstanceFromDBSnapshotInput {
	s.Iops = &v
	return s
}

// SetLicenseModel sets the LicenseModel field's value.
func (s *RestoreDBInstanceFromDBSnapshotInput) SetLicenseModel(v string) *RestoreDBInstanceFromDBSnapshotInput {
	s.LicenseModel = &v
	return s
}

// SetMultiAZ sets the MultiAZ field's value.
func (s *RestoreDBInstanceFromDBSnapshotInput) SetMultiAZ(v bool) *RestoreDBInstanceFromDBSnapshotInput {
	s.MultiAZ = &v
	return s
}

// SetOptionGroupName sets the OptionGroupName field's value.
func (s *RestoreDBInstanceFromDBSnapshotInput) SetOptionGroupName(v string) *RestoreDBInstanceFromDBSnapshotInput {
	s.OptionGroupName = &v
	return s
}

// SetPort sets the Port field's value.
func (s *RestoreDBInstanceFromDBSnapshotInput) SetPort(v int64) *RestoreDBInstanceFromDBSnapshotInput {
	s.Port = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *RestoreDBInstanceFromDBSnapshotInput) SetPubliclyAccessible(v bool) *RestoreDBInstanceFromDBSnapshotInput {
	s.PubliclyAccessible = &v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *RestoreDBInstanceFromDBSnapshotInput) SetStorageType(v string) *RestoreDBInstanceFromDBSnapshotInput {
	s.StorageType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *RestoreDBInstanceFromDBSnapshotInput) SetTags(v []*Tag) *RestoreDBInstanceFromDBSnapshotInput {
	s.Tags = v
	return s
}

// SetTdeCredentialArn sets the TdeCredentialArn field's value.
func (s *RestoreDBInstanceFromDBSnapshotInput) SetTdeCredentialArn(v string) *RestoreDBInstanceFromDBSnapshotInput {
	s.TdeCredentialArn = &v
	return s
}

// SetTdeCredentialPassword sets the TdeCredentialPassword field's value.
func (s *RestoreDBInstanceFromDBSnapshotInput) SetTdeCredentialPassword(v string) *RestoreDBInstanceFromDBSnapshotInput {
	s.TdeCredentialPassword = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBInstanceFromDBSnapshotResult
type RestoreDBInstanceFromDBSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Contains the result of a successful invocation of the following actions:
	//
	//    * CreateDBInstance
	//
	//    * DeleteDBInstance
	//
	//    * ModifyDBInstance
	//
	//    * StopDBInstance
	//
	//    * StartDBInstance
	//
	// This data type is used as a response element in the DescribeDBInstances action.
	DBInstance *DBInstance `type:"structure"`
}

// String returns the string representation
func (s RestoreDBInstanceFromDBSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreDBInstanceFromDBSnapshotOutput) GoString() string {
	return s.String()
}

// SetDBInstance sets the DBInstance field's value.
func (s *RestoreDBInstanceFromDBSnapshotOutput) SetDBInstance(v *DBInstance) *RestoreDBInstanceFromDBSnapshotOutput {
	s.DBInstance = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/RestoreDBInstanceToPointInTimeMessage
type RestoreDBInstanceToPointInTimeInput struct {
	_ struct{} `type:"structure"`

	// Indicates that minor version upgrades will be applied automatically to the
	// DB instance during the maintenance window.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// The EC2 Availability Zone that the database instance will be created in.
	//
	// Default: A random, system-chosen Availability Zone.
	//
	// Constraint: You cannot specify the AvailabilityZone parameter if the MultiAZ
	// parameter is set to true.
	//
	// Example: us-east-1a
	AvailabilityZone *string `type:"string"`

	// True to copy all tags from the restored DB instance to snapshots of the DB
	// instance; otherwise false. The default is false.
	CopyTagsToSnapshot *bool `type:"boolean"`

	// The compute and memory capacity of the Amazon RDS DB instance.
	//
	// Valid Values: db.t1.micro | db.m1.small | db.m1.medium | db.m1.large | db.m1.xlarge
	// | db.m2.2xlarge | db.m2.4xlarge | db.m3.medium | db.m3.large | db.m3.xlarge
	// | db.m3.2xlarge | db.m4.large | db.m4.xlarge | db.m4.2xlarge | db.m4.4xlarge
	// | db.m4.10xlarge | db.r3.large | db.r3.xlarge | db.r3.2xlarge | db.r3.4xlarge
	// | db.r3.8xlarge | db.t2.micro | db.t2.small | db.t2.medium | db.t2.large
	//
	// Default: The same DBInstanceClass as the original DB instance.
	DBInstanceClass *string `type:"string"`

	// The database name for the restored DB instance.
	//
	// This parameter is not used for the MySQL or MariaDB engines.
	DBName *string `type:"string"`

	// The DB subnet group name to use for the new instance.
	//
	// Constraints: Must contain no more than 255 alphanumeric characters, periods,
	// underscores, spaces, or hyphens. Must not be default.
	//
	// Example: mySubnetgroup
	DBSubnetGroupName *string `type:"string"`

	// Specify the Active Directory Domain to restore the instance in.
	Domain *string `type:"string"`

	// Specify the name of the IAM role to be used when making API calls to the
	// Directory Service.
	DomainIAMRoleName *string `type:"string"`

	// True to enable mapping of AWS Identity and Access Management (IAM) accounts
	// to database accounts; otherwise false.
	//
	// You can enable IAM database authentication for the following database engines
	//
	//    * For MySQL 5.6, minor version 5.6.34 or higher
	//
	//    * For MySQL 5.7, minor version 5.7.16 or higher
	//
	//    * Aurora 5.6 or higher.
	//
	// Default: false
	EnableIAMDatabaseAuthentication *bool `type:"boolean"`

	// The database engine to use for the new instance.
	//
	// Default: The same as source
	//
	// Constraint: Must be compatible with the engine of the source
	//
	// Valid Values: MySQL | mariadb | oracle-se1 | oracle-se | oracle-ee | sqlserver-ee
	// | sqlserver-se | sqlserver-ex | sqlserver-web | postgres | aurora
	Engine *string `type:"string"`

	// The amount of Provisioned IOPS (input/output operations per second) to be
	// initially allocated for the DB instance.
	//
	// Constraints: Must be an integer greater than 1000.
	//
	// SQL Server
	//
	// Setting the IOPS value for the SQL Server database engine is not supported.
	Iops *int64 `type:"integer"`

	// License model information for the restored DB instance.
	//
	// Default: Same as source.
	//
	// Valid values: license-included | bring-your-own-license | general-public-license
	LicenseModel *string `type:"string"`

	// Specifies if the DB instance is a Multi-AZ deployment.
	//
	// Constraint: You cannot specify the AvailabilityZone parameter if the MultiAZ
	// parameter is set to true.
	MultiAZ *bool `type:"boolean"`

	// The name of the option group to be used for the restored DB instance.
	//
	// Permanent options, such as the TDE option for Oracle Advanced Security TDE,
	// cannot be removed from an option group, and that option group cannot be removed
	// from a DB instance once it is associated with a DB instance
	OptionGroupName *string `type:"string"`

	// The port number on which the database accepts connections.
	//
	// Constraints: Value must be 1150-65535
	//
	// Default: The same port as the original DB instance.
	Port *int64 `type:"integer"`

	// Specifies the accessibility options for the DB instance. A value of true
	// specifies an Internet-facing instance with a publicly resolvable DNS name,
	// which resolves to a public IP address. A value of false specifies an internal
	// instance with a DNS name that resolves to a private IP address.
	//
	// Default: The default behavior varies depending on whether a VPC has been
	// requested or not. The following list shows the default behavior in each case.
	//
	//    * Default VPC:true
	//
	//    * VPC:false
	//
	// If no DB subnet group has been specified as part of the request and the PubliclyAccessible
	// value has not been set, the DB instance will be publicly accessible. If a
	// specific DB subnet group has been specified as part of the request and the
	// PubliclyAccessible value has not been set, the DB instance will be private.
	PubliclyAccessible *bool `type:"boolean"`

	// The date and time to restore from.
	//
	// Valid Values: Value must be a time in Universal Coordinated Time (UTC) format
	//
	// Constraints:
	//
	//    * Must be before the latest restorable time for the DB instance
	//
	//    * Cannot be specified if UseLatestRestorableTime parameter is true
	//
	// Example: 2009-09-07T23:45:00Z
	RestoreTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The identifier of the source DB instance from which to restore.
	//
	// Constraints:
	//
	//    * Must be the identifier of an existing database instance
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	// SourceDBInstanceIdentifier is a required field
	SourceDBInstanceIdentifier *string `type:"string" required:"true"`

	// Specifies the storage type to be associated with the DB instance.
	//
	// Valid values: standard | gp2 | io1
	//
	// If you specify io1, you must also include a value for the Iops parameter.
	//
	// Default: io1 if the Iops parameter is specified; otherwise standard
	StorageType *string `type:"string"`

	// A list of tags.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	// The name of the new database instance to be created.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 alphanumeric characters or hyphens
	//
	//    * First character must be a letter
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens
	//
	// TargetDBInstanceIdentifier is a required field
	TargetDBInstanceIdentifier *string `type:"string" required:"true"`

	// The ARN from the Key Store with which to associate the instance for TDE encryption.
	TdeCredentialArn *string `type:"string"`

	// The password for the given ARN from the Key Store in order to access the
	// device.
	TdeCredentialPassword *string `type:"string"`

	// Specifies whether (true) or not (false) the DB instance is restored from
	// the latest backup time.
	//
	// Default: false
	//
	// Constraints: Cannot be specified if RestoreTime parameter is provided.
	UseLatestRestorableTime *bool `type:"boolean"`
}

// String returns the string representation
func (s RestoreDBInstanceToPointInTimeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreDBInstanceToPointInTimeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreDBInstanceToPointInTimeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreDBInstanceToPointInTimeInput"}
	if s.SourceDBInstanceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceDBInstanceIdentifier"))
	}
	if s.TargetDBInstanceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetDBInstanceIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoMinorVersionUpgrade sets the AutoMinorVersionUpgrade field's value.
func (s *RestoreDBInstanceToPointInTimeInput) SetAutoMinorVersionUpgrade(v bool) *RestoreDBInstanceToPointInTimeInput {
	s.AutoMinorVersionUpgrade = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *RestoreDBInstanceToPointInTimeInput) SetAvailabilityZone(v string) *RestoreDBInstanceToPointInTimeInput {
	s.AvailabilityZone = &v
	return s
}

// SetCopyTagsToSnapshot sets the CopyTagsToSnapshot field's value.
func (s *RestoreDBInstanceToPointInTimeInput) SetCopyTagsToSnapshot(v bool) *RestoreDBInstanceToPointInTimeInput {
	s.CopyTagsToSnapshot = &v
	return s
}

// SetDBInstanceClass sets the DBInstanceClass field's value.
func (s *RestoreDBInstanceToPointInTimeInput) SetDBInstanceClass(v string) *RestoreDBInstanceToPointInTimeInput {
	s.DBInstanceClass = &v
	return s
}

// SetDBName sets the DBName field's value.
func (s *RestoreDBInstanceToPointInTimeInput) SetDBName(v string) *RestoreDBInstanceToPointInTimeInput {
	s.DBName = &v
	return s
}

// SetDBSubnetGroupName sets the DBSubnetGroupName field's value.
func (s *RestoreDBInstanceToPointInTimeInput) SetDBSubnetGroupName(v string) *RestoreDBInstanceToPointInTimeInput {
	s.DBSubnetGroupName = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *RestoreDBInstanceToPointInTimeInput) SetDomain(v string) *RestoreDBInstanceToPointInTimeInput {
	s.Domain = &v
	return s
}

// SetDomainIAMRoleName sets the DomainIAMRoleName field's value.
func (s *RestoreDBInstanceToPointInTimeInput) SetDomainIAMRoleName(v string) *RestoreDBInstanceToPointInTimeInput {
	s.DomainIAMRoleName = &v
	return s
}

// SetEnableIAMDatabaseAuthentication sets the EnableIAMDatabaseAuthentication field's value.
func (s *RestoreDBInstanceToPointInTimeInput) SetEnableIAMDatabaseAuthentication(v bool) *RestoreDBInstanceToPointInTimeInput {
	s.EnableIAMDatabaseAuthentication = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *RestoreDBInstanceToPointInTimeInput) SetEngine(v string) *RestoreDBInstanceToPointInTimeInput {
	s.Engine = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *RestoreDBInstanceToPointInTimeInput) SetIops(v int64) *RestoreDBInstanceToPointInTimeInput {
	s.Iops = &v
	return s
}

// SetLicenseModel sets the LicenseModel field