job {
	name 'release-courierd'
	using 'TEMPLATE-autobuild'
	scm {
		git {
			remote {
				github 'release/courierd', 'ssh', 'git-aws.internal.justin.tv'
				credentials 'git-aws-read-key'
			}
			clean true
		}
	}
	steps {
		shell 'manta -v -proxy -f build.json'
		saveDeployArtifact 'release/courierd', '.manta'
	}
}

job {
	name 'release-courierd-aptly'
	parameters {
		stringParam 'GIT_COMMIT'
	}
	steps {
		downloadDeployArtifact 'release/courierd'
		uploadDeb "courierd.deb"
		uploadDirtyDeb "courierd.deb"
	}
	wrappers {
		preBuildCleanup()
		timestamps()
		credentialsBinding {
			file('AWS_CONFIG_FILE', 'aws_config')
		}
	}
}
