job {
	name 'release-ec2-net-utils'
	using 'TEMPLATE-autobuild'
	scm {
		git {
			remote {
				github 'release/ec2-net-utils', 'ssh', 'git-aws.internal.justin.tv'
				credentials 'git-aws-read-key'
			}
		}
	}
	steps {
		shell 'rm -rf .manta/'
		shell 'manta -v'
		saveDeployArtifact 'release/ec2-net-utils', '.manta'
	}
}

job {
	name 'release-ec2-net-utils-aptly'
	parameters {
		stringParam 'GIT_COMMIT'
	}
	steps {
		downloadDeployArtifact 'release/ec2-net-utils'
		uploadDeb "manta.deb"
	}
	wrappers {
		preBuildCleanup()
		timestamps()
	}
}
