// +build linux

// There are some settings that are platform specific.
package execproc

import (
	"os"
	"os/exec"
	"syscall"
)

func init() {
	prepCMD = linuxPrepCMD
}

func linuxPrepCMD(cmd *exec.Cmd) {
	// BUG(tarrant): There is a bug in the go standard library where after
	// forking but before `exec`ing the child process it will check if its
	// parent is already dead by checking if the PPID is 1. If it is then it
	// sends Pdeathsig to itself. This means if forerunner is PID 1 then its
	// children die on birth.
	//
	// Once this is filed and fixed in the stdlib we can unconditionally set
	// Pdeathsig.
	if os.Getpid() != 1 {
		cmd.SysProcAttr = &syscall.SysProcAttr{Pdeathsig: syscall.SIGKILL}
	}
}
