package execproc

import (
	"log"
	"os"
	"os/signal"
)

const (
	// I'm not really sure how big to make signalBuffer so it is getting set at
	// a random number that is bigger than the number of signals we should
	// realistically receive.
	signalBuffer = 24
)

// signalWatcher expects to be started in the background. It will start up and
// start listening for signals. Once the child process is started it will then
// start sending signals to the child process.
func signalWatcher(procCh chan *os.Process) {
	sigCh := make(chan os.Signal, signalBuffer)

	signal.Notify(sigCh)
	defer signal.Stop(sigCh)

	// TODO(tarrant 2014-12-11): We need a sync.WaitGroup here to ensure that
	// the signal notifiers are all in place before starting any child
	// processes.

	proc, ok := <-procCh
	// The child process was not started:
	if !ok {
		return
	}

	for {
		select {
		case _, ok := <-procCh:
			// Child process is done.
			if !ok {
				return
			}
		case sig := <-sigCh:
			err := proc.Signal(sig)
			if err != nil {
				// TODO: actually handle this!
				log.Fatalf("Can't send signal to child process! Err: %v", err)
			}
		}
	}
}
