job {
	name 'release-forerunner'
	using 'TEMPLATE-autobuild'
	scm {
		git {
			remote {
				github 'release/forerunner', 'ssh', 'git-aws.internal.justin.tv'
				credentials 'git-aws-read-key'
			}
		}
	}
	steps {
		shell 'rm -rf .manta/'
		shell 'manta -v -proxy'
		saveDeployArtifact 'release/forerunner', '.manta'
	}
	publishers {
		archiveJunit '.manta/junit_results.xml'
	}
}

job {
	name 'release-forerunner-aptly'
	parameters {
		stringParam 'GIT_COMMIT'
	}
	steps {
		downloadDeployArtifact 'release/forerunner'
		uploadDeb 'forerunner.deb', "precise"
	}
	wrappers {
		preBuildCleanup()
		timestamps()
	}
}
