package main

import (
	"fmt"
	"log"
	"os"

	"code.justin.tv/release/forerunner/internal/exec-proc"

	"github.com/mitchellh/cli"
)

var (
	Ui cli.Ui
)

var (
	// GitCommit is the commit set via manta.
	GitCommit = "development"
	// Version is the debian version number set by manta.
	Version = "???"
)

func version() string {
	return fmt.Sprintf(`%s (Commit: %s)`, Version, GitCommit)
}

func main() {
	log.SetPrefix("forerunner ")
	setupUi()
	mustLoadAppDir()

	c := cli.NewCLI("forerunner", version())
	c.Args = os.Args[1:]
	c.Commands = map[string]cli.CommandFactory{
		"exec": func() (cli.Command, error) {
			return &execproc.ExecCommand{
				Ui: Ui,
			}, nil
		},
	}

	exitStatus, err := c.Run()
	if err != nil {
		log.Println(err)
	}

	os.Exit(exitStatus)
}
