#!/bin/bash
# Don't `set -e` because otherwise the SIGTERM we receive may cause a child
# program (sleep) to exit -1 which causes our program to exit -1 and therefor
# our tests to fail.

trap "{ echo Pid $$ got SIGTERM 2>&1; exit 0; }" SIGTERM
trap "{ echo Pid $$ got SIGINT 2>&1; exit 1; }" SIGINT

# Used to signal watching process/human they can kill it now.
echo "Ready"

while true
do
  echo Running sleep 2>&1
  sleep 1 || true
done
