package main

import (
	"os"
	"syscall"

	"github.com/mitchellh/cli"
	"golang.org/x/crypto/ssh/terminal"
)

// loadAppDir will attempt to change directory to the APPDIR. It will error if
// it doesn't have permission to cd to APPDIR, or if APPDIR doesn't exist.
func loadAppDir() error {
	appDir := os.Getenv("APPDIR")
	if appDir == "" {
		return nil
	}

	return os.Chdir(appDir)
}

// mustLoadAppDir runs loadAppDir but exits if there is an error.
func mustLoadAppDir() {
	if err := loadAppDir(); err != nil {
		Ui.Error(err.Error())
		os.Exit(1)
	}
}

// setupUi will attempt to setup the mitchellh/cli. If stdout or stderr is a
// pipe it will use non-colored Ui. Otherwise it will print errors in red and
// info in yellow.
func setupUi() {
	basicUi := &cli.BasicUi{
		Reader:      os.Stdin,
		Writer:      os.Stdout,
		ErrorWriter: os.Stderr,
	}

	if !terminal.IsTerminal(syscall.Stdout) || !terminal.IsTerminal(syscall.Stderr) {
		Ui = basicUi
		return
	}

	Ui = &cli.ColoredUi{
		InfoColor:  cli.UiColorYellow,
		ErrorColor: cli.UiColorRed,
		Ui:         basicUi,
	}
}
