package tests

import (
	"fmt"
	"log"
	"os/exec"
	"path"
	"runtime"

	"code.justin.tv/release/gocmd"
)

const (
	// ImportPath for forerunner package
	ImportPath = "code.justin.tv/release/forerunner"
)

var builder *gocmd.GoCmd
var AppDir string

func init() {
	var err error
	_, filename, _, _ := runtime.Caller(1)
	AppDir = path.Join(path.Dir(filename), "..")

	builder, err = gocmd.NewCmd()
	if err != nil {
		log.Fatal(err)
	}

}

func setupEnv(cmd *exec.Cmd) {
	cmd.Env = []string{
		fmt.Sprintf("%s=%s", "APPDIR", AppDir),
		"ENVIRONMENT=test",
		"APP=forerunner",
		"CONSUL_API=consul.internal.justin.tv",
	}
}
