# gddo-manta

Build scripts for building https://github.com/golang/gddo

# Infrastructure
 
The terraform files for creating the godoc servers are in the [godoc folder of
release/terraform](https://git-aws.internal.justin.tv/release/terraform/tree/master/godoc).

There exists one ec2 box and an ELB to provide SSL.

There is [puppet configuration](https://git-aws.internal.justin.tv/systems/puppet/tree/master/modules/gddo) that will setup daemontools and nginx for godoc.

The nginx has a basic LDAP check to provide some protection against
unauthorized access to our code.

# Configuration
 
In order to access git-aws godoc relies upon the contents of `.gitconfig` and
`.git-credentials`.

* `~jtv/.gitconfig`:
 
```
[user]
	name = devtools
[credential]
	helper = store
```

* `~jtv/.git-credentials`:

```
http://git:<redacted-cred>@git-aws.internal.justin.tv
https://git:<redacted-cred>@git-aws.internal.justin.tv
```

You can get the needed credential from git-aws by impersonating the *devtools*
user and creating a new application token.

# Local development and testing

Find the GHE credentials, as mentioned above, and pass them into `docker-compose up` as follows:
`GIT_CREDENTIALS-<credentials> docker-compose up`

