job {
  name 'release-gddo-manta'
  using 'TEMPLATE-autobuild'
  scm {
    git {
      remote {
        github 'release/gddo-manta', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
    }
  }
  throttleConcurrentBuilds {
      maxPerNode 2
  }
  steps {
    shell 'rm -rf .manta/'
    shell 'manta -v'
    saveDeployArtifact 'release/gddo-manta', '.manta'
  }
}

job {
  name 'release-gddo-manta-aptly'
  parameters {
    stringParam 'GIT_COMMIT'
  }
  steps {
    downloadDeployArtifact 'release/gddo-manta'
    uploadDeb 'gddo.deb'
  }
  wrappers {
    preBuildCleanup()
    timestamps()
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'aws_config')
      file('ARTI_CONFIG_FILE', 'dta_arti_creds')
    }
  }
}
