# Github Enterprise Encrypted Backups to S3

To run a restore to any git-instance.

**Step 1**: SSH to the backup server under the deploy user.

**Step 2**: Run `/opt/twitch/ghe-secure-backup/current/opt/twitch/ghe-secure-backup/current/ghe-restore-backup -c $GHE_HOST` The `-c` argument will restore/clobber the configuration too, so use it only if necessary.

There is a jenkins job that restores a backup of production every weekend to the dev github instance.

## IF BAD THINGS HAPENNED AND WE HAD TO START WITH A FRESH BACKUP SERVER

**Step 1**: Download and Decrypt PGP Key from s3.

  1.  Download key from S3
To retrieve PGP priv key - `aws s3 cp --sse AES256 --region us-west-1 s3://devtools-ghe-backup/.encryptedkey/gpg_encrypted_key gpg_encrypted_key`

  2.  Decrypting the Key (must have permissions to use the encryption/decrytption key)(kms key will live in the same bucket/region as snapshots [us-west-1])
`echo "$(aws kms decrypt --ciphertext-blob fileb://gpg_encrypted_key --output text --query Plaintext --region us-west-1 | base64 --decode)" > <filepath>`

**Step 2*: Get the S3 object from the sse bucket `aws s3 cp s3://devtools-ghe-backup/<filename> . --sse`

**Step 2**: decrypt latest archived snapshot or pull from s3.
  Latest archived snapshot is located in `/mnt/ghe_secure_backup/archive/$(ghearchived.gpg)`

**Step 3**: untar the now decrypted snapshot. This will result in a file heirarchy called `mnt/`

**Step 4**: `mv /mnt/ghe_secure_backup/archive/mnt/ghe_secure_backup/data/` to `/mnt/ghe_secure_backup/` (or set `GHE_DATA_DIR` to point to that directory)

**Step 5**: Run `/opt/twitch/ghe-secure-backup/current/opt/twitch/ghe-secure-backup/current/ghe-restore-backup -c $GHE_HOST` The `-c` argument will restore/clobber the configuration too, so use it only if necessary.
