job {
    name 'release-ghe-secure-backup'
    using 'TEMPLATE-autobuild'
    scm {
        git {
            remote {
                github 'release/ghe-backup-encrypted-s3', 'ssh', 'git.xarth.tv'
                credentials 'git-aws-read-key'
            }
        }
    }
    steps {
        saveChasquiArtifact 'ghe-backup-encrypted-s3', '.', 'deployments-ghe-backup-encrypted-s3', '043714768218'
    }
}

job {
    name 'release-ghe-secure-backup-deploy-chasqui'
    using 'TEMPLATE-deploy-aws-chasqui'
    steps {
        deployChasquiArtifact 'ghe-backup-encrypted-s3', '\$ENVIRONMENT', 'deployments-ghe-backup-encrypted-s3'
    }
}

job {
    name 'release-ghe-secure-backup-upload'
    wrappers {
        sshAgent 'jtv-deploy-user'
        preBuildCleanup()
        timestamps()
    }
    triggers {
        // Should be triggered everyday at 9am UTC
        cron('0 9 * * *')
    }
    steps {
        shell 'ssh -oStrictHostKeyChecking=no -oUserKnownHostsFile=/dev/null deploy@github-backup.internal.justin.tv "cd /opt/twitch/ghe-secure-backup/current && ./ghe-backup-encrypted-s3"'
    }

    publishers {
        mailer('dta@justin.tv')
    }
}

job {
    name 'release-ghe-weekly-dev-restore'
    wrappers {
        sshAgent 'jtv-deploy-user'
        preBuildCleanup()
        timestamps()
    }
    triggers {
        // Should be triggered every Sunday at 5am UTC
        cron('0 5 * * 0')
    }
    steps {
        shell 'ssh -oStrictHostKeyChecking=no -oUserKnownHostsFile=/dev/null deploy@github-backup.internal.justin.tv "cd /opt/twitch/ghe-secure-backup/current && ./ghe-restore-backup git.dev-mcordell.dev.us-west2.justin.tv"'
    }

    publishers {
        mailer('dta@justin.tv')
    }
}
