package gocmd

import (
	"os"
	"testing"
)

func cleanup(t *testing.T, locations ...string) {
	for _, location := range locations {
		if err := os.Remove(location); err != nil {
			t.Errorf("Unable to cleanup %q: %v", location, err)
		}
	}
}

func TestBuildOnce(t *testing.T) {
	builder, err := NewCmd()
	if err != nil {
		t.Fatal(err)
	}

	loc, err := builder.Build("git.xarth.tv/release/gocmd/example")
	if err != nil {
		t.Fatal(err)
	}
	defer cleanup(t, loc)

	loc2, err := builder.Build("git.xarth.tv/release/gocmd/example")
	if err != nil {
		t.Fatal(err)
	}

	if loc != loc2 {
		t.Errorf("Building twice should return the same location; Got: %v; Want: %v", loc2, loc)
		// We only need to cleanup loc2 if it is different than loc1.
		defer cleanup(t, loc2)
	}
}
