package main

import (
	"fmt"
	"net/http"
	"os"

	"./httpjsonlogger"

	"github.com/gorilla/mux"
)

func rootHandler(w http.ResponseWriter, r *http.Request) {
	fmt.Fprintf(w, "Hello World!")
}

func main() {
	handletest := mux.NewRouter()
	handletest.HandleFunc("/", rootHandler)

	http.ListenAndServe(":8080", httpjsonlogger.JSONLoggingHandler(os.Stdout, handletest))
}
